/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.report.AnalysisOfProjectMaterialsFilterControl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AnalysisOfProjectMaterialsReportServer
extends ReportServerBase {
    private static final String BACK_QTY = "REJECTEDQTY";
    private static final String FIXED_QTY = "FIXED_QTY";
    private static final String GONGWEI = "GongWei";
    private static final String LACKS_STOCK_QTY = "LACKSSTOCKQTY";
    private static final String LF_FEED_QTY = "MATERIALFEEDINGQTY";
    private static Logger logger = Logger.getLogger((String)AnalysisOfProjectMaterialsReportServer.class.getName());
    private static final String MATERIAL_MODLE = "MATERIAL_MODEL";
    private static final String MATERIAL_NAME = "MATERIAL_NAME";
    private static final String MATERIAL_NUM = "MATERIAL_NUMBER";
    private static final String MATERIAL_PROP = "materialProp";
    private static final String MATERIAL_UNIT = "MATERIAL_UNIT";
    private static final String OPERATION_NAME = "OperationName";
    private static final String OPERATION_NUMBER = "OperationNumber";
    private static final String PICKING_DIFFERENCES = "PICKINGDIFFERENCES";
    private static final String PICKING_DIFFERENCES_RATE = "PICKINGDIFFERENCESRATE";
    private static final String PRODUCT_MODLE = "PRODUCT_MODLE";
    private static final String PRODUCT_NAME = "PRODUCT_NAME";
    private static final String PRODUCT_NUM = "PRODUCT_NUMBER";
    private static final String PRODUCT_UNIT = "PRODUCT_UNIT";
    private static final String REAL_QTY = "REAL_QTY";
    private static final String RECEIVING_QTY = "TOTALDIRECTRECEIVEQTY";
    private static final String SHOULD_ISSUED_QTY = "SHOULD_ISSUED_QTY";
    private static final String STOCK_QTY = "STOCKQTY";
    private static final String WASTE_FEED_QTY = "FEEDINGQTY";
    private long lstart = System.currentTimeMillis();
    private static final String WorkCenter_Number = "WorkCenter_Number";
    private static final String WorkCenter_Name = "WorkCenter_Name";
    private static final String StorageOrgUnit = "StorageOrgUnit";
    private static final String OperationNo = "OperationNo";
    private static final String IssueMode = "IssueMode";
    private String workShopId;
    private static final String MaterialSum = "MaterialSum";
    private static final String PurPerson = "PurPerson";
    private static final String ShortageQty = "ShortageQty";
    private static String storageOrgUnitNumber = null;
    private static String storageOrgUnitName = null;
    private String Resource_Name = "com.kingdee.eas.mm.report.EMMEMReportResource";

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)this.Resource_Name, (String)name, (Locale)ctx.getLocale());
    }

    private String createTempAnalysisTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append("PRODUCT_NUMBER nvarchar(255)");
        sql.append(",\r\nPRODUCT_NAME nvarchar(255)");
        sql.append(",\r\nPRODUCT_MODLE nvarchar(255)");
        sql.append(",\r\nPRODUCT_UNIT nvarchar(255)");
        sql.append(",\r\nMATERIAL_NUMBER nvarchar(255)");
        sql.append(",\r\nMATERIAL_NAME nvarchar(255)");
        sql.append(",\r\nMATERIAL_MODEL nvarchar(255)");
        sql.append(",\r\nMATERIAL_UNIT nvarchar(255)");
        sql.append(",\r\nFIXED_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nSHOULD_ISSUED_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nREAL_QTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nREJECTEDQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nFEEDINGQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nMATERIALFEEDINGQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nTOTALDIRECTRECEIVEQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nPICKINGDIFFERENCES NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nPICKINGDIFFERENCESRATE NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nSTOCKQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nLACKSSTOCKQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nWLBKCQTY NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\nOperationNumber nvarchar(255)");
        sql.append(",\r\nOperationName nvarchar(255)");
        sql.append(",\r\nmaterialProp nvarchar(255)");
        sql.append(",\r\nGongWei nvarchar(255)");
        sql.append(",\r\nOperationNo nvarchar(255)");
        sql.append(",\r\nWorkCenter_Number nvarchar(255)");
        sql.append(",\r\nWorkCenter_Name nvarchar(255)");
        sql.append(",\r\nIssueMode nvarchar(255)");
        sql.append(",\r\nStorageOrgUnit nvarchar(255)");
        sql.append(",\r\nPurPerson nvarchar(255)");
        sql.append(",\r\nShortageQty NUMERIC(21,8) DEFAULT 0");
        sql.append(")");
        return sql.toString();
    }

    private String getResultSql(AnalysisOfProjectMaterialsFilterControl filterControl) throws BOSException, EASBizException {
        boolean deffStatusAll;
        boolean baseStatusAll;
        this.GetStorageOrgUnit(filterControl);
        Boolean materialSumFlag = filterControl.getMaterialSum().equalsIgnoreCase("false");
        StringBuffer sql = new StringBuffer();
        StringBuffer group = new StringBuffer();
        sql.append("select * from( ");
        sql.append("select ");
        if (materialSumFlag.booleanValue()) {
            sql.append("MATERIAL.FNumber AS ").append(PRODUCT_NUM);
            group.append("MATERIAL.FNumber");
            sql.append(",MATERIAL.FName_l2 AS ").append(PRODUCT_NAME);
            group.append(",MATERIAL.FName_l2");
            sql.append(",MATERIAL.FModel AS ").append(PRODUCT_MODLE);
            group.append(",MATERIAL.FModel");
            sql.append(",BASEUNIT.FName_l2 AS ").append(PRODUCT_UNIT);
            group.append(",BASEUNIT.FName_l2");
            sql.append(",MATERIAL1.FNumber AS ").append(MATERIAL_NUM);
            group.append(",MATERIAL1.FNumber");
        } else {
            sql.append("MATERIAL1.FNumber AS ").append(MATERIAL_NUM);
            group.append("MATERIAL1.FNumber");
        }
        sql.append(",MATERIAL1.FName_l2 AS ").append(MATERIAL_NAME);
        group.append(",MATERIAL1.FName_l2");
        sql.append(",MATERIAL1.FModel AS ").append(MATERIAL_MODLE);
        group.append(",MATERIAL1.FModel");
        sql.append(",BASEUNIT1.FName_l2 AS ").append(MATERIAL_UNIT);
        group.append(",BASEUNIT1.FName_l2");
        sql.append(",SUM(isnull(STOCKS.FUnitQty,0)) AS ").append(FIXED_QTY);
        sql.append(",SUM(isnull(STOCKS.FPlannedQty,0)) AS ").append(SHOULD_ISSUED_QTY);
        sql.append(",SUM(isnull(STOCKS.FActIssueQty,0)) AS ").append(REAL_QTY);
        sql.append(",SUM(isnull(STOCKS.FRejectedQty,0)) AS ").append(BACK_QTY);
        sql.append(",SUM(isnull(STOCKS.FFeedingQty,0)) AS ").append(WASTE_FEED_QTY);
        sql.append(",SUM(isnull(STOCKS.FMaterialFeedingQty,0)) AS ").append(LF_FEED_QTY);
        sql.append(",SUM(isnull(STOCKS.FTotalDirectReceiveQty,0)) AS ").append(RECEIVING_QTY);
        String diffPickingSql = "isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)";
        sql.append(",SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(") AS ").append(PICKING_DIFFERENCES);
        sql.append(",round(case SUM(STOCKS.FPlannedQty) when 0 then 0 ");
        sql.append(" else SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(")/SUM(STOCKS.FPlannedQty) ");
        sql.append(" end,6) AS ").append(PICKING_DIFFERENCES_RATE);
        sql.append(",MAX(inventory.").append(STOCK_QTY).append(") AS ").append(STOCK_QTY);
        sql.append(",SUM(");
        sql.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
        sql.append(")-MAX(inventory.").append(STOCK_QTY).append(") AS ").append(LACKS_STOCK_QTY);
        sql.append(" ,MAX(wlbinventory.WLBKCQTY) as WLBKCQTY");
        if (materialSumFlag.booleanValue()) {
            sql.append(" ,operation.fnumber As ").append(OPERATION_NUMBER);
            sql.append(" ,operation.fname_l2 As ").append(OPERATION_NAME);
        }
        sql.append(" ,(case bomentry.Fmaterialprop when 10010 then '" + this.getString(this.getContext(), "EM_GHJ") + "' when 10020 then '" + this.getString(this.getContext(), "EM_XNJ") + "'  when 10030 then '" + this.getString(this.getContext(), "EM_ZZJ") + "'  when 10040 then '" + this.getString(this.getContext(), "EM_WGJ") + "'  when 10050 then '" + this.getString(this.getContext(), "EM_WWJ") + "'   else '" + this.getString(this.getContext(), "EM_QT") + "'  end ) As ").append(MATERIAL_PROP);
        if (materialSumFlag.booleanValue()) {
            sql.append(" ,Null As ").append(GONGWEI);
            sql.append(" ,TECHNICS.Foperationno As ").append(OperationNo);
            sql.append(" ,Workcenter.Fnumber As ").append(WorkCenter_Number);
            sql.append(" ,Workcenter.Fname_l2 As ").append(WorkCenter_Name);
            sql.append(" ,(case STOCKS.FIssueMode when 11010 then '" + this.getString(this.getContext(), "EM_SCLL") + "' when 11030 then '" + this.getString(this.getContext(), "EM_KB") + "' when 11050 then '" + this.getString(this.getContext(), "EM_ZS") + "' when 11040 then '" + this.getString(this.getContext(), "EM_BLL") + "' end) As ").append(IssueMode);
        }
        sql.append(" ,Storage.Fname_l2 As ").append(StorageOrgUnit);
        sql.append(" ,mt.personName As ").append(PurPerson);
        this.getContext().getLocale();
        String shortageQty = " ,case when Storage.Fname_" + LocaleUtils.getLocaleString((Locale)this.getContext().getLocale()) + " = '" + storageOrgUnitName + "' then  SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0))  else SUM(isnull(STOCKS.FPlannedQty, 0)) -SUM(isnull(STOCKS.FActIssueQty, 0))-MAX(isnull(wlbinventory.WLBKCQTY,0)) - MAX(isnull(inventory.STOCKQTY,0)) end";
        sql.append(shortageQty);
        sql.append(" AS ").append(ShortageQty);
        if (materialSumFlag.booleanValue()) {
            group.append(",operation.fnumber");
            group.append(",operation.fname_l2");
        }
        group.append(",bomentry.Fmaterialprop");
        if (materialSumFlag.booleanValue()) {
            group.append(",TECHNICS.Foperationno");
            group.append(",Workcenter.Fnumber");
            group.append(",Workcenter.Fname_l2");
            group.append(",STOCKS.FIssueMode");
        }
        group.append(",Storage.Fname_l2");
        group.append(",mt.personName");
        sql.append(" FROM T_MM_ManufactureOrder AS MANUFACTUREORDER");
        if (materialSumFlag.booleanValue()) {
            sql.append(" INNER JOIN T_BD_MeasureUnit AS BASEUNIT");
            sql.append(" ON MANUFACTUREORDER.FBaseUnitID = BASEUNIT.FID");
            sql.append(" INNER JOIN T_BD_Material AS MATERIAL");
            sql.append(" ON MANUFACTUREORDER.FMaterialID = MATERIAL.FID");
        }
        sql.append(" INNER JOIN T_MM_MFTOrderStock AS STOCKS");
        sql.append(" ON MANUFACTUREORDER.FID = STOCKS.FParentID");
        sql.append(" INNER JOIN T_BD_MeasureUnit AS BASEUNIT1");
        sql.append(" ON STOCKS.FUnitID = BASEUNIT1.FID");
        sql.append(" INNER JOIN T_BD_Material AS MATERIAL1");
        sql.append(" ON STOCKS.FMaterialID = MATERIAL1.FID");
        if (materialSumFlag.booleanValue()) {
            sql.append(" INNER JOIN t_mm_mftordertechnics AS TECHNICS");
            sql.append(" ON STOCKS.fparentid = TECHNICS.FParentID and STOCKS.foperationno = TECHNICS.foperationno ");
            sql.append(" Left outer JOIN t_mm_operation AS operation");
            sql.append(" ON TECHNICS.foperationid = operation.fid ");
        }
        sql.append(" Left outer JOIN t_mm_bomentry AS bomentry");
        sql.append(" ON STOCKS.fbomentryid = bomentry.fid ");
        if (materialSumFlag.booleanValue()) {
            sql.append(" INNER JOIN T_Mm_Workcenter AS Workcenter");
            sql.append(" ON TECHNICS.Fworkcenterid = Workcenter.FID");
        }
        sql.append(" INNER JOIN T_ORG_Storage AS Storage");
        sql.append(" ON STOCKS.FStorageOrgUnitID = Storage.FID");
        sql.append(" left join(");
        sql.append(" select APPOINTPURORGUNIT.fnumber,PURPERSON.Fid,PURPERSON.Fname_l2 personName,PURCHASING.FMaterialID");
        sql.append(" from T_BD_Person PURPERSON");
        sql.append(" inner join T_BD_MaterialPurchasing PURCHASING");
        sql.append(" on PURCHASING.FPurPerson = PURPERSON.FID");
        sql.append(" INNER JOIN T_ORG_Purchase AS APPOINTPURORGUNIT");
        sql.append(" ON PURCHASING.FAppointPurOrgUnit = APPOINTPURORGUNIT.FID");
        sql.append(" where 1=1");
        sql.append("  ) mt on mt.FMaterialID=MATERIAL1.FID");
        if (storageOrgUnitNumber != null) {
            sql.append(" and mt.fnumber ='" + storageOrgUnitNumber + "'");
        } else {
            sql.append(" and mt.fnumber=Storage.fnumber ");
        }
        StringBuffer inventorySql = new StringBuffer("select ");
        inventorySql.append("TI.FMaterialID AS FMaterialID");
        inventorySql.append(",SUM(TI.FCurStoreQty) AS ").append(STOCK_QTY);
        inventorySql.append(" from T_IM_Inventory TI ");
        StringBuffer inventoryWhere = new StringBuffer(" where 1=1");
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            inventoryWhere.append(" and TI.FStorageOrgUnitID in (");
            inventoryWhere.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            inventoryWhere.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            inventorySql.append(" LEFT JOIN T_BD_Material AS TM ON TI.FMaterialID = TM.FID ");
            inventoryWhere.append(" and TM.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        inventorySql.append(inventoryWhere.toString());
        inventorySql.append(" group by TI.FMaterialID");
        StringBuffer wlbsql = new StringBuffer("select ");
        wlbsql.append("TI.FStorageOrgUnitID AS FStorageOrgUnitID");
        wlbsql.append(",TI.FMaterialID AS FMaterialID");
        wlbsql.append(",SUM(TI.FCurStoreQty) AS ").append("WLBKCQTY");
        wlbsql.append(" from T_IM_Inventory TI  ");
        StringBuffer wlbsqlWhere = new StringBuffer(" where 1=1 ");
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            wlbsql.append(" LEFT JOIN T_BD_Material AS TM ON TI.FMaterialID = TM.FID ");
            wlbsqlWhere.append(" and TM.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        wlbsql.append(wlbsqlWhere.toString());
        wlbsql.append(" group by TI.FStorageOrgUnitID,TI.FMaterialID");
        sql.append(" left join (").append(inventorySql.toString()).append(") inventory");
        sql.append(" on STOCKS.FMaterialID = inventory.FMaterialID ");
        sql.append(" left join (").append(wlbsql.toString()).append(") wlbinventory");
        sql.append(" on stocks.fstorageOrgUnitID=wlbinventory.FStorageOrgUnitID  and STOCKS.FMaterialID = wlbinventory.FMaterialID ");
        StringBuffer where = new StringBuffer(" where 1=1 ");
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            where.append(" and MANUFACTUREORDER.FStorageOrgUnitID in (");
            where.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            where.append(")");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (filterControl.getBizDate() != null) {
            where.append(" and MANUFACTUREORDER.FBizDate >= {ts'").append(sdf.format(filterControl.getBizDate())).append("'}");
        }
        if (filterControl.getBizDate2() != null) {
            where.append(" and MANUFACTUREORDER.FBizDate <= {ts'").append(sdf.format(filterControl.getBizDate2())).append("'}");
        }
        if (!StringUtils.isEmpty((String)filterControl.getProductNum())) {
            where.append(" and MATERIAL.FNumber = '").append(filterControl.getProductNum()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterailNum())) {
            where.append(" and MATERIAL1.FNumber = '").append(filterControl.getMaterailNum()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getProjectNum())) {
            where.append(" and MANUFACTUREORDER.FProjectID in (");
            where.append("select FID from T_MM_Project where FNumber = '").append(filterControl.getProjectNum()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getTrackNum())) {
            where.append(" and MANUFACTUREORDER.FTrackID in (");
            where.append("select FID from T_MM_TrackNumber where FNumber = '").append(filterControl.getTrackNum()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getZhujihua())) {
            where.append(" and MANUFACTUREORDER.FMpsId in (");
            where.append("select FID from CT_PS_MasterProductionSchedule where FNumber in (").append(filterControl.getZhujihua()).append(")");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getWorkShop())) {
            String workShopNumStr = filterControl.getWorkShop();
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select wc.fid from T_Mm_Workcenter wc left join T_ORG_Storage tos on wc.fstorageorgunitid = tos.fid where wc.fnumber='" + workShopNumStr + "' and tos.fnumber='" + filterControl.getStorageOrgUnitNum() + "'"));
                while (rs.next()) {
                    this.workShopId = rs.getString("fid");
                }
                where.append(" and TECHNICS.fworkcenterid in (");
                where.append("(Select fid from T_Mm_Workcenter where T_Mm_Workcenter.fparentwcid='").append(this.workShopId).append("')");
                where.append(")");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.workShopId = null;
        }
        if (!StringUtils.isEmpty((String)filterControl.getOperaNo())) {
            where.append(" and TECHNICS.foperationno like '%").append(filterControl.getOperaNo()).append("%'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getIssueMode()) && !filterControl.getIssueMode().equals("-1")) {
            where.append(" and STOCKS.FIssueMode = '").append(filterControl.getIssueMode()).append("'");
        }
        if (!StringUtils.isEmpty((String)filterControl.getWLBKC())) {
            where.append(" and STOCKS.FStorageOrgUnitID in(");
            where.append("select FID from T_ORG_Storage where FNumber = '").append(filterControl.getWLBKC()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getPurPerson())) {
            where.append(" and mt.FID in(");
            where.append("select fid from T_BD_Person where fnumber = '").append(filterControl.getPurPerson()).append("'");
            where.append(")");
        }
        if (!StringUtils.isEmpty((String)filterControl.getMaterialProp()) && !filterControl.getMaterialProp().equals("-1")) {
            where.append(" and bomentry.Fmaterialprop = '").append(filterControl.getMaterialProp()).append("'");
        }
        StringBuffer baseStatusWhere = new StringBuffer();
        boolean bl = baseStatusAll = filterControl.isAuditedStatus() && filterControl.isCompleteStatus() && filterControl.isCloseStatus() && filterControl.isFinClosedStatus() && filterControl.isReleasedStatus() || !filterControl.isAuditedStatus() && !filterControl.isCompleteStatus() && !filterControl.isCloseStatus() && !filterControl.isFinClosedStatus() && !filterControl.isReleasedStatus();
        if (baseStatusAll || filterControl.isAuditedStatus()) {
            baseStatusWhere.append(",").append(4);
        }
        if (baseStatusAll || filterControl.isCloseStatus()) {
            baseStatusWhere.append(",").append(7);
        }
        if (baseStatusAll || filterControl.isCompleteStatus()) {
            baseStatusWhere.append(",").append(8);
        }
        if (baseStatusAll || filterControl.isFinClosedStatus()) {
            baseStatusWhere.append(",").append(11);
        }
        if (baseStatusAll || filterControl.isReleasedStatus()) {
            baseStatusWhere.append(",").append(5);
        }
        if (baseStatusWhere.length() > 0) {
            where.append(" and MANUFACTUREORDER.FBaseStatus in(");
            where.append(baseStatusWhere.substring(1));
            where.append(")");
        }
        StringBuffer diffStatusWhere = new StringBuffer();
        boolean bl2 = deffStatusAll = filterControl.isFullPicking() && filterControl.isLessPicking() && filterControl.isMuchPicking() || !filterControl.isFullPicking() && !filterControl.isLessPicking() && !filterControl.isMuchPicking();
        if (!deffStatusAll && filterControl.isFullPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") = 0");
        }
        if (!deffStatusAll && filterControl.isLessPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") > 0");
        }
        if (!deffStatusAll && filterControl.isMuchPicking()) {
            diffStatusWhere.append(" or (");
            diffStatusWhere.append("isnull(STOCKS.FPlannedQty,0)+isnull(STOCKS.FRejectedQty,0)-isnull(STOCKS.FActIssueQty,0)-isnull(STOCKS.FFeedingQty,0)-isnull(STOCKS.FMaterialFeedingQty,0)");
            diffStatusWhere.append(") < 0");
        }
        if (diffStatusWhere.length() > 0) {
            where.append(" and (1 != 1 ");
            where.append(diffStatusWhere.toString());
            where.append(")");
        }
        sql.append(where.toString());
        if (group.length() > 0) {
            sql.append(" group by ").append(group.toString());
        }
        sql.append(" ) newTable");
        boolean shortage = filterControl.IsShortage();
        if (shortage) {
            sql.append(" where ShortageQty>0");
        }
        return sql.toString();
    }

    private void insertDataToTempAnalysisTable(String tempTableName, AnalysisOfProjectMaterialsFilterControl filterControl) throws BOSException, EASBizException {
        Boolean materialSumFlag = filterControl.getMaterialSum().equalsIgnoreCase("false");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into " + tempTableName + " ");
        if (materialSumFlag.booleanValue()) {
            insertSql.append("(PRODUCT_NUMBER");
            insertSql.append(",PRODUCT_NAME");
            insertSql.append(",PRODUCT_MODLE");
            insertSql.append(",PRODUCT_UNIT");
            insertSql.append(",MATERIAL_NUMBER");
        } else {
            insertSql.append("(MATERIAL_NUMBER");
        }
        insertSql.append(",MATERIAL_NAME");
        insertSql.append(",MATERIAL_MODEL");
        insertSql.append(",MATERIAL_UNIT");
        insertSql.append(",FIXED_QTY");
        insertSql.append(",SHOULD_ISSUED_QTY");
        insertSql.append(",REAL_QTY");
        insertSql.append(",REJECTEDQTY");
        insertSql.append(",FEEDINGQTY");
        insertSql.append(",MATERIALFEEDINGQTY");
        insertSql.append(",TOTALDIRECTRECEIVEQTY");
        insertSql.append(",PICKINGDIFFERENCES");
        insertSql.append(",PICKINGDIFFERENCESRATE");
        insertSql.append(",STOCKQTY");
        insertSql.append(",LACKSSTOCKQTY");
        insertSql.append(",WLBKCQTY");
        if (materialSumFlag.booleanValue()) {
            insertSql.append(",OperationNumber");
            insertSql.append(",OperationName");
        }
        insertSql.append(",materialProp");
        if (materialSumFlag.booleanValue()) {
            insertSql.append(",GongWei");
            insertSql.append(",OperationNo");
            insertSql.append(",WorkCenter_Number");
            insertSql.append(",WorkCenter_Name");
            insertSql.append(",IssueMode");
        }
        insertSql.append(",StorageOrgUnit");
        insertSql.append(",PurPerson");
        insertSql.append(",ShortageQty");
        insertSql.append(") ");
        insertSql.append(this.getResultSql(filterControl));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void lstop(String info) {
        long lstop = System.currentTimeMillis();
        logger.info((Object)("########### " + info + " : " + (lstop - this.lstart)));
    }

    private long restartTimeIndices() {
        this.lstart = System.currentTimeMillis();
        return this.lstart;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempAnalysisTable;
        AnalysisOfProjectMaterialsFilterControl filterControl = new AnalysisOfProjectMaterialsFilterControl(filter);
        this.restartTimeIndices();
        String tempTableSql = this.createTempAnalysisTableSql();
        try {
            tempAnalysisTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        this.lstop("createTempTable 'tempAnalysisTable'");
        String indexColumns = "PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME";
        try {
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempAnalysisTable, "PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME", false, false);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable index error : index columns is [PRODUCT_NUMBER,PRODUCT_NAME,MATERIAL_NUMBER,MATERIAL_NAME]", (Throwable)e);
        }
        this.lstop("create tempAnalysisTable's index");
        this.insertDataToTempAnalysisTable(tempAnalysisTable, filterControl);
        this.lstop("insert tempAnalysisTable data");
        return tempAnalysisTable;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = super.buildReportFormatConditions(reportID);
        return reportFormatConditions;
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.setTotalRowCount(0);
        AnalysisOfProjectMaterialsFilterControl filterControl = new AnalysisOfProjectMaterialsFilterControl(rptparams);
        String resultSql = this.getResultSql(filterControl);
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(PRODUCT_NUM, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0000", (Locale)this.getContext().getLocale())).setWidth(140);
            reportHeader.addChild(PRODUCT_NAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0001", (Locale)this.getContext().getLocale())).setWidth(140);
        }
        reportHeader.addChild(MATERIAL_NUM, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0002", (Locale)this.getContext().getLocale())).setWidth(140);
        reportHeader.addChild(MATERIAL_NAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0003", (Locale)this.getContext().getLocale()));
        reportHeader.addChild(MATERIAL_MODLE, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0004", (Locale)this.getContext().getLocale())).setWidth(160);
        reportHeader.addChild(MATERIAL_UNIT, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0005", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(2);
        reportHeader.addChild(SHOULD_ISSUED_QTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0006", (Locale)this.getContext().getLocale())).setAlign(3);
        reportHeader.addChild(REAL_QTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0007", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(3);
        reportHeader.addChild(PICKING_DIFFERENCES, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0008", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(3);
        reportHeader.addChild(PICKING_DIFFERENCES_RATE, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0009", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(3);
        reportHeader.addChild(StorageOrgUnit, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0010", (Locale)this.getContext().getLocale())).setWidth(160);
        reportHeader.addChild("WLBKCQTY", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0011", (Locale)this.getContext().getLocale())).setAlign(3).setWidth(180);
        reportHeader.addChild(STOCK_QTY, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0012", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(3);
        reportHeader.addChild(ShortageQty, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0013", (Locale)this.getContext().getLocale())).setWidth(160).setAlign(3);
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(OperationNo, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0014", (Locale)this.getContext().getLocale())).setWidth(100);
            reportHeader.addChild(WorkCenter_Number, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0015", (Locale)this.getContext().getLocale())).setWidth(160);
            reportHeader.addChild(WorkCenter_Name, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0016", (Locale)this.getContext().getLocale())).setWidth(160);
            reportHeader.addChild(IssueMode, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0017", (Locale)this.getContext().getLocale())).setWidth(160);
            reportHeader.addChild(OPERATION_NUMBER, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0018", (Locale)this.getContext().getLocale())).setWidth(160);
            reportHeader.addChild(OPERATION_NAME, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0019", (Locale)this.getContext().getLocale())).setWidth(160);
        }
        reportHeader.addChild(MATERIAL_PROP, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0020", (Locale)this.getContext().getLocale())).setWidth(160);
        if (filter.getObject("materialSum") != null && filter.getObject("materialSum").equals("false")) {
            reportHeader.addChild(GONGWEI, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0021", (Locale)this.getContext().getLocale())).setWidth(160);
        }
        reportHeader.addChild(PurPerson, EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0022", (Locale)this.getContext().getLocale())).setWidth(160);
        return reportHeader;
    }

    private void GetStorageOrgUnit(AnalysisOfProjectMaterialsFilterControl filterControl) {
        if (!StringUtils.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
            StringBuilder sql = new StringBuilder();
            sql.append(" select FID,Fname_").append(LocaleUtils.getLocaleString((Locale)this.getContext().getLocale())).append(" Fname from T_ORG_Storage where FNumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                while (rs.next()) {
                    String storageOrgUnitID = rs.getString("FID");
                    storageOrgUnitName = rs.getString("Fname");
                    this.GetParam(storageOrgUnitID);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void GetParam(String FStorageOrgUnitID) throws EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select PI.FValue_L2 FValue From T_BAS_PARAM P");
        sql.append(" Inner Join T_BAS_PARAMItem PI ");
        sql.append(" On PI.FKeyID=P.FID");
        sql.append(" Where FORGUnitID = '" + FStorageOrgUnitID + "' and P.FNumber='AOMES'");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
            while (rowset.next()) {
                String number = rowset.getString("FValue");
                if (number != null) {
                    // empty if block
                }
                sql.append("Select fid from T_ORG_Storage");
                sql.append(" where fnumber = '" + number + "'");
                IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
                while (rs.next()) {
                    storageOrgUnitNumber = rs.getString("fid");
                }
                if (rs.size() >= 1) continue;
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0023", (Locale)this.getContext().getLocale())));
            }
            if (rowset.size() >= 1) return;
        }
        catch (BOSException e) {
            e.printStackTrace();
            return;
        }
        catch (EASBizException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0024", (Locale)this.getContext().getLocale()) + e.getMessage()));
        }
        catch (SQLException e) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.report.EMMEMReportResource", (String)"0EMMREPORT-0024", (Locale)this.getContext().getLocale()) + e.getMessage()));
        }
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles titles = new ReportTitles();
        AnalysisOfProjectMaterialsFilterControl filterControl = new AnalysisOfProjectMaterialsFilterControl(rptparams);
        filterControl.setReportTitles(titles);
        return titles;
    }
}

