/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.report.MachineProcessingWorkshopStartedPlanControl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class MachineProcessingWorkshopStartedPlanServer
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)MachineProcessingWorkshopStartedPlanServer.class.getName());
    public static final String PROJECT_NUMBER = "PROJECT_NUMBER";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String ORDER_NUMBER = "ORDER_NUMBER";
    public static final String PRODUCT_NAME = "PRODUCT_NAME";
    public static final String PRODUCT_NUMBER = "PRODUCT_NUMBER";
    public static final String PRODUCT_MODEL = "PRODUCT_MODEL";
    public static final String CAR_QTY = "CAR_QTY";
    public static final String DELIVERY_QTY = "DELIVERY_QTY";
    public static final String TRACKNUMBER_BEGIN = "TRACKNUMBER_BEGIN";
    public static final String TRACKNUMBER_END = "TRACKNUMBER_END";
    public static final String TRACKNUMBER_CONTRAST = "TRACKNUMBER_contrast";
    public static final String PLAN_BEGIN_DATE = "PLAN_BEGIN_DATE";
    public static final String PLAN_END_DATE = "PLAN_END_DATE";
    public static final String OPERATION = "OPERATION";
    private final String locatName = this.getContext().getLocale().toString();
    private long maxSeq = 0L;

    private String getResourceInfo(String resourceName) {
        return MachineProcessingWorkshopStartedPlanControl.getResourceInfo(resourceName);
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        this.initOperatioin();
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild(PROJECT_NUMBER, this.getResourceInfo(PROJECT_NUMBER));
        reportHeader.addChild(PROJECT_NAME, this.getResourceInfo(PROJECT_NAME));
        reportHeader.addChild(ORDER_NUMBER, this.getResourceInfo(ORDER_NUMBER));
        reportHeader.addChild(PRODUCT_NAME, this.getResourceInfo(PRODUCT_NAME));
        reportHeader.addChild(PRODUCT_NUMBER, this.getResourceInfo(PRODUCT_NUMBER));
        reportHeader.addChild(PRODUCT_MODEL, this.getResourceInfo(PRODUCT_MODEL));
        reportHeader.addChild(CAR_QTY, this.getResourceInfo(CAR_QTY));
        reportHeader.addChild(DELIVERY_QTY, this.getResourceInfo(DELIVERY_QTY));
        reportHeader.addChild(TRACKNUMBER_BEGIN, this.getResourceInfo(TRACKNUMBER_BEGIN));
        reportHeader.addChild(TRACKNUMBER_END, this.getResourceInfo(TRACKNUMBER_END));
        reportHeader.addChild(TRACKNUMBER_CONTRAST, this.getResourceInfo(TRACKNUMBER_CONTRAST));
        reportHeader.addChild(PLAN_BEGIN_DATE, this.getResourceInfo(PLAN_BEGIN_DATE));
        reportHeader.addChild(PLAN_END_DATE, this.getResourceInfo(PLAN_END_DATE));
        String operationHeader = this.getResourceInfo(OPERATION);
        if (this.maxSeq > 0L) {
            StringBuilder headerKey = new StringBuilder();
            int i = 1;
            while ((long)i <= this.maxSeq) {
                headerKey.setLength(0);
                headerKey.append(OPERATION).append(i);
                if (i != 1) {
                    operationHeader = "";
                }
                reportHeader.addChild(headerKey.toString(), operationHeader);
                ++i;
            }
        } else {
            reportHeader.addChild(OPERATION, operationHeader);
        }
        return reportHeader;
    }

    protected IRowSet getReportData(String arg0, RptParams rptparams) throws Exception {
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        MachineProcessingWorkshopStartedPlanControl filterControl = new MachineProcessingWorkshopStartedPlanControl(rptparams);
        String resultSql = this.getResultSql(filterControl);
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected ReportTitles getReportTitles(String arg0, RptParams params) throws BaseException {
        ReportTitles titles = new ReportTitles();
        MachineProcessingWorkshopStartedPlanControl.setReportTitles(titles, params);
        return titles;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTable;
        MachineProcessingWorkshopStartedPlanControl filterControl = new MachineProcessingWorkshopStartedPlanControl(filter);
        String tempTableSql = this.createTempTableSql();
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        String indexColumns = "PRODUCT_NUMBER,PRODUCT_NAME,PROJECT_NUMBER,PROJECT_NAME,ORDER_NUMBER";
        try {
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tempTable, indexColumns, false, false);
        }
        catch (Exception e) {
            logger.error((Object)("create tempTable index error : index columns is [" + indexColumns + "]"), (Throwable)e);
        }
        this.insertDataToTempTable(tempTable, filterControl);
        return tempTable;
    }

    private String createTempTableSql() {
        this.initOperatioin();
        StringBuffer sql = new StringBuffer();
        sql.append("create table DataNew (");
        sql.append(PROJECT_NUMBER).append(" nvarchar(255)");
        sql.append(",\r\n").append(PROJECT_NAME).append(" nvarchar(255)");
        sql.append(",\r\n").append(ORDER_NUMBER).append(" nvarchar(255)");
        sql.append(",\r\n").append(PRODUCT_NAME).append(" nvarchar(255)");
        sql.append(",\r\n").append(PRODUCT_NUMBER).append(" nvarchar(255)");
        sql.append(",\r\n").append(PRODUCT_MODEL).append(" nvarchar(255)");
        sql.append(",\r\n").append(CAR_QTY).append(" NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n").append(DELIVERY_QTY).append(" NUMERIC(21,8) DEFAULT 0");
        sql.append(",\r\n").append(TRACKNUMBER_BEGIN).append(" nvarchar(255)");
        sql.append(",\r\n").append(TRACKNUMBER_END).append(" nvarchar(255)");
        sql.append(",\r\n").append(TRACKNUMBER_CONTRAST).append(" nvarchar(255)");
        sql.append(",\r\n").append(PLAN_BEGIN_DATE).append(" nvarchar(255)");
        sql.append(",\r\n").append(PLAN_END_DATE).append(" nvarchar(255)");
        if (this.maxSeq > 0L) {
            int i = 1;
            while ((long)i <= this.maxSeq) {
                sql.append(",\r\n").append(OPERATION).append(i).append(" nvarchar(255)");
                ++i;
            }
        } else {
            sql.append(",\r\n").append(OPERATION).append(" nvarchar(255)");
        }
        sql.append(")");
        return sql.toString();
    }

    private void insertDataToTempTable(String tempTable, MachineProcessingWorkshopStartedPlanControl filterControl) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTable);
        insertSql.append(" (").append(PROJECT_NUMBER);
        insertSql.append(",").append(PROJECT_NAME);
        insertSql.append(",").append(ORDER_NUMBER);
        insertSql.append(",").append(PRODUCT_NAME);
        insertSql.append(",").append(PRODUCT_NUMBER);
        insertSql.append(",").append(PRODUCT_MODEL);
        insertSql.append(",").append(CAR_QTY);
        insertSql.append(",").append(DELIVERY_QTY);
        insertSql.append(",").append(TRACKNUMBER_BEGIN);
        insertSql.append(",").append(TRACKNUMBER_END);
        insertSql.append(",").append(TRACKNUMBER_CONTRAST);
        insertSql.append(",").append(PLAN_BEGIN_DATE);
        insertSql.append(",").append(PLAN_END_DATE);
        if (this.maxSeq > 0L) {
            int i = 1;
            while ((long)i <= this.maxSeq) {
                insertSql.append(",").append(OPERATION).append(i);
                ++i;
            }
        }
        insertSql.append(") ");
        insertSql.append(" (").append(this.getResultSql(filterControl)).append(")");
        try {
            DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("insert data to template table is error [" + insertSql.toString() + "]"), (Throwable)e);
        }
    }

    private String getResultSql(MachineProcessingWorkshopStartedPlanControl filterControl) {
        this.initOperatioin();
        StringBuilder sql = new StringBuilder();
        StringBuilder from = new StringBuilder();
        StringBuilder where = new StringBuilder();
        sql.append("select ");
        sql.append("project.fnumber as ").append(PROJECT_NUMBER);
        sql.append(",project.fname_").append(this.locatName).append(" as ").append(PROJECT_NAME);
        sql.append(",MANUFACTUREORDER.fnumber as ").append(ORDER_NUMBER);
        sql.append(",product.fname_").append(this.locatName).append(" as ").append(PRODUCT_NAME);
        sql.append(",product.fnumber as ").append(PRODUCT_NUMBER);
        sql.append(",product.fmodel as ").append(PRODUCT_MODEL);
        sql.append(",0 as ").append(CAR_QTY);
        sql.append(",MANUFACTUREORDER.FQty as ").append(DELIVERY_QTY);
        sql.append(",trackBegin.FNumber as ").append(TRACKNUMBER_BEGIN);
        sql.append(",trackEnd.FNumber as ").append(TRACKNUMBER_END);
        sql.append(",trackContrast.FNumber as ").append(TRACKNUMBER_CONTRAST);
        sql.append(",YEAR(MANUFACTUREORDER.fplanBeginDate)||'/'||MONTH(MANUFACTUREORDER.FplanBeginDate)||'/'||DAYOFMONTH(MANUFACTUREORDER.FplanBeginDate) as ").append(PLAN_BEGIN_DATE);
        sql.append(",YEAR(MANUFACTUREORDER.fplanEndDate)||'/'||MONTH(MANUFACTUREORDER.fplanEndDate)||'/'||DAYOFMONTH(MANUFACTUREORDER.fplanEndDate) as ").append(PLAN_END_DATE);
        from.append(" from T_MM_ManufactureOrder MANUFACTUREORDER");
        from.append(" LEFT JOIN T_MM_Project project").append(" ON MANUFACTUREORDER.FProjectID = project.fid");
        from.append(" LEFT JOIN T_BD_Material product").append(" ON MANUFACTUREORDER.FMaterialID = product.FID");
        from.append(" LEFT JOIN T_MM_TrackNumber trackBegin").append(" ON MANUFACTUREORDER.FTrackID = trackBegin.FID");
        from.append(" LEFT JOIN T_MM_TrackNumber trackEnd").append(" ON MANUFACTUREORDER.CFENDTRACKNUMBERID = trackEnd.FID");
        from.append(" LEFT JOIN T_EMM_TrackNumberAssociation trackAssociation").append(" ON trackBegin.FID = trackAssociation.FEleTrackNumberID");
        from.append(" LEFT JOIN T_MM_TrackNumber trackContrast").append(" ON trackAssociation.FUniTrackNumberID = trackContrast.FID");
        where.append(" where MANUFACTUREORDER.FBaseStatus in (").append(4).append(") ");
        if (filterControl != null) {
            if (!StringUtil.isEmpty((String)filterControl.getStorageOrgUnitNum())) {
                from.append(" LEFT JOIN T_ORG_Storage storageOrg").append(" ON MANUFACTUREORDER.FStorageOrgUnitID = storageOrg.FID");
                where.append(" and storageOrg.fnumber = '").append(filterControl.getStorageOrgUnitNum()).append("'");
            }
            if (!StringUtil.isEmpty((String)filterControl.getAdminOrgUnitNum())) {
                from.append(" LEFT JOIN T_ORG_Admin adminOrg").append(" ON MANUFACTUREORDER.FAdminOrgUnitID = adminOrg.FID");
                where.append(" and adminOrg.fnumber = '").append(filterControl.getAdminOrgUnitNum()).append("'");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            if (filterControl.getPlanBeginDateBegin() != null) {
                where.append(" and MANUFACTUREORDER.fplanBeginDate > {ts'").append(sdf.format(filterControl.getPlanBeginDateBegin())).append("'}");
            }
            if (filterControl.getPlanBeginDateEnd() != null) {
                where.append(" and MANUFACTUREORDER.fplanBeginDate <= {ts'").append(sdf.format(filterControl.getPlanBeginDateEnd())).append("'}");
            }
        }
        if (this.maxSeq > 0L) {
            String operationFID = "fid";
            String operationName = "operationName";
            int i = 1;
            while ((long)i <= this.maxSeq) {
                sql.append(",operation_").append(i).append(".").append(operationName).append(" as ").append(OPERATION).append(i);
                from.append(" LEFT JOIN (");
                from.append(" select technics.fparentid as ").append(operationFID);
                from.append(" ,ope.fname_").append(this.locatName).append(" as ").append(operationName);
                from.append(" from T_MM_MFTOrderTechnics technics");
                from.append(" LEFT JOIN T_MM_Operation ope").append(" ON technics.foperationid = ope.fid");
                from.append(" where technics.fseq = ").append(i);
                from.append(") operation_").append(i).append(" ON MANUFACTUREORDER.fid = operation_").append(i).append(".").append(operationFID);
                ++i;
            }
        }
        sql.append(from.toString()).append(where.toString());
        sql.append(" order by MANUFACTUREORDER.fplanBeginDate");
        return sql.toString();
    }

    private void initOperatioin() {
        IRowSet set;
        if (this.maxSeq > 0L) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select max(technics.fseq) maxSeq");
        sql.append(" from T_MM_MFTOrderTechnics technics");
        sql.append(" LEFT JOIN T_MM_ManufactureOrder MANUFACTUREORDER").append(" ON technics.fparentid = MANUFACTUREORDER.fid");
        sql.append(" where MANUFACTUREORDER.FBaseStatus in (").append(4).append(") ");
        try {
            set = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("init operation is error [" + sql.toString() + "]"), (Throwable)e);
            return;
        }
        try {
            if (set.next()) {
                this.maxSeq = Long.parseLong(set.getString("maxSeq"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
    }
}

