/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.clientUtil.CAStringUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.sfc.ProdorderCompleteEntryInfo;
import com.kingdee.eas.mm.sfc.ProdorderCompleteInfo;
import com.kingdee.eas.mm.sfc.QualityStatusEnum;
import com.kingdee.eas.mm.sfc.app.AbstractProdorderCompleteControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryCollection;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillEntryInfo;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProdorderCompleteControllerBean
extends AbstractProdorderCompleteControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.ProdorderCompleteControllerBean");
    private String RESURL = "com.kingdee.eas.mm.sfc.EMMEMSfcResource";

    private void checkQty(Context ctx, ProdorderCompleteInfo billInfo) throws EASBizException {
        StringBuffer err = new StringBuffer();
        for (int i = 0; i < billInfo.getEntry().size(); ++i) {
            BigDecimal yieldAmount;
            ProdorderCompleteEntryInfo entryInfo = billInfo.getEntry().get(i);
            BigDecimal reportAmount = entryInfo.getReportAmount() != null ? entryInfo.getReportAmount() : BigDecimal.ZERO;
            BigDecimal qualifiedAmount = entryInfo.getQualifiedAmount() != null ? entryInfo.getQualifiedAmount() : BigDecimal.ZERO;
            BigDecimal repairAmount = entryInfo.getRepairAmount() != null ? entryInfo.getRepairAmount() : BigDecimal.ZERO;
            BigDecimal scrapAmount = entryInfo.getScrapAmount() != null ? entryInfo.getScrapAmount() : BigDecimal.ZERO;
            BigDecimal workScrapAmount = entryInfo.getWorkScrapAmount() != null ? entryInfo.getWorkScrapAmount() : BigDecimal.ZERO;
            BigDecimal materialScrapAm = entryInfo.getMaterialScrapAm() != null ? entryInfo.getMaterialScrapAm() : BigDecimal.ZERO;
            BigDecimal bigDecimal = yieldAmount = entryInfo.getYieldAmount() != null ? entryInfo.getYieldAmount() : BigDecimal.ZERO;
            if (qualifiedAmount.compareTo(BigDecimal.ZERO) == 0) {
                BigDecimal totalQty = repairAmount.add(scrapAmount).add(workScrapAmount).add(materialScrapAm).add(yieldAmount);
                if (totalQty.compareTo(reportAmount) == 0) continue;
                err.append("" + (i + 1) + ",");
                continue;
            }
            if (qualifiedAmount.compareTo(reportAmount) == 0 && repairAmount.compareTo(BigDecimal.ZERO) == 0 && scrapAmount.compareTo(BigDecimal.ZERO) == 0 && workScrapAmount.compareTo(BigDecimal.ZERO) == 0 && materialScrapAm.compareTo(BigDecimal.ZERO) == 0 && yieldAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            err.append("" + (i + 1) + ",");
        }
        if (err.length() > 0) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"HGSLBDYHBSL_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{err.toString()});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
    }

    @Override
    protected String _batchPass(Context ctx, Set ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0003", (Locale)ctx.getLocale());
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ids.size() > 100) {
            return EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0004", (Locale)ctx.getLocale());
        }
        String idstr = CAStringUtils.toSqlString((Collection)ids);
        StringBuffer upbillSql = new StringBuffer();
        upbillSql.append(" /*dialect*/ update T_SFC_PRODORDERCOMPLETE a set a.fqualitystate='2',a.fbasestatus=4 ").append("\n");
        upbillSql.append(" ,a.FAuditTime= sysdate,a.FAuditorID = '").append(userId).append("' ").append("\n");
        upbillSql.append(" where fid in (").append(idstr).append(")");
        DbUtil.execute((Context)ctx, (String)upbillSql.toString());
        StringBuffer upentrySql = new StringBuffer();
        upentrySql.append(" /*dialect*/ update T_SFC_PRODORDERCOMPLETEENTRY b set b.Fbasestatus=4,b.fqualifiedamount=b.freportamount ").append("\n");
        upentrySql.append(" where Fparentid in (").append(idstr).append(")");
        DbUtil.execute((Context)ctx, (String)upentrySql.toString());
        StringBuffer upmfhnicsSql = new StringBuffer();
        upmfhnicsSql.setLength(0);
        upmfhnicsSql.append(" Update t_mm_mftordertechnics ").append("\n");
        upmfhnicsSql.append(" set fpassqty = fqty,fbasestatus = 14,fpassbaseqty = fqty ").append("\n");
        upmfhnicsSql.append(" Where fid in (select fmfcordtechid from T_SFC_PRODORDERCOMPLETEENTRY where Fparentid in (").append(idstr).append("))");
        DbUtil.execute((Context)ctx, (String)upmfhnicsSql.toString());
        upmfhnicsSql.setLength(0);
        upmfhnicsSql.append(" Update t_mm_mftordertechnicsex ").append("\n");
        upmfhnicsSql.append(" set FQualityInspectionTime = getdate(),FQualityInspectioner='" + userId + "' ").append("\n");
        upmfhnicsSql.append(" Where fpid in (select fmfcordtechid from T_SFC_PRODORDERCOMPLETEENTRY where Fparentid in (").append(idstr).append("))");
        DbUtil.execute((Context)ctx, (String)upmfhnicsSql.toString());
        StringBuffer upmforderSql = new StringBuffer();
        upmforderSql.append("  /*dialect*/ update t_mm_manufactureorder A set  fbasestatus = 8,fpassqty = fqty,fpassbaseqty = fqty   ").append("\n");
        upmforderSql.append("  where fid in (  ").append("\n");
        upmforderSql.append("  select fparentid from t_mm_mftordertechnics  ").append("\n");
        upmforderSql.append("      where fid in (select fmfcordtechid from T_SFC_PRODORDERCOMPLETEENTRY where Fparentid  in (").append(idstr).append(")").append("\n");
        upmforderSql.append("  ) ) ").append("\n");
        upmforderSql.append("  and not exists ( select 1 from t_mm_mftordertechnics where fparentid=A.fid and fbasestatus<>14)  ").append("\n");
        DbUtil.execute((Context)ctx, (String)upmforderSql.toString());
        this.passtomanufactureinbill(ctx, ids);
        String strInfo = ResourceBase.getString((String)this.RESURL, (String)"ZJCGXT_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{ids.size()});
        return strInfo;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProdorderCompleteInfo info = (ProdorderCompleteInfo)model;
        this.checkQty(ctx, info);
        if (info.getQualityState().getValue() != "1") {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0005", (Locale)ctx.getLocale())));
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        boolean isPass = false;
        for (int i = 0; i < info.getEntry().size(); ++i) {
            ProdorderCompleteEntryInfo entryInfo = info.getEntry().get(i);
            if (entryInfo.getReportAmount() == null || BigDecimal.ZERO.compareTo(entryInfo.getReportAmount()) == 0 || entryInfo.getQualifiedAmount() == null || entryInfo.getQualifiedAmount().compareTo(entryInfo.getReportAmount()) != 0) continue;
            isPass = true;
        }
        if (!isPass && (info.getFremark() == null || "".equals(info.getFremark().trim()))) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0006", (Locale)ctx.getLocale())));
        }
        QualityStatusEnum temp = isPass ? QualityStatusEnum.PASS : QualityStatusEnum.UNPASS;
        info.setQualityState(temp);
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        super.update(ctx, pk, info);
        this.reWriteManuOrder(ctx, info);
        if (isPass) {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(pk.toString());
            this.passtomanufactureinbill(ctx, new HashSet(ids));
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkQty(ctx, (ProdorderCompleteInfo)model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkQty(ctx, (ProdorderCompleteInfo)model);
        return super._submit(ctx, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
    }

    protected String passtomanufactureinbill(Context ctx, Set ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0003", (Locale)ctx.getLocale());
        }
        String idstr = CAStringUtils.toSqlString((Collection)ids);
        StringBuffer sql = new StringBuffer();
        BigDecimal fqty = new BigDecimal(0);
        int ibotpfind = 0;
        BOTMappingInfo botInfo = null;
        IBTPManager btp = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult result = null;
        ManufactureOrderInfo manufactureOrderInfo = null;
        WarehouseInfo warehouseInfo = null;
        sql.append(" Select distinct pch.fid as fid, pch.Fmergeid as fmergerid  \n");
        sql.append(" From T_SFC_PRODORDERCOMPLETE pch \n");
        sql.append(" Where pch.fid in (").append(idstr).append(")\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                String fmergerid = rs.getString("fmergerid");
                String freportid = rs.getString("fid");
                sql.delete(0, sql.length());
                sql.append(" Select pcd.Fqualifiedamount  as fqty \n");
                sql.append(" From T_SFC_PRODORDERCOMPLETEentry pcd \n");
                sql.append(" Where pcd.fparentid = '").append(freportid).append("' and pcd.Fqualifiedamount > 0 and rownum = 1  \n");
                IRowSet rsqty = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                fqty = new BigDecimal(0);
                if (rsqty.next()) {
                    fqty = rsqty.getBigDecimal("fqty");
                }
                if (fqty.compareTo(new BigDecimal(0)) <= 0) continue;
                sql.delete(0, sql.length());
                sql.append(" Select distinct h.fid as fid, \n");
                sql.append(" minv.fdefaultwarehouseid as fwarehouseid, \n");
                sql.append(" h.Fstorageorgunitid as forgid, \n");
                sql.append(" (Select a.FToUnitID  from T_ORG_UnitRelation a INNER JOIN T_ORG_TypeRelation  b ON a.FTypeRelationID = b.FID where a.FFromUnitID = h.Fstorageorgunitid and b.FFromType = 4 and  b.FToType =1 and rownum = 1) as fcompanyorgid \n");
                sql.append(" From T_MM_ManufactureOrder h \n");
                sql.append(" Inner join T_MM_MFTOrderTechnics d on h.fid = d.fparentid \n");
                sql.append(" left outer join t_bd_materialinventory minv on h.fmaterialid = minv.fmaterialid and h.fstorageorgunitid = minv.forgunit \n");
                sql.append(" Left Outer Join T_MM_StandardRooting On T_MM_StandardRooting.fid = h.Froutingid \n");
                sql.append(" Left Outer Join T_MM_MaterialRWP On T_MM_MaterialRWP.Fparentid = T_MM_StandardRooting.Fmaterialrootingid  \n");
                sql.append(" And T_MM_MaterialRWP.Foperationid = d.foperationid \n");
                sql.append(" Where d.Fmergeid = '").append(fmergerid).append("'");
                sql.append(" and T_MM_MaterialRWP.Fispickingpoint = 1  \n");
                IRowSet rspo = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rspo.next()) {
                    String fmanuorderid = rspo.getString("fid");
                    String fwarehouseid = rspo.getString("fwarehouseid");
                    String fcompanyorgid = rspo.getString("fcompanyorgid");
                    rspo.getString("forgid");
                    if (ibotpfind == 0) {
                        IBOTMapping botFac = BOTMappingFactory.getLocalInstance((Context)ctx);
                        String fgznumber = "eE7o1tUFTzyy1rUlrhAQn8znrtQ=".equals(fcompanyorgid) ? "MM_DMES003copycopy" : "MM_DMES003copy";
                        BOTMappingCollection botCol = botFac.getBOTMappingCollection("where name='" + fgznumber + "' and extRule.isEffected=1  ");
                        if (botCol.size() == 1) {
                            botInfo = botCol.get(0);
                        } else {
                            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"MYZDBMWXZHGZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{ids.size()});
                            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
                        }
                    }
                    ++ibotpfind;
                    StorageOrgUnitInfo orginfo = null;
                    orginfo = "ZzYHbHF1SCicBQvENGh+1cznrtQ=".equals(fcompanyorgid) ? StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK("4ueEzZGDSYuVfAD/hLHijsznrtQ=")) : StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK("forgid"));
                    warehouseInfo = null;
                    if (fwarehouseid != null && !"".equals(fwarehouseid)) {
                        warehouseInfo = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(fwarehouseid));
                    }
                    CoreBillBaseCollection coreBillBaseCol = new CoreBillBaseCollection();
                    manufactureOrderInfo = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(fmanuorderid));
                    coreBillBaseCol.add((CoreBillBaseInfo)manufactureOrderInfo);
                    result = btp.transform(coreBillBaseCol, botInfo);
                    BOTRelationCollection relations = result.getBOTRelationCollection();
                    IObjectCollection bills = result.getBills();
                    for (int a = 0; a < bills.size(); ++a) {
                        ManufactureRecBillInfo bill = (ManufactureRecBillInfo)bills.getObject(a);
                        bill.setDescription(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0007", (Locale)ctx.getLocale()));
                        bill.setStorageOrgUnit(orginfo);
                        ManufactureRecBillEntryCollection entrycol = bill.getEntry();
                        for (int b = 0; b < entrycol.size(); ++b) {
                            ManufactureRecBillEntryInfo entryinfo = entrycol.get(b);
                            entryinfo.setQty(fqty);
                            entryinfo.setBaseQty(fqty);
                            entryinfo.setStorageOrgUnit(orginfo);
                            if (warehouseInfo == null) continue;
                            entryinfo.setWarehouse(warehouseInfo);
                            entryinfo.setLocation(null);
                        }
                        btp.saveRelations((CoreBillBaseInfo)bill, relations);
                    }
                }
            }
        }
        catch (SQLException e1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0008", (Locale)ctx.getLocale()) + e1.getMessage()));
        }
        return "ok";
    }

    protected void reWriteManuOrder(Context ctx, ProdorderCompleteInfo pcInfo) throws BOSException, EASBizException {
        String billId = pcInfo.getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select 1 from T_SFC_ProdorderComplete bill inner join T_SFC_ProdorderCompleteEntry entry on bill.fid=entry.fparentid  where (bill.fmergeid is null or entry.FMfcOrdTechID is null) and bill.fid = ? ", (Object[])new Object[]{billId});
        if (rs != null && rs.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0009", (Locale)ctx.getLocale())));
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_MFTOrderTechnics mo ");
        sql.append(" set (");
        sql.append(" fpassqty,fpassbaseqty");
        sql.append(",fscrapqty,fscrapbaseqty");
        sql.append(",ftotalManufacturescrapqty,ftotalManufacturescrapbaseqty");
        sql.append(",ftotalmaterialscrapqty,ftotalmaterialscrapbaseqty");
        sql.append(",frepairqty,frepairbaseqty");
        sql.append(",fconcessionqty,fconcessionbaseqty)");
        sql.append(" = (");
        sql.append("select ");
        sql.append("nvl(sum(entry.fqualifiedAmount),0),nvl(sum(entry.fqualifiedAmount),0)");
        sql.append(",nvl(sum(entry.fscrapAmount),0),nvl(sum(entry.fscrapAmount),0)");
        sql.append(",nvl(sum(entry.fworkScrapAmount),0),nvl(sum(entry.fworkScrapAmount),0)");
        sql.append(",nvl(sum(entry.fmaterialScrapAm),0),nvl(sum(entry.fmaterialScrapAm),0)");
        sql.append(",nvl(sum(entry.frepairAmount),0),nvl(sum(entry.frepairAmount),0)");
        sql.append(",nvl(sum(entry.fyieldAmount),0),nvl(sum(entry.fyieldAmount),0)");
        sql.append(" from  T_SFC_ProdorderCompleteEntry entry ");
        sql.append(" where entry.fparentid = ? and entry.FMfcOrdTechID=mo.fid group by entry.FMfcOrdTechID");
        sql.append(")");
        sql.append(" where mo.fid in (select FMfcOrdTechID from T_SFC_ProdorderCompleteEntry where fparentid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId, billId});
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_MFTOrderTechnics mo set fbasestatus=14");
        sql.append(" where mo.FfinishedQty=fpassqty and mo.fid in( select FMfcOrdTechID from T_SFC_ProdorderCompleteEntry where fparentid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_MFTOrderTechnicsEx mote set FQualityInspectionTime = sysdate,FQualityInspectioner=?");
        sql.append(" where 1=1 and mote.fpid in( select pce.FMfcOrdTechID from T_SFC_ProdorderCompleteEntry pce inner join T_MM_MFTOrderTechnics mot on mot.fid=pce.FMfcOrdTechID where mot.FfinishedQty=mot.fpassqty and pce.fparentid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, billId});
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_MFTOrderTechnics mo set fbasestatus=26");
        sql.append(" where mo.FfinishedQty<>fpassqty and mo.fid in( select FMfcOrdTechID from T_SFC_ProdorderCompleteEntry where fparentid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_MFTOrderTechnicsEx mote set FQualityInspectionTime = sysdate,FQualityInspectioner=?");
        sql.append(" where 1=1 and mote.fpid in( select pce.FMfcOrdTechID from T_SFC_ProdorderCompleteEntry pce inner join T_MM_MFTOrderTechnics mot on mot.fid=pce.FMfcOrdTechID where mot.FfinishedQty<>mot.fpassqty and pce.fparentid = ?)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, billId});
        sql.setLength(0);
        sql.append("/*dialect*/ update T_MM_ManufactureOrder bill set fbasestatus = 8 ");
        sql.append(" where bill.fid in (select fparentid from T_MM_MFTOrderTechnics mo1 where mo1.fid in (");
        sql.append(" select pcEntry.FMfcOrdTechID from T_SFC_ProdorderCompleteEntry pcEntry where pcEntry.fparentid=?))");
        sql.append(" and not exists (select 1 from T_MM_MFTOrderTechnics mo2 where mo2.fbasestatus<>14 and mo2.fparentid=bill.fid)");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billId});
    }
}

