/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mm.sfc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeCollection;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeFactory;
import com.kingdee.eas.mm.sfc.CompletionReportAmountTimeInfo;
import com.kingdee.eas.mm.sfc.CompletionReportInfo;
import com.kingdee.eas.mm.sfc.QualityControlStatusEnum;
import com.kingdee.eas.mm.sfc.app.AbstractQualityControlFacadeControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class QualityControlFacadeControllerBean
extends AbstractQualityControlFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.mm.sfc.app.QualityControlFacadeControllerBean");

    @Override
    protected void _checks(Context ctx, IObjectValue completionReport) throws BOSException {
        if (completionReport == null) {
            return;
        }
        CoreBaseCollection completionReports = new CoreBaseCollection();
        completionReports.addObject(completionReport);
        this._checksAll(ctx, (IObjectCollection)completionReports);
    }

    @Override
    protected void _checksAll(Context ctx, IObjectCollection completionReports) throws BOSException {
        if (completionReports == null || completionReports.size() == 0) {
            return;
        }
        BigDecimal zero = new BigDecimal("0.00");
        CoreBaseCollection updateCR = new CoreBaseCollection();
        CoreBaseCollection updateAT = new CoreBaseCollection();
        ArrayList<String> sqlList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < completionReports.size(); ++i) {
            List<String> backSql;
            CompletionReportInfo info;
            IObjectValue completionReport = completionReports.getObject(i);
            if (completionReport == null || !CompletionReportInfo.class.isInstance(completionReport) || (info = (CompletionReportInfo)completionReport).getId() == null) continue;
            boolean qcs = true;
            CompletionReportAmountTimeCollection atc = info.getAmountTime();
            for (int j = 0; j < atc.size(); ++j) {
                CompletionReportAmountTimeInfo at = atc.get(j);
                BigDecimal report = at.getReportAmount() != null ? at.getReportAmount() : zero;
                BigDecimal qualified = at.getQualifiedAmount() != null ? at.getQualifiedAmount() : zero;
                BigDecimal yield = at.getYieldAmount() != null ? at.getYieldAmount() : zero;
                BigDecimal ws = at.getWorkScrapAmount() != null ? at.getWorkScrapAmount() : zero;
                BigDecimal ms = at.getMaterialScrapAm() != null ? at.getMaterialScrapAm() : zero;
                BigDecimal repair = at.getRepairAmount() != null ? at.getRepairAmount() : zero;
                BigDecimal total = qualified.add(yield).add(ws).add(ms).add(repair);
                int c = report.compareTo(total);
                if (c < 0) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0010", (Locale)ctx.getLocale()));
                }
                if (c == 0) {
                    at.put("qualityControlStatus", (Object)QualityControlStatusEnum.COMPLETED);
                } else {
                    qcs = false;
                    at.put("qualityControlStatus", (Object)QualityControlStatusEnum.QUARANTINE);
                }
                updateAT.add((CoreBaseInfo)at);
            }
            sql.setLength(0);
            sql.append("update T_MM_CompletionReport ");
            sql.append(" set cfqualityControlStatus = ");
            if (qcs) {
                info.put("qualityControlStatus", (Object)QualityControlStatusEnum.COMPLETED);
                sql.append(2);
            } else {
                info.put("qualityControlStatus", (Object)QualityControlStatusEnum.QUARANTINE);
                sql.append(1);
            }
            sql.append(" where fid = '").append(info.getId().toString()).append("'");
            if (sql.length() > 0) {
                sqlList.add(sql.toString());
            }
            updateCR.add((CoreBaseInfo)info);
            if (info.getBaseStatus() != BillBaseStatusEnum.AUDITED || (backSql = this.backWriteManufactureOrder(ctx, info)) == null || backSql.size() <= 0) continue;
            sqlList.addAll(backSql);
        }
        try {
            if (updateCR.size() > 0) {
                // empty if block
            }
            if (updateAT.size() > 0) {
                CompletionReportAmountTimeFactory.getLocalInstance((Context)ctx).update(updateAT);
            }
        }
        catch (EASBizException e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.mm.sfc.EMMEMSfcResource", (String)"0EMMSFC-0011", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (sqlList.size() > 0) {
            // empty if block
        }
    }

    private List<String> backWriteManufactureOrder(Context ctx, CompletionReportInfo info) {
        String id = info.getId().toString();
        ArrayList<String> backList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("update T_MM_MFTOrderTechnics mo ");
        sql.append(" set (");
        sql.append("fpassqty");
        sql.append(",fscrapqty");
        sql.append(",ftotalManufacturescrapqty");
        sql.append(",ftotalmaterialscrapqty");
        sql.append(",frepairqty");
        sql.append(",fconcessionqty)");
        sql.append(" = (");
        sql.append("select ");
        sql.append("sum(at.fQualifiedAmount)");
        sql.append(",sum(at.fScrapAmount)");
        sql.append(",sum(at.fWorkScrapAmount)");
        sql.append(",sum(at.fMaterialScrapAm)");
        sql.append(",sum(at.fRepairAmount)");
        sql.append(",sum(at.fYieldAmount)");
        sql.append(" from T_MM_CompletionReport cr left join T_MM_CompletionRAT at on at.fparentid = cr.fid");
        sql.append(" where cr.fprocessid = mo.fid and cr.fbasestatus = ").append(4);
        sql.append(")");
        sql.append(" where mo.fid in (select fprocessid from T_MM_CompletionReport where fid = '").append(id).append("')");
        backList.add(sql.toString());
        sql.setLength(0);
        sql.append("update T_MM_DisTaskDispatchEntry mo ");
        sql.append(" set (");
        sql.append("fpassqty");
        sql.append(",fworkscrapqty");
        sql.append(",fmaterialscrapqty");
        sql.append(",frepReportqty");
        sql.append(",fconcessionqty)");
        sql.append(" = (");
        sql.append("select ");
        sql.append("sum(at.fQualifiedAmount)");
        sql.append(",sum(at.fWorkScrapAmount)");
        sql.append(",sum(at.fMaterialScrapAm)");
        sql.append(",sum(at.fRepairAmount)");
        sql.append(",sum(at.fYieldAmount)");
        sql.append(" from T_MM_CompletionReport cr left join T_MM_CompletionRAT at on at.fparentid = cr.fid");
        sql.append(" where cr.fdispWorkProcessid = mo.fid  and cr.fbasestatus = ").append(4);
        sql.append(")");
        sql.append(" where mo.fid in (select fdispWorkProcessid from T_MM_CompletionReport where fid = '").append(id).append("')");
        backList.add(sql.toString());
        sql.setLength(0);
        sql.append("update T_MM_MFTOrderTechnics mo ");
        sql.append(" set (");
        sql.append("fpassqty");
        sql.append(",fscrapqty");
        sql.append(",ftotalManufacturescrapqty");
        sql.append(",ftotalmaterialscrapqty");
        sql.append(",frepairqty");
        sql.append(",fconcessionqty)");
        sql.append(" = (");
        sql.append("select ");
        sql.append("sum(fpassqty)");
        sql.append(",sum(fworkscrapqty) + sum(fmaterialscrapqty)");
        sql.append(",sum(fworkscrapqty)");
        sql.append(",sum(fmaterialscrapqty)");
        sql.append(",sum(frepReportqty)");
        sql.append(",sum(fconcessionqty)");
        sql.append(" from T_MM_DisTaskDispatchEntry ");
        sql.append(" where fmanufactureOrderid = mo.fparentid and foperationNumber = mo.foperationNo and foperationid = mo.foperationid and frowStatus = ").append(20);
        sql.append(")");
        sql.append(" where mo.fparentid||';'||mo.foperationNo||';'||mo.foperationid in (");
        sql.append(" select dis.fmanufactureOrderid||';'||dis.foperationNumber||';'||dis.foperationid ");
        sql.append(" from T_MM_DisTaskDispatchEntry dis left join T_MM_CompletionReport cr on cr.fdispWorkProcessid = dis.fid ");
        sql.append(" where cr.fid = '").append(id).append("'");
        sql.append(")");
        backList.add(sql.toString());
        return backList;
    }
}

