/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ws.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.ws.app.AbstractWSCommonFacadeControllerBean;
import com.kingdee.eas.ws.util.WSUtil;
import java.util.List;
import java.util.Map;

public class WSCommonFacadeControllerBean
extends AbstractWSCommonFacadeControllerBean {
    private static final long serialVersionUID = 4194397908449627184L;

    @Override
    protected void _genBOTRelation(Context ctx, Map params) throws BOSException, EASBizException {
        if (ctx == null || WSUtil.isEmptyMap(params)) {
            return;
        }
        List sourceIDList = WSUtil.getMapListData(params, "SourceIDList");
        String sourceTable = WSUtil.getMapStringData(params, "SourceTable");
        String sourceBOSType = WSUtil.getMapStringData(params, "SourceBOSType");
        List destIDList = WSUtil.getMapListData(params, "DestIDList");
        String destTable = WSUtil.getMapStringData(params, "DestTable");
        String destBOSType = WSUtil.getMapStringData(params, "DestBOSType");
        if (WSUtil.isEmptyString(sourceBOSType) || WSUtil.isEmptyString(destBOSType) || WSUtil.isEmptyString(destTable) || WSUtil.isEmptyList(destIDList)) {
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userID = userInfo == null ? null : (userInfo.getId() == null ? null : userInfo.getId().toString());
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append("Insert Into T_BOT_Relation(\r\n");
        sql.append("FID,\r\n");
        sql.append("FSRCEntityID,\r\n");
        sql.append("FDESTEntityID,\r\n");
        sql.append("FSRCObjectID,\r\n");
        sql.append("FDESTObjectID,\r\n");
        sql.append("FDate,\r\n");
        sql.append("FOperatorID,\r\n");
        sql.append("FIsEffected,\r\n");
        sql.append("FBOTMappingID,\r\n");
        sql.append("FType\r\n");
        sql.append(")\r\n");
        sql.append("Select\r\n");
        sql.append("NewBOSID('").append(new BOTRelationInfo().getBOSType().toString()).append("'),\r\n");
        sql.append("'").append(sourceBOSType).append("',\r\n");
        sql.append("'").append(destBOSType).append("',\r\n");
        sql.append("D.FSourceBillID,\r\n");
        sql.append("D.FID,\r\n");
        sql.append("CURDate(),\r\n");
        if (WSUtil.isEmptyString(userID)) {
            sql.append("Null,\r\n");
        } else {
            sql.append("'").append(userID).append("',\r\n");
        }
        sql.append("1,\r\n");
        sql.append("Null,\r\n");
        sql.append("0\r\n");
        sql.append("From ").append(destTable).append(" D\r\n");
        if (!WSUtil.isEmptyString(sourceTable)) {
            sql.append("Inner Join ").append(sourceTable).append(" S On S.FID=D.FSourceBillID\r\n");
        }
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And D.FID In (\r\n");
        sql.append(SQLUtil.arrayToString((Object[])destIDList.toArray())).append("\r\n");
        sql.append(")\r\n");
        if (!WSUtil.isEmptyList(sourceIDList)) {
            sql.append("And D.FSourceBillID In (\r\n");
            sql.append(SQLUtil.arrayToString((Object[])sourceIDList.toArray())).append("\r\n");
            sql.append(")\r\n");
        }
        sql.append("And (Not Exists(\r\n");
        sql.append("Select\r\n");
        sql.append("1\r\n");
        sql.append("From T_BOT_Relation BOTP\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        sql.append("And BOTP.FSRCObjectID=D.FSourceBillID\r\n");
        sql.append("And BOTP.FDESTObjectID=D.FID\r\n");
        sql.append(")\r\n");
        sql.append(")\r\n");
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _genNumber(Context ctx, IObjectValue objectValue, String orgUnitID) throws BOSException, EASBizException {
        String billNumber;
        if (ctx == null || objectValue == null || WSUtil.isEmptyString(orgUnitID)) {
            return;
        }
        CodingRuleInfo ruleInfo = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule(objectValue, orgUnitID);
        String string = billNumber = ruleInfo == null ? null : CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber(objectValue, ruleInfo);
        if (WSUtil.isEmptyString(billNumber)) {
            String id = WSUtil.getObjectValueStringData(objectValue, "id");
            StringBuilder newBillNumber = new StringBuilder();
            newBillNumber.setLength(0);
            newBillNumber.append("AutoNumberFromBTP_");
            if (WSUtil.isEmptyString(id)) {
                newBillNumber.append(BOSUuid.create((BOSObjectType)objectValue.getBOSType()).toString());
            } else {
                newBillNumber.append(id.toString());
            }
            objectValue.setString("number", newBillNumber.toString());
        } else {
            objectValue.setString("number", billNumber);
        }
    }

    @Override
    protected void _releaseTempTable(Context ctx, List tempTableList) throws BOSException, EASBizException {
        if (ctx == null || WSUtil.isEmptyList(tempTableList)) {
            return;
        }
        for (int index = 0; index < tempTableList.size(); ++index) {
            String tempTableName;
            String string = tempTableName = tempTableList.get(index) == null ? null : tempTableList.get(index).toString();
            if (WSUtil.isEmptyString(tempTableName)) continue;
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTableName);
        }
    }
}

