/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.clientUtil.ThrowUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.BomEntryFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.zjbom.IProcessBomChangeBill;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeReqFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeReqInfo;
import com.kingdee.eas.zjbom.TypeOfChangeEnum;
import com.kingdee.eas.zjbom.app.AbstractBomChangeAuditFacadeControllerBean;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BomChangeAuditFacadeControllerBean
extends AbstractBomChangeAuditFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.BomChangeAuditFacadeControllerBean");

    @Override
    protected void _procReqAudit(Context ctx, List parmList) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        if (parmList.size() > 0) {
            for (int i = 0; i < parmList.size(); ++i) {
                String id = parmList.get(i).toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("Entry.*"));
                sic.add(new SelectorItemInfo("storageOrgUnit.*"));
                sic.add(new SelectorItemInfo("parentPts.*"));
                sic.add(new SelectorItemInfo("projectNo.*"));
                sic.add(new SelectorItemInfo("trackNumberStart.*"));
                sic.add(new SelectorItemInfo("trackNumberEnd.*"));
                sic.add(new SelectorItemInfo("suppliesOrgUnitEAS.*"));
                sic.add(new SelectorItemInfo("leadInOrgUnitEAS.*"));
                sic.add(new SelectorItemInfo("Entry.pts.*"));
                sic.add(new SelectorItemInfo("Entry.processBom.*"));
                ProcessBomChangeReqInfo procBomChangeReqInfo = ProcessBomChangeReqFactory.getLocalInstance(ctx).getProcessBomChangeReqInfo((IObjectPK)new ObjectUuidPK(id), sic);
                BomBotpUtil.createBillByBOTP(ctx, procBomChangeReqInfo, BomBotpUtil.getBOTP(ctx, "MM_PBCR001"));
                procBomChangeReqInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                coll.add((CoreBaseInfo)procBomChangeReqInfo);
            }
        }
        ProcessBomChangeReqFactory.getLocalInstance(ctx).update(coll);
    }

    @Override
    protected void _PBomChangeAudit(Context ctx, List parmList) throws BOSException, EASBizException {
        String idStr = BomUtil.getIdsStr(parmList, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0013", (Locale)ctx.getLocale()));
        CoreBaseCollection changeBillCol = new CoreBaseCollection();
        CoreBaseCollection processBomCol = new CoreBaseCollection();
        CoreBaseCollection bomColl = new CoreBaseCollection();
        CoreBaseCollection bomEntryColl = new CoreBaseCollection();
        IProcessBomChangeBill ipb = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("pts.*"));
        sic.add(new SelectorItemInfo("pts.baseUint.*"));
        sic.add(new SelectorItemInfo("parentPts.*"));
        sic.add(new SelectorItemInfo("projectNo.*"));
        sic.add(new SelectorItemInfo("trackNumberStart.*"));
        sic.add(new SelectorItemInfo("trackNumberEnd.*"));
        sic.add(new SelectorItemInfo("flowSplitUser.*"));
        sic.add(new SelectorItemInfo("materialSplitUser.*"));
        sic.add(new SelectorItemInfo("suppliesOrgUnitEAS.*"));
        sic.add(new SelectorItemInfo("leadInOrgUnitEAS.*"));
        sic.add(new SelectorItemInfo("processBom.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.content.*"));
        sic.add(new SelectorItemInfo("entrys.content.processBom.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        ProcessBomChangeBillCollection pbcCol = ipb.getProcessBomChangeBillCollection(evi);
        int size = pbcCol.size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < pbcCol.size(); ++i) {
            ProcessBomChangeBillInfo changeBill = pbcCol.get(i);
            ProcessBomBillInfo processBom = changeBill.getProcessBom();
            if (processBom == null) {
                processBom = this.addProcessBom(ctx, changeBill);
            } else {
                this.updateProcessBom(ctx, processBom, changeBill);
                if (processBom.isIsImport()) {
                    this.updateBom(ctx, processBom, changeBill, bomColl, bomEntryColl);
                }
            }
            processBomCol.add((CoreBaseInfo)processBom);
            changeBill.setBaseStatus(BillBaseStatusEnum.AUDITED);
            changeBillCol.add((CoreBaseInfo)changeBill);
            ProcessBomChangeBillEntryCollection PBomChangeEColl = changeBill.getEntrys();
            for (int j = 0; j < PBomChangeEColl.size(); ++j) {
                ProcessBomChangeBillEntryInfo entry = PBomChangeEColl.get(j);
                changeBill = entry.getContent();
                if (changeBill == null) continue;
                processBom = changeBill.getProcessBom();
                if (entry.getTypeOfChange().equals((Object)TypeOfChangeEnum.ADD)) {
                    processBom = this.addProcessBom(ctx, changeBill);
                } else {
                    this.updateProcessBom(ctx, processBom, changeBill);
                    if (processBom.isIsImport()) {
                        this.updateBom(ctx, processBom, changeBill, bomColl, bomEntryColl);
                    }
                }
                processBomCol.add((CoreBaseInfo)processBom);
                changeBill.setBaseStatus(BillBaseStatusEnum.AUDITED);
                changeBillCol.add((CoreBaseInfo)changeBill);
            }
            changeBill.setUpdateOfficialTable(true);
        }
        if (bomEntryColl.size() > 0) {
            BomEntryFactory.getLocalInstance((Context)ctx).save(bomEntryColl);
        }
        if (bomColl.size() > 0) {
            BomFactory.getLocalInstance((Context)ctx).save(bomColl);
        }
        if (processBomCol.size() > 0) {
            ProcessBomBillFactory.getLocalInstance(ctx).save(processBomCol);
        }
        if (changeBillCol.size() > 0) {
            ipb.update(changeBillCol);
        }
    }

    private ProcessBomBillInfo addProcessBom(Context ctx, ProcessBomChangeBillInfo changeBill) {
        ProcessBomBillInfo processBom = new ProcessBomBillInfo();
        processBom.setId(BOSUuid.create((BOSObjectType)processBom.getBOSType()));
        this.updateProcessBom(ctx, processBom, changeBill);
        processBom.setIsAdd(true);
        processBom.setState(BillBaseStatusEnum.AUDITED);
        changeBill.setProcessBom(processBom);
        return processBom;
    }

    private void updateProcessBom(Context ctx, ProcessBomBillInfo processBom, ProcessBomChangeBillInfo changeBill) {
        processBom.setBatch(changeBill.getBatchNo());
        processBom.setPortNo(changeBill.getPtsNumberP());
        processBom.setSeq(changeBill.getFittedSeq());
        processBom.setParentNo(changeBill.getParentPtsNumberP());
        processBom.setName(changeBill.getPtsNameP());
        processBom.setMaterial(changeBill.getPts());
        processBom.setQuantity(changeBill.getAssemblyQty());
        processBom.setWeight(changeBill.getPieceWeight());
        processBom.setUnit(changeBill.getUnitP());
        processBom.setStuffNo(changeBill.getMaterialNumberP());
        processBom.setMakeFlow(changeBill.getAfterFlow());
        processBom.setSize(changeBill.getNetDimensions());
        processBom.setSizeLength(changeBill.getFeedingSizeLong());
        processBom.setSizeWidth(changeBill.getFeedingSizeWidth());
        processBom.setUsingRate(changeBill.getUseFactor());
        processBom.setRationUnit(changeBill.getSingleFixed());
        processBom.setIsSplit(changeBill.isMaterialSplit());
        processBom.setProject(changeBill.getProjectNo());
        processBom.setRation(changeBill.getFixed());
        processBom.setStorageOrgUnit(changeBill.getLeadInOrgUnitEAS());
        processBom.setSerialNo(changeBill.getSeq());
        processBom.setFixSize(changeBill.getScale());
        processBom.setDrawBillOrg(changeBill.getSuppliesOrgUnitEAS());
        processBom.setFlowsplit(changeBill.isFlowHasSplit());
        processBom.setFlowDate(changeBill.getFlowSplitTime());
        processBom.setStorage(changeBill.getSuppliesOrgUnit());
        processBom.setGetStorage(changeBill.getLeadInOrgUnit());
        processBom.setMaterialProperty(changeBill.getMaterialSources());
        processBom.setMaterialPro(changeBill.getMaterialSourcesEnterprise());
        processBom.setState(BillBaseStatusEnum.AUDITED);
    }

    private void updateBom(Context ctx, ProcessBomBillInfo processBom, ProcessBomChangeBillInfo changeBill, CoreBaseCollection bomColl, CoreBaseCollection bomEntryColl) throws EASBizException, BOSException {
        BomEntryInfo bomEntryInfo = BomEntryFactory.getLocalInstance((Context)ctx).getBomEntryInfo("select *,parent.id where sourceProcess.id = '" + processBom.getId() + "'");
        if (bomEntryInfo == null) {
            ThrowUtil.showUIError((String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0014", (Locale)ctx.getLocale()));
        }
        bomEntryInfo.setMaterial(processBom.getMaterial());
        bomEntryInfo.setSupplyOrgUnit(processBom.getDrawBillOrg());
        bomEntryInfo.setTransferOrgUnit(processBom.getStorageOrgUnit());
        bomEntryInfo.setNetWeight(processBom.getWeight());
        bomEntryInfo.setBaseUnit(changeBill.getPts().getBaseUnit());
        bomEntryInfo.setUnit(changeBill.getPts().getBaseUnit());
        bomEntryInfo.setSpecifiedLength(processBom.getFixSize());
        bomEntryInfo.setMaterialProp(processBom.getMaterialProperty());
        bomEntryInfo.put("BomFlow", (Object)processBom.getMakeFlow());
        bomEntryInfo.put("BeginCarno", (Object)processBom.getBeginCarno());
        bomEntryInfo.put("EndCarno", (Object)processBom.getEndCarno());
        bomEntryColl.add((CoreBaseInfo)bomEntryInfo);
        BomInfo bomInfo = bomEntryInfo.getParent();
        bomInfo.setProject(changeBill.getProjectNo());
        bomInfo.setMaterial(changeBill.getParentPts());
        bomColl.add((CoreBaseInfo)bomInfo);
    }
}

