/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExFactory;
import com.kingdee.eas.emm.mo.ManufactureOrderTechnicsExInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedFactory;
import com.kingdee.eas.industry.emm.basedata.LocationDefinedInfo;
import com.kingdee.eas.industry.emm.mm.mo.ManufactureOrderFacadeFactory;
import com.kingdee.eas.mm.basedata.IMRWorkProcesEntry;
import com.kingdee.eas.mm.basedata.IPBOM;
import com.kingdee.eas.mm.basedata.IPBOMEntry;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryCollection;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryFactory;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.mm.basedata.OprTimeUnitEnum;
import com.kingdee.eas.mm.basedata.OverRunMeasureEnum;
import com.kingdee.eas.mm.basedata.PBOMEntryCollection;
import com.kingdee.eas.mm.basedata.PBOMEntryFactory;
import com.kingdee.eas.mm.basedata.PBOMEntryInfo;
import com.kingdee.eas.mm.basedata.PBOMFactory;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WorkCenterInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.mo.IManufactureOrder;
import com.kingdee.eas.mm.mo.ManufactureOrderCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderStockCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderStockInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsCollection;
import com.kingdee.eas.mm.mo.ManufactureOrderTechnicsInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.BusinessRepFactory;
import com.kingdee.eas.zjbom.BusinessRepInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessAssEntryCollection;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessAssEntryInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessEntryCollection;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessEntryInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormTypeFactory;
import com.kingdee.eas.zjbom.EngineeringChangeFormTypeInfo;
import com.kingdee.eas.zjbom.TypeOfChangeEnum;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EngineeringChangeFormProcessAudit {
    private static Logger logger = Logger.getLogger((String)EngineeringChangeFormProcessAudit.class.getName());
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";
    private String remark = null;
    protected Context ctx;
    protected IManufactureOrder imo;
    protected Map mergeIDs = new HashMap();
    protected EngineeringChangeFormProcessInfo model;
    protected EngineeringChangeFormTypeInfo modelType;
    List regenerateMergeIDMOTIDList = new ArrayList();
    List updateGWMOTIDList = new ArrayList();
    List updateMOTIDList = new ArrayList();
    List updateMOTMergeIDList = new ArrayList();

    public static ManufactureOrderInfo cloneOrder(Context ctx, ManufactureOrderInfo order, EngineeringChangeFormTypeInfo modelType) throws EASBizException, BOSException {
        ManufactureOrderInfo newOrder = (ManufactureOrderInfo)order.clone();
        newOrder.setId(null);
        newOrder.setBaseStatus(BillBaseStatusEnum.AUDITED);
        newOrder.setNumber(null);
        AutoNumberUtil.initNumber(ctx, (IObjectValue)newOrder);
        newOrder.put("stocks", (Object)new ManufactureOrderStockCollection());
        newOrder.put("technics", (Object)new ManufactureOrderTechnicsCollection());
        if (modelType != null) {
            if (modelType.getManuFBizType() != null) {
                newOrder.setBizType(modelType.getManuFBizType());
            }
            if (modelType.getProTransType() != null) {
                newOrder.setTransactionType(modelType.getProTransType());
            }
        }
        newOrder.setBizDate(new Date());
        newOrder.setAuditor(BomUtil.getCurrentUser(ctx));
        newOrder.setAuditTime(new Timestamp(newOrder.getBizDate().getTime()));
        newOrder.setCreator(null);
        newOrder.setCreateTime(null);
        newOrder.setLastUpdateUser(null);
        newOrder.setLastUpdateTime(null);
        return newOrder;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.operation.*"));
        sic.add(new SelectorItemInfo("entrys.workcenter.*"));
        sic.add(new SelectorItemInfo("AssEntrys.project.number"));
        sic.add(new SelectorItemInfo("AssEntrys.trackNumber.number"));
        return sic;
    }

    protected static ManufactureOrderTechnicsInfo getLastTechnicsInfo(Context ctx, ManufactureOrderInfo info) throws BOSException, EASBizException {
        ManufactureOrderTechnicsInfo lastTechnics = null;
        try {
            ManufactureOrderTechnicsCollection manufacTechColl = info.getTechnics();
            int size = manufacTechColl.size();
            for (int k = 0; k < size; ++k) {
                ManufactureOrderTechnicsInfo technics = manufacTechColl.get(k);
                if (lastTechnics != null && lastTechnics.getOperationNo() >= technics.getOperationNo()) continue;
                lastTechnics = technics;
            }
        }
        catch (Exception e) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"HQSCDDZHYDGXHCC_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", strInfo + e.getMessage());
            throw new InterfaceDataBaseException(interfaceException, (Throwable)e);
        }
        return lastTechnics;
    }

    EngineeringChangeFormProcessAudit(Context ctx) {
        this.ctx = ctx;
    }

    public void afterAudit() throws BOSException, EASBizException {
        String number = this.model.getNumber();
        if (this.model.getStandardRooting() == null) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0170", (Locale)this.ctx.getLocale()) + number + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0171", (Locale)this.ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (this.model.getAssEntrys() == null || this.model.getAssEntrys().size() == 0) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0170", (Locale)this.ctx.getLocale()) + number + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0172", (Locale)this.ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        if (this.model.getEntrys() == null || this.model.getEntrys().size() == 0) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0170", (Locale)this.ctx.getLocale()) + number + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0173", (Locale)this.ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        ProjectInfo projectInfo = this.model.getAssEntrys().get(0).getProject();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.number"));
        selector.add(new SelectorItemInfo("material.name"));
        selector.add(new SelectorItemInfo("materialRooting.workProcess.*"));
        StandardRootingInfo standRootInfo = StandardRootingFactory.getLocalInstance((Context)this.ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(this.model.getStandardRooting().getId()), selector);
        EngineeringChangeFormProcessEntryCollection engChaFormColl = this.model.getEntrys();
        if (this.model.isIsChangeOperation()) {
            this.updateStandardRoot(this.ctx, standRootInfo, this.model, engChaFormColl);
        }
        if (this.modelType.isIsInfluenceManu()) {
            this.updateManufactureOrder(this.ctx, this.model, standRootInfo, projectInfo);
        }
    }

    public void beforeAudit(EngineeringChangeFormProcessInfo info) throws BOSException, EASBizException {
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0131", (Locale)this.ctx.getLocale()));
            throw new InterfaceDataBaseException(interfaceException);
        }
        this.setEngineeringChangeFormProcessInfo(info);
    }

    public boolean isDiffrent(Object arg0, Object arg1) {
        boolean isChanged = false;
        if (arg0 == null && arg1 != null || arg0 != null && arg1 == null) {
            isChanged = true;
        } else if (arg0 != null && arg1 != null) {
            isChanged = arg0 instanceof CoreBaseInfo && arg1 instanceof CoreBaseInfo ? !((CoreBaseInfo)arg0).getId().toString().equals(((CoreBaseInfo)arg1).getId().toString()) : !arg0.equals(arg1);
        }
        return isChanged;
    }

    public void setEngineeringChangeFormProcessInfo(EngineeringChangeFormProcessInfo model) throws EASBizException, BOSException {
        this.model = model;
        this.modelType = this.model.getType();
        if (this.modelType != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("manuFBizType.*"));
            sic.add(new SelectorItemInfo("proTransType.*"));
            this.modelType = EngineeringChangeFormTypeFactory.getLocalInstance(this.ctx).getEngineeringChangeFormTypeInfo((IObjectPK)new ObjectUuidPK(this.modelType.getId()), sic);
        }
    }

    private String getReqRemark(EngineeringChangeFormProcessInfo processInfo) throws EASBizException, BOSException {
        if (this.remark != null) {
            return this.remark;
        }
        this.remark = "";
        if (processInfo != null && processInfo.isIsReqChange()) {
            this.remark = this.remark + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0132", (Locale)this.ctx.getLocale());
            if (processInfo.getBusinessRep() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("number");
                BusinessRepInfo reqInfo = BusinessRepFactory.getLocalInstance(this.ctx).getBusinessRepInfo((IObjectPK)new ObjectUuidPK(processInfo.getBusinessRep().getId()), sic);
                if (reqInfo != null) {
                    this.remark = this.remark + "[" + reqInfo.getNumber() + "] ";
                }
            }
            this.remark = processInfo.getRemarks();
        }
        return this.remark;
    }

    protected void addQualityFiled(EngineeringChangeFormProcessEntryInfo changeEntry, ManufactureOrderTechnicsInfo newTechnics) {
        newTechnics.put("qualityClass", (Object)changeEntry.getQualityClass());
        newTechnics.put("qualityReason", (Object)changeEntry.getQualityReason());
        newTechnics.put("qualityTime", (Object)changeEntry.getQualityHour());
    }

    protected String createMOTMergeIDTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FMOTID VARCHAR(44) Null,\r\n");
        sql.append("FMergeID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "FMOTID,FMergeID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createMOTMergeTempTable(Context ctx) throws BOSException {
        String tempTableName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table MOTMergeTempTable(\r\n");
        sql.append("FMOTID VARCHAR(44) Null,\r\n");
        sql.append("FOperationID VARCHAR(44) Null,\r\n");
        sql.append("FWorkCenterID VARCHAR(44) Null,\r\n");
        sql.append("FBaseStatus INT,\r\n");
        sql.append("FIsXOpertion INT,\r\n");
        sql.append("FProjectID VARCHAR(44) Null,\r\n");
        sql.append("FTraceID VARCHAR(44) Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Null,\r\n");
        sql.append("FMergeID VARCHAR(44) Null\r\n");
        sql.append(")\r\n");
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            TempTablePool.getInstance((Context)ctx).createIndex(tempTableName, "IsNull(FOperationID,'Null'),IsNull(FWorkCenterID,'Null'),IsNull(FBaseStatus,0),FProjectID,FTraceID,FStorageOrgUnitID,FMergeID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected void createOrderByCopy(Context ctx, ManufactureOrderInfo order, EngineeringChangeFormProcessInfo changeInfo, EngineeringChangeFormProcessEntryCollection changeEntrys) throws EASBizException, BOSException {
        ManufactureOrderTechnicsCollection technicsColl = new ManufactureOrderTechnicsCollection();
        EngineeringChangeFormProcessInfo processInfo = null;
        int size = changeEntrys.size();
        for (int i = 0; i < size; ++i) {
            BOSUuid motMergeID;
            EngineeringChangeFormProcessEntryInfo changeEntry = changeEntrys.get(i);
            processInfo = changeEntry.getParent();
            if (changeEntry.getChangeType() != TypeOfChangeEnum.ADD) continue;
            ManufactureOrderTechnicsInfo newInfo = this.createTechnicsByChangeEntry(order, changeEntry);
            String motID = newInfo == null ? null : (newInfo.getId() == null ? null : newInfo.getId().toString());
            BOSUuid bOSUuid = motMergeID = newInfo == null ? null : newInfo.getMergeID();
            if (newInfo == null) continue;
            technicsColl.add(newInfo);
            if (motID != null) {
                if (!this.updateMOTIDList.contains(motID)) {
                    this.updateMOTIDList.add(motID);
                }
                if (!this.updateGWMOTIDList.contains(motID)) {
                    this.updateGWMOTIDList.add(motID);
                }
            }
            if (motMergeID == null || this.updateMOTMergeIDList.contains(motMergeID.toString())) continue;
            this.updateMOTMergeIDList.add(motMergeID.toString());
        }
        if (technicsColl.size() <= 0) {
            return;
        }
        ManufactureOrderInfo newOrder = EngineeringChangeFormProcessAudit.cloneOrder(ctx, order, this.modelType);
        newOrder.put("technics", (Object)technicsColl);
        ManufactureOrderTechnicsInfo lastTechnics = EngineeringChangeFormProcessAudit.getLastTechnicsInfo(ctx, newOrder);
        lastTechnics.setIsPickingPoint(true);
        String remark = this.getReqRemark(processInfo);
        newOrder.setRemark(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0174", (Locale)ctx.getLocale()) + this.model.getNumber() + "\n" + remark);
        newOrder.put("srcReqChangeType", (Object)2);
        newOrder.setFinishedQty(BigDecimal.ZERO);
        newOrder.setPassQty(BigDecimal.ZERO);
        this.imo.addnew((CoreBaseInfo)newOrder);
    }

    protected ManufactureOrderTechnicsInfo createTechnicsByChangeEntry(ManufactureOrderInfo order, EngineeringChangeFormProcessEntryInfo changeEntry) throws BOSException, EASBizException {
        ManufactureOrderTechnicsInfo newTechnics = new ManufactureOrderTechnicsInfo();
        newTechnics.setId(BOSUuid.create((String)newTechnics.getBOSType().toString()));
        if (order.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            newTechnics.setBaseStatus(EntryBaseStatusEnum.ADD);
        } else if (order.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            newTechnics.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        } else if (order.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            newTechnics.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        } else {
            newTechnics.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        newTechnics.setOperationNo(changeEntry.getOperationNo());
        newTechnics.setEntrustType(changeEntry.getIsOutsou());
        newTechnics.setStorageOrgUnit(this.model.getStorageOrgUnit());
        newTechnics.setOperation(changeEntry.getOperation());
        changeEntry.getOperation().getControlStrategy().getId();
        OperationInfo operationInfo = OperationFactory.getLocalInstance((Context)this.ctx).getOperationInfo((IObjectPK)new ObjectUuidPK(changeEntry.getOperation().getId().toString()));
        newTechnics.setControlStrategy(operationInfo.getControlStrategy());
        newTechnics.setWorkcenter(changeEntry.getWorkcenter());
        newTechnics.setAdminOrgUnit(changeEntry.getWorkcenter().getAdminOrgUnit());
        newTechnics.setQty(order.getQty());
        newTechnics.setOperQty(order.getQty());
        newTechnics.setMergeID(BOSUuid.create((String)"12345678"));
        newTechnics.setOverrunMeasure(OverRunMeasureEnum.NOT_CONTROL);
        newTechnics.setIsReportPoint(true);
        newTechnics.setIsCheckPoint(changeEntry.isIsCheckPoint());
        Timestamp curTime = new Timestamp(new Date().getTime());
        newTechnics.setEarlistWoktime(curTime);
        newTechnics.setLastWorktime(curTime);
        newTechnics.setEarlistCmpTime(curTime);
        newTechnics.setLastCmpTime(curTime);
        newTechnics.setEntrustSupplier(changeEntry.getSupplier());
        newTechnics.setProcessBatch(changeEntry.getProcessBatch());
        newTechnics.setTimeUnit(OprTimeUnitEnum.Hour);
        newTechnics.setParent(order);
        newTechnics.setUnit(order.getUnit());
        newTechnics.setBaseUnit(order.getBaseUnit());
        newTechnics.setTotalUpperQty(order.getQty().multiply(BigDecimal.ONE));
        newTechnics.setIsXOpertion(((Boolean)changeEntry.getOperation().get("isXOpertion")).booleanValue());
        if (changeEntry.getGongwei() != null) {
            newTechnics.setLocationdefine(changeEntry.getGongwei());
        }
        this.addQualityFiled(changeEntry, newTechnics);
        String reqRemark = this.getReqRemark(this.model);
        newTechnics.put("reqRemark", (Object)reqRemark);
        newTechnics.setRemark(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0175", (Locale)this.ctx.getLocale()));
        String manufactororderid = order.getId().toString();
        FilterInfo filter = new FilterInfo();
        String techid = newTechnics.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("pid", (Object)techid, CompareType.EQUALS));
        boolean isExist = ManufactureOrderTechnicsExFactory.getLocalInstance(this.ctx).exists(filter);
        if (!isExist) {
            newTechnics.setProcessBatch(new BigDecimal(1));
            ManufactureOrderTechnicsExInfo technicsex = new ManufactureOrderTechnicsExInfo();
            technicsex.setParent(manufactororderid);
            technicsex.setPid(newTechnics);
            ManufactureOrderTechnicsExFactory.getLocalInstance(this.ctx).save(technicsex);
        }
        return newTechnics;
    }

    protected boolean deleteTechnicsByChangeEntry(ManufactureOrderInfo order, ManufactureOrderTechnicsInfo technics, EngineeringChangeFormProcessEntryInfo changeEntry) {
        int i;
        ManufactureOrderStockCollection stockColl = order.getStocks();
        boolean isDelete = true;
        ManufactureOrderStockCollection deletes = new ManufactureOrderStockCollection();
        int operationNo = technics.getOperationNo();
        int size = stockColl.size();
        for (i = 0; i < size; ++i) {
            ManufactureOrderStockInfo stock = stockColl.get(i);
            if (operationNo != stock.getOperationNo()) continue;
            if (stock.getActIssueQty().compareTo(BigDecimal.ZERO) > 0) {
                isDelete = false;
            }
            if (!isDelete) {
                return isDelete;
            }
            deletes.add(stock);
        }
        if (deletes.size() > 0) {
            size = deletes.size();
            for (i = 0; i < size; ++i) {
                stockColl.remove(deletes.get(i));
            }
        }
        order.getTechnics().remove(technics);
        return isDelete;
    }

    protected SelectorItemCollection getManufactureOrderSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("technics.*"));
        sic.add(new SelectorItemInfo("stocks.*"));
        sic.add(new SelectorItemInfo("expectOutputs.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("transactionType.*"));
        sic.add(new SelectorItemInfo("transactionType.number"));
        sic.add(new SelectorItemInfo("transactionType.name"));
        sic.add(new SelectorItemInfo("transactionType.bizType.*"));
        sic.add(new SelectorItemInfo("transactionType.defaultBFWarehouse.*"));
        sic.add(new SelectorItemInfo("transactionType.defaultBFLocation.*"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("routing.id"));
        sic.add(new SelectorItemInfo("routing.number"));
        sic.add(new SelectorItemInfo("routing.name"));
        sic.add(new SelectorItemInfo("routing.currency.id"));
        sic.add(new SelectorItemInfo("routing.currency.name"));
        sic.add(new SelectorItemInfo("routing.currency.number"));
        sic.add(new SelectorItemInfo("routing.currency.precision"));
        sic.add(new SelectorItemInfo("dispatcher.id"));
        sic.add(new SelectorItemInfo("dispatcher.number"));
        sic.add(new SelectorItemInfo("dispatcher.name"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("costObject.id"));
        sic.add(new SelectorItemInfo("costObject.number"));
        sic.add(new SelectorItemInfo("costObject.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNumber.id"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        sic.add(new SelectorItemInfo("trackNumber.name"));
        sic.add(new SelectorItemInfo("defaultWarehous.id"));
        sic.add(new SelectorItemInfo("defaultWarehous.number"));
        sic.add(new SelectorItemInfo("defaultWarehous.name"));
        sic.add(new SelectorItemInfo("technics.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("technics.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("technics.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("technics.operation.id"));
        sic.add(new SelectorItemInfo("technics.operation.number"));
        sic.add(new SelectorItemInfo("technics.operation.name"));
        sic.add(new SelectorItemInfo("technics.workcenter.id"));
        sic.add(new SelectorItemInfo("technics.workcenter.number"));
        sic.add(new SelectorItemInfo("technics.workcenter.name"));
        sic.add(new SelectorItemInfo("technics.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("technics.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("technics.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("technics.controlStrategy.*"));
        sic.add(new SelectorItemInfo("technics.controlStrategy.number"));
        sic.add(new SelectorItemInfo("technics.controlStrategy.name"));
        sic.add(new SelectorItemInfo("technics.unit.id"));
        sic.add(new SelectorItemInfo("technics.unit.number"));
        sic.add(new SelectorItemInfo("technics.unit.name"));
        sic.add(new SelectorItemInfo("technics.baseUnit.*"));
        sic.add(new SelectorItemInfo("technics.baseUnit.number"));
        sic.add(new SelectorItemInfo("technics.baseUnit.name"));
        sic.add(new SelectorItemInfo("technics.entrustSupplier.id"));
        sic.add(new SelectorItemInfo("technics.entrustSupplier.number"));
        sic.add(new SelectorItemInfo("technics.entrustSupplier.name"));
        sic.add(new SelectorItemInfo("technics.subRouting.id"));
        sic.add(new SelectorItemInfo("technics.subRouting.number"));
        sic.add(new SelectorItemInfo("technics.subRouting.name"));
        sic.add(new SelectorItemInfo("stocks.material.id"));
        sic.add(new SelectorItemInfo("stocks.material.number"));
        sic.add(new SelectorItemInfo("stocks.material.name"));
        sic.add(new SelectorItemInfo("stocks.material.model"));
        sic.add(new SelectorItemInfo("stocks.unit.id"));
        sic.add(new SelectorItemInfo("stocks.unit.number"));
        sic.add(new SelectorItemInfo("stocks.unit.name"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.id"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.number"));
        sic.add(new SelectorItemInfo("stocks.baseUnit.name"));
        sic.add(new SelectorItemInfo("stocks.replaceMaterial.id"));
        sic.add(new SelectorItemInfo("stocks.replaceMaterial.number"));
        sic.add(new SelectorItemInfo("stocks.replaceMaterial.name"));
        sic.add(new SelectorItemInfo("stocks.warehouse.id"));
        sic.add(new SelectorItemInfo("stocks.warehouse.number"));
        sic.add(new SelectorItemInfo("stocks.warehouse.name"));
        sic.add(new SelectorItemInfo("stocks.location.id"));
        sic.add(new SelectorItemInfo("stocks.location.number"));
        sic.add(new SelectorItemInfo("stocks.location.name"));
        sic.add(new SelectorItemInfo("stocks.operation.id"));
        sic.add(new SelectorItemInfo("stocks.operation.number"));
        sic.add(new SelectorItemInfo("stocks.operation.name"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.id"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.number"));
        sic.add(new SelectorItemInfo("stocks.receiptStroageOrgUnit.name"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.id"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.number"));
        sic.add(new SelectorItemInfo("stocks.receiptStock.name"));
        sic.add(new SelectorItemInfo("expectOutputs.material.id"));
        sic.add(new SelectorItemInfo("expectOutputs.material.number"));
        sic.add(new SelectorItemInfo("expectOutputs.material.name"));
        sic.add(new SelectorItemInfo("expectOutputs.material.model"));
        sic.add(new SelectorItemInfo("expectOutputs.unit.id"));
        sic.add(new SelectorItemInfo("expectOutputs.unit.number"));
        sic.add(new SelectorItemInfo("expectOutputs.unit.name"));
        sic.add(new SelectorItemInfo("expectOutputs.baseUnit.id"));
        sic.add(new SelectorItemInfo("expectOutputs.baseUnit.number"));
        sic.add(new SelectorItemInfo("expectOutputs.baseUnit.name"));
        sic.add(new SelectorItemInfo("expectOutputs.assistUnit.id"));
        sic.add(new SelectorItemInfo("expectOutputs.assistUnit.number"));
        sic.add(new SelectorItemInfo("expectOutputs.assistUnit.name"));
        sic.add(new SelectorItemInfo("expectOutputs.operation.id"));
        sic.add(new SelectorItemInfo("expectOutputs.operation.number"));
        sic.add(new SelectorItemInfo("expectOutputs.operation.name"));
        sic.add(new SelectorItemInfo("expectOutputs.defaultWarehous.id"));
        sic.add(new SelectorItemInfo("expectOutputs.defaultWarehous.number"));
        sic.add(new SelectorItemInfo("expectOutputs.defaultWarehous.name"));
        sic.add(new SelectorItemInfo("expectOutputs.costObect.id"));
        sic.add(new SelectorItemInfo("expectOutputs.costObect.number"));
        sic.add(new SelectorItemInfo("expectOutputs.costObect.name"));
        return sic;
    }

    protected String insertMOTMergeIDTempTableSQL(String motMergeIDTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(motMergeIDTempTable).append("(\r\n");
        sql.append("FMOTID,\r\n");
        sql.append("FMergeID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String insertMOTMergeTempTableSQL(String motMergeTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("Insert Into ").append(motMergeTempTable).append("(\r\n");
        sql.append("FMOTID,\r\n");
        sql.append("FOperationID,\r\n");
        sql.append("FWorkCenterID,\r\n");
        sql.append("FBaseStatus,\r\n");
        sql.append("FIsXOpertion,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FMergeID\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected void modifyBillOfMaterial(Context ctx, StandardRootingInfo standRootInfo, EngineeringChangeFormProcessInfo engChageFormProInfo, EngineeringChangeFormProcessEntryCollection engChaFormColl) throws BOSException, EASBizException {
        PBOMEntryCollection wpseqcol;
        Integer wpseq;
        PBOMEntryInfo pbomEntry;
        if (engChaFormColl == null || engChaFormColl.size() == 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        EngineeringChangeFormProcessAssEntryCollection assentrys = engChageFormProInfo.getAssEntrys();
        if (assentrys == null || assentrys.size() == 0) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("parent.routing.id", (Object)standRootInfo.getId().toString()));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("parent.*"));
        sic.add(new SelectorItemInfo("routingItem.*"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        IPBOM ipbomMain = PBOMFactory.getLocalInstance((Context)ctx);
        IPBOMEntry ipbom = PBOMEntryFactory.getLocalInstance((Context)ctx);
        PBOMEntryCollection entryCol = ipbom.getPBOMEntryCollection(evi);
        if (entryCol == null || entryCol.size() == 0) {
            return;
        }
        HashMap<Integer, PBOMEntryCollection> wpseqmap = new HashMap<Integer, PBOMEntryCollection>();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            pbomEntry = entryCol.get(i);
            MRWorkProcesEntryInfo workProcess = pbomEntry.getRoutingItem();
            if (workProcess == null) continue;
            wpseq = workProcess.getWpSeq();
            if (wpseqmap.containsKey(wpseq)) {
                wpseqcol = (PBOMEntryCollection)wpseqmap.get(wpseq);
            } else {
                wpseqcol = new PBOMEntryCollection();
                wpseqmap.put(wpseq, wpseqcol);
            }
            wpseqcol.add(pbomEntry);
        }
        HashMap<Integer, PBOMEntryCollection> merge = new HashMap<Integer, PBOMEntryCollection>();
        HashMap<Integer, PBOMEntryCollection> delete = new HashMap<Integer, PBOMEntryCollection>();
        HashSet<ObjectUuidPK> deletemainids = new HashSet<ObjectUuidPK>();
        HashSet<ObjectUuidPK> deleteentryids = new HashSet<ObjectUuidPK>();
        int size2 = engChaFormColl.size();
        for (int i = 0; i < size2; ++i) {
            PBOMEntryCollection mergeEntry;
            EngineeringChangeFormProcessEntryInfo entry = engChaFormColl.get(i);
            if (!TypeOfChangeEnum.DELETE.equals((Object)entry.getChangeType()) || (wpseq = Integer.valueOf(entry.getOperationNo())) == 0 || !wpseqmap.containsKey(wpseq)) continue;
            wpseqcol = (PBOMEntryCollection)wpseqmap.get(wpseq);
            int jsize = wpseqcol.size();
            for (int j = 0; j < jsize; ++j) {
                pbomEntry = wpseqcol.get(j);
                deletemainids.add(new ObjectUuidPK(pbomEntry.getParent().getId()));
                deleteentryids.add(new ObjectUuidPK(pbomEntry.getId()));
            }
            delete.put(wpseq, wpseqcol);
            Integer rewpseq = entry.getRepartitionWpSeq();
            if (rewpseq == 0) continue;
            if (merge.containsKey(rewpseq)) {
                mergeEntry = (PBOMEntryCollection)merge.get(rewpseq);
            } else {
                mergeEntry = new PBOMEntryCollection();
                merge.put(rewpseq, mergeEntry);
            }
            mergeEntry.addCollection(wpseqcol);
        }
        if (merge.size() > 0) {
            // empty if block
        }
        if (deleteentryids.size() > 0) {
            IObjectPK[] pks = new IObjectPK[deleteentryids.size()];
            deleteentryids.toArray(pks);
            ipbom.delete(pks);
        }
        if (deletemainids.size() > 0) {
            IObjectPK[] pks = new IObjectPK[deletemainids.size()];
            deletemainids.toArray(pks);
            ipbomMain.delete(pks);
        }
    }

    protected void modifyTechnics(Context ctx, ManufactureOrderInfo order, EngineeringChangeFormProcessEntryCollection changeEntrys) throws EASBizException, BOSException {
        int i;
        String key;
        TypeOfChangeEnum type;
        int i2;
        ManufactureOrderTechnicsInfo technics;
        ManufactureOrderTechnicsCollection technicsColl = order.getTechnics();
        ManufactureOrderTechnicsInfo lastTechnics = EngineeringChangeFormProcessAudit.getLastTechnicsInfo(ctx, order);
        HashMap<String, ManufactureOrderTechnicsInfo> updateTechnics = new HashMap<String, ManufactureOrderTechnicsInfo>();
        HashMap<String, ManufactureOrderTechnicsInfo> deleteTechnics = new HashMap<String, ManufactureOrderTechnicsInfo>();
        HashSet<String> allTechnics = new HashSet<String>();
        int size = technicsColl.size();
        for (int i3 = 0; i3 < size; ++i3) {
            technics = technicsColl.get(i3);
            EntryBaseStatusEnum status = technics.getBaseStatus();
            String key2 = "NO:" + technics.getOperationNo();
            allTechnics.add(key2);
            updateTechnics.put(key2, technics);
            if (status != EntryBaseStatusEnum.ADD && status != EntryBaseStatusEnum.TEMPORARILYSAVED && status != EntryBaseStatusEnum.SUBMITED && status != EntryBaseStatusEnum.AUDITED) continue;
            deleteTechnics.put(key2, technics);
        }
        int size2 = changeEntrys.size();
        for (i2 = 0; i2 < size2; ++i2) {
            EngineeringChangeFormProcessEntryInfo changeEntry = changeEntrys.get(i2);
            type = changeEntry.getChangeType();
            key = "NO:" + changeEntry.getOperationNo();
            technics = (ManufactureOrderTechnicsInfo)deleteTechnics.get(key);
            if (technics == null || type != TypeOfChangeEnum.DELETE) continue;
            this.deleteTechnicsByChangeEntry(order, technics, changeEntry);
        }
        size2 = changeEntrys.size();
        for (i2 = 0; i2 < size2; ++i2) {
            BOSUuid motMergeID;
            String mtid;
            EngineeringChangeFormProcessEntryInfo changeEntry = changeEntrys.get(i2);
            type = changeEntry.getChangeType();
            key = "NO:" + changeEntry.getOperationNo();
            if (type == TypeOfChangeEnum.ADD) {
                BOSUuid motMergeID2;
                if (allTechnics.contains(key)) {
                    String strInfo = ResourceBase.getString((String)RESURL, (String)"XZGXSCDDYCZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[0]);
                    NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", strInfo);
                    throw new InterfaceDataBaseException(interfaceException);
                }
                if (order.getInt("srcReqChangeType") != 0) continue;
                technics = this.createTechnicsByChangeEntry(order, changeEntry);
                BOSUuid bOSUuid = motMergeID2 = technics == null ? null : technics.getMergeID();
                if (motMergeID2 != null && !this.updateMOTMergeIDList.contains(motMergeID2.toString())) {
                    this.updateMOTMergeIDList.add(motMergeID2.toString());
                }
                technicsColl.add(technics);
                continue;
            }
            if (type != TypeOfChangeEnum.MODIFY || (technics = (ManufactureOrderTechnicsInfo)updateTechnics.get(key)) == null) continue;
            OperationInfo motOperationInfo = technics.getOperation();
            OperationInfo changeOperationInfo = changeEntry.getOperation();
            WorkCenterInfo motWorkCenterInfo = technics.getWorkcenter();
            WorkCenterInfo changeWorkCenterInfo = changeEntry.getWorkcenter();
            Boolean isOperationDifferent = this.isDiffrent(motOperationInfo, changeOperationInfo);
            Boolean isWorkCenterDifferent = this.isDiffrent(motWorkCenterInfo, changeWorkCenterInfo);
            if ((isOperationDifferent.booleanValue() || isWorkCenterDifferent.booleanValue()) && technics.getId() != null) {
                mtid = technics.getId().toString();
                if (!this.regenerateMergeIDMOTIDList.contains(mtid)) {
                    this.regenerateMergeIDMOTIDList.add(mtid);
                }
                if (!this.updateMOTIDList.contains(mtid)) {
                    this.updateMOTIDList.add(mtid);
                }
            }
            if (changeEntry.getGongwei() != null && technics.getId() != null && !this.updateGWMOTIDList.contains(mtid = technics.getId().toString())) {
                this.updateGWMOTIDList.add(mtid);
            }
            this.updateTechnicsByChangeEntry(order, technics, changeEntry);
            BOSUuid bOSUuid = motMergeID = technics == null ? null : technics.getMergeID();
            if (motMergeID == null || this.updateMOTMergeIDList.contains(motMergeID.toString())) continue;
            this.updateMOTMergeIDList.add(motMergeID.toString());
        }
        ManufactureOrderTechnicsInfo afterLastTechnics = EngineeringChangeFormProcessAudit.getLastTechnicsInfo(ctx, order);
        if (lastTechnics != null) {
            lastTechnics.setIsPickingPoint(false);
        }
        if (afterLastTechnics != null) {
            afterLastTechnics.setIsPickingPoint(true);
        }
        ArrayList<ManufactureOrderTechnicsInfo> sort = new ArrayList<ManufactureOrderTechnicsInfo>();
        int size3 = order.getTechnics().size();
        for (i = 0; i < size3; ++i) {
            technics = order.getTechnics().get(i);
            sort.add(technics);
        }
        Collections.sort(sort, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                ManufactureOrderTechnicsInfo t1 = (ManufactureOrderTechnicsInfo)o1;
                ManufactureOrderTechnicsInfo t2 = (ManufactureOrderTechnicsInfo)o2;
                return t1.getOperationNo() - t2.getOperationNo();
            }
        });
        size3 = sort.size();
        for (i = 0; i < size3; ++i) {
            technics = (ManufactureOrderTechnicsInfo)sort.get(i);
            technics.setSeq(i + 1);
        }
        this.imo.update((IObjectPK)new ObjectUuidPK(order.getId()), (CoreBaseInfo)order);
        if (this.updateMOTIDList != null && this.updateMOTIDList.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String ids = SQLUtil.arrayToString((Object[])this.updateMOTIDList.toArray());
            sql.setLength(0);
            sql.append("Update T_MM_MFTOrderStock UT\r\n");
            sql.append("Set (\r\n");
            sql.append("FWorkcenterID,\r\n");
            sql.append("FOperationID\r\n");
            sql.append(")=(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("MOT.FWorkCenterID,\r\n");
            sql.append("MOT.FOperationID\r\n");
            sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FParentID=UT.FParentID\r\n");
            sql.append("And MOT.FOperationNO=UT.FOperationNO\r\n");
            sql.append(")\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And UT.FID In (\r\n");
            sql.append("Select\r\n");
            sql.append("MOS.FID\r\n");
            sql.append("From T_MM_MFTOrderTechnics MOT\r\n");
            sql.append("Inner Join T_MM_MFTOrderStock MOS On\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FParentID=MOS.FParentID\r\n");
            sql.append("And MOT.FOperationNO=MOS.FOperationNO\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And MOT.FID In (\r\n");
            sql.append(ids).append("\r\n");
            sql.append(")\r\n");
            sql.append(")\r\n");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update t_im_materialreqbillentry me set ");
            sql.append(" ( FWORKCENTERID, FOPERATIONID,FCostCenterOrgUnitID)");
            sql.append(" = (select  ");
            sql.append("tt.FWorkcenterID,\r\n");
            sql.append("tt.FOperationID,\r\n");
            sql.append("WC.FCostCenterID\r\n");
            sql.append(" from t_mm_mftordertechnics tt");
            sql.append(" inner join t_mm_mftorderstock st on tt.fparentid = st.fparentid and tt.foperationid = st.foperationid and tt.foperationno = st.foperationno\r\n");
            sql.append("Left Join T_MM_WorkCenter WC On WC.FID=TT.FWorkCenterID\r\n");
            sql.append(" where st.fid = to_char(me.fsourcebillentryid)");
            sql.append(" and tt.fid in (").append(ids).append(") ");
            sql.append(" )");
            sql.append(" where fsourcebillentryid in (");
            sql.append(" \t\tselect to_char(stock.fid)");
            sql.append(" \t\tfrom t_mm_mftordertechnics t");
            sql.append(" \t\tinner join t_mm_mftorderstock stock on t.fparentid = stock.fparentid and t.foperationid = stock.foperationid and t.foperationno = stock.foperationno");
            sql.append(" \t\twhere t.fid in (").append(ids).append(") ");
            sql.append(" \t)");
            sql.append("and exists(select 1 from t_im_materialreqbill bill where bill.fbasestatus<>4 and bill.fid=me.fparentid)");
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void updateManufactureOrder(Context ctx, EngineeringChangeFormProcessInfo changeInfo, StandardRootingInfo standRootInfo, ProjectInfo projectInfo) throws BOSException, EASBizException {
        EngineeringChangeFormProcessAssEntryCollection asscoll = changeInfo.getAssEntrys();
        if (asscoll == null || asscoll.size() == 0) {
            return;
        }
        HashSet<String> projectids = new HashSet<String>();
        HashSet<String> trackids = new HashSet<String>();
        int size = asscoll.size();
        for (int i = 0; i < size; ++i) {
            EngineeringChangeFormProcessAssEntryInfo assEntry = asscoll.get(i);
            ProjectInfo project = assEntry.getProject();
            projectids.add(project.getId().toString());
            TrackNumberInfo track = assEntry.getTrackNumber();
            trackids.add(track.getId().toString());
        }
        EntityViewInfo entityView = new EntityViewInfo();
        SelectorItemCollection sic = this.getManufactureOrderSelectors();
        entityView.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)7, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("routing.id", (Object)standRootInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("project.id", projectids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", trackids, CompareType.INCLUDE));
        entityView.setFilter(filter);
        this.imo = ManufactureOrderFactory.getLocalInstance((Context)ctx);
        ManufactureOrderCollection manufacOrdColl = this.imo.getManufactureOrderCollection(entityView);
        if (manufacOrdColl == null || manufacOrdColl.size() == 0) {
            return;
        }
        EngineeringChangeFormProcessEntryCollection changeEntrys = changeInfo.getEntrys();
        this.regenerateMergeIDMOTIDList.clear();
        this.updateMOTIDList.clear();
        this.updateMOTMergeIDList.clear();
        for (int i = 0; i < manufacOrdColl.size(); ++i) {
            EntryBaseStatusEnum entryStatus;
            ManufactureOrderInfo order = manufacOrdColl.get(i);
            if (order == null) continue;
            String number = order.getNumber();
            if (order.getCostObject() == null) {
                NumericExceptionSubItem interfaceException = new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0176", (Locale)ctx.getLocale()) + number + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0177", (Locale)ctx.getLocale()));
                throw new InterfaceDataBaseException(interfaceException);
            }
            String costObjNumber = order.getCostObject().getNumber();
            StringUtils.equalsIgnoreCase((String)number, (String)costObjNumber);
            ManufactureOrderTechnicsInfo lastTechnics = EngineeringChangeFormProcessAudit.getLastTechnicsInfo(ctx, order);
            BillBaseStatusEnum status = order.getBaseStatus();
            EntryBaseStatusEnum entryBaseStatusEnum = entryStatus = lastTechnics != null ? lastTechnics.getBaseStatus() : EntryBaseStatusEnum.ADD;
            if (status == BillBaseStatusEnum.COMPLETE || entryStatus == EntryBaseStatusEnum.COMPLETION || entryStatus == EntryBaseStatusEnum.MOSTCOMPLETION) {
                if (order.getInt("srcReqChangeType") != 0) continue;
                this.createOrderByCopy(ctx, order, changeInfo, changeEntrys);
                continue;
            }
            this.modifyTechnics(ctx, order, changeEntrys);
        }
        if (this.updateMOTMergeIDList != null && this.updateMOTMergeIDList.size() > 0) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("MOTMergeIDList", this.updateMOTMergeIDList);
            param.put("Type", "Auto");
            ManufactureOrderFacadeFactory.getLocalInstance(this.ctx).transferOpenItem(param);
        }
    }

    protected void updateStandardRoot(Context ctx, StandardRootingInfo standRootInfo, EngineeringChangeFormProcessInfo engChageFormProInfo, EngineeringChangeFormProcessEntryCollection engChaFormColl) throws BOSException, EASBizException {
        MRWorkProcesEntryInfo mr;
        MRWorkProcesEntryCollection mrWorkProcessColl = standRootInfo.getMaterialRooting().getWorkProcess();
        if (engChaFormColl.size() == 0) {
            return;
        }
        HashMap<Integer, MRWorkProcesEntryInfo> mrmap = new HashMap<Integer, MRWorkProcesEntryInfo>();
        int size = mrWorkProcessColl.size();
        for (int j = 0; j < size; ++j) {
            mr = mrWorkProcessColl.get(j);
            mrmap.put(mr.getWpSeq(), mr);
        }
        CoreBaseCollection adds = new CoreBaseCollection();
        CoreBaseCollection updates = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> deletes = new ArrayList<ObjectUuidPK>();
        EngineeringChangeFormProcessEntryCollection modifyBill = new EngineeringChangeFormProcessEntryCollection();
        StringBuffer errorMessages = new StringBuffer();
        int size2 = engChaFormColl.size();
        for (int j = 0; j < size2; ++j) {
            EngineeringChangeFormProcessEntryInfo engiEntryInfo = engChaFormColl.get(j);
            Integer wpSeq = engiEntryInfo.getOperationNo();
            boolean flag = mrmap.containsKey(wpSeq);
            TypeOfChangeEnum type = engiEntryInfo.getChangeType();
            if (TypeOfChangeEnum.ADD.equals((Object)type) && !flag) {
                MRWorkProcesEntryInfo mrWorkEntryInfo = new MRWorkProcesEntryInfo();
                BigDecimal item = BigDecimal.ZERO;
                mrWorkEntryInfo.setQueueTime(BigDecimal.ZERO);
                mrWorkEntryInfo.setSpQueueTime(item);
                mrWorkEntryInfo.setSmQueueTime(item);
                mrWorkEntryInfo.setPreparedTime(item);
                mrWorkEntryInfo.setSpPreparedTime(item);
                mrWorkEntryInfo.setSmPreparedTime(item);
                mrWorkEntryInfo.setMachiningTime(item);
                mrWorkEntryInfo.setSpMachiningTime(item);
                mrWorkEntryInfo.setSmMachiningTime(item);
                mrWorkEntryInfo.setWaittingTime(item);
                mrWorkEntryInfo.setRealProductQtyHigh(item);
                mrWorkEntryInfo.setRealProductQtyLow(item);
                mrWorkEntryInfo.setTransferTime(item);
                mrWorkEntryInfo.setParent(standRootInfo.getMaterialRooting());
                mrWorkEntryInfo.setWpSeq(engiEntryInfo.getOperationNo());
                mrWorkEntryInfo.setEntrustType(engiEntryInfo.getIsOutsou());
                mrWorkEntryInfo.setCooStorageOrgUnit(engChageFormProInfo.getStorageOrgUnit());
                mrWorkEntryInfo.setOperation(engiEntryInfo.getOperation());
                mrWorkEntryInfo.setWorkCenter(engiEntryInfo.getWorkcenter());
                mrWorkEntryInfo.setEntrustSupplier(engiEntryInfo.getSupplier());
                mrWorkEntryInfo.setIsReportPoint(true);
                mrWorkEntryInfo.setIsCheckPoint(engiEntryInfo.isIsCheckPoint());
                mrWorkEntryInfo.setProcessBatch(new BigDecimal(1));
                mrWorkEntryInfo.setControlStrategy(engiEntryInfo.getOperation().getControlStrategy());
                mrWorkEntryInfo.setTimeUnit(OprTimeUnitEnum.Hour);
                mrWorkEntryInfo.setOverrunMeasure(OverRunMeasureEnum.NOT_CONTROL);
                mrWorkEntryInfo.put("isXOpertion", engiEntryInfo.getOperation().get("isXOpertion"));
                if (engiEntryInfo.getGongwei() != null && engiEntryInfo.getGongwei().getId() != null) {
                    LocationDefinedInfo locationDefined = LocationDefinedFactory.getLocalInstance((Context)ctx).getLocationDefinedInfo((IObjectPK)new ObjectUuidPK(engiEntryInfo.getGongwei().getId().toString()));
                    engiEntryInfo.setGongwei(locationDefined);
                }
                mrWorkEntryInfo.setLocationDefined(engiEntryInfo.getGongwei());
                adds.add((CoreBaseInfo)mrWorkEntryInfo);
                continue;
            }
            if (!flag) continue;
            mr = (MRWorkProcesEntryInfo)mrmap.get(wpSeq);
            if (TypeOfChangeEnum.MODIFY.equals((Object)type)) {
                mr.setEntrustType(engiEntryInfo.getIsOutsou());
                mr.setOperation(engiEntryInfo.getOperation());
                mr.setWorkCenter(engiEntryInfo.getWorkcenter());
                mr.setEntrustSupplier(engiEntryInfo.getSupplier());
                mr.setIsCheckPoint(engiEntryInfo.isIsCheckPoint());
                mr.setProcessBatch(engiEntryInfo.getProcessBatch());
                mr.put("isXOpertion", engiEntryInfo.getOperation().get("isXOpertion"));
                if (engiEntryInfo.getGongwei() != null) {
                    mr.setLocationDefined(engiEntryInfo.getGongwei());
                }
                updates.add((CoreBaseInfo)mr);
                continue;
            }
            if (!TypeOfChangeEnum.DELETE.equals((Object)type)) continue;
            deletes.add(new ObjectUuidPK(mr.getId()));
            mrWorkProcessColl.remove(mr);
            modifyBill.add(engiEntryInfo);
        }
        IMRWorkProcesEntry imr = MRWorkProcesEntryFactory.getLocalInstance((Context)ctx);
        Result addNewResult = null;
        ArrayList<String> addNewIDList = new ArrayList<String>();
        if (adds.size() > 0) {
            addNewResult = imr.addnew(adds);
            mrWorkProcessColl.addObjectCollection((IObjectCollection)adds);
            if (addNewResult != null && addNewResult.size() > 0) {
                for (int index = 0; index < addNewResult.size(); ++index) {
                    String exception;
                    String id;
                    LineResult lineResult = addNewResult.getLineResult(index);
                    String string = id = lineResult.getPk() == null ? null : lineResult.getPk().toString();
                    if (!addNewIDList.contains(id)) {
                        addNewIDList.add(id);
                    }
                    String string2 = exception = lineResult.getException() == null ? null : lineResult.getException().getMessage();
                    if (exception == null) continue;
                    errorMessages.append(exception);
                }
            }
            logger.debug((Object)((Object)addNewIDList).toString());
            if (errorMessages.toString().trim().length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0178", (Locale)ctx.getLocale()), errorMessages.toString()));
            }
        }
        if (updates.size() > 0) {
            imr.update(updates);
        }
        if (modifyBill.size() > 0) {
            this.modifyBillOfMaterial(ctx, standRootInfo, engChageFormProInfo, modifyBill);
        }
        if (deletes.size() > 0) {
            IObjectPK[] pks = new IObjectPK[deletes.size()];
            deletes.toArray(pks);
            imr.delete(pks);
        }
    }

    protected ManufactureOrderTechnicsInfo updateTechnicsByChangeEntry(ManufactureOrderInfo order, ManufactureOrderTechnicsInfo technics, EngineeringChangeFormProcessEntryInfo changeEntry) throws EASBizException, BOSException {
        technics.setEntrustType(changeEntry.getIsOutsou());
        technics.setOperation(changeEntry.getOperation());
        technics.setWorkcenter(changeEntry.getWorkcenter());
        technics.setAdminOrgUnit(changeEntry.getWorkcenter().getAdminOrgUnit());
        technics.setIsCheckPoint(changeEntry.isIsCheckPoint());
        technics.setEntrustSupplier(changeEntry.getSupplier());
        technics.setProcessBatch(changeEntry.getProcessBatch());
        technics.put("isXOpertion", changeEntry.getOperation().get("isXOpertion"));
        String reqRemark = this.getReqRemark(this.model);
        technics.put("reqRemark", (Object)reqRemark);
        String manufactororderid = order.getId().toString();
        FilterInfo filter = new FilterInfo();
        String techid = technics.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("pid", (Object)techid, CompareType.EQUALS));
        boolean isExist = ManufactureOrderTechnicsExFactory.getLocalInstance(this.ctx).exists(filter);
        if (!isExist) {
            technics.setProcessBatch(new BigDecimal(1));
            ManufactureOrderTechnicsExInfo technicsex = new ManufactureOrderTechnicsExInfo();
            technicsex.setParent(manufactororderid);
            technicsex.setPid(technics);
            ManufactureOrderTechnicsExFactory.getLocalInstance(this.ctx).save(technicsex);
        }
        if (changeEntry.getGongwei() != null) {
            technics.setLocationdefine(changeEntry.getGongwei());
        }
        this.addQualityFiled(changeEntry, technics);
        return technics;
    }
}

