/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.zjbom.DesignBOMBillSplitFacadeFactory;
import com.kingdee.eas.zjbom.FlowChangeRepCollection;
import com.kingdee.eas.zjbom.FlowChangeRepEntryCollection;
import com.kingdee.eas.zjbom.FlowChangeRepFactory;
import com.kingdee.eas.zjbom.FlowChangeRepInfo;
import com.kingdee.eas.zjbom.IFlowChangeRep;
import com.kingdee.eas.zjbom.SplitSingleProcessCollection;
import com.kingdee.eas.zjbom.SplitSingleProcessFactory;
import com.kingdee.eas.zjbom.app.AbstractFlowChangeRepControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FlowChangeRepControllerBean
extends AbstractFlowChangeRepControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.FlowChangeRepControllerBean");

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        if (FlowChangeRepInfo.class.isInstance(model)) {
            FlowChangeRepInfo info = (FlowChangeRepInfo)model;
            info.setState(BillBaseStatusEnum.SUBMITED);
        }
        super._submit(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FlowChangeRepInfo info = (FlowChangeRepInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        BOSUuid id = info.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        info.setId(id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        this._addnew(ctx, (IObjectPK)pk, (IObjectValue)info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FlowChangeRepInfo info = (FlowChangeRepInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        super._update(ctx, pk, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, model);
        }
        super._save(ctx, pk, model);
    }

    private void initBaseStatus(FlowChangeRepInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getState() == null || info.getState().getValue() < status.getValue()) {
            info.setState(status);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue mod) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        FlowChangeRepInfo info = (FlowChangeRepInfo)mod;
        if (info == null) {
            info = this.getFlowChangeRepInfo(ctx, pk);
        }
        info.setState(BillBaseStatusEnum.AUDITED);
        info.setAuditor(BomUtil.getCurrentUser(ctx));
        info.setAuditTime(new Date());
        super._passAudit(ctx, pk, (IObjectValue)info);
        super._update(ctx, pk, (IObjectValue)info);
        this._updateDesignBOMBill(ctx, pk);
        this._createSplitSingleProcess(ctx, pk);
    }

    @Override
    protected void _updateDesignBOMBill(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FlowChangeRepCollection bills = this.getFlowChangeRepCollection(ctx, "select * where id = '" + pk.toString() + "'");
        DesignBOMBillSplitFacadeFactory.getLocalInstance(ctx).splitByFlowChangeRep(bills);
    }

    @Override
    protected void _createSplitSingleProcess(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FlowChangeRepInfo info = this.getFlowChangeRepInfo(ctx, "select *,entry.*,entry.sjbom.* where id = '" + pk.toString() + "'");
        FlowChangeRepEntryCollection entrys = info.getEntrys();
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        BOTMappingInfo botp = BomBotpUtil.getBOTP(ctx, "MM_FCR001");
        SplitSingleProcessCollection sspcol = BomBotpUtil.createBillByBOTP(ctx, info, botp);
        int size = sspcol.size();
        if (size == 0) {
            return;
        }
        CoreBaseCollection savecol = new CoreBaseCollection();
        for (int i = 0; i < size; ++i) {
            savecol.add((CoreBaseInfo)sspcol.get(i));
        }
        Result pks = SplitSingleProcessFactory.getLocalInstance(ctx).save(savecol);
        if (pks != null && !pks.getLineResult(0).isSucess()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0183", (Locale)ctx.getLocale()) + pks.getLineResult(0).getException().toString()));
        }
        BomBotpUtil.saveRelations(ctx, (IObjectCollection)sspcol);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        FlowChangeRepInfo info = (FlowChangeRepInfo)model;
        info.setState(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super._unpassAudit(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        List<Object> ids = new ArrayList();
        ids = Arrays.asList(arrayPK);
        this.checkAudit(ctx, ids, true);
        super._delete(ctx, arrayPK);
    }

    private boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        IFlowChangeRep issp = FlowChangeRepFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)4));
        check = issp.exists(filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0032", (Locale)ctx.getLocale()));
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._passAudit(ctx, pk, null);
    }
}

