/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.AbstractPdmEasCarnoEqualSetInfo;
import com.kingdee.eas.zjbom.BusinessChangeTypeEnum;
import com.kingdee.eas.zjbom.BusinessInputEntryFactory;
import com.kingdee.eas.zjbom.BusinessInputEntryInfo;
import com.kingdee.eas.zjbom.BusinessInputFactory;
import com.kingdee.eas.zjbom.BusinessInputInfo;
import com.kingdee.eas.zjbom.BusinessMnoTypeEnum;
import com.kingdee.eas.zjbom.DesignBOMBillInfo;
import com.kingdee.eas.zjbom.IPdmEasCarnoEqualSet;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetCollection;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetFactory;
import com.kingdee.eas.zjbom.PdmEasCarnoEqualSetInfo;
import com.kingdee.eas.zjbom.PdmEasOpdatalogFactory;
import com.kingdee.eas.zjbom.PdmEasOpdatalogInfo;
import com.kingdee.eas.zjbom.SourceTypeEnum;
import com.kingdee.eas.zjbom.app.PLMBomControllerBean;
import com.kingdee.eas.zjbom.app.tree.MaterialInfoEntity;
import com.kingdee.eas.zjbom.app.tree.RadomUtil;
import com.kingdee.eas.zjbom.app.tree.TreeHelper;
import com.kingdee.eas.zjbom.app.tree.TreeNode;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PLMBomControllerBeanEx
extends PLMBomControllerBean {
    private static final long serialVersionUID = 451384347177046111L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.PLMBomControllerBeanEx");

    private IPdmEasCarnoEqualSet getPDMToEASFacotry(Context ctx) throws BOSException {
        return PdmEasCarnoEqualSetFactory.getLocalInstance(ctx);
    }

    @Override
    protected void _checkBusinessisExist(Context ctx, IObjectValue model) throws BOSException {
        String fxm = model.getExtendedProperty("PMH");
        boolean isBackstage = Boolean.parseBoolean(model.getExtendedProperty("isBackstage"));
        if (this.checkExistBusinessInput(ctx, fxm) && !isBackstage) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0185", (Locale)ctx.getLocale()));
        }
        if (this.checkExistBusinessInput(ctx, fxm) && isBackstage) {
            return;
        }
    }

    @Override
    protected void _syncDesignBOM(Context ctx, IObjectValue model) throws BOSException {
        if (model != null) {
            String pmh = model.getExtendedProperty("PMH");
            try {
                this.loopSyncXM(ctx, pmh, false);
                this.logXm(ctx, pmh, true);
            }
            catch (Exception ex) {
                this.logXm(ctx, pmh, false);
            }
        } else {
            PdmEasCarnoEqualSetCollection values = PdmEasCarnoEqualSetFactory.getLocalInstance(ctx).getPdmEasCarnoEqualSetCollection();
            for (int n = 0; n < values.size(); ++n) {
                if (!values.get(n).isIssync()) continue;
                String pmh = values.get(n).getPDMCARNO();
                try {
                    this.loopSyncXM(ctx, pmh, true);
                    this.logXm(ctx, pmh, true);
                    continue;
                }
                catch (Exception ex) {
                    this.logXm(ctx, pmh, false);
                }
            }
        }
    }

    private void logXm(Context ctx, String pmh, boolean issuccess) {
        PdmEasOpdatalogInfo info = new PdmEasOpdatalogInfo();
        Date time = new Date();
        Timestamp _time = new Timestamp(time.getTime());
        info.setXM(pmh);
        info.setCreateTime(_time);
        info.setBizDate(_time);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        try {
            PdmEasOpdatalogFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void loopSyncXM(Context ctx, String pmh, boolean isBackstage) throws BOSException {
        String sql = "select count(*) account from ct_zjb_designbombill a where a.FSOURCEBILLID='PTC' and a.CFPROJECTNO='" + pmh + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean isExist = false;
        try {
            if (rs.next() && Integer.parseInt(rs.getString("account")) > 0) {
                isExist = true;
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0186", (Locale)ctx.getLocale()));
        }
        if (isExist) {
            String time = "select cflastupdatesynctime from ct_zjb_pdmeascarnoequalset where cfpdmcarno='" + pmh + "'";
            IRowSet rsTime = DbUtil.executeQuery((Context)ctx, (String)time);
            String breakPointTime = "";
            try {
                while (rsTime.next()) {
                    breakPointTime = rsTime.getString("cflastupdatesynctime");
                }
            }
            catch (Exception ex) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0187", (Locale)ctx.getLocale()));
            }
            this.updateDesignBomByAddData(ctx, breakPointTime, pmh, isBackstage);
        } else {
            this.initDesignBom(ctx, pmh);
        }
    }

    private String createTmpTableBom(Context ctx) throws BOSException {
        String tempTableName = "PLMBOMTempTable";
        try {
            tempTableName = TempTablePool.getInstance((Context)ctx).createTempTable("Create Table PLMBOMTempTable(\r\nFID VARCHAR(44),\r\nFPMNO VARCHAR(20),\r\nFPMVER VARCHAR(8),\r\nFMNO VARCHAR(20),\r\nFMVER VARCHAR(8),\r\nFUNITNAME VARCHAR(8),\r\nFQTY VARCHAR(8)\r\n)");
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0188", (Locale)ctx.getLocale()));
        }
        return tempTableName;
    }

    private void initDesignBom(Context ctx, String pmh) throws BOSException {
        String sql = "select * from T_PLM_EAS_MaterialInfo a where a.fxm='" + pmh + "' and fisproduct='true' order by fmatno,fmatver desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            return;
        }
        try {
            HashMap<String, String> materversionmap = new HashMap<String, String>();
            sql = "select fmatno,max(fmatver) maxversion from t_plm_eas_materialinfo group by fmatno";
            IRowSet materrs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (materrs.next()) {
                materversionmap.put(materrs.getString("fmatno"), materrs.getString("maxversion"));
            }
            Map<String, String[]> result = this.getTopLevelData(ctx, rs);
            String tempTableName = this.createTmpTableBom(ctx);
            this.getDownLevelData(ctx, result, materversionmap, tempTableName);
            Date time = new Date();
            String timesql = "update ct_zjb_pdmeascarnoequalset set cflastupdatesynctime='" + time.toLocaleString() + "'";
            DbUtil.execute((Context)ctx, (String)timesql);
            this.dealData(ctx, tempTableName, pmh);
        }
        catch (Exception ex) {
            logger.debug((Object)ex);
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0189", (Locale)ctx.getLocale()));
        }
    }

    private void updateDesignBomByAddData(Context ctx, String time, String fxm, boolean isBackstage) throws BOSException {
        Date _time = new Date();
        String timesql = "update ct_zjb_pdmeascarnoequalset set cflastupdatesynctime='" + _time.toLocaleString() + "'";
        DbUtil.execute((Context)ctx, (String)timesql);
        String tmpTable = null;
        try {
            tmpTable = this.updateDesignBom(ctx, fxm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if ("".equals(tmpTable) || tmpTable == null) {
            return;
        }
        String sql = "select * from T_PLM_EAS_MaterialInfo where fopdate > '" + time + "' order by fopdate asc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        this._updateEasPtcTree(ctx, tmpTable, fxm, time, isBackstage);
    }

    private void _updateEasPtcTree(Context ctx, String tmpTable, String fxm, String timeStr, boolean isBackstage) throws BOSException {
        Map<String, Object> newMap = this.convertNewDesignBomByStr(ctx, tmpTable, fxm);
        Map<String, Object> oldMap = this.convertOldDesignBomByStr(ctx, fxm);
        Map<String, List<String>> mapRes = this._compareEasAndPtc(newMap, oldMap);
        this.insertBusinessinput(ctx, mapRes, newMap, oldMap);
    }

    private Map<String, List<String>> _compareEasAndPtc(Map<String, Object> ptcNodeMap, Map<String, Object> easNodeMap) throws BOSException {
        HashMap<String, List<String>> mapRes = new HashMap<String, List<String>>();
        HashMap<String, DesignBOMBillInfo> mergeMap = new HashMap<String, DesignBOMBillInfo>();
        Map ptcMap = (Map)ptcNodeMap.get("NOVERKEYMAP");
        Map easMap = (Map)easNodeMap.get("NOVERKEYMAP");
        mergeMap.putAll(ptcMap);
        mergeMap.putAll(easMap);
        List<String> delList = this.getCompareMap(mergeMap, ptcMap, false);
        List<String> addList = this.getCompareMap(mergeMap, easMap, false);
        List<String> repeatList = this.getCompareMap(ptcMap, easMap, true);
        mapRes.put("ADD", addList);
        mapRes.put("DEL", delList);
        mapRes.put("REPEAT", repeatList);
        return mapRes;
    }

    private boolean checkExistBusinessInput(Context ctx, String fxm) throws BOSException {
        String sql = "select fparentid from ct_zjb_businessinputentry where cfprojectnumberpdm='" + fxm + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String uuid = rs.getString("fparentid");
                map.put(uuid, uuid);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0190", (Locale)ctx.getLocale()));
        }
        if (map.size() > 0) {
            for (Map.Entry obj : map.entrySet()) {
                String pk = (String)obj.getKey();
                ObjectUuidPK pkobj = new ObjectUuidPK(pk);
                try {
                    BusinessInputInfo info = BusinessInputFactory.getLocalInstance(ctx).getBusinessInputInfo((IObjectPK)pkobj);
                    if (info.getState().getValue() >= 8) continue;
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private BusinessInputEntryInfo createBusinessInputEntryInfo(Context ctx, BusinessInputInfo bi, DesignBOMBillInfo info, String changeType, String pmno) {
        BusinessInputEntryInfo bientry = new BusinessInputEntryInfo();
        bientry.setParent(bi);
        bientry.setReasonsOfChange(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0191", (Locale)ctx.getLocale()));
        bientry.setBz(info.getBz());
        bientry.setChangeType(BusinessChangeTypeEnum.BOMCHANGE);
        String begincarno = info.getBeginCarNo();
        String endcarno = info.getEndCarNo();
        bientry.setBegincarnoPDM(begincarno);
        bientry.setEndcarnoPDM(endcarno);
        bientry.setProjectNamePDM(info.getProjectName());
        bientry.setProjectNumberPDM(info.getProjectNo());
        bientry.setMemo(info.getMeno());
        bientry.setCmname(info.getStruffName());
        bientry.setCmno(info.getStuffNo());
        bientry.setQty(info.getQuantity());
        bientry.setParentchartno(info.getParentchartno());
        bientry.setPmname(info.getParentName());
        bientry.setPmno(pmno == null ? info.getParentNo() : pmno);
        bientry.setUnitname(info.getUnit());
        bientry.setChartno("");
        bientry.setMname(info.getName());
        bientry.setMno(info.getPartNo());
        bientry.setMnotype(BusinessMnoTypeEnum.FABRICATEDPART);
        return bientry;
    }

    private void insertBusinessinput(Context ctx, Map<String, List<String>> mapRes, Map<String, Object> newMap, Map<String, Object> oldMap) throws BOSException {
        DesignBOMBillInfo info;
        List<String> addData = mapRes.get("ADD");
        List<String> delData = mapRes.get("DEL");
        List<String> repeatData = mapRes.get("REPEAT");
        BusinessInputInfo bi = new BusinessInputInfo();
        bi.setBizDate(new Date());
        bi.setState(BillBaseStatusEnum.ADD);
        bi.setSourceType(SourceTypeEnum.PTC);
        bi.setPubDate(new Date());
        bi.setPublisher(SysContext.getSysContext().getCurrentUserInfo());
        bi.setPubState(false);
        bi.setNumber(RadomUtil.generateNumber());
        Map maxMap = (Map)oldMap.get("MAXVERSION");
        CoreBaseCollection collectionEntry = new CoreBaseCollection();
        Map mapObject = (Map)newMap.get("VERSIONMAP");
        Map oldmapObject = (Map)oldMap.get("VERSIONMAP");
        for (String s : addData) {
            info = (DesignBOMBillInfo)mapObject.get(((Map)newMap.get("NOVERKEYMAP")).get(s));
            String pnmo = (String)maxMap.get(info.getParentNo().substring(0, info.getParentNo().indexOf(".")));
            BusinessInputEntryInfo bientry = this.createBusinessInputEntryInfo(ctx, bi, info, "0", pnmo);
            collectionEntry.add((CoreBaseInfo)bientry);
        }
        for (String s : delData) {
            info = (DesignBOMBillInfo)oldmapObject.get(((Map)newMap.get("NOVERKEYMAP")).get(s));
            BusinessInputEntryInfo bientry = this.createBusinessInputEntryInfo(ctx, bi, info, "0", null);
            collectionEntry.add((CoreBaseInfo)bientry);
        }
        for (String s : repeatData) {
            BusinessInputEntryInfo bientry;
            info = (DesignBOMBillInfo)mapObject.get(((Map)newMap.get("NOVERKEYMAP")).get(s));
            DesignBOMBillInfo oldinfo = (DesignBOMBillInfo)oldmapObject.get(((Map)newMap.get("NOVERKEYMAP")).get(s));
            String oldmatercodeunit = oldinfo.getParentNo() + "@" + oldinfo.getPartNo();
            String newmatercodeunit = info.getParentNo() + "@" + info.getPartNo();
            BigDecimal oldqty = oldinfo.getQuantity();
            BigDecimal newqty = info.getQuantity();
            if (newqty.compareTo(oldqty) == 0) {
                if (newmatercodeunit.equals(oldmatercodeunit)) continue;
                bientry = this.createBusinessInputEntryInfo(ctx, bi, info, "2", null);
                collectionEntry.add((CoreBaseInfo)bientry);
                continue;
            }
            bientry = this.createBusinessInputEntryInfo(ctx, bi, info, "0", null);
            collectionEntry.add((CoreBaseInfo)bientry);
        }
        try {
            BusinessInputFactory.getLocalInstance(ctx).save((CoreBaseInfo)bi);
            BusinessInputEntryFactory.getLocalInstance(ctx).save(collectionEntry);
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0192", (Locale)ctx.getLocale()));
        }
    }

    private void updateEasDataCompare(Context ctx, IRowSet rs, String tmpTable, String fxm, String timeStr) throws BOSException {
        Map<String, String> ptcNodeList = this.getPTCTreeNode(ctx, tmpTable);
        Map<String, String> easNodeList = this.getEASTreeNode(ctx, fxm);
        Map<String, List<String>> mapRes = null;
        this.createElecBill(ctx, mapRes, tmpTable, timeStr);
    }

    public void createElecBill(Context ctx, Map<String, List<String>> mapRes, String tmpTable, String timeStr) throws BOSException {
        String sql = "select B.* from VTZ12SMW751GFJPK1E2G0DE5K24X B ,T_PLM_EAS_FIRST_EBOM C WHERE B.FID=C.FID and fopdate>'" + timeStr + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0193", (Locale)ctx.getLocale()));
        }
        List<String> delNode = mapRes.get("del");
    }

    private Map<String, List<String>> compareEasAndPtc(Map<String, DesignBOMBillInfo> ptcNodeMap, Map<String, DesignBOMBillInfo> easNodeMap) throws BOSException {
        HashMap<String, List<String>> mapRes = new HashMap<String, List<String>>();
        HashMap<String, DesignBOMBillInfo> mergeMap = new HashMap<String, DesignBOMBillInfo>();
        mergeMap.putAll(ptcNodeMap);
        mergeMap.putAll(easNodeMap);
        List<String> delList = this.getCompareMap(mergeMap, ptcNodeMap, false);
        List<String> addList = this.getCompareMap(mergeMap, easNodeMap, false);
        mapRes.put("ADD", addList);
        mapRes.put("DEL", delList);
        return mapRes;
    }

    private List<String> getCompareMap(Map<String, DesignBOMBillInfo> map1, Map<String, DesignBOMBillInfo> map2, boolean isRepeat) {
        ArrayList<String> rs = new ArrayList<String>();
        for (Map.Entry<String, DesignBOMBillInfo> obj : map1.entrySet()) {
            String key = obj.getKey();
            if (!(!isRepeat ? map2.get(key) == null : map2.get(key) != null)) continue;
            rs.add(key);
        }
        return rs;
    }

    private Map<String, String> getEASTreeNode(Context ctx, String fxm) throws BOSException {
        HashMap<String, String> mapResult = new HashMap<String, String>();
        String parentSql = "select cfpartno,cfparentno from Ct_Zjb_Designbombill  where cfprojectno='" + fxm + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)parentSql);
        try {
            while (rs.next()) {
                String key1 = rs.getString("cfpartno");
                String key2 = rs.getString("cfparentno");
                mapResult.put(key1, "");
                mapResult.put(key2, "");
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0194", (Locale)ctx.getLocale()));
        }
        return mapResult;
    }

    private Map<String, String> getPTCTreeNode(Context ctx, String tmpTable) throws BOSException {
        HashMap<String, String> mapResult = new HashMap<String, String>();
        String sql = "select FPMNO,FPMVER,FMNO,FMVER from " + tmpTable;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String key1 = rs.getString("FPMNO") + "." + rs.getString("FPMVER");
                String key2 = rs.getString("FMNO") + "." + rs.getString("FMVER");
                mapResult.put(key1, "");
                mapResult.put(key2, "");
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0194", (Locale)ctx.getLocale()));
        }
        return mapResult;
    }

    private void updateEasData(Context ctx, IRowSet rs, String tmpTable, String fxm) throws BOSException {
        try {
            while (rs.next()) {
                IRowSet ptc_rs_m;
                String materialcode = rs.getString("FMATNO");
                String materialver = rs.getString("FMATVER");
                String sql = "select * from " + tmpTable + " where FPMNO='" + materialcode + "' and FPMVER='" + materialver + "'";
                IRowSet ptc_rs_p = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (ptc_rs_p.size() > 0) {
                    sql = "select CFPARTNO,CFPARTMATERCODE from Ct_Zjb_Designbombill a where a.cfparentmatercode='" + materialcode + "' and cfprojectno='" + fxm + "'";
                    IRowSet eas_rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    this.compareMaterial(ctx, ptc_rs_p, eas_rs, true);
                }
                if ((ptc_rs_m = DbUtil.executeQuery((Context)ctx, (String)(sql = "select * from " + tmpTable + " where FMNO='" + materialcode + "' and FMVER='" + materialver + "'"))).size() <= 0) continue;
                sql = "select CFPARENTNO,CFPARENTMATERCODE from Ct_Zjb_Designbombill a where a.cfpartmatercode='" + materialcode + "' and cfprojectno='" + fxm + "'";
                IRowSet eas_rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                this.compareMaterial(ctx, ptc_rs_m, eas_rs, false);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0195", (Locale)ctx.getLocale()));
        }
    }

    private void compareMaterial(Context ctx, IRowSet ptc_rs, IRowSet eas_rs, boolean isCompParent) throws BOSException {
        try {
            ArrayList<String> ptsList = new ArrayList<String>();
            ArrayList<String> easList = new ArrayList<String>();
            if (isCompParent) {
                while (ptc_rs.next()) {
                    ptsList.add(ptc_rs.getString("FMNO") + "." + ptc_rs.getString("FMVER"));
                }
            } else {
                while (ptc_rs.next()) {
                    ptsList.add(ptc_rs.getString("FPMNO") + "." + ptc_rs.getString("FPMVER"));
                }
            }
            while (eas_rs.next()) {
                if (isCompParent) {
                    String cfpartno = eas_rs.getString("CFPARTNO");
                    easList.add(cfpartno);
                    continue;
                }
                String string = eas_rs.getString("CFPARENTNO");
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0196", (Locale)ctx.getLocale()));
        }
    }

    private String updateDesignBom(Context ctx, String pmh) throws Exception {
        String sql = "select * from T_PLM_EAS_MaterialInfo a where a.fxm='" + pmh + "' and fisproduct='true' order by fmatno,fmatver desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 0) {
            return "";
        }
        HashMap<String, String> materversionmap = new HashMap<String, String>();
        sql = "select fmatno,max(fmatver) maxversion from t_plm_eas_materialinfo group by fmatno";
        IRowSet materrs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (materrs.next()) {
            materversionmap.put(materrs.getString("fmatno"), materrs.getString("maxversion"));
        }
        String tempTableName = null;
        HashMap<String, String[]> topResult = new HashMap<String, String[]>();
        try {
            Map<String, String[]> result = this.getTopLevelData(ctx, rs);
            topResult.putAll(result);
            tempTableName = this.createTmpTableBom(ctx);
            this.getDownLevelData(ctx, result, materversionmap, tempTableName);
        }
        catch (SQLException ex) {
            logger.debug((Object)ex);
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0189", (Locale)ctx.getLocale()));
        }
        return tempTableName;
    }

    private void createElecBusiBill(Context ctx, String tmpTable, String pmh, Map<String, String[]> result) throws BOSException {
        for (Map.Entry<String, String[]> obj : result.entrySet()) {
            String[] materialStrs = obj.getValue();
            this.createElecBusiBillByMaterial(ctx, tmpTable, pmh, materialStrs);
        }
    }

    private void recurseMatertree(Context ctx, String pmh, String materialcode, String upmaterialcode, Map<String, List<String>> oldMap) throws BOSException {
        String sql = "select cfparentno,cfpartno from ct_zjb_designbombill a where a.cfparentno='" + materialcode + "' and a.cfprojectno='" + pmh + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String cfparentmatercode = rs.getString("cfparentno");
                String cfpartno = rs.getString("cfpartno");
                if (oldMap.get(upmaterialcode + "@" + cfparentmatercode) == null) {
                    ArrayList<String> memberList = new ArrayList<String>();
                    memberList.add(cfpartno);
                    oldMap.put(upmaterialcode + "@" + cfparentmatercode, memberList);
                } else {
                    oldMap.get(upmaterialcode + "@" + cfparentmatercode).add(cfpartno);
                }
                this.recurseMatertree(ctx, pmh, cfpartno, cfparentmatercode, oldMap);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0197", (Locale)ctx.getLocale()));
        }
    }

    private void createElecBusiBillByMaterial(Context ctx, String tmpTable, String pmh, String[] materialinfo) throws BOSException {
        String sql = "select * from " + tmpTable;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<MaterialInfoEntity> materialList = new ArrayList<MaterialInfoEntity>();
        MaterialInfoEntity entityRoot = new MaterialInfoEntity();
        entityRoot.setId((materialinfo[0] + materialinfo[1]).hashCode());
        entityRoot.setCode(materialinfo[0]);
        entityRoot.setVersion(materialinfo[1]);
        entityRoot.setMaterialName(materialinfo[0]);
        materialList.add(entityRoot);
        try {
            while (rs.next()) {
                String fpmno = rs.getString("FPMNO");
                String pfmver = rs.getString("FPMVER");
                String fmno = rs.getString("FMNO");
                String fmver = rs.getString("FMVER");
                MaterialInfoEntity entity = new MaterialInfoEntity();
                entity.setId((fmno + fmver).hashCode());
                entity.setParentId((fpmno + pfmver).hashCode());
                entity.setCode(fmno);
                entity.setVersion(fmver);
                entity.setMaterialName(fmno);
                materialList.add(entity);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0198", (Locale)ctx.getLocale()));
        }
        List<TreeNode> treenodes = TreeHelper.changeEnititiesToTreeNodes(materialList);
        TreeHelper tree = new TreeHelper(treenodes);
        tree.getRoot();
    }

    private void createCompartBill(Map<String, List<String>> oldMap, String tmpTable) {
        for (Map.Entry<String, List<String>> obj : oldMap.entrySet()) {
            String key = obj.getKey();
            ArrayList arrayList = (ArrayList)obj.getValue();
        }
    }

    private Map<String, Object> convertOldDesignBomByStr(Context ctx, String fxh) throws BOSException {
        HashMap<String, Object> _mapResult = new HashMap<String, Object>();
        HashMap<String, String> noverkeyMap = new HashMap<String, String>();
        HashMap<String, DesignBOMBillInfo> versionMap = new HashMap<String, DesignBOMBillInfo>();
        String parentSql = "select * from Ct_Zjb_Designbombill a where a.cfprojectno='" + fxh + "'";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)parentSql);
        HashMap<String, String> maxMaterialVersion = new HashMap<String, String>();
        try {
            while (_rs.next()) {
                String key1 = _rs.getString("cfparentno");
                String key2 = _rs.getString("cfpartno");
                DesignBOMBillInfo info = new DesignBOMBillInfo();
                info.setBatch(_rs.getString("cfbatch"));
                info.setPartNo(_rs.getString("cfpartno"));
                info.setParentNo(_rs.getString("cfparentno"));
                info.setName(_rs.getString("cfname"));
                info.setQuantity(_rs.getBigDecimal("CFQUANTITY"));
                info.setUnit(_rs.getString("CFUNIT"));
                info.setStruffName(_rs.getString("CFSTRUFFNAME"));
                info.setParentName(_rs.getString("CFPARENTNAME"));
                info.setProjectNo(_rs.getString("CFPROJECTNO"));
                info.setProjectName(_rs.getString("CFPROJECTNAME"));
                info.setBeginCarNo(_rs.getString("CFERPBATCHNO1ID"));
                info.setEndCarNo(_rs.getString("CFERPBATCHNO2ID"));
                versionMap.put(key1 + "@" + key2, info);
                noverkeyMap.put(_rs.getString("CFPARENTMATERCODE") + "@" + _rs.getString("CFPARTMATERCODE"), key1 + "@" + key2);
                maxMaterialVersion.put(_rs.getString("CFPARENTMATERCODE"), _rs.getString("cfparentno"));
                maxMaterialVersion.put(_rs.getString("CFPARTMATERCODE"), _rs.getString("cfpartno"));
                _mapResult.put("NOVERKEYMAP", noverkeyMap);
                _mapResult.put("VERSIONMAP", versionMap);
                _mapResult.put("MAXVERSION", maxMaterialVersion);
            }
        }
        catch (Exception ex) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0194", (Locale)ctx.getLocale()));
        }
        return _mapResult;
    }

    private Map<String, Object> convertNewDesignBomByStr(Context ctx, String tmpTableName, String pmh) throws BOSException {
        PdmEasCarnoEqualSetInfo info = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            info = this.getPDMToEASFacotry(ctx).getPdmEasCarnoEqualSetInfo("select *,EasCarno.*,Easbegintracknumber.*,Easendtracknumber.* where PDMCARNO= '" + pmh + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info == null) {
            return map;
        }
        HashMap<String, String> noverkeyMap = new HashMap<String, String>();
        HashMap<String, DesignBOMBillInfo> versionMap = new HashMap<String, DesignBOMBillInfo>();
        ProjectInfo eascarno = info.getEasCarno();
        TrackNumberInfo s_trackN = info.getEasbegintracknumber();
        TrackNumberInfo e_trackN = info.getEasendtracknumber();
        String batchnumber = info.getBatch();
        String projectid = eascarno.getId().toString();
        String easprojectcode = pmh;
        String easprojectname = info.getXMName();
        String createid = ((ObjectUuidPK)ctx.getCaller()).toString();
        String controlunitid = info.getCU().getId().toString();
        String sql = " SELECT NewBOSID('64455A59'),B.FMATNO||'.'||B.FMATVER CFPARENTNO ,  B.FNAME cfparentname,  C.FMATNO||'.'||C.FMATVER CFPARTNO ,  C.FNAME cfname, A.FUNITNAME CFUNIT, A.FQTY CFQUANTITY, C.FCMNO CFSTRUFFNAME , C.FMANAGER, 'PTC', C.FPARTTYPE, C.FMODEL,  '" + projectid + "', '" + easprojectcode + "' CFPROJECTNO, '" + easprojectname + "' CFPROJECTNAME,1 CFbeginCarNo,9999 CFendCarNo," + batchnumber + " cfbatch,1, '" + s_trackN + "', '" + e_trackN + "',0,0, '" + createid + "', '" + controlunitid + "', B.FMATNO BFMATNO, C.FMATNO CFMATNO  from " + tmpTableName + " a ,T_PLM_EAS_MaterialInfo B,T_PLM_EAS_MaterialInfo C WHERE A.FPMNO = B.FMATNO  AND A.FPMVER = B.FMATVER  AND A.FMNO = C.FMATNO  AND A.FMVER = C.FMATVER ";
        IRowSet _rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (_rs.next()) {
                DesignBOMBillInfo _info = new DesignBOMBillInfo();
                _info.setBatch(_rs.getString("cfbatch"));
                _info.setPartNo(_rs.getString("cfpartno"));
                _info.setParentNo(_rs.getString("cfparentno"));
                _info.setName(_rs.getString("cfname"));
                _info.setQuantity(_rs.getBigDecimal("CFQUANTITY"));
                _info.setUnit(_rs.getString("CFUNIT"));
                _info.setStruffName(_rs.getString("CFSTRUFFNAME"));
                _info.setParentName(_rs.getString("CFPARENTNAME"));
                _info.setProjectNo(_rs.getString("CFPROJECTNO"));
                _info.setProjectName(_rs.getString("CFPROJECTNAME"));
                _info.setBeginCarNo(s_trackN == null ? "" : s_trackN.getNumber());
                _info.setEndCarNo(e_trackN == null ? "" : e_trackN.getNumber());
                noverkeyMap.put(_rs.getString("BFMATNO") + "@" + _rs.getString("CFMATNO"), _info.getParentNo() + "@" + _info.getPartNo());
                versionMap.put(_info.getParentNo() + "@" + _info.getPartNo(), _info);
                map.put("NOVERKEYMAP", noverkeyMap);
                map.put("VERSIONMAP", versionMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    private void dealData(Context ctx, String tmpTableName, String pmh) throws BOSException {
        AbstractPdmEasCarnoEqualSetInfo info = null;
        try {
            info = this.getPDMToEASFacotry(ctx).getPdmEasCarnoEqualSetInfo("select *,EasCarno.*,Easbegintracknumber.*,Easendtracknumber.* where PDMCARNO= '" + pmh + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (info == null) {
            return;
        }
        ProjectInfo eascarno = info.getEasCarno();
        TrackNumberInfo s_trackN = info.getEasbegintracknumber();
        TrackNumberInfo e_trackN = info.getEasendtracknumber();
        String _s_trackN = s_trackN == null ? "" : s_trackN.getId().toString();
        String _e_trackN = e_trackN == null ? "" : e_trackN.getId().toString();
        String batchnumber = info.getBatch();
        String projectid = eascarno.getId().toString();
        String easprojectcode = pmh;
        String easprojectname = info.getXMName();
        String createid = ((ObjectUuidPK)ctx.getCaller()).toString();
        String controlunitid = info.getCU().getId().toString();
        String sql = " SELECT NewBOSID('64455A59'),B.FMATNO||'.'||B.FMATVER CFPARENTNO ,  B.FNAME,  C.FMATNO||'.'||C.FMATVER CFPARTNO,  C.FNAME, A.FUNITNAME, A.FQTY, C.FCMNO, C.FMANAGER, 'PTC', C.FPARTTYPE, C.FMODEL,  '" + projectid + "', '" + easprojectcode + "', '" + easprojectname + "',1,9999," + batchnumber + ",1, '" + _s_trackN + "', '" + _e_trackN + "',0,0, '" + createid + "', '" + controlunitid + "', B.FMATNO, C.FMATNO  from " + tmpTableName + " a ,T_PLM_EAS_MaterialInfo B,T_PLM_EAS_MaterialInfo C WHERE A.FPMNO = B.FMATNO  AND A.FPMVER = B.FMATVER  AND A.FMNO = C.FMATNO  AND A.FMVER = C.FMATVER ";
        String insertsql = "insert into Ct_Zjb_Designbombill( FID, CFPARENTNO,  CFPARENTNAME, CFPARTNO,  CFNAME,  CFUNIT,  CFQUANTITY,  CFSTRUFFNAME,  CFBZ,  FSOURCEBILLID,  CFCZ, CFMODEL,  CFPROJECTID,  CFPROJECTNO,  CFPROJECTNAME,  CFBEGINCARNO,  CFENDCARNO,  CFBATCH,  CFSTATE,  CFErpbatchno1ID,  CFErpbatchno2ID,  fhaseffected,  ffivouchered,  FCREATORID,  FCONTROLUNITID, CFPARENTMATERCODE, CFPARTMATERCODE) " + sql;
        DbUtil.execute((Context)ctx, (String)insertsql);
    }

    private Map<String, String[]> getTopLevelData(Context ctx, IRowSet rs) throws SQLException {
        HashMap<String, String[]> materMapVer = new HashMap<String, String[]>();
        while (rs.next()) {
            if (materMapVer.get(rs.getString("fmatno")) != null) continue;
            materMapVer.put(rs.getString("fmatno"), new String[]{rs.getString("fmatno"), rs.getString("fmatver")});
        }
        return materMapVer;
    }

    private void getDownLevelData(Context ctx, Map<String, String[]> rs, Map<String, String> materversionmap, String tempTableName) throws Exception {
        for (Map.Entry<String, String[]> entry : rs.entrySet()) {
            Object[] values = entry.getValue();
            String materialcode = values[0];
            String materialMaxversion = materversionmap.get(materialcode);
            String sql = "select FID,FPMNO,FPMVER,FMNO,FMVER,FUNITNAME,FQTY from t_plm_eas_first_ebom a where a.fpmno=? and a.fpmver=?";
            values = new String[]{materialcode, materialMaxversion};
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])values);
            if (result.size() > 0) {
                try {
                    while (result.next()) {
                        String fid = result.getString("FID");
                        String fpmno = result.getString("FPMNO");
                        String fpmver = result.getString("FPMVER");
                        String fmno = result.getString("FMNO");
                        String fmver = materversionmap.get(result.getString("FMNO"));
                        String funitname = result.getString("FUNITNAME");
                        String fqty = result.getString("FQTY");
                        String insertsql = "insert into " + tempTableName + " values('" + fid + "','" + fpmno + "','" + fpmver + "','" + fmno + "','" + fmver + "','" + funitname + "','" + fqty + "')";
                        DbUtil.execute((Context)ctx, (String)insertsql);
                        rs.clear();
                        rs.put(fpmno, new String[]{fmno, fmver});
                        this.getDownLevelData(ctx, rs, materversionmap, tempTableName);
                    }
                    continue;
                }
                catch (Exception ex) {
                    throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0199", (Locale)ctx.getLocale()));
                }
            }
            return;
        }
    }
}

