/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.clientUtil.ThrowUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.IStandardRooting;
import com.kingdee.eas.mm.basedata.IWcEngineer;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.basedata.WcEngineerFactory;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.zjbom.AbstractProcessBomBillInfo;
import com.kingdee.eas.zjbom.BOMChangeTypeEnum;
import com.kingdee.eas.zjbom.EngineeringChangeFormMaterialAssEntryInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormMaterialEntryInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormMaterialInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessAssEntryInfo;
import com.kingdee.eas.zjbom.EngineeringChangeFormProcessInfo;
import com.kingdee.eas.zjbom.IProcessBomBill;
import com.kingdee.eas.zjbom.IProcessBomChangeBill;
import com.kingdee.eas.zjbom.IProcessBomChangeBillEntry;
import com.kingdee.eas.zjbom.ProcessBomBillCollection;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillOldInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillEntryInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeBillInfo;
import com.kingdee.eas.zjbom.TypeOfChangeEnum;
import com.kingdee.eas.zjbom.app.AbstractProcessBomChangeBillFacadeControllerBean;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ProcessBomChangeBillFacadeControllerBean
extends AbstractProcessBomChangeBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.ProcessBomChangeBillFacadeControllerBean");
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";

    @Override
    protected IObjectCollection _introducingChildOfChildLayer(Context ctx, Map param) throws BOSException, EASBizException {
        BOMChangeTypeEnum lower = BOMChangeTypeEnum.lower_of_sub;
        ProcessBomChangeBillEntryCollection result = this.introducingChild(ctx, param, lower);
        if (result == null) {
            result = new ProcessBomChangeBillEntryCollection();
        }
        return result;
    }

    @Override
    protected IObjectCollection _introducingChildOfParentLayer(Context ctx, Map param) throws BOSException, EASBizException {
        BOMChangeTypeEnum lower = BOMChangeTypeEnum.lower_of_father;
        ProcessBomChangeBillEntryCollection result = this.introducingChild(ctx, param, lower);
        if (result == null) {
            result = new ProcessBomChangeBillEntryCollection();
        }
        return result;
    }

    private ProcessBomChangeBillEntryCollection introducingChild(Context ctx, Map param, BOMChangeTypeEnum lower) throws BOSException, EASBizException {
        String bomid = (String)param.get("PARAM_PBCB_PROCESSBOMBILLID");
        if (bomid == null || StringUtil.isEmpty((String)bomid.trim())) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0284", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        ProcessBomChangeBillEntryCollection result = new ProcessBomChangeBillEntryCollection();
        IProcessBomBill ipbb = ProcessBomBillFactory.getLocalInstance(ctx);
        ProcessBomBillInfo bom = ipbb.getProcessBomBillInfo("select batch,portNo,parentNo where id = '" + bomid + "'");
        if (bom == null) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0285", (Locale)ctx.getLocale()) + bomid);
            throw new EASBizException(exc);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("drawBillOrg.name"));
        sic.add(new SelectorItemInfo("storage.name"));
        sic.add(new SelectorItemInfo("getStorage.name"));
        FilterInfo filter = new FilterInfo();
        if (lower == BOMChangeTypeEnum.lower_of_father) {
            filter.getFilterItems().add(new FilterItemInfo("batch", (Object)bom.getBatch(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parentNo", (Object)bom.getParentNo(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("portNo", (Object)bom.getPortNo(), CompareType.NOTEQUALS));
        } else if (lower == BOMChangeTypeEnum.lower_of_sub) {
            filter.getFilterItems().add(new FilterItemInfo("batch", (Object)bom.getBatch(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("parentNo", (Object)bom.getPortNo(), CompareType.EQUALS));
        } else {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0286", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        ProcessBomBillCollection pbbcol = ipbb.getProcessBomBillCollection(evi);
        if (pbbcol == null || pbbcol.size() == 0) {
            return result;
        }
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBB002");
        ProcessBomChangeBillCollection pbcbcol = new ProcessBomChangeBillCollection();
        for (int i = 0; i < pbbcol.size(); ++i) {
            ProcessBomBillInfo info = pbbcol.get(i);
            ProcessBomChangeBillInfo changebom = BomBotpUtil.createBillByBOTP2(ctx, info, botInfo);
            pbcbcol.add(changebom);
        }
        if (pbcbcol == null || pbcbcol.size() == 0) {
            return result;
        }
        for (int i = 0; i < pbcbcol.size(); ++i) {
            ProcessBomChangeBillInfo pbcbinfo = pbcbcol.get(i);
            ProcessBomChangeBillEntryInfo entry = new ProcessBomChangeBillEntryInfo();
            entry.setTypeOfChange(TypeOfChangeEnum.MODIFY);
            entry.setContent(pbcbinfo);
            entry.getContent().setBomChangeType(lower);
            if (lower != BOMChangeTypeEnum.lower_of_father && lower != BOMChangeTypeEnum.lower_of_sub) {
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0286", (Locale)ctx.getLocale()));
                throw new EASBizException(exc);
            }
            result.addObject((IObjectValue)entry);
        }
        return result;
    }

    @Override
    protected IObjectCollection _saveIntroducingChildLayer(Context ctx, IObjectCollection entrys) throws BOSException, EASBizException {
        ProcessBomChangeBillEntryCollection result = new ProcessBomChangeBillEntryCollection();
        if (entrys == null || entrys.size() == 0) {
            return result;
        }
        IProcessBomChangeBillEntry ipbce = ProcessBomChangeBillEntryFactory.getLocalInstance(ctx);
        CoreBaseCollection contentUpdates = new CoreBaseCollection();
        CoreBaseCollection entryUpdates = new CoreBaseCollection();
        for (int i = 0; i < entrys.size(); ++i) {
            IObjectValue o = entrys.getObject(i);
            if (!ProcessBomChangeBillEntryInfo.class.isInstance(o)) continue;
            ProcessBomChangeBillEntryInfo entryinfo = (ProcessBomChangeBillEntryInfo)o;
            entryUpdates.add((CoreBaseInfo)entryinfo);
            ProcessBomChangeBillInfo pbc = entryinfo.getContent();
            if (pbc == null) continue;
            contentUpdates.add((CoreBaseInfo)pbc);
        }
        IProcessBomChangeBill ipbc = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        if (contentUpdates.size() > 0) {
            ipbc.save(contentUpdates);
            BomBotpUtil.saveRelations(ctx, (IObjectCollection)contentUpdates);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("content"));
        if (entryUpdates.size() > 0) {
            ipbce.save(entryUpdates);
        }
        return result;
    }

    @Override
    protected IObjectValue _createMaterialOrder(Context ctx, String id) throws BOSException, EASBizException {
        StorageOrgUnitInfo leadIn;
        SelectorItemCollection sic;
        ObjectUuidPK pk;
        IProcessBomChangeBill ipbc = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        ProcessBomChangeBillInfo info = ipbc.getProcessBomChangeBillInfo((IObjectPK)(pk = new ObjectUuidPK(id)), sic = this.getSelector());
        if (info == null) {
            ThrowUtil.showUIError((String)(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0287", (Locale)ctx.getLocale()) + id));
        }
        if ((leadIn = info.getLeadInOrgUnitEAS()) == null) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"GYBOMBGDDLYKCZZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
            ThrowUtil.showUIError((String)strInfo);
        }
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB002");
        EngineeringChangeFormMaterialInfo ecfMaterial = BomBotpUtil.createBillByBOTP2(ctx, info, botInfo);
        this.settingMatralOrder(ctx, info, ecfMaterial);
        return ecfMaterial;
    }

    private void settingMatralOrder(Context ctx, ProcessBomChangeBillInfo info, EngineeringChangeFormMaterialInfo ecfMaterial) throws EASBizException, BOSException {
        TrackNumberInfo end;
        TrackNumberInfo start;
        ProjectInfo project;
        TrackNumberCollection tracks;
        int size;
        StandardRootingInfo rooting = this.getStandardRooting(ctx, info, true);
        ecfMaterial.setStandardRooting(rooting);
        if (rooting != null) {
            ecfMaterial.setMaterial(rooting.getMaterial());
        }
        if ((size = (tracks = this.getTrackNumbers(ctx, project = info.getProjectNo(), start = info.getTrackNumberStart(), end = info.getTrackNumberEnd())).size()) > 0) {
            ecfMaterial.getAssEntrys().clear();
            for (int i = 0; i < size; ++i) {
                TrackNumberInfo track = tracks.get(i);
                EngineeringChangeFormMaterialAssEntryInfo item = new EngineeringChangeFormMaterialAssEntryInfo();
                item.setProject(project);
                item.setTrackNumber(track);
                item.setSeq(ecfMaterial.getAssEntrys().size());
                ecfMaterial.getAssEntrys().add(item);
            }
        }
        ProcessBomBillOldInfo oldprocessbom = info.getOldBom();
        size = ecfMaterial.getEntrys().size();
        if (size != 2) {
            return;
        }
        EngineeringChangeFormMaterialEntryInfo old = ecfMaterial.getEntrys().get(0);
        if (oldprocessbom == null) {
            ecfMaterial.getEntrys().removeObject((IObjectValue)old);
            return;
        }
        BigDecimal oldFixed = oldprocessbom.getRation();
        String portNo = oldprocessbom.getPortNo();
        String pts = info.getPtsNumberP();
        if (oldFixed == null || StringUtil.equalsIgnoreCase((String)portNo, (String)pts)) {
            ecfMaterial.getEntrys().removeObject((IObjectValue)old);
        } else {
            old.setAddQty(BomUtil.ZERO.subtract(oldFixed));
        }
    }

    @Override
    protected IObjectValue _createFlowOrder(Context ctx, String id) throws BOSException, EASBizException {
        StorageOrgUnitInfo supp;
        SelectorItemCollection sic;
        ObjectUuidPK pk;
        IProcessBomChangeBill ipbc = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        ProcessBomChangeBillInfo info = ipbc.getProcessBomChangeBillInfo((IObjectPK)(pk = new ObjectUuidPK(id)), sic = this.getSelector());
        if (info == null) {
            ThrowUtil.showUIError((String)(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0287", (Locale)ctx.getLocale()) + id));
        }
        if ((supp = info.getSuppliesOrgUnitEAS()) == null) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"GYBOMGDDGHKCZZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[0]);
            ThrowUtil.showUIError((String)strInfo);
        }
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_PBCB003");
        EngineeringChangeFormProcessInfo ecfProcess = BomBotpUtil.createBillByBOTP3(ctx, info, botInfo);
        this.settingProcessOrder(ctx, info, ecfProcess);
        return ecfProcess;
    }

    private void settingProcessOrder(Context ctx, ProcessBomChangeBillInfo info, EngineeringChangeFormProcessInfo ecfProcess) throws EASBizException, BOSException {
        StandardRootingInfo rooting = this.getStandardRooting(ctx, info, true);
        ecfProcess.setStandardRooting(rooting);
        ProjectInfo project = info.getProjectNo();
        TrackNumberInfo start = info.getTrackNumberStart();
        TrackNumberInfo end = info.getTrackNumberEnd();
        TrackNumberCollection tracks = this.getTrackNumbers(ctx, project, start, end);
        int size = tracks.size();
        if (size > 0) {
            ecfProcess.getAssEntrys().clear();
            for (int i = 0; i < size; ++i) {
                TrackNumberInfo track = tracks.get(i);
                EngineeringChangeFormProcessAssEntryInfo item = new EngineeringChangeFormProcessAssEntryInfo();
                item.setProject(project);
                item.setTrackNumber(track);
                item.setSeq(ecfProcess.getAssEntrys().size());
                ecfProcess.getAssEntrys().add(item);
            }
        }
    }

    private TrackNumberCollection getTrackNumbers(Context ctx, ProjectInfo project, TrackNumberInfo start, TrackNumberInfo end) throws EASBizException, BOSException {
        TrackNumberCollection result = new TrackNumberCollection();
        if (project == null || start == null || end == null || StringUtil.isEmpty((String)start.getNumber()) || StringUtil.isEmpty((String)end.getNumber())) {
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("trackNumber.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)project.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)start.getNumber(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.number", (Object)end.getNumber(), CompareType.LESS_EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo("project.number"));
        evi.getSorter().add(new SorterItemInfo("trackNumber.number"));
        ProjectCarCollection cars = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarCollection(evi);
        int size = cars.size();
        if (size == 0) {
            return result;
        }
        for (int i = 0; i < size; ++i) {
            TrackNumberInfo track = cars.get(i).getTrackNumber();
            if (track == null) continue;
            result.add(track);
        }
        return result;
    }

    private boolean checkProcessPerson(Context ctx, StorageOrgUnitInfo storage, String errorMsg) throws EASBizException, BOSException {
        UserInfo user = BomUtil.getCurrentUser(ctx);
        IWcEngineer iwe = WcEngineerFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.storageOrgUnit.id", (Object)storage.getId().toString(), CompareType.EQUALS));
        if (user.getPerson() != null) {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)user.getPerson().getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.id is null"));
        }
        if (iwe.exists(filter)) {
            return true;
        }
        if (!StringUtil.isEmpty((String)errorMsg)) {
            ThrowUtil.showUIError((String)errorMsg);
        }
        return false;
    }

    private StandardRootingInfo getStandardRooting(Context ctx, ProcessBomChangeBillInfo info, boolean phantompart) throws BOSException, EASBizException {
        StandardRootingInfo sr = null;
        AbstractProcessBomBillInfo processBom = null;
        if (phantompart) {
            processBom = this.getNotPhantompartBom(ctx, info.getProcessBom());
        }
        if (processBom == null) {
            return sr;
        }
        String materialNumber = processBom.getParentNo();
        if (StringUtils.isEmpty((String)materialNumber)) {
            return sr;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("materialRooting.*"));
        sic.add(new SelectorItemInfo("workProcess.*"));
        FilterInfo filter = new FilterInfo();
        StorageOrgUnitInfo current = ContextUtil.getCurrentStorageUnit((Context)ctx);
        if (current != null) {
            filter.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)current.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("material.number", (Object)materialNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isMainRooting", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)60, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        IStandardRooting isr = StandardRootingFactory.getLocalInstance((Context)ctx);
        StandardRootingCollection srcol = isr.getStandardRootingCollection(evi);
        if (srcol.size() > 0) {
            sr = srcol.get(0);
        }
        return sr;
    }

    private ProcessBomBillInfo getNotPhantompartBom(Context ctx, ProcessBomBillInfo processBom) throws BOSException, EASBizException {
        if (processBom == null) {
            return null;
        }
        ProcessBomBillInfo parent = this.getParentBom(ctx, processBom);
        if (parent == null || parent.getMaterialProperty() != MaterialAttributeEnum.PHANTOMPART) {
            return processBom;
        }
        return this.getNotPhantompartBom(ctx, parent);
    }

    private ProcessBomBillInfo getParentBom(Context ctx, ProcessBomBillInfo processBom) throws BOSException, EASBizException {
        if (processBom == null) {
            return null;
        }
        IProcessBomBill ipb = ProcessBomBillFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("material.number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("portNo", (Object)processBom.getParentNo(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("batch", (Object)processBom.getBatch(), CompareType.EQUALS));
        StorageOrgUnitInfo draw = processBom.getStorageOrgUnit();
        if (draw == null) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("drawBillOrg.id", (Object)draw.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)4, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(filter);
        ProcessBomBillInfo info = null;
        ProcessBomBillCollection pbCol = ipb.getProcessBomBillCollection(evi);
        if (pbCol.size() > 0) {
            info = pbCol.get(0);
        }
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pts.*"));
        sic.add(new SelectorItemInfo("pts.baseUnit.*"));
        sic.add(new SelectorItemInfo("parentPts.name"));
        sic.add(new SelectorItemInfo("parentPts.number"));
        sic.add(new SelectorItemInfo("projectNo.*"));
        sic.add(new SelectorItemInfo("trackNumberStart.*"));
        sic.add(new SelectorItemInfo("trackNumberEnd.*"));
        sic.add(new SelectorItemInfo("processBom.*"));
        sic.add(new SelectorItemInfo("oldBom.*"));
        sic.add(new SelectorItemInfo("oldBom.material.*"));
        return sic;
    }

    @Override
    protected String _createOrder(Context ctx, String id, Map param) throws BOSException, EASBizException {
        ThrowUtil.showUIError((String)EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0288", (Locale)ctx.getLocale()));
        return super._createOrder(ctx, id, param);
    }
}

