/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BOMChangeReqTypeEnum;
import com.kingdee.eas.zjbom.IProcessBomBillOld;
import com.kingdee.eas.zjbom.IProcessBomChangeReqEntry;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomBillOldFactory;
import com.kingdee.eas.zjbom.ProcessBomBillOldInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeReqCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeReqEntryCollection;
import com.kingdee.eas.zjbom.ProcessBomChangeReqEntryFactory;
import com.kingdee.eas.zjbom.ProcessBomChangeReqEntryInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeReqInfo;
import com.kingdee.eas.zjbom.app.AbstractProcessBomChangeReqControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class ProcessBomChangeReqControllerBean
extends AbstractProcessBomChangeReqControllerBean {
    private static final long serialVersionUID = -457907257074155188L;
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";

    private boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0032", (Locale)ctx.getLocale()));
    }

    private void initBaseStatus(ProcessBomChangeReqInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getBaseStatus() == null || info.getBaseStatus().getValue() < status.getValue()) {
            info.setBaseStatus(status);
        }
    }

    protected Result _addnew(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.addNewDataCheck(ctx, colls);
        return super._addnew(ctx, colls);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewDataCheck(ctx, model);
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber()) || this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        this.initBaseStatus(info);
        this.saveOldBom(ctx, info);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewDataCheck(ctx, model);
        CoreBaseInfo info = (CoreBaseInfo)model;
        BOSUuid id = info.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        info.setId(id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        this._addnew(ctx, (IObjectPK)pk, (IObjectValue)info);
        return pk;
    }

    protected IObjectPK[] _addnewBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        this.addNewDataCheck(ctx, colls);
        return super._addnewBatchData(ctx, colls);
    }

    @Override
    protected void _audit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        try {
            this.passAudit(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _unaudit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        try {
            this.unpassAudit(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _createProcessBomChangeBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Entry.*"));
        sic.add(new SelectorItemInfo("storageOrgUnit.*"));
        sic.add(new SelectorItemInfo("parentPts.*"));
        sic.add(new SelectorItemInfo("projectNo.*"));
        sic.add(new SelectorItemInfo("trackNumberStart.*"));
        sic.add(new SelectorItemInfo("trackNumberEnd.*"));
        sic.add(new SelectorItemInfo("suppliesOrgUnitEAS.*"));
        sic.add(new SelectorItemInfo("leadInOrgUnitEAS.*"));
        sic.add(new SelectorItemInfo("Entry.pts.*"));
        sic.add(new SelectorItemInfo("Entry.processBom.*"));
        ProcessBomChangeReqInfo procBomChangeReqInfo = this.getProcessBomChangeReqInfo(ctx, pk, sic);
        ProcessBomChangeBillCollection changebillcol = BomBotpUtil.createBillByBOTP(ctx, procBomChangeReqInfo, BomBotpUtil.getBOTP(ctx, "MM_PBCR001"));
        for (int j = 0; j < changebillcol.size(); ++j) {
            coll.add((CoreBaseInfo)changebillcol.get(j));
        }
        if (coll.size() > 0) {
            ProcessBomChangeBillFactory.getLocalInstance(ctx).update(coll);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._delete(ctx, pks);
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        for (IObjectPK element : arrayPK) {
            ids.add(element.toString());
        }
        this.checkAudit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(new SelectorItemInfo("entry.oldBom.id"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        ProcessBomChangeReqCollection coll = this.getProcessBomChangeReqCollection(ctx, evi);
        if (coll != null && coll.size() > 0) {
            ArrayList<ObjectUuidPK> deletePks = new ArrayList<ObjectUuidPK>();
            for (int i = 0; i < coll.size(); ++i) {
                ProcessBomChangeReqInfo info = coll.get(i);
                ProcessBomChangeReqEntryCollection ecoll = info.getEntry();
                if (ecoll == null || ecoll.size() == 0) continue;
                for (int j = 0; j < ecoll.size(); ++j) {
                    ProcessBomChangeReqEntryInfo entry = ecoll.get(j);
                    if (entry.getOldBom() == null) continue;
                    deletePks.add(new ObjectUuidPK(entry.getOldBom().getId()));
                }
            }
            if (deletePks.size() > 0) {
                IObjectPK[] pks = new IObjectPK[deletePks.size()];
                deletePks.toArray(pks);
                ProcessBomBillOldFactory.getLocalInstance(ctx).delete(pks);
            }
        }
        super._delete(ctx, arrayPK);
    }

    @Override
    protected boolean _existsChangeBill(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        ProcessBomChangeReqInfo changeReq = this.getProcessBomChangeReqInfo(ctx, "select *,Entry.processBom.* where id = '" + id.toString() + "'");
        try {
            BOMChangeReqTypeEnum type = changeReq.getBOMChangeReqType();
            if (type == BOMChangeReqTypeEnum.ADD) {
                return false;
            }
            ProcessBomBillInfo processBom = changeReq.getEntry().get(0).getProcessBom();
            ObjectUuidPK processBomPK = new ObjectUuidPK(processBom.getId());
            return ProcessBomBillFactory.getLocalInstance(ctx).existsChangeBill((IObjectPK)processBomPK);
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(BomUtil.getCurrentUser(ctx));
        info.setAuditTime(new Date());
        super._passAudit(ctx, pk, model);
        this.update(ctx, pk, (CoreBaseInfo)info);
        this.createProcessBomChangeBill(ctx, pk);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        if (ProcessBomChangeReqInfo.class.isInstance(model)) {
            ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            this.update(ctx, pk, (CoreBaseInfo)info);
        }
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ProcessBomChangeReqInfo.class.isInstance(model)) {
            ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
            if (info.getId() != null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(model.get("id").toString());
                this.checkAudit(ctx, ids, true);
            }
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        return super._submit(ctx, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        String billId = pk.toString();
        if (billId != null) {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo instInfo = null;
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            if (instInfo != null) {
                return;
            }
        }
        if ((iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx)).ifHaveDestBills(billIdString = info.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{info.getString("number")});
        }
        if (info.getId() == null) {
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super._unpassAudit(ctx, pk, model);
        this.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._update(ctx, colls);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        ProcessBomChangeReqInfo info = (ProcessBomChangeReqInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        this.saveOldBom(ctx, info);
        super._update(ctx, pk, model);
    }

    protected void addNewDataCheck(Context ctx, IObjectCollection oc) throws BOSException, EASBizException {
        if (ctx == null || oc == null) {
            return;
        }
        if (oc.size() == 0) {
            return;
        }
        ProcessBomChangeReqCollection pbcrCollection = oc instanceof ProcessBomChangeReqCollection ? (ProcessBomChangeReqCollection)oc : null;
        HashMap<String, String> pbIDMap = new HashMap<String, String>();
        ArrayList<String> pbIDList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        StringBuilder errorMessages = new StringBuilder();
        errorMessages.setLength(0);
        for (int index = 0; index < pbcrCollection.size(); ++index) {
            ProcessBomChangeReqInfo pbcrInfo = pbcrCollection.get(index);
            if (pbcrInfo == null) continue;
            String number = pbcrInfo.getNumber() == null ? "" : pbcrInfo.getNumber();
            ProcessBomChangeReqEntryCollection pbcreCollection = pbcrInfo.getEntry();
            if (pbcreCollection == null || pbcreCollection.size() == 0) continue;
            ArrayList<String> pbcrePBIDList = new ArrayList<String>();
            for (int entryIndex = 0; entryIndex < pbcreCollection.size(); ++entryIndex) {
                String pbID;
                ProcessBomBillInfo pbInfo;
                ProcessBomChangeReqEntryInfo pbcreInfo = pbcreCollection.get(index);
                if (pbcreInfo == null || (pbInfo = pbcreInfo.getProcessBom()) == null) continue;
                String string = pbID = pbInfo.getId() == null ? null : pbInfo.getId().toString();
                if (pbID == null || pbID.trim().length() == 0 || pbcrePBIDList.contains(pbID)) continue;
                pbcrePBIDList.add(pbID);
            }
            if (pbcrePBIDList.size() == 0) continue;
            for (int listIndex = 0; listIndex < pbcrePBIDList.size(); ++listIndex) {
                String pbID;
                String string = pbID = pbcrePBIDList.get(listIndex) == null ? null : pbcrePBIDList.get(listIndex).toString();
                if (pbID == null || pbID.trim().length() == 0) continue;
                if (pbIDList.contains(pbID) && pbIDMap.containsKey(pbID)) {
                    String pbcrNumber = pbIDMap.get(pbID) == null ? "" : pbIDMap.get(pbID).toString();
                    String strInfo = ResourceBase.getString((String)RESURL, (String)"BCXZDSJZYYYLXTDGY_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{number, pbcrNumber});
                    errorMessages.append(strInfo).append("\r\n");
                    continue;
                }
                pbIDList.add(pbID);
                pbIDMap.put(pbID, number);
            }
        }
        if (pbIDList.size() > 0) {
            sql.setLength(0);
            sql.append("Select ");
            sql.append("id, ");
            sql.append("seq, ");
            sql.append("parent.number, ");
            sql.append("processBom.number ");
            sql.append("Where ");
            sql.append("processBom.id In ( ");
            sql.append(SQLUtil.arrayToString((Object[])pbIDList.toArray()));
            sql.append(") ");
            sql.append("And parent.baseStatus<>").append(4).append(" ");
            ProcessBomChangeReqEntryCollection pbcreCollection = ProcessBomChangeReqEntryFactory.getLocalInstance(ctx).getProcessBomChangeReqEntryCollection(sql.toString());
            for (int index = 0; index < pbcreCollection.size(); ++index) {
                ProcessBomChangeReqEntryInfo pbcreInfo = pbcreCollection.get(index);
                if (pbcreInfo == null) continue;
                ProcessBomChangeReqInfo pbcrInfo = pbcreInfo.getParent();
                ProcessBomBillInfo pbInfo = pbcreInfo.getProcessBom();
                if (pbcrInfo == null || pbInfo == null) continue;
                String pbcrNumber = pbcrInfo.getNumber() == null ? "" : pbcrInfo.getNumber();
                String pbNumber = pbInfo.getNumber() == null ? "" : pbInfo.getNumber();
                String strInfo = ResourceBase.getString((String)RESURL, (String)"BCXZDSJZYYZXTDGY_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{pbNumber, pbcrNumber});
                errorMessages.append(strInfo).append("\r\n");
            }
        }
        if (errorMessages.toString().trim().length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0289", (Locale)ctx.getLocale()), errorMessages.toString()));
        }
    }

    protected void addNewDataCheck(Context ctx, IObjectValue ov) throws BOSException, EASBizException {
        if (ctx == null || ov == null) {
            return;
        }
        ProcessBomChangeReqCollection pbcrCollection = new ProcessBomChangeReqCollection();
        pbcrCollection.addObject(ov);
        this.addNewDataCheck(ctx, (IObjectCollection)pbcrCollection);
    }

    protected void saveOldBom(Context ctx, ProcessBomChangeReqInfo info) throws BOSException, EASBizException {
        int i;
        if (info == null) {
            return;
        }
        IProcessBomChangeReqEntry ie = ProcessBomChangeReqEntryFactory.getLocalInstance(ctx);
        ProcessBomChangeReqEntryInfo entry = null;
        IProcessBomBillOld io = ProcessBomBillOldFactory.getLocalInstance(ctx);
        StringBuffer error = new StringBuffer();
        ArrayList<String> pbIDList = new ArrayList<String>();
        int size = info.getEntry().size();
        for (i = 0; i < size; ++i) {
            String pbcEntryMaterialID;
            ProcessBomChangeReqEntryInfo entrys = info.getEntry().get(i);
            if (entrys.getPts() == null || (pbcEntryMaterialID = entrys.getPts().getId().toString()) == null) continue;
            if (pbIDList.contains(pbcEntryMaterialID) && pbIDList.contains(pbcEntryMaterialID)) {
                String pbcEntryMaterialNumber = entrys.getPts().getNumber();
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0290", (Locale)ctx.getLocale()) + "\n" + pbcEntryMaterialNumber + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0291"));
            } else {
                pbIDList.add(pbcEntryMaterialID);
            }
            if (error.length() <= 0) continue;
            throw new EASBizException(new NumericExceptionSubItem("", error.toString()));
        }
        size = info.getEntry().size();
        for (i = 0; i < size; ++i) {
            boolean updateEntry;
            entry = info.getEntry().get(i);
            boolean bl = updateEntry = entry != null && entry.getId() != null && ie.exists((IObjectPK)new ObjectUuidPK(entry.getId()));
            if (updateEntry) {
                return;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)("select FOldBomId from CT_ZJB_ProcessBCRE where FParentID = '" + info.getId() + "'"), CompareType.INNER));
            io.delete(filter);
            if (entry == null) {
                return;
            }
            ProcessBomBillOldInfo old = entry.getOldBom();
            if (old == null) {
                return;
            }
            if (old.getId() != null && io.exists((IObjectPK)new ObjectUuidPK(old.getId()))) continue;
            io.save((CoreBaseInfo)old);
        }
    }

    @Override
    public String getDesignMode(Context ctx, String portno, String drawbillorg) throws BOSException, EASBizException, RemoteException, SQLException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append("SELECT FPLANSTRATEGY,FISOLATEDRULE,FMANUFACTURESTRATEGYID ");
        sql.append(" FROM t_bd_materialplan where fmaterialid = (");
        sql.append(" SELECT fid FROM T_BD_MATERIAL where fnumber = '" + portno + "' and fstatus = '1')");
        sql.append(" and  FORGUNIT='" + drawbillorg + "'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String manufacturID = null;
        String isolatedrule = null;
        while (rs.next()) {
            manufacturID = rs.getString("FMANUFACTURESTRATEGYID");
            isolatedrule = rs.getString("FISOLATEDRULE");
        }
        sql.setLength(0);
        sql.append("SELECT fid FROM T_MM_DesignMode where fid =");
        sql.append("(SELECT fparentid FROM T_MM_DesignModeEntry where ");
        sql.append("FManufactureStrategyID = '" + manufacturID + "'");
        sql.append(" and FIsolatedRule = '" + isolatedrule + "')");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String designmodeid = null;
        while (rs.next()) {
            designmodeid = rs.getString("fid");
        }
        return designmodeid;
    }
}

