/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.BomMaterialProEnum;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProcessBomPurFixedTableReportServer
extends ReportServerBase {
    protected static final String F_TITLE = "_title";
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";
    protected final Map reportHeaderMap = new HashMap();
    public static final String group_by_flow = "_sum";
    public static final String PROJECT_ID = "PROJECT_ID";
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String TRACK_BIGEN = "TRACK_NUMBER_B";
    public static final String TRACK_END = "TRACK_NUMBER_E";
    public static final String MATERIAL_NUMBER = "MATERIAL_NUMBER";
    public static final String MATERIAL_NAME = "MATERIAL_NAME";
    public static final String MATERIAL_WARRANTNUMBER = "MATERIAL_WARRANTNUMBER";
    public static final String MATERIAL_PICTURENUMBER = "MATERIAL_PICTURENUMBER";
    public static final String MATERIAL_MATERIALCZ = "MATERIAL_MATERIALCZ";
    public static final String MATERIAL_HELPCODE = "MATERIAL_HELPCODE";
    public static final String MATERIAL_PROP = "MATERIAL_PROP";
    public static final String FIXED = "FIXED";
    public static final String WORKCENTRE_ID = "WORKCENTRE_ID";
    public static final String WORKCENTRE_NAME = "WORKCENTRE_NAME";
    public static final String MATERIAL_UNIT = "MATERIAL_UNIT";
    public static final String MATERIAL_MSPEC = "MATERIAL_MSPEC";
    public static final String BOM_MATERIAL_PROP = "BOM_MATERIAL_PROP";
    public static final String SORT_NO = "SORT_NO";
    public static final String UPDATE_RECORD = "UPDATE_RECORD";
    public static final String DEFAULT_TREASURY = "DEFAULT_TREASURY";
    public static final String ISPURREQ = "IS_PURREQ";
    public static final String PURORGUNIT = "PURORGUNIT";

    protected ReportTitles getReportTitles(String s, RptParams params) throws BaseException {
        ReportTitles titles = new ReportTitles();
        int index = 0;
        titles.AddTitle(index, params.getString("txtBatch_title"));
        titles.AddTitle(++index, params.getString("prmtProductNumber_title"));
        titles.AddTitle(++index, params.getString("fixed_title"));
        titles.AddTitle(++index, params.getString("prmtProject_title"));
        titles.AddTitle(++index, params.getString("prmtTrackBegin_title"));
        titles.AddTitle(++index, params.getString("prmtTrackEnd_title"));
        titles.AddTitle(++index, params.getString("materialSources_title"));
        titles.AddTitle(++index, params.getString("txtFlow_title"));
        titles.AddTitle(++index, params.getString("prmtPur_title"));
        titles.AddTitle(++index, params.getString("groupby_title"));
        ++index;
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        return this.getReportHeader(ctx);
    }

    private ReportHeader getReportHeader(Context ctx) {
        ReportHeader reportHeader = (ReportHeader)this.reportHeaderMap.get(ctx);
        if (reportHeader == null) {
            reportHeader = new ReportHeader();
            this.reportHeaderMap.put(ctx, reportHeader);
        }
        return reportHeader;
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        String resultSql = "";
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)resultSql.toString());
        return set;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tempTable;
        String tempTableSql = this.getTempTableSql(filter);
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        try {
            tempTable = pool.createTempTable(tempTableSql);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable error : sql is [" + tempTableSql + "]", (Throwable)e);
        }
        String indexColumns = "FID";
        try {
            pool.createIndex(tempTable, indexColumns, false, false);
            indexColumns = MATERIAL_NUMBER;
            pool.createIndex(tempTable, indexColumns, false, false);
        }
        catch (Exception e) {
            throw new BaseException("create tempTable index error : index columns is [" + indexColumns + "]", (Throwable)e);
        }
        this.insertData(tempTable, filter);
        return tempTable;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions reportFormatConditions = super.buildReportFormatConditions(reportID);
        if (reportFormatConditions == null) {
            reportFormatConditions = new ReportFormatConditions();
        }
        Appearance a = new Appearance();
        a.backColor = Color.blue;
        a.foreColor = Color.yellow;
        int condition = 6;
        reportFormatConditions.add(FIXED, condition, (Object)BigDecimal.ZERO, a, false);
        return reportFormatConditions;
    }

    protected void insertData(String tempTable, RptParams filter) throws BaseException {
        ProjectInfo project;
        MaterialInfo topMaterial;
        Context ctx = this.getContext();
        String top = filter.getString("prmtProductNumber");
        try {
            topMaterial = (MaterialInfo)MaterialFactory.getLocalInstance((Context)ctx).getValue(" where number = '" + top + "'");
        }
        catch (ObjectNotFoundException e) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"QJCWLBDCCPBCZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{top});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo), (Throwable)e);
        }
        String pro = filter.getString("prmtProject");
        try {
            project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo(" where number = '" + pro + "'");
        }
        catch (ObjectNotFoundException e) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"XMHBCZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{pro});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo + e.getMessage()), (Throwable)e);
        }
        BomTree tree = new BomTree();
        Map params = filter.toMap();
        params.put("tempTable", tempTable);
        params.put("reportHeader", this.getReportHeader(ctx));
        tree.run(ctx, project, topMaterial, params);
    }

    private String getResourceInfo(String resourceName) {
        return "";
    }

    protected String getTempTableSql(RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        StringBuilder sql = new StringBuilder();
        ReportHeader reportHeader = this.getReportHeader(ctx);
        if (reportHeader.getChildCount() > 0) {
            reportHeader.getChilds().clear();
        }
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(" FID VARCHAR(44) Not Null,\r\n");
        sql.append(MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        reportHeader.addChild(MATERIAL_NUMBER, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0229", (Locale)ctx.getLocale())).setWidth(130);
        sql.append(MATERIAL_NAME).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0294", (Locale)ctx.getLocale())).setWidth(150);
        sql.append(MATERIAL_MSPEC).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_MSPEC, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0295", (Locale)ctx.getLocale())).setWidth(100);
        sql.append(MATERIAL_UNIT).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_UNIT, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0296", (Locale)ctx.getLocale())).setWidth(60);
        sql.append(MATERIAL_MATERIALCZ).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_MATERIALCZ, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0308", (Locale)ctx.getLocale())).setWidth(100);
        sql.append(MATERIAL_WARRANTNUMBER).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_WARRANTNUMBER, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0309", (Locale)ctx.getLocale())).setWidth(100);
        sql.append(MATERIAL_PICTURENUMBER).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_PICTURENUMBER, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0310", (Locale)ctx.getLocale())).setWidth(100);
        sql.append(MATERIAL_HELPCODE).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(MATERIAL_HELPCODE, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0311", (Locale)ctx.getLocale())).setWidth(10).setVisible(false);
        String flow = filter.getString("txtFlow");
        if (flow == null) {
            flow = "";
        }
        String batch = filter.getString("txtBatch");
        sql.append(FIXED).append(" Numeric(21,8) Default 0 Not Null,\r\n");
        if (!filter.getBoolean("byFlow") && StringUtils.isEmpty((String)flow)) {
            reportHeader.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setWidth(65);
        } else {
            StringBuilder resultSql = new StringBuilder();
            resultSql.append("select distinct CFMakeFlow Flow from CT_ZJB_ProcessBomBill ");
            resultSql.append(" where CFMakeFlow like ?");
            resultSql.append(" and CFBatch = ?");
            resultSql.append(" order by CFMakeFlow");
            try {
                IRowSet set = DbUtil.executeQuery((Context)ctx, (String)resultSql.toString(), (Object[])new Object[]{"%" + flow + "%", batch});
                if (set.next()) {
                    reportHeader.addChild(group_by_flow, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setWidth(65);
                    ReportHeader child = ProcessBomPurFixedTableReportServer.getChild(reportHeader, group_by_flow);
                    child.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0297", (Locale)ctx.getLocale()));
                    int n = 1;
                    do {
                        sql.append(FIXED).append(n).append(" Numeric(21,8) Null,\r\n");
                        child.addChild(FIXED + n, set.getString("Flow"));
                        ++n;
                    } while (set.next());
                } else {
                    reportHeader.addChild(FIXED, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0256", (Locale)ctx.getLocale())).setWidth(65);
                }
            }
            catch (SQLException e) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0298", (Locale)ctx.getLocale()), (Throwable)e);
            }
        }
        sql.append(WORKCENTRE_ID).append(" VARCHAR(44) Null,\r\n");
        sql.append(WORKCENTRE_NAME).append(" NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byWorkCenter")) {
            reportHeader.addChild(WORKCENTRE_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0303", (Locale)ctx.getLocale()));
        }
        sql.append(MATERIAL_PROP).append(" INT Null,\r\n");
        sql.append(MATERIAL_PROP).append("_Alias NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byMaterialProp")) {
            reportHeader.addChild("MATERIAL_PROP_Alias", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0304", (Locale)ctx.getLocale()));
        }
        sql.append(BOM_MATERIAL_PROP).append(" VARCHAR(100) Null,\r\n");
        sql.append(BOM_MATERIAL_PROP).append("_Alias NVARCHAR(80) Null,\r\n");
        if (filter.getBoolean("byBomMaterialProp")) {
            reportHeader.addChild("BOM_MATERIAL_PROP_Alias", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0312", (Locale)ctx.getLocale()));
        }
        sql.append(FIXED).append("_CFMakeFlow NVARCHAR(500) Null,\r\n");
        reportHeader.addChild("FIXED_CFMakeFlow", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0313", (Locale)ctx.getLocale()));
        sql.append(PROJECT_ID).append(" VARCHAR(44) Null,\r\n");
        sql.append(PROJECT_NAME).append(" NVARCHAR(80) Null,\r\n");
        reportHeader.addChild(PROJECT_NAME, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0300", (Locale)ctx.getLocale()));
        sql.append(TRACK_BIGEN).append(" NVARCHAR(80) Not Null,\r\n");
        reportHeader.addChild(TRACK_BIGEN, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0301", (Locale)ctx.getLocale()));
        sql.append(TRACK_END).append(" NVARCHAR(80) Not Null,\r\n");
        reportHeader.addChild(TRACK_END, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0302", (Locale)ctx.getLocale()));
        sql.append(UPDATE_RECORD).append(" NVARCHAR(2000) Null,\r\n");
        if (filter.getBoolean("byUpdateRecord")) {
            reportHeader.addChild(UPDATE_RECORD, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0306", (Locale)ctx.getLocale()));
        }
        boolean byFlowPur = filter.getBoolean("byFlowPur");
        sql.append(ISPURREQ).append(" NVARCHAR(10) Null,\r\n");
        sql.append(PURORGUNIT).append(" NVARCHAR(80) Null,\r\n");
        if (byFlowPur) {
            reportHeader.addChild(ISPURREQ, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0314", (Locale)ctx.getLocale()));
            reportHeader.addChild(PURORGUNIT, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0315", (Locale)ctx.getLocale()));
        }
        sql.append(DEFAULT_TREASURY).append(" NVARCHAR(100) Null,\r\n");
        sql.append(SORT_NO).append(" INT Null");
        sql.append(")");
        return sql.toString();
    }

    protected static ReportHeader getChild(ReportHeader reportHeader, String fieldName) {
        ArrayList childs = reportHeader.getChilds();
        for (int i = childs.size() - 1; i >= 0; --i) {
            ReportHeader child = (ReportHeader)childs.get(i);
            if (!fieldName.equalsIgnoreCase(child.getFieldName())) continue;
            return child;
        }
        return null;
    }

    public static boolean getBoolean(Map map, String key) {
        Object bb = map.get(key);
        if (bb == null) {
            return false;
        }
        if (bb instanceof Boolean) {
            return (Boolean)bb;
        }
        return Boolean.valueOf(String.valueOf(bb));
    }

    private class BomTree
    extends ProcessBomTree {
        public static final String report_Header = "reportHeader";
        public static final String temp_Table = "tempTable";

        private BomTree() {
        }

        @Override
        protected void initTree() throws Exception {
            this.filterBatch = true;
            super.initTree();
        }

        @Override
        protected void execute(String treeTemp, Map params) throws Exception {
            Object e;
            int i;
            BigDecimal fixed;
            Integer track;
            String key;
            String id;
            IRowSet rows;
            ReportHeader flowChild;
            int f;
            int size;
            ArrayList pv;
            ArrayList flows;
            String tempTable = (String)params.get(temp_Table);
            ReportHeader reportHeader = (ReportHeader)params.get(report_Header);
            String flow = (String)params.get("txtFlow");
            if (StringUtils.isEmpty((String)flow)) {
                flow = null;
            }
            boolean byWorkCenter = ProcessBomPurFixedTableReportServer.getBoolean(params, "byWorkCenter");
            boolean byMaterialProp = ProcessBomPurFixedTableReportServer.getBoolean(params, "byMaterialProp");
            boolean byBomMaterialProp = ProcessBomPurFixedTableReportServer.getBoolean(params, "byBomMaterialProp");
            boolean byUpdateRecord = ProcessBomPurFixedTableReportServer.getBoolean(params, "byUpdateRecord");
            boolean byFlowPur = ProcessBomPurFixedTableReportServer.getBoolean(params, "byFlowPur");
            ArrayList<String> byg = new ArrayList<String>();
            StringBuilder sql = new StringBuilder();
            ArrayList<Object> paramValue = new ArrayList<Object>();
            sql.append("/*dialect*/insert into ").append(tempTable).append("(");
            sql.append(ProcessBomPurFixedTableReportServer.MATERIAL_NUMBER);
            byg.add(ProcessBomPurFixedTableReportServer.MATERIAL_NUMBER);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_NAME);
            if (byWorkCenter) {
                sql.append(",").append(ProcessBomPurFixedTableReportServer.WORKCENTRE_ID);
                sql.append(",").append(ProcessBomPurFixedTableReportServer.WORKCENTRE_NAME);
                byg.add(ProcessBomPurFixedTableReportServer.WORKCENTRE_ID);
            }
            if (byMaterialProp) {
                sql.append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_PROP);
                byg.add(ProcessBomPurFixedTableReportServer.MATERIAL_PROP);
            }
            if (byBomMaterialProp) {
                sql.append(",").append(ProcessBomPurFixedTableReportServer.BOM_MATERIAL_PROP);
                byg.add(ProcessBomPurFixedTableReportServer.BOM_MATERIAL_PROP);
            }
            if (byUpdateRecord) {
                sql.append(",").append(ProcessBomPurFixedTableReportServer.UPDATE_RECORD);
                byg.add(ProcessBomPurFixedTableReportServer.UPDATE_RECORD);
            }
            if (byFlowPur) {
                sql.append(",").append(ProcessBomPurFixedTableReportServer.ISPURREQ);
                sql.append(",").append(ProcessBomPurFixedTableReportServer.PURORGUNIT);
                byg.add(ProcessBomPurFixedTableReportServer.ISPURREQ);
                byg.add(ProcessBomPurFixedTableReportServer.PURORGUNIT);
            }
            sql.append(",").append(ProcessBomPurFixedTableReportServer.FIXED);
            ReportHeader child = ProcessBomPurFixedTableReportServer.getChild(reportHeader, ProcessBomPurFixedTableReportServer.group_by_flow);
            if (child != null) {
                flows = child.getChilds();
                pv = new ArrayList();
                size = flows.size();
                for (f = 1; f < size; ++f) {
                    flowChild = (ReportHeader)flows.get(f);
                    sql.append(",").append(flowChild.getFieldName());
                }
            }
            sql.append(",").append(ProcessBomPurFixedTableReportServer.FIXED).append("_CFMakeFlow");
            sql.append(",").append(ProcessBomPurFixedTableReportServer.PROJECT_ID);
            byg.add(ProcessBomPurFixedTableReportServer.PROJECT_ID);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.PROJECT_NAME);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.TRACK_BIGEN);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.TRACK_END);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.SORT_NO);
            sql.append(",FID) select ");
            sql.append("tree.").append("TREE_MATERIAL_NUMBER");
            sql.append(",tree.").append("TREE_MATERIAL_NAME");
            if (byWorkCenter) {
                sql.append(",storage.fid");
                sql.append(",storage.fname_l2");
            }
            if (byMaterialProp) {
                sql.append(",tree.").append("TREE_MATERIAL_PROP");
            }
            if (byBomMaterialProp) {
                sql.append(",bom.CFBomMaterialPro");
            }
            if (byUpdateRecord) {
                sql.append(",bom.CFUpdateRecord");
            }
            if (byFlowPur) {
                sql.append(",nvl(flowpur.fispurreq,'\u5426')");
                sql.append(",flowpur.fname");
            }
            sql.append(",sum(tree.").append("Expand_FIXED").append(") as ").append("Expand_FIXED");
            if (child != null) {
                flows = child.getChilds();
                pv = new ArrayList();
                size = flows.size();
                for (f = 1; f < size; ++f) {
                    flowChild = (ReportHeader)flows.get(f);
                    sql.append(",sum(");
                    sql.append("case when bom.CFMakeFlow = '").append(flowChild.getCaption()).append("'");
                    sql.append(" then tree.").append("Expand_FIXED").append(" else 0 end");
                    sql.append(")");
                }
            }
            sql.append(",wmsys.wm_concat(distinct to_char(bom.CFMakeFlow))");
            sql.append(",'").append(this.project.getId().toString()).append("'");
            sql.append(",'").append(this.project.getName()).append("'");
            sql.append(",tree.").append("TREE_TRACK_NUMBER");
            sql.append(",tree.").append("TREE_TRACK_NUMBER");
            sql.append(",min(bom.CFSortNo)");
            sql.append(",max(''||rownum)");
            StringBuilder from = new StringBuilder();
            from.append(" from ").append(treeTemp).append(" tree");
            from.append(" left join CT_ZJB_ProcessBomBill bom on bom.fid = tree.").append("TREE_BOM_ID");
            from.append(" left join T_ORG_Storage storage on storage.fid = bom.CFStorageOrgUnitID ");
            if (byFlowPur) {
                from.append(" left join (select '\u662f' fispurreq,fsce.cfflow fflow,max(pur.fnumber) fnumber,max(pur.fname_l2) fname from CT_ZJB_FlowSplitConfigEntry fsce inner join t_org_purchase pur on pur.fid = fsce.CFPURORGUNITID where fsce.cfispurreq = 1 group by fsce.cfflow,pur.fnumber,pur.fname_l2) ").append(" flowpur on flowpur.fflow = bom.CFMakeFlow");
            }
            StringBuilder where = new StringBuilder();
            where.append(" where 1=1 ");
            if (params.containsKey("prmtTrackBegin")) {
                where.append(" and tree.").append("TREE_TRACK_NUMBER").append(" >= ?");
                paramValue.add(params.get("prmtTrackBegin"));
            }
            if (params.containsKey("prmtTrackEnd")) {
                where.append(" and tree.").append("TREE_TRACK_NUMBER").append(" <= ?");
                paramValue.add(params.get("prmtTrackEnd"));
            }
            if (params.containsKey("materialSources")) {
                where.append(" and tree.").append("TREE_MATERIAL_PROP").append(" = ?");
                paramValue.add(params.get("materialSources"));
            }
            if (flow != null) {
                where.append(" and bom.CFMakeFlow like ?");
                paramValue.add("%" + flow + "%");
            }
            if (byFlowPur && params.containsKey("prmtPur")) {
                int i2;
                String prmtPur = (String)params.get("prmtPur");
                String[] purs = prmtPur.split("[,;]");
                ArrayList<String> vs = new ArrayList<String>();
                if (purs.length > 0) {
                    for (i2 = 0; i2 < purs.length; ++i2) {
                        if (StringUtils.isEmpty((String)purs[i2])) continue;
                        vs.add(purs[i2].trim());
                    }
                }
                if (vs.size() > 0) {
                    where.append(" and flowpur.fnumber in (''");
                    for (i2 = 0; i2 < vs.size(); ++i2) {
                        where.append(",?");
                        paramValue.add(vs.get(i2));
                    }
                    where.append(")");
                }
            }
            StringBuilder group = new StringBuilder();
            group.append(" group by tree.").append("TREE_MATERIAL_NUMBER").append(",tree.").append("TREE_MATERIAL_NAME");
            group.append(",tree.").append("TREE_PROJECT_ID").append(",tree.").append("TREE_TRACK_NUMBER");
            StringBuilder orderby = new StringBuilder();
            orderby.append(" order by tree.").append("TREE_MATERIAL_NUMBER");
            if (byWorkCenter) {
                group.append(",storage.fid");
                group.append(",storage.fname_l2");
            }
            if (byMaterialProp) {
                group.append(",tree.").append("TREE_MATERIAL_PROP");
            }
            if (byBomMaterialProp) {
                group.append(",bom.CFBomMaterialPro");
            }
            if (byUpdateRecord) {
                group.append(",bom.CFUpdateRecord");
            }
            if (byFlowPur) {
                group.append(",flowpur.fispurreq,flowpur.fnumber,flowpur.fname");
            }
            sql.append(from.toString());
            sql.append(where.toString());
            sql.append(group.toString());
            sql.append(orderby.toString());
            BomTree.executeUpdate(this.ctx, sql.toString(), paramValue);
            HashMap<String, BigDecimal> fixeds = new HashMap<String, BigDecimal>();
            HashMap<String, Integer> tracks = new HashMap<String, Integer>();
            HashMap<String, String> ids = new HashMap<String, String>();
            ArrayList<String> keys = new ArrayList<String>();
            sql.setLength(0);
            sql.append("select ");
            sql.append("FID");
            for (int bs = 0; bs < byg.size(); ++bs) {
                sql.append(",").append(byg.get(bs).toString());
            }
            sql.append(",").append(ProcessBomPurFixedTableReportServer.TRACK_BIGEN);
            sql.append(",").append(ProcessBomPurFixedTableReportServer.FIXED);
            sql.append(" from ").append(tempTable);
            int start = 0;
            int one_rows = 100000;
            do {
                rows = DbUtil.executeQuery((Context)ProcessBomPurFixedTableReportServer.this.getContext(), (String)sql.toString(), (int)start, (int)one_rows);
                while (rows.next()) {
                    id = rows.getString("FID");
                    if (ids.containsKey(id)) continue;
                    key = "";
                    for (int bs = 0; bs < byg.size(); ++bs) {
                        key = key + rows.getString(byg.get(bs).toString());
                        key = key + "_";
                    }
                    String t = rows.getString(ProcessBomPurFixedTableReportServer.TRACK_BIGEN);
                    key = key + "$#$" + t;
                    track = Integer.parseInt(t.substring(t.length() - 4));
                    fixed = rows.getBigDecimal(ProcessBomPurFixedTableReportServer.FIXED);
                    keys.add(key);
                    fixeds.put(key, fixed);
                    tracks.put(key, track);
                    ids.put(key, id);
                }
                start = start + one_rows + 1;
            } while (rows != null && rows.size() == one_rows);
            rows = null;
            HashSet<String> deleteids = new HashSet<String>();
            Collections.sort(keys, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            String sid = null;
            String skey = null;
            String ekey = null;
            BigDecimal sfixed = null;
            Integer strack = null;
            HashMap<String, String> setEndTracks = new HashMap<String, String>();
            for (int k = 0; k < keys.size(); ++k) {
                key = (String)keys.get(k);
                ekey = key.substring(0, key.lastIndexOf("$#$"));
                track = (Integer)tracks.get(key);
                fixed = (BigDecimal)fixeds.get(key);
                id = (String)ids.get(key);
                if (sid != null && skey.equals(ekey) && track == strack + 1 && sfixed.compareTo(fixed) == 0) {
                    deleteids.add(id);
                    setEndTracks.put(sid, id);
                    strack = track;
                    continue;
                }
                sid = id;
                skey = ekey;
                strack = track;
                sfixed = fixed;
            }
            if (setEndTracks.size() > 0) {
                sql.setLength(0);
                sql.append("update ").append(tempTable);
                sql.append(" set ").append(ProcessBomPurFixedTableReportServer.TRACK_END).append(" = (").append("select ").append(ProcessBomPurFixedTableReportServer.TRACK_END).append(" from ").append(tempTable).append(" where fid = ?").append(")");
                sql.append(" where fid = ?");
                Iterator it = setEndTracks.entrySet().iterator();
                ArrayList<Object> param = new ArrayList<Object>();
                String sql_track_end = sql.toString();
                while (it.hasNext()) {
                    Map.Entry en = it.next();
                    param.clear();
                    param.add(en.getValue());
                    param.add(en.getKey());
                    BomTree.executeUpdate(this.ctx, sql_track_end, param);
                }
            }
            if (deleteids.size() > 0) {
                Iterator it = deleteids.iterator();
                StringBuilder idstr = new StringBuilder();
                int index = 0;
                while (it.hasNext()) {
                    idstr.append(",'").append(it.next()).append("'");
                    if (++index != 1000) continue;
                    sql.setLength(0);
                    sql.append("delete ").append(tempTable).append(" where fid in (").append(idstr.substring(1)).append(")");
                    BomTree.executeUpdate(this.ctx, sql.toString(), null);
                    index = 0;
                    idstr.setLength(0);
                }
                if (idstr.length() > 0) {
                    sql.setLength(0);
                    sql.append("delete ").append(tempTable).append(" where fid in (").append(idstr.substring(1)).append(")");
                    BomTree.executeUpdate(this.ctx, sql.toString(), null);
                    index = 1;
                    idstr.setLength(0);
                }
            }
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" set ");
            sql.append(ProcessBomPurFixedTableReportServer.MATERIAL_PROP).append("_Alias = ( case ").append(ProcessBomPurFixedTableReportServer.MATERIAL_PROP);
            List ma = MaterialAttributeEnum.getEnumList();
            int size2 = ma.size();
            for (i = 0; i < size2; ++i) {
                e = (MaterialAttributeEnum)ma.get(i);
                sql.append(" when ").append("").append(e.getValue()).append(" then '").append(e.getAlias()).append("'");
            }
            sql.append(" else null end)");
            sql.append(",").append(ProcessBomPurFixedTableReportServer.BOM_MATERIAL_PROP).append("_Alias = ( case ").append(ProcessBomPurFixedTableReportServer.BOM_MATERIAL_PROP);
            ma = BomMaterialProEnum.getEnumList();
            size2 = ma.size();
            for (i = 0; i < size2; ++i) {
                e = (BomMaterialProEnum)((Object)ma.get(i));
                sql.append(" when '").append(e.getValue()).append("' then '").append(e.getAlias()).append("'");
            }
            sql.append(" else null end)");
            sql.append(",(").append(ProcessBomPurFixedTableReportServer.MATERIAL_UNIT).append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_MSPEC).append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_WARRANTNUMBER).append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_PICTURENUMBER).append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_MATERIALCZ).append(",").append(ProcessBomPurFixedTableReportServer.MATERIAL_HELPCODE).append(") = (");
            sql.append("select unit.fname_l2,material.fmodel,material.fwarrantnumber,material.fpicturenumber,material.fcz,material.fhelpcode");
            sql.append(" from T_BD_Material material left join T_BD_MeasureUnit unit on unit.fid = material.fbaseunit");
            sql.append(" where material.fnumber = ").append(tempTable).append(".").append(ProcessBomPurFixedTableReportServer.MATERIAL_NUMBER);
            sql.append(")");
            BomTree.executeUpdate(this.ctx, sql.toString(), null);
        }
    }
}

