/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.zjbom.IPurBusinessRep;
import com.kingdee.eas.zjbom.PurBusinessRepFactory;
import com.kingdee.eas.zjbom.PurBusinessRepInfo;
import com.kingdee.eas.zjbom.app.AbstractPurBusinessRepControllerBean;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PurBusinessRepControllerBean
extends AbstractPurBusinessRepControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.PurBusinessRepControllerBean");

    @Override
    protected void _setClosedStatus(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._setClosedStatus(ctx, pk);
        PurBusinessRepInfo info = this.getPurBusinessRepInfo(ctx, pk);
        info.setState(BillBaseStatusEnum.CLOSED);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurBusinessRepInfo info = (PurBusinessRepInfo)model;
        this.initBaseStatus(info);
        Date now = new Date();
        info.setCreateTime(new Timestamp(now.getTime()));
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            // empty if block
        }
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        BOSUuid id = info.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        info.setId(id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        this._addnew(ctx, (IObjectPK)pk, (IObjectValue)info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurBusinessRepInfo info = (PurBusinessRepInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            // empty if block
        }
        super._update(ctx, pk, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            // empty if block
        }
        super._save(ctx, pk, model);
    }

    private void initBaseStatus(PurBusinessRepInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getState() == null || info.getState().getValue() < status.getValue()) {
            info.setState(status);
        }
    }

    @Override
    protected void _processAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._processAudit(ctx, pk);
        PurBusinessRepInfo model = this.getPurBusinessRepInfo(ctx, pk);
        this._passAudit(ctx, pk, (IObjectValue)model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        super._passAudit(ctx, pk, model);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        PurBusinessRepInfo info = (PurBusinessRepInfo)model;
        info.setState(BillBaseStatusEnum.AUDITED);
        info.setAuditor(BomUtil.getCurrentUser(ctx));
        info.setAuditorTime(new Date());
        super._update(ctx, pk, model);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        PurBusinessRepInfo info = (PurBusinessRepInfo)model;
        info.setState(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditorTime(null);
        super._unpassAudit(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    @Override
    public boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        IPurBusinessRep issp = PurBusinessRepFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)4));
        check = issp.exists(filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0032", (Locale)ctx.getLocale()));
    }

    public boolean checkStatusValid(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.checkStatusValid(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._submit(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurBusinessRepInfo info = (PurBusinessRepInfo)model;
        info.setState(BillBaseStatusEnum.DISPOSEING);
        return super._submit(ctx, model);
    }
}

