/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.FlowSplitConfigCollection;
import com.kingdee.eas.zjbom.FlowSplitConfigEntryCollection;
import com.kingdee.eas.zjbom.FlowSplitConfigEntryInfo;
import com.kingdee.eas.zjbom.FlowSplitConfigFactory;
import com.kingdee.eas.zjbom.FlowSplitConfigInfo;
import com.kingdee.eas.zjbom.IProcessBomChangeBill;
import com.kingdee.eas.zjbom.ProcessBomBillCollection;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.ProcessBomChangeBillFactory;
import com.kingdee.eas.zjbom.SplitSingleProcessCollection;
import com.kingdee.eas.zjbom.SplitSingleProcessInfo;
import com.kingdee.eas.zjbom.app.AbstractSplitSingleProcessControllerBean;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.app.util.BomBotpUtil;
import com.kingdee.eas.zjbom.util.BomUtil;
import com.kingdee.eas.zjbom.util.BomUtilZY;
import com.kingdee.eas.zjbom.util.ToSplitSingleProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SplitSingleProcessControllerBean
extends AbstractSplitSingleProcessControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.app.SplitSingleProcessControllerBean");
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        if (SplitSingleProcessInfo.class.isInstance(model)) {
            SplitSingleProcessInfo info = (SplitSingleProcessInfo)model;
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        }
        super._submit(ctx, pk, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SplitSingleProcessInfo info = (SplitSingleProcessInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo info = (CoreBaseInfo)model;
        BOSUuid id = info.getId();
        if (id == null) {
            id = BOSUuid.create((BOSObjectType)info.getBOSType());
        }
        info.setId(id);
        ObjectUuidPK pk = new ObjectUuidPK(id);
        this._addnew(ctx, (IObjectPK)pk, (IObjectValue)info);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SplitSingleProcessInfo info = (SplitSingleProcessInfo)model;
        this.initBaseStatus(info);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, (IObjectValue)info);
        }
        super._update(ctx, pk, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        if (this.exists(ctx, "where (number is null or number = '') and id = '" + pk.toString() + "'")) {
            AutoNumberUtil.initNumber(ctx, model);
        }
        super._save(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Map<String, MaterialInfo> mapPortNo;
        IObjectPK pk = super._save(ctx, model);
        SplitSingleProcessInfo splitInfo = (SplitSingleProcessInfo)model;
        String ptsNumber = splitInfo.getPtsNumberP();
        CtrlUnitInfo ctrlInfo = splitInfo.getCU();
        String parentPspNumber = splitInfo.getParentPtsNumberP();
        String[] orgIDs = null;
        if (ctrlInfo != null) {
            orgIDs = new String[]{ctrlInfo.getId().toString()};
        }
        if (ptsNumber != null && orgIDs != null) {
            mapPortNo = BomUtilZY.queryMaterialByMaterialAndOrg(ctx, ptsNumber, null, orgIDs);
            MaterialInfo mar = mapPortNo.get(ctrlInfo.getId().toString());
            if (splitInfo.getPts() == null) {
                splitInfo.setPts(mar);
            }
        }
        if (parentPspNumber != null && orgIDs != null) {
            mapPortNo = BomUtilZY.queryMaterialByMaterialAndOrg(ctx, parentPspNumber, null, orgIDs);
            MaterialInfo marr = mapPortNo.get(ctrlInfo.getId().toString());
            if (splitInfo.getParentPts() == null) {
                splitInfo.setParentPts(marr);
            }
        }
        this._save(ctx, pk, (IObjectValue)splitInfo);
        return pk;
    }

    private void initBaseStatus(SplitSingleProcessInfo info) {
        BillBaseStatusEnum status = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (info.getBaseStatus() == null || info.getBaseStatus().getValue() < status.getValue()) {
            info.setBaseStatus(status);
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        this.checkAudit(ctx, ids, true);
        SplitSingleProcessInfo info = (SplitSingleProcessInfo)model;
        info.setId(BOSUuid.read((String)pk.toString()));
        this.setPassAuditData(ctx, info);
        super._passAudit(ctx, pk, model);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(pk.toString());
        boolean isAudit = this.checkAudit(ctx, ids, false);
        if (!isAudit) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0042", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("complete", (Object)true));
        boolean check = this.exists(ctx, filter);
        if (check) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0332", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        IProcessBomChangeBill ipb = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        boolean isc = ipb.exists("where sourceBillId = '" + pk.toString() + "'");
        if (isc) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0333", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        SplitSingleProcessInfo info = (SplitSingleProcessInfo)model;
        this.setUnPassAuditData(ctx, info);
        info.setId(BOSUuid.read((String)pk.toString()));
        super._unpassAudit(ctx, pk, (IObjectValue)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    private void setPassAuditData(Context ctx, SplitSingleProcessInfo info) {
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(BomUtil.getCurrentUser(ctx));
        info.setAuditorTime(new Date());
    }

    private void setUnPassAuditData(Context ctx, SplitSingleProcessInfo info) {
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditorTime(null);
    }

    @Override
    protected void _batchPassAudit(Context ctx, List ids) throws BOSException, EASBizException {
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
        SplitSingleProcessCollection col = this.getSplitSingleProcessCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection update = new CoreBaseCollection();
        for (int i = 0; i < col.size(); ++i) {
            SplitSingleProcessInfo info = col.get(i);
            this.setPassAuditData(ctx, info);
            update.add((CoreBaseInfo)info);
        }
        if (update.size() > 0) {
            this.update(ctx, update);
        }
    }

    @Override
    protected void _batchUnPassAudit(Context ctx, List ids) throws BOSException, EASBizException {
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
        SplitSingleProcessCollection col = this.getSplitSingleProcessCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection update = new CoreBaseCollection();
        for (int i = 0; i < col.size(); ++i) {
            SplitSingleProcessInfo info = col.get(i);
            this.setUnPassAuditData(ctx, info);
            update.add((CoreBaseInfo)info);
        }
        IProcessBomChangeBill ipb = ProcessBomChangeBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", new HashSet(ids), CompareType.INCLUDE));
        boolean isc = ipb.exists(filter);
        if (isc) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0333", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        if (update.size() > 0) {
            this.update(ctx, update);
        }
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        List<Object> ids = new ArrayList();
        ids = Arrays.asList(arrayPK);
        this.checkAudit(ctx, ids, true);
        super._delete(ctx, arrayPK);
    }

    @Override
    protected String _batchProcessSplits(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        this.checkAudit(ctx, ids, true);
        this.checkFlowHasSplit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        SplitSingleProcessCollection sspc = this.getSplitSingleProcessCollection(ctx, evi);
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_SSP002");
        CoreBaseCollection updateCol = new CoreBaseCollection();
        for (int i = 0; i < sspc.size(); ++i) {
            Object lastinfo = null;
            SplitSingleProcessInfo info = sspc.get(i);
            String flow = info.getTechnologicalFlow();
            if (StringUtils.isEmpty((String)flow)) {
                String strInfo = ResourceBase.getString((String)RESURL, (String)"QSZLCCFDDGYLCN_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            String initportNumber = info.getPtsNumberP();
            MaterialInfo initportMaterialInfo = info.getPts();
            FlowSplitConfigInfo config = this.getFlowSplitConfig(ctx, info.getTechnologicalFlow());
            FlowSplitConfigEntryCollection fscec = config.getEntry();
            int size = fscec.size();
            if (size > 0) {
                FlowSplitConfigEntryInfo entryInfo = fscec.get(0);
                info.setAfterFlow(entryInfo.getFlow());
                info.setSupplier(entryInfo.getSupplier());
                info.setGetSupplier(entryInfo.getGetSupplier());
                this.flowHasSplit(ctx, info);
                this.syncProcessWordsConfigInfo(info, entryInfo);
                if (entryInfo.getCodeRule() != null && !"".equals(entryInfo.getCodeRule())) {
                    info.setPts(null);
                    info.setPtsNumberP(initportNumber + entryInfo.getCodeRule());
                }
                updateCol.add((CoreBaseInfo)info);
            }
            if (size <= 1) continue;
            SplitSingleProcessInfo newParent = info;
            for (int c = 1; c < size; ++c) {
                SplitSingleProcessCollection sspCol = BomBotpUtil.createBillByBOTP2(ctx, info, botInfo);
                FlowSplitConfigEntryInfo entryInfo = fscec.get(c);
                SplitSingleProcessInfo nowssp = null;
                for (int j = 0; j < sspCol.size(); ++j) {
                    nowssp = sspCol.get(j);
                    if (entryInfo.getCodeRule() == null || "".equals(entryInfo.getCodeRule())) {
                        nowssp.setPts(initportMaterialInfo);
                        nowssp.setPtsNumberP(initportNumber);
                    } else {
                        nowssp.setPts(null);
                        nowssp.setPtsNumberP(initportNumber + entryInfo.getCodeRule());
                    }
                    nowssp.setPtsNameP(info.getPtsNameP());
                    nowssp.setParentPts(newParent.getPts());
                    nowssp.setParentPtsNameP(newParent.getPtsNameP());
                    nowssp.setParentPtsNumberP(newParent.getPtsNumberP());
                    nowssp.setAfterFlow(entryInfo.getFlow());
                    this.flowHasSplit(ctx, nowssp);
                    this.syncProcessWordsConfigInfo(nowssp, entryInfo);
                    updateCol.add((CoreBaseInfo)nowssp);
                }
                if (nowssp == null) continue;
                nowssp.setMaterialNameP(newParent.getMaterialNameP());
                nowssp.setMaterialNumberP(newParent.getMaterialNumberP());
                nowssp.setSupplier(entryInfo.getSupplier());
                nowssp.setGetSupplier(entryInfo.getGetSupplier());
                newParent.setMaterialNameP(null);
                newParent.setMaterialNumberP(null);
                newParent.setSupplier(entryInfo.getSupplier());
                newParent.setGetSupplier(entryInfo.getGetSupplier());
                newParent = nowssp;
            }
            if (newParent.equals(info) || info.getPtsNumberP().equals(newParent.getPtsNumberP())) continue;
            evi = new EntityViewInfo();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            evi.setSelector(sic);
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("parentPtsNumberP", (Object)initportNumber, CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("batchNo", (Object)info.getBatchNo(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("technologicalFlow is not null"));
            SplitSingleProcessCollection updateParentPts = this.getSplitSingleProcessCollection(ctx, evi);
            for (int k = 0; k < updateParentPts.size(); ++k) {
                SplitSingleProcessInfo up = updateParentPts.get(k);
                up.setParentPts(newParent.getPts());
                up.setParentPtsNameP(newParent.getPtsNameP());
                up.setParentPtsNumberP(newParent.getPtsNumberP());
                updateCol.add((CoreBaseInfo)up);
            }
        }
        if (updateCol.size() > 0) {
            for (int i = 0; i < updateCol.size(); ++i) {
                SplitSingleProcessInfo up = (SplitSingleProcessInfo)updateCol.get(i);
                ObjectUuidPK pk = new ObjectUuidPK(up.getId());
                this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)up);
            }
        }
        return super._batchProcessSplits(ctx, ids);
    }

    private boolean checkAudit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            String errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0030", (Locale)ctx.getLocale());
            if (ids.size() == 1) {
                errMsg = EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0031", (Locale)ctx.getLocale());
            }
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", errMsg);
            throw new EASBizException(exc);
        }
        return check;
    }

    private boolean checkFlowHasSplit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("flowHasSplit", (Object)true));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0247", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        FilterInfo filterOr = new FilterInfo();
        filterOr.getFilterItems().add(new FilterItemInfo("technologicalFlow is null"));
        FilterInfo filterOr2 = new FilterInfo();
        filterOr2.getFilterItems().add(new FilterItemInfo("technologicalFlow", (Object)"", CompareType.EQUALS));
        filterOr.mergeFilter(filterOr2, "or");
        filter.mergeFilter(filterOr, "and");
        boolean bl = check = check || this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0248", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        return check;
    }

    private boolean checkMaterialSplit(Context ctx, List ids, boolean throwError) throws BOSException, EASBizException {
        boolean check = false;
        if (ids == null || ids.size() == 0) {
            return check;
        }
        String idStr = this.getIdsStr(ctx, ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("materialSplit", (Object)true));
        check = this.exists(ctx, filter);
        if (check && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0249", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("flowHasSplit", (Object)false));
        boolean check2 = this.exists(ctx, filter);
        boolean bl = check = check || !check2;
        if (check2 && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0250", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        FilterInfo filterOr = new FilterInfo();
        filterOr.getFilterItems().add(new FilterItemInfo("materialNumberP is null"));
        FilterInfo filterOr2 = new FilterInfo();
        filterOr2.getFilterItems().add(new FilterItemInfo("materialNumberP", (Object)"", CompareType.EQUALS));
        filterOr.mergeFilter(filterOr2, "or");
        filter.mergeFilter(filterOr, "and");
        boolean check3 = this.exists(ctx, filter);
        boolean bl2 = check = check || !check3;
        if (check3 && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0334", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        filter = new FilterInfo();
        HashSet<Integer> materialPropSet = new HashSet<Integer>();
        materialPropSet.add(10030);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        filter.getFilterItems().add(new FilterItemInfo("materialSources", materialPropSet, CompareType.INCLUDE));
        boolean check4 = this.exists(ctx, filter);
        boolean bl3 = check = check || check4;
        if (!check4 && throwError) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0252", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        return check;
    }

    private FlowSplitConfigInfo getFlowSplitConfig(Context ctx, String flow) throws BOSException, EASBizException {
        FlowSplitConfigInfo info = null;
        FlowSplitConfigCollection fscc = FlowSplitConfigFactory.getLocalInstance(ctx).getFlowSplitConfigCollection("select *,Entry.* where FlowName = '" + flow.trim() + "' order by entry.seq");
        if (fscc.size() == 0) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"WLCDCFPZ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{flow});
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
            throw new EASBizException(exc);
        }
        info = fscc.get(0);
        return info;
    }

    @Override
    protected String _batchSplitOfRawMaterials(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        this.checkMaterialSplit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        SplitSingleProcessCollection sspc = this.getSplitSingleProcessCollection(ctx, evi);
        BOTMappingInfo botInfo = BomBotpUtil.getBOTP(ctx, "MM_SSP002");
        CoreBaseCollection updateCol = new CoreBaseCollection();
        for (int i = 0; i < sspc.size(); ++i) {
            SplitSingleProcessInfo info = sspc.get(i);
            updateCol.add((CoreBaseInfo)info);
            String flow = info.getAfterFlow();
            if (StringUtils.isEmpty((String)flow)) {
                String strInfo = ResourceBase.getString((String)RESURL, (String)"QSZLCCFDDGYLCN_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            String[] afterflow = ToSplitSingleProcess.splitProcessWordsInfo(flow);
            info.setAfterFlow(afterflow[0]);
            try {
                FlowSplitConfigInfo config = this.getFlowSplitConfig(ctx, afterflow[0]);
                if (config.getEntry() != null && config.getEntry().size() == 1) {
                    FlowSplitConfigEntryInfo entryInfo = config.getEntry().get(0);
                    this.syncProcessWordsConfigInfo(info, entryInfo);
                }
            }
            catch (Exception config) {
                // empty catch block
            }
            this.materialSplit(ctx, info);
            FlowSplitConfigEntryInfo entryInfoM = null;
            try {
                FlowSplitConfigInfo configM = this.getFlowSplitConfig(ctx, afterflow[1]);
                if (configM.getEntry() != null && configM.getEntry().size() == 1) {
                    entryInfoM = configM.getEntry().get(0);
                }
            }
            catch (Exception configM) {
                // empty catch block
            }
            SplitSingleProcessCollection sspCol = BomBotpUtil.createBillByBOTP2(ctx, info, botInfo);
            for (int j = 0; j < sspCol.size(); ++j) {
                SplitSingleProcessInfo ssp = sspCol.get(j);
                ssp.setPts(null);
                ssp.setPtsNameP(info.getMaterialNameP());
                ssp.setPtsNumberP(info.getMaterialNumberP());
                ssp.setParentPts(info.getPts());
                ssp.setParentPtsNameP(info.getPtsNameP());
                ssp.setParentPtsNumberP(info.getPtsNumberP());
                ssp.setMaterialNameP(null);
                ssp.setMaterialNumberP(null);
                ssp.setAfterFlow(afterflow[1]);
                if (entryInfoM != null) {
                    this.syncProcessWordsConfigInfo(ssp, entryInfoM);
                    this.flowHasSplit(ctx, ssp);
                }
                ssp.setTechnologicalFlow(null);
                ssp.setAfterFlow(null);
                ssp.setSuppliesOrgUnitEAS(null);
                ssp.setLeadInOrgUnitEAS(null);
                ssp.setMaterialSources(null);
                ssp.setGetSupplier(null);
                ssp.setSupplier(null);
                updateCol.add((CoreBaseInfo)ssp);
            }
            info.setMaterialNameP(null);
            info.setMaterialNumberP(null);
        }
        if (updateCol.size() > 0) {
            this.update(ctx, updateCol);
            ArrayList<BOSUuid> um = new ArrayList<BOSUuid>();
            for (int i = 0; i < updateCol.size(); ++i) {
                um.add(updateCol.get(i).getId());
            }
        }
        return super._batchSplitOfRawMaterials(ctx, ids);
    }

    private void flowHasSplit(Context ctx, SplitSingleProcessInfo info) {
        Date now = new Date();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        info.setFlowHasSplit(true);
        info.setFlowSplitTime(now);
        info.setFlowSplitUser(user);
    }

    private void materialSplit(Context ctx, SplitSingleProcessInfo info) {
        Date now = new Date();
        UserInfo user = BomUtil.getCurrentUser(ctx);
        info.setMaterialSplit(true);
        info.setMaterialSplitTime(now);
        info.setMaterialSplitUser(user);
    }

    private void syncProcessWordsConfigInfo(SplitSingleProcessInfo sspInfo, FlowSplitConfigEntryInfo entryInfo) throws BOSException, EASBizException {
        ToSplitSingleProcess.syncProcessWordsConfigInfo(sspInfo, entryInfo);
    }

    @Override
    protected void _updateMaterial(Context ctx, List ids) throws BOSException, EASBizException {
        MeasureUnitInfo unit;
        String number;
        String un;
        SplitSingleProcessInfo info;
        this.checkAudit(ctx, ids, true);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pts.number"));
        sic.add(new SelectorItemInfo("parentPts.number"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        SplitSingleProcessCollection sspCol = this.getSplitSingleProcessCollection(ctx, evi);
        int size = sspCol.size();
        if (size < 1) {
            return;
        }
        HashMap<String, MaterialInfo> materials = new HashMap<String, MaterialInfo>();
        StringBuilder sql = new StringBuilder("select fid,fnumber,fname_l2 as fname,fGroupid,fcoefficient from T_BD_MeasureUnit ");
        sql.append("where rownum = 1 ");
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            info = sspCol.get(i);
            if (!info.isFlowHasSplit()) {
                String strInfo = ResourceBase.getString((String)RESURL, (String)"LJBMWJXLCCFB_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getPtsNumberP()});
                NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
                throw new EASBizException(exc);
            }
            un = info.getUnitP();
            if (!StringUtils.isEmpty((String)un) && !params.contains(un.trim())) {
                sql.append(" or fname_l2 = ?");
                params.add(un.trim());
            }
            if (!StringUtils.isEmpty((String)(number = info.getPtsNumberP())) && !materials.containsKey(number)) {
                materials.put(number, null);
            }
            if (StringUtils.isEmpty((String)(number = info.getParentPtsNumberP())) || materials.containsKey(number)) continue;
            materials.put(number, null);
        }
        if (materials.size() == 0) {
            return;
        }
        IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
        HashMap<String, MeasureUnitInfo> units = new HashMap<String, MeasureUnitInfo>();
        try {
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            while (rows.next()) {
                unit = new MeasureUnitInfo();
                unit.setQtyPrecision(4);
                String id = rows.getString("fid");
                unit.setId(BOSUuid.read((String)id));
                unit.setNumber(rows.getString("fnumber"));
                String name = rows.getString("fname");
                unit.setName(name);
                unit.setCoefficient(rows.getBigDecimal("fcoefficient"));
                MeasureUnitGroupInfo group = new MeasureUnitGroupInfo();
                group.setId(BOSUuid.read((String)rows.getString("fGroupid")));
                unit.setMeasureUnitGroup(group);
                units.put(name.trim(), unit);
            }
            unit = (MeasureUnitInfo)units.values().toArray()[0];
        }
        catch (SQLException e) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0281", (Locale)ctx.getLocale()));
            throw new EASBizException(exc, (Throwable)e);
        }
        MaterialCollection mcol = new MaterialCollection();
        try {
            sql.setLength(0);
            params.clear();
            sql.append("select fid,fnumber,fname_l2 from T_BD_Material ");
            sql.append(" where 1 != 1");
            for (String en : materials.keySet()) {
                sql.append(" or fnumber = ?");
                params.add(en);
            }
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            while (rows.next()) {
                MaterialInfo item = new MaterialInfo();
                String id = rows.getString("fid");
                item.setId(BOSUuid.read((String)id));
                number = rows.getString("fnumber");
                item.setNumber(number);
                String name = rows.getString("fname_l2");
                item.setName(name);
                mcol.add(item);
            }
        }
        catch (SQLException e) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0282", (Locale)ctx.getLocale()));
            throw new EASBizException(exc, (Throwable)e);
        }
        int msize = mcol.size();
        if (msize != 0) {
            for (int i = 0; i < msize; ++i) {
                MaterialInfo mi = mcol.get(i);
                materials.put(mi.getNumber(), mi);
            }
        }
        UserInfo userInfo = BomUtil.getCurrentUser(ctx);
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < size; ++i) {
            String strInfo;
            MeasureUnitInfo mu;
            MaterialInfo mi;
            StorageOrgUnitInfo disPatchOrgUnitInfo;
            info = sspCol.get(i);
            Integer materialSources = info.getMaterialSources() == null ? null : Integer.valueOf(info.getMaterialSources().getValue());
            String leadInOrgUnitEASID = info.getLeadInOrgUnitEAS() == null ? null : info.getLeadInOrgUnitEAS().getId().toString();
            String suppliesOrgUnitEASID = info.getSuppliesOrgUnitEAS() == null ? null : info.getSuppliesOrgUnitEAS().getId().toString();
            number = info.getPtsNumberP();
            String fdisPatchOrgUnitId = null;
            if (info.getAfterFlow() != null && (disPatchOrgUnitInfo = FlowSplitConfigFactory.getLocalInstance(ctx).getDispatchOrgUnitInfo(info.getAfterFlow())) != null) {
                fdisPatchOrgUnitId = disPatchOrgUnitInfo.getId().toString();
            }
            if (!StringUtils.isEmpty((String)number)) {
                mi = (MaterialInfo)materials.get(number);
                if (BomUtilZY.isCheckMaterialNum(ctx, number, leadInOrgUnitEASID)) {
                    mu = unit;
                    un = info.getUnitP();
                    if (!StringUtils.isEmpty((String)un) && units.containsKey(un.trim())) {
                        mu = (MeasureUnitInfo)units.get(un.trim());
                    }
                } else {
                    strInfo = ResourceBase.getString((String)RESURL, (String)"BOM_MATERAIL_01", (Locale)ctx.getLocale(), (Object[])new Object[]{number});
                    NumericExceptionSubItem exc = new NumericExceptionSubItem("", strInfo);
                    throw new EASBizException(exc);
                }
                mi = BomUtilZY.createMaterial(ctx, number, info.getPtsNameP(), mu, null, 6, info.getSpecifications(), materialSources, leadInOrgUnitEASID, suppliesOrgUnitEASID, info.getAfterFlow(), 0, info.getCZ(), info.getRegisteredMark(), info.getWarrantNumber(), info.getPICTURENUMBER(), info.getPieceWeight(), fdisPatchOrgUnitId);
                materials.put(number, mi);
                info.setPts(mi);
            }
            if (!StringUtils.isEmpty((String)(number = info.getParentPtsNumberP()))) {
                mi = (MaterialInfo)materials.get(number);
                if (BomUtilZY.isCheckMaterialNum(ctx, number, leadInOrgUnitEASID)) {
                    mu = unit;
                    un = info.getUnitP();
                    if (!StringUtils.isEmpty((String)un) && units.containsKey(un.trim())) {
                        mu = (MeasureUnitInfo)units.get(un.trim());
                    }
                } else {
                    strInfo = ResourceBase.getString((String)RESURL, (String)"BOM_MATERAIL_01", (Locale)ctx.getLocale(), (Object[])new Object[]{number});
                    NumericExceptionSubItem exc = new NumericExceptionSubItem("", strInfo);
                    throw new EASBizException(exc);
                }
                mi = BomUtilZY.createMaterial(ctx, number, info.getParentPtsNameP(), mu, null, 6, info.getSpecifications(), materialSources, leadInOrgUnitEASID, suppliesOrgUnitEASID, info.getAfterFlow(), 0, info.getCZ(), info.getRegisteredMark(), info.getWarrantNumber(), info.getPICTURENUMBER(), info.getPieceWeight(), fdisPatchOrgUnitId);
                materials.put(number, mi);
                info.setParentPts(mi);
            }
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
    }

    private String getIdsStr(Context ctx, List ids) throws EASBizException {
        return BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
    }

    @Override
    protected void _rationCalculate(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        SplitSingleProcessCollection sspcol = this.getSplitSingleProcessCollection(ctx, evi);
        int size = sspcol.size();
        if (size == 0) {
            return;
        }
        SelectorItemCollection usic = new SelectorItemCollection();
        usic.add(new SelectorItemInfo("fixed"));
        usic.add(new SelectorItemInfo("singleFixed"));
        CoreBaseCollection update = new CoreBaseCollection();
        for (int i = 0; i < size; ++i) {
            SplitSingleProcessInfo info = sspcol.get(i);
            BigDecimal fixed = info.getFixed();
            BigDecimal singleFixed = info.getSingleFixed();
            BigDecimal sizeWidth = info.getFeedingSizeWidth();
            BigDecimal sizeLong = info.getFeedingSizeLong();
            BigDecimal useFactor = info.getUseFactor();
            BigDecimal qty = info.getAssemblyQty();
            String materialID = null;
            if (info.getPts() != null) {
                materialID = info.getPts().getId().toString();
            }
            BigDecimal mi = BomUtil.getMultiMeasureUnit(ctx, materialID);
            BigDecimal nowSingleFixed = BomUtil.calculationOfSingleFixed(singleFixed, sizeWidth, sizeLong, useFactor, mi);
            BigDecimal nowFixed = BomUtil.calculationOfFixed(fixed, nowSingleFixed, qty);
            info.setSingleFixed(nowSingleFixed);
            info.setFixed(nowFixed);
            update.add((CoreBaseInfo)info);
        }
        if (update.size() > 0) {
            this.update(ctx, update);
        }
    }

    @Override
    protected void _rationInit(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = this.getIdsStr(ctx, ids);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)idStr, CompareType.INNER));
        SplitSingleProcessCollection sspcol = this.getSplitSingleProcessCollection(ctx, evi);
        int size = sspcol.size();
        if (size == 0) {
            return;
        }
        SelectorItemCollection usic = new SelectorItemCollection();
        usic.add(new SelectorItemInfo("fixed"));
        usic.add(new SelectorItemInfo("singleFixed"));
        for (int i = 0; i < size; ++i) {
            SplitSingleProcessInfo info = sspcol.get(i);
            BigDecimal fixed = info.getFixed();
            BigDecimal singleFixed = info.getSingleFixed();
            BigDecimal sizeWidth = info.getFeedingSizeWidth();
            BigDecimal sizeLong = info.getFeedingSizeLong();
            BigDecimal useFactor = info.getUseFactor();
            BigDecimal qty = info.getAssemblyQty();
            if (!BomUtil.isEmpty(singleFixed) || !BomUtil.isEmpty(useFactor)) continue;
            singleFixed = BigDecimal.ONE;
            info.setSingleFixed(singleFixed);
            BigDecimal nowFixed = BomUtil.calculationOfFixed(fixed, singleFixed, qty);
            info.setFixed(nowFixed);
            this.updatePartial(ctx, (CoreBaseInfo)info, usic);
        }
    }

    protected SplitSingleProcessInfo _rationCopy(Context ctx, SplitSingleProcessInfo info) throws BOSException, EASBizException {
        if (info.getSingleFixed() != null) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0337", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        if (info.getPts() == null || info.getParentPts() == null) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0338", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        if (info.getPts().getNumber().matches("^\\d.*$")) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0339", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getPts().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("parentNo", (Object)info.getParentPts().getNumber()));
        evi.setSorter(new SorterItemCollection());
        SorterItemInfo sorter = new SorterItemInfo("createTime");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        evi.setTopCount(1);
        ProcessBomBillCollection lastInfos = ProcessBomBillFactory.getLocalInstance(ctx).getProcessBomBillCollection(evi);
        ProcessBomBillInfo lastInfo = null;
        if (lastInfos == null || lastInfos.size() != 1) {
            NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0340", (Locale)ctx.getLocale()));
            throw new EASBizException(exc);
        }
        lastInfo = lastInfos.get(0);
        BigDecimal singleFixed = lastInfo.getRationUnit();
        BigDecimal sizeWidth = lastInfo.getSizeWidth();
        BigDecimal sizeLong = lastInfo.getSizeLength();
        BigDecimal useFactor = lastInfo.getUsingRate();
        CoreBaseCollection updates = new CoreBaseCollection();
        boolean up = false;
        if (!BomUtil.isEmpty(singleFixed) && BomUtil.isEmpty(info.getSingleFixed())) {
            info.setSingleFixed(singleFixed);
            up = true;
        }
        if (!BomUtil.isEmpty(sizeLong) && BomUtil.isEmpty(info.getFeedingSizeLong())) {
            info.setFeedingSizeLong(sizeLong);
            up = true;
        }
        if (!BomUtil.isEmpty(sizeWidth) && BomUtil.isEmpty(info.getFeedingSizeWidth())) {
            info.setFeedingSizeWidth(sizeWidth);
            up = true;
        }
        if (!BomUtil.isEmpty(useFactor) && BomUtil.isEmpty(info.getUseFactor())) {
            info.setUseFactor(useFactor);
            up = true;
        }
        if (up) {
            return info;
        }
        String strInfo = ResourceBase.getString((String)RESURL, (String)"GYBOMMYKGFZSJ_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{lastInfo.getNumber()});
        NumericExceptionSubItem exc = new NumericExceptionSubItem("Src_id_Exsit", strInfo);
        throw new EASBizException(exc);
    }

    @Override
    protected String _rationCopy(Context ctx, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("pts.number"));
        sic.add(new SelectorItemInfo("parentPts.number"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(sic);
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        SplitSingleProcessCollection infos = this.getSplitSingleProcessCollection(ctx, evi);
        CoreBaseCollection updates = new CoreBaseCollection();
        StringBuilder error = new StringBuilder();
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            SplitSingleProcessInfo info = infos.get(i);
            try {
                info = this._rationCopy(ctx, info);
                updates.add((CoreBaseInfo)info);
                continue;
            }
            catch (EASBizException e) {
                error.append(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0263", (Locale)ctx.getLocale())).append(info.getNumber()).append(" \uff1a");
                error.append(e.getMessage());
                error.append("\n");
                ids.remove(info.getId().toString());
            }
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
            this._rationCalculate(ctx, ids);
        }
        if (error.length() > 0) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"SXXTJLFZDDSBRX_INFO", (Locale)ctx.getLocale(), (Object[])new Object[]{infos.size()});
            error.insert(0, strInfo + "\n");
            return error.toString();
        }
        return EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0341", (Locale)ctx.getLocale());
    }

    @Override
    protected String _queryRepeat(Context ctx, HashMap rptMap) throws BOSException, EASBizException {
        String batch = (String)rptMap.get("batch");
        StringBuffer strBuf = new StringBuffer();
        String sql = " select fid from  CT_ZJB_SplitSingleProcess a inner join    ( select CFBatchNo,CFPtsNumberP,CFParentPtsNumberP,CFTechnologicalFlow,fprojectNo,ftrackNumberStart,ftrackNumberEnd       from CT_ZJB_SplitSingleProcess       where CFBatchNo='" + batch + "'      group by CFBatchNo,CFPtsNumberP,CFParentPtsNumberP,CFTechnologicalFlow,fprojectNo,ftrackNumberStart,ftrackNumberEnd       having count(fid)>1) b       on a.CFBatchNo=b.CFBatchNo and a.CFPtsNumberP=b.CFPtsNumberP       and a.CFParentPtsNumberP=b.CFParentPtsNumberP and a.CFTechnologicalFlow=b.CFTechnologicalFlow      and ISNULL(a.fprojectNo,' ')=ISNULL(b.fprojectNo,' ')       and ISNULL(a.ftrackNumberStart,' ') = ISNULL(b.ftrackNumberStart,' ')      and ISNULL(a.ftrackNumberEnd,' ') = ISNULL(b.ftrackNumberEnd,' ')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                strBuf.append(rs.getString("fid"));
                strBuf.append(",");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }

    @Override
    protected String _deleteRepeat(Context ctx, List idList, String operate) throws BOSException, EASBizException {
        super._deleteRepeat(ctx, idList, operate);
        int rowNum = 0;
        String deleteSql = null;
        try {
            IRowSet rs = null;
            String sql1 = "select a.CFPtsNumberP,a.CFParentPtsNumberP,a.fprojectNo,b.fid from CT_ZJB_SplitSingleProcess a    inner join CT_ZJB_SplitSingleProcess b  on a.CFBatchNo=b.CFBatchNo and a.CFPtsNumberP=b.CFPtsNumberP  and a.CFParentPtsNumberP=b.CFParentPtsNumberP and a.CFTechnologicalFlow=b.CFTechnologicalFlow and ISNULL(a.fprojectNo,' ')=ISNULL(b.fprojectNo,' ')  and ISNULL(a.ftrackNumberStart,' ') = ISNULL(b.ftrackNumberStart,' ') and ISNULL(a.ftrackNumberEnd,' ') = ISNULL(b.ftrackNumberEnd,' ') and b.fid <> ? where a.fid= ? order by b.CFSeq desc";
            String sql2 = "select a.CFPtsNumberP,a.CFParentPtsNumberP,a.fprojectNo,b.fid from CT_ZJB_SplitSingleProcess a    inner join CT_ZJB_SplitSingleProcess b   on a.CFBatchNo=b.CFBatchNo and a.CFPtsNumberP=b.CFPtsNumberP  and a.CFParentPtsNumberP=b.CFParentPtsNumberP and a.CFTechnologicalFlow=b.CFTechnologicalFlow and ISNULL(a.fprojectNo,' ')=ISNULL(b.fprojectNo,' ')  and ISNULL(a.ftrackNumberStart,' ') = ISNULL(b.ftrackNumberStart,' ') and ISNULL(a.ftrackNumberEnd,' ') = ISNULL(b.ftrackNumberEnd,' ') where a.fid=? order by b.CFSeq desc";
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                if ("Check".equals(operate)) {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new Object[]{idList.get(i), idList.get(i)});
                    if (!rs.next()) continue;
                    ++rowNum;
                    continue;
                }
                rs = DbUtil.executeQuery((Context)ctx, (String)sql2, (Object[])new Object[]{idList.get(i)});
                if (rs.size() <= 1) continue;
                rs.next();
                String fid = rs.getString("fid");
                deleteSql = "delete CT_ZJB_SplitSingleProcess where fid=?";
                DbUtil.execute((Context)ctx, (String)deleteSql, (Object[])new Object[]{fid});
                ++rowNum;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return String.valueOf(rowNum);
    }

    @Override
    protected void _batchUnlock(Context ctx, List ids) throws BOSException, EASBizException {
        super._batchUnlock(ctx, ids);
    }

    @Override
    protected String _batchUpdateSeq(Context ctx, HashMap parmMap, List ids) throws BOSException, EASBizException {
        this.checkAudit(ctx, ids, true);
        String idStr = BomUtil.getIdsStr(ids, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0258", (Locale)ctx.getLocale()));
        String batchNo = (String)parmMap.get("batchNo");
        SplitSingleProcessCollection infos = this.getSplitSingleProcessCollection(ctx, "select id where id in (" + idStr + ")");
        CoreBaseCollection updates = new CoreBaseCollection();
        for (int i = 0; i < infos.size(); ++i) {
            SplitSingleProcessInfo info = infos.get(i);
            info.setBatchNo(batchNo);
            updates.add((CoreBaseInfo)info);
        }
        if (updates.size() > 0) {
            this.update(ctx, updates);
        }
        return idStr;
    }

    @Override
    protected String _batchUpdate(Context ctx, Map parmMap) throws BOSException, EASBizException {
        ArrayList tempList = (ArrayList)parmMap.get("list");
        String model = (String)parmMap.get("model");
        if (model != null && !model.equals("")) {
            for (int i = 0; i < tempList.size(); ++i) {
                Map tempMap = (Map)tempList.get(i);
                String id = (String)tempMap.get("id");
                String updateSql = "update CT_ZJB_SplitSingleProcess set FDesignModeID = '" + model + "' where fid = '" + id + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        return null;
    }
}

