/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app.tree;

import com.kingdee.eas.zjbom.app.tree.MaterialInfoEntity;
import com.kingdee.eas.zjbom.app.tree.TreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TreeHelper {
    private TreeNode root;
    private List<TreeNode> tempNodeList;
    private boolean isValidTree = true;

    public TreeHelper() {
    }

    public TreeHelper(List<TreeNode> treeNodeList) {
        this.tempNodeList = treeNodeList;
        this.generateTree();
    }

    public static TreeNode getTreeNodeById(TreeNode tree, int id) {
        if (tree == null) {
            return null;
        }
        TreeNode treeNode = tree.findTreeNodeById(id);
        return treeNode;
    }

    public void generateTree() {
        HashMap nodeMap = this.putNodesIntoMap();
        this.putChildIntoParent(nodeMap);
    }

    protected HashMap putNodesIntoMap() {
        int maxId = Integer.MAX_VALUE;
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>();
        for (TreeNode treeNode : this.tempNodeList) {
            int id = treeNode.getSelfId();
            if (id < maxId) {
                maxId = id;
                this.root = treeNode;
            }
            String keyId = String.valueOf(id);
            nodeMap.put(keyId, treeNode);
        }
        return nodeMap;
    }

    protected void putChildIntoParent(HashMap nodeMap) {
        for (TreeNode treeNode : nodeMap.values()) {
            int parentId = treeNode.getParentId();
            String parentKeyId = String.valueOf(parentId);
            if (!nodeMap.containsKey(parentKeyId)) continue;
            TreeNode parentNode = (TreeNode)nodeMap.get(parentKeyId);
            if (parentNode == null) {
                this.isValidTree = false;
                return;
            }
            parentNode.addChildNode(treeNode);
        }
    }

    protected void initTempNodeList() {
        if (this.tempNodeList == null) {
            this.tempNodeList = new ArrayList<TreeNode>();
        }
    }

    public void addTreeNode(TreeNode treeNode) {
        this.initTempNodeList();
        this.tempNodeList.add(treeNode);
    }

    public boolean insertTreeNode(TreeNode treeNode) {
        boolean insertFlag = this.root.insertJuniorNode(treeNode);
        return insertFlag;
    }

    public static List<TreeNode> changeEnititiesToTreeNodes(List<MaterialInfoEntity> entityList) {
        MaterialInfoEntity orgEntity2 = new MaterialInfoEntity();
        ArrayList<TreeNode> tempNodeList = new ArrayList<TreeNode>();
        for (MaterialInfoEntity orgEntity2 : entityList) {
            TreeNode treeNode = new TreeNode();
            treeNode.setObj(orgEntity2);
            treeNode.setParentId(orgEntity2.getParentId());
            treeNode.setSelfId(orgEntity2.getId());
            treeNode.setNodeName(orgEntity2.getMaterialName());
            tempNodeList.add(treeNode);
        }
        return tempNodeList;
    }

    public boolean isValidTree() {
        return this.isValidTree;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        this.root = root;
    }

    public List<TreeNode> getTempNodeList() {
        return this.tempNodeList;
    }

    public void setTempNodeList(List<TreeNode> tempNodeList) {
        this.tempNodeList = tempNodeList;
    }
}

