/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class BOMTreeUtil {
    public static final String FID = "F_ID";
    public static final String FLEVEL = "F_LEVEL";
    public static final String FBOMID = "F_BOMID";
    public static final String FBOMENTRYID = "F_BOMENTRYID";
    public static final String FPARENTID = "F_PARENTID";
    public static final String FMaterialID = "F_MaterialID";
    public static final String FMaterialNumber = "F_MaterialNumber";
    public static final String FMaterialProp = "F_MaterialProp";
    public static final String FParentMaterialID = "F_ParentMaterialID";
    public static final String FProductID = "F_ProductID";
    public static final String FProductNumber = "F_ProductNumber";
    public static final String FProjectID = "F_ProjectID";
    public static final String FTrackID = "F_TrackID";
    public static final String FTrackNumber = "F_TrackNumber";
    public static final String FSTrackID = "F_STrackID";
    public static final String FSTrackNumber = "F_STrackNumber";
    public static final String FETrackID = "F_ETrackID";
    public static final String FETrackNumber = "F_ETrackNumber";
    public static final String FParentConsumeFixQTY = "F_ParentConsumeFixQTY";
    public static final String FConsumeFixQTY = "F_ConsumeFixQTY";
    public static final String FConsumeQty = "F_ConsumeQty";
    public static final String FTREE_LONG_NUMBER = "TREE_LONG_NUMBER";
    public static final String FISLEAF = "F_ISLEAF";
    private Context ctx;
    private String treeTable;
    private int level = 0;
    private ProjectCollection projects;
    private TrackNumberCollection tracks;
    private TrackNumberInfo track;
    private MaterialCollection materials;
    private Map params = new HashMap();
    private boolean stopVirtual = false;
    public static final String param_stopVirtual = "param_stopVirtual";
    public static final String param_project = "param_project";
    public static final String param_track = "param_track";
    public static final String param_trackno = "param_trackno";
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";
    public static final String[] columns = new String[]{"F_ID", "F_LEVEL", "F_BOMID", "F_BOMENTRYID", "F_PARENTID", "F_MaterialID", "F_MaterialProp", "F_ParentMaterialID", "F_ProjectID", "F_TrackID", "F_TrackNumber", "F_STrackID", "F_STrackNumber", "F_ETrackID", "F_ETrackNumber", "F_ParentConsumeFixQTY", "F_ConsumeFixQTY", "F_ConsumeQty", "TREE_LONG_NUMBER"};

    protected final int getLevel() {
        return this.level;
    }

    protected final String getTreeTable() {
        return this.treeTable;
    }

    public static String designBomTree() {
        return null;
    }

    protected abstract void execute(String var1, Map var2) throws Exception;

    protected void initTree() throws EASBizException, BOSException {
        Object o;
        if (this.params.containsKey(param_stopVirtual)) {
            this.stopVirtual = Boolean.parseBoolean(this.params.get(param_stopVirtual).toString());
        }
        if (this.params.containsKey(param_project)) {
            o = this.params.get(param_project);
            if (ProjectInfo.class.isInstance(o)) {
                this.projects.add((ProjectInfo)o);
            } else if (ProjectCollection.class.isInstance(o)) {
                this.projects.addCollection((ProjectCollection)o);
            }
        }
        if (this.params.containsKey(param_track)) {
            o = this.params.get(param_track);
            if (TrackNumberInfo.class.isInstance(o)) {
                this.tracks.add((TrackNumberInfo)o);
            } else if (TrackNumberCollection.class.isInstance(o)) {
                this.tracks.addCollection((TrackNumberCollection)o);
            }
        }
        if (this.params.containsKey(param_trackno)) {
            o = this.params.get(param_trackno);
            this.track = TrackNumberInfo.class.isInstance(o) ? (TrackNumberInfo)o : null;
        }
        this.treeTable = ProcessBomTree.createTempTable(this.ctx, this.getExpandBOMSql());
        this.insertExpandBOM();
    }

    public final void run(Context ctx, MaterialCollection materials, Map params) throws EASBizException {
        if (ctx == null) {
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0003", (Locale)ctx.getLocale())));
        }
        this.projects = new ProjectCollection();
        this.materials = materials;
        this.tracks = new TrackNumberCollection();
        this.ctx = ctx;
        if (params != null) {
            this.params.putAll(params);
        }
        try {
            this.initTree();
            this.execute(this.treeTable, this.params);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0004", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
        }
        finally {
            ProcessBomTree.releaseTable(ctx, this.treeTable);
        }
    }

    public final void run(Context ctx, MaterialInfo material, Map params) throws EASBizException {
        MaterialCollection mc = new MaterialCollection();
        mc.add(material);
        this.run(ctx, mc, params);
    }

    protected String getExpandBOMSql() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(FID).append(" NVARCHAR(200) Not Null,\r\n");
        sql.append(FLEVEL).append(" INT Not Null,\r\n");
        sql.append(FBOMID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FBOMENTRYID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FPARENTID).append(" NVARCHAR(200) Null,\r\n");
        sql.append(FMaterialProp).append(" INT Default ").append(10060).append(" Not Null,\r\n");
        sql.append(FMaterialID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FMaterialNumber).append(" VARCHAR(100) Null,\r\n");
        sql.append(FParentMaterialID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FProductID).append(" VARCHAR(44) Null,\r\n");
        sql.append(FProductNumber).append(" VARCHAR(100) Null,\r\n");
        sql.append(FProjectID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(FTrackID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(FTrackNumber).append(" NVARCHAR(80)  Null,\r\n");
        sql.append(FSTrackID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(FSTrackNumber).append(" NVARCHAR(80)  Null,\r\n");
        sql.append(FETrackID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(FETrackNumber).append(" NVARCHAR(80)  Null,\r\n");
        sql.append(FParentConsumeFixQTY).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(FConsumeFixQTY).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(FConsumeQty).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append("FSupplyStorageOrgUnitID VARCHAR(44) Not Null,\r\n");
        sql.append("FStorageOrgUnitID VARCHAR(44) Not Null,\r\n");
        sql.append(FTREE_LONG_NUMBER).append(" VARCHAR(4000) Not Null,");
        sql.append(FISLEAF).append(" INT Default 0 Not Null");
        sql.append(")");
        return sql.toString();
    }

    protected void insertExpandBOM() throws BOSException, EASBizException {
        String materialids;
        String trackids;
        this.level = 1;
        StringBuffer sqlStr = new StringBuffer();
        ArrayList param = new ArrayList();
        this.getInsertSql(sqlStr, param, this.level);
        String projectids = this.getProjectIds();
        if (projectids != null && !"".equals(projectids.trim())) {
            sqlStr.append(" and t.fprojectid in (").append(projectids).append(")");
        }
        if ((trackids = this.getTrackIds()) != null && !"".equals(trackids.trim())) {
            sqlStr.append(" and track.fid in (").append(trackids).append(")");
        }
        if (this.track != null && this.track.getNumber() != null) {
            sqlStr.append(" and stn.fnumber <='").append(this.track.getNumber().toString()).append("' ");
            sqlStr.append(" and etn.fnumber >='").append(this.track.getNumber().toString()).append("' ");
        }
        if ((materialids = this.getMaterialIds()) != null && !"".equals(materialids.trim())) {
            sqlStr.append(" and t.fmaterialid in (").append(materialids).append(")");
        } else {
            sqlStr.append(" and not exists (").append("select ee.fid from T_MM_BomEntry ee left join T_MM_Bom bb on bb.fid = ee.fparentid where bb.fprojectid = t.fprojectid and t.fmaterialid = ee.fmaterialid").append(")");
        }
        int no = DBUtil.executeUpdate((Context)this.ctx, (String)sqlStr.toString(), (Object[])param.toArray());
        while (no != 0) {
            if (this.level == 50) {
                String strInfo = ResourceBase.getString((String)RESURL, (String)"ZZBOMSZKCGC_INFO", (Locale)this.ctx.getLocale(), (Object[])new Object[]{this.level});
                throw new EASBizException(new NumericExceptionSubItem("id_error", strInfo));
            }
            this.checkRepeat(this.level);
            if (!this.afterAddData(this.level)) break;
            ++this.level;
            sqlStr.setLength(0);
            param.clear();
            this.getInsertSql(sqlStr, param, this.level);
            no = this.executeUpdate(sqlStr.toString(), param);
        }
        --this.level;
        param.clear();
        this.executeUpdate("update " + this.treeTable + " st set " + FISLEAF + " = 1  where not exists ( select " + FID + " from " + this.treeTable + " tt where tt." + FPARENTID + " = st." + FID + " )", param);
    }

    protected boolean afterAddData(int l) throws BOSException, EASBizException {
        return true;
    }

    protected void checkRepeat(int l) throws BOSException, EASBizException {
        String checkSql1 = "select distinct";
        checkSql1 = checkSql1 + " temp.F_TrackNumber";
        checkSql1 = checkSql1 + ",temp.F_MaterialNumber";
        checkSql1 = checkSql1 + ",temp.TREE_LONG_NUMBER";
        checkSql1 = checkSql1 + ",temp.F_STrackID";
        checkSql1 = checkSql1 + ",temp.F_ETrackNumber";
        checkSql1 = checkSql1 + " from " + this.treeTable + " temp";
        checkSql1 = checkSql1 + " where temp.F_LEVEL = ?";
        checkSql1 = checkSql1 + " group by temp.F_TrackNumber,temp.TREE_LONG_NUMBER,temp.F_MaterialNumber,temp.F_STrackID,temp.F_ETrackNumber";
        checkSql1 = checkSql1 + " having count(1) > 1";
        checkSql1 = checkSql1 + " order by temp.F_TrackNumber,temp.TREE_LONG_NUMBER";
        String checkSql2 = "select ";
        checkSql2 = checkSql2 + " temp.F_TrackNumber";
        checkSql2 = checkSql2 + ",temp.F_MaterialNumber";
        checkSql2 = checkSql2 + ",temp.TREE_LONG_NUMBER";
        checkSql2 = checkSql2 + " from " + this.treeTable + " temp";
        checkSql2 = checkSql2 + " where temp.F_LEVEL = ?";
        checkSql2 = checkSql2 + " and temp.TREE_LONG_NUMBER like CONCAT('%',CONCAT(temp.F_MaterialNumber,'!!%') )";
        checkSql2 = checkSql2 + " order by temp.F_TrackNumber,temp.TREE_LONG_NUMBER";
        StringBuilder error = new StringBuilder();
        IRowSet rows = DBUtil.executeQuery((Context)this.ctx, (String)checkSql1, (Object[])new Object[]{l});
        try {
            while (rows.next()) {
                error.append(rows.getString(FTrackNumber)).append("   ");
                error.append(rows.getString(FSTrackID)).append("   ");
                error.append(rows.getString(FETrackNumber)).append("   ");
                error.append(rows.getString(FTREE_LONG_NUMBER).replaceAll("!!", " \u2192 "));
                error.append("\n");
            }
        }
        catch (SQLException e) {
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0005", (Locale)this.ctx.getLocale())).append("\n");
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0006", (Locale)this.ctx.getLocale()) + e.getMessage() + "\n");
            throw new EASBizException(new NumericExceptionSubItem("", error.toString()), (Throwable)e);
        }
        if (error.length() > 0) {
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0005", (Locale)this.ctx.getLocale())).append("\n");
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0007", (Locale)this.ctx.getLocale())).append("\n");
            throw new EASBizException(new NumericExceptionSubItem("", error.toString()));
        }
        rows = DBUtil.executeQuery((Context)this.ctx, (String)checkSql2, (Object[])new Object[]{l});
        try {
            while (rows.next()) {
                error.append(rows.getString(FTrackNumber)).append("   ");
                error.append(rows.getString(FTREE_LONG_NUMBER).replaceAll("!!", " \u2192 "));
                error.append("\n");
            }
        }
        catch (SQLException e) {
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0005", (Locale)this.ctx.getLocale())).append("\n");
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0008", (Locale)this.ctx.getLocale()) + e.getMessage() + "\n");
            throw new EASBizException(new NumericExceptionSubItem("", error.toString()), (Throwable)e);
        }
        if (error.length() > 0) {
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0005", (Locale)this.ctx.getLocale())).append("\n");
            error.insert(0, EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0009", (Locale)this.ctx.getLocale())).append("\n");
            throw new EASBizException(new NumericExceptionSubItem("", error.toString()));
        }
    }

    protected String getInsertSql(StringBuffer sqlStr, List param, int l) {
        boolean isFirst = l == 1;
        sqlStr.append("insert into ").append(this.treeTable).append(" (");
        sqlStr.append(FID);
        sqlStr.append(",").append(FLEVEL);
        sqlStr.append(",").append(FBOMID);
        sqlStr.append(",").append(FBOMENTRYID);
        sqlStr.append(",").append(FPARENTID);
        sqlStr.append(",").append(FMaterialProp);
        sqlStr.append(",").append(FMaterialID);
        sqlStr.append(",").append(FMaterialNumber);
        sqlStr.append(",").append(FParentMaterialID);
        sqlStr.append(",").append(FProductID);
        sqlStr.append(",").append(FProductNumber);
        sqlStr.append(",").append(FProjectID);
        sqlStr.append(",").append(FTrackID);
        sqlStr.append(",").append(FTrackNumber);
        sqlStr.append(",").append(FSTrackID);
        sqlStr.append(",").append(FSTrackNumber);
        sqlStr.append(",").append(FETrackID);
        sqlStr.append(",").append(FETrackNumber);
        sqlStr.append(",").append(FParentConsumeFixQTY);
        sqlStr.append(",").append(FConsumeFixQTY);
        sqlStr.append(",").append(FConsumeQty);
        sqlStr.append(",").append(FTREE_LONG_NUMBER);
        sqlStr.append(",FSupplyStorageOrgUnitID");
        sqlStr.append(",FStorageOrgUnitID");
        sqlStr.append(") select ");
        sqlStr.append(" '").append(l).append("-'||rownum");
        sqlStr.append(",").append(l);
        sqlStr.append(",t.fid");
        sqlStr.append(",e.fid");
        if (isFirst) {
            sqlStr.append(",null");
        } else {
            sqlStr.append(",temp2.").append(FID);
        }
        sqlStr.append(",e.FMaterialProp");
        sqlStr.append(",e.fmaterialid");
        sqlStr.append(",em.fnumber");
        sqlStr.append(",t.fmaterialid");
        if (isFirst) {
            sqlStr.append(",tm.fid");
            sqlStr.append(",tm.fnumber");
        } else {
            sqlStr.append(",(case when temp2.").append(FMaterialProp).append(" = ").append(10020).append(" then temp2.").append(FProductID).append(" else tm.fid end ) as ").append(FProductID);
            sqlStr.append(",(case when temp2.").append(FMaterialProp).append(" = ").append(10020).append(" then temp2.").append(FProductNumber).append(" else to_char(tm.fnumber) end) as ").append(FProductNumber);
        }
        sqlStr.append(",t.fprojectid");
        sqlStr.append(",track.fid");
        sqlStr.append(",track.fnumber");
        sqlStr.append(",stn.fid");
        sqlStr.append(",stn.fnumber");
        sqlStr.append(",etn.fid");
        sqlStr.append(",etn.fnumber");
        if (isFirst) {
            sqlStr.append(",1");
            sqlStr.append(",isnull(e.FConsumeFixQTY,0)");
            sqlStr.append(",isnull(e.FConsumeFixQTY,0)");
            sqlStr.append(",tm.fnumber||'!!'||em.fnumber");
        } else {
            sqlStr.append(",temp2.").append(FConsumeQty).append("");
            sqlStr.append(",isnull(e.FConsumeFixQTY,0)");
            sqlStr.append(",isnull(e.FConsumeFixQTY,0) * temp2.").append(FConsumeQty).append("");
            sqlStr.append(",temp2.").append(FTREE_LONG_NUMBER).append("||'!!'||em.fnumber");
        }
        sqlStr.append(",e.FSupplyStorageOrgUnitID");
        sqlStr.append(",t.FStorageOrgUnitID");
        sqlStr.append(" from T_MM_Bom t left join T_MM_BomEntry e on e.fparentid = t.fid");
        sqlStr.append(" inner join T_BD_Material tm on tm.fid = t.fmaterialid");
        sqlStr.append(" inner join T_BD_Material em on em.fid = e.fmaterialid");
        sqlStr.append(" left Join T_MM_TrackNumber stn on stn.FID=e.FBeginCarnoID");
        sqlStr.append(" left Join T_MM_TrackNumber etn on etn.FID=e.FEndCarnoID");
        sqlStr.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid");
        if (isFirst) {
            sqlStr.append(" where 1=1 ");
        } else {
            sqlStr.append(" ,").append(this.treeTable).append(" temp2 ");
            sqlStr.append(" where 1=1 ");
            sqlStr.append(" and temp2.").append(FLEVEL).append(" = ? ");
            param.add(l - 1);
            sqlStr.append(" and temp2.").append(FConsumeQty).append(" > 0 ");
            sqlStr.append(" and t.fstorageOrgUnitID = temp2.FSupplyStorageOrgUnitID");
            sqlStr.append(" and t.fprojectid = temp2.").append(FProjectID);
            sqlStr.append(" and track.fid = temp2.").append(FTrackID);
            sqlStr.append(" and t.fmaterialid = temp2.").append(FMaterialID);
            if (this.stopVirtual) {
                sqlStr.append(" and (").append(" temp2.").append(FMaterialProp).append(" = ").append(10020).append(" )");
            }
        }
        sqlStr.append(" and t.FBaseStatus = ? ");
        param.add(4);
        sqlStr.append(" and t.FBomType = ? ");
        param.add(80);
        sqlStr.append(" and car.fprojectid = t.fprojectid");
        return sqlStr.toString();
    }

    protected String getMaterialIds() {
        StringBuilder pids = new StringBuilder();
        if (this.materials != null) {
            int size = this.materials.size();
            for (int i = 0; i < size; ++i) {
                pids.append(",'").append(this.materials.get(i).getId()).append("'");
            }
        }
        if (pids.length() > 0) {
            return pids.substring(1);
        }
        return null;
    }

    protected String getTrackIds() {
        StringBuilder pids = new StringBuilder();
        if (this.tracks != null) {
            int size = this.tracks.size();
            for (int i = 0; i < size; ++i) {
                pids.append(",'").append(this.tracks.get(i).getId()).append("'");
            }
        }
        if (pids.length() > 0) {
            return pids.substring(1);
        }
        return null;
    }

    protected String getProjectIds() throws EASBizException {
        StringBuilder pids = new StringBuilder();
        if (this.projects != null) {
            int size = this.projects.size();
            for (int i = 0; i < size; ++i) {
                pids.append(",'").append(this.projects.get(i).getId()).append("'");
            }
        }
        if (pids.length() == 0) {
            return null;
        }
        return pids.substring(1);
    }

    protected int executeUpdate(String sql, List param) throws BOSException {
        return ProcessBomTree.executeUpdate(this.ctx, sql, param);
    }

    protected IRowSet executeQuery(String sql, List param) throws BOSException {
        return ProcessBomTree.executeQuery(this.ctx, sql, param);
    }

    protected Map executeQuery2(String sql, List param) throws BOSException, SQLException {
        IRowSet rows = ProcessBomTree.executeQuery(this.ctx, sql, param);
        HashMap<String, Map> tree = new HashMap<String, Map>();
        while (rows.next()) {
            tree.put(rows.getString(FID), this.getAllColumns(rows));
        }
        return tree;
    }

    protected Map getAllColumns(IRowSet row) {
        HashMap<String, Object> node = new HashMap<String, Object>();
        for (String key : columns) {
            try {
                node.put(key, row.getObject(key));
            }
            catch (SQLException e) {
                node.put(key, null);
            }
        }
        return node;
    }
}

