/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ProcessBomTree {
    public static final String TREE_BILL_FIXED = "TREE_BILL_FIXED";
    public static final String TREE_BOM_ID = "TREE_BOM_ID";
    public static final String TREE_EXPAND_FIXED = "Expand_FIXED";
    public static final String TREE_FIXED = "TREE_FIXED";
    public static final String TREE_ID = "TREE_ID";
    public static final String TREE_ISOWNOBJECT = "TREE_ISOWNOBJECT";
    public static final String TREE_LEVEL = "TREE_LEVEL";
    public static final String TREE_LEVEL_LONG_NUMBER = "level_long_number";
    public static final String TREE_LONG_NUMBER = "TREE_LONG_NUMBER";
    public static final String TREE_MATERIAL_ID = "TREE_MATERIAL_ID";
    public static final String TREE_MATERIAL_NAME = "TREE_MATERIAL_NAME";
    public static final String TREE_MATERIAL_NUMBER = "TREE_MATERIAL_NUMBER";
    public static final String TREE_MATERIAL_PROP = "TREE_MATERIAL_PROP";
    public static final String TREE_PARENT_FIXED = "TREE_PARENT_FIXED";
    public static final String TREE_PARENT_ID = "TREE_PARENT_ID";
    public static final String TREE_PARENT_MATERIAL_ID = "TREE_PARENT_MATERIAL_ID";
    public static final String TREE_PARENT_MATERIAL_NAME = "TREE_PARENT_MATERIAL_NAME";
    public static final String TREE_PARENT_MATERIAL_NUMBER = "TREE_PARENT_MATERIAL_NUMBER";
    public static final String TREE_PARENT_MATERIAL_PROP = "TREE_PARENT_MATERIAL_PROP";
    public static final String TREE_PROJECT_ID = "TREE_PROJECT_ID";
    public static final String TREE_TRACK_ID = "TREE_TRACK_ID";
    public static final String CFIsSplit = "CFIsSplit";
    public static final String TREE_TRACK_NUMBER = "TREE_TRACK_NUMBER";
    private static String RESURL = "com.kingdee.eas.zjbom.EMMEMZjResource";
    protected Context ctx;
    protected Boolean filterBatch = false;
    protected MaterialInfo material;
    protected Map params;
    protected ProjectInfo project;
    protected String treeTable;

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0010", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, List param) throws BOSException {
        if (param == null) {
            param = new ArrayList();
        }
        return DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
    }

    public static int executeUpdate(Context ctx, String sql, List param) throws BOSException {
        if (param == null) {
            param = new ArrayList();
        }
        return DBUtil.executeUpdate((Context)ctx, (String)sql, (Object[])param.toArray());
    }

    public static void releaseTable(Context ctx, String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    public final void run(Context ctx, ProjectInfo project, MaterialInfo material, Map params) throws EASBizException {
        this.ctx = ctx;
        this.project = project;
        this.material = material;
        this.params = params;
        try {
            this.initTree();
            this.execute(this.treeTable, this.params);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0011", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
        }
        finally {
            ProcessBomTree.releaseTable(ctx, this.treeTable);
        }
    }

    protected abstract void execute(String var1, Map var2) throws Exception;

    protected String getTreeTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append(TREE_ID).append(" NVARCHAR(200) Not Null,\r\n");
        sql.append(TREE_PARENT_ID).append(" NVARCHAR(200) Null,\r\n");
        sql.append(TREE_BOM_ID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(TREE_PROJECT_ID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(TREE_TRACK_ID).append(" VARCHAR(44)  Null,\r\n");
        sql.append(TREE_TRACK_NUMBER).append(" NVARCHAR(80)  Null,\r\n");
        sql.append(TREE_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NAME).append(" NVARCHAR(100)  Null,\r\n");
        sql.append(TREE_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_MATERIAL_PROP).append(" INT Null,\r\n");
        sql.append(TREE_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_PARENT_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_PROP).append(" INT Null,\r\n");
        sql.append(TREE_PARENT_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_LONG_NUMBER).append(" NVARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL_LONG_NUMBER).append(" VARCHAR(2000)  Null,");
        sql.append(TREE_LEVEL).append(" INT Default 0 Not Null,");
        sql.append(TREE_EXPAND_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_BILL_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_ISOWNOBJECT).append(" Int Default 0");
        sql.append(",").append(CFIsSplit).append(" Numeric(10)");
        sql.append(")");
        return sql.toString();
    }

    protected void initTree() throws Exception {
        String treeSql = this.getTreeTableSql();
        this.treeTable = ProcessBomTree.createTempTable(this.ctx, treeSql);
        this.insertInto();
    }

    protected void insertInto() throws Exception {
        String beginTrackNumber = null;
        String endTrackNumber = null;
        if (this.params.containsKey("prmtTrackBegin") && this.params.get("prmtTrackBegin") != null && !"".equals(this.params.get("prmtTrackBegin").toString())) {
            beginTrackNumber = this.params.get("prmtTrackBegin").toString();
        }
        if (this.params.containsKey("prmtTrackEnd") && this.params.get("prmtTrackEnd") != null && !"".equals(this.params.get("prmtTrackEnd").toString())) {
            endTrackNumber = this.params.get("prmtTrackEnd").toString();
        }
        boolean level = true;
        StringBuilder insert = new StringBuilder();
        insert.append("insert into ").append(this.treeTable).append(" (");
        insert.append(TREE_ID);
        insert.append(",").append(TREE_PARENT_ID);
        insert.append(",").append(TREE_BOM_ID);
        insert.append(",").append(TREE_PROJECT_ID);
        insert.append(",").append(TREE_TRACK_ID);
        insert.append(",").append(TREE_TRACK_NUMBER);
        insert.append(",").append(TREE_MATERIAL_ID);
        insert.append(",").append(TREE_MATERIAL_NAME);
        insert.append(",").append(TREE_MATERIAL_NUMBER);
        insert.append(",").append(TREE_MATERIAL_PROP);
        insert.append(",").append(TREE_FIXED);
        insert.append(",").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",").append(TREE_PARENT_FIXED);
        insert.append(",").append(TREE_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL);
        insert.append(",").append(TREE_EXPAND_FIXED);
        insert.append(",").append(TREE_BILL_FIXED);
        insert.append(",").append(TREE_ISOWNOBJECT);
        insert.append(",").append(CFIsSplit);
        insert.append(") \r\n (select ");
        insert.append("'").append(1).append("-'||newbosid('12345678') ").append(" AS ").append(TREE_ID);
        insert.append(",null").append(" AS ").append(TREE_PARENT_ID);
        insert.append(",bom.fid").append(" AS ").append(TREE_BOM_ID);
        insert.append(",bom.CFProjectID").append(" AS ").append(TREE_PROJECT_ID);
        if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(",track.fid").append(" AS ").append(TREE_TRACK_ID);
            insert.append(",track.fnumber").append(" AS ").append(TREE_TRACK_NUMBER);
        } else if (this.params.containsKey("tracknumbers")) {
            insert.append(",track.fid").append(" AS ").append(TREE_TRACK_ID);
            insert.append(",track.fnumber").append(" AS ").append(TREE_TRACK_NUMBER);
        } else {
            insert.append(",null AS ").append(TREE_TRACK_ID);
            insert.append(",null AS ").append(TREE_TRACK_NUMBER);
        }
        insert.append(",m.fid").append(" AS ").append(TREE_MATERIAL_ID);
        insert.append(",m.fname_l2").append(" AS ").append(TREE_MATERIAL_NAME);
        insert.append(",m.fnumber").append(" AS ").append(TREE_MATERIAL_NUMBER);
        insert.append(",bom.CFMaterialProperty").append(" AS ").append(TREE_MATERIAL_PROP);
        if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(",(case when (stn.fnumber <= track.fnumber and etn.fnumber >= track.fnumber) then bom.CFRation else 0 end )").append(" AS ").append(TREE_FIXED);
        } else {
            insert.append(",bom.CFRation").append(" AS ").append(TREE_FIXED);
        }
        if (this.material != null) {
            insert.append(",'").append(this.material.getId().toString()).append("' AS ").append(TREE_PARENT_MATERIAL_ID);
            insert.append(",'").append(this.material.getName()).append("' AS ").append(TREE_PARENT_MATERIAL_NAME);
            insert.append(",'").append(this.material.getNumber()).append("' AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        } else {
            insert.append(",'' AS ").append(TREE_PARENT_MATERIAL_ID);
            insert.append(",bom.CFParentName AS ").append(TREE_PARENT_MATERIAL_NAME);
            insert.append(",bom.CFParentNo AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        }
        insert.append(",'").append(10030).append("' AS ").append(TREE_PARENT_MATERIAL_PROP);
        String fixed = (String)this.params.get("fixed");
        if (!StringUtils.isEmpty((String)fixed)) {
            insert.append(",").append(fixed).append(" AS ").append(TREE_PARENT_FIXED);
        } else {
            insert.append(",1").append(" AS ").append(TREE_PARENT_FIXED);
        }
        insert.append(",' '").append(" AS ").append(TREE_LONG_NUMBER);
        insert.append(",null AS ").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(1).append(" AS ").append(TREE_LEVEL);
        if (!StringUtils.isEmpty((String)fixed)) {
            if (beginTrackNumber != null && endTrackNumber != null) {
                insert.append(",(case when (stn.fnumber <= track.fnumber and etn.fnumber >= track.fnumber) then bom.CFRation *").append(fixed).append(" else 0 end )").append(" AS ").append(TREE_EXPAND_FIXED);
            } else {
                insert.append(",isnull(bom.CFRation,0)*").append(fixed).append(" AS ").append(TREE_EXPAND_FIXED);
            }
        } else if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(",(case when (stn.fnumber <= track.fnumber and etn.fnumber >= track.fnumber) then bom.CFRation  else 0 end )").append(" AS ").append(TREE_EXPAND_FIXED);
        } else {
            insert.append(",bom.CFRation *").append(fixed).append(" AS ").append(TREE_EXPAND_FIXED);
        }
        if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(",(case when (stn.fnumber <= track.fnumber and etn.fnumber >= track.fnumber) then bom.CFRation else 0 end )").append(" AS ").append(TREE_BILL_FIXED);
        } else {
            insert.append(",bom.CFRation").append(" AS ").append(TREE_BILL_FIXED);
        }
        insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
        insert.append(",\r\n bom.").append(CFIsSplit);
        insert.append(" from CT_ZJB_ProcessBomBill bom");
        insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
        insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
        insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
        if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
        } else if (this.params.containsKey("tracknumbers")) {
            insert.append(" ,T_MM_ProjectCar car left join T_MM_TrackNumber track on track.fid = car.ftrackNumberid ");
        }
        ArrayList<Object> param = new ArrayList<Object>();
        insert.append(" where 1 = 1 ");
        if (this.project == null) {
            insert.append(" and bom.CFProjectID  is null ");
        } else {
            insert.append(" and bom.CFProjectID = ? ");
            param.add(this.project.getId().toString());
        }
        if (beginTrackNumber != null && endTrackNumber != null) {
            insert.append(" and track.fnumber >= '" + beginTrackNumber + "' and track.fnumber <= '" + endTrackNumber + "' ");
        } else if (this.params.containsKey("tracknumbers")) {
            insert.append(" and track.fnumber >= stn.fnumber and track.fnumber <= etn.fnumber ");
        } else {
            insert.append(" and bom.CFBeginCarnoID is null and bom.CFEndCarnoID is null ");
        }
        insert.append(" and bom.CFRation is not null and bom.CFRation > 0");
        insert.append(" and bom.CFState = ?");
        param.add(4);
        if (this.params.containsKey("txtBatch") && this.filterBatch.booleanValue() && this.params.get("txtBatch") != null && !"".equals(this.params.get("txtBatch"))) {
            insert.append(" and bom.cfbatch = ?");
            param.add(this.params.get("txtBatch"));
        }
        if (this.material != null) {
            insert.append(" and bom.CFParentNo = ?");
            param.add(this.material.getNumber());
        } else {
            insert.append(" and not exists (select 1 from CT_ZJB_ProcessBomBill bom2 where bom.CFParentNo = bom2.CFPortNo  and ( bom.CFProjectID = bom2.CFProjectID  or bom.CFProjectID is null))");
        }
        if (this.params.containsKey("tracknumbers")) {
            List tracks = (List)this.params.get("tracknumbers");
            insert.append(" and track.FNumber in (").append(SQLUtil.arrayToString((Object[])tracks.toArray())).append(")");
        }
        insert.append(" ) ");
        int count = ProcessBomTree.executeUpdate(this.ctx, insert.toString(), param);
        this.updateLongNumber(1);
        this.insertInto(2, count);
    }

    protected void insertInto(int level, int count) throws Exception {
        if (level == 30) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"GYBOMSZKQG_INFO", (Locale)this.ctx.getLocale(), (Object[])new Object[]{level});
            throw new EASBizException(new NumericExceptionSubItem("id_error", strInfo));
        }
        if (count == 0) {
            return;
        }
        String beginTrackNumber = null;
        String endTrackNumber = null;
        if (this.params.containsKey("prmtTrackBegin") && this.params.get("prmtTrackBegin") != null && !"".equals(this.params.get("prmtTrackBegin").toString())) {
            beginTrackNumber = this.params.get("prmtTrackBegin").toString();
        }
        if (this.params.containsKey("prmtTrackEnd") && this.params.get("prmtTrackEnd") != null && !"".equals(this.params.get("prmtTrackEnd").toString())) {
            endTrackNumber = this.params.get("prmtTrackEnd").toString();
        }
        StringBuilder insert = new StringBuilder();
        insert.append("insert into ").append(this.treeTable).append(" (");
        insert.append(TREE_ID);
        insert.append(",").append(TREE_PARENT_ID);
        insert.append(",").append(TREE_BOM_ID);
        insert.append(",").append(TREE_PROJECT_ID);
        insert.append(",").append(TREE_TRACK_ID);
        insert.append(",").append(TREE_TRACK_NUMBER);
        insert.append(",").append(TREE_MATERIAL_ID);
        insert.append(",").append(TREE_MATERIAL_NAME);
        insert.append(",").append(TREE_MATERIAL_NUMBER);
        insert.append(",").append(TREE_MATERIAL_PROP);
        insert.append(",").append(TREE_FIXED);
        insert.append(",").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",").append(TREE_PARENT_FIXED);
        insert.append(",").append(TREE_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL);
        insert.append(",").append(TREE_EXPAND_FIXED);
        insert.append(",").append(TREE_BILL_FIXED);
        insert.append(",").append(TREE_ISOWNOBJECT);
        insert.append(",").append(CFIsSplit);
        insert.append(") \r\n (select ");
        insert.append("'").append(level).append("-'||newbosid('12345678')").append(" AS ").append(TREE_ID);
        insert.append(",tree.").append(TREE_ID).append(" AS ").append(TREE_PARENT_ID);
        insert.append(",bom.fid").append(" AS ").append(TREE_BOM_ID);
        insert.append(",bom.CFProjectID").append(" AS ").append(TREE_PROJECT_ID);
        insert.append(",tree.").append(TREE_TRACK_ID).append(" AS ").append(TREE_TRACK_ID);
        insert.append(",tree.").append(TREE_TRACK_NUMBER).append(" AS ").append(TREE_TRACK_NUMBER);
        insert.append(",m.fid").append(" AS ").append(TREE_MATERIAL_ID);
        insert.append(",m.fname_l2").append(" AS ").append(TREE_MATERIAL_NAME);
        insert.append(",m.fnumber").append(" AS ").append(TREE_MATERIAL_NUMBER);
        insert.append(",bom.CFMaterialProperty").append(" AS ").append(TREE_MATERIAL_PROP);
        insert.append(",(case when tree.").append(TREE_TRACK_ID).append(" is null then bom.CFRation else (case when tree.").append(TREE_TRACK_NUMBER).append(" >= stn.fnumber and tree.").append(TREE_TRACK_NUMBER).append(" <= etn.fnumber then bom.CFRation  else 0 end) end )").append(" AS ").append(TREE_FIXED);
        insert.append(",tree.").append(TREE_MATERIAL_ID).append(" AS ").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",tree.").append(TREE_MATERIAL_NAME).append(" AS ").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",tree.").append(TREE_MATERIAL_NUMBER).append(" AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",tree.").append(TREE_MATERIAL_PROP).append(" AS ").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",tree.").append(TREE_FIXED).append(" AS ").append(TREE_PARENT_FIXED);
        insert.append(",tree.").append(TREE_LONG_NUMBER).append(" AS ").append(TREE_LONG_NUMBER);
        insert.append(",null As ").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(level).append(" AS ").append(TREE_LEVEL);
        insert.append(",(case when tree.").append(TREE_TRACK_ID).append(" is null then tree.").append(TREE_EXPAND_FIXED).append(" * bom.CFRation else (case when tree.").append(TREE_TRACK_NUMBER).append(" >= stn.fnumber and tree.").append(TREE_TRACK_NUMBER).append(" <= etn.fnumber then tree.").append(TREE_EXPAND_FIXED).append(" * bom.CFRation  else 0 end) end )").append(" AS ").append(TREE_FIXED);
        insert.append(", ( case when bom.CFMaterialProperty != ").append(10020).append(" and tree.").append(TREE_MATERIAL_PROP).append(" != ").append(10020).append(" then isnull(bom.CFRation,0)").append(" else tree.").append(TREE_BILL_FIXED).append(" * isnull(bom.CFRation,0)").append(" end ) ");
        insert.append(",\r\n").append("Case BOM.CFBOMMaterialPro When '1' Then 1 Else 0 End\r\n");
        insert.append(",bom.").append(CFIsSplit);
        insert.append(" from CT_ZJB_ProcessBomBill bom");
        insert.append(" left join T_BD_Material m on m.fid = bom.CFMaterialID");
        insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bom.CFBeginCarnoID");
        insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bom.CFEndCarnoID");
        insert.append(" ,").append(this.treeTable).append(" tree ");
        ArrayList<Integer> param = new ArrayList<Integer>();
        insert.append(" where 1 = 1 ");
        insert.append(" and tree.").append(TREE_MATERIAL_NUMBER).append(" = bom.CFParentNo");
        insert.append(" and (bom.CFProjectID   = tree.").append(TREE_PROJECT_ID).append(" or bom.CFProjectID is null ) ");
        insert.append(" and tree.").append(TREE_ID).append(" is not null");
        insert.append(" and tree.").append(TREE_LEVEL).append(" = ?");
        param.add(level - 1);
        insert.append(" and bom.CFRation > 0 ");
        insert.append(" and bom.CFState = ?");
        param.add(4);
        if (this.params.containsKey("txtBatch") && this.filterBatch.booleanValue() && this.params.get("txtBatch") != null && !"".equals(this.params.get("txtBatch"))) {
            insert.append(" and bom.cfbatch = ?");
            param.add((Integer)this.params.get("txtBatch"));
        }
        insert.append(" ) ");
        count = ProcessBomTree.executeUpdate(this.ctx, insert.toString(), param);
        this.updateLongNumber(level);
        this.insertInto(level + 1, count);
    }

    protected void updateFixed() throws Exception {
        int count;
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(TREE_EXPAND_FIXED);
        sql.append(" from ").append(this.treeTable).append(" tree");
        sql.append(" where tree.").append(TREE_ID).append(" = ").append(this.treeTable).append(".").append(TREE_PARENT_ID);
        String tree_expand_fixed_sql = sql.toString();
        String tree_bill_fixed_sql = tree_expand_fixed_sql.replaceFirst(TREE_EXPAND_FIXED, TREE_BILL_FIXED);
        ArrayList<Integer> param = new ArrayList<Integer>();
        int level = 1;
        sql.setLength(0);
        sql.append("update ").append(this.treeTable).append(" set ");
        sql.append(" ").append(TREE_EXPAND_FIXED).append(" = ");
        sql.append(" ( case when ").append(TREE_PARENT_ID).append(" is null then ").append(TREE_FIXED).append(" else (").append(tree_expand_fixed_sql).append(") * ").append(TREE_FIXED).append(" end )");
        sql.append(" , ").append(TREE_BILL_FIXED).append(" = ");
        sql.append(" ( case when ").append(TREE_PARENT_ID).append(" is null then ").append(TREE_FIXED).append(" when ").append(TREE_MATERIAL_PROP).append(" != ").append(10020).append(" and ").append(TREE_PARENT_MATERIAL_PROP).append(" != ").append(10020).append(" then ").append(TREE_FIXED).append(" else (").append(tree_bill_fixed_sql).append(") * ").append(TREE_FIXED).append(" end )");
        sql.append(" where ").append(TREE_LEVEL).append(" = ?");
        String update_fixed_sql = sql.toString();
        do {
            param.clear();
            param.add(level);
            count = ProcessBomTree.executeUpdate(this.ctx, update_fixed_sql, param);
            ++level;
        } while (count > 0);
    }

    protected void updateLongNumber(int level) throws Exception {
        StringBuilder sql = new StringBuilder();
        String longNumber = sql.append("'!!'||").append(TREE_MATERIAL_NUMBER).append("||'!!'").toString();
        sql.setLength(0);
        sql.append("select ");
        sql.append(TREE_MATERIAL_NUMBER);
        sql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        sql.append(",min(").append(TREE_TRACK_NUMBER).append(") ").append(" AS b_").append(TREE_TRACK_NUMBER);
        sql.append(",max(").append(TREE_TRACK_NUMBER).append(") ").append(" AS e_").append(TREE_TRACK_NUMBER);
        sql.append(" from (");
        sql.append("select ");
        sql.append(TREE_MATERIAL_NUMBER);
        sql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        sql.append(",").append(TREE_TRACK_NUMBER);
        sql.append(",").append(TREE_LONG_NUMBER);
        sql.append(",'%'||").append(longNumber).append("||'%' AS addLongNumber");
        sql.append(" from ").append(this.treeTable);
        sql.append(" where ").append(TREE_LONG_NUMBER).append(" is not null");
        sql.append(" and ").append(TREE_LEVEL).append(" = ").append(level);
        sql.append(" ) tree");
        sql.append(" where ").append(TREE_LONG_NUMBER).append(" like addLongNumber");
        sql.append(" group by ").append(TREE_MATERIAL_NUMBER).append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        IRowSet rows = ProcessBomTree.executeQuery(this.ctx, sql.toString(), null);
        StringBuilder error = new StringBuilder();
        while (rows.next()) {
            if (error.length() <= 0) {
                error.append("\n" + EASResource.getString((String)"com.kingdee.eas.zjbom.EMMEMZjResource", (String)"0EMMZJBOM-0012", (Locale)this.ctx.getLocale()) + "\n");
            }
            error.append(rows.getString(TREE_MATERIAL_NUMBER)).append("    ");
            error.append(rows.getString(TREE_PARENT_MATERIAL_NUMBER)).append("    ");
            error.append(rows.getString("b_TREE_TRACK_NUMBER")).append(" - ").append(rows.getString("e_TREE_TRACK_NUMBER")).append("\n");
        }
        if (error.length() > 0) {
            String strInfo = ResourceBase.getString((String)RESURL, (String)"XMXDGYBOMS_INFO", (Locale)this.ctx.getLocale(), (Object[])new Object[]{this.project.getName()});
            throw new EASBizException(new NumericExceptionSubItem("", strInfo));
        }
        sql.setLength(0);
        sql.append("update ").append(this.treeTable).append(" set ");
        sql.append(TREE_LONG_NUMBER).append(" = ");
        sql.append(TREE_LONG_NUMBER).append("||").append(longNumber);
        sql.append(" where ").append(TREE_LEVEL).append(" = ").append(level);
        ProcessBomTree.executeUpdate(this.ctx, sql.toString(), null);
    }
}

