/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.MRWorkProcesEntryInfo;
import com.kingdee.eas.mm.basedata.StandardRootingCollection;
import com.kingdee.eas.mm.basedata.StandardRootingFactory;
import com.kingdee.eas.mm.basedata.StandardRootingInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ConvertStatusEnum;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.IbomConvertToPBomFacade;
import com.kingdee.eas.zjbom.convert.app.AbstractBomConvertLogControllerBean;
import com.kingdee.eas.zjbom.convert.bomConvertToPBomFacadeFactory;
import com.kingdee.eas.zjbom.convert.operationTypeEnum;
import com.kingdee.eas.zjbom.convert.util.BomChangeChildStepUtil;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BomConvertLogControllerBean
extends AbstractBomConvertLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjbom.convert.app.BomConvertLogControllerBean");
    private static String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";
    protected Map<String, String> systemParamValueCacheMap = null;

    @Override
    protected BOMTypeEnum _getBomType(Context ctx, String fbomid, boolean ishead) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        if (ishead) {
            sql.append("Select fbomtype from t_mm_bom where fid = ?");
        } else {
            sql.append("Select h.fbomtype from t_mm_bom h inner join t_mm_bomentry d on h.fid = d.fparentid where d.fid = ?");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fbomid});
            if (rs.next()) {
                int bomTypeValue = rs.getInt("fbomtype");
                return BOMTypeEnum.getEnum((int)bomTypeValue);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected IRowSet _getStepEntrys(Context ctx, String logID) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" Select fseq,fsourcebomid,fstepname, ");
        sql.append(" fbegindate, ");
        sql.append(" fenddate, ");
        sql.append(" fexectimelong,fexecresult,FExecStatus,fid,fstandardrootingid,fmrwid,FChildStepID ");
        sql.append(" from t_bco_bomconvertlogentry ");
        sql.append(" where fparentid = ? ");
        sql.append(" order by fseq ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{logID});
        return rs;
    }

    @Override
    protected DesignModeInfo _getDesignModeInfo(Context ctx, String bomID, DBOMTypeEnum DBomType) throws BOSException, EASBizException {
        if (DBomType == null || bomID == null) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select ");
        sql.append(" fdesignmodeid ");
        sql.append(" from ");
        if (DBomType.equals((Object)DBOMTypeEnum.DesignBOM)) {
            sql.append(" ct_zjb_designbombill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            sql.append(" ct_zjb_designbommiddlebill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
            sql.append(" T_ZJB_DesignBomTempBill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.append(" ct_zjb_processbombill ");
        } else {
            return null;
        }
        sql.append(" where fid = ? ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomID});
            if (rs.next()) {
                String fdesignmodeid = rs.getString("fdesignmodeid");
                if (fdesignmodeid != null) {
                    return DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(fdesignmodeid));
                }
                return null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected boolean _checkDesignModeIsSame(Context ctx, List bomIDList, DBOMTypeEnum DBomType) throws BOSException, EASBizException {
        if (DBomType == null || bomIDList == null || bomIDList.size() < 1) {
            return true;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" Select distinct ");
        sql.append(" fdesignmodeid ");
        sql.append(" from ");
        if (DBomType.equals((Object)DBOMTypeEnum.DesignBOM)) {
            sql.append(" ct_zjb_designbombill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            sql.append(" ct_zjb_designbommiddlebill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.append(" ct_zjb_processbombill ");
        } else if (DBomType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
            sql.append(" T_ZJB_DesignBomTempBill ");
        } else {
            return true;
        }
        sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs == null || rs.size() <= 1;
    }

    @Override
    protected BomConvertLogInfo _initStepEntrys(Context ctx, Map dataParam) throws BOSException, EASBizException {
        if (dataParam == null) {
            return null;
        }
        DBOMTypeEnum beforeDBOMType = null;
        if (dataParam.get("beforeDBomType") != null) {
            beforeDBOMType = (DBOMTypeEnum)((Object)dataParam.get("beforeDBomType"));
        }
        ArrayList beforeBomIDList = null;
        if (dataParam.get("beforeBomIDList") != null) {
            beforeBomIDList = (ArrayList)dataParam.get("beforeBomIDList");
        }
        operationTypeEnum operationType = (operationTypeEnum)((Object)dataParam.get("operationType"));
        int expandType = 1;
        if (dataParam.get("expandType") != null) {
            expandType = Integer.parseInt(dataParam.get("expandType").toString());
        }
        DesignModeInfo designModeInfo = null;
        if (dataParam.get("designModeInfo") != null) {
            designModeInfo = (DesignModeInfo)dataParam.get("designModeInfo");
        }
        ArrayList bomstdList = null;
        if (dataParam.get("bomstdList") != null) {
            bomstdList = (ArrayList)dataParam.get("bomstdList");
        }
        BomConvertLogInfo info = new BomConvertLogInfo();
        info.setConvertStatus(ConvertStatusEnum.NOConvert);
        info.setBeforeBomType(beforeDBOMType);
        info.setOperationType(operationType);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        int seq = 0;
        if (operationType.equals((Object)operationTypeEnum.bomConvert) || operationType.equals((Object)operationTypeEnum.bomUnConvert)) {
            if (beforeDBOMType.equals((Object)DBOMTypeEnum.DesignBOM)) {
                sql.append(" Select fid, ");
                sql.append(" cfpartno || ' '||cfname||'--->'||cfparentno As fname");
                sql.append(" from ct_zjb_designbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])beforeBomIDList.toArray())).append(") ");
            } else if (beforeDBOMType.equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
                sql.append(" Select fid, ");
                sql.append(" cfportno || ' '||cfname||'--->'||cfparentno As fname");
                sql.append(" from ct_zjb_designbommiddlebill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])beforeBomIDList.toArray())).append(") ");
            } else if (beforeDBOMType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
                sql.append(" Select fid, ");
                sql.append(" FMaterialNumber || ' '||FMaterialName||'--->'||FPMaterialNumber As fname");
                sql.append(" from T_ZJB_DesignBomTempBill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])beforeBomIDList.toArray())).append(") ");
            } else if (beforeDBOMType.equals((Object)DBOMTypeEnum.ProcessBOM)) {
                sql.append(" Select fid, ");
                sql.append(" cfportno || ' '||cfname||'--->'||cfparentno As fname");
                sql.append(" from ct_zjb_processbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])beforeBomIDList.toArray())).append(") ");
            } else {
                return null;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    this.addBomConvertLogEntryInfo(ctx, info, rs.getString("fid"), ExecStatusEnum.NOExecute, null, rs.getString("fname"), 0, ++seq);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            this.checkData(ctx, info, beforeBomIDList);
        } else if (operationType.equals((Object)operationTypeEnum.pbomOneKey)) {
            BomInfo bomInfo = null;
            if (dataParam.get("bomInfo") != null) {
                bomInfo = (BomInfo)dataParam.get("bomInfo");
            }
            boolean dispHaveNoEndDatas = false;
            if (dataParam.get("dispHaveNoEndDatas") != null) {
                dispHaveNoEndDatas = (Boolean)dataParam.get("dispHaveNoEndDatas");
            }
            if (bomstdList != null && bomstdList.size() > 0) {
                this.expandBomInit2(ctx, bomstdList, info);
            } else {
                this.expandBomInit(ctx, bomInfo, expandType, info, dispHaveNoEndDatas);
            }
        } else if (operationType.equals((Object)operationTypeEnum.bomChange)) {
            this.initBomChangeSteps(ctx, beforeBomIDList, beforeDBOMType, info);
        } else {
            return null;
        }
        return info;
    }

    protected void initBomChangeSteps(Context ctx, List<String> bomChangeIDList, DBOMTypeEnum dbomType, BomConvertLogInfo info) throws BOSException, EASBizException {
        if (bomChangeIDList == null || bomChangeIDList.size() < 1) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        int seq = 0;
        int billSeq = 0;
        int childStepSeq = 0;
        sql.append(" Select ");
        if (dbomType.equals((Object)DBOMTypeEnum.ProcessBOM)) {
            sql.append(" a.fid as fid ,");
            sql.append(" cfptsnumberp || ' '||cfptsnamep||'--->'||fnumber As fname,");
            sql.append(" a.cfbasestatus as fbasestatus, ");
            sql.append(" a.cfcomplete as fcomplete ");
            sql.append(" from ct_zjb_processbomchangebill a ");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])bomChangeIDList.toArray())).append(") ");
        } else if (dbomType.equals((Object)DBOMTypeEnum.DesignTempBom)) {
            sql.append(" a.fid as fid ,");
            sql.append(" fbillname ||'--->'||fnumber As fname,");
            sql.append(" a.fbasestatus as fbasestatus, ");
            sql.append(" 0 as fcomplete ");
            sql.append(" from t_zjb_designbomchangetemp a ");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])bomChangeIDList.toArray())).append(") ");
        } else if (dbomType.equals((Object)DBOMTypeEnum.DesignBOM)) {
            sql.append(" a.fid as fid ,");
            sql.append(" cfname ||'--->'||fnumber As fname,");
            sql.append(" a.cfstate as fbasestatus, ");
            sql.append(" a.fisarchive as fcomplete ");
            sql.append(" from ct_zjb_businessrep a ");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])bomChangeIDList.toArray())).append(") ");
        } else if (dbomType.equals((Object)DBOMTypeEnum.MfgBom)) {
            sql.append(" a.fid as fid ,");
            sql.append(" m.fnumber||m.fname_l2||'--->'||a.fnumber As fname,");
            sql.append(" a.fbasestatus as fbasestatus, ");
            sql.append(" 0 as fcomplete ");
            sql.append(" from t_mm_bomchange a ");
            sql.append(" inner join t_bd_material m on m.fid = a.fmaterialid ");
            sql.append(" where a.fid in(").append(SQLUtil.arrayToString((Object[])bomChangeIDList.toArray())).append(") ");
        } else {
            return;
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fid = null;
        String fname = null;
        String fbasestatus = null;
        String fcomplete = null;
        int hasChildStepID = 0;
        try {
            while (rs.next()) {
                fid = rs.getString("fid");
                fname = rs.getString("fname");
                fbasestatus = rs.getString("fbasestatus");
                fcomplete = rs.getString("fcomplete");
                ++billSeq;
                if (!this.validBomChangeBillComplete(ctx, fcomplete)) {
                    this.addBomConvertLogEntryInfo(ctx, info, rs.getString("fid"), ExecStatusEnum.ERROR, ResourceBase.getString((String)RESURL, (String)"changeISComplete", (Locale)ctx.getLocale()), billSeq + ". " + rs.getString("fname"), 0, ++seq);
                    continue;
                }
                if (!this.validBomChangeBillBasestatus(ctx, fbasestatus)) {
                    this.addBomConvertLogEntryInfo(ctx, info, rs.getString("fid"), ExecStatusEnum.ERROR, ResourceBase.getString((String)RESURL, (String)"changeISAudit", (Locale)ctx.getLocale()), billSeq + ". " + rs.getString("fname"), 0, ++seq);
                    continue;
                }
                List<Map<Integer, String>> childStepList = BomChangeChildStepUtil.getChildStep(ctx, dbomType);
                hasChildStepID = childStepList != null && childStepList.size() > 0 ? 999999 : 0;
                this.addBomConvertLogEntryInfo(ctx, info, rs.getString("fid"), ExecStatusEnum.NOExecute, null, billSeq + ". " + rs.getString("fname"), hasChildStepID, ++seq);
                if (childStepList == null || childStepList.size() <= 0) continue;
                childStepSeq = 0;
                for (int i = 0; i < childStepList.size(); ++i) {
                    Map<Integer, String> childStepMap = childStepList.get(i);
                    Set<Integer> set = childStepMap.keySet();
                    Iterator<Integer> it = set.iterator();
                    while (it.hasNext()) {
                        Integer stepKey = Integer.parseInt(((Object)it.next()).toString());
                        String stepName = childStepMap.get(stepKey);
                        this.addBomConvertLogEntryInfo(ctx, info, rs.getString("fid"), ExecStatusEnum.NOExecute, null, "    " + billSeq + "." + ++childStepSeq + " : " + stepName, stepKey, ++seq);
                    }
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean validBomChangeBillComplete(Context ctx, String fcomplete) throws BOSException, EASBizException {
        return fcomplete == null || !"1".equals(fcomplete);
    }

    protected boolean validBomChangeBillBasestatus(Context ctx, String fbasestatus) throws BOSException, EASBizException {
        return fbasestatus == null || !"4".equals(fbasestatus);
    }

    protected void addBomConvertLogEntryInfo(Context ctx, BomConvertLogInfo info, String sourceBomID, ExecStatusEnum execStatusEnum, String execResult, String stepname, int childStepID, int seq) throws BOSException, EASBizException {
        BomConvertLogEntryInfo entryInfo = new BomConvertLogEntryInfo();
        entryInfo.setSourceBomID(sourceBomID);
        entryInfo.setExecStatus(execStatusEnum);
        entryInfo.setExecResult(execResult);
        entryInfo.setStepname(stepname);
        entryInfo.setChildStepID(childStepID);
        entryInfo.setSeq(seq);
        info.getEntrys().add(entryInfo);
    }

    protected String getSystemParamValueCache(Context ctx, String orgUnitID, String systemParamNumber) throws EASBizException, BOSException {
        if (this.systemParamValueCacheMap != null && this.systemParamValueCacheMap.containsKey(orgUnitID + systemParamNumber)) {
            return this.systemParamValueCacheMap.get(orgUnitID + systemParamNumber);
        }
        String value = this.getParamValue(ctx, systemParamNumber, orgUnitID);
        this.systemParamValueCacheMap.put(orgUnitID + systemParamNumber, value);
        return value;
    }

    protected String getParamValue(Context ctx, String paramName, String storageOrgUnitID) throws BOSException, EASBizException {
        if (storageOrgUnitID == null) {
            return null;
        }
        String value = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("value"));
        filterInfo.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)storageOrgUnitID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)paramName, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        ParamItemCollection paramItemCollection = ParamItemFactory.getLocalInstance((Context)ctx).getParamItemCollection(entityViewInfo);
        if (paramItemCollection != null && paramItemCollection.size() > 0 && paramItemCollection.get(0) != null) {
            value = paramItemCollection.get(0).getValue() == null ? "" : paramItemCollection.get(0).getValue();
        }
        return value;
    }

    protected void expandBomInit(Context ctx, BomInfo bomInfo, int expandType, BomConvertLogInfo info, boolean dispHaveNoEndDatas) throws BOSException, EASBizException {
        if (bomInfo == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        IbomConvertToPBomFacade ib = bomConvertToPBomFacadeFactory.getLocalInstance(ctx);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (expandType == 1) {
            sql.append(" Select h.fid,h.fnumber,h.fmaterialid,h.fprojectid,h.fbomtype,m.fnumber as fmaterialnumber,m.fname_l2 as fmaterialname,h.fdesignmodeid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
            sql.append(" where h.fid = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomInfo.getId().toString()});
        } else if (expandType == 2) {
            dataMap.put("bomInfo", bomInfo);
            dataMap.put("isExpandAllChild", true);
            rs = ib.getBomDatas(dataMap);
        } else if (expandType == 3) {
            TrackNumberInfo minTrackInfo = BomUtil.getBomTrackNumberInfo(ctx, bomInfo, "MIN");
            sql.setLength(0);
            sql.append(" Select h.fid,h.fnumber,h.fmaterialid,h.fprojectid,h.fbomtype,m.fnumber as fmaterialnumber,m.fname_l2 as fmaterialname,h.fdesignmodeid ");
            sql.append(" from t_mm_bom h1 ");
            sql.append(" inner join t_mm_bom h on h1.fstorageorgunitid = h.fstorageorgunitid ");
            sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
            sql.append(" where h1.fid = ? ");
            sql.append(" And h.fbasestatus = 4 ");
            sql.append(" And Exists(Select 1 from t_mm_bomentry d where d.fparentid = h.fid) ");
            if (minTrackInfo != null) {
                sql.append(" And h1.fid in(Select fparentid from t_mm_bomentry where fbegincarnoid = '" + minTrackInfo.getId() + "')  ");
            } else {
                sql.append(" And h1.fprojectid = h.fprojectid  ");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomInfo.getId().toString()});
        } else {
            return;
        }
        try {
            String fbomid;
            int seq = 0;
            Object errorID = null;
            String errorInfoStr = null;
            HashMap<String, String> bomDefStdMap = new HashMap<String, String>();
            String fstdID = null;
            if (dispHaveNoEndDatas) {
                ArrayList<String> bomIDList = new ArrayList<String>();
                while (rs.next()) {
                    fbomid = rs.getString("fid");
                    bomIDList.add(fbomid);
                }
                rs.beforeFirst();
                HashMap<String, Serializable> queryDataMap = new HashMap<String, Serializable>();
                queryDataMap.put("bomIDList", bomIDList);
                queryDataMap.put("pbomQueryType", Integer.valueOf(2));
                IRowSet rsBom = bomConvertToPBomFacadeFactory.getLocalInstance(ctx).getBomStdPboms(queryDataMap);
                while (rsBom.next()) {
                    fbomid = rsBom.getString("fbomid");
                    fstdID = rsBom.getString("fstdid");
                    bomDefStdMap.put(fbomid, fstdID);
                }
            }
            while (rs.next()) {
                fbomid = rs.getString("fid");
                StandardRootingInfo stdInfo = null;
                if (dispHaveNoEndDatas) {
                    if (bomDefStdMap == null || !bomDefStdMap.containsKey(fbomid)) continue;
                    fstdID = (String)bomDefStdMap.get(fbomid);
                    stdInfo = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingInfo((IObjectPK)new ObjectUuidPK(fstdID), this.getStandardRootingSic());
                } else {
                    dataMap = new HashMap();
                    dataMap.put("fbomID", fbomid);
                    stdInfo = ib.getDefaultStandardRooting(dataMap);
                }
                MRWorkProcesEntryInfo mrwInfo = null;
                if (stdInfo != null) {
                    mrwInfo = ib.getMRWorkProcessInfo(stdInfo.getId().toString(), 2);
                }
                if (dispHaveNoEndDatas && (stdInfo == null || mrwInfo == null)) continue;
                String fbomnumber = rs.getString("fnumber");
                String fmaterialid = rs.getString("fmaterialid");
                String fprojectid = rs.getString("fprojectid");
                int fbomtype = rs.getInt("fbomtype");
                String fmaterialnumber = rs.getString("fmaterialnumber");
                String fmaterialname = rs.getString("fmaterialname");
                BomConvertLogEntryInfo entryInfo = new BomConvertLogEntryInfo();
                entryInfo.setSourceBomID(fbomid);
                entryInfo.setExecResult(null);
                entryInfo.setExecStatus(ExecStatusEnum.NOExecute);
                entryInfo.setStepname(fbomnumber + "--[" + fmaterialnumber + "]" + fmaterialname);
                entryInfo.setSeq(++seq);
                entryInfo.setStandardRooting(stdInfo);
                entryInfo.setMRWorkProcesEntry(mrwInfo);
                if (entryInfo.getStandardRooting() == null) {
                    errorInfoStr = ResourceBase.getString((String)RESURL, (String)"No_Audit_StandardRooting", (Locale)ctx.getLocale());
                    entryInfo.setExecResult(errorInfoStr);
                    entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                } else if (entryInfo.getMRWorkProcesEntry() == null) {
                    errorInfoStr = ResourceBase.getString((String)RESURL, (String)"No_MrworkProcess", (Locale)ctx.getLocale());
                    entryInfo.setExecResult(errorInfoStr);
                    entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                }
                info.getEntrys().add(entryInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void expandBomInit2(Context ctx, List bomstdList, BomConvertLogInfo info) throws BOSException, EASBizException {
        if (bomstdList == null || bomstdList.size() < 1) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        IbomConvertToPBomFacade ib = bomConvertToPBomFacadeFactory.getLocalInstance(ctx);
        HashMap dataMap = new HashMap();
        int seq = 0;
        Object errorID = null;
        String errorInfoStr = null;
        try {
            String fstdid;
            String fbomid;
            ArrayList<String> bomIDList = new ArrayList<String>();
            ArrayList<String> stdIDList = new ArrayList<String>();
            for (int i = 0; i < bomstdList.size(); ++i) {
                HashMap bomstdMap = (HashMap)bomstdList.get(i);
                fbomid = bomstdMap.get("bomid").toString();
                fstdid = bomstdMap.get("stdid").toString();
                bomIDList.add(fbomid);
                stdIDList.add(fstdid);
            }
            StandardRootingCollection stdColl = null;
            StandardRootingInfo stdInfo = null;
            if (stdIDList != null && stdIDList.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet(stdIDList), CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(this.getStandardRootingSic());
                stdColl = StandardRootingFactory.getLocalInstance((Context)ctx).getStandardRootingCollection(viewInfo);
            }
            sql.setLength(0);
            sql.append(" Select h.fid,h.fnumber,h.fmaterialid,h.fprojectid,h.fbomtype,m.fnumber as fmaterialnumber,m.fname_l2 as fmaterialname,h.fdesignmodeid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" left outer join t_bd_material m on m.fid = h.fmaterialid ");
            sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String fbomnumber = rs.getString("fnumber");
                String fmaterialid = rs.getString("fmaterialid");
                String fprojectid = rs.getString("fprojectid");
                int fbomtype = rs.getInt("fbomtype");
                String fmaterialnumber = rs.getString("fmaterialnumber");
                String fmaterialname = rs.getString("fmaterialname");
                fbomid = rs.getString("fid");
                String fdesignmodeid = rs.getString("fdesignmodeid");
                for (int i = 0; i < bomstdList.size(); ++i) {
                    HashMap bomstdMap = (HashMap)bomstdList.get(i);
                    if (!bomstdMap.get("bomid").toString().equals(fbomid)) continue;
                    fstdid = bomstdMap.get("stdid").toString();
                    stdInfo = null;
                    if (stdColl != null && stdColl.size() > 0) {
                        for (int j = 0; j < stdColl.size(); ++j) {
                            if (!stdColl.get(j).getId().toString().equals(fstdid)) continue;
                            stdInfo = stdColl.get(j);
                            break;
                        }
                    }
                    BomConvertLogEntryInfo entryInfo = new BomConvertLogEntryInfo();
                    entryInfo.setSourceBomID(fbomid);
                    entryInfo.setExecResult(null);
                    entryInfo.setExecStatus(ExecStatusEnum.NOExecute);
                    entryInfo.setStepname(fbomnumber + "--[" + fmaterialnumber + "]" + fmaterialname);
                    entryInfo.setSeq(++seq);
                    entryInfo.setStandardRooting(stdInfo);
                    if (stdInfo != null) {
                        entryInfo.setMRWorkProcesEntry(ib.getMRWorkProcessInfo(stdInfo.getId().toString(), 2));
                    }
                    if (entryInfo.getStandardRooting() == null) {
                        errorInfoStr = ResourceBase.getString((String)RESURL, (String)"No_StandardRooting", (Locale)ctx.getLocale());
                        entryInfo.setExecResult(errorInfoStr);
                        entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    } else if (entryInfo.getMRWorkProcesEntry() == null) {
                        errorInfoStr = ResourceBase.getString((String)RESURL, (String)"No_MrworkProcess", (Locale)ctx.getLocale());
                        entryInfo.setExecResult(errorInfoStr);
                        entryInfo.setExecStatus(ExecStatusEnum.ERROR);
                    }
                    info.getEntrys().add(entryInfo);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected SelectorItemCollection getStandardRootingSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    protected void checkData(Context ctx, BomConvertLogInfo info, List<String> bomIDList) throws BOSException, EASBizException {
        if (info == null || info.getBeforeBomType() == null || info.getEntrys() == null || info.getEntrys().size() < 1 || bomIDList == null || bomIDList.size() < 1) {
            return;
        }
        if (info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBOM)) {
            this.checkData_DesignBom(ctx, info, bomIDList);
        }
        if (info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignTempBom)) {
            this.checkData_DesignBomTemp(ctx, info, bomIDList);
        }
        if (info.getBeforeBomType().equals((Object)DBOMTypeEnum.DesignBomMiddle)) {
            this.checkData_DesignBomMiddle(ctx, info, bomIDList);
        }
        if (info.getBeforeBomType().equals((Object)DBOMTypeEnum.ProcessBOM)) {
            this.checkData_ProcessBom(ctx, info, bomIDList);
        }
    }

    protected void checkData_DesignBom(Context ctx, BomConvertLogInfo info, List<String> bomIDList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        String errorID = null;
        String errorInfoStr = null;
        try {
            errorInfoStr = ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale());
            sql.append(" Select fid  ");
            sql.append(" from ct_zjb_designbombill ");
            sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And cfstate <> 4 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                errorID = rs.getString("fid");
                this.setErrorStr(ctx, info, errorID, errorInfoStr);
            }
            if (info.getOperationType().equals((Object)operationTypeEnum.bomConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"DesignModeNull", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_designbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And fdesignmodeid is  null  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_designbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And cfisimport = 1  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            } else if (info.getOperationType().equals((Object)operationTypeEnum.bomUnConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isNoConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_designbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And (cfisimport = 0 or  cfisimport is null)   ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkData_DesignBomTemp(Context ctx, BomConvertLogInfo info, List<String> bomIDList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        String errorID = null;
        String errorInfoStr = null;
        try {
            IRowSet rs = null;
            if (info.getOperationType().equals((Object)operationTypeEnum.bomConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"DesignModeNull", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from T_ZJB_DesignBomTempBill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And fdesignmodeid is  null  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from T_ZJB_DesignBomTempBill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And FIsConvert = 1  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            } else if (info.getOperationType().equals((Object)operationTypeEnum.bomUnConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isNoConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from T_ZJB_DesignBomTempBill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And (FIsConvert = 0 or  FIsConvert is null)   ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkData_DesignBomMiddle(Context ctx, BomConvertLogInfo info, List<String> bomIDList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        String errorID = null;
        String errorInfoStr = null;
        try {
            errorInfoStr = ResourceBase.getString((String)RESURL, (String)"DataIsLockEditStatus", (Locale)ctx.getLocale());
            sql.append(" Select fid  ");
            sql.append(" from ct_zjb_designbommiddlebill ");
            sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And cfisedit = 1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                errorID = rs.getString("fid");
                this.setErrorStr(ctx, info, errorID, errorInfoStr);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkData_ProcessBom(Context ctx, BomConvertLogInfo info, List<String> bomIDList) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        String errorID = null;
        String errorInfoStr = null;
        try {
            errorInfoStr = ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale());
            sql.append(" Select fid  ");
            sql.append(" from ct_zjb_processbombill ");
            sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
            sql.append(" And cfstate <> 4 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                errorID = rs.getString("fid");
                this.setErrorStr(ctx, info, errorID, errorInfoStr);
            }
            if (info.getOperationType().equals((Object)operationTypeEnum.bomConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"DesignModeNull", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_processbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And fdesignmodeid is  null  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_processbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And cfisimport = 1  ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            } else if (info.getOperationType().equals((Object)operationTypeEnum.bomUnConvert)) {
                errorInfoStr = ResourceBase.getString((String)RESURL, (String)"isNoConverted", (Locale)ctx.getLocale());
                sql.setLength(0);
                sql.append(" Select fid  ");
                sql.append(" from ct_zjb_processbombill ");
                sql.append(" where fid in(").append(SQLUtil.arrayToString((Object[])bomIDList.toArray())).append(") ");
                sql.append(" And (cfisimport = 0 or  cfisimport is null)   ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    errorID = rs.getString("fid");
                    this.setErrorStr(ctx, info, errorID, errorInfoStr);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void setErrorStr(Context ctx, BomConvertLogInfo info, String sourceBomID, String errorStr) {
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            if (info.getEntrys().get(i).getSourceBomID() == null || !info.getEntrys().get(i).getSourceBomID().equals(sourceBomID)) continue;
            if (info.getEntrys().get(i).getExecResult() == null) {
                info.getEntrys().get(i).setExecResult(errorStr);
            } else {
                info.getEntrys().get(i).setExecResult(info.getEntrys().get(i).getExecResult() + ";" + errorStr);
            }
            info.getEntrys().get(i).setExecStatus(ExecStatusEnum.ERROR);
        }
    }
}

