/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.mo.app.ManufactureOrderStockProcess;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderEntryInfo;
import com.kingdee.eas.industry.emm.project.biz.mrp.PMRPPlannedOrderInfo;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanCollection;
import com.kingdee.eas.industry.emm.scm.material.EMMMaterialPlanFactory;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class PMRPPlannedOrderProcess {
    public static PMRPPlannedOrderEntryInfo subQty(Context ctx, PMRPPlannedOrderEntryInfo entryInfo, BigDecimal subQty, PMRPPlannedOrderInfo poInfo, BigDecimal funitQty) throws BOSException, EASBizException {
        if (subQty == null || subQty.compareTo(BigDecimal.ZERO) <= 0) {
            return entryInfo;
        }
        if (entryInfo == null) {
            return entryInfo;
        }
        StringBuilder sql = new StringBuilder();
        entryInfo.setDemandQty(entryInfo.getDemandQty().subtract(subQty));
        entryInfo.setBaseDemandQty(entryInfo.getBaseDemandQty().subtract(subQty));
        entryInfo.setAssociateQty(entryInfo.getDemandQty());
        entryInfo.setStandardQty(entryInfo.getStandardQty().subtract(subQty));
        if (funitQty == null) {
            funitQty = BigDecimal.ZERO;
        }
        entryInfo.setUnitQty(funitQty);
        if (entryInfo != null && entryInfo.getId() != null && entryInfo.getDemandQty().compareTo(BigDecimal.ZERO) <= 0 && (poInfo.getTotalReleaseQty() == null || poInfo.getTotalReleaseQty().compareTo(BigDecimal.ZERO) <= 0)) {
            sql.setLength(0);
            sql.append(" delete from t_mrp_pmrpplannedorderentry where fid = '").append(entryInfo.getId()).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            return null;
        }
        return entryInfo;
    }

    public static BigDecimal getbomRateQty(Context ctx, BomInfo bomInfo, PMRPPlannedOrderInfo poInfo, BomEntryInfo bomentryInfo, BigDecimal foldqty) throws BOSException, EASBizException {
        BigDecimal fnewqty = foldqty;
        if (bomentryInfo != null) {
            if (bomInfo == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("productBaseQty"));
                sic.add(new SelectorItemInfo("productQty"));
                sic.add(new SelectorItemInfo("id"));
                bomInfo = bomentryInfo.getParent();
                bomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(bomInfo.getId()), sic);
            }
            BigDecimal FProductQty = bomInfo.getProductQty();
            MeasureUnitInfo productUnitInfo = ManufactureOrderStockProcess.getMPProductUnitInfo((Context)ctx, (String)poInfo.getMaterial().getId().toString(), (String)poInfo.getStorageOrgUnit().getId().toString());
            MultiMeasureUnitInfo billMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo((Context)ctx, (String)poInfo.getMaterial().getId().toString(), (String)poInfo.getUnit().getId().toString());
            MultiMeasureUnitInfo productMultiMeasureUnitInfo = null;
            if (productUnitInfo != null) {
                productMultiMeasureUnitInfo = ManufactureOrderStockProcess.getMultiMeasureUnitInfo((Context)ctx, (String)poInfo.getMaterial().getId().toString(), (String)productUnitInfo.getId().toString());
            }
            BigDecimal converRate = new BigDecimal(1);
            if (billMultiMeasureUnitInfo != null && productMultiMeasureUnitInfo != null && billMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate() != null && productMultiMeasureUnitInfo.getConversionRate().compareTo(BigDecimal.ZERO) != 0) {
                converRate = billMultiMeasureUnitInfo.getBaseConvsRate().divide(productMultiMeasureUnitInfo.getConversionRate(), 4, 4);
            }
            if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.VariableAmount) && converRate != null) {
                if (FProductQty != null && FProductQty.compareTo(BigDecimal.ZERO) != 0) {
                    fnewqty = new BigDecimal(1).multiply(foldqty).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision());
                }
            } else if (bomentryInfo.getConsumeType().equals((Object)ConsumeTypeEnum.Proportion) && converRate != null && bomentryInfo.getBaseProductRate() != null && bomentryInfo.getBaseProductRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getBaseRate() != null && bomentryInfo.getBaseRate().compareTo(BigDecimal.ZERO) != 0 && bomentryInfo.getProportion() != null) {
                fnewqty = bomInfo.getProductBaseQty().divide(bomentryInfo.getBaseProductRate(), 4, 4).divide(bomentryInfo.getBaseRate(), 4, 4).multiply(bomentryInfo.getProportion().multiply(new BigDecimal(0.01))).divide(bomInfo.getProductQty(), 4, 4).multiply(converRate).setScale(billMultiMeasureUnitInfo.getQtyPrecision());
            }
        }
        return fnewqty;
    }

    public static int getPMRPPlannedOrderEntryMaxSeq(Context ctx, String fparentID) throws SQLException, EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Max(fseq) as fseq from t_mrp_pmrpplannedorderentry where fparentid = ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{fparentID});
        if (rs.next()) {
            return rs.getInt("fseq");
        }
        return 0;
    }

    protected static BigDecimal getConvertRate(Context ctx, PMRPPlannedOrderInfo ppoInfo, PMRPPlannedOrderEntryInfo ppoeInfo) throws BOSException, EASBizException {
        BigDecimal converRate = new BigDecimal(1);
        return converRate;
    }

    public static PMRPPlannedOrderEntryInfo addPMRPPlannedOrderEntryInfo(Context ctx, BomEntryInfo bomentryInfo, PMRPPlannedOrderInfo pPOInfo, BigDecimal updateQty, BigDecimal funitUpdateQty) throws SQLException, EASBizException, BOSException {
        if (bomentryInfo == null) {
            return null;
        }
        PMRPPlannedOrderEntryInfo addInfo = new PMRPPlannedOrderEntryInfo();
        Timestamp now = new Timestamp(new Date().getTime());
        int fseq = PMRPPlannedOrderProcess.getPMRPPlannedOrderEntryMaxSeq(ctx, pPOInfo.getId().toString());
        addInfo.setSeq(++fseq);
        addInfo.setParent(pPOInfo);
        BOSUuid id = BOSUuid.create((BOSObjectType)addInfo.getBOSType());
        addInfo.setId(id);
        BigDecimal convertRate = PMRPPlannedOrderProcess.getConvertRate(ctx, pPOInfo, addInfo);
        addInfo.setDemandQty(updateQty);
        addInfo.setBaseDemandQty(updateQty.multiply(convertRate));
        addInfo.setStandardQty(updateQty);
        addInfo.setAssociateQty(updateQty);
        addInfo.setStorageOrgUnit(bomentryInfo.getSupplyOrgUnit());
        addInfo.setDefaultWarehouse(bomentryInfo.getDefaultWarehouse());
        addInfo.setLocation(bomentryInfo.getLocation());
        addInfo.setTransferOrgUnit(bomentryInfo.getTransferOrgUnit());
        addInfo.setTransferWarehouse(bomentryInfo.getTransferWarehouse());
        addInfo.setDispatchOrgUnit(PMRPPlannedOrderProcess.getMaterialDispatchOrgUnitInfo(ctx, bomentryInfo.getMaterial().getId().toString(), pPOInfo.getStorageOrgUnit().getId().toString()));
        addInfo.setUnitQty(funitUpdateQty);
        if (pPOInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            addInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        } else if (pPOInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            addInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        } else {
            addInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        addInfo.setBaseUnit(bomentryInfo.getMaterial().getBaseUnit());
        addInfo.setUnit(bomentryInfo.getUnit());
        addInfo.setMaterial(bomentryInfo.getMaterial());
        addInfo.setReplaceVersion(null);
        addInfo.setReleaseBaseQty(BigDecimal.ZERO);
        addInfo.setReleaseQty(BigDecimal.ZERO);
        addInfo.setOriginalPlanBaseQty(updateQty.multiply(convertRate));
        addInfo.setOriginalPlanQty(updateQty);
        addInfo.setScrapQty(BigDecimal.ZERO);
        addInfo.setScrapRate(BigDecimal.ZERO);
        addInfo.setBackFlush(false);
        addInfo.setAssCoefficient(BigDecimal.ZERO);
        addInfo.setAssistUnit(bomentryInfo.getAssistUnit());
        addInfo.setBlkSize(bomentryInfo.getBlkSize());
        addInfo.setIssInHightLimit(updateQty);
        addInfo.setIssInLowLimit(BigDecimal.ZERO);
        addInfo.setIssMode(bomentryInfo.getIssMode());
        addInfo.setIsStockTransfer(bomentryInfo.isIsStockTransfer());
        addInfo.setLineSeq(fseq + "");
        addInfo.setProvideType(BomConvertBaseProcess.getMaterialProvideTypeEnum(ctx, pPOInfo.getStorageOrgUnit().getId().toString(), bomentryInfo.getSupplyOrgUnit().getId().toString(), bomentryInfo.getMaterial().getId().toString()));
        addInfo.setReqDate(pPOInfo.getStartDate());
        return addInfo;
    }

    public static StorageOrgUnitInfo getMaterialDispatchOrgUnitInfo(Context ctx, String materialID, String orgUnitID) throws EASBizException, BOSException {
        Object disOrgUnitInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgUnitID));
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)true));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(PMRPPlannedOrderProcess.getMpExDisOrgUnitSic());
        EMMMaterialPlanCollection mpExColl = EMMMaterialPlanFactory.getLocalInstance((Context)ctx).getEMMMaterialPlanCollection(viewInfo);
        if (mpExColl != null && mpExColl.size() > 0) {
            return mpExColl.get(0).getDistributionOrgUnit();
        }
        return null;
    }

    private static final SelectorItemCollection getMpExDisOrgUnitSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("distributionOrgUnit.id"));
        sic.add(new SelectorItemInfo("distributionOrgUnit.number"));
        sic.add(new SelectorItemInfo("distributionOrgUnit.name"));
        return sic;
    }
}

