/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.process;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.DBOMTypeEnum;
import com.kingdee.eas.zjbom.ProcessBomBillFactory;
import com.kingdee.eas.zjbom.ProcessBomBillInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogEntryInfo;
import com.kingdee.eas.zjbom.convert.BomConvertLogInfo;
import com.kingdee.eas.zjbom.convert.ExecStatusEnum;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.eas.zjbom.convert.util.BomUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BomConvertProcessBomBaseProcess
extends BomConvertBaseProcess {
    public ProcessBomBillInfo processBomBillInfo = null;

    @Override
    public void convert(Context ctx, BomConvertLogEntryInfo entryInfo, BomConvertLogInfo info) throws BOSException, EASBizException {
        super.convert(ctx, entryInfo, info);
        if (this.isException) {
            return;
        }
        this.getProcessBomBillInfo(ctx, entryInfo.getSourceBomID());
        this.isException = !this.checkData_ProcessBom(ctx);
    }

    public ProcessBomBillInfo getProcessBomBillInfo(Context ctx, String fid) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("endCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.id"));
        sic.add(new SelectorItemInfo("beginCarno.number"));
        sic.add(new SelectorItemInfo("endCarno.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.*"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.id"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.number"));
        sic.add(new SelectorItemInfo("designMode.Entry.manufactureStrategy.name"));
        this.processBomBillInfo = ProcessBomBillFactory.getLocalInstance(ctx).getProcessBomBillInfo((IObjectPK)new ObjectUuidPK(fid), sic);
        return this.processBomBillInfo;
    }

    public void updateProcessBomStatus(Context ctx) throws BOSException, EASBizException {
        this.processBomBillInfo.setIsImport(true);
        this.processBomBillInfo.setConvertBomType(this.bomConvertLogInfo.getAfterBomType());
        this.processBomBillInfo.setConvertDate(this.currentDate);
        this.processBomBillInfo.setConverter(this.currentUserInfo);
        updateSic = new SelectorItemCollection();
        updateSic.add(new SelectorItemInfo("isImport"));
        updateSic.add(new SelectorItemInfo("convertBomType"));
        updateSic.add(new SelectorItemInfo("convertDate"));
        updateSic.add(new SelectorItemInfo("converter"));
        ProcessBomBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)this.processBomBillInfo, updateSic);
    }

    public boolean checkData_ProcessBom(Context ctx) throws BOSException, EASBizException {
        if (this.processBomBillInfo.getState() == null || !this.processBomBillInfo.getState().equals((Object)BillBaseStatusEnum.AUDITED)) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"Status_NoAudit", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        if (this.processBomBillInfo.getDesignMode() == null) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"DesignModeNull", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        DesignModeInfo dsInfo = this.processBomBillInfo.getDesignMode();
        if (this.processBomBillInfo.isIsImport()) {
            this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"isConverted", (Locale)ctx.getLocale()));
            this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
            updateSic = new SelectorItemCollection();
            updateSic.add(new SelectorItemInfo("execResult"));
            updateSic.add(new SelectorItemInfo("execStatus"));
            this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
            return false;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        MaterialInfo materialInfo = BomConvertProcessBomBaseProcess.getMaterialInfo(ctx, this.processBomBillInfo.getPortNo());
        MaterialInfo parentMaterialInfo = BomConvertProcessBomBaseProcess.getMaterialInfo(ctx, this.processBomBillInfo.getParentNo());
        if (this.bomConvertLogInfo.getAfterBomType().equals((Object)DBOMTypeEnum.MfgBom)) {
            List<String> allChildDrawOrgUnitIDList;
            if (materialInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialNumberNoBaseData", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (parentMaterialInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ParentMaterialNumberNoBaseData", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getStorageOrgUnit() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"StorageOrgUnitIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getDrawBillOrg() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"SupplyOrgUnitIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getMaterialProperty() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialAttrIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getParentQty() == null || this.processBomBillInfo.getParentQty().compareTo(BigDecimal.ZERO) <= 0) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"parentQty_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getPMUnit() == null || "".equals(this.processBomBillInfo.getPMUnit())) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"parentMUnit_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getUnit() == null || "".equals(this.processBomBillInfo.getUnit())) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MUnit_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            MeasureUnitInfo pUnitInfo = BomConvertProcessBomBaseProcess.getMeasureUnitInfo(ctx, this.processBomBillInfo.getPMUnit(), parentMaterialInfo);
            if (pUnitInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getPMUnit()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            MeasureUnitInfo unitInfo = BomConvertProcessBomBaseProcess.getMeasureUnitInfo(ctx, this.processBomBillInfo.getUnit(), materialInfo);
            if (unitInfo == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"unit_NoBaseData", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getUnit()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isProject() && this.processBomBillInfo.getProject() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ProjectIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isTrackNumber() && this.processBomBillInfo.getBeginCarno() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"STrackNumberIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (dsInfo.isTrackNumber() && this.processBomBillInfo.getEndCarno() == null) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ETrackNumberIsNull", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!BomConvertProcessBomBaseProcess.checkMaterialDisCU(ctx, this.processBomBillInfo.getPortNo(), null)) {
                CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"MaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getPortNo(), ctrlUnitInfo.getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!BomConvertProcessBomBaseProcess.checkMaterialDisCU(ctx, this.processBomBillInfo.getParentNo(), null)) {
                CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ParentMaterialNoCU", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getParentNo(), ctrlUnitInfo.getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkPermission(ctx, this.processBomBillInfo.getStorageOrgUnit().getId().toString(), "mm_bom_addnew").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByMMBomAddNew", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getStorageOrgUnit().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (BomUtil.getBomInfo(ctx, parentMaterialInfo.getId().toString(), this.processBomBillInfo.getStorageOrgUnit().getId().toString(), this.processBomBillInfo.getProject() == null ? null : this.processBomBillInfo.getProject().getId().toString(), dsInfo, this.processBomBillInfo.getBeginCarno() == null ? null : this.processBomBillInfo.getBeginCarno().getId().toString(), this.processBomBillInfo.getMainTenanceLevel() == null ? null : this.processBomBillInfo.getMainTenanceLevel().getId().toString()) != null && !this.checkPermission(ctx, this.processBomBillInfo.getStorageOrgUnit().getId().toString(), "mm_bom_update").booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"NoPermissionByMMBomUpdate", (Locale)ctx.getLocale(), (Object[])new String[]{this.processBomBillInfo.getStorageOrgUnit().getName()}));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkProcessFlowValid(ctx).booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ProcessFlowBaseValid", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (!this.checkDoubleProcessDataValid(ctx).booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"ProcessDoubleDataValid", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            List<String> allParentStorageOrgUnitIDList = this.getAllParentStorageOrgUnitIDList(ctx);
            if (allParentStorageOrgUnitIDList != null && allParentStorageOrgUnitIDList.size() > 0) {
                if (!allParentStorageOrgUnitIDList.contains(this.processBomBillInfo.getStorageOrgUnit().getId().toString())) {
                    allParentStorageOrgUnitIDList.add(this.processBomBillInfo.getStorageOrgUnit().getId().toString());
                }
                if (this.checkMaterialOrgUnitIsMul(ctx, allParentStorageOrgUnitIDList, this.processBomBillInfo.getParentNo(), "ProcessBomParentMaterialMulOrgUnit", true)) {
                    return false;
                }
            }
            if ((allChildDrawOrgUnitIDList = this.getAllChildDrawOrgUnitIDList(ctx)) != null && allChildDrawOrgUnitIDList.size() > 0) {
                if (!allChildDrawOrgUnitIDList.contains(this.processBomBillInfo.getDrawBillOrg().getId().toString())) {
                    allChildDrawOrgUnitIDList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
                }
                if (this.checkMaterialOrgUnitIsMul(ctx, allChildDrawOrgUnitIDList, this.processBomBillInfo.getPortNo(), "ProcessBomChildMaterialMulOrgUnit", false)) {
                    return false;
                }
            }
            if ((allParentStorageOrgUnitIDList = BomConvertProcessBomBaseProcess.getMaterialBomOrgUnitList(ctx, null, this.processBomBillInfo.getStorageOrgUnit().getId().toString(), this.processBomBillInfo.getProject() == null ? null : this.processBomBillInfo.getProject().getId().toString(), this.processBomBillInfo.getBeginCarno() == null ? null : this.processBomBillInfo.getBeginCarno().getId().toString(), this.processBomBillInfo.getParentNo())) != null && allParentStorageOrgUnitIDList.size() > 1 && this.checkMaterialOrgUnitIsMul(ctx, allParentStorageOrgUnitIDList, this.processBomBillInfo.getParentNo(), "BomParentMaterialMulOrgUnit", true)) {
                return false;
            }
            allChildDrawOrgUnitIDList = BomConvertProcessBomBaseProcess.getMaterialBomOrgUnitList(ctx, null, this.processBomBillInfo.getDrawBillOrg().getId().toString(), this.processBomBillInfo.getProject() == null ? null : this.processBomBillInfo.getProject().getId().toString(), this.processBomBillInfo.getBeginCarno() == null ? null : this.processBomBillInfo.getBeginCarno().getId().toString(), this.processBomBillInfo.getPortNo());
            if (allChildDrawOrgUnitIDList != null && allChildDrawOrgUnitIDList.size() > 1 && this.checkMaterialOrgUnitIsMul(ctx, allChildDrawOrgUnitIDList, this.processBomBillInfo.getPortNo(), "BomChildMaterialMulOrgUnit", false)) {
                return false;
            }
            if (!this.checkProcessEMMZZBOMtoNextAllowNOChildDataValid(ctx).booleanValue()) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"EMMZZBOMtoNextAllowNOChild", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            sql.setLength(0);
            sql.append(" Select d.fid ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" inner join t_bd_material m on m.fid = d.fmaterialid ");
            sql.append(" inner join t_bd_material pm on pm.fid = h.fmaterialid ");
            if (dsInfo.isTrackNumber()) {
                sql.append(" left outer join t_mm_tracknumber bt on bt.fid = d.fbegincarnoid ");
                sql.append(" left outer join t_mm_tracknumber et on et.fid = d.fendcarnoid ");
            }
            sql.append(" where  m.fnumber = ? and pm.fnumber = ? and h.fstorageorgunitid = ? and h.fdesignmodeid = ? ");
            sql.append(" and d.fsupplystorageorgunitid = ? ");
            if (this.processBomBillInfo.getMainTenanceLevel() == null) {
                sql.append(" and h.FMainTenanceLevelID is null ");
            } else {
                sql.append(" and h.FMainTenanceLevelID = '" + this.processBomBillInfo.getMainTenanceLevel().getId() + "' ");
            }
            if (dsInfo.isProject()) {
                sql.append(" and h.fprojectid = '" + this.processBomBillInfo.getProject().getId() + "' ");
            }
            if (dsInfo.isTrackNumber()) {
                sql.append(" and bt.fnumber <= '" + this.processBomBillInfo.getEndCarno().getNumber() + "' ");
                sql.append(" and et.fnumber >= '" + this.processBomBillInfo.getBeginCarno().getNumber() + "' ");
            }
            if ((rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{this.processBomBillInfo.getPortNo(), this.processBomBillInfo.getParentNo(), this.processBomBillInfo.getStorageOrgUnit().getId().toString(), dsInfo.getId().toString(), this.processBomBillInfo.getDrawBillOrg().getId().toString()})) != null && rs.size() > 0) {
                String errNumber = "isExists_ProcessBom_ManuBom";
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)errNumber, (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            String errorStr = null;
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialPlan(ctx, parentMaterialInfo.getId().toString(), this.processBomBillInfo.getStorageOrgUnit().getId().toString(), this.processBomBillInfo.getDesignMode(), this.bomConvertLogInfo.getAfterBomType(), true, true, pUnitInfo);
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialPlan(ctx, materialInfo.getId().toString(), this.processBomBillInfo.getDrawBillOrg().getId().toString(), this.processBomBillInfo.getDesignMode(), this.bomConvertLogInfo.getAfterBomType(), true, false, unitInfo);
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialInventroy(ctx, parentMaterialInfo.getId().toString(), this.processBomBillInfo.getStorageOrgUnit().getId().toString());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialInventroy(ctx, materialInfo.getId().toString(), this.processBomBillInfo.getDrawBillOrg().getId().toString());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialUnitConvertRate(ctx, parentMaterialInfo, pUnitInfo, parentMaterialInfo.getBaseUnit());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            errorStr = BomConvertProcessBomBaseProcess.checkMaterialUnitConvertRate(ctx, materialInfo, unitInfo, materialInfo.getBaseUnit());
            if (errorStr != null && !errorStr.equals("ok")) {
                this.bomConvertLogEntryInfo.setExecResult(errorStr);
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
            if (this.processBomBillInfo.getMainTenanceLevel() != null && (this.processBomBillInfo.getIssueProp() == null || this.processBomBillInfo.getIssueProp().equals((Object)IssuePropEnum.NULL))) {
                this.bomConvertLogEntryInfo.setExecResult(ResourceBase.getString((String)RESURL, (String)"IssueProp_Null", (Locale)ctx.getLocale()));
                this.bomConvertLogEntryInfo.setExecStatus(ExecStatusEnum.ERROR);
                updateSic = new SelectorItemCollection();
                updateSic.add(new SelectorItemInfo("execResult"));
                updateSic.add(new SelectorItemInfo("execStatus"));
                this.iBomConvertLogEntry.updatePartial((CoreBaseInfo)this.bomConvertLogEntryInfo, updateSic);
                return false;
            }
        }
        return true;
    }

    @Override
    public void afterConvert(Context ctx) throws BOSException, EASBizException {
        super.afterConvert(ctx);
        this.updateProcessBomStatus(ctx);
    }

    public Boolean checkProcessFlowValid(Context ctx) throws BOSException, EASBizException {
        if (this.processBomBillInfo.getInitMakeFlow() == null || this.processBomBillInfo.getMakeFlow() == null) {
            return true;
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select fe.fid from ct_zjb_flowsplitconfigentry fe ");
        sql.append(" inner join CT_ZJB_FlowSplitConfig f on f.fid = fe.FParentID ");
        sql.append(" where f.CFFlowName = ?  ");
        sql.append(" AND fe.CFFLOW = ? ");
        sql.append(" AND fe.CFSTORAGEORGUNITID = ? ");
        sql.append(" AND fe.CFGETSTORAGEORGUNI = ? ");
        sql.append(" AND fe.CFMaterialProperty =? ");
        paramList.add(this.processBomBillInfo.getInitMakeFlow());
        paramList.add(this.processBomBillInfo.getMakeFlow());
        paramList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
        paramList.add(this.processBomBillInfo.getStorageOrgUnit().getId().toString());
        paramList.add(this.processBomBillInfo.getMaterialProperty().getValue());
        if (this.processBomBillInfo.getSupplier() != null) {
            sql.append(" AND fe.CFSupplierID =? ");
            paramList.add(this.processBomBillInfo.getSupplier().getId().toString());
        } else {
            sql.append(" AND fe.CFSupplierID is null");
        }
        if (this.processBomBillInfo.getGetSupplier() != null) {
            sql.append(" AND fe.CFGetSupplierID =? ");
            paramList.add(this.processBomBillInfo.getGetSupplier().getId().toString());
        } else {
            sql.append(" AND fe.CFGetSupplierID is null");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (!rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public Boolean checkDoubleProcessDataValid(Context ctx) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select fid  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where CFPORTNO = ?  ");
        sql.append(" AND CFPARENTNO = ? ");
        sql.append(" AND CFStorageOrgUnitID = ? ");
        sql.append(" AND CFDrawBillOrgID =? ");
        sql.append(" AND CFSTATE =? ");
        sql.append(" AND cfration > 0 ");
        sql.append(" AND fid <> ? ");
        paramList.add(this.processBomBillInfo.getPortNo());
        paramList.add(this.processBomBillInfo.getParentNo());
        paramList.add(this.processBomBillInfo.getStorageOrgUnit().getId().toString());
        paramList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
        paramList.add(4);
        paramList.add(this.processBomBillInfo.getId().toString());
        if (this.processBomBillInfo.getBatch() == null) {
            sql.append(" AND CFBATCH is null ");
        } else {
            sql.append(" AND CFBATCH = ? ");
            paramList.add(this.processBomBillInfo.getBatch());
        }
        if (this.processBomBillInfo.getDesignMode().isProject()) {
            if (this.processBomBillInfo.getProject() == null) {
                sql.append(" AND CFPROJECTID is null ");
            } else {
                sql.append(" AND CFPROJECTID = ? ");
                paramList.add(this.processBomBillInfo.getProject().getId().toString());
            }
        }
        if (this.processBomBillInfo.getDesignMode().isTrackNumber()) {
            if (this.processBomBillInfo.getBeginCarno() == null) {
                sql.append(" AND CFBEGINCARNOID is null ");
            } else {
                sql.append(" AND CFBEGINCARNOID = ? ");
                paramList.add(this.processBomBillInfo.getBeginCarno().getId().toString());
            }
            if (this.processBomBillInfo.getEndCarno() == null) {
                sql.append(" AND CFENDCARNOID is null ");
            } else {
                sql.append(" AND CFENDCARNOID = ? ");
                paramList.add(this.processBomBillInfo.getEndCarno().getId().toString());
            }
        }
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public Boolean checkProcessDrawOrgUnitDataValid(Context ctx) throws BOSException, EASBizException {
        CtrlUnitInfo cc = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (BomConvertProcessBomBaseProcess.getSysParamBooleanValue(ctx, cc.getId().toString(), "EMMBomOrg", true)) {
            return true;
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select fid  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where CFPORTNO = ?  ");
        sql.append(" AND CFPARENTNO = ? ");
        sql.append(" AND CFStorageOrgUnitID = ? ");
        sql.append(" AND CFDrawBillOrgID <> ? ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND CFRation > 0 ");
        paramList.add(this.processBomBillInfo.getPortNo());
        paramList.add(this.processBomBillInfo.getParentNo());
        paramList.add(this.processBomBillInfo.getStorageOrgUnit().getId().toString());
        paramList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
        paramList.add(4);
        if (this.processBomBillInfo.getBatch() == null) {
            sql.append(" AND CFBATCH is null ");
        } else {
            sql.append(" AND CFBATCH = ? ");
            paramList.add(this.processBomBillInfo.getBatch());
        }
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public List<String> getAllParentStorageOrgUnitIDList(Context ctx) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select distinct CFDrawBillOrgID As fDrawOrgUnitID  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where CFPORTNO = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND CFRation > 0  ");
        paramList.add(this.processBomBillInfo.getParentNo());
        paramList.add(4);
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        if (this.processBomBillInfo.getProject() != null) {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.processBomBillInfo.getProject().getId().toString());
        }
        sql.append(" union  ");
        sql.append(" select distinct Cfstorageorgunitid As fDrawOrgUnitID  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where Cfparentno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND CFRation > 0  ");
        paramList.add(this.processBomBillInfo.getParentNo());
        paramList.add(4);
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        if (this.processBomBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND (Cfprojectid = ? or Cfprojectid is null ) ");
            paramList.add(this.processBomBillInfo.getProject().getId().toString());
        }
        if (this.processBomBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.processBomBillInfo.getDesignMode().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fDrawOrgUnitID") == null || "".equals(rs.getString("fDrawOrgUnitID"))) continue;
                idList.add(rs.getString("fDrawOrgUnitID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    public List<String> getAllChildDrawOrgUnitIDList(Context ctx) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paramList = new ArrayList<Object>();
        sql.append(" select distinct CFDrawBillOrgID As fDrawOrgUnitID  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where CFPORTNO = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND CFRation > 0  ");
        paramList.add(this.processBomBillInfo.getPortNo());
        paramList.add(4);
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        if (this.processBomBillInfo.getProject() == null) {
            sql.append(" AND Cfprojectid is null ");
        } else {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.processBomBillInfo.getProject().getId().toString());
        }
        if (this.processBomBillInfo.getDesignMode() == null) {
            sql.append(" AND Fdesignmodeid is null ");
        } else {
            sql.append(" AND Fdesignmodeid = ? ");
            paramList.add(this.processBomBillInfo.getDesignMode().getId().toString());
        }
        sql.append(" union  ");
        sql.append(" select distinct Cfstorageorgunitid As fDrawOrgUnitID  ");
        sql.append(" from CT_ZJB_PROCESSBOMBILL  ");
        sql.append(" where Cfparentno = ?  ");
        sql.append(" AND CFSTATE = ? ");
        sql.append(" AND CFRation > 0  ");
        paramList.add(this.processBomBillInfo.getPortNo());
        paramList.add(4);
        if (this.processBomBillInfo.getProject() != null) {
            sql.append(" AND Cfprojectid = ? ");
            paramList.add(this.processBomBillInfo.getProject().getId().toString());
        }
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        ArrayList<String> idList = new ArrayList<String>();
        try {
            while (rs.next()) {
                if (rs.getString("fDrawOrgUnitID") == null || "".equals(rs.getString("fDrawOrgUnitID"))) continue;
                idList.add(rs.getString("fDrawOrgUnitID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return idList;
    }

    public Boolean checkProcessChildDrawOrgUnitDataValid(Context ctx) throws BOSException, EASBizException {
        if (this.processBomBillInfo.getMaterialProperty() == null || !this.processBomBillInfo.getMaterialProperty().equals((Object)MaterialAttributeEnum.FABRICATEDPART)) {
            return true;
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<String> paramList = new ArrayList<String>();
        sql.append(" select h.fid  ");
        sql.append(" from t_mm_bom h   ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid   ");
        sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid   ");
        sql.append(" left outer join t_mm_tracknumber bt on d.fbegincarnoid = bt.fid   ");
        sql.append(" left outer join t_mm_tracknumber et on d.fendcarnoid = et.fid   ");
        sql.append(" where m.fnumber = ?  ");
        paramList.add(this.processBomBillInfo.getPortNo());
        sql.append(" And h.fdesignModeID = ").append(this.processBomBillInfo.getDesignMode().getId());
        if (this.processBomBillInfo.getDesignMode().isProject()) {
            if (this.processBomBillInfo.getProject() == null) {
                sql.append(" AND h.fprojectid is null ");
            } else {
                sql.append(" AND h.fprojectid = ? ");
                paramList.add(this.processBomBillInfo.getProject().getId().toString());
            }
        }
        if (this.processBomBillInfo.getMainTenanceLevel() == null) {
            sql.append(" AND h.FMainTenanceLevelID is null ");
        } else {
            sql.append(" AND h.FMainTenanceLevelID = ? ");
            paramList.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
        }
        if (this.processBomBillInfo.getDesignMode().isTrackNumber()) {
            if (this.processBomBillInfo.getBeginCarno() == null) {
                sql.append(" AND  d.fbegincarnoid is null ");
            } else {
                sql.append(" AND  bt.fnumber <= ? ");
                paramList.add(this.processBomBillInfo.getBeginCarno().getNumber().toString());
            }
            if (this.processBomBillInfo.getEndCarno() == null) {
                sql.append(" AND d.fendcarnoid is null ");
            } else {
                sql.append(" AND et.fnumber >= ? ");
                paramList.add(this.processBomBillInfo.getEndCarno().getNumber().toString());
            }
        }
        sql.append(" AND h.fstorageorgunitid <> ? ");
        paramList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public Boolean checkProcessEMMZZBOMtoNextAllowNOChildDataValid(Context ctx) throws BOSException, EASBizException {
        if (!this.processBomBillInfo.isZZNoChildToBom() && (this.processBomBillInfo.getMaterialProperty().equals((Object)MaterialAttributeEnum.PHANTOMPART) || this.processBomBillInfo.getMaterialProperty().equals((Object)MaterialAttributeEnum.FABRICATEDPART))) {
            String EMMZZBOMtoNextAllowNOChild = "false";
            CtrlUnitInfo cc = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            EMMZZBOMtoNextAllowNOChild = BomConvertProcessBomBaseProcess.getSysParamValue(ctx, cc.getId().toString(), "EMMZZBOMtoNextAllowNOChild", true);
            if (EMMZZBOMtoNextAllowNOChild == null || !EMMZZBOMtoNextAllowNOChild.toUpperCase().equals("TRUE")) {
                StringBuilder sql = new StringBuilder();
                DesignModeInfo design = DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(this.processBomBillInfo.getDesignMode().getId().toString()));
                ArrayList<String> paramList = new ArrayList<String>();
                sql.append(" select h.fid  ");
                sql.append(" from t_mm_bom h   ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid   ");
                sql.append(" inner join t_bd_material m on m.fid = h.fmaterialid   ");
                sql.append(" left outer join t_mm_tracknumber bt on d.FBeginCarnoID = bt.fid   ");
                sql.append(" left outer join t_mm_tracknumber et on d.FEndCarnoID= et.fid   ");
                sql.append(" where m.fnumber = ?  ");
                paramList.add(this.processBomBillInfo.getPortNo());
                sql.append(" and h.FStorageOrgUnitID = ?");
                paramList.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
                if (this.processBomBillInfo.getProject() == null) {
                    sql.append(" AND h.FProjectID is null ");
                } else {
                    sql.append(" AND (h.FProjectID = ? or h.FProjectID is null )");
                    paramList.add(this.processBomBillInfo.getProject().getId().toString());
                }
                if (this.processBomBillInfo.getBeginCarno() != null) {
                    TrackNumberInfo start = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(this.processBomBillInfo.getBeginCarno().getId().toString()));
                    sql.append(" and (bt.fnumber >= '" + start.getNumber() + "' or bt.fid is null)");
                } else {
                    sql.append(" AND d.FBeginCarnoID is null ");
                }
                if (this.processBomBillInfo.getEndCarno() != null) {
                    TrackNumberInfo end = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(this.processBomBillInfo.getEndCarno().getId().toString()));
                    sql.append(" and (et.fnumber <= '" + end.getNumber() + "' or et.fid is null )");
                } else {
                    sql.append(" AND d.FEndCarnoID is null ");
                }
                StringBuffer processsql = new StringBuffer();
                ArrayList<String> paramLists = new ArrayList<String>();
                processsql.append(" Select a.fid  ");
                processsql.append("from ct_zjb_processbombill a  ");
                processsql.append(" left outer join t_mm_tracknumber bt on a.CFBeginCarnoID = bt.fid   ");
                processsql.append(" left outer join t_mm_tracknumber et on a.CFEndCarnoID = et.fid   ");
                processsql.append("where a.cfparentno = ?  ");
                processsql.append("and a.cfstorageorgunitid = ?  ");
                paramLists.add(this.processBomBillInfo.getPortNo());
                paramLists.add(this.processBomBillInfo.getDrawBillOrg().getId().toString());
                if (this.processBomBillInfo.getMainTenanceLevel() == null) {
                    processsql.append(" AND a.FMainTenanceLevelID is null ");
                } else {
                    processsql.append(" AND a.FMainTenanceLevelID = ? ");
                    paramLists.add(this.processBomBillInfo.getMainTenanceLevel().getId().toString());
                }
                if (this.processBomBillInfo.getProject() == null) {
                    processsql.append(" AND a.cfprojectid is null ");
                } else {
                    processsql.append(" AND (a.cfprojectid = ? or a.cfprojectid is null) ");
                    paramLists.add(this.processBomBillInfo.getProject().getId().toString());
                }
                if (this.processBomBillInfo.getBeginCarno() != null) {
                    TrackNumberInfo start = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(this.processBomBillInfo.getBeginCarno().getId().toString()));
                    processsql.append(" and (bt.fnumber >= '" + start.getNumber() + "' or bt.fid is null) ");
                } else {
                    processsql.append(" AND a.CFBeginCarnoID is null ");
                }
                if (this.processBomBillInfo.getEndCarno() != null) {
                    TrackNumberInfo end = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(this.processBomBillInfo.getEndCarno().getId().toString()));
                    processsql.append(" and (et.fnumber <= '" + end.getNumber() + "' or et.fid is null)");
                } else {
                    processsql.append(" AND a.CFEndCarnoID is null ");
                }
                IRowSet bomrs = DbUtil.executeQuery((Context)ctx, (String)processsql.toString(), (Object[])paramLists.toArray());
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                try {
                    if (!rs.next() && !bomrs.next()) {
                        return false;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return true;
    }
}

