/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjbom.convert.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialCharEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialIssueModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialProductEnum;
import com.kingdee.eas.basedata.master.material.MaterialProvideTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.mm.basedata.BOMTypeEnum;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.mm.basedata.BomChangeInfo;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomEntryInfo;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.ConsumeTypeEnum;
import com.kingdee.eas.mm.basedata.DesignModeFactory;
import com.kingdee.eas.mm.basedata.DesignModeInfo;
import com.kingdee.eas.mm.basedata.IssuePropEnum;
import com.kingdee.eas.mm.basedata.MainTenanceLevelInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.mm.common.util.SQLUtil;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.zjbom.app.util.AutoNumberUtil;
import com.kingdee.eas.zjbom.convert.BomChangeBillAuditFacadeFactory;
import com.kingdee.eas.zjbom.convert.process.BomConvertBaseProcess;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BomUtil {
    private static BillBaseStatusEnum bomBaseStatusEnum = BillBaseStatusEnum.AUDITED;
    private static BigDecimal Bigone = new BigDecimal(1);
    public static final DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static String RESURL = "com.kingdee.eas.zjbom.convert.convertBomResource";

    private static final SelectorItemCollection getNumberSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    public static final TrackNumberInfo getTrackNumberInfo(Context ctx, String trackID) throws BOSException, EASBizException {
        return TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberInfo((IObjectPK)new ObjectUuidPK(trackID), BomUtil.getNumberSic());
    }

    public static final SelectorItemCollection getBomSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.number"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.name"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.id"));
        sic.add(new SelectorItemInfo("entrys.beginCarno.number"));
        sic.add(new SelectorItemInfo("entrys.endCarno.id"));
        sic.add(new SelectorItemInfo("entrys.endCarno.number"));
        return sic;
    }

    public static final BomInfo getBomInfo(Context ctx, String materialID, String orgunitID, String projectID, DesignModeInfo dsInfo, String trackNumberID, String mainTenanceLevelID) throws BOSException, EASBizException {
        BomInfo bomInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", (Object)orgunitID));
        if (mainTenanceLevelID == null || "".equals(mainTenanceLevelID)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("mainTenanceLevel.id", null, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("mainTenanceLevel.id", (Object)mainTenanceLevelID, CompareType.EQUALS));
        }
        if (dsInfo.isProject()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", (Object)projectID));
        } else if (!dsInfo.isProject() && dsInfo.isTrackNumber()) {
            if (trackNumberID != null) {
                String trackNumber = null;
                trackNumber = BomUtil.getTrackNumberInfo(ctx, trackNumberID).getNumber();
                StringBuilder sql = new StringBuilder();
                sql.append(" Select distinct bd.fparentid from t_mm_bomentry bd inner join t_mm_tracknumber bt on bt.fid = bd.fbegincarnoid inner join t_mm_tracknumber et on et.fid = bd.fendcarnoid where bt.fnumber <= '" + trackNumber + "' and et.fnumber >= '" + trackNumber + "' ");
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("project.id", null));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)3, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("designMode.id", (Object)dsInfo.getId()));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(BomUtil.getBomSelectSic());
        BomCollection bomCollection = BomFactory.getLocalInstance((Context)ctx).getBomCollection(viewInfo);
        if (bomCollection != null && bomCollection.size() > 0) {
            bomInfo = bomCollection.get(0);
        }
        return bomInfo;
    }

    public static BomInfo addBomInfo(Context ctx, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnitInfo, ProjectInfo projectInfo, DesignModeInfo dsInfo, BigDecimal qty, MeasureUnitInfo unitInfo, SupplierInfo supplierInfo, MainTenanceLevelInfo mainTenanceLevelInfo) throws BOSException, EASBizException {
        UserInfo currentUserInfo = (UserInfo)ctx.get((Object)"UserInfo");
        Date currentDate = new Date();
        Timestamp curentTimeStamp = new Timestamp(System.currentTimeMillis());
        BomInfo bomInfo = new BomInfo();
        bomInfo.setUnit(unitInfo);
        bomInfo.setBaseUnit(materialInfo.getBaseUnit());
        bomInfo.setName(materialInfo.getName());
        bomInfo.setDesignMode(dsInfo);
        bomInfo.setBomType(dsInfo.getBomType());
        bomInfo.setUsageType(BOMUsageEnum.Master);
        bomInfo.setMaterial(materialInfo);
        bomInfo.setModel(materialInfo.getModel());
        if (dsInfo.isProject()) {
            bomInfo.setProject(projectInfo);
        }
        bomInfo.setStorageOrgUnit(storageOrgUnitInfo);
        bomInfo.setGetSupplier(supplierInfo);
        if (bomBaseStatusEnum.equals((Object)BillBaseStatusEnum.AUDITED)) {
            bomInfo.setAuditor(currentUserInfo);
            bomInfo.setAuditTime(curentTimeStamp);
        }
        bomInfo.setBaseStatus(bomBaseStatusEnum);
        bomInfo.setLastUpdateUser(currentUserInfo);
        bomInfo.setModifier(currentUserInfo);
        bomInfo.setLastUpdateTime(curentTimeStamp);
        bomInfo.setModificationTime(curentTimeStamp);
        bomInfo.setYield(new BigDecimal(100.0));
        bomInfo.setBizDate(currentDate);
        bomInfo.setBomGroup(BomConvertBaseProcess.getBomGroupstandadInfo(ctx, storageOrgUnitInfo));
        bomInfo.setProductBaseQty(Bigone);
        bomInfo.setProductQty(Bigone);
        if (qty != null && qty.compareTo(BigDecimal.ZERO) > 0) {
            bomInfo.setProductBaseQty(qty);
            bomInfo.setProductQty(qty);
        }
        bomInfo.setIsProjectManu(true);
        bomInfo.setMainTenanceLevel(mainTenanceLevelInfo);
        AutoNumberUtil.initNumber(ctx, (IObjectValue)bomInfo);
        return bomInfo;
    }

    public static BomEntryInfo getBomEntryInfo(Context ctx, BomInfo bomInfo, MaterialInfo materialInfo, StorageOrgUnitInfo storageOrgUnitInfo, TrackNumberInfo btInfo, TrackNumberInfo etInfo) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = null;
        if (bomInfo.getEntrys() != null && bomInfo.getEntrys().size() > 0) {
            for (int i = 0; i < bomInfo.getEntrys().size(); ++i) {
                bomEntryInfo = bomInfo.getEntrys().get(i);
                if (bomEntryInfo.getMaterial() == null || bomEntryInfo.getSupplyOrgUnit() == null || !bomEntryInfo.getMaterial().getId().toString().equals(materialInfo.getId().toString()) || !bomEntryInfo.getSupplyOrgUnit().getId().toString().equals(storageOrgUnitInfo.getId().toString())) continue;
                if (bomInfo.getDesignMode().isTrackNumber()) {
                    if (bomEntryInfo.getBeginCarno() == null || bomEntryInfo.getEndCarno() == null || btInfo == null || etInfo == null || !btInfo.getId().toString().equals(bomEntryInfo.getBeginCarno().getId().toString()) || !etInfo.getId().toString().equals(bomEntryInfo.getEndCarno().getId().toString())) continue;
                    return bomEntryInfo;
                }
                return bomEntryInfo;
            }
        }
        return null;
    }

    public static BomEntryInfo addBomEntryInfo(Context ctx, BomInfo bomInfo, MaterialInfo materialInfo, MeasureUnitInfo unitInfo, BigDecimal qty, StorageOrgUnitInfo supplyOrgUnitInfo, TrackNumberInfo btInfo, TrackNumberInfo etInfo, MaterialAttributeEnum materialAttr, SupplierInfo supplierInfo, IssuePropEnum issueProp) throws BOSException, EASBizException {
        BomEntryInfo bomEntryInfo = new BomEntryInfo();
        bomEntryInfo.setMaterial(materialInfo);
        bomEntryInfo.setUnit(unitInfo);
        bomEntryInfo.setBaseUnit(materialInfo.getBaseUnit());
        bomEntryInfo.setConsumeFixBaseQty(qty);
        bomEntryInfo.setConsumeFixQty(qty);
        bomEntryInfo.setMaterialChar(MaterialCharEnum.getEnum((int)10410));
        bomEntryInfo.setConsumeType(ConsumeTypeEnum.getEnum((int)20));
        bomEntryInfo.setProportion(BigDecimal.ZERO);
        bomEntryInfo.setScrapRatio(BigDecimal.ZERO);
        bomEntryInfo.setLeadtime(0);
        try {
            Date effectiveDate = sdf.parse(MMUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd"));
            Date disableDate = sdf.parse("2099-12-31");
            bomEntryInfo.setEffectiveDate(effectiveDate);
            bomEntryInfo.setDisableDate(disableDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        bomEntryInfo.setOutputType(MaterialProductEnum.getEnum((int)10740));
        bomEntryInfo.setIssMode(MaterialIssueModeEnum.getEnum((int)11010));
        bomEntryInfo.setProvideType(BomConvertBaseProcess.getMaterialProvideTypeEnum(ctx, bomInfo.getStorageOrgUnit().getId().toString(), supplyOrgUnitInfo.getId().toString(), materialInfo.getId().toString()));
        bomEntryInfo.setSupplyOrgUnit(supplyOrgUnitInfo);
        bomEntryInfo.setTransferOrgUnit(bomInfo.getStorageOrgUnit());
        bomEntryInfo.setSupplier(supplierInfo);
        bomEntryInfo.setBlkSize(null);
        bomEntryInfo.setSpecifiedLength(null);
        bomEntryInfo.setMaterialProp(materialAttr);
        if (bomEntryInfo.getProvideType() == MaterialProvideTypeEnum.SPANORGATTEMPERPROVIDE) {
            bomEntryInfo.setTransferOrgUnit(bomEntryInfo.getSupplyOrgUnit());
        }
        if (bomInfo.getDesignMode().isTrackNumber()) {
            bomEntryInfo.setBeginCarno(btInfo);
            bomEntryInfo.setEndCarno(etInfo);
        }
        bomEntryInfo.setIssueProp(issueProp);
        bomEntryInfo.setParent(bomInfo);
        return bomEntryInfo;
    }

    public static String checkBomCanUnConvert(Context ctx, List<String> bomEntryIDList) throws BOSException, EASBizException {
        String successful = "ok";
        if (bomEntryIDList == null || bomEntryIDList.size() < 1) {
            return successful;
        }
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        String errorNumber = null;
        try {
            if (bomBaseStatusEnum.equals((Object)BillBaseStatusEnum.AUDITED)) {
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" inner join t_mm_pbomentry pd on pd.fbomitemid = d.fid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePBom_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" inner join t_mm_bomchange ch on ch.fbomid = h.fid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = ResourceBase.getString((String)RESURL, (String)"BomIsCreateChange_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" inner join t_mm_mftorderstock mo on mo.fbomentryid = d.fid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePO_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" inner join t_sm_subcontractorderentry so on so.fbomid = h.fid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreateWWOrder_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                sql.setLength(0);
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" inner join t_mrp_pmrpplannedorder pd on pd.fbominterid = h.fid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePlannedOrder_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                    return successful;
                }
                BomCollection bomcoll = BomUtil.getbomCollection(ctx, bomEntryIDList);
                ArrayList<String> topBomIDList = new ArrayList<String>();
                if (bomcoll != null && bomcoll.size() > 0) {
                    for (int i = 0; i < bomcoll.size(); ++i) {
                        BomInfo bomInfo = bomcoll.get(i);
                        List topBomInfoList = BomUtil.getTopZZBomInfo(ctx, bomInfo);
                        for (int j = 0; j < topBomInfoList.size(); ++j) {
                            BomInfo topZZBom = (BomInfo)topBomInfoList.get(j);
                            topBomIDList.add(topZZBom.getId().toString());
                        }
                    }
                }
                if (topBomIDList != null && topBomIDList.size() > 0) {
                    sql.setLength(0);
                    sql.append(" Select distinct h.fnumber ");
                    sql.append(" from t_mm_bom h ");
                    sql.append(" inner join t_mm_pbom ph on ph.fbomid = h.fid ");
                    sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                    sql.append(" And h.fdesignmodeid is not null ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    errorNumber = BomUtil.getErrorNumber(ctx, rs);
                    if (errorNumber != null) {
                        successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePBom_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                        return successful;
                    }
                    sql.setLength(0);
                    sql.append(" Select distinct h.fnumber ");
                    sql.append(" from t_mm_bom h ");
                    sql.append(" inner join t_mm_bomchange ch on ch.fbomid = h.fid ");
                    sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                    sql.append(" And h.fdesignmodeid is not null ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    errorNumber = BomUtil.getErrorNumber(ctx, rs);
                    if (errorNumber != null) {
                        successful = ResourceBase.getString((String)RESURL, (String)"BomIsCreateChange_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                        return successful;
                    }
                    sql.setLength(0);
                    sql.append(" Select distinct h.fnumber ");
                    sql.append(" from t_mm_bom h ");
                    sql.append(" inner join t_mm_manufactureorder mo on mo.fbomid = h.fid ");
                    sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                    sql.append(" And h.fdesignmodeid is not null ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    errorNumber = BomUtil.getErrorNumber(ctx, rs);
                    if (errorNumber != null) {
                        successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePO_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                        return successful;
                    }
                    sql.setLength(0);
                    sql.append(" Select distinct h.fnumber ");
                    sql.append(" from t_mm_bom h ");
                    sql.append(" inner join t_sm_subcontractorderentry so on so.fbomid = h.fid ");
                    sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                    sql.append(" And h.fdesignmodeid is not null ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    errorNumber = BomUtil.getErrorNumber(ctx, rs);
                    if (errorNumber != null) {
                        successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreateWWOrder_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                        return successful;
                    }
                    sql.setLength(0);
                    sql.append(" Select distinct h.fnumber ");
                    sql.append(" from t_mm_bom h ");
                    sql.append(" inner join t_mrp_pmrpplannedorder pd on pd.fbominterid = h.fid ");
                    sql.append(" where h.fid in(").append(SQLUtil.arrayToString((Object[])topBomIDList.toArray())).append(") ");
                    sql.append(" And h.fbasestatus = 4 ");
                    sql.append(" And h.fdesignmodeid is not null ");
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    errorNumber = BomUtil.getErrorNumber(ctx, rs);
                    if (errorNumber != null) {
                        successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsCreatePlannedOrder_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                        return successful;
                    }
                }
            } else {
                sql.append(" Select distinct h.fnumber ");
                sql.append(" from t_mm_bom h ");
                sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
                sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
                sql.append(" And h.fbasestatus = 4 ");
                sql.append(" And h.fdesignmodeid is not null ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                errorNumber = BomUtil.getErrorNumber(ctx, rs);
                if (errorNumber != null) {
                    successful = BomUtil.getBomTypeName(ctx, bomEntryIDList.get(0)) + ResourceBase.getString((String)RESURL, (String)"BomIsAudit_NumberList", (Locale)ctx.getLocale(), (Object[])new Object[]{errorNumber});
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return successful;
    }

    public static String getBomTypeName(Context ctx, String bomentryID) throws BOSException, EASBizException, SQLException {
        String bomtypeName = "";
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append(" Select h.fbomtype ");
        sql.append(" from t_mm_bom h ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
        sql.append(" where d.fid = ?  ");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bomentryID});
        if (rs.next()) {
            int bomtype = rs.getInt("fbomtype");
            return BOMTypeEnum.getEnum((int)bomtype).getAlias(ctx.getLocale());
        }
        return bomtypeName;
    }

    public static String getErrorNumber(Context ctx, IRowSet rs) throws BOSException, EASBizException, SQLException {
        if (rs == null) {
            return null;
        }
        String errorNumber = null;
        while (rs.next()) {
            if (errorNumber == null) {
                errorNumber = rs.getString("fnumber");
                continue;
            }
            errorNumber = errorNumber + "\u3001" + rs.getString("fnumber");
        }
        return errorNumber;
    }

    public static TrackNumberInfo getBomTrackNumberInfo(Context ctx, BomInfo bomInfo, String isMaxOrMin) throws BOSException, EASBizException {
        TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
        StringBuilder sql = new StringBuilder();
        sql.append(" Select top 1 t.fid,t.fnumber,t.fname_l2 as fname ");
        sql.append(" from t_mm_bomentry a ");
        if (isMaxOrMin.equals("MAX")) {
            sql.append(" left outer join t_mm_tracknumber t on a.fendcarnoid = t.fid");
        } else {
            sql.append(" left outer join t_mm_tracknumber t on a.fbegincarnoid = t.fid");
        }
        sql.append(" where a.fparentid = '").append(bomInfo.getId().toString()).append("'");
        IRowSet rs = null;
        rs = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                if (rs.getString("fid") == null || "".equals(rs.getString("fid"))) {
                    return null;
                }
                trackNumberInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                trackNumberInfo.setNumber(rs.getString("fnumber"));
                trackNumberInfo.setName(rs.getString("fname"));
                return trackNumberInfo;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static List<TrackNumberInfo> getBomTrackNumberInfoList(Context ctx, BomInfo bomInfo) throws BOSException, EASBizException {
        TrackNumberInfo btInfo = BomUtil.getBomTrackNumberInfo(ctx, bomInfo, "MIN");
        TrackNumberInfo etInfo = BomUtil.getBomTrackNumberInfo(ctx, bomInfo, "MAX");
        TrackNumberInfo trackNumberInfo = null;
        ProjectInfo projectInfo = null;
        ArrayList<TrackNumberInfo> returnList = new ArrayList<TrackNumberInfo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" Select t.fid,t.fnumber,t.fname_l2 as fname,p.fid as fprojectid,p.fnumber as fprojectnumber,p.fname_l2 as fprojectname ");
        sql.append(" from t_mm_projectcar a ");
        sql.append(" inner join t_mm_tracknumber t on t.fid = a.ftracknumberid");
        sql.append(" left outer join t_mm_project p on p.fid = a.fprojectid");
        sql.append(" where t.fnumber >= '").append(btInfo.getNumber()).append("' and t.fnumber <= '").append(etInfo.getNumber()).append("' ");
        sql.append(" order by t.fnumber ");
        IRowSet rs = null;
        rs = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                trackNumberInfo = new TrackNumberInfo();
                trackNumberInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                trackNumberInfo.setNumber(rs.getString("fnumber"));
                trackNumberInfo.setName(rs.getString("fname"));
                if (rs.getString("fprojectid") != null) {
                    projectInfo = new ProjectInfo();
                    projectInfo.setId(BOSUuid.read((String)rs.getString("fprojectid")));
                    projectInfo.setNumber(rs.getString("fprojectnumber"));
                    projectInfo.setName(rs.getString("fprojectname"));
                } else {
                    projectInfo = null;
                }
                trackNumberInfo.put("projectInfo", (Object)projectInfo);
                returnList.add(trackNumberInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnList;
    }

    public static int checkBomisValid(Context ctx, BigDecimal qty, MeasureUnitInfo unitInfo, BomInfo bomInfo) throws BOSException, EASBizException {
        if (bomInfo == null) {
            return 0;
        }
        if (bomInfo.getProductBaseQty().compareTo(qty) != 0) {
            return -1;
        }
        if (unitInfo != null && bomInfo.getUnit() != null && !unitInfo.getId().toString().equals(bomInfo.getUnit().getId().toString())) {
            return -2;
        }
        return 0;
    }

    public static void showBomChangeEditUI(String bomId) throws EASBizException, BOSException {
        BomInfo bomInfo;
        boolean ishand = false;
        if (EmptyUtil.isEmpty((String)bomId)) {
            MsgBox.showError((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.basedata.BOMResource", (String)"MfgBom_Msg_0001"));
            SysUtil.abort();
        }
        if ((bomInfo = BomFactory.getRemoteInstance().getBomInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bomId)))).getBaseStatus() != BillBaseStatusEnum.AUDITED) {
            MsgBox.showError((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.basedata.BOMResource", (String)"MfgBom_Msg_0003"));
            SysUtil.abort();
        }
        BomEntryInfo entryInfo = null;
        BOSObjectType type = null;
        for (int i = 0; i < bomInfo.getEntrys().size(); ++i) {
            entryInfo = bomInfo.getEntrys().get(i);
            if (!EmptyUtil.isEmpty((String)entryInfo.getSourceProcessId())) {
                ishand = true;
                break;
            }
            if (EmptyUtil.isEmpty((String)entryInfo.getSourceBillEntryId()) || (type = BOSUuid.getBOSObjectType((String)entryInfo.getSourceBillEntryId(), (boolean)true)).toString().equals("B0D7AB69")) continue;
            ishand = true;
            break;
        }
        if (ishand) {
            MsgBox.showError((String)ResourceUtils.getMessage((String)"com.kingdee.eas.mm.basedata.BOMResource", (String)"MfgBom_Msg_0004"));
            SysUtil.abort();
        }
        BomChangeInfo bomChangeInfo = BomChangeBillAuditFacadeFactory.getRemoteInstance().addBomChangeInfoByBom(bomId, null);
        IUIWindow uiWindow = null;
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"bomChangeInfo", (Object)bomChangeInfo);
        String uiClass = "com.kingdee.eas.mm.basedata.client.BomChangeEditUI";
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.mm.basedata.client.BomChangeEditUI", (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public static void checkPermission(String permissionItemNumber, String storageOrgUnitID) throws EASBizException, BOSException {
        if (storageOrgUnitID == null || permissionItemNumber == null) {
            return;
        }
        if (storageOrgUnitID.trim().length() == 0 || permissionItemNumber.trim().length() == 0) {
            return;
        }
        ObjectUuidPK userObjectUuidPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)userObjectUuidPK, OrgType.Storage, (IObjectPK)new ObjectUuidPK(storageOrgUnitID), permissionItemNumber);
    }

    public static boolean needTrackWhere(BomInfo bomInfo) {
        return bomInfo != null && bomInfo.getDesignMode() != null && !bomInfo.getDesignMode().isProject() && bomInfo.getDesignMode().isTrackNumber();
    }

    public static boolean needProjectWhere(BomInfo bomInfo) {
        return bomInfo != null && bomInfo.getDesignMode() != null && bomInfo.getDesignMode().isProject();
    }

    public static BomCollection getbomCollection(Context ctx, List bomEntryIDList) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.setLength(0);
        sql.append(" Select distinct h.fid ");
        sql.append(" from t_mm_bom h ");
        sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
        sql.append(" where d.fid in(").append(SQLUtil.arrayToString((Object[])bomEntryIDList.toArray())).append(") ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> bomIDset = new HashSet<String>();
        while (rs.next()) {
            bomIDset.add(rs.getString("fid"));
        }
        if (bomIDset != null && bomIDset.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", bomIDset, CompareType.INCLUDE));
            viewInfo.setFilter(filterInfo);
            viewInfo.setSelector(BomUtil.getBomHeadSelectSic());
            BomCollection bomCollection = BomFactory.getLocalInstance((Context)ctx).getBomCollection(viewInfo);
            return bomCollection;
        }
        return null;
    }

    private static final SelectorItemCollection getBomHeadSelectSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bomtype"));
        sic.add(new SelectorItemInfo("designMode.*"));
        sic.add(new SelectorItemInfo("mainTenanceLevel.id"));
        return sic;
    }

    public static List getTopZZBomInfo(Context ctx, BomInfo bomInfo) throws BOSException, EASBizException, SQLException {
        BomInfo topZZBomInfo = null;
        ArrayList<BomInfo> topBomInfoList = new ArrayList<BomInfo>();
        StringBuilder sql = new StringBuilder();
        String fbomid = null;
        IRowSet rs = null;
        ArrayList<String> bomIDList = new ArrayList<String>();
        ArrayList<String> topBomIDList = new ArrayList<String>();
        bomIDList.add(bomInfo.getId().toString());
        ArrayList<String> execIDList = new ArrayList<String>();
        TrackNumberInfo trackNumberInfo = null;
        HashMap<String, BomInfo> bomIDInfoMap = new HashMap<String, BomInfo>();
        bomIDInfoMap.put(bomInfo.getId().toString(), bomInfo);
        while (bomIDList.size() > 0) {
            fbomid = ((String)bomIDList.get(0)).toString();
            if (execIDList.contains(fbomid)) {
                bomIDList.remove(fbomid);
                continue;
            }
            execIDList.add(fbomid);
            BomInfo loopBomInfo = (BomInfo)bomIDInfoMap.get(fbomid);
            trackNumberInfo = null;
            if (BomUtil.needTrackWhere(loopBomInfo)) {
                trackNumberInfo = BomUtil.getBomTrackNumberInfo(ctx, bomInfo, "MIN");
            }
            sql.setLength(0);
            sql.append(" Select distinct h.fid,h.fmaterialid,h.fstorageorgunitid,d.fconsumefixqty As Fqty ");
            sql.append(" from t_mm_bom h ");
            sql.append(" inner join t_mm_bomentry d on h.fid = d.fparentid ");
            sql.append(" where Exists( select 1 from t_mm_bom a  ");
            sql.append(" where a.fid = '").append(fbomid).append("'  ");
            sql.append(" and d.fmaterialid = a.fmaterialid ");
            sql.append(" and d.fsupplystorageorgunitid = a.fstorageorgunitid  ");
            sql.append(" and isnull(a.FMainTenanceLevelID,'*') = isnull(h.FMainTenanceLevelID,'*')  ");
            if (BomUtil.needProjectWhere(loopBomInfo)) {
                sql.append(" and a.fprojectid  = h.fprojectid ");
            }
            sql.append(" ) and h.fbasestatus = 4 ");
            if (BomUtil.needTrackWhere(loopBomInfo) && trackNumberInfo != null) {
                sql.append(" and  d.fbegincarnoid = '" + trackNumberInfo.getId().toString() + "' ");
            }
            sql.append(" and d.fmaterialprop = ").append(10020);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs == null || rs.size() < 1) {
                bomIDList.remove(fbomid);
                if (topBomIDList.contains(fbomid)) continue;
                topZZBomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(fbomid), BomUtil.getBomHeadSelectSic());
                topBomInfoList.add(topZZBomInfo);
                topBomIDList.add(fbomid);
                continue;
            }
            while (rs.next()) {
                String tempbomid = rs.getString("fid");
                if (bomIDList.contains(tempbomid)) continue;
                bomIDList.add(tempbomid);
                topZZBomInfo = BomFactory.getLocalInstance((Context)ctx).getBomInfo((IObjectPK)new ObjectUuidPK(tempbomid), BomUtil.getBomHeadSelectSic());
                if (!topBomIDList.contains(tempbomid)) {
                    topBomInfoList.add(topZZBomInfo);
                    topBomIDList.add(tempbomid);
                }
                bomIDInfoMap.put(tempbomid, topZZBomInfo);
            }
            bomIDList.remove(fbomid);
        }
        if (topBomInfoList.size() < 1) {
            topBomInfoList.add(bomInfo);
        }
        return topBomInfoList;
    }

    public static final DesignModeInfo getDesignModeByMaterialOrgUnit(Context ctx, String materialid, String storageOrgUnitID, String materialNumber) throws BOSException, EASBizException {
        String fdsid = BomUtil.getDesignModeByMaterialOrgUnitID(ctx, materialid, storageOrgUnitID, materialNumber);
        if (fdsid == null || "".equals(fdsid)) {
            return null;
        }
        return DesignModeFactory.getLocalInstance((Context)ctx).getDesignModeInfo((IObjectPK)new ObjectUuidPK(fdsid));
    }

    public static final String getDesignModeByMaterialOrgUnitID(Context ctx, String materialid, String storageOrgUnitID, String materialNumber) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        IRowSet rs = null;
        sql.append("  Select distinct ds.fid as fid ");
        sql.append("  from t_bd_materialplan mp ");
        sql.append("  inner join T_MM_DESIGNMODEENTRY dse on dse.fmanufacturestrategyid = mp.fmanufacturestrategyid ");
        sql.append("  and isnull(dse.fisolatedrule,'NONE') = isnull(mp.fisolatedrule,'NONE') ");
        sql.append("  inner join t_mm_designmode ds on dse.fparentid = ds.fid and ds.fstatus = 8 ");
        if (materialid == null) {
            sql.append("  inner join t_bd_material m on m.fid =mp.fmaterialid ");
            sql.append("  where m.fnumber = ? ");
            sql.append(" and mp.forgunit = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialNumber, storageOrgUnitID});
        } else {
            sql.append("  where mp.fmaterialid = ? ");
            sql.append(" and mp.forgunit = ? ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{materialid, storageOrgUnitID});
        }
        try {
            if (rs.next()) {
                return rs.getString("fid");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static List<String> getAllDesignModeIDList() throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add("ySgAAAADJLPK0P+Y");
        idList.add("ySgAAAADJLDK0P+Y");
        idList.add("ySgAAAADJLbK0P+Y");
        idList.add("ySgAAAADJLnK0P+Y");
        return idList;
    }

    public static List<TrackNumberInfo> getOrderBomTrackNumberInfoList(Context ctx, String bomID) throws BOSException, EASBizException {
        TrackNumberInfo trackNumberInfo = null;
        Object projectInfo = null;
        ArrayList<TrackNumberInfo> returnList = new ArrayList<TrackNumberInfo>();
        StringBuilder sql = new StringBuilder();
        sql.append(" Select t.fid,t.fnumber,t.fname_l2 as fname ");
        sql.append(" from t_mm_orderbompt a ");
        sql.append(" inner join t_mm_tracknumber t on t.fid = a.ftrackid");
        sql.append(" where a.forderid = '" + bomID + "' ");
        sql.append(" order by t.fnumber ");
        IRowSet rs = null;
        rs = ctx == null ? SQLFacadeFactory.getRemoteInstance().getRowset(sql.toString()) : DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                trackNumberInfo = new TrackNumberInfo();
                trackNumberInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                trackNumberInfo.setNumber(rs.getString("fnumber"));
                trackNumberInfo.setName(rs.getString("fname"));
                returnList.add(trackNumberInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return returnList;
    }
}

