/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.zjreport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.mm.basedata.BomException;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.common.util.MMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.zjreport.app.AbstractWorkshopMSAnalysisRPTFacadeControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WorkshopMSAnalysisRPTFacadeControllerBean
extends AbstractWorkshopMSAnalysisRPTFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.zjreport.app.WorkshopMSAnalysisRPTFacadeControllerBean");
    private static final long serialVersionUID = 8696346081666763332L;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String[] sumColumns;
        MMUtils.releaseTmpTable((Context)ctx, (String)params.getString("tempTable"));
        String storageOrgUnitFrom = params.getObject("storageOrgUnitFrom").toString();
        String storageOrgUnitTo = params.getObject("storageOrgUnitTo").toString();
        String projectNumberFrom = params.getObject("projectNumberFrom").toString();
        String projectNumberTo = params.getObject("projectNumberTo").toString();
        String traceNumberFrom = params.getObject("traceNumberFrom").toString();
        String traceNumberTo = params.getObject("traceNumberTo").toString();
        String startDate = params.getObject("startDate").toString();
        String endDate = params.getObject("endDate").toString();
        String materialFrom = params.getObject("materialFrom").toString();
        String materialTo = params.getObject("materialTo").toString();
        String process = params.getObject("process").toString();
        String productFrom = params.getObject("productFrom").toString();
        String productTo = params.getObject("productTo").toString();
        String saveStatus = params.getObject("saveStatus").toString();
        String submitStatus = params.getObject("submitStatus").toString();
        String auditStatus = params.getObject("auditStatus").toString();
        String assignStatus = params.getObject("assignStatus").toString();
        StringBuffer billStatus = new StringBuffer();
        String status = null;
        StringBuffer sql = new StringBuffer();
        String resultTableName = null;
        try {
            sql.append("Create Table WorkshopMSAnalysisRPT(\r\n");
            sql.append("FID VARCHAR(44),\r\n");
            sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
            sql.append("FStorageOrgUnitNumber NVARCHAR(80),\r\n");
            sql.append("FStorageOrgUnitName NVARCHAR(80),\r\n");
            sql.append("FProjectID VARCHAR(44),\r\n");
            sql.append("FProjectNumber NVARCHAR(80),\r\n");
            sql.append("FProjectName NVARCHAR(80),\r\n");
            sql.append("FProductID VARCHAR(44),\r\n");
            sql.append("FProductNumber NVARCHAR(80),\r\n");
            sql.append("FProductName NVARCHAR(80),\r\n");
            sql.append("FTraceID VARCHAR(44),\r\n");
            sql.append("FTraceNumber NVARCHAR(80),\r\n");
            sql.append("FCompareTraceID VARCHAR(44),\r\n");
            sql.append("FCompareTraceNumber NVARCHAR(80),\r\n");
            sql.append("FMaterialID VARCHAR(44),\r\n");
            sql.append("FMaterialNumber NVARCHAR(80),\r\n");
            sql.append("FMaterialName NVARCHAR(80),\r\n");
            sql.append("FMaterialModel NVARCHAR(80),\r\n");
            sql.append("FQTY Numeric(21,8),\r\n");
            sql.append("FUnitID VARCHAR(80),\r\n");
            sql.append("FUnitNumber NVARCHAR(80),\r\n");
            sql.append("FUnitName NVARCHAR(80),\r\n");
            sql.append("FWarehouseID VARCHAR(44),\r\n");
            sql.append("FWarehouseNumber NVARCHAR(80),\r\n");
            sql.append("FWarehouseName NVARCHAR(80),\r\n");
            sql.append("FPlanQty Numeric(21,8),\r\n");
            sql.append("FSendQty Numeric(21,8),\r\n");
            sql.append("FWarehouseStock Numeric(21,8),\r\n");
            sql.append("FStorageOrgUnitStock Numeric(21,8),\r\n");
            sql.append("FStockoutQty Numeric(21,8),\r\n");
            sql.append("FProperties NVARCHAR(80),\r\n");
            sql.append("FProcess NVARCHAR(80),\r\n");
            sql.append("FRemark NVARCHAR(80)\r\n");
            sql.append(")\r\n");
            logger.debug((Object)("Create WorkshopMSAnalysisRPT Result Table SQL:\r\n" + sql.toString()));
            resultTableName = MMUtils.createTmpTable((Context)ctx, (String)sql.toString());
            params.setString("tempTable", resultTableName);
            sql.setLength(0);
            sql.append(this.getInsertResultTempTableSQL(resultTableName));
            sql.append("Select\r\n");
            sql.append("MO.FID,\r\n");
            sql.append("MO.FStorageOrgUnitID,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("MO.FProjectID,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("MO.CFMAUNMaterialID,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("MO.FTrackID,\r\n");
            sql.append("Null,\r\n");
            sql.append("TA.FUNITrackNumberID,\r\n");
            sql.append("Null,\r\n");
            sql.append("MOSE.FMaterialID,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("(\r\n");
            sql.append("Select\r\n");
            sql.append("Top 1\r\n");
            sql.append("BE.FDefaultWarehouseID\r\n");
            sql.append("From T_MM_BOMEntry BE\r\n");
            sql.append("Where\r\n");
            sql.append("BE.FParentID=B.FID\r\n");
            sql.append("And BE.FMaterialID=MOSE.FMaterialID\r\n");
            sql.append("),\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("IsNull(MOSE.FPlannedQTY,0),\r\n");
            sql.append("IsNull(MOSE.FActIssueQTY,0),\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("Null,\r\n");
            sql.append("PO.CFBOMFlow,\r\n");
            sql.append("MO.FDescription\r\n");
            sql.append("From T_MM_ManufactureOrder MO\r\n");
            sql.append("Inner Join T_MM_MFTOrderStock MOSE On MOSE.FParentID=MO.FID\r\n");
            sql.append("Inner Join T_MM_BOM B On B.FID=MO.FBOMID\r\n");
            sql.append("Left Join T_ORG_Storage S On S.FID=MO.FStorageOrgUnitID\r\n");
            sql.append("Left Join T_MM_Project P On P.FID=MO.FProjectID\r\n");
            sql.append("Left Join T_BD_Material MM On MM.FID=MOSE.FMaterialID\r\n");
            sql.append("Left Join T_MM_TrackNumber T On T.FID=MO.FTrackID\r\n");
            sql.append("Left Join T_EMM_TrackNumberAssociation TA On TA.FELETrackNumberID=MO.FTrackID\r\n");
            sql.append("Left Join T_BD_Material BP On BP.FID=MO.CFMAUNMaterialID\r\n");
            sql.append("Left Join T_MM_PlannedOrder PO On PO.FID=MO.FSourceBillID\r\n");
            sql.append("Where\r\n");
            sql.append("1=1\r\n");
            sql.append("And B.FBomType=").append(45).append("\r\n");
            if (storageOrgUnitFrom != null && storageOrgUnitFrom.trim().length() > 0) {
                sql.append("And S.FNumber>='" + storageOrgUnitFrom + "'\r\n");
            }
            if (storageOrgUnitTo != null && storageOrgUnitTo.trim().length() > 0) {
                sql.append("And S.FNumber<='" + storageOrgUnitTo + "'\r\n");
            }
            if (projectNumberFrom != null && projectNumberFrom.trim().length() > 0) {
                sql.append("And P.FNumber>='" + projectNumberFrom + "'\r\n");
            }
            if (projectNumberTo != null && projectNumberTo.trim().length() > 0) {
                sql.append("And P.FNumber<='" + projectNumberTo + "'\r\n");
            }
            if (traceNumberFrom != null && traceNumberFrom.trim().length() > 0) {
                sql.append("And T.FNumber>='" + traceNumberFrom + "'\r\n");
            }
            if (traceNumberTo != null && traceNumberTo.trim().length() > 0) {
                sql.append("And T.FNumber<='" + traceNumberTo + "'\r\n");
            }
            if (startDate != null && startDate.trim().length() > 0) {
                sql.append("And To_CHAR(MO.FPlanBeginDate,'yyyy-mm-dd')>='" + startDate + "'\r\n");
            }
            if (endDate != null && endDate.trim().length() > 0) {
                sql.append("And To_CHAR(MO.FPlanBeginDate,'yyyy-mm-dd')<='" + endDate + "'\r\n");
            }
            if (productFrom != null && productFrom.trim().length() > 0) {
                sql.append("And BP.FNumber>='" + productFrom + "'\r\n");
            }
            if (productTo != null && productTo.trim().length() > 0) {
                sql.append("And BP.FNumber<='" + productTo + "'\r\n");
            }
            if (process != null && process.trim().length() > 0) {
                sql.append("And PO.CFBOMFlow Like '%" + process + "%'\r\n");
            }
            if (saveStatus != null && saveStatus.trim().length() > 0 && Boolean.valueOf(saveStatus).booleanValue()) {
                billStatus.append("Or MO.FBaseStatus=").append(1).append("\r\n");
            }
            if (submitStatus != null && submitStatus.trim().length() > 0 && Boolean.valueOf(submitStatus).booleanValue()) {
                billStatus.append("Or MO.FBaseStatus=").append(2).append("\r\n");
            }
            if (auditStatus != null && auditStatus.trim().length() > 0 && Boolean.valueOf(auditStatus).booleanValue()) {
                billStatus.append("Or MO.FBaseStatus=").append(4).append("\r\n");
            }
            if (saveStatus != null && assignStatus.trim().length() > 0 && Boolean.valueOf(assignStatus).booleanValue()) {
                billStatus.append("Or MO.FBaseStatus=").append(5).append("\r\n");
            }
            if (billStatus != null && billStatus.toString().length() > 0) {
                status = billStatus.toString();
                status = status.substring(3, status.length());
                sql.append("And (\r\n");
                sql.append(status);
                sql.append(")\r\n");
            }
            logger.debug((Object)("Select WorkshopMSAnalysisRPT PlannedOrder SQL:\r\n" + sql.toString()));
            SQLUtils.execute((Context)ctx, (String)sql.toString());
            this.generateResult(ctx, resultTableName, materialFrom, materialTo);
            params = this._query(ctx, params, 0, 50);
        }
        catch (Exception e) {
            MMUtils.releaseTmpTable((Context)ctx, resultTableName);
            throw new BOSException((Throwable)e);
        }
        if (params.getObject("sumColumns") != null && params.getObject("sumColumns") instanceof String[] && (sumColumns = (String[])params.getObject("sumColumns")).length > 0) {
            sql.setLength(0);
            sql.append("Select\r\n");
            for (String sumColumn : sumColumns) {
                sql.append("SUM(F" + sumColumn + ") \"" + sumColumn + "\",\r\n");
            }
            sql.append("'SUM' \"sumText\"\r\n");
            sql.append("From " + resultTableName + "\r\n");
            logger.debug((Object)("Get WorkshopMSAnalysisRPT Sum Row SQL:\r\n" + sql.toString()));
            RptRowSet sumData = this.executeQuery(sql.toString(), null, ctx);
            params.setObject("sumData", (Object)sumData);
        }
        MMUtils.releaseTmpTable((Context)ctx, (String)resultTableName);
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("R.FProjectNumber,\r\n");
        sql.append("R.FProjectName,\r\n");
        sql.append("R.FTraceNumber,\r\n");
        sql.append("R.FProductNumber,\r\n");
        sql.append("R.FProductName,\r\n");
        sql.append("R.FMaterialNumber,\r\n");
        sql.append("R.FMaterialName,\r\n");
        sql.append("R.FMaterialModel,\r\n");
        sql.append("R.FUnitNumber,\r\n");
        sql.append("R.FUnitName,\r\n");
        sql.append("R.FWarehouseNumber,\r\n");
        sql.append("R.FWarehouseName,\r\n");
        sql.append("R.FPlanQTY,\r\n");
        sql.append("R.FWarehouseStock,\r\n");
        sql.append("R.FStorageOrgUnitStock,\r\n");
        sql.append("R.FSendQTY,\r\n");
        sql.append("R.FProcess\r\n");
        sql.append("From (\r\n");
        sql.append("Select\r\n");
        sql.append("FProjectNumber \"FProjectNumber\",\r\n");
        sql.append("FProjectName \"FProjectName\",\r\n");
        sql.append("FProductNumber \"FProductNumber\",\r\n");
        sql.append("FProductName \"FProductName\",\r\n");
        sql.append("FTraceNumber \"FTraceNumber\",\r\n");
        sql.append("FCompareTraceNumber \"FCompareTraceNumber\",\r\n");
        sql.append("FMaterialNumber \"FMaterialNumber\",\r\n");
        sql.append("FMaterialName \"FMaterialName\",\r\n");
        sql.append("FMaterialModel \"FMaterialModel\",\r\n");
        sql.append("FQTY \"FQTY\",\r\n");
        sql.append("FUnitNumber \"FUnitNumber\",\r\n");
        sql.append("FUnitName \"FUnitName\",\r\n");
        sql.append("FWarehouseNumber \"FWarehouseNumber\",\r\n");
        sql.append("FWarehouseName \"FWarehouseName\",\r\n");
        sql.append("FPlanQTY \"FPlanQTY\",\r\n");
        sql.append("FSendQTY \"FSendQTY\",\r\n");
        sql.append("FWarehouseStock \"FWarehouseStock\",\r\n");
        sql.append("FStorageOrgUnitStock \"FStorageOrgUnitStock\",\r\n");
        sql.append("FStockoutQty \"FStockoutQTY\",\r\n");
        sql.append("FProperties \"FProperties\",\r\n");
        sql.append("FProcess \"FProcess\",\r\n");
        sql.append("FRemark \"FRemark\",\r\n");
        sql.append("FMaterialNumber \"FOrder\"\r\n");
        sql.append("From ").append(params.getString("tempTable")).append("\r\n");
        sql.append("Union\r\n");
        sql.append("Select\r\n");
        sql.append("Null,\r\n");
        if (EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource.subtotal") != null && EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource.subtotal").toString().trim().length() >= 0) {
            sql.append("N'").append(EASResource.getString((String)"com.kingdee.eas.framework.report.CommRptResource.subtotal")).append("',\r\n");
        } else {
            sql.append("Null,\r\n");
        }
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("SUM(FPlanQTY),\r\n");
        sql.append("SUM(FSendQTY),\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("SUM(SUM(Distinct WS.FWarehouseStock))\r\n");
        sql.append("From " + params.getString("tempTable") + " WS\r\n");
        sql.append("Where\r\n");
        sql.append("WS.FMaterialID=T.FMaterialID\r\n");
        sql.append("Group By\r\n");
        sql.append("WS.FMaterialID,\r\n");
        sql.append("WS.FWarehouseID\r\n");
        sql.append("),\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("SOUS.FStorageOrgUnitStock\r\n");
        sql.append("From " + params.getString("tempTable") + " SOUS\r\n");
        sql.append("Where\r\n");
        sql.append("SOUS.FMaterialID=T.FMaterialID\r\n");
        sql.append("),\r\n");
        sql.append("SUM(FStockoutQTY),\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("T.FMaterialNumber || N' SUM' \"FOrder\"\r\n");
        sql.append("From " + params.getString("tempTable") + " T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FMaterialID,\r\n");
        sql.append("T.FMaterialNumber\r\n");
        sql.append(") R\r\n");
        sql.append("Order By\r\n");
        sql.append("R.FOrder,\r\n");
        sql.append("R.FTraceNumber\r\n");
        logger.debug((Object)("Select WorkshopMSAnalysisRPT Result SQL:\r\n" + sql.toString()));
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        params.setObject("rowSet", (Object)rs);
        params.setInt("rowCount", rs.getRowCount());
        return params;
    }

    protected String bomExpand(Context ctx, String moID, String storageOrgUnitID, String projectID, String traceID, String bomID) throws BOSException {
        String expendBomTempTable;
        block6: {
            expendBomTempTable = this.createBOMExpandTempTable(ctx);
            try {
                StringBuffer sql = new StringBuffer();
                sql.append(this.getInsertBOMExpandTempTableSQL(expendBomTempTable));
                sql.append("Select\r\n");
                sql.append("0,\r\n");
                sql.append("IsNull(MP.FManufactureStrategyID,'NUnM+gEcEADgAA3cwKgL09g0uEU='),\r\n");
                sql.append("'").append(storageOrgUnitID).append("',\r\n");
                sql.append("'").append(projectID).append("',\r\n");
                sql.append("'").append(traceID).append("',\r\n");
                sql.append("MO.FMaterialID,\r\n");
                sql.append("Null,\r\n");
                sql.append("MP.FIsolatedRule,\r\n");
                sql.append("MO.FQTY,\r\n");
                sql.append("MO.FQTY,\r\n");
                sql.append("B.FID,\r\n");
                sql.append("B.FBOMType,\r\n");
                sql.append("B.FUsageType,\r\n");
                sql.append("MP.FIsConfigable,\r\n");
                sql.append("Null\r\n");
                sql.append("From T_MM_ManufactureOrder MO\r\n");
                sql.append("Inner Join T_MM_BOM B On B.FID=MO.FBomID\r\n");
                sql.append("Inner Join T_BD_MaterialPlan MP On\r\n");
                sql.append("MP.FOrgUnit=MO.FStorageOrgUnitID\r\n");
                sql.append("And MP.FMaterialID=MO.FMaterialID\r\n");
                sql.append("Where\r\n");
                sql.append("1=1\r\n");
                sql.append("And MO.FID='").append(moID).append("'\r\n");
                logger.debug((Object)("Insert WorkshopMSAnalysisRPT BOM Expend Top BOM:\r\n" + sql.toString()));
                int insertRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                if (insertRows <= 0) break block6;
                int expendLevel = 0;
                int orderBOMUpdateRows = 0;
                int mainBOMUpdateRows = 0;
                while (this.isCanExpand(ctx, expendBomTempTable, expendLevel)) {
                    if (expendLevel > 50) {
                        throw new BomException(BomException.CYCLE);
                    }
                    sql.setLength(0);
                    sql.append(this.getInsertBOMExpandTempTableSQL(expendBomTempTable));
                    sql.append("Select\r\n");
                    sql.append(expendLevel + 1).append(",\r\n");
                    sql.append("IsNull(BEMP.FManufactureStrategyID,'NUnM+gEcEADgAA3cwKgL09g0uEU='),\r\n");
                    sql.append("'").append(storageOrgUnitID).append("',\r\n");
                    sql.append("Case\r\n");
                    sql.append("When\r\n");
                    sql.append("T.FBOMType=").append(45).append("\r\n");
                    sql.append("And IsNull(BEMP.FManufactureStrategyID,'NUnM+gEcEADgAA3cwKgL09g0uEU=') In\r\n");
                    sql.append("(\r\n");
                    sql.append("'Null',\r\n");
                    sql.append("'fpPxtypCS/ihJ30GjB/UJtg0uEU=',\r\n");
                    sql.append("'qAYbemEdG9ngQKjAYj0V1dg0uEU=',\r\n");
                    sql.append("'qAXoUB/tBg/gQKjAYj0WQ9g0uEU=',\r\n");
                    sql.append("'qAYfaBzTrmLgQKjAYj0f3dg0uEU='\r\n");
                    sql.append(")\r\n");
                    sql.append("Then '999999999'\r\n");
                    sql.append("Else T.FProjectID\r\n");
                    sql.append("End,\r\n");
                    sql.append("Case\r\n");
                    sql.append("When\r\n");
                    sql.append("T.FBOMType=").append(45).append("\r\n");
                    sql.append("And IsNull(BEMP.FManufactureStrategyID,'NUnM+gEcEADgAA3cwKgL09g0uEU=') In\r\n");
                    sql.append("(\r\n");
                    sql.append("'Null',\r\n");
                    sql.append("'qAXoUB/uBg/gQKjAYj0WQ9g0uEU=',\r\n");
                    sql.append("'GE2FIa4GQ6uhdx0RDGuibtg0uEU='\r\n");
                    sql.append(")\r\n");
                    sql.append("And BEMP.FIsolatedRule='").append("ITEM").append("'\r\n");
                    sql.append("Then '999999999'\r\n");
                    sql.append("Else T.FTraceID\r\n");
                    sql.append("End,\r\n");
                    sql.append("BE.FMaterialID,\r\n");
                    sql.append("BE.FDefaultWarehouseID,\r\n");
                    sql.append("BEMP.FIsolatedRule,\r\n");
                    sql.append("Case\r\n");
                    sql.append("When ").append(expendLevel).append("=0 Then IsNull(MOSE.FPlannedQTY,0)\r\n");
                    sql.append("When IsNull(BE.FConsumeType,0)=").append(20).append(" And ").append(expendLevel).append(">0 Then\r\n");
                    sql.append("T.FPlanQTY / B.FProductQTY * BE.FConsumeFixQTY\r\n");
                    sql.append("Else\r\n");
                    sql.append("((T.FPlanQTY * B.FProductBaseQty) * (BE.FProportion * 0.01)) / ((BE.FBaseProductRate * BE.FBaseRate) * B.FProductQTY)\r\n");
                    sql.append("End,\r\n");
                    sql.append("Case\r\n");
                    sql.append("When ").append(expendLevel).append("=0 Then IsNull(MOSE.FActIssueQTY,0)\r\n");
                    sql.append("When IsNull(BE.FConsumeType,0)=").append(20).append(" And ").append(expendLevel).append(">0 Then\r\n");
                    sql.append("T.FSendQTY / B.FProductQTY * BE.FConsumeFixQTY\r\n");
                    sql.append("Else\r\n");
                    sql.append("((T.FSendQTY * B.FProductBaseQty) * (BE.FProportion * 0.01)) / ((BE.FBaseProductRate * BE.FBaseRate) * B.FProductQTY)\r\n");
                    sql.append("End,\r\n");
                    sql.append("Null,\r\n");
                    sql.append("T.FBOMType,\r\n");
                    sql.append("T.FUsageType,\r\n");
                    sql.append("BEMP.FIsConfigable,\r\n");
                    sql.append("BE.CFBOMFlow\r\n");
                    sql.append("From ").append(expendBomTempTable).append(" t\r\n");
                    sql.append("Inner Join T_MM_BOM B On B.FID=T.FBOMID\r\n");
                    sql.append("Inner Join T_MM_BOMEntry BE On BE.FParentID=B.FID\r\n");
                    sql.append("Left Join T_BD_MaterialPlan BEMP On\r\n");
                    sql.append("BEMP.FOrgUnit='").append(storageOrgUnitID).append("'\r\n");
                    sql.append("And BEMP.FMaterialID=BE.FMaterialID\r\n");
                    sql.append("Left Join T_MM_MFTOrderStock MOSE On\r\n");
                    sql.append(expendLevel).append("=0\r\n");
                    sql.append("And MOSE.FParentID='").append(moID).append("'\r\n");
                    sql.append("And MOSE.FMaterialID=BE.FMaterialID\r\n");
                    sql.append("Where\r\n");
                    sql.append("1=1\r\n");
                    sql.append("And T.FLevel=").append(expendLevel).append("\r\n");
                    sql.append("And BE.FEffectiveDate<=CURDate()\r\n");
                    sql.append("And BE.FDisableDate>CURDate()\r\n");
                    sql.append("And (\r\n");
                    sql.append("(\r\n");
                    sql.append(expendLevel).append("=0\r\n");
                    sql.append("And MOSE.FMaterialID Is Not Null\r\n");
                    sql.append(")\r\n");
                    sql.append("Or ").append(expendLevel).append(">0\r\n");
                    sql.append(")\r\n");
                    logger.debug((Object)("Insert WorkshopMSAnalysisRPT BOM Expand Table Data SQL:\r\n" + sql.toString()));
                    insertRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                    if (insertRows >= 1) {
                        sql.setLength(0);
                        sql.append("Update " + expendBomTempTable + " T\r\n");
                        sql.append("Set (\r\n");
                        sql.append("FBOMID,\r\n");
                        sql.append("FBOMType\r\n");
                        sql.append(")\r\n");
                        sql.append("=\r\n");
                        sql.append("(\r\n");
                        sql.append("Select\r\n");
                        sql.append("B.FID,\r\n");
                        sql.append("B.FBOMType\r\n");
                        sql.append("From T_MM_BOM B\r\n");
                        sql.append("Inner Join T_MM_OrderBOMPT OBPT On OBPT.FOrderID=B.FID\r\n");
                        sql.append("Where\r\n");
                        sql.append("B.FBaseStatus=").append(4).append("\r\n");
                        sql.append("And B.FUsageType=").append(10).append("\r\n");
                        sql.append("And T.FUsageType=B.FUsageType\r\n");
                        sql.append("And B.FMaterialID=T.FMaterialID\r\n");
                        sql.append("And B.FStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
                        sql.append("And T.FBOMID Is Null\r\n");
                        sql.append("And T.FLevel=").append(expendLevel + 1).append("\r\n");
                        sql.append("And B.FBOMType=").append(45).append("\r\n");
                        sql.append("And T.FBOMType=B.FBOMType\r\n");
                        sql.append("And (\r\n");
                        sql.append("(\r\n");
                        sql.append("T.FManufactureStrategyID In\r\n");
                        sql.append("(\r\n");
                        sql.append("'Null',\r\n");
                        sql.append("'qAXoUB/uBg/gQKjAYj0WQ9g0uEU=',\r\n");
                        sql.append("'GE2FIa4GQ6uhdx0RDGuibtg0uEU='\r\n");
                        sql.append(")\r\n");
                        sql.append("And T.FIsolatedRule='").append("ITEM").append("'\r\n");
                        sql.append("And T.FProjectID=OBPT.FProjectID\r\n");
                        sql.append("And OBPT.FTrackID Is Null\r\n");
                        sql.append(")\r\n");
                        sql.append("Or\r\n");
                        sql.append("(\r\n");
                        sql.append("T.FManufactureStrategyID In\r\n");
                        sql.append("(\r\n");
                        sql.append("'Null',\r\n");
                        sql.append("'qAXoUB/uBg/gQKjAYj0WQ9g0uEU=',\r\n");
                        sql.append("'GE2FIa4GQ6uhdx0RDGuibtg0uEU='\r\n");
                        sql.append(")\r\n");
                        sql.append("And T.FIsolatedRule='").append("ITEM_TRACKNO").append("'\r\n");
                        sql.append("And T.FProjectID=OBPT.FProjectID\r\n");
                        sql.append("And T.FTraceID=OBPT.FTrackID\r\n");
                        sql.append(")\r\n");
                        sql.append("Or\r\n");
                        sql.append("(\r\n");
                        sql.append("T.FManufactureStrategyID In\r\n");
                        sql.append("(\r\n");
                        sql.append("'Null',\r\n");
                        sql.append("'fpPxtypCS/ihJ30GjB/UJtg0uEU=',\r\n");
                        sql.append("'qAYbemEdG9ngQKjAYj0V1dg0uEU=',\r\n");
                        sql.append("'qAXoUB/tBg/gQKjAYj0WQ9g0uEU=',\r\n");
                        sql.append("'qAYfaBzTrmLgQKjAYj0f3dg0uEU='\r\n");
                        sql.append(")\r\n");
                        sql.append("And OBPT.FProjectID Is Null\r\n");
                        sql.append("And T.FTraceID=OBPT.FTrackID\r\n");
                        sql.append(")\r\n");
                        sql.append(")\r\n");
                        sql.append(")\r\n");
                        sql.append("Where\r\n");
                        sql.append("FLevel=").append(expendLevel + 1).append("\r\n");
                        logger.debug((Object)("Update WorkshopMSAnalysisRPT Order BOM SQL:\r\n" + sql.toString()));
                        orderBOMUpdateRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                        sql = new StringBuffer();
                        sql.append("Update " + expendBomTempTable + " T\r\n");
                        sql.append("Set (\r\n");
                        sql.append("FBOMID,\r\n");
                        sql.append("FBOMType\r\n");
                        sql.append(")\r\n");
                        sql.append("=\r\n");
                        sql.append("(\r\n");
                        sql.append("Select\r\n");
                        sql.append("B.FID,\r\n");
                        sql.append("B.FBOMType\r\n");
                        sql.append("From T_MM_BOM B\r\n");
                        sql.append("Where\r\n");
                        sql.append("B.FBaseStatus=").append(4).append("\r\n");
                        sql.append("And B.FUsageType=").append(10).append("\r\n");
                        sql.append("And T.FUsageType=B.FUsageType\r\n");
                        sql.append("And B.FMaterialID=T.FMaterialID\r\n");
                        sql.append("And B.FStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
                        sql.append("And T.FBOMID Is Null\r\n");
                        sql.append("And T.FLevel=").append(expendLevel + 1).append("\r\n");
                        sql.append("And T.FIsconfigable=0\r\n");
                        sql.append("And B.FBOMType=").append(40).append("\r\n");
                        sql.append(")\r\n");
                        sql.append("Where\r\n");
                        sql.append("FLevel=" + (expendLevel + 1) + "\r\n");
                        logger.debug((Object)("Update WorkshopMSAnalysisRPT Manufacture BOM SQL:\r\n" + sql.toString()));
                        mainBOMUpdateRows = SQLUtils.execute((Context)ctx, (String)sql.toString());
                        if (orderBOMUpdateRows + mainBOMUpdateRows >= 1) {
                            ++expendLevel;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                MMUtils.releaseTmpTable((Context)ctx, (String)expendBomTempTable);
                throw new BOSException((Throwable)e);
            }
        }
        return expendBomTempTable;
    }

    protected String createBOMExpandTempTable(Context ctx) throws BOSException {
        String expendBomTempTable = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Create Table BOMExpandTempTable(\r\n");
            sql.append("FLevel INT Default 0 Not Null,\r\n");
            sql.append("FManufactureStrategyID VARCHAR(44),\r\n");
            sql.append("FStorageOrgUnitID VARCHAR(44),\r\n");
            sql.append("FProjectID VARCHAR(44),\r\n");
            sql.append("FTraceID VARCHAR(44),\r\n");
            sql.append("FMaterialID VARCHAR(44),\r\n");
            sql.append("FWarehouseID VARCHAR(44),\r\n");
            sql.append("FIsolatedRule VARCHAR(44),\r\n");
            sql.append("FPlanQTY Numeric(21,8) Default 1,\r\n");
            sql.append("FSendQTY Numeric(21,8) Default 1,\r\n");
            sql.append("FBOMID VARCHAR(44),\r\n");
            sql.append("FBOMType INT Default ").append(40).append(",\r\n");
            sql.append("FUsageType INT Default ").append(10).append(",\r\n");
            sql.append("FIsConfigable INT Default 0,\r\n");
            sql.append("FProcess NVARCHAR(80)\r\n");
            sql.append(")\r\n");
            logger.debug((Object)("Create WorkshopMSAnalysisRPT BOM Expend Table SQL:\r\n" + sql.toString()));
            expendBomTempTable = MMUtils.createTmpTable((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return expendBomTempTable;
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        RptRowSet rptRowSet = null;
        try {
            rptRowSet = DBUtil.executeQuery((String)sql, (SqlParams)parameters, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        this.close(con);
        return rptRowSet;
    }

    protected void generateResult(Context ctx, String resultTableName, String materialFrom, String materialTo) throws BOSException {
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInsertResultTempTableSQL(resultTableName));
        sql.append("Select\r\n");
        sql.append("Null,\r\n");
        sql.append("SR.FStorageOrgUnitID,\r\n");
        sql.append("S.FNumber,\r\n");
        sql.append("S.FName_" + locale + ",\r\n");
        sql.append("SR.FProjectID,\r\n");
        sql.append("P.FNumber,\r\n");
        sql.append("P.FName_" + locale + ",\r\n");
        sql.append("SR.FProductID,\r\n");
        sql.append("BP.FNumber,\r\n");
        sql.append("BP.FName_" + locale + ",\r\n");
        sql.append("SR.FTraceID,\r\n");
        sql.append("T.FNumber,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("SR.FMaterialID,\r\n");
        sql.append("M.FNumber,\r\n");
        sql.append("M.FName_" + locale + ",\r\n");
        sql.append("M.FModel,\r\n");
        sql.append("Null,\r\n");
        sql.append("U.FID,\r\n");
        sql.append("U.FNumber,\r\n");
        sql.append("U.FName_" + locale + ",\r\n");
        sql.append("SR.FWarehouseID,\r\n");
        sql.append("W.FNumber,\r\n");
        sql.append("W.FName_" + locale + ",\r\n");
        sql.append("SR.FPlanQty,\r\n");
        sql.append("SR.FSendQty,\r\n");
        sql.append("SR.FWarehouseStock,\r\n");
        sql.append("SR.FStorageOrgUnitStock,\r\n");
        sql.append("IsNull(SR.FPlanQty,0) - IsNull(SR.FSendQty,0) - IsNull(SR.FWarehouseStock,0),\r\n");
        sql.append("Null,\r\n");
        sql.append("SR.FProcess,\r\n");
        sql.append("Null\r\n");
        sql.append("From (\r\n");
        sql.append("Select\r\n");
        sql.append("T.FStorageOrgUnitID \"FStorageOrgUnitID\",\r\n");
        sql.append("T.FProjectID \"FProjectID\",\r\n");
        sql.append("T.FProductID \"FProductID\",\r\n");
        sql.append("T.FTraceID \"FTraceID\",\r\n");
        sql.append("T.FMaterialID \"FMaterialID\",\r\n");
        sql.append("T.FWarehouseID \"FWarehouseID\",\r\n");
        sql.append("SUM(T.FPlanQty) \"FPlanQty\",\r\n");
        sql.append("SUM(T.FSendQty) \"FSendQty\",\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("SUM(INV.FCURStoreQTY)\r\n");
        sql.append("From T_IM_Inventory INV\r\n");
        sql.append("Where\r\n");
        sql.append("INV.FWarehouseID=T.FWarehouseID\r\n");
        sql.append("And INV.FMaterialID=T.FMaterialID\r\n");
        sql.append(") FWarehouseStock,\r\n");
        sql.append("(\r\n");
        sql.append("Select\r\n");
        sql.append("SUM(INV.FCURStoreQTY)\r\n");
        sql.append("From T_IM_Inventory INV\r\n");
        sql.append("Where\r\n");
        sql.append("INV.FStorageOrgUnitID=T.FStorageOrgUnitID\r\n");
        sql.append("And INV.FMaterialID=T.FMaterialID\r\n");
        sql.append(") FStorageOrgUnitStock,\r\n");
        sql.append("T.FProcess \"FProcess\"\r\n");
        sql.append("From ").append(resultTableName).append(" T\r\n");
        sql.append("Group By\r\n");
        sql.append("T.FStorageOrgUnitID,\r\n");
        sql.append("T.FProjectID,\r\n");
        sql.append("T.FProductID,\r\n");
        sql.append("T.FTraceID,\r\n");
        sql.append("T.FMaterialID,\r\n");
        sql.append("T.FWarehouseID,\r\n");
        sql.append("T.FProcess\r\n");
        sql.append(") SR\r\n");
        sql.append("Left Join T_ORG_Storage S On S.FID=SR.FStorageOrgUnitID\r\n");
        sql.append("Left Join T_MM_Project P On P.FID=SR.FProjectID\r\n");
        sql.append("Left Join T_BD_Material BP On BP.FID=SR.FProductID\r\n");
        sql.append("Left Join T_MM_TrackNumber T On T.FID=SR.FTraceID\r\n");
        sql.append("Left Join T_BD_Material M On M.FID=SR.FMaterialID\r\n");
        sql.append("Left Join T_BD_MeasureUnit U On U.FID=M.FBaseUnit\r\n");
        sql.append("Left Join T_DB_Warehouse W On W.FID=SR.FWarehouseID\r\n");
        sql.append("Where\r\n");
        sql.append("1=1\r\n");
        if (materialFrom != null && materialFrom.trim().length() > 0) {
            sql.append("And M.FNumber>='" + materialFrom + "'\r\n");
        }
        if (materialTo != null && materialTo.trim().length() > 0) {
            sql.append("And M.FNumber<='" + materialTo + "'\r\n");
        }
        logger.debug((Object)("Generate WorkshopMSAnalysisRPT Result Data SQL:\r\n" + sql.toString()));
        SQLUtils.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("Delete From ").append(resultTableName).append("\r\n");
        sql.append("Where\r\n");
        sql.append("FID Is Not Null\r\n");
        logger.debug((Object)("Delete WorkshopMSAnalysisRPT Useless Result Data SQL:\r\n" + sql.toString()));
        SQLUtils.execute((Context)ctx, (String)sql.toString());
    }

    protected String getInsertBOMExpandTempTableSQL(String expendBomTempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + expendBomTempTable + "(\r\n");
        sql.append("FLevel,\r\n");
        sql.append("FManufactureStrategyID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FIsolatedRule,\r\n");
        sql.append("FPlanQTY,\r\n");
        sql.append("FSendQTY,\r\n");
        sql.append("FBOMID,\r\n");
        sql.append("FBOMType,\r\n");
        sql.append("FUsageType,\r\n");
        sql.append("FIsConfigable,\r\n");
        sql.append("FProcess\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected String getInsertResultTempTableSQL(String resultTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(resultTableName).append("(\r\n");
        sql.append("FID,\r\n");
        sql.append("FStorageOrgUnitID,\r\n");
        sql.append("FStorageOrgUnitNumber,\r\n");
        sql.append("FStorageOrgUnitName,\r\n");
        sql.append("FProjectID,\r\n");
        sql.append("FProjectNumber,\r\n");
        sql.append("FProjectName,\r\n");
        sql.append("FProductID,\r\n");
        sql.append("FProductNumber,\r\n");
        sql.append("FProductName,\r\n");
        sql.append("FTraceID,\r\n");
        sql.append("FTraceNumber,\r\n");
        sql.append("FCompareTraceID,\r\n");
        sql.append("FCompareTraceNumber,\r\n");
        sql.append("FMaterialID,\r\n");
        sql.append("FMaterialNumber,\r\n");
        sql.append("FMaterialName,\r\n");
        sql.append("FMaterialModel,\r\n");
        sql.append("FQTY,\r\n");
        sql.append("FUnitID,\r\n");
        sql.append("FUnitNumber,\r\n");
        sql.append("FUnitName,\r\n");
        sql.append("FWarehouseID,\r\n");
        sql.append("FWarehouseNumber,\r\n");
        sql.append("FWarehouseName,\r\n");
        sql.append("FPlanQty,\r\n");
        sql.append("FSendQty,\r\n");
        sql.append("FWarehouseStock,\r\n");
        sql.append("FStorageOrgUnitStock,\r\n");
        sql.append("FStockoutQty,\r\n");
        sql.append("FProperties,\r\n");
        sql.append("FProcess,\r\n");
        sql.append("FRemark\r\n");
        sql.append(")\r\n");
        return sql.toString();
    }

    protected void insertResult(Context ctx, String expendBomTempTable, String moID, String storageOrgUnitID, String resultTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInsertResultTempTableSQL(resultTableName));
        sql.append("Select\r\n");
        sql.append("NewBOSID('12345678'),\r\n");
        sql.append("MO.FStorageOrgUnitID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("MO.FProjectID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("MO.CFMAUNMaterialID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("MO.FTrackID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("EXP.FMaterialID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("EXP.FWarehouseID,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("EXP.FPlanQty,\r\n");
        sql.append("EXP.FSendQty,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("Null,\r\n");
        sql.append("EXP.FProcess,\r\n");
        sql.append("Null\r\n");
        sql.append("From T_MM_ManufactureOrder MO\r\n");
        sql.append("Inner Join (\r\n");
        sql.append("Select\r\n");
        sql.append("'").append(moID).append("' FMOID,\r\n");
        sql.append("TT.FMaterialID FMaterialID,\r\n");
        sql.append("TT.FWarehouseID FWarehouseID,\r\n");
        sql.append("SUM(TT.FPlanQTY) FPlanQTY,\r\n");
        sql.append("SUM(TT.FSendQTY) FSendQTY,\r\n");
        sql.append("TT.FProcess\r\n");
        sql.append("From " + expendBomTempTable + " TT\r\n");
        sql.append("Left Join T_BD_MaterialPlan MP On\r\n");
        sql.append("MP.FMaterialID=TT.FMaterialID\r\n");
        sql.append("And MP.FOrgUnit='").append(storageOrgUnitID).append("'\r\n");
        sql.append("Where\r\n");
        sql.append("IsNull(TT.FLevel,0)>0\r\n");
        sql.append("And MP.FMaterialATTR=").append(10040).append("\r\n");
        sql.append("Group By\r\n");
        sql.append("TT.FMaterialID,\r\n");
        sql.append("TT.FWarehouseID,\r\n");
        sql.append("TT.FProcess\r\n");
        sql.append(") EXP On EXP.FMOID=MO.FID\r\n");
        sql.append("Where\r\n");
        sql.append("MO.FID='").append(moID).append("'\r\n");
        logger.debug((Object)("Insert WorkshopMSAnalysisRPT Result Data SQL:\r\n" + sql.toString()));
        try {
            SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean isCanExpand(Context ctx, String expendBomTempTable, int expendLevel) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Select\r\n");
        sql.append("Top 1\r\n");
        sql.append("BE.FID\r\n");
        sql.append("From " + expendBomTempTable + " t\r\n");
        sql.append("Inner Join T_MM_BOMEntry BE On BE.FParentID=T.FBOMID\r\n");
        sql.append("Where\r\n");
        sql.append("T.FLevel=" + expendLevel + "\r\n");
        sql.append("And T.FBOMID Is Not Null\r\n");
        logger.debug((Object)("Check TempTable Is Can Expand SQL:\r\n" + sql.toString()));
        try {
            IRowSet rs = SQLUtils.executeQuery((Context)ctx, (String)sql.toString());
            if (rs != null && rs.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

