/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillCollection;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillEntryInfo;
import com.kingdee.eas.industry.emm.lcm.CostEstimationBillInfo;
import com.kingdee.eas.industry.emm.lcm.app.AbstractCostEstimationBillControllerBean;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CostEstimationBillControllerBean
extends AbstractCostEstimationBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.lcm.app.CostEstimationBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostEstimationBillInfo bill = (CostEstimationBillInfo)model;
        this.checkStart(ctx, (IObjectValue)bill);
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _checkStart(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        CostEstimationBillCollection billColl = this.getBillColl(ctx, pks, null);
        this.checkStart(ctx, (IObjectCollection)billColl);
    }

    private CostEstimationBillCollection getBillColl(Context ctx, IObjectPK[] pks, SelectorItemCollection sic) throws BOSException {
        Set idSet = NCMUtils.arrayPK2Set((IObjectPK[])pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (sic != null) {
            evi.setSelector(sic);
        }
        return this.getCostEstimationBillCollection(ctx, evi);
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyinfo = ((CostEstimationBillInfo)model).getFICompany();
        if (((CostEstimationBillInfo)model).getPeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(((CostEstimationBillInfo)model).getPeriod().getId().toString()));
        if (!ctrol.isStart(1001, companyinfo.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.isCheckStart() && !NCMUtils.isBig((PeriodInfo)ctrol.getCacheCurrentPeriod(1001, companyinfo.getId().toString()), (PeriodInfo)period)) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
        PeriodInfo period;
        PeriodInfo curPeriod;
        if (billColl == null || billColl.isEmpty()) {
            return;
        }
        CostEstimationBillInfo info = (CostEstimationBillInfo)billColl.getObject(0);
        CompanyOrgUnitInfo companyInfo = info.getFICompany();
        if (info.getPeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        this.checkStartDiff(ctrol, companyInfo.getId().toString());
        if (this.isCheckStart() && !NCMUtils.isBig((PeriodInfo)(curPeriod = ctrol.getCacheCurrentPeriod(1001, companyInfo.getId().toString())), (PeriodInfo)(period = this.getLeastPeriodInfo(ctx, billColl)))) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    protected PeriodInfo getLeastPeriodInfo(Context ctx, IObjectCollection billColl) throws BOSException {
        if (billColl == null || billColl.isEmpty()) {
            return new PeriodInfo();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < billColl.size(); ++i) {
            CostEstimationBillInfo info = (CostEstimationBillInfo)billColl.getObject(i);
            idSet.add(info.getPeriod().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        if (periodColl.size() > 0) {
            return periodColl.get(0);
        }
        return new PeriodInfo();
    }

    protected boolean isCheckStart() {
        return true;
    }

    private void checkStartDiff(ISystemStatusCtrol ctrol, String companyId) throws CMBillException, EASBizException, BOSException {
        boolean isInit = ctrol.isStart(1001, companyId);
        if (this.checkStartForCommon()) {
            if (!isInit) {
                throw new CMBillException(CMBillException.COST_NOTON);
            }
        } else if (isInit) {
            throw new CMBillException(CMBillException.COST_ISON);
        }
    }

    protected boolean checkStartForCommon() {
        return true;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostEstimationBillInfo info = (CostEstimationBillInfo)model;
        if (info == null) {
            info = (CostEstimationBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0000")));
        }
        this.checkStart(ctx, (IObjectValue)info);
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostEstimationBillInfo info = (CostEstimationBillInfo)model;
        if (info == null) {
            info = (CostEstimationBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0001")));
        }
        this.checkStart(ctx, (IObjectValue)info);
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CostEstimationBillInfo info = (CostEstimationBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0002")));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, CostEstimationBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0003")));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getFICompany() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0004"));
        }
        if (eti.getPeriod() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0005"));
        }
        if (eti.getProject() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0006"));
        }
        if (eti.getTrackNumber() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0007"));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostEstimationBillInfo eti = (CostEstimationBillInfo)model;
        this.checkStart(ctx, (IObjectValue)eti);
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0008")));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            CostEstimationBillEntryInfo entry = eti.getEntrys().get(i);
            if (entry.getCoeff() == null || BigDecimal.ZERO.compareTo(entry.getCoeff()) >= 0) {
                entry.setCoeff(BigDecimal.ONE);
            }
            entry.setCoeffAmount(entry.getAmount().multiply(entry.getCoeff()).setScale(2, RoundingMode.HALF_UP));
        }
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostEstimationBillInfo eti = (CostEstimationBillInfo)model;
        this.checkStart(ctx, (IObjectValue)eti);
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0009")));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            CostEstimationBillEntryInfo entry = eti.getEntrys().get(i);
            if (entry.getCoeff() == null || BigDecimal.ZERO.compareTo(entry.getCoeff()) >= 0) {
                entry.setCoeff(BigDecimal.ONE);
            }
            entry.setCoeffAmount(entry.getAmount().multiply(entry.getCoeff()).setScale(2, RoundingMode.HALF_UP));
        }
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostEstimationBillInfo info = (CostEstimationBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getFICompany().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, CostEstimationBillInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, CostEstimationBillInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getFICompany().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CostEstimationBillInfo aSCMBillBaseInfo = (CostEstimationBillInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostEstimationBillInfo aSCMBillBaseInfo = (CostEstimationBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(CostEstimationBillInfo aSCMBillBaseInfo) {
        return null;
    }

    @Override
    protected Map _autoEstimate(Context ctx, String companyID, int period, String tempTableName) throws BOSException, EASBizException {
        try {
            Result rsl;
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("/*dialect*/ select  t.FCompanyID,t.FPeriod,t.FProjectID,t.FTrackNumberID,t.FMaterialID,");
            sql.append(" sum(nvl(t.FQty,0)-nvl(t.FActualReqQty,0)) as FQty,sum(nvl(t.FEstimateAmount,0)) as FAmount");
            sql.append(" from " + tempTableName + " t");
            sql.append(" where t.FEstimateAmount>0 ");
            sql.append(" and not exists (select 1 from ct_lcm_costestimationbill b  ");
            sql.append(" inner join t_bd_period p on b.cfperiodid=p.fid ");
            sql.append(" where b.cfprojectid=t.FProjectID and b.cfficompanyid=t.FCompanyID ");
            sql.append(" and b.cftracknumberid=t.FTrackNumberID and p.fnumber=t.FPeriod ) ");
            sql.append(" and t.FTrackNumberID is not null ");
            sql.append(" group by t.FCompanyID,t.FPeriod,t.FProjectID,t.FTrackNumberID,t.FMaterialID");
            sql.append(" order by t.FProjectID,t.FTrackNumberID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String projectID = "";
            String trackNumberID = "";
            PeriodCollection pColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection("where number=" + period);
            PeriodInfo periodInfo = pColl.get(0);
            CompanyOrgUnitInfo compangInfo = new CompanyOrgUnitInfo();
            compangInfo.setId(BOSUuid.read((String)companyID));
            UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            CtrlUnitInfo curCTRLUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            CoreBaseCollection ceColl = new CoreBaseCollection();
            CostEstimationBillInfo billInfo = new CostEstimationBillInfo();
            while (rs.next()) {
                String tpID = rs.getString("FProjectID");
                String ttID = rs.getString("FTrackNumberID");
                if (!tpID.equals(projectID) || !ttID.equals(trackNumberID)) {
                    projectID = tpID;
                    trackNumberID = ttID;
                    billInfo = new CostEstimationBillInfo();
                    billInfo.setId(BOSUuid.create((String)billInfo.getBOSType().toString()));
                    billInfo.setBizDate(new Date());
                    billInfo.setCU(curCTRLUnitInfo);
                    billInfo.setStatus(BillBaseStatusEnum.AUDITED);
                    billInfo.setAuditTime(new Date());
                    billInfo.setAuditor(curUserInfo);
                    billInfo.setFICompany(compangInfo);
                    billInfo.setPeriod(periodInfo);
                    ProjectInfo project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)projectID));
                    billInfo.setProject(project);
                    TrackNumberInfo tracknumber = new TrackNumberInfo();
                    tracknumber.setId(BOSUuid.read((String)trackNumberID));
                    billInfo.setTrackNumber(tracknumber);
                    billInfo.setIsCharge(false);
                    ceColl.add((CoreBaseInfo)billInfo);
                }
                String mID = rs.getString("FMaterialID");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                CostEstimationBillEntryInfo entry = new CostEstimationBillEntryInfo();
                entry.setId(BOSUuid.create((String)entry.getBOSType().toString()));
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)mID));
                entry.setMaterial(materialInfo);
                entry.setQty(rs.getBigDecimal("FQty"));
                entry.setCoeff(BigDecimal.ONE);
                entry.setAmount(amount);
                entry.setCoeffAmount(amount);
                billInfo.getEntrys().add(entry);
            }
            if (ceColl.size() > 0 && (rsl = this.addnew(ctx, ceColl)).getResult() != 1) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0010")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Success", "True");
        return result;
    }

    @Override
    protected Map _autoEstimateReversed(Context ctx, String companyID, int period, String tempTableName) throws BOSException, EASBizException {
        try {
            Result rsl;
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append("/*dialect*/ select  t.FCompanyID,t.FPeriod,t.FProjectID,t.FTrackNumberID,t.FMaterialID,");
            sql.append(" sum(nvl(t.FQty,0)) as FQty, sum(nvl(t.FActualCost,0)) as FAmount");
            sql.append(" from " + tempTableName + " t");
            sql.append(" where t.FActualCost>0 ");
            sql.append(" and not exists (select 1 from ct_lcm_costestimationbill b  ");
            sql.append(" inner join t_bd_period p on b.cfperiodid=p.fid ");
            sql.append(" where b.cfprojectid=t.FProjectID and b.cftracknumberid=t.FTrackNumberID and b.cfficompanyid=t.FCompanyID ");
            sql.append(" and p.fnumber=t.FPeriod and b.cfischarge=1) ");
            sql.append(" group by t.FCompanyID,t.FPeriod,t.FProjectID,t.FMaterialID");
            sql.append(" order by t.FProjectID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String projectID = "";
            String trackNumberID = "";
            PeriodCollection pColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection("where number=" + period);
            PeriodInfo periodInfo = pColl.get(0);
            CompanyOrgUnitInfo compangInfo = new CompanyOrgUnitInfo();
            compangInfo.setId(BOSUuid.read((String)companyID));
            UserInfo curUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            CtrlUnitInfo curCTRLUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            CoreBaseCollection ceColl = new CoreBaseCollection();
            CostEstimationBillInfo billInfo = new CostEstimationBillInfo();
            while (rs.next()) {
                String tpID = rs.getString("FProjectID");
                String ttID = rs.getString("FTrackNumberID");
                if (!tpID.equals(projectID) || !ttID.equals(trackNumberID)) {
                    projectID = tpID;
                    trackNumberID = ttID;
                    billInfo = new CostEstimationBillInfo();
                    billInfo.setId(BOSUuid.create((String)billInfo.getBOSType().toString()));
                    billInfo.setBizDate(new Date());
                    billInfo.setCU(curCTRLUnitInfo);
                    billInfo.setStatus(BillBaseStatusEnum.AUDITED);
                    billInfo.setAuditTime(new Date());
                    billInfo.setAuditor(curUserInfo);
                    billInfo.setFICompany(compangInfo);
                    billInfo.setPeriod(periodInfo);
                    ProjectInfo project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)projectID));
                    billInfo.setProject(project);
                    TrackNumberInfo tracknumber = new TrackNumberInfo();
                    tracknumber.setId(BOSUuid.read((String)trackNumberID));
                    billInfo.setTrackNumber(tracknumber);
                    billInfo.setIsCharge(true);
                    ceColl.add((CoreBaseInfo)billInfo);
                }
                String mID = rs.getString("FMaterialID");
                BigDecimal amount = rs.getBigDecimal("FAmount");
                CostEstimationBillEntryInfo entry = new CostEstimationBillEntryInfo();
                entry.setId(BOSUuid.create((String)entry.getBOSType().toString()));
                MaterialInfo materialInfo = new MaterialInfo();
                materialInfo.setId(BOSUuid.read((String)mID));
                entry.setMaterial(materialInfo);
                entry.setAmount(amount);
                entry.setCoeff(BigDecimal.ONE);
                entry.setCoeffAmount(amount);
                entry.setQty(rs.getBigDecimal("FQty"));
                billInfo.getEntrys().add(entry);
            }
            if (ceColl.size() > 0 && (rsl = this.addnew(ctx, ceColl)).getResult() != 1) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0011")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Success", "True");
        return result;
    }
}

