/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.industry.emm.lcm.app.AbstractLeanCostFacadeControllerBean;
import com.kingdee.eas.industry.emm.lcm.util.LcmConstant;
import com.kingdee.eas.industry.emm.lcm.util.LcmUtils;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.ncm.bill.IInputQtyBill;
import com.kingdee.eas.ncm.bill.InputQtyBillEntryInfo;
import com.kingdee.eas.ncm.bill.InputQtyBillFactory;
import com.kingdee.eas.ncm.bill.InputQtyBillInfo;
import com.kingdee.eas.ncm.bill.InputQtyImportTypeEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LeanCostFacadeControllerBean
extends AbstractLeanCostFacadeControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.lcm.app.LeanCostFacadeControllerBean");
    public static final String[] MATERREQTRANTYPE_EXCEPT = new String[]{"438NCR", "440NCR", "44301CG01", "40617-1", "405WL", "44305", "CDE-JC", "CDE"};
    private String topProduct;
    private static List<String[]> costItemSql = new ArrayList<String[]>();

    @Override
    protected void _lcmDispatcher(Context ctx, IObjectValue billInfo, String action, Map param) throws BOSException, EASBizException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Map _importInputQty(Context ctx, Map param) throws BOSException, EASBizException {
        IInputQtyBill iInputQtyBill = InputQtyBillFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> result = new HashMap<String, String>();
        String tmpTable = null;
        try {
            String periodId = ((PeriodInfo)param.get("period")).getId().toString();
            String companyId = (String)param.get("company");
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
            String[] dateStrArray = LcmUtils.dealPeriod(period);
            this.checkIfCodingRuleExsit(ctx, companyId);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            StringBuffer createTableSql = new StringBuffer();
            createTableSql.append("create table T_NCM_OrderQtyTable (").append("\t FCompanyOrg varchar(44),").append("\t FCalculatePeriod varchar(44),").append("\t FCostCenterID varchar(44),").append("\t FCostObjectID varchar(44),").append("\t FQty decimal(28,10))");
            tmpTable = pool.createTempTable(createTableSql.toString());
            StringBuffer sql = new StringBuffer();
            String FCalculatePeriod = period.getId().toString();
            sql.append("/*dialect*/  insert into ").append(tmpTable).append(" (FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID,FQty) ");
            sql.append(" select distinct '" + companyId + "','" + FCalculatePeriod + "'");
            sql.append(" ,bill.fcostcenterorgunitid,en.fcostobjectid,1");
            sql.append(" from  t_im_materialreqbill bill ");
            sql.append(" inner join t_im_materialreqbillentry en on en.fparentid=bill.fid");
            sql.append(" inner join t_scm_transactiontype tti on bill.ftransactiontypeid=tti.fid");
            sql.append(" inner join t_bd_costobject co on en.fcostobjectid=co.fid");
            sql.append(" inner join t_org_costcenter cc on bill.fcostcenterorgunitid=cc.fid");
            sql.append(" where  ");
            sql.append("  cc.fcostcentertype=0 ");
            sql.append(" and bill.fbasestatus>3");
            sql.append(" and tti.fismanucostcalculate=1");
            sql.append(" and en.fcompanyorgunitid='" + companyId + "'");
            if (!LcmUtils.isEmpty(dateStrArray[0])) {
                sql.append(" and bill.fbizDate >= to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss') ");
                sql.append(" and en.fbizDate >= to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss') ");
            }
            if (!LcmUtils.isEmpty(dateStrArray[1])) {
                sql.append(" and bill.fbizDate <= to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss') ");
                sql.append(" and en.fbizDate <= to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss') ");
            }
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/  insert into ").append(tmpTable).append(" (FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID,FQty) ");
            sql.append(" select distinct '" + companyId + "','" + FCalculatePeriod + "'");
            sql.append(" ,bill.fcostcenterorgunitid,en.fcostobjectid,1");
            sql.append(" from  t_im_manufacturerecbill bill ");
            sql.append(" inner join t_im_manufacturerecbillentry en on en.fparentid=bill.fid");
            sql.append(" inner join t_bd_costobject co on en.fcostobjectid=co.fid");
            sql.append(" inner join t_org_costcenter cc on bill.fcostcenterorgunitid=cc.fid");
            sql.append(" where  ");
            sql.append("  cc.fid='xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
            sql.append("  and bill.fstorageorgunitid='tpyPIjQ0RCmSK9eQYTJBjsznrtQ='");
            sql.append("     and en.fcostobjectid is not null");
            sql.append(" and bill.fbasestatus>3");
            sql.append(" and en.fcompanyorgunitid='" + companyId + "'");
            if (!LcmUtils.isEmpty(dateStrArray[0])) {
                sql.append(" and bill.fbizDate >= to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss') ");
            }
            if (!LcmUtils.isEmpty(dateStrArray[1])) {
                sql.append(" and bill.fbizDate <= to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss') ");
            }
            sql.append(" and co.fid not in (select FCostObjectID from " + tmpTable + " )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String balanceTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_Balance", (int)period.getNumber(), (int)period.getNumber());
            sql.setLength(0);
            sql.append("/*dialect*/ delete from " + tmpTable + " t");
            sql.append(" where exists (select 1 from " + balanceTable + " bt where bt.fcalculateperiodid=t.FCalculatePeriod");
            sql.append(" and bt.fcompanyorg=t.FCompanyOrg and bt.fcostobjectid=t.FCostObjectID");
            sql.append(" and bt.fcostcenterid=t.FCostCenterID and bt.fbopwipqty>0 )");
            int i = SQLUtils.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            DbUtil.execute((Context)ctx, (String)("delete t_ncm_inputqtybillentry where fparentid in (select fid from t_ncm_inputqtybill where fcompanyorg='" + companyId + "' and fcalculateperiod='" + periodId + "' and fimporttype=3)"));
            sql.setLength(0);
            DbUtil.execute((Context)ctx, (String)("delete from t_ncm_inputqtybill where fcompanyorg='" + companyId + "' and fcalculateperiod='" + periodId + "' and fimporttype=3"));
            sql.setLength(0);
            IRowSet rowSet = null;
            sql.append(" select toq.FCompanyOrg as fcompanyid,toq.FCalculatePeriod as fperiodid,toq.FCostCenterID as FCostCenterID,toq.FCostObjectID as FCostObjectID ,toq.FQty as fqty,period.fid,period.FBeginDate as fbizdate from ").append(tmpTable).append(" toq ").append(" INNER JOIN t_bd_period period on toq.FCalculatePeriod = period.fid ");
            sql.append(" order by toq.FCostCenterID \n");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            InputQtyBillInfo inputQtyBill = null;
            InputQtyBillEntryInfo inputQtyBillEntry = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            String costCenterID = "";
            while (rowSet.next()) {
                if (costCenterID != null && !costCenterID.equals(rowSet.getString("FCostCenterID"))) {
                    if (costCenterID.length() > 0) {
                        iInputQtyBill.addnew(inputQtyBill);
                    }
                    inputQtyBill = new InputQtyBillInfo();
                    costCenterID = rowSet.getString("FCostCenterID");
                }
                inputQtyBill.setCompanyOrg(company);
                inputQtyBill.setImportType(InputQtyImportTypeEnum.fromimport);
                inputQtyBill.setCalculatePeriod(period);
                inputQtyBill.setBizDate((Date)rowSet.getDate("fbizdate"));
                inputQtyBill.setBillStatus(BillBaseStatusEnum.AUDITED);
                inputQtyBill.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                inputQtyBill.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
                inputQtyBill.setIsImport(true);
                CostCenterOrgUnitInfo costCenter = new CostCenterOrgUnitInfo();
                costCenter.setId(BOSUuid.read((String)costCenterID));
                inputQtyBill.setCostCenterOrgUnit(costCenter);
                inputQtyBillEntry = new InputQtyBillEntryInfo();
                inputQtyBillEntry.setIsImport(true);
                CostObjectInfo costObject = new CostObjectInfo();
                costObject.setId(BOSUuid.read((String)rowSet.getString("FCostObjectID")));
                inputQtyBillEntry.setCostObject(costObject);
                BigDecimal inputQty = rowSet.getBigDecimal("fqty");
                inputQtyBillEntry.setQty(inputQty);
                inputQtyBill.getEntry().add(inputQtyBillEntry);
            }
            if (inputQtyBill != null) {
                iInputQtyBill.addnew(inputQtyBill);
            }
            result.put(LcmConstant.STRING_RESULT, LcmConstant.STRING_SUCCESS);
            if (tmpTable == null) return result;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                if (tmpTable == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        return result;
    }

    @Override
    protected Map _importInputQtyModify(Context ctx, Map param) throws BOSException, EASBizException {
        String tmpTable2;
        HashMap<String, String> result;
        block13: {
            IInputQtyBill iInputQtyBill = InputQtyBillFactory.getLocalInstance((Context)ctx);
            result = new HashMap<String, String>();
            String tmpTable = null;
            tmpTable2 = null;
            try {
                String periodId = ((PeriodInfo)param.get("period")).getId().toString();
                String companyId = (String)param.get("company");
                PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
                String[] dateStrArray = LcmUtils.dealPeriod(period);
                this.checkIfCodingRuleExsit(ctx, companyId);
                TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                StringBuffer createTableSql = new StringBuffer();
                createTableSql.append("create table T_NCM_OrderQtyTable (").append("\t FCompanyOrg varchar(44),").append("\t FCalculatePeriod varchar(44),").append("\t FCostCenterID varchar(44),").append("\t FCostObjectID varchar(44),").append("\t fprojectid varchar(44),").append("\t ftrackid varchar(44),").append("\t frelatedid varchar(44),").append("\t fmocoid varchar(44),").append("\t fmomaid varchar(44),").append("\t flag varchar(44),").append("\t FmoQty decimal(28,10),").append("\t FQty decimal(28,10))");
                tmpTable = pool.createTempTable(createTableSql.toString());
                StringBuffer sql = new StringBuffer();
                String FCalculatePeriod = period.getId().toString();
                sql.append("/*dialect*/  insert into ").append(tmpTable);
                sql.append(" (FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID,fprojectid,ftrackid,frelatedid,");
                sql.append(" fmocoid,fmomaid,FmoQty,FQty)");
                sql.append(" select  '" + companyId + "','" + FCalculatePeriod + "'");
                sql.append(" ,bill.fcostcenterorgunitid,en.fcostobjectid,co.fprojectid,co.ftrackid,coe.frelatedid,");
                sql.append(" nvl(mo.FCOSTOBJECTID,'xxx'),nvl(mo.FMATERIALID,'xxx'),nvl(mo.fqty,1),");
                sql.append(" 1");
                sql.append(" from  t_im_materialreqbill bill ");
                sql.append(" inner join t_im_materialreqbillentry en on en.fparentid=bill.fid");
                sql.append(" inner join t_scm_transactiontype tti on bill.ftransactiontypeid=tti.fid");
                sql.append(" inner join t_bd_costobject co on en.fcostobjectid=co.fid");
                sql.append(" inner join t_bd_costobjectentry coe on co.fid=coe.fparentid");
                sql.append(" inner join t_org_costcenter cc on bill.fcostcenterorgunitid=cc.fid");
                sql.append(" left  join t_mm_manufactureorder mo on mo.fid=en.fsourcebillid");
                sql.append(" where  ");
                sql.append("  cc.fcostcentertype=0 ");
                sql.append(" and bill.fbasestatus=4");
                sql.append(" and tti.fismanucostcalculate=1");
                sql.append(" and en.fcompanyorgunitid='" + companyId + "'");
                if (!LcmUtils.isEmpty(dateStrArray[0])) {
                    sql.append(" and bill.fbizDate >= to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss') ");
                }
                if (!LcmUtils.isEmpty(dateStrArray[1])) {
                    sql.append(" and bill.fbizDate <= to_date('").append(dateStrArray[1]).append("','yyyy-MM-dd HH24:mi:ss') ");
                }
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append(" update ").append(tmpTable);
                sql.append(" set FQty=FmoQty where ");
                sql.append(" FCostObjectID=fmocoid and frelatedid=fmomaid");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append(" insert into ").append(tmpTable);
                sql.append(" (FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID,FQty,flag) ");
                sql.append(" select  FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID,Max(FQty),'1'");
                sql.append(" from ").append(tmpTable);
                sql.append(" group by FCompanyOrg,FCalculatePeriod,FCostCenterID,FCostObjectID");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql.append("delete from ").append(tmpTable).append(" where flag is null or flag<>'1'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                String balanceTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyId, (String)"T_NCM_Balance", (int)period.getNumber(), (int)period.getNumber());
                sql.setLength(0);
                sql.append("/*dialect*/ delete from " + tmpTable + " t");
                sql.append(" where exists (select 1 from " + balanceTable + " bt where bt.fcalculateperiodid=t.FCalculatePeriod");
                sql.append(" and bt.fcompanyorg=t.FCompanyOrg and bt.fcostobjectid=t.FCostObjectID");
                sql.append(" and bt.fcostcenterid=t.FCostCenterID and bt.fbopwipqty>0 )");
                int i = SQLUtils.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                DbUtil.execute((Context)ctx, (String)("delete t_ncm_inputqtybillentry where fparentid in (select fid from t_ncm_inputqtybill where fcompanyorg='" + companyId + "' and fcalculateperiod='" + periodId + "' and fimporttype=3)"));
                sql.setLength(0);
                DbUtil.execute((Context)ctx, (String)("delete from t_ncm_inputqtybill where fcompanyorg='" + companyId + "' and fcalculateperiod='" + periodId + "' and fimporttype=3"));
                sql.setLength(0);
                IRowSet rowSet = null;
                sql.append(" select toq.FCompanyOrg as fcompanyid,toq.FCalculatePeriod as fperiodid,toq.FCostCenterID as FCostCenterID,toq.FCostObjectID as FCostObjectID ,toq.FQty as fqty,period.fid,period.FBeginDate as fbizdate from ").append(tmpTable).append(" toq ").append(" INNER JOIN t_bd_period period on toq.FCalculatePeriod = period.fid ");
                sql.append(" order by toq.FCostCenterID \n");
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                InputQtyBillInfo inputQtyBill = null;
                InputQtyBillEntryInfo inputQtyBillEntry = null;
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)companyId));
                String costCenterID = "";
                while (rowSet.next()) {
                    if (costCenterID != null && !costCenterID.equals(rowSet.getString("FCostCenterID"))) {
                        if (costCenterID.length() > 0) {
                            iInputQtyBill.addnew(inputQtyBill);
                        }
                        inputQtyBill = new InputQtyBillInfo();
                        costCenterID = rowSet.getString("FCostCenterID");
                    }
                    inputQtyBill.setCompanyOrg(company);
                    inputQtyBill.setImportType(InputQtyImportTypeEnum.fromimport);
                    inputQtyBill.setCalculatePeriod(period);
                    inputQtyBill.setBizDate((Date)rowSet.getDate("fbizdate"));
                    inputQtyBill.setBillStatus(BillBaseStatusEnum.AUDITED);
                    inputQtyBill.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                    inputQtyBill.setAuditTime(BDCMUtils.DateToTime((Date)BDCMUtils.now()));
                    inputQtyBill.setIsImport(true);
                    CostCenterOrgUnitInfo costCenter = new CostCenterOrgUnitInfo();
                    costCenter.setId(BOSUuid.read((String)costCenterID));
                    inputQtyBill.setCostCenterOrgUnit(costCenter);
                    inputQtyBillEntry = new InputQtyBillEntryInfo();
                    inputQtyBillEntry.setIsImport(true);
                    CostObjectInfo costObject = new CostObjectInfo();
                    costObject.setId(BOSUuid.read((String)rowSet.getString("FCostObjectID")));
                    inputQtyBillEntry.setCostObject(costObject);
                    BigDecimal inputQty = rowSet.getBigDecimal("fqty");
                    inputQtyBillEntry.setQty(inputQty);
                    inputQtyBill.getEntry().add(inputQtyBillEntry);
                }
                if (inputQtyBill != null) {
                    iInputQtyBill.addnew(inputQtyBill);
                }
                result.put(LcmConstant.STRING_RESULT, LcmConstant.STRING_SUCCESS);
                if (tmpTable == null) break block13;
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
                    }
                    if (tmpTable2 != null) {
                        TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable2);
                    }
                    throw throwable;
                }
            }
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
        }
        if (tmpTable2 != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable2);
        }
        return result;
    }

    private void checkIfCodingRuleExsit(Context ctx, String companyId) throws BOSException, EASBizException {
        if (!CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new InputQtyBillInfo(), companyId)) {
            throw new CMBillException(CMBillException.NOCORDRULE, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"56_InputQtyBillControllerBean", (Locale)ctx.getLocale())});
        }
    }

    @Override
    protected Map _calTopHour(Context ctx, List ids) throws BOSException, EASBizException {
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, companyID);
        try {
            this.topProduct = TempTablePool.getInstance((Context)ctx).createTempTable(LcmUtils.getCreateTableForTopProduct());
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/  insert into " + this.topProduct + " ");
        sql.append("  select en.fcostobjectid  ");
        sql.append("  from t_im_manufacturerecbillentry en ");
        sql.append("  inner join t_im_manufacturerecbill bill on en.fparentid=bill.fid");
        sql.append("  where  bill.fstorageorgunitid='tpyPIjQ0RCmSK9eQYTJBjsznrtQ='");
        sql.append("  and bill.fcostcenterorgunitid='xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
        sql.append("  and bill.fbasestatus=4");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" select distinct e.fid as fid from t_ncm_actualhour b");
        sql.append(" inner join t_ncm_actualhourentry e on b.fid=e.fparentid");
        sql.append(" where b.fcompanyorg='" + companyID + "'");
        sql.append(" and b.fcalculateperiod='" + periodInfo.getId().toString() + "'");
        sql.append(" and e.fcostobjectid in (select fcostobjectid from " + this.topProduct + ")");
        sql.append(" and b.fid in (" + EmmUtils.getSqlFromCollection((Collection)ids) + ")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0016", (Locale)ctx.getLocale())));
            }
            String qcTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_Balance", (int)periodInfo.getNumber(), (int)periodInfo.getNumber());
            sql.setLength(0);
            sql.append(" /*dialect*/ update t_ncm_actualhourentry t1 set t1.fhoursecond=(");
            sql.append(" select nvl(sum(nvl(t2.fhoursecond,0)),0)  ");
            sql.append(" from t_ncm_actualhourentry t2 ");
            sql.append(" inner join t_ncm_actualhour t2b on t2.fparentid=t2b.fid");
            sql.append(" inner join t_bd_costObject co2 on t2.fcostobjectid=co2.fid ");
            sql.append(" inner join t_bd_costObject co1 on co2.fprojectid=co1.fprojectid and co2.ftrackid=co1.ftrackid ");
            sql.append(" where co1.fid=t1.fcostobjectid and co1.fid<>co2.fid ");
            sql.append(" and t2b.fcompanyorg='" + companyID + "'");
            sql.append(" and t2b.fcalculateperiod='" + periodInfo.getId().toString() + "'");
            sql.append(" and t2b.fbillstatus=4");
            sql.append(" and co2.fisfinished=1");
            sql.append(" ) ");
            sql.append(" where  t1.fid in (" + EmmUtils.getSqlFromCollection(idSet) + ")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ update t_ncm_actualhourentry t1 set t1.fhoursecond=(");
            sql.append(" select nvl(t1.fhoursecond,0)+nvl(sum(qct.fbopwiphour*3600),0)  ");
            sql.append(" from " + qcTable + " qct  ");
            sql.append(" inner join t_bd_costObject co2 on qct.fcostobjectid=co2.fid ");
            sql.append(" inner join t_bd_costObject co1 on co2.fprojectid=co1.fprojectid and co2.ftrackid=co1.ftrackid ");
            sql.append(" where co1.fid=t1.fcostobjectid  ");
            sql.append(" and qct.fcompanyorg='" + companyID + "'");
            sql.append(" and qct.fcalculateperiodid='" + periodInfo.getId().toString() + "'");
            sql.append(" and co2.fisfinished=1");
            sql.append(" and co1.fisfinished=1");
            sql.append(" group by t1.fhoursecond");
            sql.append(" ) ");
            sql.append(" where  t1.fid in (" + EmmUtils.getSqlFromCollection(idSet) + ")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Msg", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0017", (Locale)ctx.getLocale()));
        return result;
    }

    @Override
    protected Map _calProjectCost(Context ctx, Map map) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)map.get("company");
        String companyID = company.getId().toString();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, company.getId().toString());
        String periodId = periodInfo.getId().toString();
        try {
            String[] sqlTmp;
            int i;
            int count;
            String allDataTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_AllDataByCostObj", (int)periodInfo.getNumber(), (int)periodInfo.getNumber());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select count(1) as count from " + allDataTable));
            if (rs.next() && (count = rs.getInt("count")) == 0) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"QIJIAN", (Locale)ctx.getLocale(), (Object[])new Object[]{periodInfo.getNumber()});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo + ":" + EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0018", (Locale)ctx.getLocale()) + "\u3002"));
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" create table t_XX (");
            sql.append(" FCompanyID varchar(44),");
            sql.append(" FPeriodID varchar(44),");
            sql.append(" FProjectID varchar(44),");
            sql.append(" FBeginActualHour  NUMERIC(21,8),");
            sql.append(" FInputActualHour  NUMERIC(21,8),");
            sql.append(" FFinisedActualHour  NUMERIC(21,8))");
            String tmpAhTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into " + tmpAhTable + " ");
            sql.append(" select t.fcompanyid,t.fcalculateperiodid,p.fid,sum(t.fbopwiphour),sum(t.finputhour),sum(t.ffinishedhour)");
            sql.append(" from " + allDataTable + " t ");
            sql.append(" inner join t_bd_costobject co on  t.fcostobjectid=co.fid");
            sql.append(" inner join t_mm_project p on co.fprojectid=p.fid");
            sql.append(" where t.fcompanyid='" + companyID + "'");
            sql.append(" and t.fcalculateperiodid='" + periodId + "'");
            sql.append(" having  sum(t.finputhour)>0");
            sql.append(" group by t.fcompanyid,t.fcalculateperiodid,p.fid");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" create table xxx (");
            sql.append(" FCompanyID varchar(44),");
            sql.append(" FPeriodID varchar(44),");
            sql.append(" FProjectElementID varchar(44),");
            sql.append(" FAmount  NUMERIC(21,8))");
            String tmpOtherExpenseTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append(" insert into " + tmpOtherExpenseTable + " ");
            sql.append(" select t.cfficompanyid,t.cfperiodid,e.cfcostelementid,sum(e.cfamount)");
            sql.append(" from CT_LCM_ProjectExpenseAllocBill t ");
            sql.append(" inner join CT_LCM_ProjectEABE e on t.fid=e.fparentid ");
            sql.append(" where t.cfficompanyid='" + companyID + "'");
            sql.append(" and t.cfperiodid='" + periodId + "'");
            sql.append(" and t.cfstatus=4");
            sql.append(" group by t.cfficompanyid,t.cfperiodid,e.cfcostelementid");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)("select sum(FInputActualHour) as ftotal from " + tmpAhTable));
            BigDecimal totalAh = BigDecimal.ZERO;
            if (rs.next()) {
                totalAh = rs.getBigDecimal("ftotal");
            }
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into CT_LCM_PROJECTCOSTHIS");
            sql.append(" select * from CT_LCM_PROJECTCOSTNOW");
            sql.append(" where FCompanyID='" + companyID + "' and FPeriodID<>'" + periodId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ delete from CT_LCM_PROJECTCOSTNOW");
            sql.append(" where FCompanyID='" + companyID + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into CT_LCM_PROJECTCOSTNOW (FCompanyID,FPeriodID,FProjectID,FProjectElementID,");
            sql.append(" FBeginAmount,FHappenAmount,FFinishedAmount,FEndAmount)");
            sql.append(" select t1.FCompanyID,t1.FPeriodID,t1.FProjectID,t2.FProjectElementID,");
            sql.append(" 0,round(t1.FInputActualHour*round(t2.FAmount/" + totalAh + ",8),2),0,0");
            sql.append(" from " + tmpAhTable + " t1 ");
            sql.append(" inner join " + tmpOtherExpenseTable + " t2 on t1.FCompanyID=t2.FCompanyID and t1.FPeriodID=t2.FPeriodID");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ select et.FProjectElementID as fcostelementid,et.famount-sum(nvl(nt.FHappenAmount,0)+nvl(nt.FFinishedAmount,0)) as fdiff");
            sql.append(" from " + tmpOtherExpenseTable + " et ");
            sql.append(" inner join  CT_LCM_PROJECTCOSTNOW nt on et.FCompanyID=nt.FCompanyID   and et.fperiodid=nt.fperiodid and et.FProjectElementID=nt.FProjectElementID");
            sql.append(" group by et.FProjectElementID,et.famount");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal diff = rs.getBigDecimal("fdiff");
                String fcostelementid = rs.getString("fcostelementid");
                if (diff.compareTo(BigDecimal.ZERO) == 0) continue;
                String assign = "+";
                if (diff.compareTo(BigDecimal.ZERO) < 0) {
                    assign = "-";
                }
                sql.setLength(0);
                sql.append(" /*dialect*/ update CT_LCM_PROJECTCOSTNOW set FHappenAmount=FHappenAmount" + assign + diff.abs());
                sql.append(" where FProjectElementID='" + fcostelementid + "'");
                sql.append(" and FCompanyID='" + companyID + "' and FPeriodID='" + periodId + "'");
                sql.append(" and FProjectID=(select FProjectID from CT_LCM_PROJECTCOSTNOW");
                sql.append(" where FProjectElementID='" + fcostelementid + "'");
                sql.append(" and FCompanyID='" + companyID + "' and FPeriodID='" + periodId + "'");
                sql.append(" and rownum=1)");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
            String tmpTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTableA());
            sql = new StringBuffer();
            ArrayList<String> sqls = new ArrayList<String>();
            String rsDataTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalResult", (int)3);
            sqls = new ArrayList();
            for (int i2 = 0; i2 < costItemSql.size(); ++i2) {
                String[] sqlTmp2 = costItemSql.get(i2);
                sql.setLength(0);
                sql.append("/*dialect*/ insert into " + tmpTable + " (FXM,FProjectID," + sqlTmp2[0] + ")");
                sql.append(" select '3',co.fprojectid,");
                sql.append(" sum(rs.ffinishedamount)");
                sql.append(" from " + rsDataTable + " rs");
                sql.append(" inner join t_org_company company on company.fid=rs.fcompanyid");
                sql.append(" inner join t_ncm_costitem ci on ci.fid=rs.fcostitemid");
                sql.append(" inner join t_bd_costobject co on co.fid=rs.fcostobjectid");
                sql.append(" inner join t_mm_project pj on pj.fid=co.fprojectid");
                sql.append(" inner join t_org_costcenter cc on cc.fid=rs.fcostcenterid");
                sql.append(" where 1=1");
                sql.append(sqlTmp2[1]);
                sql.append(" group by co.fprojectid");
                sqls.add(sql.toString());
            }
            EmmUtils.executeBatchUpdate((Context)ctx, sqls);
            String rsDataTableEnd = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_CostCalResult", (int)1);
            sqls = new ArrayList();
            for (i = 0; i < costItemSql.size(); ++i) {
                sqlTmp = costItemSql.get(i);
                sql.setLength(0);
                sql.append("/*dialect*/ insert into " + tmpTable + " (FXM,FProjectID," + sqlTmp[0] + ")");
                sql.append(" select '4' as FXM,co.fprojectid,");
                sql.append(" sum(rs.feopwipamount)");
                sql.append(" from " + rsDataTableEnd + " rs");
                sql.append(" inner join t_org_company company on company.fid=rs.fcompanyid");
                sql.append(" inner join t_ncm_costitem ci on ci.fid=rs.fcostitemid");
                sql.append(" inner join t_bd_costobject co on co.fid=rs.fcostobjectid");
                sql.append(" inner join t_mm_project pj on pj.fid=co.fprojectid");
                sql.append(" inner join t_org_costcenter cc on cc.fid=rs.fcostcenterid");
                sql.append(" where 1=1");
                sql.append(sqlTmp[1]);
                sql.append(" group by co.fprojectid");
                sqls.add(sql.toString());
            }
            EmmUtils.executeBatchUpdate((Context)ctx, sqls);
            DbUtil.execute((Context)ctx, (String)("delete from CT_LCM_PROJECTCOSTMANU where FCOMPANYID='" + companyID + "' and FPERIODID='" + periodId + "'"));
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into CT_LCM_PROJECTCOSTMANU (FXM,FCOMPANYID,FPERIODID,FProjectID,FTCL,");
            sql.append("FGS,FZZCL,FZZBCP,FDLF,FZJRG,FGZFJ,FZZFY,FQTZXF,FTOTAL)");
            sql.append(" select '3','" + companyID + "','" + periodId + "',t.fprojectid,1,0,sum(nvl(t.FZZCL,0)),sum(nvl(t.FZZBCP,0)),sum(nvl(t.FDLF,0)),");
            sql.append(" sum(nvl(t.FZJRG,0)),sum(nvl(t.FGZFJ,0)),sum(nvl(t.FZZFY,0)),sum(nvl(t.FQTZXF,0)),");
            sql.append(" sum(nvl(t.FZZCL,0))+sum(nvl(t.FZZBCP,0))+sum(nvl(t.FDLF,0))+sum(nvl(t.FZJRG,0))+sum(nvl(t.FGZFJ,0))+sum(nvl(t.FZZFY,0))+sum(nvl(t.FQTZXF,0))");
            sql.append(" from " + tmpTable + " t where t.fxm='3'");
            sql.append(" group by t.fprojectid");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into CT_LCM_PROJECTCOSTMANU (FXM,FCOMPANYID,FPERIODID,FProjectID,FTCL,");
            sql.append(" FGS,FZZCL,FZZBCP,FDLF,FZJRG,FGZFJ,FZZFY,FQTZXF,FTOTAL)");
            sql.append(" select '4','" + companyID + "','" + periodId + "',t.fprojectid,1,0,sum(nvl(t.FZZCL,0)),sum(nvl(t.FZZBCP,0)),sum(nvl(t.FDLF,0)),");
            sql.append(" sum(nvl(t.FZJRG,0)),sum(nvl(t.FGZFJ,0)),sum(nvl(t.FZZFY,0)),sum(nvl(t.FQTZXF,0)),");
            sql.append(" sum(nvl(t.FZZCL,0))+sum(nvl(t.FZZBCP,0))+sum(nvl(t.FDLF,0))+sum(nvl(t.FZJRG,0))+sum(nvl(t.FGZFJ,0))+sum(nvl(t.FZZFY,0))+sum(nvl(t.FQTZXF,0))");
            sql.append(" from " + tmpTable + " t where t.fxm='4'");
            sql.append(" group by t.fprojectid");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into CT_LCM_PROJECTCOSTMANU (FXM,FCOMPANYID,FPERIODID,FProjectID)");
            sql.append(" select distinct '2','" + companyID + "','" + periodId + "',t.fprojectid ");
            sql.append(" from " + tmpTable + " t");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sqls = new ArrayList();
            for (i = 0; i < costItemSql.size(); ++i) {
                sqlTmp = costItemSql.get(i);
                sql.setLength(0);
                sql.append("/*dialect*/ update CT_LCM_PROJECTCOSTMANU t1 set " + sqlTmp[0] + " = ");
                sql.append(" nvl((select sum(" + sqlTmp[0] + ") from " + tmpTable + " t2 where t2.fprojectid=t1.fprojectid and t2.fxm='3' group by t2.fprojectid),0) + ");
                sql.append(" nvl((select sum(" + sqlTmp[0] + ") from " + tmpTable + " t3 where t3.fprojectid=t1.fprojectid and t3.fxm='4' group by t3.fprojectid),0)  ");
                sql.append(" where t1.fxm='2' and t1.fcompanyid='" + companyID + "' and t1.fperiodid='" + periodId + "'");
                sqls.add(sql.toString());
            }
            EmmUtils.executeBatchUpdate((Context)ctx, sqls);
            sql.setLength(0);
            sql.append(" /*dialect*/ update CT_LCM_PROJECTCOSTMANU t set ftotal=t.FZZCL+t.FZZBCP+FDLF+FZJRG+FGZFJ+FZZFY+t.FQTZXF");
            sql.append(" where t.fxm='2' and t.fcompanyid='" + companyID + "' and t.fperiodid='" + periodId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String ahDataTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_AllDataByCostObj", (int)3);
            String gsTmpTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTableGS());
            sql.setLength(0);
            sql.append(" /*dialect*/ insert into " + gsTmpTable);
            sql.append(" select co.fprojectid,sum(nvl(t.finputhour,0)),sum(nvl(t.ffinishedhour,0)) ");
            sql.append(" from " + ahDataTable + " t");
            sql.append(" inner join t_bd_costobject co on t.fcostobjectid=co.fid");
            sql.append(" group by co.fprojectid ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ update CT_LCM_PROJECTCOSTMANU t1 set t1.FGS=");
            sql.append(" (select t2.FInputHour from " + gsTmpTable + " t2");
            sql.append(" where t2.fprojectid=t1.fprojectid and t1.fxm='2')");
            sql.append(" where t1.fxm='2'");
            sql.append(" and t1.fcompanyid='" + companyID + "' and t1.fperiodid='" + periodId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" /*dialect*/ update CT_LCM_PROJECTCOSTMANU t1 set t1.FGS=");
            sql.append(" (select t2.FFinishedHour from " + gsTmpTable + " t2");
            sql.append(" where t2.fprojectid=t1.fprojectid and t1.fxm='3')");
            sql.append(" where t1.fxm='3'");
            sql.append(" and t1.fcompanyid='" + companyID + "' and t1.fperiodid='" + periodId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String ahDataTableEnd = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)ctx, (String)companyID, (String)"T_NCM_AllDataByCostObj", (int)1);
            sql.setLength(0);
            sql.append(" /*dialect*/ update CT_LCM_PROJECTCOSTMANU t1 set t1.FGS=");
            sql.append(" (select sum(nvl(t2.feopwiphour,0)) from " + ahDataTableEnd + " t2");
            sql.append(" inner join t_bd_costobject co on t2.fcostobjectid=co.fid");
            sql.append(" where co.fprojectid=t1.fprojectid and t1.fxm='4')");
            sql.append(" where t1.fxm='4'");
            sql.append(" and t1.fcompanyid='" + companyID + "' and t1.fperiodid='" + periodId + "'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Msg", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0019"));
        return result;
    }

    private String createTempTableA() {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("create table tempTableX(");
        sql.append("FXM varchar(44),");
        sql.append("FProjectID varchar(44),");
        sql.append("FTCL NUMERIC(28,14),");
        sql.append("FGS NUMERIC(28,14),");
        sql.append("FZZCL NUMERIC(28,14),");
        sql.append("FZZBCP NUMERIC(28,14),");
        sql.append("FDLF NUMERIC(28,14),");
        sql.append("FZJRG NUMERIC(28,14),");
        sql.append("FGZFJ NUMERIC(28,14),");
        sql.append("FZZFY NUMERIC(28,14),");
        sql.append("FQTZXF NUMERIC(28,14),");
        sql.append("FTOTAL NUMERIC(28,14)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempTableGS() {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("create table tempTableX(");
        sql.append("FProjectID varchar(44),");
        sql.append("FInputHour NUMERIC(28,14),");
        sql.append("FFinishedHour NUMERIC(28,14)");
        sql.append(")");
        return sql.toString();
    }

    static {
        String[] tmp = new String[]{"FZZCL", " and ci.fid='+PuAkE8fQzK5FtdQELQybFSMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FZZBCP", " and ci.fid='l71y2L/VQYOwV0IXMqbyylSMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FDLF", " and ci.fid='6LSaWvujSxCsaOEirl4NPFSMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FGZFJ", " and ci.fid='IXCTfdL/R2eDgdmiIso+W1SMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FZJRG", " and  ci.fid='1Ldo8TVDSRWORYz1dxz6LVSMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FZZFY", " and ci.fid='Is6+Dy+ISqOb4EbcwDdoVVSMWpE=' "};
        costItemSql.add(tmp);
        tmp = new String[]{"FQTZXF", " and ci.fid='0uOSWfnFQPmVUOvA6QAAIFSMWpE='"};
        costItemSql.add(tmp);
    }
}

