/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.industry.emm.lcm.ProjectCostElementInfo;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillCollection;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillEntryInfo;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillFactory;
import com.kingdee.eas.industry.emm.lcm.ProjectExpenseAllocBillInfo;
import com.kingdee.eas.industry.emm.lcm.app.AbstractProjectExpenseAllocBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProjectExpenseAllocBillControllerBean
extends AbstractProjectExpenseAllocBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.lcm.app.ProjectExpenseAllocBillControllerBean");
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectExpenseAllocBillInfo bill = (ProjectExpenseAllocBillInfo)model;
        bill.setCU(super.getCU(ctx, (ObjectBaseInfo)bill));
        this.checkStart(ctx, (IObjectValue)bill);
        this.checkNumber(ctx, (IObjectValue)bill);
        return super._addnew(ctx, model);
    }

    protected void _checkStart(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        ProjectExpenseAllocBillCollection billColl = this.getBillColl(ctx, pks, null);
        this.checkStart(ctx, (IObjectCollection)billColl);
    }

    private ProjectExpenseAllocBillCollection getBillColl(Context ctx, IObjectPK[] pks, SelectorItemCollection sic) throws BOSException {
        Set idSet = NCMUtils.arrayPK2Set((IObjectPK[])pks);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (sic != null) {
            evi.setSelector(sic);
        }
        return this.getProjectExpenseAllocBillCollection(ctx, evi);
    }

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo companyinfo = ((ProjectExpenseAllocBillInfo)model).getFICompany();
        if (((ProjectExpenseAllocBillInfo)model).getPeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(((ProjectExpenseAllocBillInfo)model).getPeriod().getId().toString()));
        if (!ctrol.isStart(1001, companyinfo.getId().toString())) {
            throw new CMBillException(CMBillException.COST_NOTON);
        }
        if (this.isCheckStart() && !NCMUtils.isBig((PeriodInfo)ctrol.getCacheCurrentPeriod(1001, companyinfo.getId().toString()), (PeriodInfo)period)) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    protected void checkStart(Context ctx, IObjectCollection billColl) throws BOSException, EASBizException {
        PeriodInfo period;
        PeriodInfo curPeriod;
        if (billColl == null || billColl.isEmpty()) {
            return;
        }
        ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)billColl.getObject(0);
        CompanyOrgUnitInfo companyInfo = info.getFICompany();
        if (info.getPeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        this.checkStartDiff(ctrol, companyInfo.getId().toString());
        if (this.isCheckStart() && !NCMUtils.isBig((PeriodInfo)(curPeriod = ctrol.getCacheCurrentPeriod(1001, companyInfo.getId().toString())), (PeriodInfo)(period = this.getLeastPeriodInfo(ctx, billColl)))) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }

    protected PeriodInfo getLeastPeriodInfo(Context ctx, IObjectCollection billColl) throws BOSException {
        if (billColl == null || billColl.isEmpty()) {
            return new PeriodInfo();
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < billColl.size(); ++i) {
            ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)billColl.getObject(i);
            idSet.add(info.getPeriod().getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("number"));
        PeriodCollection periodColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(evi);
        if (periodColl.size() > 0) {
            return periodColl.get(0);
        }
        return new PeriodInfo();
    }

    protected boolean isCheckStart() {
        return true;
    }

    private void checkStartDiff(ISystemStatusCtrol ctrol, String companyId) throws CMBillException, EASBizException, BOSException {
        boolean isInit = ctrol.isStart(1001, companyId);
        if (this.checkStartForCommon()) {
            if (!isInit) {
                throw new CMBillException(CMBillException.COST_NOTON);
            }
        } else if (isInit) {
            throw new CMBillException(CMBillException.COST_ISON);
        }
    }

    protected boolean checkStartForCommon() {
        return true;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)model;
        if (info == null) {
            info = (ProjectExpenseAllocBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus().getValue() != 2) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0000", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        this.checkStart(ctx, (IObjectValue)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)model;
        if (info == null) {
            info = (ProjectExpenseAllocBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0002", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectExpenseAllocBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0003", (Locale)ctx.getLocale())));
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getFICompany() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0004", (Locale)ctx.getLocale()));
        }
        if (eti.getPeriod() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0005", (Locale)ctx.getLocale()));
        }
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            String strInfo;
            ProjectExpenseAllocBillEntryInfo entry = eti.getEntrys().get(i);
            if (entry.getCostElement() == null) {
                strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
                errStr.append(";" + strInfo + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0012", (Locale)ctx.getLocale()));
            }
            if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(entry.getAmount())) continue;
            strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            errStr.append(";" + strInfo + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0021", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectExpenseAllocBillInfo eti = (ProjectExpenseAllocBillInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectExpenseAllocBillInfo eti = (ProjectExpenseAllocBillInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void checkNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectExpenseAllocBillInfo info = (ProjectExpenseAllocBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus(model, info.getFICompany().getId().toString());
        if (ruleStatus.isExist() && (StringUtils.isEmpty((String)info.getNumber()) || ruleStatus.isAddNoBreak() || !ruleStatus.isModifiable() && this.isNumberUsed(ctx, info))) {
            this.setNewNumber(ctx, info, iCodingRuleManager, null);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(model.getBOSUuid("id"));
            super._checkNumberBlank(ctx, (IObjectPK)pk, model);
            super._checkNumberDup(ctx, (IObjectPK)pk, model);
        }
    }

    protected boolean isNumberUsed(Context ctx, ProjectExpenseAllocBillInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS));
        if (info.getCU() != null) {
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)info.getCU().getId().toString(), CompareType.EQUALS));
        }
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        boolean exist = super._exists(ctx, filter);
        return exist;
    }

    protected void setNewNumber(Context ctx, ProjectExpenseAllocBillInfo info, ICodingRuleManager iCodingRuleManager, String customString) throws BOSException, EASBizException {
        String number = iCodingRuleManager.getNumber((IObjectValue)info, info.getFICompany().getId().toString(), customString);
        info.setNumber(number);
        if (this.isNumberUsed(ctx, info)) {
            this.setNewNumber(ctx, info, iCodingRuleManager, customString);
        }
    }

    protected String _getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        String strBindProp;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        ProjectExpenseAllocBillInfo aSCMBillBaseInfo = (ProjectExpenseAllocBillInfo)model;
        String number = "";
        boolean isNumberNoSet = false;
        if (aSCMBillBaseInfo.getNumber() == null || aSCMBillBaseInfo.getNumber().length() == 0) {
            isNumberNoSet = true;
        }
        if ((strBindProp = this.getBindingProperty(ctx)) != null && strBindProp.trim().length() > 0) {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString);
            aSCMBillBaseInfo.setNumber(number);
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            aSCMBillBaseInfo.setNumber(number);
        }
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = strBindProp != null && strBindProp.trim().length() > 0 ? iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp, customString) : iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new CMBillException(CMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this._getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, customString);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectExpenseAllocBillInfo aSCMBillBaseInfo = (ProjectExpenseAllocBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty(ctx) != null && this.getBindingProperty(ctx).trim().length() > 0 && aSCMBillBaseInfo.get(this.getBindingProperty(ctx)) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(ctx), this.getBindingPropertyValue(aSCMBillBaseInfo), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected Object getBindingPropertyValue(ProjectExpenseAllocBillInfo aSCMBillBaseInfo) {
        return null;
    }

    @Override
    protected Map _autoFromGL(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyID = company.getId().toString();
        ISystemStatusCtrol ibiz = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ibiz.getCacheCurrentPeriod(1001, company.getId().toString());
        String periodId = periodInfo.getId().toString();
        String currencyid = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select '" + companyID + "' as fcompanyid,'" + periodId + "' as fperiodid,pce.fid as fpceid,b.fdebitfor as famount");
        sql.append(" from t_gl_accountbalance b");
        sql.append(" inner join T_BD_AccountView av on b.faccountid=av.fid");
        sql.append(" inner join ct_lcm_projectcostelement pce on pce.cfaccountid=av.fid ");
        sql.append(" where b.fbaltype=5 and b.fperiodid='" + periodId + "' ");
        sql.append(" and av.fcompanyid='" + companyID + "'");
        sql.append(" and b.fcurrencyid='" + currencyid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ProjectExpenseAllocBillInfo bill = new ProjectExpenseAllocBillInfo();
        bill.setFICompany(company);
        bill.setPeriod(periodInfo);
        try {
            while (rs.next()) {
                ProjectExpenseAllocBillEntryInfo entry = new ProjectExpenseAllocBillEntryInfo();
                entry.setId(BOSUuid.create((String)entry.getBOSType().toString()));
                String pceid = rs.getString("fpceid");
                ProjectCostElementInfo pceInfo = new ProjectCostElementInfo();
                pceInfo.setId(BOSUuid.read((String)pceid));
                entry.setCostElement(pceInfo);
                entry.setAmount(rs.getBigDecimal("famount"));
                bill.getEntrys().add(entry);
            }
            if (bill.getEntrys().size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0022", (Locale)ctx.getLocale())));
            }
            bill.setDescription(EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0023", (Locale)ctx.getLocale()));
            ProjectExpenseAllocBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)bill);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("Msg", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0024", (Locale)ctx.getLocale()));
        return result;
    }
}

