/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.lcm.util.LcmUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostEstimationExceptionDetailsRptServer
extends ReportServerBase {
    private String project;
    private String projectId;
    private String projectName;
    private String periodNumberFrom;
    private String companyID;
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.rpt.app.CostEstimationExceptionDetailsRptServer");

    protected IRowSet getReportData(String s, RptParams params) throws Exception {
        Context ctx = this.getContext();
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.initRptParams(params);
        if (this.periodNumberFrom == null) {
            return null;
        }
        int pf = Integer.parseInt(this.periodNumberFrom);
        int y = Integer.parseInt((pf + "").substring(0, 4));
        int m = Integer.parseInt((pf + "").substring(4, 6));
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodTypeInfo pt = new PeriodTypeInfo();
        pt.setId(BOSUuid.read((String)"7p+3Pg7ZRWSmsI8znYyoq19piaY="));
        IPeriod iperiod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo curCMPeriod = iperiod.getPeriodInfo(y, m, pt);
        String[] dateStrArray = LcmUtils.dealPeriod(curCMPeriod);
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyID);
        if (currentPeriod.getNumber() <= pf) {
            // empty if block
        }
        String resultTmpTbale = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTable());
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("/*dialect*/ insert into " + resultTmpTbale);
        sql.append(" select co.fid as FCostObjectID,co.fprojectid as FProjectID, e.fmaterialId as FMaterialID,e.fqty as FQty,e.factualcost as FActualCost");
        sql.append(" from t_im_materialreqbill b");
        sql.append(" inner join t_im_materialreqbillentry e on b.fid=e.fparentid ");
        sql.append(" inner join t_bd_costobject co on e.fcostobjectid=co.fid ");
        sql.append(" where 1=1");
        sql.append(" and e.fcompanyorgunitid='" + this.companyID + "'");
        sql.append(" and co.cffinishedtime is not null");
        sql.append(" and co.cffinishedtime < to_date('").append(dateStrArray[0]).append("','yyyy-MM-dd HH24:mi:ss') ");
        sql.setLength(0);
        sql.append(" select p.fnumber as FProject,p.fname_l2 as FProjectNumber,");
        sql.append(" c.fnumber as FCostObjectNumber,c.fname_l2 as FCostObjectName,");
        sql.append(" m.fnumber as FMaterialNumber,m.fname_l2 as FMaterialName,");
        sql.append(" t.fqty,t.FActualCost");
        sql.append(" from " + resultTmpTbale + " t");
        sql.append(" inner join t_mm_project p on t.FProjectID=p.fid");
        sql.append(" inner join t_bd_costobject c on t.FCostObjectID=c.fid");
        sql.append(" inner join t_bd_material m on t.FMaterialID=m.fid");
        sql.append(" order by p.fnumber,c.fnumber,m.fnumber");
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        this.dropTempTable(s, params, resultTmpTbale);
        return set;
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableX(");
        sql.append("FProjectID varchar(44),");
        sql.append("FCostObjectID varchar(44),");
        sql.append("FMaterialID varchar(44),");
        sql.append("FQty NUMERIC(28,14),");
        sql.append("FActualCost NUMERIC(28,14)");
        sql.append(")");
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        this.companyID = params.getObject("company") != null ? ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() : null;
        if (params.getObject("project") != null) {
            String[] tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0];
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fid,fname_l2 as fname from t_mm_project where fnumber='" + this.project + "'"));
            if (rs.next()) {
                this.projectId = rs.getString("fid");
                this.projectName = rs.getString("fname");
            }
        } else {
            this.project = null;
        }
        this.periodNumberFrom = params.getObject("periodFrom") != null ? params.getObject("periodFrom").toString() : null;
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        return null;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FProject", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0050", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FProjectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0065", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FCostObjectNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0066", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FCostObjectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0067", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FMaterialNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0068", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FMaterialName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0069", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FQty", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0070", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FActualCost", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0071", (Locale)this.getContext().getLocale()));
        return reportHeader;
    }
}

