/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostEstimationGatherRptServer
extends ReportServerBase {
    private String project;
    private String projectId;
    private String projectName;
    private String trackNumber;
    private String trackNumberId;
    private String periodNumberFrom;
    private String companyID;
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.rpt.app.ProjectGainGusanRptServer");

    protected IRowSet getReportData(String s, RptParams params) throws Exception {
        Context ctx = this.getContext();
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.initRptParams(params);
        if (this.periodNumberFrom == null) {
            return null;
        }
        int pf = Integer.parseInt(this.periodNumberFrom);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyID);
        if (currentPeriod.getNumber() <= pf) {
            // empty if block
        }
        String resultTmpTbale = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTable());
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ insert into " + resultTmpTbale);
        sql.append(" select t.FProjectID,sum(FQC) as FQC,sum(FBQ) as FBQ,sum(FBQCX) as FBQCX,sum(FQM) FQM  from (");
        sql.append(" select b.CFProjectID as FProjectID,sum(e.CFAmount) as FQC,0 as FBQ,0 as FBQCX,0 as FQM");
        sql.append(" from ct_lcm_costestimationbill b");
        sql.append(" inner join ct_lcm_costestimationbillentry e on b.fid=e.fparentid");
        sql.append(" inner join t_bd_period p on p.fid=b.cfperiodid");
        sql.append(" where b.cfstatus=4 and b.cfischarge=0");
        sql.append(" and p.fnumber<" + pf);
        sql.append(" group by b.cFProjectID");
        sql.append(" union all");
        sql.append(" select b.CFProjectID,sum(e.CFAmount) as FQC,0 as FBQ,0 as FBQCX,0 as FQM");
        sql.append(" from ct_lcm_costestimationbill b");
        sql.append(" inner join ct_lcm_costestimationbillentry e on b.fid=e.fparentid");
        sql.append(" inner join t_bd_period p on p.fid=b.cfperiodid");
        sql.append(" where b.cfstatus=4 and b.cfischarge=1");
        sql.append(" and p.fnumber<" + pf);
        sql.append(" group by b.cFProjectID");
        sql.append(" union all");
        sql.append(" select b.CFProjectID,0 as FQC,sum(e.CFAmount) as FBQ,0 as FBQCX,0 as FQM");
        sql.append(" from ct_lcm_costestimationbill b");
        sql.append(" inner join ct_lcm_costestimationbillentry e on b.fid=e.fparentid");
        sql.append(" inner join t_bd_period p on p.fid=b.cfperiodid");
        sql.append(" where b.cfstatus=4 and b.cfischarge=0");
        sql.append(" and p.fnumber=" + pf);
        sql.append(" group by b.cFProjectID");
        sql.append(" union all");
        sql.append(" select b.CFProjectID,0 as FQC,0 as FBQ,sum(e.CFAmount) as FBQCX,0 as FQM");
        sql.append(" from ct_lcm_costestimationbill b");
        sql.append(" inner join ct_lcm_costestimationbillentry e on b.fid=e.fparentid");
        sql.append(" inner join t_bd_period p on p.fid=b.cfperiodid");
        sql.append(" where b.cfstatus=4 and b.cfischarge=1");
        sql.append(" and p.fnumber=" + pf);
        sql.append(" group by b.CFProjectID");
        sql.append(" ) t group by t.FProjectID");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + resultTmpTbale + " set FQM=nvl(FQC,0)+nvl(FBQ,0)-nvl(FBQCX,0) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer selectAll = new StringBuffer();
        selectAll.append(" SELECT p.fnumber as FProject,p.fname_l2 as FProjectName ");
        sql.append(",to_char(nvl(t.FQC,0),'fm999,999,999,999,990.00')  as FQC");
        sql.append(",to_char(nvl(t.FBQ,0),'fm999,999,999,999,990.00')  as FBQ");
        sql.append(",to_char(nvl(t.FBQCX,0),'fm999,999,999,999,990.00')  as FBQCX");
        sql.append(",to_char(nvl(t.FQM,0),'fm999,999,999,999,990.00')  as FQM");
        selectAll.append(" from " + resultTmpTbale + " t ");
        selectAll.append(" inner join t_mm_project p on t.FProjectID=p.fid ");
        selectAll.append(" order by p.fnumber ");
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)selectAll.toString());
        this.dropTempTable(s, params, resultTmpTbale);
        return set;
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableX(");
        sql.append("FProjectID varchar(44),");
        sql.append("FQC NUMERIC(28,14),");
        sql.append("FBQ NUMERIC(28,14),");
        sql.append("FBQCX NUMERIC(28,14),");
        sql.append("FQM NUMERIC(28,14)");
        sql.append(")");
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rs;
        String[] tmp;
        this.companyID = params.getObject("company") != null ? ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() : null;
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0];
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fid,fname_l2 as fname from t_mm_project where fnumber='" + this.project + "'"));
            if (rs.next()) {
                this.projectId = rs.getString("fid");
                this.projectName = rs.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0];
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fid from t_mm_tracknumber where fnumber='" + this.trackNumber + "'"));
            if (rs.next()) {
                this.trackNumberId = rs.getString("fid");
            }
        } else {
            this.trackNumber = null;
        }
        this.periodNumberFrom = params.getObject("periodFrom") != null ? params.getObject("periodFrom").toString() : null;
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        return null;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader t = reportHeader.addChild("FProject", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0050", (Locale)this.getContext().getLocale()));
        t = reportHeader.addChild("FProjectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0065", (Locale)this.getContext().getLocale()));
        t = reportHeader.addChild("FQC", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0072", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FBQ", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0073", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FBQCX", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0074", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FQM", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0075", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        return reportHeader;
    }
}

