/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.industry.emm.lcm.util.LcmUtils;
import com.kingdee.eas.mm.basedata.BomCollection;
import com.kingdee.eas.mm.basedata.BomFactory;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;

public class EstimateListDetailsRptServer
extends ReportServerBase {
    private String project;
    private String projectId;
    private String projectName;
    private String trackNumber;
    private String trackNumberId;
    private String periodNumberFrom;
    private String periodNumberTo;
    private String companyID;
    private String[] materials;
    private String[] sous;
    private String flow;
    private String price1;
    private String price2;
    private String amount1;
    private String amount2;
    private boolean isEstimateOperation = false;

    protected IRowSet getReportData(String s, RptParams params) throws Exception {
        Context ctx = this.getContext();
        boolean isConnect = params.getObject("isconnect") != null;
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.initRptParams(params);
        if (this.periodNumberFrom == null) {
            return null;
        }
        int pf = Integer.parseInt(this.periodNumberFrom);
        ISystemStatusCtrol sysctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo currentPeriod = sysctrol.getCacheCurrentPeriod(2, this.companyID);
        if (currentPeriod.getNumber() <= pf) {
            // empty if block
        }
        String tempTableReport = null;
        try {
            tempTableReport = TempTablePool.getInstance((Context)ctx).createTempTable(LcmUtils.createCETableSql("XXX"));
            this.expendBom(pf, tempTableReport, s, params, this.projectId, this.trackNumberId);
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append(" /*dialect*/ insert into " + tempTableReport + " (FQty,FAmount,FActualReqQty,FActualCost,FDiffForQty,FEstimateAmount)");
        sql.append(" select sum(FQty),sum(FAmount),sum(FActualReqQty),sum(FActualCost),sum(FDiffForQty),sum(FEstimateAmount)");
        sql.append(" from " + tempTableReport);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (this.price1 != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FPrice<" + this.price1));
        }
        if (this.price2 != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FPrice>" + this.price2));
        }
        if (this.amount1 != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FEstimateAmount<" + this.amount1));
        }
        if (this.amount2 != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FEstimateAmount>" + this.amount2));
        }
        sql.setLength(0);
        sql.append("/*dialect*/ select trackNumber.fname_l2 as FTrackNumber");
        sql.append(",sou.fnumber as FStorageOrgUnit,sou.fname_l2 as FStorageOrgUnitName");
        sql.append(",m.fnumber as FMaterialNumber,m.fname_l2 as FMaterialName,m.fmodel as FModel");
        sql.append(",unit.fname_l2 as FUnit,tmp.fqty as FQty");
        sql.append(",to_char(FPrice,'fm999,999,999,999,990.00') as FPrice");
        sql.append(",to_char(FAmount,'fm999,999,999,999,990.00') as FAmount");
        sql.append(",'' as FBuJianType");
        sql.append(",FBomFlow as FFlow");
        sql.append(",FActualReqQty as FActualReqQty");
        sql.append(",to_char(FActualPrice,'fm999,999,999,999,990.00') as FActualPrice");
        sql.append(",to_char(FActualCost,'fm999,999,999,999,990.00') as FActualCost");
        sql.append(",to_char(FDiffForPrice,'fm999,999,999,999,990.00') as FDiffForPrice");
        sql.append(",FDiffForQty as FDiffForQty");
        sql.append(",to_char(FEstimateAmount,'fm999,999,999,999,990.00') as FEstimateAmount");
        sql.append(",FPeriod as FPeriod,FCompanyID as FCompanyID,'" + tempTableReport + "' as FTableName");
        if (this.materials == null) {
            sql.append(",'0' as FIsMaterial");
        } else {
            sql.append(",'1' as FIsMaterial");
        }
        sql.append(" from " + tempTableReport + " tmp");
        sql.append(" left join t_bd_material m on m.fid=tmp.fmaterialid");
        sql.append(" left join t_mm_project p on p.fid=tmp.fprojectid");
        sql.append(" left join t_mm_tracknumber trackNumber on trackNumber.fid=tmp.ftracknumberid");
        sql.append(" inner join t_org_storage sou on sou.fid =tmp.FSouID");
        sql.append(" left join t_bd_measureunit unit on m.fbaseunit=unit.fid");
        sql.append(" ");
        sql.append(" order by sou.fnumber,m.fnumber");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return result;
    }

    protected void expendBom(int pf, String tempTableReport, String s, RptParams params, String projectID, String trackNumberID) throws Exception {
        Context ctx = this.getContext();
        StringBuffer sql = new StringBuffer();
        sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
        sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
        sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
        sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
        sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
        sql.append(" where p.fid='" + projectID + "'");
        sql.append(" and stn.fnumber<='" + this.trackNumber + "' and etn.fnumber>='" + this.trackNumber + "'");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        String topMId = null;
        if (!rs.next()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0084", (Locale)ctx.getLocale())));
        }
        topMId = rs.getString("materialid");
        String bomid = null;
        String souId = null;
        BomCollection bom = BomFactory.getLocalInstance((Context)this.getContext()).getBomCollection("select id,storageOrgUnit.id where material.id = '" + topMId + "'  and project.number = '" + this.project + "' and baseStatus = 4");
        if (bom.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0085", (Locale)ctx.getLocale())));
        }
        bomid = bom.get(0).getId().toString();
        souId = bom.get(0).getStorageOrgUnit().getId().toString();
        StringBuffer flowSql = new StringBuffer();
        flowSql.append(" select bomentry.fparentid,bomentry.CFBomFlow,bomentry.fid,bomentry.FConsumeFixQty, '' AS FSource,bom.FMATERIALID fpmaterialid,bomentry.FMaterialProp,  '' as FProvideType  from t_mm_bomentry  bomentry ");
        flowSql.append(" inner join t_mm_bom bom on bom.fid=bomentry.fparentid");
        flowSql.append(" inner join t_mm_tracknumber btrack on btrack.fid=bomEntry.CFBeginCarnoID");
        flowSql.append(" inner join t_mm_tracknumber etrack on etrack.fid=bomEntry.CFEndCarnoID");
        flowSql.append(" inner join t_mm_tracknumber temptrack on temptrack.fid='" + this.trackNumberId + "'");
        flowSql.append(" where bomentry.fmaterialid='" + topMId + "'  and bom.fprojectid='" + this.projectId + "'");
        flowSql.append(" and temptrack.fnumber  between btrack.fnumber and etrack.fnumber ");
        flowSql.append(" and bom.fbaseStatus = 4 ");
        String bomflow = "";
        String pbomid = "";
        String fSource = "";
        String fpmaterialid = "";
        String FProvideType = "";
        String FMaterialProp = "";
        rs = DbUtil.executeQuery((Context)ctx, (String)flowSql.toString());
        if (rs.next()) {
            pbomid = rs.getString("fparentid");
            bomflow = rs.getString("CFBomFlow");
            rs.getString("fid");
            fSource = rs.getString("FSource");
            fpmaterialid = rs.getString("fpmaterialid");
            FProvideType = rs.getString("FProvideType");
            FMaterialProp = rs.getString("FMaterialProp");
        }
        String tblmmbom = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTableSql());
        TempTablePool.getInstance((Context)ctx).createIndex(tblmmbom, "fbomid", false, false);
        TempTablePool.getInstance((Context)ctx).createIndex(tblmmbom, "fmaterialid", false, false);
        sql.setLength(0);
        sql.append(" insert into ").append(tblmmbom).append(" values (");
        sql.append("'").append(topMId).append("',");
        sql.append("'").append(topMId).append("',");
        sql.append("'").append(pbomid).append("',");
        sql.append("'").append(souId).append("',");
        sql.append("'").append(bomid).append("',");
        sql.append("'").append(this.trackNumberId).append("',");
        sql.append("'").append(this.projectId).append("',");
        sql.append("'").append(souId).append("',");
        sql.append("'").append(bomflow).append("',");
        sql.append("'").append(0).append("',");
        sql.append("'").append(1).append("',");
        sql.append("'").append(1).append("',");
        sql.append("'").append(fpmaterialid).append("',");
        sql.append("'").append(fSource).append("',");
        sql.append("'").append(FMaterialProp).append("',");
        sql.append("'").append(FProvideType).append("')");
        int i = SQLUtils.execute((Context)ctx, (String)sql.toString());
        if (i < 1) {
            return;
        }
        for (int a = 0; a < 99; ++a) {
            sql.setLength(0);
            sql.append("  insert into ").append(tblmmbom).append(" (fmaterialid,ftrackid,fprojectid,forgid,fissign,bomflow,fpbomid,fpbomorgid,fqty,FPQty,FSource,fpmaterialid,FMaterialProp,FProvideType)");
            sql.append("  select bomEntry.Fmaterialid,tmp.ftrackid,tmp.fprojectid,tmp.forgid,").append("'").append(a + 1).append("'");
            sql.append(",bomEntry.CFBomFlow,bom.fid,bom.fstorageorgunitid,tmp.fqty*bomEntry.Fconsumefixqty,tmp.fqty,  '' AS FSource,bom.FMATERIALID,bomentry.FMaterialProp,   '' as FProvideType from  ").append(tblmmbom).append(" tmp ");
            sql.append("  inner join t_mm_bom bom on tmp.fbomid=bom.fid");
            sql.append("  inner join t_mm_bomentry bomEntry on bom.fid=bomEntry.Fparentid");
            sql.append("  inner join t_mm_tracknumber btrack on btrack.fid=bomEntry.CFBeginCarnoID");
            sql.append("  inner join t_mm_tracknumber etrack on etrack.fid=bomEntry.CFEndCarnoID");
            sql.append("  inner join t_mm_tracknumber temptrack on temptrack.fid=tmp.ftrackid");
            sql.append("  where 1=1 AND temptrack.fnumber>=btrack.fnumber and temptrack.fnumber<=etrack.fnumber and tmp.fissign='").append(a).append("'");
            sql.append(" and bom.fbaseStatus = 4 ");
            i = SQLUtils.execute((Context)ctx, (String)sql.toString());
            if (i <= 0) break;
            sql.setLength(0);
            sql.append(" update ").append(tblmmbom).append(" tmp set (fbomid,forgid)=");
            sql.append(" (select top 1 fid,fstorageorgunitid from t_mm_bom t where t.fstorageorgunitid=tmp.forgid and ");
            sql.append(" t.fmaterialid=tmp.fmaterialid and tmp.fprojectid=t.fprojectid and t.fbaseStatus = 4 ) where tmp.fbomid is null and tmp.fissign='").append(a + 1).append("'");
            sql.append(" and exists (select 1 from t_mm_bom t where t.fstorageorgunitid=tmp.forgid and ");
            sql.append(" t.fmaterialid=tmp.fmaterialid and tmp.fprojectid=t.fprojectid and t.fbaseStatus = 4)");
            i = SQLUtils.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update ").append(tblmmbom).append(" tmp set (fbomid,forgid)=");
            sql.append(" (select top 1 fid,fstorageorgunitid from t_mm_bom t where 1=1 and ");
            sql.append(" t.fmaterialid=tmp.fmaterialid and tmp.fprojectid=t.fprojectid and t.fbaseStatus = 4 ) where tmp.fbomid is null and tmp.fissign='").append(a + 1).append("'");
            sql.append(" and exists (select 1 from t_mm_bom t where 1=1 and ");
            sql.append(" t.fmaterialid=tmp.fmaterialid and tmp.fprojectid=t.fprojectid and t.fbaseStatus = 4)");
            i = SQLUtils.execute((Context)ctx, (String)sql.toString());
        }
        String adminTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTableSqlForAdminSou());
        StringBuffer sqlAdmin = new StringBuffer();
        sqlAdmin.append("/*dialect*/ insert into " + adminTempTable + " values ('/BCeURxpSDC3xZT3++FVfcznrtQ=','eWbCBD/ZQ1+ebRrZDuxF3cznrtQ=')");
        SQLUtils.execute((Context)ctx, (String)sqlAdmin.toString());
        sqlAdmin.setLength(0);
        sqlAdmin.append("/*dialect*/ insert into " + adminTempTable + " values ('Tk+U1KnxRdiYf+uNUrNJRMznrtQ=','AcgiAdKIT7Cs4dP40U7KTcznrtQ=')");
        SQLUtils.execute((Context)ctx, (String)sqlAdmin.toString());
        sqlAdmin.setLength(0);
        sqlAdmin.append("/*dialect*/ insert into " + adminTempTable + " values ('ROz/muIDQRyL3Fs3ix6jFcznrtQ=','nXnw4GGNRh+AxZ/cMEMFpcznrtQ=')");
        SQLUtils.execute((Context)ctx, (String)sqlAdmin.toString());
        sqlAdmin.setLength(0);
        sqlAdmin.append("/*dialect*/ insert into " + adminTempTable + " values ('5fRddvCtQUKum9jw1yaACsznrtQ=','8vJD+kZuRLuQlkF2ysZ3b8znrtQ=')");
        SQLUtils.execute((Context)ctx, (String)sqlAdmin.toString());
        StringBuffer sql2 = new StringBuffer();
        sql2.append("insert into ");
        sql2.append(tempTableReport);
        sql2.append(" (FProjectID,FTrackNumberID,");
        sql2.append("FSouID,");
        sql2.append("FBomFlow,");
        sql2.append("FMaterialID,FQty,FPeriod,FCompanyID) ");
        sql2.append("select  ");
        sql2.append("temp.fprojectid,\r\n");
        sql2.append("temp.ftrackid,\r\n");
        sql2.append("temp.forgid,\r\n");
        sql2.append("temp.bomflow,\r\n");
        sql2.append("ma.fid,");
        sql2.append("sum(temp.fpqty*pben.CFConsumeQuota),");
        sql2.append(pf + ",");
        sql2.append("'" + this.companyID + "'");
        sql2.append(" from  ");
        sql2.append(tblmmbom);
        sql2.append(" temp");
        sql2.append(" inner join t_mm_pbom pb ");
        sql2.append(" on temp.fpbomid = pb.fbomid");
        sql2.append(" inner join T_MM_StandardRooting sroot on sroot.fid = pb.froutingID");
        sql2.append(" inner join T_MM_PBOMEntry pben  on pben.fparentid = pb.fid and temp.fmaterialid =pben.CFMaterialID");
        sql2.append(" inner join T_MM_MaterialRWP rwp ");
        sql2.append(" on rwp.fid = pben.FRoutingitemid ");
        sql2.append(" inner join T_MM_Operation op");
        sql2.append(" on op.fid = rwp.foperationid");
        sql2.append(" inner join T_MM_WorkCenter wc");
        sql2.append(" on wc.fid = rwp.FWorkCenterID");
        sql2.append(" inner join t_bd_material ma");
        sql2.append(" on ma.fid = pben.cfmaterialid");
        sql2.append(" inner join t_bd_material pma");
        sql2.append(" on pma.fid = temp.fpmaterialid");
        sql2.append(" inner join t_mm_tracknumber bigtr on bigtr.fid = pben.CFSTraceID ");
        sql2.append(" inner join t_mm_tracknumber endtr on endtr.fid = pben.CFETraceid ");
        sql2.append(" inner join t_mm_tracknumber teptr on teptr.fid = '" + this.trackNumberId + "' ");
        sql2.append(" where 1=1");
        sql2.append(" and pb.FProjectID = '" + this.projectId + "'");
        sql2.append(" and teptr.fnumber  between bigtr.fnumber and endtr.fnumber ");
        sql2.append(" and temp.forgid<>'WITRVBDeSAStq/s6OqfSjcznrtQ='");
        sql2.append(" and temp.forgid in (select fsouid from " + adminTempTable + ")");
        if (this.flow != null) {
            sql2.append(" and temp.bomflow like '%" + this.flow.trim() + "%'");
        }
        sql2.append(" group by temp.fprojectid,temp.ftrackid,temp.forgid,ma.fid,temp.bomflow");
        DbUtil.execute((Context)ctx, (String)sql2.toString());
        if (this.materials != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FMaterialID not in (select fid from t_bd_material where fnumber in (" + EmmUtils.getSqlFromArray((String[])this.materials) + "))"));
        }
        if (this.sous != null) {
            DbUtil.execute((Context)ctx, (String)("delete from " + tempTableReport + " where FSouID not in (select fid from t_org_storage where fnumber in (" + EmmUtils.getSqlFromArray((String[])this.sous) + "))"));
        }
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " tmp set tmp.FPurOrgID=");
        sql.append(" (select MAX(fsce.CFPurOrgUnitID)");
        sql.append(" from  CT_ZJB_FlowSplitConfigEntry fsce ");
        sql.append(" where fsce.CFFlow=tmp.FBomFlow)");
        sql.append(" where exists (select 1 from CT_ZJB_FlowSplitConfigEntry fsce1 where fsce1.CFFlow=tmp.FBomFlow)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " tmp set (tmp.FPrice)=");
        sql.append(" (select round(nvl(fprice,0)/1.17,2) as FPrice");
        sql.append(" from t_bd_materialpurchasing en");
        sql.append(" where 1=1");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and en.forgunit=tmp.FPurOrgID");
        sql.append("  )");
        sql.append(" where exists (select 1");
        sql.append(" from t_bd_materialpurchasing en");
        sql.append(" where 1=1");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and en.forgunit=tmp.FPurOrgID");
        sql.append("  )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " tmp set (tmp.FPrice)=");
        sql.append(" (select round(nvl(fprice,0)/1.17,2) as FPrice");
        sql.append(" from t_bd_materialpurchasing en");
        sql.append(" where 1=1");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and en.forgunit='uHesH1pARsmCli2qcHmx4cznrtQ='");
        sql.append("  )");
        sql.append(" where exists (select 1");
        sql.append(" from t_bd_materialpurchasing en");
        sql.append(" where 1=1");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and en.forgunit='uHesH1pARsmCli2qcHmx4cznrtQ='");
        sql.append("  )");
        sql.append(" and tmp.FPurOrgID is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " set FAmount=round(fprice*FQty,2)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        int year = Integer.parseInt((pf + "").substring(0, 4));
        int period = Integer.parseInt((pf + "").substring(4, 6));
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " tmp set (tmp.FActualReqQty,tmp.FActualCost)=");
        sql.append(" (select sum(en.fqty),sum(en.factualcost)");
        sql.append(" from t_im_materialreqbillentry en");
        sql.append(" inner join t_im_materialreqbill b on en.fparentid=b.fid");
        sql.append(" inner join " + adminTempTable + " att on b.fadminorgunitid=att.fadminid");
        sql.append(" where 1=1");
        sql.append(" and b.fbasestatus=4");
        sql.append(" and en.fprojectid=tmp.FProjectID and en.ftracknumberid=tmp.FTrackNumberID");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and att.fsouid=tmp.FSouID");
        sql.append(" and en.fcompanyorgunitid='" + this.companyID + "')");
        sql.append(" where exists (select 1");
        sql.append(" from t_im_materialreqbillentry en");
        sql.append(" inner join t_im_materialreqbill b on en.fparentid=b.fid");
        sql.append(" inner join " + adminTempTable + " att on b.fadminorgunitid=att.fadminid");
        sql.append(" where 1=1");
        sql.append(" and b.fbasestatus>3");
        sql.append(" and en.fprojectid=tmp.FProjectID and en.ftracknumberid=tmp.FTrackNumberID");
        sql.append(" and en.fmaterialid=tmp.FMaterialID");
        sql.append(" and att.fsouid=tmp.FSouID");
        sql.append(" and en.fcompanyorgunitid='" + this.companyID + "' )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " set FActualPrice=round(FActualCost/FActualReqQty,4) where FActualReqQty>0");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " set FDiffForPrice=round(nvl(FPrice,0)-nvl(FActualPrice,0),2) where FActualReqQty>0");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " set FDiffForQty=round(nvl(fqty,0)-nvl(FActualReqQty,0),2)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ update " + tempTableReport + " set FEstimateAmount=round(nvl(FDiffForQty,0)*nvl(FPrice,0),2)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.dropTempTable(s, params, tblmmbom);
        this.dropTempTable(s, params, adminTempTable);
    }

    protected ReportTitles getReportTitles(String ctx, RptParams params) throws BaseException {
        ReportTitles title = new ReportTitles();
        title.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0076", (Locale)this.getContext().getLocale()) + ":" + this.periodNumberFrom);
        title.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0050", (Locale)this.getContext().getLocale()) + ":" + this.project + "        " + this.projectName);
        return title;
    }

    private String createTableSql() {
        StringBuffer bomsql = new StringBuffer();
        bomsql.append(" create table MMBOM( ");
        bomsql.append(" fmaterialid varchar(44),\r\n");
        bomsql.append(" fsourcebomid varchar(44),\r\n");
        bomsql.append(" fpbomid varchar(44),\r\n");
        bomsql.append(" fpbomorgid varchar(44),\r\n");
        bomsql.append(" fbomid varchar(44),\r\n");
        bomsql.append(" ftrackid varchar(44),\r\n");
        bomsql.append(" fprojectid varchar(44),\r\n");
        bomsql.append(" forgid varchar(44),\r\n");
        bomsql.append(" bomflow varchar(100),\r\n");
        bomsql.append(" fissign varchar(44),\r\n");
        bomsql.append(" fqty NUMERIC(21,8),\r\n");
        bomsql.append(" FPQty NUMERIC(21,8),\r\n");
        bomsql.append(" fpmaterialid varchar(44),\r\n");
        bomsql.append(" FSource varchar(100),\r\n");
        bomsql.append(" FMaterialProp varchar(100),\r\n");
        bomsql.append(" FProvideType varchar(100)\r\n");
        bomsql.append(" )");
        return bomsql.toString();
    }

    private String createTableSqlForAdminSou() {
        StringBuffer bomsql = new StringBuffer();
        bomsql.append(" create table MMBOM( ");
        bomsql.append(" fadminid varchar(44),\r\n");
        bomsql.append(" fsouid varchar(44)\r\n");
        bomsql.append(" )");
        return bomsql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        IRowSet rs;
        String[] tmp;
        if (params.getObject("isconnect") != null) {
            params = (RptParams)params.getObject("totalfilter");
        }
        this.companyID = params.getObject("company") != null ? ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() : null;
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.project = tmp[0];
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fid,fname_l2 as fname from t_mm_project where fnumber='" + this.project + "'"));
            if (rs.next()) {
                this.projectId = rs.getString("fid");
                this.projectName = rs.getString("fname");
            }
        } else {
            this.project = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumber = tmp[0];
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fid from t_mm_tracknumber where fnumber='" + this.trackNumber + "'"));
            if (rs.next()) {
                this.trackNumberId = rs.getString("fid");
            }
        } else {
            this.trackNumber = null;
        }
        this.periodNumberFrom = params.getObject("periodFrom") != null ? params.getObject("periodFrom").toString() : null;
        this.periodNumberTo = params.getObject("periodTo") != null ? params.getObject("periodTo").toString() : null;
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
        if (params.getObject("storageOrgUnit") != null) {
            tmp = ((String)params.getObject("storageOrgUnit")).split(";");
            this.sous = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                this.sous[i] = tmp[i].trim();
            }
        } else {
            this.sous = null;
        }
        this.flow = params.getObject("flow") != null ? params.getObject("flow").toString() : null;
        this.price1 = params.getObject("price1") != null ? params.getObject("price1").toString() : null;
        this.price2 = params.getObject("price2") != null ? params.getObject("price2").toString() : null;
        this.amount1 = params.getObject("amount1") != null ? params.getObject("amount1").toString() : null;
        this.amount2 = params.getObject("amount2") != null ? params.getObject("amount2").toString() : null;
        this.isEstimateOperation = new Boolean((String)params.getObject("isEstimateOperation"));
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FTrackNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0052", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FStorageOrgUnit", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0086", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FStorageOrgUnitName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0087", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FMaterialNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0068", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FMaterialName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0069", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FModel", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0088", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FUnit", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0089", (Locale)this.getContext().getLocale()));
        ReportHeader t = reportHeader.addChild("FQty", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0070", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FPrice", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0090", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FAmount", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0091", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FBuJianType", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0092", (Locale)this.getContext().getLocale()));
        t = reportHeader.addChild("FFlow", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0093", (Locale)this.getContext().getLocale()));
        t = reportHeader.addChild("FActualReqQty", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0094", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FActualPrice", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0095", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FActualCost", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0071", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FDiffForPrice", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0096", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FDiffForQty", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0097", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FEstimateAmount", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0098", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = reportHeader.addChild("FPeriod", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0076", (Locale)this.getContext().getLocale()));
        t.setVisible(false);
        t = reportHeader.addChild("FCompanyID", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0046", (Locale)this.getContext().getLocale()));
        t.setVisible(false);
        t = reportHeader.addChild("FTableName", "FTableName");
        t.setVisible(false);
        t = reportHeader.addChild("FIsMaterial", "FIsMaterial");
        t.setVisible(false);
        return reportHeader;
    }

    protected RptParams buildFilterFromConnect(RptParams filter, RptParams totalFilter, HashMap rowData) throws BaseException {
        return filter;
    }
}

