/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.industry.emm.common.EmmUtils;
import com.kingdee.eas.industry.emm.lcm.util.LcmUtils;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectProductActualHourRptServer
extends ReportServerBase {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResource";
    private String Total_AmountRow = EASResource.getString((String)this.RESURL, (String)"Total_AmountRow", (Locale)this.getContext().getLocale());
    private String Total_Amount = EASResource.getString((String)this.RESURL, (String)"Total_Amount");
    private String XJ = EASResource.getString((String)this.RESURL, (String)"XJ");
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private String[] costObjects;
    private String[] costCenters;
    private String[] projects;
    private String[] trackNumbers;
    private String[] materials;
    private String periodNumberFrom;
    private String periodNumberTo;
    private String companyID;
    private static List<String[]> costItemSql;
    private boolean isGatherCostCenter;
    private boolean isGatherProject;
    private boolean isGatherTrack;
    private boolean isTotalOnly;
    private boolean isTotalTop;
    private List costCenterList;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
    private boolean isDataTable = false;
    private String topProduct;
    private boolean isOnlyBenBu = false;

    public boolean isContainBenBu(String[] ccs) {
        if (ccs != null) {
            for (int i = 0; i < ccs.length; ++i) {
                if (!"1.16.01".equals(ccs[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected IRowSet getReportData(String s, RptParams rptparams) throws Exception {
        int i;
        int i2;
        String ccNumberStr;
        this.setSort(new Boolean(true));
        this.setSortClickType(new Integer(2));
        this.initRptParams(rptparams);
        if (this.periodNumberFrom == null || this.costCenters == null) {
            return null;
        }
        if (this.costCenters.length > 30) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0176")));
        }
        this.isOnlyBenBu = this.costCenters != null && this.costCenters.length == 1 && "1.16.01".equals(this.costCenters[0]);
        String alltempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.createTempTable());
        this.topProduct = TempTablePool.getInstance((Context)this.getContext()).createTempTable(LcmUtils.getCreateTableForTopProduct());
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/  insert into " + this.topProduct + " ");
        sql.append("  select en.fcostobjectid  ");
        sql.append("  from t_im_manufacturerecbillentry en ");
        sql.append("  inner join t_im_manufacturerecbill bill on en.fparentid=bill.fid");
        sql.append("  where  bill.fstorageorgunitid='tpyPIjQ0RCmSK9eQYTJBjsznrtQ='");
        sql.append("  and bill.fcostcenterorgunitid='xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
        sql.append("  and bill.fbasestatus=4");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        this.insertDataToTB(alltempTableName);
        PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)this.companyID);
        if (!this.isDataTable) {
            DbUtil.execute((Context)this.getContext(), (String)("update " + alltempTableName + " set FWG=FQC+FFS where FIsFinished=1"));
            DbUtil.execute((Context)this.getContext(), (String)("update " + alltempTableName + " set FQM=FQC+FFS-FWG "));
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fnumber as fnumber,fname_l2 as fname from t_org_costcenter where fnumber in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ") order by fnumber"));
        this.costCenterList = new ArrayList();
        while (rs.next()) {
            String name = rs.getString("fname");
            String number = rs.getString("fnumber");
            this.costCenterList.add(number);
        }
        String tmp2 = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.resultTmp_CreateSql());
        ArrayList<String> sqls = new ArrayList<String>();
        for (int i3 = 0; i3 < this.costCenterList.size(); ++i3) {
            String ccNumber = (String)this.costCenterList.get(i3);
            ccNumberStr = ccNumber.replaceAll("\\.", "_");
            sql = new StringBuffer();
            sql.append("/*dialect*/ insert into " + tmp2 + " (fprojectid,ftracknumberid,fcostobjectid,FType,FQC_" + ccNumberStr + ",FFS_" + ccNumberStr + ",FWG_" + ccNumberStr + ",FQM_" + ccNumberStr + ")");
            sql.append(" select pj.fid,tk.fid,co.fid,lpt.fname_l2,ROUND(nvl(FQC,0)/3600,2),ROUND(nvl(FFS,0)/3600,2),ROUND(nvl(FWG,0)/3600,2),ROUND(nvl(FQM,0)/3600,2)");
            sql.append(" from " + alltempTableName + " t ");
            sql.append(" inner join t_bd_costobject co on t.fcostobjectid=co.fid");
            sql.append(" inner join t_org_costcenter cc on t.fcostcenterid=cc.fid");
            sql.append(" left join t_mm_project pj on pj.fid=t.fprojectid");
            sql.append(" left join t_mm_trackNumber tk on tk.fid=t.ftrackNumberid");
            sql.append(" left join ct_pcm_projecttypes lpt on lpt.fid=pj.cfprojecttypesid");
            sql.append(" where cc.fnumber='" + ccNumber + "'");
            sqls.add(sql.toString());
        }
        EmmUtils.executeBatchUpdate((Context)this.getContext(), sqls);
        String resultTmp = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.resultTmp_CreateSql());
        sql = new StringBuffer();
        sql.append("/*dialect*/ insert into " + resultTmp + "");
        sql.append(" select fcostobjectid,fprojectid,ftracknumberid,FType,");
        for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
            sql.append("SUM(nvl(FQC_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("0,");
        for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
            sql.append("SUM(nvl(FFS_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("0,");
        for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
            sql.append("SUM(nvl(FWG_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("0,");
        for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
            sql.append("SUM(nvl(FQM_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("0,0,0");
        sql.append(" from " + tmp2 + " group by fprojectid,ftracknumberid,fcostobjectid,FType");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        if (this.isGatherCostCenter || this.isGatherProject || this.isGatherTrack) {
            sql.setLength(0);
            sql.append("/*dialect*/ insert into " + resultTmp + " ");
            sql.append(" select null,");
            if (this.isGatherProject) {
                sql.append("FProjectID,");
            } else {
                sql.append("null,");
            }
            if (this.isGatherTrack) {
                sql.append("FTrackNumberID,");
            } else {
                sql.append("null,");
            }
            sql.append("null,");
            for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
                sql.append("SUM(nvl(FQC_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
            }
            sql.append("0,");
            for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
                sql.append("SUM(nvl(FFS_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
            }
            sql.append("0,");
            for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
                sql.append("SUM(nvl(FWG_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
            }
            sql.append("0,");
            for (i2 = 0; i2 < this.costCenterList.size(); ++i2) {
                sql.append("SUM(nvl(FQM_" + this.costCenterList.get(i2).toString().replaceAll("\\.", "_") + ",0)),");
            }
            sql.append("0,1,0");
            sql.append(" from " + resultTmp);
            StringBuffer tmpStr = new StringBuffer();
            if (this.isGatherProject) {
                tmpStr.append("FProjectID,");
            }
            if (this.isGatherTrack) {
                tmpStr.append("FTrackNumberID,");
            }
            if (tmpStr.length() > 0) {
                sql.append(" group by ").append(tmpStr.toString().substring(0, tmpStr.length() - 1));
            }
            DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        }
        sql.setLength(0);
        sql.append("update " + resultTmp + " set FQC_XJ=");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            ccNumberStr = ((String)this.costCenterList.get(i)).replaceAll("\\.", "_");
            if (i != 0) {
                sql.append("+");
            }
            sql.append("FQC_" + ccNumberStr);
        }
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + resultTmp + " set FFS_XJ=");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            ccNumberStr = ((String)this.costCenterList.get(i)).replaceAll("\\.", "_");
            if (i != 0) {
                sql.append("+");
            }
            sql.append("FFS_" + ccNumberStr);
        }
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + resultTmp + " set FWG_XJ=");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            ccNumberStr = ((String)this.costCenterList.get(i)).replaceAll("\\.", "_");
            if (i != 0) {
                sql.append("+");
            }
            sql.append("FWG_" + ccNumberStr);
        }
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append("update " + resultTmp + " set FQM_XJ=");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            ccNumberStr = ((String)this.costCenterList.get(i)).replaceAll("\\.", "_");
            if (i != 0) {
                sql.append("+");
            }
            sql.append("FQM_" + ccNumberStr);
        }
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        DbUtil.execute((Context)this.getContext(), (String)("delete from " + resultTmp + " where FQC_XJ=0 and FFS_XJ=0 and FWG_XJ=0 and FQM_XJ=0"));
        sql.setLength(0);
        sql.append("/*dialect*/ insert into " + resultTmp + " t");
        sql.append(" select null,");
        sql.append("null,");
        sql.append("null,");
        sql.append("'Total_AmountRow',");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("SUM(nvl(FQC_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("sum(nvl(FQC_XJ,0)),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("SUM(nvl(FFS_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("sum(nvl(FFS_XJ,0)),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("SUM(nvl(FWG_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("sum(nvl(FWG_XJ,0)),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("SUM(nvl(FQM_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",0)),");
        }
        sql.append("sum(nvl(FQM_XJ,0)),1,1");
        sql.append(" from " + resultTmp);
        sql.append(" where FIsTotalRow=0");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
        sql.setLength(0);
        sql.append("/*dialect*/ select ");
        sql.append(this.periodNumberFrom + " as FPeriod,");
        sql.append(" pj.fnumber as FProjectNumber,");
        sql.append(" pj.fname_l2 as FProjectName,");
        sql.append(" tk.fnumber as FTrackNumber,");
        sql.append(" tk.fname_l2 as FTrackNumberName,");
        sql.append(" co.fnumber as FCostObjectNumber,");
        sql.append(" co.fname_l2 as FCostObjectName,");
        sql.append(" case when t.FIsAllTotalRow=1 then 'Total_Amount' when t.FIsTotalRow=1 then 'XJ' else to_char(lpt.fname_l2) end FType,");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("case when FQC_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + "=0 then '' else to_char(FQC_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",'fm999,999,999,999,990.00')  end as FQC_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",");
        }
        sql.append("case when FQC_XJ=0 then '' else to_char(FQC_XJ,'fm999,999,999,999,990.00') end as FQC_XJ,");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("case when FFS_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + "=0 then '' else to_char(FFS_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",'fm999,999,999,999,990.00') end as FFS_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",");
        }
        sql.append("case when FFS_XJ=0 then '' else to_char(FFS_XJ,'fm999,999,999,999,990.00') end as FFS_XJ,");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("case when FWG_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + "=0 then '' else to_char(FWG_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",'fm999,999,999,999,990.00') end as FWG_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",");
        }
        sql.append("case when FWG_XJ=0 then '' else to_char(FWG_XJ,'fm999,999,999,999,990.00') end as FWG_XJ,");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("case when FQM_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + "=0 then '' else to_char(FQM_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",'fm999,999,999,999,990.00') end as FQM_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + ",");
        }
        sql.append("case when FQM_XJ=0 then '' else to_char(FQM_XJ,'fm999,999,999,999,990.00') end as FQM_XJ");
        sql.append(" from " + resultTmp + " t");
        sql.append(" left join t_bd_costobject co on co.fid=t.fcostobjectid");
        sql.append(" left join t_mm_project pj on pj.fid=t.fprojectid");
        sql.append(" left join ct_pcm_projecttypes lpt on lpt.fid=pj.cfprojecttypesid");
        sql.append(" left join t_mm_tracknumber tk on tk.fid=t.ftracknumberid");
        sql.append(" where 1=1");
        if (this.isTotalOnly) {
            sql.append(" and t.FIsTotalRow=1");
        }
        sql.append(" order by t.FIsAllTotalRow desc,");
        if (this.isGatherProject && this.isGatherTrack) {
            sql.append(" pj.fnumber,");
            sql.append(" tk.fnumber,");
            sql.append(" t.FIsTotalRow,");
            sql.append(" co.fnumber");
        } else if (this.isGatherProject) {
            sql.append(" pj.fnumber,");
            sql.append(" t.FIsTotalRow,");
            sql.append(" tk.fnumber,");
            sql.append(" co.fnumber");
        } else if (this.isGatherTrack) {
            sql.append(" tk.fnumber,");
            sql.append(" pj.fnumber,");
            sql.append(" t.FIsTotalRow,");
            sql.append(" co.fnumber");
        } else {
            sql.append(" pj.fnumber,");
            sql.append(" tk.fnumber,");
            sql.append(" co.fnumber");
        }
        IRowSet set = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        this.dropTempTable(s, rptparams, alltempTableName);
        this.dropTempTable(s, rptparams, tmp2);
        this.dropTempTable(s, rptparams, resultTmp);
        return set;
    }

    private String resultTmp_CreateSql() {
        int i;
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableX(");
        sql.append("FCostObjectID varchar(44),");
        sql.append("FProjectID varchar(44),");
        sql.append("FTrackNumberID varchar(44),");
        sql.append("FType  varchar(255),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("FQC_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + " NUMERIC(28,14),");
        }
        sql.append("FQC_XJ NUMERIC(28,14),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("FFS_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + " NUMERIC(28,14),");
        }
        sql.append("FFS_XJ NUMERIC(28,14),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("FWG_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + " NUMERIC(28,14),");
        }
        sql.append("FWG_XJ NUMERIC(28,14),");
        for (i = 0; i < this.costCenterList.size(); ++i) {
            sql.append("FQM_" + this.costCenterList.get(i).toString().replaceAll("\\.", "_") + " NUMERIC(28,14),");
        }
        sql.append("FQM_XJ NUMERIC(28,14), ");
        sql.append("FIsTotalRow int not null default(0),");
        sql.append("FIsAllTotalRow int not null default(0)");
        sql.append(")");
        return sql.toString();
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableX(");
        sql.append("FProjectID varchar(44),");
        sql.append("FTrackNumberID varchar(44),");
        sql.append("FCostObjectID varchar(44),");
        sql.append("FCostCenterID varchar(44),");
        sql.append("FQC  NUMERIC(28,14),");
        sql.append("FFS NUMERIC(28,14),");
        sql.append("FWG NUMERIC(28,14),");
        sql.append("FQM NUMERIC(28,14),");
        sql.append("FIsFinished int default 0");
        sql.append(")");
        return sql.toString();
    }

    private void initRptParams(RptParams params) throws BOSException, SQLException {
        int i;
        String[] tmp;
        this.companyID = params.getObject("company") != null ? ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() : null;
        if (params.getObject("costCenter") != null) {
            tmp = ((String)params.getObject("costCenter")).split(";");
            this.costCenters = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.costCenters[i] = tmp[i].trim();
            }
        } else {
            this.costCenters = null;
        }
        if (params.getObject("costObject") != null) {
            tmp = ((String)params.getObject("costObject")).split(";");
            this.costObjects = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.costObjects[i] = tmp[i].trim();
            }
        } else {
            this.costObjects = null;
        }
        if (params.getObject("project") != null) {
            tmp = ((String)params.getObject("project")).split(";");
            this.projects = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.projects[i] = tmp[i].trim();
            }
        } else {
            this.projects = null;
        }
        if (params.getObject("trackNumber") != null) {
            tmp = ((String)params.getObject("trackNumber")).split(";");
            this.trackNumbers = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.trackNumbers[i] = tmp[i].trim();
            }
        } else {
            this.trackNumbers = null;
        }
        if (params.getObject("material") != null) {
            tmp = ((String)params.getObject("material")).split(";");
            this.materials = new String[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                this.materials[i] = tmp[i].trim();
            }
        } else {
            this.materials = null;
        }
        this.periodNumberFrom = params.getObject("periodFrom") != null ? params.getObject("periodFrom").toString() : null;
        this.periodNumberTo = params.getObject("periodTo") != null ? params.getObject("periodTo").toString() : null;
        this.isGatherCostCenter = new Boolean((String)params.getObject("isGatherCostCenter"));
        this.isGatherProject = new Boolean((String)params.getObject("isGatherProject"));
        this.isGatherTrack = new Boolean((String)params.getObject("isGatherTrack"));
        this.isTotalOnly = new Boolean((String)params.getObject("isTotalOnly"));
        this.isTotalTop = new Boolean((String)params.getObject("isTotalTop"));
    }

    private void insertDataToTB(String tempTableName) throws EASBizException, BOSException, SQLException {
        int pf;
        int pt = pf = Integer.parseInt(this.periodNumberFrom);
        if (this.periodNumberTo != null) {
            pt = Integer.parseInt(this.periodNumberTo);
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("/*dialect*/ insert into ");
        sql.append(tempTableName);
        sql.append(" select fprojectid,ftracknumberid,fcostobjectid,fcostcenterid,sum(FQC),sum(FFS),sum(FWG),sum(FQM),FIsFinished from (");
        PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)this.companyID);
        String dateTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)this.companyID, (String)"T_NCM_AllDataByCostObj", (int)pf, (int)pt);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select count(1) as count from " + dateTable));
        boolean bl = this.isDataTable = currPeriod.getNumber() != Integer.parseInt(this.periodNumberFrom);
        if (!this.isDataTable) {
            while (rs.next()) {
                int count = rs.getInt("count");
                if (count <= 0) continue;
                this.isDataTable = true;
            }
        }
        if (!this.isDataTable) {
            sql.append(" select p.fid as fprojectid,tk.fid as ftracknumberid,en.fcostobjectid as fcostobjectid,bill.fcostcenterid as fcostcenterid,0 as FQC,en.fhoursecond as FFS,0 as FWG,0 as FQM,co.fisfinished as FIsFinished");
            sql.append(" from t_ncm_actualhour bill");
            sql.append(" inner join t_ncm_actualhourentry en on en.fparentid=bill.fid");
            sql.append(" inner join t_bd_period period on period.fnumber='" + this.periodNumberFrom + "'");
            sql.append(" inner join t_bd_costobject co on en.fcostobjectid=co.fid");
            sql.append(" left join t_mm_project p on p.fid=co.fprojectid");
            sql.append(" left join t_mm_trackNumber tk on tk.fid=co.ftrackid");
            sql.append(" inner join t_org_costcenter cc on cc.fid=bill.fcostcenterid");
            sql.append(" where bill.fbillstatus=4");
            sql.append(" and bill.fbizdate>=period.fbegindate");
            sql.append(" and bill.fbizdate<=period.fenddate");
            sql.append(" and bill.fcompanyorg='" + this.companyID + "'");
            sql.append(" and cc.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ")");
            if (this.costObjects != null && this.costObjects.length > 0) {
                sql.append(" and co.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costObjects) + ")");
            }
            if (this.projects != null && this.projects.length > 0) {
                sql.append(" and p.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
            }
            if (this.trackNumbers != null && this.trackNumbers.length > 0) {
                sql.append(" and tk.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.trackNumbers) + ")");
            }
            if (!this.isOnlyBenBu) {
                sql.append(" and cc.fid <>'xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
            }
        } else {
            sql.append(" select p.fid as fprojectid,tk.fid as ftracknumberid,bill.fcostobjectid as fcostobjectid,bill.fcostcenterid as fcostcenterid,0 as FQC,bill.finputhour*3600 as FFS,0 as FWG,0 as FQM,co.fisfinished as FIsFinished");
            sql.append(" from " + dateTable + " bill");
            sql.append(" inner join t_bd_period period on period.fid=bill.fcalculateperiodid");
            sql.append(" inner join t_bd_costobject co on bill.fcostobjectid=co.fid");
            sql.append(" left join t_mm_project p on p.fid=co.fprojectid");
            sql.append(" left join t_mm_trackNumber tk on tk.fid=co.ftrackid");
            sql.append(" inner join t_org_costcenter cc on cc.fid=bill.fcostcenterid");
            sql.append(" where ");
            sql.append(" period.fnumber=" + this.periodNumberFrom);
            sql.append(" and bill.fcompanyid='" + this.companyID + "'");
            sql.append(" and cc.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ")");
            if (this.costObjects != null && this.costObjects.length > 0) {
                sql.append(" and co.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costObjects) + ")");
            }
            if (this.projects != null && this.projects.length > 0) {
                sql.append(" and p.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
            }
            if (this.trackNumbers != null && this.trackNumbers.length > 0) {
                sql.append(" and tk.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.trackNumbers) + ")");
            }
            if (!this.isOnlyBenBu) {
                sql.append(" and cc.fid <>'xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
            }
        }
        sql.append(" union all");
        dateTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)this.companyID, (String)"T_NCM_Balance", (int)pf, (int)pt);
        sql.append(" select p.fid as fprojectid,tk.fid as ftracknumberid,bill.fcostobjectid as fcostobjectid,bill.fcostcenterid as fcostcenterid,bill.fbopwiphour*3600 as FQC,0 as FFS,0 as FWG,0 as FQM,co.fisfinished as FIsFinished");
        sql.append(" from " + dateTable + " bill");
        sql.append(" inner join t_bd_period period on period.fid=bill.fcalculateperiodid");
        sql.append(" inner join t_bd_costobject co on bill.fcostobjectid=co.fid");
        sql.append(" left join t_mm_project p on p.fid=co.fprojectid");
        sql.append(" left join t_mm_trackNumber tk on tk.fid=co.ftrackid");
        sql.append(" inner join t_org_costcenter cc on cc.fid=bill.fcostcenterid");
        sql.append(" where ");
        sql.append(" period.fnumber=" + this.periodNumberFrom);
        sql.append(" and bill.fcompanyorg='" + this.companyID + "'");
        sql.append(" and cc.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ")");
        if (this.costObjects != null && this.costObjects.length > 0) {
            sql.append(" and co.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costObjects) + ")");
        }
        if (this.projects != null && this.projects.length > 0) {
            sql.append(" and p.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
        }
        if (this.trackNumbers != null && this.trackNumbers.length > 0) {
            sql.append(" and tk.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.trackNumbers) + ")");
        }
        if (!this.isOnlyBenBu) {
            sql.append(" and cc.fid <>'xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
        }
        if (this.isDataTable) {
            sql.append(" union all");
            dateTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)this.companyID, (String)"T_NCM_AllDataByCostObj", (int)pf, (int)pt);
            sql.append(" select p.fid as fprojectid,tk.fid as ftracknumberid,bill.fcostobjectid as fcostobjectid,bill.fcostcenterid as fcostcenterid,0 as FQC,0 as FFS,bill.ffinishedhour*3600 as FWG,0 as FQM,co.fisfinished as FIsFinished");
            sql.append(" from " + dateTable + " bill");
            sql.append(" inner join t_bd_period period on period.fid=bill.fcalculateperiodid");
            sql.append(" inner join t_bd_costobject co on bill.fcostobjectid=co.fid");
            sql.append(" left join t_mm_project p on p.fid=co.fprojectid");
            sql.append(" left join t_mm_trackNumber tk on tk.fid=co.ftrackid");
            sql.append(" inner join t_org_costcenter cc on cc.fid=bill.fcostcenterid");
            sql.append(" where ");
            sql.append(" period.fnumber=" + this.periodNumberFrom);
            sql.append(" and bill.fcompanyid='" + this.companyID + "'");
            sql.append(" and cc.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ")");
            if (this.costObjects != null && this.costObjects.length > 0) {
                sql.append(" and co.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costObjects) + ")");
            }
            if (this.projects != null && this.projects.length > 0) {
                sql.append(" and p.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
            }
            if (this.trackNumbers != null && this.trackNumbers.length > 0) {
                sql.append(" and tk.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.trackNumbers) + ")");
            }
            if (!this.isOnlyBenBu) {
                sql.append(" and cc.fid <>'xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
            }
        }
        if (this.isDataTable) {
            sql.append(" union all");
            dateTable = NCMDynamicTableManager.getPhysicalTblNameForReport((Context)this.getContext(), (String)this.companyID, (String)"T_NCM_AllDataByCostObj", (int)pf, (int)pt);
            sql.append(" select p.fid as fprojectid,tk.fid as ftracknumberid,bill.fcostobjectid as fcostobjectid,bill.fcostcenterid as fcostcenterid,0 as FQC,0 as FFS,0 as FWG,bill.feopwiphour*3600 as FQM,co.fisfinished as FIsFinished");
            sql.append(" from " + dateTable + " bill");
            sql.append(" inner join t_bd_period period on period.fid=bill.fcalculateperiodid");
            sql.append(" inner join t_bd_costobject co on bill.fcostobjectid=co.fid");
            sql.append(" left join t_mm_project p on p.fid=co.fprojectid");
            sql.append(" left join t_mm_trackNumber tk on tk.fid=co.ftrackid");
            sql.append(" inner join t_org_costcenter cc on cc.fid=bill.fcostcenterid");
            sql.append(" where ");
            sql.append(" period.fnumber=" + this.periodNumberFrom);
            sql.append(" and bill.fcompanyid='" + this.companyID + "'");
            sql.append(" and cc.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ")");
            if (this.costObjects != null && this.costObjects.length > 0) {
                sql.append(" and co.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.costObjects) + ")");
            }
            if (this.projects != null && this.projects.length > 0) {
                sql.append(" and p.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.projects) + ")");
            }
            if (this.trackNumbers != null && this.trackNumbers.length > 0) {
                sql.append(" and tk.fnumber  in (" + EmmUtils.getSqlFromArray((String[])this.trackNumbers) + ")");
            }
            if (!this.isOnlyBenBu) {
                sql.append(" and cc.fid <>'xaHWDgFGQhK2gFwbW1oQxsznrtQ='");
            }
        }
        sql.append(" )  t group by  fprojectid,ftracknumberid,fcostobjectid,fcostcenterid,FIsFinished");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
    }

    protected ReportTitles getReportTitles(String s, RptParams rptparams) throws BaseException {
        ReportTitles title = new ReportTitles();
        try {
            int i;
            StringBuffer tmp;
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fname_l2 as fname from t_org_company where fid='" + this.companyID + "'"));
            rs.next();
            String companyName = rs.getString("fname");
            title.AddTitle(0, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0046", (Locale)this.getContext().getLocale()) + ":" + companyName);
            title.AddTitle(1, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0047", (Locale)this.getContext().getLocale()) + ":" + this.periodNumberFrom);
            if (this.costCenters == null || this.costCenters.length == 0) {
                title.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0048", (Locale)this.getContext().getLocale()));
            } else {
                tmp = new StringBuffer();
                for (i = 0; i < this.costCenters.length; ++i) {
                    if (i != 0) {
                        tmp.append(",");
                    }
                    tmp.append(this.costCenters[i]);
                }
                title.AddTitle(2, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0040", (Locale)this.getContext().getLocale()) + "\uff1a" + tmp.toString());
            }
            if (this.projects == null || this.projects.length == 0) {
                title.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0049", (Locale)this.getContext().getLocale()));
            } else {
                tmp = new StringBuffer();
                for (i = 0; i < this.projects.length; ++i) {
                    if (i != 0) {
                        tmp.append(",");
                    }
                    tmp.append(this.projects[i]);
                }
                title.AddTitle(3, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0050", (Locale)this.getContext().getLocale()) + "\uff1a" + tmp.toString());
            }
            if (this.trackNumbers == null || this.trackNumbers.length == 0) {
                title.AddTitle(4, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0051", (Locale)this.getContext().getLocale()));
            } else {
                tmp = new StringBuffer();
                for (i = 0; i < this.trackNumbers.length; ++i) {
                    if (i != 0) {
                        tmp.append(",");
                    }
                    tmp.append(this.trackNumbers[i]);
                }
                title.AddTitle(4, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0052", (Locale)this.getContext().getLocale()) + "\uff1a" + tmp.toString());
            }
            if (this.costObjects == null || this.costObjects.length == 0) {
                title.AddTitle(5, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0053", (Locale)this.getContext().getLocale()));
            } else {
                tmp = new StringBuffer();
                for (i = 0; i < this.costObjects.length; ++i) {
                    if (i != 0) {
                        tmp.append(",");
                    }
                    tmp.append(this.costObjects[i]);
                }
                title.AddTitle(5, EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0054", (Locale)this.getContext().getLocale()) + "\uff1a" + tmp.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return title;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams rptparams) throws Exception {
        this.initRptParams(rptparams);
        boolean isAll = !this.isGatherProject && !this.isGatherTrack || this.isTotalOnly;
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FPeriod", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0177", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FProjectNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0108", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FProjectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0178", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FTrackNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0179", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FTrackNumberName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0180", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FCostObjectNumber", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0066", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FCostObjectName", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0067", (Locale)this.getContext().getLocale()));
        reportHeader.addChild("FType", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0181", (Locale)this.getContext().getLocale()));
        if (this.periodNumberFrom == null || this.costCenters == null) {
            return null;
        }
        if (this.costCenters.length > 30) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0176", (Locale)this.getContext().getLocale())));
        }
        ReportHeader rh1 = reportHeader.addChild("FQiChu", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0182", (Locale)this.getContext().getLocale()));
        ReportHeader rh2 = reportHeader.addChild("FFaSheng", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0183", (Locale)this.getContext().getLocale()));
        ReportHeader rh3 = reportHeader.addChild("FWanGong", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0184", (Locale)this.getContext().getLocale()));
        ReportHeader rh4 = reportHeader.addChild("FQiMo", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0185", (Locale)this.getContext().getLocale()));
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("select fnumber as fnumber,fname_l2 as fname from t_org_costcenter where fnumber in (" + EmmUtils.getSqlFromArray((String[])this.costCenters) + ") order by fnumber"));
        while (rs.next()) {
            String name = rs.getString("fname");
            String number = rs.getString("fnumber");
            ReportHeader t = rh1.addChild("FQC_" + number.toUpperCase().replaceAll("\\.", "_"), name).setAlign(1);
            t.setAlign(3);
            t = rh2.addChild("FFS_" + number.toUpperCase().replaceAll("\\.", "_"), name).setAlign(1);
            t.setAlign(3);
            t = rh3.addChild("FWG_" + number.toUpperCase().replaceAll("\\.", "_"), name).setAlign(1);
            t.setAlign(3);
            t = rh4.addChild("FQM_" + number.toUpperCase().replaceAll("\\.", "_"), name).setAlign(1);
            t.setAlign(3);
        }
        ReportHeader t = rh1.addChild("FQC_XJ", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0157", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = rh2.addChild("FFS_XJ", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0157", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = rh3.addChild("FWG_XJ", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0157", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        t = rh4.addChild("FQM_XJ", EASResource.getString((String)"com.kingdee.eas.industry.emm.lcm.PCLCMResource", (String)"0EMMPCLCM-0157", (Locale)this.getContext().getLocale()));
        t.setAlign(3);
        return reportHeader;
    }
}

