/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.lcm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class LcmUtils {
    public static final String PROJECTCOST_HIS_TABLENAME = "CT_LCM_PROJECTCOSTHIS";
    public static final String PROJECTCOST_NOW_TABLENAME = "CT_LCM_PROJECTCOSTNOW";
    public static final String PROJECTCOST_HIS_AH_TABLENAME = "CT_LCM_PROJECTCOSTAHHIS";
    public static final String PROJECTCOST_NOW_AH_TABLENAME = "CT_LCM_PROJECTCOSTAHNOW";
    public static final String PROJECTCOST_MANU_TABLENAME = "CT_LCM_PROJECTCOSTMANU";
    public static String CETABLENAME = "T_NCM_CE";

    public static String[] dealPeriod(PeriodInfo period) {
        Calendar ca = Calendar.getInstance();
        String bdStr = null;
        String edStr = null;
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (period.getEndDate() != null) {
            ca.setTime(period.getEndDate());
            ca.set(11, 23);
            ca.set(12, 59);
            ca.set(13, 59);
            edStr = sf.format(ca.getTime());
        }
        if (period.getBeginDate() != null) {
            bdStr = sf.format(period.getBeginDate());
        }
        return new String[]{bdStr, edStr};
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getCreateTableForTopProduct() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table XXXXX (");
        sql.append("fcostobjectid varchar(44)");
        sql.append(")");
        return sql.toString();
    }

    public static String getNowCostEstimationName(Context ctx, String companyID, int period) throws BOSException, SQLException {
        String tableName;
        boolean isExists;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fnumber from t_org_company where fid='" + companyID + "'"));
        String companyNumber = null;
        if (rs.next()) {
            companyNumber = rs.getString("fnumber");
        }
        if (!(isExists = LcmUtils.isExistsTable(ctx, tableName = CETABLENAME + "_" + companyNumber.replaceAll("\\.", "_") + "_" + period))) {
            String sql = LcmUtils.createCETableSql(tableName);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FProjectID)"));
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FTrackNumberID)"));
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FCompanyID)"));
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FPeriod)"));
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FMaterialID)"));
            DbUtil.execute((Context)ctx, (String)("CREATE INDEX " + LcmUtils.createIndexName() + " ON " + tableName + " (FCompanyID,FPeriod,FProjectID,FTrackNumberID,FSouID,FBomFlow,FWorkCenterID,FMaterialID)"));
        }
        return tableName;
    }

    public static boolean getNowCostEstimationNameIsExists(Context ctx, String companyID, int period) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fnumber from t_org_company where fid='" + companyID + "'"));
        String companyNumber = null;
        if (rs.next()) {
            companyNumber = rs.getString("fnumber");
        }
        String tableName = CETABLENAME + "_" + companyNumber.replaceAll("\\.", "_") + "_" + period;
        boolean isExists = LcmUtils.isExistsTable(ctx, tableName);
        return isExists;
    }

    public static String createCETableSql(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tableName + " (");
        sql.append(" FProjectID VARCHAR(44),\r\n");
        sql.append(" FTrackNumberID VARCHAR(44),\r\n");
        sql.append(" FSouID VARCHAR(44),\r\n");
        sql.append(" FBomFlow varchar(100),\r\n");
        sql.append(" FWorkCenterID varchar(100),\r\n");
        sql.append(" FMaterialID varchar(100),\r\n");
        sql.append(" FQty NUMERIC(21,8),\r\n");
        sql.append(" FPrice NUMERIC(21,8),\r\n");
        sql.append(" FAmount NUMERIC(21,8),\r\n");
        sql.append(" FActualReqQty NUMERIC(21,8),\r\n");
        sql.append(" FActualPrice NUMERIC(21,8),\r\n");
        sql.append(" FActualCost NUMERIC(21,8),\r\n");
        sql.append(" FDiffForPrice NUMERIC(21,8),\r\n");
        sql.append(" FDiffForQty NUMERIC(21,8),\r\n");
        sql.append(" FEstimateAmount NUMERIC(21,8),\r\n");
        sql.append(" FPeriod int,\r\n");
        sql.append(" FCompanyID varchar(44),\r\n");
        sql.append(" FPurOrgID varchar(44)\r\n");
        sql.append(" )");
        return sql.toString();
    }

    private static boolean isExistsTable(Context ctx, String tablename) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select 1 from KSQL_USERTABLES WHERE KSQL_TABNAME='" + tablename + "'"));
        return rs.next();
    }

    private static String createIndexName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 17);
        return "I" + name;
    }

    public static List getHisCostEstimationName(Context ctx, String companyID, int period) throws BOSException, SQLException, EASBizException {
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo sPeriodInfo = ctrol.getStartPeriod(1001, companyID);
        int sPeriod = sPeriodInfo.getNumber();
        ArrayList<String> his = new ArrayList<String>();
        int i = period;
        while (i > sPeriod) {
            int y = Integer.parseInt((i + "").substring(0, 4));
            int m = Integer.parseInt((i + "").substring(4, 6));
            Calendar c = Calendar.getInstance();
            c.set(1, y);
            c.set(2, m - 1);
            y = c.get(1);
            m = c.get(2);
            if (m == 0) {
                m = 12;
                --y;
            }
            if (!LcmUtils.getNowCostEstimationNameIsExists(ctx, companyID, i = y * 100 + m)) continue;
            his.add(LcmUtils.getNowCostEstimationName(ctx, companyID, i));
        }
        return his;
    }

    public static String getHisCostEstimationDateTempTable(Context ctx, String companyID, int period, String whereSql) throws Exception {
        String tempTableReport = TempTablePool.getInstance((Context)ctx).createTempTable(LcmUtils.createCETableSql("XXX"));
        List ts = LcmUtils.getHisCostEstimationName(ctx, companyID, period);
        if (whereSql == null) {
            whereSql = "";
        }
        for (int i = 0; i < ts.size(); ++i) {
            String tb = (String)ts.get(i);
            DbUtil.execute((Context)ctx, (String)("/*dialect*/insert into " + tempTableReport + " select * from " + tb + " " + whereSql));
        }
        return tempTableReport;
    }

    public static final String createProjectCostTable(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tableName + " (");
        sql.append(" FCOMPANYID VARCHAR(44),\r\n");
        sql.append(" FPERIODID VARCHAR(44),\r\n");
        sql.append(" FPROJECTID varchar(44),\r\n");
        sql.append(" FPROJECTELEMENTID varchar(44),\r\n");
        sql.append(" FFinishedAmount NUMERIC(21,2),\r\n");
        sql.append(" FBeginAmount NUMERIC(21,2),\r\n");
        sql.append(" FHappenAmount NUMERIC(21,2),\r\n");
        sql.append(" FEndAmount NUMERIC(21,2)\r\n");
        sql.append(" )");
        return sql.toString();
    }

    public static final String createProjectCostTableForAH(String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tableName + " (");
        sql.append(" FCOMPANYID VARCHAR(44),\r\n");
        sql.append(" FPERIODID VARCHAR(44),\r\n");
        sql.append(" FPROJECTID varchar(44),\r\n");
        sql.append(" FFinishedAmount NUMERIC(21,8),\r\n");
        sql.append(" FBeginAmount NUMERIC(21,8),\r\n");
        sql.append(" FHappenAmount NUMERIC(21,8),\r\n");
        sql.append(" FEndAmount NUMERIC(21,8)\r\n");
        sql.append(" )");
        return sql.toString();
    }
}

