/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.ApproximateBillInfo;
import com.kingdee.eas.industry.emm.pcm.ApproximateBillLabourEntryInfo;
import com.kingdee.eas.industry.emm.pcm.app.AbstractApproximateBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.basedata.ExpenseTypeEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.RateStorageOfManufacturingUnitsCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.RateStorageOfManufacturingUnitsFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.RateStorageOfManufacturingUnitsInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.TimeTypeEnum;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ApproximateBillControllerBean
extends AbstractApproximateBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.ApproximateBillControllerBean");
    DateFormat sdf_YD = new SimpleDateFormat("yyyy-MM-dd");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApproximateBillInfo bill = (ApproximateBillInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ApproximateBillInfo info = (ApproximateBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fsrcobjectid from t_bot_relation r where r.fdestobjectid='" + pk.toString() + "' and fsrcentityId='699A93A4'"));
            if (rs.next()) {
                String estimateBillId = rs.getString("fsrcobjectid");
                DbUtil.execute((Context)ctx, (String)("update ct_pcm_estimatebill set cfprojectid='" + info.getProject().getId().toString() + "' where fid='" + estimateBillId + "'"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        super.handleAfterTransform(ctx, action, objectValue);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ApproximateBillInfo info = (ApproximateBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ApproximateBillInfo info = (ApproximateBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ApproximateBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0005", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getVehicleType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0007", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApproximateBillInfo eti = (ApproximateBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, ApproximateBillInfo eti) throws EASBizException {
        String error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
    }

    protected void materialEntryBeforeSave(Context ctx, ApproximateBillInfo model) throws BOSException, EASBizException {
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ApproximateBillInfo eti = (ApproximateBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        ApproximateBillInfo ebi = (ApproximateBillInfo)objectValue;
        if (ebi.getLabourEntry().size() == 1 && ebi.getLabourEntry().get(0).getExpenseDept() == null) {
            ebi.getLabourEntry().remove(ebi.getLabourEntry().get(0));
        }
        if (ebi.getOtherDeliverablesEntry().size() == 1 && ebi.getOtherDeliverablesEntry().get(0).getOtherDeliverable() == null) {
            ebi.getOtherDeliverablesEntry().remove(ebi.getOtherDeliverablesEntry().get(0));
        }
        if (ebi.getOtherExpenseEntry().size() == 1 && ebi.getOtherExpenseEntry().get(0).getCostItem() == null) {
            ebi.getOtherExpenseEntry().remove(ebi.getOtherExpenseEntry().get(0));
        }
        if (ebi.getProjectRiskEntrys().size() == 1 && ebi.getProjectRiskEntrys().get(0).getRiskItem() == null) {
            ebi.getProjectRiskEntrys().remove(ebi.getProjectRiskEntrys().get(0));
        }
        for (int j = 0; j < ebi.getLabourEntry().size(); ++j) {
            ApproximateBillLabourEntryInfo entryInfo = ebi.getLabourEntry().get(j);
            AdminOrgUnitInfo adminInfo = entryInfo.getExpenseDept();
            if (adminInfo == null) continue;
            BigDecimal whRate = BigDecimal.ZERO;
            BigDecimal manuRate = BigDecimal.ZERO;
            BigDecimal enRate = BigDecimal.ZERO;
            Date bizDate = null;
            String bizDateYPStr = null;
            String bizDateYStr = null;
            RateStorageOfManufacturingUnitsCollection rsColl = null;
            ExpenseTypeEnum etEnum = ExpenseTypeEnum.ESTIMATEBUDGET;
            if (ebi.getBizDate() != null) {
                bizDate = ebi.getBizDate();
                bizDateYPStr = this.sdf_YD.format(bizDate);
                bizDateYStr = bizDateYPStr.substring(0, 4);
                bizDateYPStr = bizDateYPStr.substring(0, 7);
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" where units.id='" + adminInfo.getId().toString() + "' ");
            sql.append(" and expenseType=" + etEnum.getValue() + "");
            sql.append(" and status=2");
            sql.append(" order by timeType,time  ");
            rsColl = RateStorageOfManufacturingUnitsFactory.getLocalInstance(ctx).getRateStorageOfManufacturingUnitsCollection(sql.toString());
            for (int i = 0; i < rsColl.size(); ++i) {
                RateStorageOfManufacturingUnitsInfo rsInfo = rsColl.get(i);
                if (bizDateYPStr != null && !"".equals(bizDateYPStr) && rsInfo.getTime() != null && !rsInfo.getTime().equals(bizDateYPStr) && rsInfo.getTimeType().equals((Object)TimeTypeEnum.TYPEOFMONTH) || bizDateYStr != null && !"".equals(bizDateYStr) && rsInfo.getTime() != null && !rsInfo.getTime().equals(bizDateYStr) && rsInfo.getTimeType().equals((Object)TimeTypeEnum.TYPEOFYEAR)) continue;
                if (rsInfo.getRateType().getValue() == 1) {
                    whRate = rsInfo.getGeneralRate();
                }
                if (rsInfo.getRateType().getValue() == 3) {
                    manuRate = rsInfo.getGeneralRate();
                }
                if (rsInfo.getRateType().getValue() != 2) continue;
                enRate = rsInfo.getGeneralRate();
            }
            entryInfo.setWhRate(whRate);
            entryInfo.setWhRateEnd(whRate);
            entryInfo.setManuExpenseRate(manuRate);
            entryInfo.setManuExpenseRateEnd(manuRate);
            entryInfo.setEngExpenseRate(enRate);
            entryInfo.setEngExpenseRateEnd(enRate);
        }
    }

    protected void _handleAfterTransform(Context context, String s, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this._handleAfterTransform(context, s, coll.getObject(i));
            }
        }
    }
}

