/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.BudgetBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.BudgetBillInfo;
import com.kingdee.eas.industry.emm.pcm.PurchaseAttrEnum;
import com.kingdee.eas.industry.emm.pcm.app.AbstractBudgetBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.app.ProjectTargetCostBillBomTree;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetBillControllerBean
extends AbstractBudgetBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.BudgetBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BudgetBillInfo bill = (BudgetBillInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BudgetBillInfo info = (BudgetBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BudgetBillInfo info = (BudgetBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BudgetBillInfo info = (BudgetBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, BudgetBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0005", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BudgetBillInfo eti = (BudgetBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, BudgetBillInfo eti) throws EASBizException {
        String error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
    }

    protected void materialEntryBeforeSave(Context ctx, BudgetBillInfo model) throws BOSException, EASBizException {
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        if (model.getEntrys() != null && model.getEntrys().size() > 0) {
            for (int i = 0; i < model.getEntrys().size(); ++i) {
                if (model.getProject() == null || model.getEntrys().get(i).getClassCode() == null) continue;
                StringBuffer sql = new StringBuffer();
                ArrayList<String> ags = new ArrayList<String>();
                sql.append(" /*dialect*/select pe.CFTechnicalNumber,pe.CFPurchasePrice,pe.CFPurchaseCost from ct_pcm_prpbudgetbill p");
                sql.append(" inner join ct_pcm_prpbudgetbillentry pe on pe.fparentid=p.fid");
                sql.append(" where p.cfprojectid=? and p.CFSTATUS=4");
                sql.append(" and pe.CFCLASSCODEID=?");
                ags.add(model.getProject().getId().toString());
                ags.add(model.getEntrys().get(i).getClassCode().getId().toString());
                if (model.getEntrys().get(i).getMaterial() != null) {
                    sql.append(" and pe.cfmaterialid=?");
                    ags.add(model.getEntrys().get(i).getMaterial().getId().toString());
                }
                sql.append(" order by p.fbizdate desc");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])ags.toArray());
                try {
                    while (rs.next()) {
                        model.getEntrys().get(i).setTrolleyQtyPurchase(rs.getBigDecimal("CFTechnicalNumber"));
                        model.getEntrys().get(i).setTrolleyPricePurchase(rs.getBigDecimal("CFPurchasePrice"));
                        model.getEntrys().get(i).setTrolleyCostPurchase(rs.getBigDecimal("CFPurchaseCost"));
                    }
                    continue;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BudgetBillInfo eti = (BudgetBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        BudgetBillInfo ebi = (BudgetBillInfo)objectValue;
        if (ebi.getLabourEntry().size() == 1 && ebi.getLabourEntry().get(0).getExpenseDept() == null) {
            ebi.getLabourEntry().remove(ebi.getLabourEntry().get(0));
        }
        if (ebi.getOtherDeliverablesEntry().size() == 1 && ebi.getOtherDeliverablesEntry().get(0).getOtherDeliverable() == null) {
            ebi.getOtherDeliverablesEntry().remove(ebi.getOtherDeliverablesEntry().get(0));
        }
        if (ebi.getOtherExpenseEntry().size() == 1 && ebi.getOtherExpenseEntry().get(0).getCostItem() == null) {
            ebi.getOtherExpenseEntry().remove(ebi.getOtherExpenseEntry().get(0));
        }
        if (ebi.getProjectRiskEntrys().size() == 1 && ebi.getProjectRiskEntrys().get(0).getRiskItem() == null) {
            ebi.getProjectRiskEntrys().remove(ebi.getProjectRiskEntrys().get(0));
        }
    }

    protected void _handleAfterTransform(Context context, String s, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this._handleAfterTransform(context, s, coll.getObject(i));
            }
        }
    }

    @Override
    protected Map _exBom(Context ctx, Map map) throws BOSException {
        BudgetBillInfo billInfo = (BudgetBillInfo)map.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)map.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)map.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)map.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("sql_tmp", map.get("sql"));
            params.put("projectType_tmp", map.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    protected String getTempTableSql(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append("FClassCodeID varchar(44) ,\r\n");
        sql.append("FMaterialID varchar(44) ,\r\n");
        sql.append("FMaterialNumber VARCHAR(250) ,\r\n");
        sql.append("FMaterialName VARCHAR(250) Null,\r\n");
        sql.append("FMaterialModel VARCHAR(250) Null,\r\n");
        sql.append("FUnitID VARCHAR(44) Null,\r\n");
        sql.append("FUnitName  VARCHAR(250) Null,\r\n");
        sql.append("FFlow VARCHAR(250) Null,\r\n");
        sql.append("FPrice Numeric(21,8) Null,\r\n");
        sql.append("FActualPrice Numeric(21,8) Null,\r\n");
        sql.append("FDeQty Numeric(21,8) Null\r\n");
        sql.append(")");
        return sql.toString();
    }

    @Override
    protected Map _exManuBom(Context ctx, Map paramMap) throws BOSException, EASBizException {
        BudgetBillInfo billInfo = (BudgetBillInfo)paramMap.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)paramMap.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)paramMap.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            ManuBomTree tree = new ManuBomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("projectType_tmp", paramMap.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    private class ManuBomTree
    extends ProjectTargetCostBillBomTree {
        private ManuBomTree() {
        }

        @Override
        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("/*dialect*/ insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" null,0,0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" where 1=1");
            sql.append(" and b.TREE_MATERIAL_PROP!=10030");
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfmaterialid=t.FMaterialID and c.cfclasscodeid is not null and c.cfprojecttypeid='" + projectType.getId().toString() + "'");
            sql.append(" and rownum=1)");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfmaterialid=t.FMaterialID and c1.cfclasscodeid is not null and c1.cfprojecttypeid='" + projectType.getId().toString() + "')");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(nvl(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FActualPrice=");
            sql.append(" (select distinct first_value(c.fprice) over (partition by c.fmaterialid order by c.fbilldate desc) fprice from T_AP_OtherBillEntry c");
            sql.append(" inner join T_AP_OtherBill ob on ob.fid=c.fparentid ");
            sql.append(" where c.fmaterialid=t.FMaterialID");
            sql.append(" and ob.fbilltype=202");
            sql.append(" and ob.fisbizbill=0");
            sql.append(" and ob.fbillstatus=3");
            sql.append(" and ob.fistransbill=0 and ob.fcompanyid = '" + ContextUtil.getCurrentFIUnit((Context)this.ctx).getId() + "' ");
            sql.append(" )");
            sql.append(" where exists (select 1 from T_AP_OtherBillEntry c1 ");
            sql.append(" inner join T_AP_OtherBill ob1 on ob1.fid=c1.fparentid ");
            sql.append(" where c1.fmaterialid=t.FMaterialID");
            sql.append(" and ob1.fbilltype=202");
            sql.append(" and ob1.fisbizbill=0");
            sql.append(" and ob1.fbillstatus=3");
            sql.append(" and ob1.fistransbill=0 and ob1.fcompanyid = '" + ContextUtil.getCurrentFIUnit((Context)this.ctx).getId() + "' ");
            sql.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            BudgetBillInfo billInfo = (BudgetBillInfo)params.get("billInfo");
            HashMap<String, BudgetBillEntryInfo> materialMap = new HashMap<String, BudgetBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                BudgetBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("/*dialect*/ select * from " + tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            int noCount = 0;
            while (rs.next()) {
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID)) {
                    if (((BudgetBillEntryInfo)materialMap.get(materialID)).getTechTrolleyQty().compareTo(rs.getBigDecimal("FDeQty")) == 0) continue;
                    ((BudgetBillEntryInfo)materialMap.get(materialID)).setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    BudgetBillEntryInfo info = (BudgetBillEntryInfo)materialMap.get(materialID);
                    info.setActualPrice(rs.getBigDecimal("FActualPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FActualPrice"));
                    if (info.getEstimatePrice() != null && info.getEstimatePrice().compareTo(BigDecimal.ZERO) > 0) {
                        info.setEstimateUnitPrice(info.getEstimatePrice());
                        info.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0018", (Locale)this.ctx.getLocale()));
                    } else if (info.getActualPrice() != null && info.getActualPrice().compareTo(BigDecimal.ZERO) > 0) {
                        info.setEstimateUnitPrice(info.getActualPrice());
                        info.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0019", (Locale)this.ctx.getLocale()));
                    }
                    BigDecimal trolleyCost = BigDecimal.ZERO;
                    if (info.getEstimateUnitPrice() != null) {
                        trolleyCost = info.getTechTrolleyQty().multiply(info.getEstimateUnitPrice()).setScale(2, RoundingMode.HALF_UP);
                    }
                    if (info.getRiskAmount() != null) {
                        trolleyCost.add(info.getRiskAmount());
                    }
                    info.setTrolleyRealCost(trolleyCost);
                    continue;
                }
                if (materials.contains(materialID)) continue;
                if (classCodeID != null) {
                    ++count;
                } else {
                    ++noCount;
                }
                BudgetBillEntryInfo entry = new BudgetBillEntryInfo();
                entry.setClassCode((ClassificationCodeInfo)allClassCode.get(classCodeID));
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                MeasureUnitInfo ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setFlow(rs.getString("FFlow"));
                entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setActualPrice(rs.getBigDecimal("FActualPrice"));
                if (entry.getActualPrice() != null && entry.getActualPrice().compareTo(BigDecimal.ZERO) > 0) {
                    entry.setEstimateUnitPrice(entry.getActualPrice());
                    entry.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0019", (Locale)this.ctx.getLocale()));
                    BigDecimal trolleyCost = BigDecimal.ZERO;
                    if (entry.getEstimateUnitPrice() != null) {
                        trolleyCost = entry.getTechTrolleyQty().multiply(entry.getEstimateUnitPrice()).setScale(2, RoundingMode.HALF_UP);
                    }
                    if (entry.getRiskAmount() != null) {
                        trolleyCost.add(entry.getRiskAmount());
                    }
                    entry.setTrolleyRealCost(trolleyCost);
                }
                billInfo.getEntrys().add(entry);
            }
            rs = DbUtil.executeQuery((Context)this.ctx, (String)("/*dialect*/ select count(*) as count from " + tempTable + " where fclasscodeid is null"));
            if (rs.next()) {
                noCount = rs.getInt("count");
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
            reMap.put("billInfo", billInfo);
        }
    }

    private class BomTree
    extends ProcessBomTree {
        private BomTree() {
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("/*dialect*/ insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" max(pbb.cfmakeflow),0,0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" inner join ct_zjb_processbombill pbb on b.tree_bom_id=pbb.fid");
            sql.append(" where 1=1");
            sql.append(" " + propSql);
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfmaterialid=t.FMaterialID and c.cfclasscodeid is not null and c.cfprojecttypeid='" + projectType.getId().toString() + "'");
            sql.append(" and rownum=1)");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfmaterialid=t.FMaterialID and c1.cfclasscodeid is not null and c1.cfprojecttypeid='" + projectType.getId().toString() + "')");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(nvl(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FActualPrice=");
            sql.append(" (select distinct first_value(c.fprice) over (partition by c.fmaterialid order by c.fbilldate desc) fprice from T_AP_OtherBillEntry c");
            sql.append(" inner join T_AP_OtherBill ob on ob.fid=c.fparentid ");
            sql.append(" where c.fmaterialid=t.FMaterialID");
            sql.append(" and ob.fbilltype=202");
            sql.append(" and ob.fisbizbill=0");
            sql.append(" and ob.fbillstatus=3");
            sql.append(" and ob.fistransbill=0 and ob.fcompanyid = '" + ContextUtil.getCurrentFIUnit((Context)this.ctx).getId() + "' ");
            sql.append(" )");
            sql.append(" where exists (select 1 from T_AP_OtherBillEntry c1 ");
            sql.append(" inner join T_AP_OtherBill ob1 on ob1.fid=c1.fparentid ");
            sql.append(" where c1.fmaterialid=t.FMaterialID");
            sql.append(" and ob1.fbilltype=202");
            sql.append(" and ob1.fisbizbill=0");
            sql.append(" and ob1.fbillstatus=3");
            sql.append(" and ob1.fistransbill=0 and ob1.fcompanyid = '" + ContextUtil.getCurrentFIUnit((Context)this.ctx).getId() + "' ");
            sql.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            BudgetBillInfo billInfo = (BudgetBillInfo)params.get("billInfo");
            HashMap<String, BudgetBillEntryInfo> materialMap = new HashMap<String, BudgetBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                BudgetBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("/*dialect*/ select * from " + tempTable + " where fclasscodeid is not null");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            while (rs.next()) {
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID) && ((BudgetBillEntryInfo)materialMap.get(materialID)).getTechTrolleyQty().compareTo(rs.getBigDecimal("FDeQty")) != 0) {
                    ((BudgetBillEntryInfo)materialMap.get(materialID)).setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    BudgetBillEntryInfo info = (BudgetBillEntryInfo)materialMap.get(materialID);
                    info.setActualPrice(rs.getBigDecimal("FActualPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FActualPrice"));
                    if (info.getEstimatePrice() != null && info.getEstimatePrice().compareTo(BigDecimal.ZERO) > 0) {
                        info.setEstimateUnitPrice(info.getEstimatePrice());
                        info.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0018", (Locale)this.ctx.getLocale()));
                    } else if (info.getActualPrice() != null && info.getActualPrice().compareTo(BigDecimal.ZERO) > 0) {
                        info.setEstimateUnitPrice(info.getActualPrice());
                        info.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0019", (Locale)this.ctx.getLocale()));
                    }
                    BigDecimal trolleyCost = BigDecimal.ZERO;
                    if (info.getEstimateUnitPrice() != null) {
                        trolleyCost = info.getTechTrolleyQty().multiply(info.getEstimateUnitPrice()).setScale(2, RoundingMode.HALF_UP);
                    }
                    if (info.getRiskAmount() != null) {
                        trolleyCost.add(info.getRiskAmount());
                    }
                    info.setTrolleyRealCost(trolleyCost);
                }
                if (materials.contains(materialID)) continue;
                BudgetBillEntryInfo entry = new BudgetBillEntryInfo();
                entry.setClassCode((ClassificationCodeInfo)allClassCode.get(classCodeID));
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                MeasureUnitInfo ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setFlow(rs.getString("FFlow"));
                entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setActualPrice(rs.getBigDecimal("FActualPrice"));
                if (entry.getActualPrice() != null && entry.getActualPrice().compareTo(BigDecimal.ZERO) > 0) {
                    entry.setEstimateUnitPrice(entry.getActualPrice());
                    entry.setPriceSource(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0019", (Locale)this.ctx.getLocale()));
                    BigDecimal trolleyCost = BigDecimal.ZERO;
                    if (entry.getEstimateUnitPrice() != null) {
                        trolleyCost = entry.getTechTrolleyQty().multiply(entry.getEstimateUnitPrice()).setScale(2, RoundingMode.HALF_UP);
                    }
                    if (entry.getRiskAmount() != null) {
                        trolleyCost.add(entry.getRiskAmount());
                    }
                    entry.setTrolleyRealCost(trolleyCost);
                }
                billInfo.getEntrys().add(entry);
                ++count;
            }
            rs = DbUtil.executeQuery((Context)this.ctx, (String)("/*dialect*/ select count(*) as count from " + tempTable + " where fclasscodeid is null"));
            int noCount = 0;
            if (rs.next()) {
                noCount = rs.getInt("count");
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
        }
    }
}

