/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.EstimateBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.EstimateBillInfo;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryCollection;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryInfo;
import com.kingdee.eas.industry.emm.pcm.app.AbstractEstimateBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.VehicleTypeInfo;
import com.kingdee.eas.industry.emm.pcm.costmanagement.app.SparePartsHelper;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceCollection;
import com.kingdee.eas.industry.emm.pcm.spareparts.SparePartJZPriceFactory;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EstimateBillControllerBean
extends AbstractEstimateBillControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.EstimateBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateBillInfo bill = (EstimateBillInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EstimateBillInfo info = (EstimateBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        EstimateBillInfo info = (EstimateBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EstimateBillInfo info = (EstimateBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, EstimateBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0005", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getVehicleType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0007", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateBillInfo eti = (EstimateBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, EstimateBillInfo eti) throws EASBizException {
        String error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
        EstimateBillEntryCollection entrysColl = eti.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer tmpStr = new StringBuffer();
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (!isTotalRow && PcmTreeBillHelper.isStringEmpty(materialEntry.get("discCode"))) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0020", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() <= 0) continue;
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0021", (Locale)ctx.getLocale()) + strInfo + "," + tmpStr.toString()));
        }
        EstimateBillSpareEntryCollection ebSpareColl = eti.getSpareEntry();
        for (int i = 0; i < ebSpareColl.size(); ++i) {
            ProjectTypesInfo pti;
            EstimateBillSpareEntryInfo spareEntry = ebSpareColl.get(i);
            StringBuffer tmpStr = new StringBuffer();
            if (spareEntry.isIsTotalRow()) continue;
            if (spareEntry.getMaterialName() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0022", (Locale)ctx.getLocale()));
            }
            if (spareEntry.getUnit() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0023", (Locale)ctx.getLocale()));
            }
            if (spareEntry.getReferProject() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0024", (Locale)ctx.getLocale()));
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(spareEntry.getTechProjectQty())) {
                spareEntry.setTechProjectQty(BigDecimal.ZERO);
            }
            if (spareEntry.getMaterial() != null) {
                spareEntry.setUnit(spareEntry.getMaterial().getBaseUnit());
            }
            EntityViewInfo evi = new EntityViewInfo();
            ProjectInfo projectInfo = spareEntry.getReferProject();
            if (projectInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("estPrice"));
                evi.getSelector().add(new SelectorItemInfo("actPurPrice"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("project.number", (Object)projectInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("idCode", (Object)spareEntry.getDiscCode(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("updateDate is not null"));
                evi.setSorter(new SorterItemCollection());
                SorterItemInfo itemInfo1 = new SorterItemInfo("updateDate");
                itemInfo1.setSortType(SortType.DESCEND);
                evi.getSorter().add(itemInfo1);
                SparePartPriceCollection pmpCollection1 = null;
                try {
                    pmpCollection1 = SparePartPriceFactory.getLocalInstance(ctx).getSparePartPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection1.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection1.get(0).getActPurPrice())) {
                    actualPurPrice = pmpCollection1.get(0).getActPurPrice();
                }
                spareEntry.setReferProjectPrice(actualPurPrice);
            } else {
                spareEntry.setReferProjectPrice(null);
            }
            String idcode = spareEntry.getDiscCode();
            VehicleTypeInfo vehicleTypeInfo = eti.getVehicleType();
            if (idcode != null && vehicleTypeInfo != null) {
                evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(new SelectorItemInfo("qty"));
                evi.getSelector().add(new SelectorItemInfo("price"));
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("vehicleType.number", (Object)vehicleTypeInfo.getNumber(), CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("idCode", (Object)idcode, CompareType.EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("IsCheck", (Object)true, CompareType.EQUALS));
                evi.setSorter(new SorterItemCollection());
                SparePartJZPriceCollection pmpCollection = null;
                try {
                    pmpCollection = SparePartJZPriceFactory.getLocalInstance(ctx).getSparePartJZPriceCollection(evi);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
                BigDecimal actualPurPrice = null;
                if (pmpCollection.size() != 0 && !PcmTreeBillHelper.isBigDecimalEmptyAndZero(pmpCollection.get(0).getPrice())) {
                    actualPurPrice = pmpCollection.get(0).getPrice();
                }
                spareEntry.setProjectPrice(actualPurPrice);
            }
            if ((pti = eti.getProjectType()) != null) {
                BigDecimal configurePrice = spareEntry.getConfigurePrice();
                BigDecimal inquiryPrice = spareEntry.getInquiryPrice();
                BigDecimal referProjectPrice = spareEntry.getReferProjectPrice();
                BigDecimal estimatePrice = spareEntry.getEstimatePrice();
                BigDecimal newPurPrice = spareEntry.getNewPurPrice();
                BigDecimal projectPrice = spareEntry.getProjectPrice();
                if (estimatePrice != null && estimatePrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", estimatePrice);
                    spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0018", (Locale)ctx.getLocale()));
                } else if (inquiryPrice != null && inquiryPrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", inquiryPrice);
                    spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0025", (Locale)ctx.getLocale()));
                } else if (projectPrice != null && projectPrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", projectPrice);
                    spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0026", (Locale)ctx.getLocale()));
                } else if (referProjectPrice != null && referProjectPrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", referProjectPrice);
                    ProjectInfo project = (ProjectInfo)spareEntry.get("referProject");
                    if (project != null) {
                        spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0027", (Locale)ctx.getLocale()) + ":" + project.getName());
                    }
                } else if (newPurPrice != null && newPurPrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", newPurPrice);
                    spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0028", (Locale)ctx.getLocale()));
                } else if (configurePrice != null && configurePrice.compareTo(BigDecimal.ZERO) > 0) {
                    spareEntry.put("estimateUnitPrice", configurePrice);
                    spareEntry.put("priceSource", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0029", (Locale)ctx.getLocale()));
                }
            }
            if (PcmTreeBillHelper.isBigDecimalEmptyAndZero(spareEntry.get("estimateUnitPrice"))) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0030", (Locale)ctx.getLocale()));
            } else {
                BigDecimal riskCoeff = spareEntry.getBigDecimal("riskCoeff");
                if (riskCoeff != null && riskCoeff.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal riskAmount = riskCoeff.multiply(spareEntry.getBigDecimal("estimateUnitPrice")).setScale(2, RoundingMode.HALF_UP);
                    spareEntry.put("riskAmount", riskAmount);
                }
                if (tmpStr.length() == 0) {
                    BigDecimal trolleyQty = new BigDecimal(spareEntry.getTechProjectQty().toString());
                    BigDecimal trolleyPrice = new BigDecimal(spareEntry.get("estimateUnitPrice").toString());
                    BigDecimal riskAmount = spareEntry.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : spareEntry.getBigDecimal("riskAmount");
                    BigDecimal trolleyCost = trolleyQty.multiply(trolleyPrice).add(riskAmount);
                    spareEntry.put("projcetCost", trolleyCost);
                }
            }
            if (tmpStr.length() <= 0) continue;
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0031", (Locale)ctx.getLocale()) + strInfo + "," + tmpStr.toString()));
        }
    }

    protected void materialEntryBeforeSave(Context ctx, EstimateBillInfo model) throws BOSException, EASBizException {
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        SparePartsHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EstimateBillInfo eti = (EstimateBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        EstimateBillInfo ebi = (EstimateBillInfo)objectValue;
        if (ebi.getLabourEntry().size() == 1 && ebi.getLabourEntry().get(0).getExpenseDept() == null) {
            ebi.getLabourEntry().remove(ebi.getLabourEntry().get(0));
        }
        if (ebi.getOtherDeliverablesEntry().size() == 1 && ebi.getOtherDeliverablesEntry().get(0).getOtherDeliverable() == null) {
            ebi.getOtherDeliverablesEntry().remove(ebi.getOtherDeliverablesEntry().get(0));
        }
        if (ebi.getOtherExpenseEntry().size() == 1 && ebi.getOtherExpenseEntry().get(0).getCostItem() == null) {
            ebi.getOtherExpenseEntry().remove(ebi.getOtherExpenseEntry().get(0));
        }
        if (ebi.getProjectRiskEntrys().size() == 1 && ebi.getProjectRiskEntrys().get(0).getRiskItem() == null) {
            ebi.getProjectRiskEntrys().remove(ebi.getProjectRiskEntrys().get(0));
        }
    }

    protected void _handleAfterTransform(Context context, String s, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this._handleAfterTransform(context, s, coll.getObject(i));
            }
        }
    }
}

