/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.industry.emm.pcm.EstimateBillFactory;
import com.kingdee.eas.industry.emm.pcm.EstimateBillInfo;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryCollection;
import com.kingdee.eas.industry.emm.pcm.EstimateBillSpareEntryFactory;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public class EstimateBillSpareImport
extends AbstractDataTransmission {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return EstimateBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable ht, Context arg1) throws TaskExternalException {
        if (((DataToken)ht.get((Object)"FNumber")).data == null || "".equals(((DataToken)ht.get((Object)"FNumber")).data.toString().trim())) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0032", (Locale)arg1.getLocale()));
        }
        if (((DataToken)ht.get((Object)"FSpareEntry$unit_number")).data == null || "".equals(((DataToken)ht.get((Object)"FSpareEntry$unit_number")).data.toString().trim())) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0014", (Locale)arg1.getLocale()));
        }
        return null;
    }

    public void submit(CoreBaseInfo billInfo, Context ctx) throws TaskExternalException {
        EstimateBillInfo ebi = (EstimateBillInfo)billInfo;
        this.checkSparePartsExeEstimate(ebi, ctx);
        String number = ebi.getNumber();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)4, CompareType.EQUALS));
        boolean isAudit = false;
        try {
            isAudit = this.getController(ctx).exists(filter);
        }
        catch (Exception e) {
            new TaskExternalException("", (Throwable)e);
        }
        if (isAudit) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0016", (Locale)ctx.getLocale()));
        }
        super.submit(billInfo, ctx);
    }

    private void checkSparePartsExeEstimate(EstimateBillInfo ebi, Context ctx) throws TaskExternalException {
        EstimateBillSpareEntryCollection pare = ebi.getSpareEntry();
        for (int i = 0; i < pare.size(); ++i) {
            if (pare.get(i).getMaterial() == null) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)pare.get(i).getMaterial().getId()));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)ebi.getId(), CompareType.EQUALS));
            view.setFilter(filter);
            try {
                EstimateBillSpareEntryCollection collection = EstimateBillSpareEntryFactory.getLocalInstance(ctx).getEstimateBillSpareEntryCollection(view);
                if (collection == null || collection.size() <= 0) continue;
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(pare.get(i).getMaterial().getId()));
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"WL_EXCELT", (Locale)ctx.getLocale(), (Object[])new Object[]{material.getNumber()});
                throw new TaskExternalException(strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0033", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                e.printStackTrace();
                continue;
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }
}

