/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.pcm.PRPBudgetBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.PRPBudgetBillInfo;
import com.kingdee.eas.industry.emm.pcm.PurchaseAttrEnum;
import com.kingdee.eas.industry.emm.pcm.app.AbstractPRPBudgetBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.app.ProjectTargetCostBillBomTree;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PRPBudgetBillControllerBean
extends AbstractPRPBudgetBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.PRPBudgetBillControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PRPBudgetBillInfo eti = (PRPBudgetBillInfo)model;
        if (eti.getCU() == null) {
            eti.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        PRPBudgetBillControllerBean.insertTotalRowByClassCode(model, ctx);
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PRPBudgetBillInfo eti;
        if (pk != null && (eti = this.getPRPBudgetBillInfo(ctx, pk)).getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0060", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PRPBudgetBillInfo eti = (PRPBudgetBillInfo)model;
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        PRPBudgetBillControllerBean.insertTotalRowByClassCode(model, ctx);
        return super._submit(ctx, model);
    }

    public static void insertTotalRowByClassCode(IObjectValue model, Context ctx) throws BOSException, EASBizException {
        IObjectCollection coll = (IObjectCollection)model.get("entrys");
        String costKey = "trolleyCost";
        ProjectTypesInfo pti = (ProjectTypesInfo)model.get("projectType");
        ArrayList<ClassificationCodeInfo> cciSet = new ArrayList<ClassificationCodeInfo>();
        CoreBillEntryBaseInfo cloneer = null;
        HashSet<String> editTotalRowSetForClassCodeID = new HashSet<String>();
        HashMap<ClassificationCodeInfo, Integer> dupMap = new HashMap<ClassificationCodeInfo, Integer>();
        for (int i = 0; i < coll.size(); ++i) {
            ClassificationCodeInfo cci;
            CoreBillEntryBaseInfo iov = (CoreBillEntryBaseInfo)coll.getObject(i);
            if (cloneer == null) {
                cloneer = (CoreBillEntryBaseInfo)iov.clone();
            }
            if (!cciSet.contains(cci = (ClassificationCodeInfo)iov.get("classCode"))) {
                cciSet.add(cci);
            }
            if (iov.getBoolean("isTotalRow") || iov.getBoolean("isPackageRow")) {
                if (!PcmTreeBillHelper.isBigDecimalEmptyAndZero(iov.get("estimateUnitPrice"))) {
                    editTotalRowSetForClassCodeID.add(((ClassificationCodeInfo)iov.get("classCode")).getId().toString());
                }
                iov.put("isPackageRow", (Object)true);
            }
            if (dupMap.get(cci) != null) {
                int count = (Integer)dupMap.get(cci);
                dupMap.put(cci, ++count);
                continue;
            }
            dupMap.put(cci, 1);
        }
        Collections.sort(cciSet);
        if (cloneer != null) {
            cloneer.clear();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)pti.getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection selColl = new SelectorItemCollection();
        selColl.add(new SelectorItemInfo("*"));
        selColl.add(new SelectorItemInfo("parent.*"));
        ev.setSelector(selColl);
        ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeCollection(ev);
        HashMap<ClassificationCodeInfo, ClassificationCodeInfo> allClassCode = new HashMap<ClassificationCodeInfo, ClassificationCodeInfo>();
        for (int i = 0; i < classCodeColl.size(); ++i) {
            allClassCode.put(classCodeColl.get(i), classCodeColl.get(i));
        }
        HashMap<ClassificationCodeInfo, CoreBillEntryBaseInfo> classCodeTotalRowMap = new HashMap<ClassificationCodeInfo, CoreBillEntryBaseInfo>();
        HashSet<CoreBillEntryBaseInfo> leafTotalRow = new HashSet<CoreBillEntryBaseInfo>();
        for (int i = cciSet.size() - 1; i >= 0; --i) {
            ClassificationCodeInfo cci = (ClassificationCodeInfo)cciSet.get(i);
            CoreBillEntryBaseInfo newClone = null;
            BigDecimal totalTrolleyCost = BigDecimal.ZERO;
            BigDecimal totalRiskAmount = BigDecimal.ZERO;
            BigDecimal totalTrolleyCostPurchase = BigDecimal.ZERO;
            BigDecimal totalPurchaseCost = BigDecimal.ZERO;
            int tmp_count = 0;
            for (int j = 0; j < coll.size(); ++j) {
                BigDecimal purchaseCost;
                BigDecimal trolleyCostPurchase;
                BigDecimal riskAmount;
                BigDecimal trolleyCost;
                CoreBillEntryBaseInfo iov = (CoreBillEntryBaseInfo)coll.getObject(j);
                ClassificationCodeInfo cciChild = (ClassificationCodeInfo)iov.get("classCode");
                if (cciChild.getId().toString().equals(cci.getId().toString())) {
                    if (iov.getBoolean("isTotalRow") || iov.getBoolean("isPackageRow")) {
                        newClone = iov;
                    } else {
                        trolleyCost = iov.getBigDecimal(costKey) == null ? BigDecimal.ZERO : iov.getBigDecimal(costKey);
                        totalTrolleyCost = totalTrolleyCost.add(trolleyCost);
                        riskAmount = iov.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov.getBigDecimal("riskAmount");
                        totalRiskAmount = totalRiskAmount.add(riskAmount);
                        trolleyCostPurchase = iov.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov.getBigDecimal("trolleyCostPurchase");
                        totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase);
                        purchaseCost = iov.getBigDecimal("purchaseCost") == null ? BigDecimal.ZERO : iov.getBigDecimal("purchaseCost");
                        totalPurchaseCost = totalPurchaseCost.add(purchaseCost);
                        ++tmp_count;
                    }
                }
                if (!PRPBudgetBillControllerBean.isLeafOfParent(cciChild, cci) || PRPBudgetBillControllerBean.isLeafOfEditParent(allClassCode, editTotalRowSetForClassCodeID, cci, cciChild)) continue;
                if (editTotalRowSetForClassCodeID.contains(cciChild.getId().toString())) {
                    totalTrolleyCost = totalTrolleyCost.add(iov.getBigDecimal(costKey));
                    BigDecimal riskAmount2 = iov.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov.getBigDecimal("riskAmount");
                    totalRiskAmount = totalRiskAmount.add(riskAmount2);
                    BigDecimal trolleyCostPurchase2 = iov.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov.getBigDecimal("trolleyCostPurchase");
                    totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase2);
                    BigDecimal purchaseCost2 = iov.getBigDecimal("purchaseCost") == null ? BigDecimal.ZERO : iov.getBigDecimal("purchaseCost");
                    totalPurchaseCost = totalPurchaseCost.add(purchaseCost2);
                    continue;
                }
                if (iov.getBoolean("isTotalRow") || iov.getBoolean("isPackageRow")) continue;
                trolleyCost = iov.getBigDecimal(costKey) == null ? BigDecimal.ZERO : iov.getBigDecimal(costKey);
                totalTrolleyCost = totalTrolleyCost.add(trolleyCost);
                riskAmount = iov.getBigDecimal("riskAmount") == null ? BigDecimal.ZERO : iov.getBigDecimal("riskAmount");
                totalRiskAmount = totalRiskAmount.add(riskAmount);
                trolleyCostPurchase = iov.getBigDecimal("trolleyCostPurchase") == null ? BigDecimal.ZERO : iov.getBigDecimal("trolleyCostPurchase");
                totalTrolleyCostPurchase = totalTrolleyCostPurchase.add(trolleyCostPurchase);
                purchaseCost = iov.getBigDecimal("purchaseCost") == null ? BigDecimal.ZERO : iov.getBigDecimal("purchaseCost");
                totalPurchaseCost = totalPurchaseCost.add(purchaseCost);
            }
            if (newClone == null) {
                newClone = (CoreBillEntryBaseInfo)cloneer.clone();
                newClone.put("classCode", (Object)cci);
                coll.addObject((IObjectValue)newClone);
            }
            newClone.put("tmp_count", (Object)tmp_count);
            leafTotalRow.add(newClone);
            if (PRPBudgetBillControllerBean.isBigDecimalEmptyAndZero(newClone.get("estimateUnitPrice"))) {
                newClone.put("techTrolleyQty", null);
                newClone.put(costKey, (Object)totalTrolleyCost);
            }
            newClone.put("riskAmount", (Object)totalRiskAmount);
            newClone.put("trolleyCostPurchase", (Object)totalTrolleyCostPurchase);
            newClone.put("purchaseCost", (Object)totalPurchaseCost);
            if (!newClone.getBoolean("isPackageRow")) {
                newClone.put("isTotalRow", (Object)true);
            }
            classCodeTotalRowMap.put(cci, newClone);
        }
        for (CoreBillEntryBaseInfo cbe : leafTotalRow) {
            if (cbe.get("tmp_count") == null || cbe.getInt("tmp_count") != 1) continue;
            coll.removeObject((IObjectValue)cbe);
        }
        HashSet reCalSet = new HashSet(allClassCode.keySet());
        Set classTotalSet = classCodeTotalRowMap.keySet();
        reCalSet.removeAll(classTotalSet);
        ArrayList reCalList = new ArrayList(reCalSet);
        Collections.sort(reCalList);
        for (int i = reCalList.size() - 1; i >= 0; --i) {
            ClassificationCodeInfo cci = (ClassificationCodeInfo)reCalList.get(i);
            BigDecimal totalTrolleyCost = BigDecimal.ZERO;
            BigDecimal totalRiskAmount = BigDecimal.ZERO;
            BigDecimal totalPurchaseCost = BigDecimal.ZERO;
            boolean isExists = false;
            Iterator<Object> it = classTotalSet.iterator();
            while (it.hasNext()) {
                ClassificationCodeInfo totalCci = (ClassificationCodeInfo)allClassCode.get((ClassificationCodeInfo)it.next());
                if (totalCci == null || totalCci.getParent() == null || !totalCci.getParent().getId().toString().equals(cci.getId().toString())) continue;
                isExists = true;
                CoreBillEntryBaseInfo iov = (CoreBillEntryBaseInfo)classCodeTotalRowMap.get(totalCci);
                totalTrolleyCost = totalTrolleyCost.add(iov.getBigDecimal(costKey));
                totalRiskAmount = totalRiskAmount.add(iov.getBigDecimal("riskAmount"));
                totalPurchaseCost = totalPurchaseCost.add(iov.getBigDecimal("purchaseCost"));
            }
            if (isExists) {
                CoreBillEntryBaseInfo newClone = (CoreBillEntryBaseInfo)cloneer.clone();
                newClone.put("classCode", (Object)cci);
                newClone.put(costKey, (Object)totalTrolleyCost);
                newClone.put("riskAmount", (Object)totalRiskAmount);
                newClone.put("purchaseCost", (Object)totalPurchaseCost);
                newClone.put("isTotalRow", (Object)true);
                coll.addObject((IObjectValue)newClone);
                classCodeTotalRowMap.put(cci, newClone);
            }
            PRPBudgetBillControllerBean.addAmountLoopForTotal(allClassCode, classCodeTotalRowMap, (ClassificationCodeInfo)allClassCode.get(cci.getParent()), totalTrolleyCost, totalRiskAmount, totalPurchaseCost, costKey);
        }
    }

    @Override
    protected Map _exBom(Context ctx, Map map) throws BOSException {
        PRPBudgetBillInfo billInfo = (PRPBudgetBillInfo)map.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)map.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)map.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)map.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("sql_tmp", map.get("sql"));
            params.put("projectType_tmp", map.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    protected String getTempTableSql(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append("FClassCodeID varchar(44) ,\r\n");
        sql.append("FMaterialID varchar(44) ,\r\n");
        sql.append("FMaterialNumber VARCHAR(250) ,\r\n");
        sql.append("FMaterialName VARCHAR(250) Null,\r\n");
        sql.append("FMaterialModel VARCHAR(250) Null,\r\n");
        sql.append("FUnitID VARCHAR(44) Null,\r\n");
        sql.append("FUnitName  VARCHAR(250) Null,\r\n");
        sql.append("FFlow VARCHAR(250) Null,\r\n");
        sql.append("FPrice Numeric(21,8) Null,\r\n");
        sql.append("FActualPrice Numeric(21,8) Null,\r\n");
        sql.append("FDeQty Numeric(21,8) Null\r\n");
        sql.append(")");
        return sql.toString();
    }

    public static void addAmountLoopForTotal(Map allClassCode, Map classCodeTotalRowMap, ClassificationCodeInfo classCode, BigDecimal totalTrolleyCost, BigDecimal totalRiskAmount, BigDecimal totalPurchaseCost, String costKey) {
        if (classCode == null) {
            return;
        }
        if (classCodeTotalRowMap.get(classCode) != null) {
            CoreBillEntryBaseInfo newClone = (CoreBillEntryBaseInfo)classCodeTotalRowMap.get(classCode);
            BigDecimal trolleyCost = newClone.getBigDecimal(costKey);
            if (totalTrolleyCost != null && trolleyCost != null) {
                newClone.put(costKey, (Object)totalTrolleyCost.add(trolleyCost));
            }
            BigDecimal riskAmount = newClone.getBigDecimal("riskAmount");
            if (totalRiskAmount != null && riskAmount != null) {
                newClone.put("riskAmount", (Object)totalRiskAmount.add(riskAmount));
            }
            BigDecimal purchaseCost = newClone.getBigDecimal("purchaseCost");
            if (totalPurchaseCost != null && purchaseCost != null) {
                newClone.put("purchaseCost", (Object)totalRiskAmount.add(purchaseCost));
            }
        }
        if (classCode.getLevel() > 1) {
            PRPBudgetBillControllerBean.addAmountLoopForTotal(allClassCode, classCodeTotalRowMap, (ClassificationCodeInfo)allClassCode.get(classCode.getParent()), totalTrolleyCost, totalRiskAmount, totalPurchaseCost, costKey);
        }
    }

    public static boolean isBigDecimalEmptyAndZero(Object o) {
        if (o == null) {
            return true;
        }
        if ("".equals(o.toString().trim())) {
            return true;
        }
        try {
            new BigDecimal(o.toString());
        }
        catch (Exception e) {
            return true;
        }
        return BigDecimal.ZERO.compareTo(new BigDecimal(o.toString())) >= 0;
    }

    private static boolean isLeafOfParent(ClassificationCodeInfo children, ClassificationCodeInfo parent) {
        if (children == null || children.getLongNumber() == null || parent == null || parent.getLongNumber() == null) {
            return false;
        }
        if (children.getLongNumber().equals(parent.getLongNumber())) {
            return false;
        }
        String childrenLongNumber = children.getLongNumber();
        String parentNumber = parent.getNumber();
        String[] parentStrs = childrenLongNumber.split("!");
        for (int i = 0; i < parentStrs.length - 1; ++i) {
            if (!parentStrs[i].equals(parentNumber)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLeafOfEditParent(Map allClassCode, Set editTotalRowSetForClassCodeID, ClassificationCodeInfo cci, ClassificationCodeInfo cciChild) {
        boolean isParentIn = false;
        ClassificationCodeInfo temp = cciChild;
        for (int i = 0; i < cciChild.getLevel(); ++i) {
            if (temp == null || temp.getParent() == null || (temp = (ClassificationCodeInfo)allClassCode.get(temp.getParent())) == null || !editTotalRowSetForClassCodeID.contains(temp.getId().toString()) || !PRPBudgetBillControllerBean.isLeafOfParent(temp, cci)) continue;
            isParentIn = true;
        }
        return isParentIn;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PRPBudgetBillInfo info = (PRPBudgetBillInfo)model;
        if (info == null) {
            info = (PRPBudgetBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PRPBudgetBillInfo info = (PRPBudgetBillInfo)model;
        if (info == null) {
            info = (PRPBudgetBillInfo)this._getValue(ctx, pk);
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    @Override
    protected Map _exManuBom(Context ctx, Map paramMap) throws BOSException, EASBizException {
        PRPBudgetBillInfo billInfo = (PRPBudgetBillInfo)paramMap.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)paramMap.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)paramMap.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            ManuBomTree tree = new ManuBomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("projectType_tmp", paramMap.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    private class ManuBomTree
    extends ProjectTargetCostBillBomTree {
        private ManuBomTree() {
        }

        @Override
        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" null,0,0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" where 1=1");
            sql.append(" and b.TREE_MATERIAL_PROP!='10030").append("'");
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tempTable + " t set FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfmaterialid=t.FMaterialID and c.cfclasscodeid is not null and c.cfprojecttypeid='" + projectType.getId().toString() + "'");
            sql.append(" and rownum=1)");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfmaterialid=t.FMaterialID and c1.cfclasscodeid is not null and c1.cfprojecttypeid='" + projectType.getId().toString() + "')");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(IsNull(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update " + tempTable + " t set FActualPrice=");
            sql.append(" (select top 1 c.fprice fprice from T_AP_OtherBillEntry c");
            sql.append(" where c.fmaterialid=t.FMaterialID order by c.fbilldate)");
            sql.append(" where exists (select 1 from T_AP_OtherBillEntry c1 ");
            sql.append(" where c1.fmaterialid=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            PRPBudgetBillInfo billInfo = (PRPBudgetBillInfo)params.get("billInfo");
            HashMap<String, PRPBudgetBillEntryInfo> materialMap = new HashMap<String, PRPBudgetBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                PRPBudgetBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("select * from " + tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            int noCount = 0;
            while (rs.next()) {
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID)) {
                    ((PRPBudgetBillEntryInfo)materialMap.get(materialID)).setTechnicalNumber(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    PRPBudgetBillEntryInfo info = (PRPBudgetBillEntryInfo)materialMap.get(materialID);
                    info.setActualPrice(rs.getBigDecimal("FActualPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FActualPrice"));
                }
                if (materials.contains(materialID)) continue;
                PRPBudgetBillEntryInfo entry = new PRPBudgetBillEntryInfo();
                if (classCodeID != null) {
                    ClassificationCodeInfo classCode = (ClassificationCodeInfo)allClassCode.get(classCodeID);
                    entry.setClassCode(classCode);
                    entry.setClassCodeName(classCode.getName());
                    entry.setClassCodeAttr(classCode.getAttribute());
                    ++count;
                } else {
                    ++noCount;
                }
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                MeasureUnitInfo ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setTechnicalNumber(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setActualPrice(rs.getBigDecimal("FActualPrice"));
                billInfo.getEntrys().add(entry);
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
            reMap.put("billInfo", billInfo);
        }
    }

    private class BomTree
    extends ProcessBomTree {
        private BomTree() {
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("/*dialect*/ insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" max(pbb.cfmakeflow),0,0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" inner join ct_zjb_processbombill pbb on b.tree_bom_id=pbb.fid");
            sql.append(" where 1=1");
            sql.append(" " + propSql);
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfmaterialid=t.FMaterialID and c.cfclasscodeid is not null and c.cfprojecttypeid='" + projectType.getId().toString() + "'");
            sql.append(" and rownum=1)");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfmaterialid=t.FMaterialID and c1.cfclasscodeid is not null and c1.cfprojecttypeid='" + projectType.getId().toString() + "')");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(nvl(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FActualPrice=");
            sql.append(" (select distinct first_value(c.fprice) over (partition by c.fmaterialid order by c.fbilldate desc) fprice from T_AP_OtherBillEntry c");
            sql.append(" where c.fmaterialid=t.FMaterialID)");
            sql.append(" where exists (select 1 from T_AP_OtherBillEntry c1 ");
            sql.append(" where c1.fmaterialid=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            PRPBudgetBillInfo billInfo = (PRPBudgetBillInfo)params.get("billInfo");
            HashMap<String, PRPBudgetBillEntryInfo> materialMap = new HashMap<String, PRPBudgetBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                PRPBudgetBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("/*dialect*/ select * from " + tempTable + " where fclasscodeid is not null");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            while (rs.next()) {
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID) && ((PRPBudgetBillEntryInfo)materialMap.get(materialID)).getTrolleyNumber() != null && ((PRPBudgetBillEntryInfo)materialMap.get(materialID)).getTrolleyNumber().compareTo(rs.getBigDecimal("FDeQty")) != 0) {
                    ((PRPBudgetBillEntryInfo)materialMap.get(materialID)).setTrolleyNumber(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    PRPBudgetBillEntryInfo info = (PRPBudgetBillEntryInfo)materialMap.get(materialID);
                    info.setActualPrice(rs.getBigDecimal("FActualPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FActualPrice"));
                }
                if (materials.contains(materialID)) continue;
                PRPBudgetBillEntryInfo entry = new PRPBudgetBillEntryInfo();
                ClassificationCodeInfo classCode = (ClassificationCodeInfo)allClassCode.get(classCodeID);
                entry.setClassCode(classCode);
                entry.setClassCodeName(classCode.getName());
                entry.setClassCodeAttr(classCode.getAttribute());
                MaterialInfo mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                MeasureUnitInfo ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setFlow(rs.getString("FFlow"));
                entry.setTechnicalNumber(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setActualPrice(rs.getBigDecimal("FActualPrice"));
                if (entry.getActualPrice() != null && entry.getActualPrice().compareTo(BigDecimal.ZERO) > 0) {
                    entry.setPurchasePrice(entry.getActualPrice());
                    BigDecimal trolleyCost = BigDecimal.ZERO;
                    if (entry.getPurchasePrice() != null) {
                        trolleyCost = entry.getTechnicalNumber().multiply(entry.getPurchasePrice()).setScale(2, RoundingMode.HALF_UP);
                    }
                    if (entry.getRiskAmount() != null) {
                        trolleyCost.add(entry.getRiskAmount());
                    }
                    entry.setPurchaseCost(trolleyCost);
                }
                billInfo.getEntrys().add(entry);
                ++count;
            }
            rs = DbUtil.executeQuery((Context)this.ctx, (String)("/*dialect*/ select count(*) as count from " + tempTable + " where fclasscodeid is null"));
            int noCount = 0;
            if (rs.next()) {
                noCount = rs.getInt("count");
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
        }
    }
}

