/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeChangeEntryCollection;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeChangeEntryInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeChangeInfo;
import com.kingdee.eas.industry.emm.pcm.app.AbstractProjectIncomeChangeControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectIncomeChangeControllerBean
extends AbstractProjectIncomeChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.ProjectIncomeChangeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeChangeInfo bill = (ProjectIncomeChangeInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectIncomeChangeInfo info = (ProjectIncomeChangeInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectIncomeChangeInfo info = (ProjectIncomeChangeInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectIncomeChangeInfo info = (ProjectIncomeChangeInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectIncomeChangeInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0005", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (eti.getProject() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0034", (Locale)ctx.getLocale()));
        }
        if (eti.getQty() == 0) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0035", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeChangeInfo billInfo = (ProjectIncomeChangeInfo)model;
        this.check(ctx, billInfo);
        this.checkEntrys(ctx, billInfo);
        if (billInfo.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && billInfo.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        billInfo.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, ProjectIncomeChangeInfo billInfo) throws EASBizException {
        ProjectIncomeChangeEntryCollection entrysColl = billInfo.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer errorSB = new StringBuffer();
            ProjectIncomeChangeEntryInfo piInfo = (ProjectIncomeChangeEntryInfo)entrysColl.getObject(i);
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectDomestic())) {
                piInfo.setProjectDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectOverseas())) {
                piInfo.setProjectOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectOverseasCNY())) {
                piInfo.setProjectOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleDomestic())) {
                piInfo.setVehicleDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleOverseas())) {
                piInfo.setVehicleOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleOverseasCNY())) {
                piInfo.setVehicleOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesDomestic())) {
                piInfo.setSparesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesOverseas())) {
                piInfo.setSparesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesOverseasCNY())) {
                piInfo.setSparesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsDomestic())) {
                piInfo.setToolsDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsOverseas())) {
                piInfo.setToolsOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsOverseasCNY())) {
                piInfo.setToolsOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesDomestic())) {
                piInfo.setServicesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesOverseas())) {
                piInfo.setServicesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesOverseasCNY())) {
                piInfo.setServicesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseDomestic())) {
                piInfo.setExpenseDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseOverseas())) {
                piInfo.setExpenseOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseOverseasCNY())) {
                piInfo.setExpenseOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherDomestic())) {
                piInfo.setOtherDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherOverseas())) {
                piInfo.setOtherOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherOverseasCNY())) {
                piInfo.setOtherOverseasCNY(BigDecimal.ZERO);
            }
            piInfo.setProjectTotal(piInfo.getProjectDomestic().add(piInfo.getProjectOverseasCNY()));
            piInfo.setVehicleTotal(piInfo.getVehicleDomestic().add(piInfo.getVehicleOverseasCNY()));
            piInfo.setSparesTotal(piInfo.getSparesDomestic().add(piInfo.getSparesOverseasCNY()));
            piInfo.setToolsTotal(piInfo.getToolsDomestic().add(piInfo.getToolsOverseasCNY()));
            piInfo.setServicesTotal(piInfo.getServicesDomestic().add(piInfo.getServicesOverseasCNY()));
            piInfo.setExpenseTotal(piInfo.getExpenseDomestic().add(piInfo.getExpenseOverseasCNY()));
            piInfo.setOtherTotal(piInfo.getOtherDomestic().add(piInfo.getOtherOverseasCNY()));
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjProjectDomestic())) {
                piInfo.setAdjProjectDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjProjectOverseas())) {
                piInfo.setAdjProjectOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjProjectOverseasCNY())) {
                piInfo.setAdjProjectOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjVehicleDomestic())) {
                piInfo.setAdjVehicleDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjVehicleOverseas())) {
                piInfo.setAdjVehicleOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjVehicleOverseasCNY())) {
                piInfo.setAdjVehicleOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjSparesDomestic())) {
                piInfo.setAdjSparesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjSparesOverseas())) {
                piInfo.setAdjSparesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjSparesOverseasCNY())) {
                piInfo.setAdjSparesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjToolsDomestic())) {
                piInfo.setAdjToolsDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjToolsOverseas())) {
                piInfo.setAdjToolsOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjToolsOverseasCNY())) {
                piInfo.setAdjToolsOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjServicesDomestic())) {
                piInfo.setAdjServicesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjServicesOverseas())) {
                piInfo.setAdjServicesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjServicesOverseasCNY())) {
                piInfo.setAdjServicesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjExpenseDomestic())) {
                piInfo.setAdjExpenseDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjExpenseOverseas())) {
                piInfo.setAdjExpenseOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjExpenseOverseasCNY())) {
                piInfo.setAdjExpenseOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjOtherDomestic())) {
                piInfo.setAdjOtherDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjOtherOverseas())) {
                piInfo.setAdjOtherOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getAdjOtherOverseasCNY())) {
                piInfo.setAdjOtherOverseasCNY(BigDecimal.ZERO);
            }
            piInfo.setAdjProjectTotal(piInfo.getAdjProjectDomestic().add(piInfo.getAdjProjectOverseasCNY()));
            piInfo.setAdjProjectAmount(piInfo.getAdjProjectTotal().subtract(piInfo.getProjectTotal()));
            piInfo.setAdjVehicleTotal(piInfo.getAdjVehicleDomestic().add(piInfo.getAdjVehicleOverseasCNY()));
            piInfo.setAdjVehicleAmount(piInfo.getAdjVehicleTotal().subtract(piInfo.getVehicleTotal()));
            piInfo.setAdjSparesTotal(piInfo.getAdjSparesDomestic().add(piInfo.getAdjSparesOverseasCNY()));
            piInfo.setAdjSparesAmount(piInfo.getAdjSparesTotal().subtract(piInfo.getSparesTotal()));
            piInfo.setAdjToolsTotal(piInfo.getAdjToolsDomestic().add(piInfo.getAdjToolsOverseasCNY()));
            piInfo.setAdjToolsAmount(piInfo.getAdjToolsTotal().subtract(piInfo.getToolsTotal()));
            piInfo.setAdjServicesTotal(piInfo.getAdjServicesDomestic().add(piInfo.getAdjServicesOverseasCNY()));
            piInfo.setAdjServicesAmount(piInfo.getAdjServicesTotal().subtract(piInfo.getServicesTotal()));
            piInfo.setAdjExpenseTotal(piInfo.getAdjExpenseDomestic().add(piInfo.getAdjExpenseOverseasCNY()));
            piInfo.setAdjExpenseAmount(piInfo.getAdjExpenseTotal().subtract(piInfo.getExpenseTotal()));
            piInfo.setAdjOtherTotal(piInfo.getAdjOtherDomestic().add(piInfo.getAdjOtherOverseasCNY()));
            piInfo.setAdjOtherAmount(piInfo.getAdjOtherTotal().subtract(piInfo.getOtherTotal()));
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeChangeInfo eti = (ProjectIncomeChangeInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }
}

