/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeEntryCollection;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeEntryInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectIncomeInfo;
import com.kingdee.eas.industry.emm.pcm.app.AbstractProjectIncomeControllerBean;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProjectIncomeControllerBean
extends AbstractProjectIncomeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.ProjectIncomeControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeInfo bill = (ProjectIncomeInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectIncomeInfo info = (ProjectIncomeInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectIncomeInfo info = (ProjectIncomeInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectIncomeInfo info = (ProjectIncomeInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectIncomeInfo eti) throws EASBizException, BOSException {
        StringBuffer errStr = new StringBuffer();
        if (eti.getNumber() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.PricePolicyAdjustResource", (String)"not_null_number", (Locale)ctx.getLocale()) + "\n");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0096", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0097", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getProject() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.qm.qc.NCRBizResource", (String)"ProjectIsNotNull", (Locale)ctx.getLocale()) + "\n");
        }
        if (eti.getProjectQty() == 0) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0036", (Locale)ctx.getLocale()) + "\n");
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeInfo billInfo = (ProjectIncomeInfo)model;
        this.check(ctx, billInfo);
        this.checkEntrys(ctx, billInfo);
        if (billInfo.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && billInfo.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        billInfo.setStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void checkEntrys(Context ctx, ProjectIncomeInfo billInfo) throws EASBizException {
        ProjectIncomeEntryCollection entrysColl = billInfo.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer errorSB = new StringBuffer();
            ProjectIncomeEntryInfo piInfo = (ProjectIncomeEntryInfo)entrysColl.getObject(i);
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectDomestic())) {
                piInfo.setProjectDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectOverseas())) {
                piInfo.setProjectOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getProjectOverseasCNY())) {
                piInfo.setProjectOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleDomestic())) {
                piInfo.setVehicleDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleOverseas())) {
                piInfo.setVehicleOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getVehicleOverseasCNY())) {
                piInfo.setVehicleOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesDomestic())) {
                piInfo.setSparesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesOverseas())) {
                piInfo.setSparesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getSparesOverseasCNY())) {
                piInfo.setSparesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsDomestic())) {
                piInfo.setToolsDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsOverseas())) {
                piInfo.setToolsOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getToolsOverseasCNY())) {
                piInfo.setToolsOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesDomestic())) {
                piInfo.setServicesDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesOverseas())) {
                piInfo.setServicesOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getServicesOverseasCNY())) {
                piInfo.setServicesOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseDomestic())) {
                piInfo.setExpenseDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseOverseas())) {
                piInfo.setExpenseOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getExpenseOverseasCNY())) {
                piInfo.setExpenseOverseasCNY(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherDomestic())) {
                piInfo.setOtherDomestic(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherOverseas())) {
                piInfo.setOtherOverseas(BigDecimal.ZERO);
            }
            if (PcmTreeBillHelper.isBigDecimalEmpty(piInfo.getOtherOverseasCNY())) {
                piInfo.setOtherOverseasCNY(BigDecimal.ZERO);
            }
            BigDecimal projectQty = new BigDecimal(billInfo.getProjectQty());
            piInfo.setProjectTotal(piInfo.getProjectDomestic().add(piInfo.getProjectOverseasCNY()));
            piInfo.setProjectPrice(piInfo.getProjectTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setVehicleTotal(piInfo.getVehicleDomestic().add(piInfo.getVehicleOverseasCNY()));
            piInfo.setVehiclePrice(piInfo.getVehicleTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setSparesTotal(piInfo.getSparesDomestic().add(piInfo.getSparesOverseasCNY()));
            piInfo.setSparesPrice(piInfo.getSparesTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setToolsTotal(piInfo.getToolsDomestic().add(piInfo.getToolsOverseasCNY()));
            piInfo.setToolsPrice(piInfo.getToolsTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setServicesTotal(piInfo.getServicesDomestic().add(piInfo.getServicesOverseasCNY()));
            piInfo.setServicesPrice(piInfo.getServicesTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setExpenseTotal(piInfo.getExpenseDomestic().add(piInfo.getExpenseOverseasCNY()));
            piInfo.setExpensePrice(piInfo.getExpenseTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
            piInfo.setOtherTotal(piInfo.getOtherDomestic().add(piInfo.getOtherOverseasCNY()));
            piInfo.setOtherPrice(piInfo.getOtherTotal().divide(projectQty).setScale(4, RoundingMode.HALF_UP));
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectIncomeInfo eti = (ProjectIncomeInfo)model;
        this.check(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return super._save(ctx, model);
    }
}

