/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class ProjectTargetCostBillBomTree {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private String RESURLOne = "com.kingdee.eas.industry.emm.lcm.LcmResource";
    public static final String TREE_BILL_FIXED = "TREE_BILL_FIXED";
    public static final String TREE_BOM_ID = "TREE_BOM_ID";
    public static final String TREE_EXPAND_FIXED = "Expand_FIXED";
    public static final String TREE_FIXED = "TREE_FIXED";
    public static final String TREE_ID = "TREE_ID";
    public static final String TREE_ISOWNOBJECT = "TREE_ISOWNOBJECT";
    public static final String TREE_LEVEL = "TREE_LEVEL";
    public static final String TREE_LEVEL_LONG_NUMBER = "level_long_number";
    public static final String TREE_LONG_NUMBER = "TREE_LONG_NUMBER";
    public static final String TREE_MATERIAL_ID = "TREE_MATERIAL_ID";
    public static final String TREE_MATERIAL_NAME = "TREE_MATERIAL_NAME";
    public static final String TREE_MATERIAL_NUMBER = "TREE_MATERIAL_NUMBER";
    public static final String TREE_MATERIAL_PROP = "TREE_MATERIAL_PROP";
    public static final String TREE_PARENT_FIXED = "TREE_PARENT_FIXED";
    public static final String TREE_PARENT_ID = "TREE_PARENT_ID";
    public static final String TREE_PARENT_MATERIAL_ID = "TREE_PARENT_MATERIAL_ID";
    public static final String TREE_PARENT_MATERIAL_NAME = "TREE_PARENT_MATERIAL_NAME";
    public static final String TREE_PARENT_MATERIAL_NUMBER = "TREE_PARENT_MATERIAL_NUMBER";
    public static final String TREE_PARENT_MATERIAL_PROP = "TREE_PARENT_MATERIAL_PROP";
    public static final String TREE_PROJECT_ID = "TREE_PROJECT_ID";
    public static final String TREE_TRACK_ID = "TREE_TRACK_ID";
    public static final String CFIsSplit = "FIsAssigned";
    public static final String Storage_OrgUnit_ID = "Storage_OrgUnit_ID";
    public static final String TREE_TRACK_NUMBER = "TREE_TRACK_NUMBER";
    protected Context ctx;
    protected Boolean filterBatch = false;
    protected MaterialInfo material;
    protected Map params;
    protected ProjectInfo project;
    protected String treeTable;
    protected String treeManuTable;
    protected String returNManuTable;

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        try {
            return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0037", (Locale)ctx.getLocale()), (Throwable)e);
        }
    }

    public static IRowSet executeQuery(Context ctx, String sql, List param) throws BOSException {
        if (param == null) {
            param = new ArrayList();
        }
        return DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])param.toArray());
    }

    public static int executeUpdate(Context ctx, String sql, List param) throws BOSException {
        if (param == null) {
            param = new ArrayList();
        }
        return DBUtil.executeUpdate((Context)ctx, (String)sql, (Object[])param.toArray());
    }

    public static void executeSql(Context ctx, String sql) throws BOSException {
        DbUtil.execute((Context)ctx, (String)sql);
    }

    public static void releaseTable(Context ctx, String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
    }

    public final void run(Context ctx, ProjectInfo project, MaterialInfo material, Map params) throws EASBizException {
        this.ctx = ctx;
        this.project = project;
        this.material = material;
        this.params = params;
        try {
            this.initTree();
            this.execute(this.returNManuTable, this.params);
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0038", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
        }
        finally {
            ProjectTargetCostBillBomTree.releaseTable(ctx, this.treeTable);
            ProjectTargetCostBillBomTree.releaseTable(ctx, this.treeManuTable);
            ProjectTargetCostBillBomTree.releaseTable(ctx, this.returNManuTable);
        }
    }

    protected abstract void execute(String var1, Map var2) throws Exception;

    protected String getTreeTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable( ");
        sql.append(TREE_ID).append(" NVARCHAR(200) Not Null,\r\n");
        sql.append(TREE_PARENT_ID).append(" NVARCHAR(200) Null,\r\n");
        sql.append(TREE_BOM_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PROJECT_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_TRACK_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_TRACK_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(Storage_OrgUnit_ID).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_LONG_NUMBER).append(" NVARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL_LONG_NUMBER).append(" VARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL).append(" INT Default 0 Not Null,");
        sql.append(TREE_EXPAND_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_BILL_FIXED).append(" Numeric(21,8) Default 0 Not Null ");
        sql.append(")");
        return sql.toString();
    }

    protected String getTreeManuTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandManuBOMTable( ");
        sql.append(TREE_ID).append(" NVARCHAR(200) Not Null,\r\n");
        sql.append(TREE_PARENT_ID).append(" NVARCHAR(200) Null,\r\n");
        sql.append(TREE_BOM_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PROJECT_ID).append(" VARCHAR(44) ,\r\n");
        sql.append(TREE_TRACK_ID).append(" VARCHAR(44) ,\r\n");
        sql.append(TREE_TRACK_NUMBER).append(" NVARCHAR(80) ,\r\n");
        sql.append(TREE_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(Storage_OrgUnit_ID).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_LONG_NUMBER).append(" NVARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL_LONG_NUMBER).append(" VARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL).append(" INT Default 0 Not Null,");
        sql.append(TREE_EXPAND_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_BILL_FIXED).append(" Numeric(21,8) Default 0 Not Null ");
        sql.append(")");
        return sql.toString();
    }

    protected String getTreeReturnTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandManuBOMTable( ");
        sql.append(TREE_ID).append(" NVARCHAR(200) Not Null,\r\n");
        sql.append(TREE_PARENT_ID).append(" NVARCHAR(200) Null,\r\n");
        sql.append(TREE_BOM_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PROJECT_ID).append(" VARCHAR(44) ,\r\n");
        sql.append(TREE_TRACK_ID).append(" VARCHAR(44) ,\r\n");
        sql.append(TREE_TRACK_NUMBER).append(" NVARCHAR(80) ,\r\n");
        sql.append(TREE_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(Storage_OrgUnit_ID).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_ID).append(" VARCHAR(44) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NAME).append(" NVARCHAR(100) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_NUMBER).append(" NVARCHAR(80) Not Null,\r\n");
        sql.append(TREE_PARENT_MATERIAL_PROP).append(" NVARCHAR(80) Null,\r\n");
        sql.append(TREE_PARENT_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_LONG_NUMBER).append(" NVARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL_LONG_NUMBER).append(" VARCHAR(2000) Not Null,");
        sql.append(TREE_LEVEL).append(" INT Default 0 Not Null,");
        sql.append(TREE_EXPAND_FIXED).append(" Numeric(21,8) Default 0 Not Null,");
        sql.append(TREE_BILL_FIXED).append(" Numeric(21,8) Default 0 Not Null ");
        sql.append(")");
        return sql.toString();
    }

    protected void initTree() throws Exception {
        String treeSql = this.getTreeTableSql();
        this.treeTable = ProjectTargetCostBillBomTree.createTempTable(this.ctx, treeSql);
        this.insertInto(this.ctx);
        this.insertMenuBOM();
        this.insertReturnBOM();
    }

    protected void insertReturnBOM() throws Exception {
        String treeSql = this.getTreeReturnTableSql();
        this.returNManuTable = ProjectTargetCostBillBomTree.createTempTable(this.ctx, treeSql);
        StringBuilder tempInsertSql = new StringBuilder();
        tempInsertSql.append(" insert into ").append(this.returNManuTable).append(" ( ").append(TREE_ID);
        tempInsertSql.append(",").append(TREE_PARENT_ID);
        tempInsertSql.append(",").append(TREE_BOM_ID);
        tempInsertSql.append(",").append(TREE_PROJECT_ID);
        tempInsertSql.append(",").append(TREE_TRACK_ID);
        tempInsertSql.append(",").append(TREE_TRACK_NUMBER);
        tempInsertSql.append(",").append(TREE_MATERIAL_ID);
        tempInsertSql.append(",").append(TREE_MATERIAL_NAME);
        tempInsertSql.append(",").append(TREE_MATERIAL_NUMBER);
        tempInsertSql.append(",").append(TREE_MATERIAL_PROP);
        tempInsertSql.append(",").append(TREE_FIXED);
        tempInsertSql.append(",").append(Storage_OrgUnit_ID);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_ID);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_NAME);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_PROP);
        tempInsertSql.append(",").append(TREE_PARENT_FIXED);
        tempInsertSql.append(",").append(TREE_LONG_NUMBER);
        tempInsertSql.append(",").append(TREE_LEVEL_LONG_NUMBER);
        tempInsertSql.append(",").append(TREE_LEVEL);
        tempInsertSql.append(",").append(TREE_EXPAND_FIXED);
        tempInsertSql.append(",").append(TREE_BILL_FIXED);
        tempInsertSql.append(") (select c.");
        tempInsertSql.append(TREE_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_ID);
        tempInsertSql.append(", c.").append(TREE_BOM_ID);
        tempInsertSql.append(", c.").append(TREE_PROJECT_ID);
        tempInsertSql.append(", c.").append(TREE_TRACK_ID);
        tempInsertSql.append(", c.").append(TREE_TRACK_NUMBER);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_ID);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_NAME);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_NUMBER);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_PROP);
        tempInsertSql.append(", c.").append(TREE_FIXED);
        tempInsertSql.append(", c.").append(Storage_OrgUnit_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_NAME);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_NUMBER);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_PROP);
        tempInsertSql.append(", c.").append(TREE_PARENT_FIXED);
        tempInsertSql.append(", c.").append(TREE_LONG_NUMBER);
        tempInsertSql.append(", c.").append(TREE_LEVEL_LONG_NUMBER);
        tempInsertSql.append(", c.").append(TREE_LEVEL);
        tempInsertSql.append(", c.").append(TREE_EXPAND_FIXED);
        tempInsertSql.append(", c.").append(TREE_BILL_FIXED);
        tempInsertSql.append("  from ");
        tempInsertSql.append(this.treeManuTable).append(" c where c.tree_id not in (select a.tree_id from ");
        tempInsertSql.append(this.treeManuTable).append(" a  where a.tree_id  in(select b.tree_parent_id from ").append(this.treeManuTable).append(" b)");
        tempInsertSql.append(" ))");
        int countnum = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, tempInsertSql.toString(), null);
    }

    protected void insertMenuBOM() throws Exception {
        String treeSql = this.getTreeManuTableSql();
        this.treeManuTable = ProjectTargetCostBillBomTree.createTempTable(this.ctx, treeSql);
        StringBuilder tempInsertSql = new StringBuilder();
        tempInsertSql.append(" insert into ").append(this.treeManuTable).append(" ( ").append(TREE_ID);
        tempInsertSql.append(",").append(TREE_PARENT_ID);
        tempInsertSql.append(",").append(TREE_BOM_ID);
        tempInsertSql.append(",").append(TREE_PROJECT_ID);
        tempInsertSql.append(",").append(TREE_TRACK_ID);
        tempInsertSql.append(",").append(TREE_TRACK_NUMBER);
        tempInsertSql.append(",").append(TREE_MATERIAL_ID);
        tempInsertSql.append(",").append(TREE_MATERIAL_NAME);
        tempInsertSql.append(",").append(TREE_MATERIAL_NUMBER);
        tempInsertSql.append(",").append(TREE_MATERIAL_PROP);
        tempInsertSql.append(",").append(TREE_FIXED);
        tempInsertSql.append(",").append(Storage_OrgUnit_ID);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_ID);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_NAME);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        tempInsertSql.append(",").append(TREE_PARENT_MATERIAL_PROP);
        tempInsertSql.append(",").append(TREE_PARENT_FIXED);
        tempInsertSql.append(",").append(TREE_LONG_NUMBER);
        tempInsertSql.append(",").append(TREE_LEVEL_LONG_NUMBER);
        tempInsertSql.append(",").append(TREE_LEVEL);
        tempInsertSql.append(",").append(TREE_EXPAND_FIXED);
        tempInsertSql.append(",").append(TREE_BILL_FIXED);
        tempInsertSql.append(") (select c.");
        tempInsertSql.append(TREE_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_ID);
        tempInsertSql.append(", c.").append(TREE_BOM_ID);
        tempInsertSql.append(", c.").append(TREE_PROJECT_ID);
        tempInsertSql.append(", c.").append(TREE_TRACK_ID);
        tempInsertSql.append(", c.").append(TREE_TRACK_NUMBER);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_ID);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_NAME);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_NUMBER);
        tempInsertSql.append(", c.").append(TREE_MATERIAL_PROP);
        tempInsertSql.append(", c.").append(TREE_FIXED);
        tempInsertSql.append(", c.").append(Storage_OrgUnit_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_ID);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_NAME);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_NUMBER);
        tempInsertSql.append(", c.").append(TREE_PARENT_MATERIAL_PROP);
        tempInsertSql.append(", c.").append(TREE_PARENT_FIXED);
        tempInsertSql.append(", c.").append(TREE_LONG_NUMBER);
        tempInsertSql.append(", c.").append(TREE_LEVEL_LONG_NUMBER);
        tempInsertSql.append(", c.").append(TREE_LEVEL);
        tempInsertSql.append(", c.").append(TREE_EXPAND_FIXED);
        tempInsertSql.append(", c.").append(TREE_BILL_FIXED);
        tempInsertSql.append("  from ");
        tempInsertSql.append(this.treeTable).append(" c where c.tree_id not in (select a.tree_id from ");
        tempInsertSql.append(this.treeTable).append(" a  where a.tree_id  in(select b.tree_parent_id from ").append(this.treeTable).append(" b)");
        tempInsertSql.append(" ))");
        int countnum = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, tempInsertSql.toString(), null);
        int level = 1;
        StringBuilder insert = new StringBuilder();
        insert.append(" update ").append(this.treeManuTable).append(" set ").append(TREE_ID).append(" = " + level).append("||'-'||rownum ");
        insert.append(", ").append(TREE_PARENT_ID).append("= null");
        insert.append(", ").append(TREE_LEVEL).append("=" + level);
        insert.append(", ").append(TREE_LEVEL_LONG_NUMBER).append("=( right(power(10,5-length(rownum))||'',5-length(rownum))||rownum)");
        int count = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, insert.toString(), null);
        this.insertMenuBOM(level + 1, count);
    }

    protected void insertMenuBOM(int level, int count) throws Exception {
        if (level == 30) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"CENG", (Locale)this.ctx.getLocale(), (Object[])new Object[]{level});
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0039", (Locale)this.ctx.getLocale()) + strInfo + "," + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0040", (Locale)this.ctx.getLocale())));
        }
        if (count == 0) {
            return;
        }
        StringBuilder insert = new StringBuilder();
        insert.append("insert into ").append(this.treeManuTable).append(" (");
        insert.append(TREE_ID);
        insert.append(",").append(TREE_PARENT_ID);
        insert.append(",").append(TREE_BOM_ID);
        insert.append(",").append(TREE_PROJECT_ID);
        insert.append(",").append(TREE_TRACK_ID);
        insert.append(",").append(TREE_TRACK_NUMBER);
        insert.append(",").append(TREE_MATERIAL_ID);
        insert.append(",").append(TREE_MATERIAL_NAME);
        insert.append(",").append(TREE_MATERIAL_NUMBER);
        insert.append(",").append(TREE_MATERIAL_PROP);
        insert.append(",").append(TREE_FIXED);
        insert.append(",").append(Storage_OrgUnit_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",").append(TREE_PARENT_FIXED);
        insert.append(",").append(TREE_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL);
        insert.append(",").append(TREE_EXPAND_FIXED);
        insert.append(",").append(TREE_BILL_FIXED);
        insert.append(") (select ");
        insert.append("'").append(level).append("-'||rownum").append(" AS ").append(TREE_ID);
        insert.append(",tree.").append(TREE_ID).append(" AS ").append(TREE_PARENT_ID);
        insert.append(",bom.fid").append(" AS ").append(TREE_BOM_ID);
        insert.append(",bom.FProjectID").append(" AS ").append(TREE_PROJECT_ID);
        insert.append(",stn.fid").append(" AS ").append(TREE_TRACK_ID);
        insert.append(",stn.fnumber").append(" AS ").append(TREE_TRACK_NUMBER);
        insert.append(",me.fid").append(" AS ").append(TREE_MATERIAL_ID);
        insert.append(",me.fname_l2").append(" AS ").append(TREE_MATERIAL_NAME);
        insert.append(",me.fnumber").append(" AS ").append(TREE_MATERIAL_NUMBER);
        insert.append(",bomEntry.FmaterialProp ").append(" AS ").append(TREE_MATERIAL_PROP);
        insert.append(",bomEntry.FconsumefixQty ").append(" AS ").append(TREE_FIXED);
        insert.append(",bomEntry.FSupplyStorageOrgUnitID ").append(" AS ").append(Storage_OrgUnit_ID);
        insert.append(",tree.").append(TREE_MATERIAL_ID).append(" AS ").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",tree.").append(TREE_MATERIAL_NAME).append(" AS ").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",tree.").append(TREE_MATERIAL_NUMBER).append(" AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",tree.").append(TREE_MATERIAL_PROP).append(" AS ").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",tree.").append(TREE_FIXED).append(" AS ").append(TREE_PARENT_FIXED);
        insert.append(",tree.").append(TREE_LONG_NUMBER).append(" AS ").append(TREE_LONG_NUMBER);
        insert.append(",tree.").append(TREE_LEVEL_LONG_NUMBER).append("||'.'||(case when bomEntry.CFfixseq is not null then right(power(10,5-length(bomEntry.CFfixseq))||'',5-length(bomEntry.CFfixseq))||bomEntry.CFfixseq else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
        insert.append(",").append(level).append(" AS ").append(TREE_LEVEL);
        insert.append(", isnull(bomEntry.FconsumefixQty,0)*").append(" tree.").append(TREE_EXPAND_FIXED);
        insert.append(",  isnull(bomEntry.FconsumefixQty,0)*").append(" tree.").append(TREE_BILL_FIXED);
        insert.append(" from T_MM_BomEntry bomEntry ");
        insert.append(" left join T_MM_Bom bom on bomEntry.fparentid=bom.fid ");
        insert.append(" left join T_BD_Material me on me.fid = bomEntry.FMaterialID");
        insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bomEntry.FBEGINCARNOID");
        insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bomEntry.FENDCARNOID");
        insert.append(" , ").append(this.treeManuTable).append(" tree ");
        ArrayList<Integer> param = new ArrayList<Integer>();
        insert.append(" where 1=1 ");
        insert.append(" and tree.").append(TREE_MATERIAL_ID).append(" = bom.FmaterialID");
        insert.append(" and tree.").append(Storage_OrgUnit_ID).append(" = bom.FStorageOrgUnitID ");
        insert.append(" and tree.").append(TREE_ID).append(" is not null");
        insert.append(" and tree.").append(TREE_LEVEL).append(" = ?");
        param.add(level - 1);
        insert.append(" and bom.fbasestatus = ?");
        param.add(4);
        insert.append(" ) ");
        count = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, insert.toString(), param);
        this.updateLongNumber(level, this.treeManuTable);
        this.insertMenuBOM(level + 1, count);
    }

    protected void insertInto(Context ctx) throws Exception {
        String Planning = EASResource.getString((String)this.RESURLOne, (String)"Planning", (Locale)ctx.getLocale());
        String Virtual = EASResource.getString((String)this.RESURLOne, (String)"Virtual", (Locale)ctx.getLocale());
        String HomeMade = EASResource.getString((String)this.RESURLOne, (String)"HomeMade", (Locale)ctx.getLocale());
        String OutSourcing = EASResource.getString((String)this.RESURLOne, (String)"OutSourcing", (Locale)ctx.getLocale());
        String Entrust_OutSide = EASResource.getString((String)this.RESURLOne, (String)"Entrust_OutSide", (Locale)ctx.getLocale());
        String Other = EASResource.getString((String)this.RESURLOne, (String)"Other", (Locale)ctx.getLocale());
        TrackNumberInfo trackNumInfo = (TrackNumberInfo)this.params.get("tracknumber_tmp");
        String tempSql = this.getTempTableSql();
        String tempTable = ProjectTargetCostBillBomTree.createTempTable(this.ctx, tempSql);
        StringBuilder tempInsertSql = new StringBuilder();
        tempInsertSql.append(" insert into ").append(tempTable).append("  select ");
        tempInsertSql.append(" distinct bom.fid ");
        tempInsertSql.append(" from T_MM_Bom bom ");
        tempInsertSql.append(this.getWhereCon());
        int countnum = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, tempInsertSql.toString(), null);
        boolean level = true;
        StringBuilder insert = new StringBuilder();
        insert.append("insert into ").append(this.treeTable).append(" (");
        insert.append(TREE_ID);
        insert.append(",").append(TREE_PARENT_ID);
        insert.append(",").append(TREE_BOM_ID);
        insert.append(",").append(TREE_PROJECT_ID);
        insert.append(",").append(TREE_TRACK_ID);
        insert.append(",").append(TREE_TRACK_NUMBER);
        insert.append(",").append(TREE_MATERIAL_ID);
        insert.append(",").append(TREE_MATERIAL_NAME);
        insert.append(",").append(TREE_MATERIAL_NUMBER);
        insert.append(",").append(TREE_MATERIAL_PROP);
        insert.append(",").append(TREE_FIXED);
        insert.append(",").append(Storage_OrgUnit_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",").append(TREE_PARENT_FIXED);
        insert.append(",").append(TREE_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL);
        insert.append(",").append(TREE_EXPAND_FIXED);
        insert.append(",").append(TREE_BILL_FIXED);
        insert.append(")  (select ");
        insert.append("'").append(1).append("-'||rownum ").append(" AS ").append(TREE_ID);
        insert.append(",null").append(" AS ").append(TREE_PARENT_ID);
        insert.append(",bom.fid ").append(" AS ").append(TREE_BOM_ID);
        insert.append(",bom.FProjectID ").append(" AS ").append(TREE_PROJECT_ID);
        insert.append(", '").append(trackNumInfo.getId().toString() + "' AS ").append(TREE_TRACK_ID);
        insert.append(", '").append(trackNumInfo.getNumber() + "' AS ").append(TREE_TRACK_NUMBER);
        insert.append(",m.fid").append(" AS ").append(TREE_MATERIAL_ID);
        insert.append(",m.fname_l2").append(" AS ").append(TREE_MATERIAL_NAME);
        insert.append(",m.fnumber").append(" AS ").append(TREE_MATERIAL_NUMBER);
        insert.append(",( Case TO_CHAR((Select fmaterialattr From T_BD_MaterialPlan where fmaterialid = m.fid And FOrgUnit =bom.FStorageOrgUnitID And Rownum = 1 ))   when '10010' then 'Planning' when '10020' then 'Virtual'  when '10030' then 'HomeMade'  when '10040' then 'OutSourcing'  when '10050' then 'Entrust_OutSide' when '10060' then 'Other'  else ''  end ) ").append(" AS ").append(TREE_MATERIAL_PROP);
        insert.append(",1").append(" AS ").append(TREE_FIXED);
        insert.append(",bom.FStorageOrgUnitID ").append(" AS ").append(Storage_OrgUnit_ID);
        insert.append(",'").append(this.material.getId().toString()).append("' AS ").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",'").append(this.material.getName()).append("' AS ").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",'").append(this.material.getNumber()).append("' AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",( Case TO_CHAR((Select fmaterialattr From T_BD_MaterialPlan where fmaterialid = '" + this.material.getId().toString() + "' And FOrgUnit =bom.FStorageOrgUnitID And Rownum = 1 ))   when '10010' then 'Planning' when '10020' then 'Virtual'  when '10030' then 'HomeMade'  when '10040' then 'OutSourcing'  when '10050' then 'Entrust_OutSide' when '10060' then 'Other'  else ''  end ) As ").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",1").append(" AS ").append(TREE_PARENT_FIXED);
        insert.append(",' '").append(" AS ").append(TREE_LONG_NUMBER);
        insert.append(", ( right(power(10,5-length(rownum))||'',5-length(rownum))||rownum) ");
        insert.append(", ").append(1).append(" AS ").append(TREE_LEVEL);
        insert.append(",1 ").append(" AS ").append(TREE_EXPAND_FIXED);
        insert.append(",1 ").append(" AS ").append(TREE_BILL_FIXED);
        insert.append(" from ").append(tempTable).append(" tempTable left join T_MM_Bom bom on bom.fid=tempTable.FBOMID ");
        insert.append(" left join T_BD_Material m on m.fid = bom.FMaterialID ");
        insert.append(" )");
        int count = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, insert.toString(), null);
        ProjectTargetCostBillBomTree.releaseTable(ctx, tempTable);
        this.updateLongNumber(1, this.treeTable);
        this.insertInto(2, count);
    }

    protected String getTempTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTempTable( ");
        sql.append(" FBOMID NVARCHAR(200) Not Null ");
        sql.append(")");
        return sql.toString();
    }

    protected String getWhereCon() {
        StringBuilder sqlWhere = new StringBuilder();
        sqlWhere.append(" left join T_MM_BomEntry bomEntry on bomEntry.fparentid=bom.fid ");
        sqlWhere.append(" left join T_BD_Material me on me.fid = bomEntry.FMaterialID");
        sqlWhere.append(" left join T_BD_MaterialPlan maPlan on maPlan.fmaterialid=bomEntry.FMATERIALID ");
        sqlWhere.append(" left join T_BD_Material m on m.fid = bom.FMaterialID");
        sqlWhere.append(" left join T_MM_TrackNumber stn on stn.FID=bomEntry.FBEGINCARNOID");
        sqlWhere.append(" left join T_MM_TrackNumber etn on etn.FID=bomEntry.FENDCARNOID");
        sqlWhere.append(" where 1=1");
        sqlWhere.append(" and stn.FNumber <= '");
        sqlWhere.append(this.params.get("prmtTrackBegin"));
        sqlWhere.append("' and etn.FNumber >= '");
        sqlWhere.append(this.params.get("prmtTrackEnd"));
        sqlWhere.append("' and bom.FbaseStatus = ");
        sqlWhere.append(4);
        sqlWhere.append(" and bom.FProjectID = '");
        sqlWhere.append(this.project.getId().toString());
        sqlWhere.append("' AND bom.FBOMTYPE =50 ");
        sqlWhere.append(" and NOT EXISTS  (SELECT 1 FROM T_MM_BomEntry C,T_MM_Bom D WHERE C.FPARENTID = D.FID  AND C.FMaterialID = bom.FMaterialID AND D.FProjectID = bom.FProjectID  AND C.FSupplyStorageOrgUnitID = bom.FStorageOrgUnitID )");
        return sqlWhere.toString();
    }

    protected void insertInto(int level, int count) throws Exception {
        if (level == 30) {
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"CENG", (Locale)this.ctx.getLocale(), (Object[])new Object[]{level});
            throw new EASBizException(new NumericExceptionSubItem("id_error", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0039", (Locale)this.ctx.getLocale()) + strInfo + "," + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0040", (Locale)this.ctx.getLocale())));
        }
        if (count == 0) {
            return;
        }
        StringBuilder insert = new StringBuilder();
        insert.append("insert into ").append(this.treeTable).append(" (");
        insert.append(TREE_ID);
        insert.append(",").append(TREE_PARENT_ID);
        insert.append(",").append(TREE_BOM_ID);
        insert.append(",").append(TREE_PROJECT_ID);
        insert.append(",").append(TREE_TRACK_ID);
        insert.append(",").append(TREE_TRACK_NUMBER);
        insert.append(",").append(TREE_MATERIAL_ID);
        insert.append(",").append(TREE_MATERIAL_NAME);
        insert.append(",").append(TREE_MATERIAL_NUMBER);
        insert.append(",").append(TREE_MATERIAL_PROP);
        insert.append(",").append(TREE_FIXED);
        insert.append(",").append(Storage_OrgUnit_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",").append(TREE_PARENT_FIXED);
        insert.append(",").append(TREE_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL_LONG_NUMBER);
        insert.append(",").append(TREE_LEVEL);
        insert.append(",").append(TREE_EXPAND_FIXED);
        insert.append(",").append(TREE_BILL_FIXED);
        insert.append(") (select ");
        insert.append("'").append(level).append("-'||rownum").append(" AS ").append(TREE_ID);
        insert.append(",tree.").append(TREE_ID).append(" AS ").append(TREE_PARENT_ID);
        insert.append(",bom.fid").append(" AS ").append(TREE_BOM_ID);
        insert.append(",bom.FProjectID").append(" AS ").append(TREE_PROJECT_ID);
        insert.append(",stn.fid").append(" AS ").append(TREE_TRACK_ID);
        insert.append(",stn.fnumber").append(" AS ").append(TREE_TRACK_NUMBER);
        insert.append(",me.fid").append(" AS ").append(TREE_MATERIAL_ID);
        insert.append(",me.fname_l2").append(" AS ").append(TREE_MATERIAL_NAME);
        insert.append(",me.fnumber").append(" AS ").append(TREE_MATERIAL_NUMBER);
        insert.append(",bomEntry.FmaterialProp ").append(" AS ").append(TREE_MATERIAL_PROP);
        insert.append(",bomEntry.FconsumefixQty ").append(" AS ").append(TREE_FIXED);
        insert.append(",bomEntry.FSupplyStorageOrgUnitID ").append(" AS ").append(Storage_OrgUnit_ID);
        insert.append(",tree.").append(TREE_MATERIAL_ID).append(" AS ").append(TREE_PARENT_MATERIAL_ID);
        insert.append(",tree.").append(TREE_MATERIAL_NAME).append(" AS ").append(TREE_PARENT_MATERIAL_NAME);
        insert.append(",tree.").append(TREE_MATERIAL_NUMBER).append(" AS ").append(TREE_PARENT_MATERIAL_NUMBER);
        insert.append(",tree.").append(TREE_MATERIAL_PROP).append(" AS ").append(TREE_PARENT_MATERIAL_PROP);
        insert.append(",tree.").append(TREE_FIXED).append(" AS ").append(TREE_PARENT_FIXED);
        insert.append(",tree.").append(TREE_LONG_NUMBER).append(" AS ").append(TREE_LONG_NUMBER);
        insert.append(",tree.").append(TREE_LEVEL_LONG_NUMBER).append("||'.'||(case when bomEntry.CFfixseq is not null then right(power(10,5-length(bomEntry.CFfixseq))||'',5-length(bomEntry.CFfixseq))||bomEntry.CFfixseq else right(power(10,5-length(rownum))||'',5-length(rownum))||rownum end)");
        insert.append(",").append(level).append(" AS ").append(TREE_LEVEL);
        insert.append(", isnull(bomEntry.FconsumefixQty,0)*").append(" tree.").append(TREE_EXPAND_FIXED);
        insert.append(",  isnull(bomEntry.FconsumefixQty,0)*").append(" tree.").append(TREE_BILL_FIXED);
        insert.append(" from T_MM_BomEntry bomEntry ");
        insert.append(" left join T_MM_Bom bom on bomEntry.fparentid=bom.fid ");
        insert.append(" left join T_BD_Material me on me.fid = bomEntry.FMaterialID");
        insert.append(" left Join T_MM_TrackNumber stn on stn.FID=bomEntry.FBEGINCARNOID");
        insert.append(" left Join T_MM_TrackNumber etn on etn.FID=bomEntry.FENDCARNOID");
        insert.append(" , ").append(this.treeTable).append(" tree ");
        ArrayList<Integer> param = new ArrayList<Integer>();
        insert.append(" where 1=1 ");
        insert.append(" and tree.").append(TREE_MATERIAL_ID).append(" = bom.FmaterialID");
        insert.append(" and tree.").append(Storage_OrgUnit_ID).append(" = bom.FStorageOrgUnitID ");
        if (level == 2) {
            insert.append(" and bom.fid= tree.TREE_BOM_ID");
        }
        insert.append(" and bomEntry.FMaterialProp= 10030");
        insert.append(" and tree.").append(TREE_ID).append(" is not null");
        insert.append(" and tree.").append(TREE_LEVEL).append(" = ?");
        param.add(level - 1);
        insert.append(" and bom.fbasestatus = ?");
        param.add(4);
        insert.append(" ) ");
        count = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, insert.toString(), param);
        this.updateLongNumber(level, this.treeTable);
        this.insertInto(level + 1, count);
    }

    protected void updateFixed(String tableStr) throws Exception {
        int count;
        StringBuilder sql = new StringBuilder();
        sql.append("select ").append(TREE_EXPAND_FIXED);
        sql.append(" from ").append(tableStr).append(" tree");
        sql.append(" where tree.").append(TREE_ID).append(" = ").append(tableStr).append(".").append(TREE_PARENT_ID);
        String tree_expand_fixed_sql = sql.toString();
        String tree_bill_fixed_sql = tree_expand_fixed_sql.replaceFirst(TREE_EXPAND_FIXED, TREE_BILL_FIXED);
        ArrayList<Integer> param = new ArrayList<Integer>();
        int level = 1;
        sql.setLength(0);
        sql.append("update ").append(tableStr).append(" set ");
        sql.append(" ").append(TREE_EXPAND_FIXED).append(" = ");
        sql.append(" ( case when ").append(TREE_PARENT_ID).append(" is null then ").append(TREE_FIXED).append(" else (").append(tree_expand_fixed_sql).append(") * ").append(TREE_FIXED).append(" end )");
        sql.append(" where ").append(TREE_LEVEL).append(" = ?");
        String update_fixed_sql = sql.toString();
        do {
            param.clear();
            param.add(level);
            count = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, update_fixed_sql, param);
            ++level;
        } while (count > 0);
    }

    protected void updateLongNumber(int level, String tableStr) throws Exception {
        StringBuilder sql = new StringBuilder();
        String longNumber = sql.append("'!!'||").append(TREE_MATERIAL_NUMBER).append("||'!!'").toString();
        sql.setLength(0);
        sql.append("select ");
        sql.append(TREE_MATERIAL_NUMBER);
        sql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        sql.append(",min(").append(TREE_TRACK_NUMBER).append(") ").append(" AS b_").append(TREE_TRACK_NUMBER);
        sql.append(",max(").append(TREE_TRACK_NUMBER).append(") ").append(" AS e_").append(TREE_TRACK_NUMBER);
        sql.append(" from (");
        sql.append("select ");
        sql.append(TREE_MATERIAL_NUMBER);
        sql.append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        sql.append(",").append(TREE_TRACK_NUMBER);
        sql.append(",").append(TREE_LONG_NUMBER);
        sql.append(",'%'||").append(longNumber).append("||'%' AS addLongNumber");
        sql.append(" from ").append(tableStr);
        sql.append(" where ").append(TREE_LONG_NUMBER).append(" is not null");
        sql.append(" and ").append(TREE_LEVEL).append(" = ").append(level);
        sql.append(" ) tree");
        sql.append(" where ").append(TREE_LONG_NUMBER).append(" like addLongNumber");
        sql.append(" group by ").append(TREE_MATERIAL_NUMBER).append(",").append(TREE_PARENT_MATERIAL_NUMBER);
        IRowSet rows = ProjectTargetCostBillBomTree.executeQuery(this.ctx, sql.toString(), null);
        StringBuilder error = new StringBuilder();
        while (rows.next()) {
            if (error.length() <= 0) {
                error.append("\n").append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0041", (Locale)this.ctx.getLocale())).append("\n");
            }
            error.append(rows.getString(TREE_MATERIAL_NUMBER)).append("    ");
            error.append(rows.getString(TREE_PARENT_MATERIAL_NUMBER)).append("    ");
            error.append(rows.getString("b_TREE_TRACK_NUMBER")).append(" - ").append(rows.getString("e_TREE_TRACK_NUMBER")).append("\n");
        }
        if (error.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0042", (Locale)this.ctx.getLocale()) + "[" + this.project.getName() + "]" + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0043", (Locale)this.ctx.getLocale()) + "," + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0044", (Locale)this.ctx.getLocale()) + ":\n" + error.toString()));
        }
        sql.setLength(0);
        sql.append("update ").append(tableStr).append(" set ");
        sql.append(TREE_LONG_NUMBER).append(" = ");
        sql.append(TREE_LONG_NUMBER).append("||").append(longNumber);
        sql.append(" where ").append(TREE_LEVEL).append(" = ").append(level);
        ProjectTargetCostBillBomTree.executeUpdate(this.ctx, sql.toString(), null);
    }
}

