/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.PurchaseAttrEnum;
import com.kingdee.eas.industry.emm.pcm.app.AbstractProjectTargetCostBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.app.ProjectTargetCostBillBomTree;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.zjbom.app.util.ProcessBomTree;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProjectTargetCostBillControllerBean
extends AbstractProjectTargetCostBillControllerBean {
    private String RESURLTWO = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.ProjectTargetCostBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo bill = (ProjectTargetCostBillInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectTargetCostBillInfo info = (ProjectTargetCostBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ProjectTargetCostBillInfo info = (ProjectTargetCostBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0002", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo info = (ProjectTargetCostBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, ProjectTargetCostBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getAdminOrgUnit() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0005", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo eti = (ProjectTargetCostBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        for (int i = 0; i < eti.getEntrys().size(); ++i) {
            ProjectTargetCostBillEntryInfo entry = eti.getEntrys().get(i);
            if (entry.isIsPriceLimit() && entry.getMaterial() == null) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{entry.getSeq()});
                throw new EASBizException(new NumericExceptionSubItem("", strInfo + "," + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0045", (Locale)ctx.getLocale()) + "," + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0046", (Locale)ctx.getLocale())));
            }
            entry.setIsMainRow(true);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _submitForPurchase(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected void checkEntrys(Context ctx, ProjectTargetCostBillInfo eti) throws EASBizException, BOSException {
        String error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
        ProjectTargetCostBillEntryCollection entrysColl = eti.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            ProjectTargetCostBillEntryInfo entry;
            StringBuffer tmpStr = new StringBuffer();
            IObjectValue materialEntry = entrysColl.getObject(i);
            if (materialEntry.get("responsibilityCenter") == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0047", (Locale)ctx.getLocale()));
            }
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            boolean isPackageRow = materialEntry.getBoolean("isPackageRow");
            if (!isTotalRow && PcmTreeBillHelper.isBigDecimalEmptyAndZero((entry = (ProjectTargetCostBillEntryInfo)entrysColl.getObject(i)).getTargetCoeff())) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0048", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() <= 0) continue;
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0021", (Locale)ctx.getLocale()) + strInfo + "," + tmpStr.toString()));
        }
    }

    private boolean isLeafOfParent(ClassificationCodeInfo children, ClassificationCodeInfo parent) {
        if (children == null || parent == null) {
            return false;
        }
        if (children.getLongNumber().equals(parent.getLongNumber())) {
            return true;
        }
        String childrenLongNumber = children.getLongNumber();
        String parentNumber = parent.getNumber();
        String[] parentStrs = childrenLongNumber.split("!");
        for (int i = 0; i < parentStrs.length - 1; ++i) {
            if (!parentStrs[i].equals(parentNumber)) continue;
            return true;
        }
        return false;
    }

    protected void materialEntryBeforeSave(Context ctx, ProjectTargetCostBillInfo model) throws EASBizException, BOSException {
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)model, ctx);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo eti = (ProjectTargetCostBillInfo)model;
        this.check(ctx, eti);
        this.checkEntrys(ctx, eti);
        this.materialEntryBeforeSave(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        this.setDefaultValue(ctx, eti);
        return super._save(ctx, model);
    }

    private void setDefaultValue(Context ctx, ProjectTargetCostBillInfo eti) {
        ProjectTargetCostBillEntryCollection c = eti.getEntrys();
        for (int i = 0; i < c.size(); ++i) {
            ProjectTargetCostBillEntryInfo cc = c.get(i);
            if (cc.getTrolleyQtyPurchase() == null) {
                cc.setTrolleyQtyPurchase(cc.getTechTrolleyQty());
            }
            if (cc.getTrolleyPricePurchase() != null) continue;
            cc.setTrolleyPricePurchase(cc.getEstimateUnitPrice());
        }
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo ebi = (ProjectTargetCostBillInfo)objectValue;
        if (ebi.getLabourEntry().size() == 1 && ebi.getLabourEntry().get(0).getExpenseDept() == null) {
            ebi.getLabourEntry().remove(ebi.getLabourEntry().get(0));
        }
        String CGZX = EASResource.getString((String)this.RESURLTWO, (String)"CGZX", (Locale)ctx.getLocale());
        if (ebi.getEntrys() != null && ebi.getEntrys().size() > 0) {
            for (int i = 0; i < ebi.getEntrys().size(); ++i) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)"CGZX", CompareType.LIKE));
                ev.setFilter(filter);
                AdminOrgUnitCollection a = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(ev);
                AdminOrgUnitInfo adminInfo = a.get(0);
                ebi.getEntrys().get(i).setResponsibilityCenter(adminInfo);
            }
        }
    }

    protected void _handleAfterTransform(Context context, String s, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this._handleAfterTransform(context, s, coll.getObject(i));
            }
        }
    }

    @Override
    protected Map _exBom(Context ctx, Map map) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo billInfo = (ProjectTargetCostBillInfo)map.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)map.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)map.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)map.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            BomTree tree = new BomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("sql_tmp", map.get("sql"));
            params.put("projectType_tmp", map.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    protected String getTempTableSql(Context ctx) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("Create Table ExpandBOMTable(\r\n");
        sql.append("FClassCodeID varchar(44) ,\r\n");
        sql.append("FMaterialID varchar(44) ,\r\n");
        sql.append("FMaterialNumber VARCHAR(250) ,\r\n");
        sql.append("FMaterialName VARCHAR(250) Null,\r\n");
        sql.append("FMaterialModel VARCHAR(250) Null,\r\n");
        sql.append("FUnitID VARCHAR(44) Null,\r\n");
        sql.append("FUnitName  VARCHAR(250) Null,\r\n");
        sql.append("FFlow VARCHAR(250) Null,\r\n");
        sql.append("FPrice Numeric(21,8) Null,\r\n");
        sql.append("FDeQty Numeric(21,8) Null\r\n");
        sql.append(")");
        return sql.toString();
    }

    @Override
    protected Map _exManuBom(Context ctx, Map paramMap) throws BOSException, EASBizException {
        ProjectTargetCostBillInfo billInfo = (ProjectTargetCostBillInfo)paramMap.get("billInfo");
        HashMap reMap = new HashMap();
        try {
            ProjectInfo project = (ProjectInfo)paramMap.get("project");
            TrackNumberInfo trackNumber = (TrackNumberInfo)paramMap.get("trackNumber");
            StorageOrgUnitInfo sou = (StorageOrgUnitInfo)paramMap.get("sou");
            StringBuffer sql = new StringBuffer();
            sql.append(" select m.fid as materialid from CT_ZJB_PdmEasCarnoEqualSet pce");
            sql.append(" inner join t_bd_material m on pce.CFPMno=m.fnumber");
            sql.append(" inner join t_mm_project p on p.fid=pce.CFEasCarnoID");
            sql.append(" inner join t_mm_tracknumber stn on stn.fid=pce.cfeasbegintracknum");
            sql.append(" inner join t_mm_tracknumber etn on etn.fid=pce.cfeasendtracknumbe");
            sql.append(" where p.fid='" + project.getId().toString() + "'");
            sql.append(" and stn.fnumber<='" + trackNumber.getNumber() + "' and etn.fnumber>='" + trackNumber.getNumber() + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String topMId = null;
            if (!rs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0017", (Locale)ctx.getLocale())));
            }
            topMId = rs.getString("materialid");
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.getTempTableSql(ctx));
            MaterialInfo topMaterial = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)topMId)));
            ManuBomTree tree = new ManuBomTree();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tempTable", tempTable);
            params.put("prmtTrackBegin", trackNumber.getNumber());
            params.put("prmtTrackEnd", trackNumber.getNumber());
            params.put("project_tmp", project);
            params.put("tracknumber_tmp", trackNumber);
            params.put("projectType_tmp", paramMap.get("projectType"));
            params.put("billInfo", billInfo);
            params.put("returnMap", reMap);
            tree.run(ctx, project, topMaterial, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Serializable> re = new HashMap<String, Serializable>();
        re.put("billInfo", billInfo);
        re.put("returnMap", reMap);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)billInfo.getEntrys());
        return re;
    }

    private class ManuBomTree
    extends ProjectTargetCostBillBomTree {
        private ManuBomTree() {
        }

        @Override
        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("/*dialect*/ insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" null,0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" where 1=1");
            sql.append(" and b.TREE_MATERIAL_PROP!=10030");
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            int counttemp = ProjectTargetCostBillBomTree.executeUpdate(this.ctx, sql.toString(), null);
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfclasscodeid is not null and c.cfmaterialid=t.FMaterialID and c.cfprojecttypeid='" + projectType.getId().toString() + "' and rownum<2");
            sql.append(" )");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfclasscodeid is not null and c1.cfmaterialid=t.FMaterialID and c1.cfprojecttypeid='" + projectType.getId().toString() + "' and rownum<2)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(nvl(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            ProjectTargetCostBillInfo billInfo = (ProjectTargetCostBillInfo)params.get("billInfo");
            HashMap<String, ProjectTargetCostBillEntryInfo> materialMap = new HashMap<String, ProjectTargetCostBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                ProjectTargetCostBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("/*dialect*/ select * from " + tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            int noCount = 0;
            ProjectTargetCostBillEntryCollection billEntryCollection = new ProjectTargetCostBillEntryCollection();
            while (rs.next()) {
                MeasureUnitInfo ui;
                MaterialInfo mi;
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID) && ((ProjectTargetCostBillEntryInfo)materialMap.get(materialID)).getTechTrolleyQty().compareTo(rs.getBigDecimal("FDeQty")) != 0) {
                    ((ProjectTargetCostBillEntryInfo)materialMap.get(materialID)).setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                }
                ProjectTargetCostBillEntryInfo entry = new ProjectTargetCostBillEntryInfo();
                if (materials.contains(materialID)) continue;
                if (classCodeID != null) {
                    entry.setClassCode((ClassificationCodeInfo)allClassCode.get(classCodeID));
                    mi = new MaterialInfo();
                    mi.setId(BOSUuid.read((String)materialID));
                    mi.setNumber(rs.getString("FMaterialNumber"));
                    mi.setName(rs.getString("FMaterialName"));
                    mi.setModel(rs.getString("FMaterialModel"));
                    entry.setMaterial(mi);
                    entry.setMaterialName(rs.getString("FMaterialName"));
                    entry.setMaterialModel(rs.getString("FMaterialModel"));
                    ui = new MeasureUnitInfo();
                    ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                    ui.setName(rs.getString("FUnitName"));
                    entry.setUnit(ui);
                    entry.setFlow(rs.getString("FFlow"));
                    entry.setLastestPurPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                    entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                    entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    entry.setDecomposeQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                    entry.setTargetCoeff(BigDecimal.ONE);
                    billInfo.getEntrys().add(entry);
                    ++count;
                    continue;
                }
                mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setFlow(rs.getString("FFlow"));
                entry.setLastestPurPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setDecomposeQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setTargetCoeff(BigDecimal.ONE);
                ++noCount;
                billEntryCollection.add(entry);
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
            reMap.put("billEntryCollection", billEntryCollection);
        }
    }

    private class BomTree
    extends ProcessBomTree {
        private BomTree() {
        }

        protected void execute(String treeTemp, Map params) throws Exception {
            String tempTable = (String)params.get("tempTable");
            String propSql = (String)params.get("sql_tmp");
            ProjectTypesInfo projectType = (ProjectTypesInfo)params.get("projectType_tmp");
            StringBuilder sql = new StringBuilder();
            sql.append("/*dialect*/ insert into " + tempTable + "");
            sql.append(" select null,");
            sql.append(" m.fid,m.fnumber,m.fname_l2,");
            sql.append(" m.fmodel,mui.fid,mui.fname_l2,");
            sql.append(" max(pbb.cfmakeflow),0,sum(b.expand_fixed) ");
            sql.append(" from " + treeTemp + " b");
            sql.append(" inner join t_bd_material m on b.tree_material_id=m.fid");
            sql.append(" inner join t_bd_measureunit mui on m.fbaseunit=mui.fid");
            sql.append(" inner join ct_zjb_processbombill pbb on b.tree_bom_id=pbb.fid");
            sql.append(" where 1=1");
            sql.append(" " + propSql);
            sql.append(" group by m.fid,m.fnumber,m.fname_l2,m.fmodel,mui.fid,mui.fname_l2");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FClassCodeID=");
            sql.append(" (select c.cfclasscodeid from ct_pcm_classcmr c ");
            sql.append(" where c.cfclasscodeid is not null and c.cfmaterialid=t.FMaterialID and c.cfprojecttypeid='" + projectType.getId().toString() + "' and rownum<2");
            sql.append(" )");
            sql.append(" where exists (select 1 from ct_pcm_classcmr c1 ");
            sql.append(" where c1.cfclasscodeid is not null and c1.cfmaterialid=t.FMaterialID and c1.cfprojecttypeid='" + projectType.getId().toString() + "' and rownum<2)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("/*dialect*/ update " + tempTable + " t set t.FPrice=");
            sql.append(" ( select  min(nvl(c.CFLatestPurPrice,0))  from CT_PCM_PurMaterialPriceStorage c");
            sql.append(" where c.CFMaterialNumberID=t.FMaterialID)");
            sql.append(" where exists (select 1 from CT_PCM_PurMaterialPriceStorage c1 ");
            sql.append(" where c1.CFMaterialNumberID=t.FMaterialID)");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            ProjectTargetCostBillInfo billInfo = (ProjectTargetCostBillInfo)params.get("billInfo");
            HashMap<String, ProjectTargetCostBillEntryInfo> materialMap = new HashMap<String, ProjectTargetCostBillEntryInfo>();
            for (int i = 0; i < billInfo.getEntrys().size(); ++i) {
                ProjectTargetCostBillEntryInfo entry = billInfo.getEntrys().get(i);
                if (entry.getMaterial() == null) continue;
                materialMap.put(entry.getMaterial().getId().toString(), entry);
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)projectType.getId().toString(), CompareType.EQUALS));
            ev.setFilter(filter);
            SelectorItemCollection selColl = new SelectorItemCollection();
            selColl.add(new SelectorItemInfo("*"));
            selColl.add(new SelectorItemInfo("parent.*"));
            ev.setSelector(selColl);
            ClassificationCodeCollection classCodeColl = ClassificationCodeFactory.getLocalInstance(this.ctx).getClassificationCodeCollection(ev);
            HashMap<String, ClassificationCodeInfo> allClassCode = new HashMap<String, ClassificationCodeInfo>();
            for (int i = 0; i < classCodeColl.size(); ++i) {
                allClassCode.put(classCodeColl.get(i).getId().toString(), classCodeColl.get(i));
            }
            Set materials = materialMap.keySet();
            sql.setLength(0);
            sql.append("/*dialect*/ select * from " + tempTable);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            int count = 0;
            int noCount = 0;
            ProjectTargetCostBillEntryCollection billEntryCollection = new ProjectTargetCostBillEntryCollection();
            while (rs.next()) {
                MeasureUnitInfo ui;
                MaterialInfo mi;
                String materialID = rs.getString("FMaterialID");
                String classCodeID = rs.getString("FClassCodeID");
                if (materials.contains(materialID) && ((ProjectTargetCostBillEntryInfo)materialMap.get(materialID)).getTechTrolleyQty().compareTo(rs.getBigDecimal("FDeQty")) != 0) {
                    ((ProjectTargetCostBillEntryInfo)materialMap.get(materialID)).setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                }
                ProjectTargetCostBillEntryInfo entry = new ProjectTargetCostBillEntryInfo();
                if (materials.contains(materialID)) continue;
                if (classCodeID != null) {
                    entry.setClassCode((ClassificationCodeInfo)allClassCode.get(classCodeID));
                    mi = new MaterialInfo();
                    mi.setId(BOSUuid.read((String)materialID));
                    mi.setNumber(rs.getString("FMaterialNumber"));
                    mi.setName(rs.getString("FMaterialName"));
                    mi.setModel(rs.getString("FMaterialModel"));
                    entry.setMaterial(mi);
                    entry.setMaterialName(rs.getString("FMaterialName"));
                    entry.setMaterialModel(rs.getString("FMaterialModel"));
                    ui = new MeasureUnitInfo();
                    ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                    ui.setName(rs.getString("FUnitName"));
                    entry.setUnit(ui);
                    entry.setFlow(rs.getString("FFlow"));
                    entry.setLastestPurPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                    entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                    entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    entry.setDecomposeQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                    entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                    entry.setTargetCoeff(BigDecimal.ONE);
                    billInfo.getEntrys().add(entry);
                    ++count;
                    continue;
                }
                mi = new MaterialInfo();
                mi.setId(BOSUuid.read((String)materialID));
                mi.setNumber(rs.getString("FMaterialNumber"));
                mi.setName(rs.getString("FMaterialName"));
                mi.setModel(rs.getString("FMaterialModel"));
                entry.setMaterial(mi);
                entry.setMaterialName(rs.getString("FMaterialName"));
                entry.setMaterialModel(rs.getString("FMaterialModel"));
                ui = new MeasureUnitInfo();
                ui.setId(BOSUuid.read((String)rs.getString("FUnitID")));
                ui.setName(rs.getString("FUnitName"));
                entry.setUnit(ui);
                entry.setFlow(rs.getString("FFlow"));
                entry.setLastestPurPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setEstimateUnitPrice(rs.getBigDecimal("FPrice") == null ? BigDecimal.ZERO : rs.getBigDecimal("FPrice"));
                entry.setTechTrolleyQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setDecomposeQty(rs.getBigDecimal("FDeQty") == null ? BigDecimal.ZERO : rs.getBigDecimal("FDeQty"));
                entry.setPurchaseAttr(PurchaseAttrEnum.NONE);
                entry.setTargetCoeff(BigDecimal.ONE);
                ++noCount;
                billEntryCollection.add(entry);
            }
            Map reMap = (Map)params.get("returnMap");
            reMap.put("sussCount", count);
            reMap.put("noCount", noCount);
            reMap.put("billEntryCollection", billEntryCollection);
        }
    }
}

