/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.CostTypeEnum;
import com.kingdee.eas.industry.emm.pcm.ITargetCostStream;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillCollection;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillFactory;
import com.kingdee.eas.industry.emm.pcm.ProjectTargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.TargetCostBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.TargetCostBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.TargetCostBillInfo;
import com.kingdee.eas.industry.emm.pcm.TargetCostStreamCollection;
import com.kingdee.eas.industry.emm.pcm.TargetCostStreamFactory;
import com.kingdee.eas.industry.emm.pcm.TargetCostStreamInfo;
import com.kingdee.eas.industry.emm.pcm.app.AbstractTargetCostBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.template.EstimateTemplateInfo;
import com.kingdee.eas.industry.emm.pcm.util.PcmTreeBillHelper;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TargetCostBillControllerBean
extends AbstractTargetCostBillControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.app.TargetCostBillControllerBean");
    private ProjectTargetCostBillInfo srcBillInfo = null;

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TargetCostBillInfo bill = (TargetCostBillInfo)model;
        return super._addnew(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        TargetCostBillInfo info = (TargetCostBillInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0000", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0001", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ update CT_PCM_ProjectTCBE e set (e.CFDecomposeQty,e.CFDiffQty,e.CFDecomposePrice,e.CFDiffPrice,e.CFDecomposeCost,e.CFDiffCost,e.CFDecomposeRemark,e.CFDecomposeOverRate)");
        sql.append(" = (");
        sql.append(" select nvl(te.CFDecomposeQty,0),");
        sql.append(" nvl(te.CFDecomposeQty,0)-nvl(e.CFTechTrolleyQty,0),");
        sql.append(" nvl(te.CFDecomposePrice,0),");
        sql.append(" nvl(te.CFDecomposePrice,0)-nvl(e.cfestimateUnitPrice,0),");
        sql.append(" round(nvl(te.CFDecomposeQty,0)*nvl(te.CFDecomposePrice,0),2),");
        sql.append(" round(nvl(te.CFDecomposeQty,0)*nvl(te.CFDecomposePrice,0),2)-nvl(e.cftrolleyRealCost,2),");
        sql.append(" te.CFDecomposeRemark,");
        sql.append(" case when e.cftrolleyRealCost=0 then 0");
        sql.append(" else round(round(nvl(te.CFDecomposeQty,0)*nvl(te.CFDecomposePrice,0),2)-nvl(e.cftrolleyRealCost,2)/nvl(e.cftrolleyRealCost,2)*100,2)");
        sql.append(" end");
        sql.append(" from CT_PCM_TargetCostBillEntry te where te.CFSourceBillEntryID=e.fid and te.fparentid='" + info.getId().toString() + "'");
        sql.append(" )");
        sql.append(" where e.fparentid='" + info.getSourceBillId() + "' and e.CFResponsibilityCe='" + info.getResponsibilityDept().getId().toString() + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        ProjectTargetCostBillInfo ptcb = ProjectTargetCostBillFactory.getLocalInstance(ctx).getProjectTargetCostBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)info.getSourceBillId())), ProjectTargetCostBillInfo.getSelectors());
        ProjectTargetCostBillEntryCollection newColl = new ProjectTargetCostBillEntryCollection();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            TargetCostBillEntryInfo entry = info.getEntrys().get(i);
            if (entry.isIsMainRow() || entry.isIsTotalRow()) continue;
            ProjectTargetCostBillEntryInfo ei = new ProjectTargetCostBillEntryInfo();
            ei.setClassCode(entry.getClassCode());
            ei.setMaterial(entry.getMaterial());
            ei.setMaterialName(entry.getMaterialName());
            ei.setMaterialModel(entry.getMaterialModel());
            ei.setUnit(entry.getUnit());
            ei.setPurchaseAttr(entry.getPurchaseAttr());
            ei.setSupplier(entry.getSupplier());
            ei.setFlow(entry.getFlow());
            ei.setDecomposeQty(entry.getDecomposeQty());
            ei.setDiffQty(entry.getDiffQty());
            ei.setDecomposePrice(entry.getDiffPrice());
            ei.setDiffPrice(entry.getDiffPrice());
            ei.setDecomposeCost(entry.getDecomposeCost());
            ei.setDiffCost(entry.getDiffCost());
            ei.setDecomposeOverRate(entry.getDecomposeOverRate());
            ei.setDecomposeRemark(entry.getDecomposeRemark());
            ei.setIsMainRow(false);
            ei.setIsTotalRow(false);
            ei.setIsPackageRow(false);
            newColl.add(ei);
        }
        ptcb.getEntrys().addCollection(newColl);
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)ptcb.getEntrys());
        ProjectTargetCostBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(ptcb.getId()), (CoreBaseInfo)ptcb);
        try {
            this.genProjectCostStream(ctx, info.getSourceBillId());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    protected void genProjectCostStream(Context ctx, String sourceid) throws EASBizException, BOSException, UuidException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("/*dialect*/ select 1 from CT_PCM_TargetCostBill c where c.CFStatus<>4 and c.fsourcebillid='" + sourceid + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceid));
        ev.setFilter(filter);
        SelectorItemCollection siColl = new SelectorItemCollection();
        siColl.add("*");
        siColl.add("projectType.*");
        siColl.add("entrys.*");
        ev.setSelector(siColl);
        ProjectTargetCostBillInfo ptcb = null;
        ProjectTargetCostBillCollection ptcbColl = ProjectTargetCostBillFactory.getLocalInstance(ctx).getProjectTargetCostBillCollection(ev);
        if (ptcbColl != null && ptcbColl.size() > 0) {
            ptcb = ptcbColl.get(0);
        }
        ITargetCostStream iTargetCostStream = TargetCostStreamFactory.getLocalInstance(ctx);
        HashMap<String, ProjectTargetCostBillEntryInfo> map = new HashMap<String, ProjectTargetCostBillEntryInfo>();
        for (int i = 0; i < ptcb.getEntrys().size(); ++i) {
            ProjectTargetCostBillEntryInfo sumEntry;
            ProjectTargetCostBillEntryInfo entry = ptcb.getEntrys().get(i);
            if (!entry.isIsOutput() && !entry.isIsPriceLimit() || (sumEntry = (ProjectTargetCostBillEntryInfo)map.get(entry.getClassCode().getId().toString())) != null && !entry.isIsPriceLimit()) continue;
            TargetCostStreamInfo tcsi = new TargetCostStreamInfo();
            if (entry.isIsPriceLimit()) {
                if (entry.getMaterial() == null) {
                    String strInfo = ResourceBase.getString((String)this.RESURL, (String)"FLD", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
                    throw new EASBizException(new NumericExceptionSubItem("", strInfo + ":" + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0064", (Locale)ctx.getLocale()) + "\uff0c" + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0065", (Locale)ctx.getLocale()) + "\uff01"));
                }
                tcsi.setMaterial(entry.getMaterial());
            }
            tcsi.setProjectTypes(ptcb.getProjectType());
            tcsi.setControlType(ptcb.getControlType());
            tcsi.setCostType(CostTypeEnum.PURCHASE);
            tcsi.setResponsibilityCenter(entry.getResponsibilityCenter());
            tcsi.setProject(ptcb.getProject());
            tcsi.setClassCode(entry.getClassCode());
            if (entry.isIsPriceLimit()) {
                if (entry.getEstimateUnitPrice().compareTo(BigDecimal.ZERO) <= 0) {
                    // empty if block
                }
                tcsi.setTargetPrice(entry.getEstimateUnitPrice());
                tcsi.setIsLimit(true);
            } else {
                if (entry.getTrolleyRealCost().compareTo(BigDecimal.ZERO) <= 0) {
                    // empty if block
                }
                tcsi.setProjectTargetCost(entry.getTrolleyRealCost());
                tcsi.setIsLimit(false);
            }
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("controlType", (Object)tcsi.getControlType().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("costType", (Object)tcsi.getCostType().getValue()));
            filter.getFilterItems().add(new FilterItemInfo("responsibilityCenter.id", (Object)tcsi.getResponsibilityCenter().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)tcsi.getProject().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("classCode.id", (Object)tcsi.getClassCode().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("projectTypes.id", (Object)tcsi.getProjectTypes().getId().toString()));
            if (entry.isIsPriceLimit()) {
                filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)tcsi.getMaterial().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("isLimit", (Object)true));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isLimit", (Object)false));
            }
            if (iTargetCostStream.exists(filter)) {
                ev = new EntityViewInfo();
                ev.setFilter(filter);
                TargetCostStreamCollection coll = iTargetCostStream.getTargetCostStreamCollection(ev);
                if (coll != null || coll.size() > 0) {
                    tcsi.setId(coll.get(0).getId());
                    iTargetCostStream.update((IObjectPK)new ObjectUuidPK(tcsi.getId()), (CoreBaseInfo)tcsi);
                }
            } else {
                iTargetCostStream.submit((CoreBaseInfo)tcsi);
            }
            if (!entry.isIsTotalRow()) continue;
            map.put(entry.getClassCode().getId().toString(), entry);
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0066", (Locale)ctx.getLocale())));
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TargetCostBillInfo info = (TargetCostBillInfo)this.getValue(ctx, pk);
        if (info.getStatus() == BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0003", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void check(Context ctx, TargetCostBillInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0004", (Locale)ctx.getLocale())));
        }
        if (eti.getBizDate() == null) {
            eti.setBizDate(new Date());
        }
        StringBuffer errStr = new StringBuffer();
        if (eti.getResponsibilityDept() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0067", (Locale)ctx.getLocale()));
        }
        if (eti.getProjectType() == null) {
            errStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0006", (Locale)ctx.getLocale()));
        }
        if (errStr.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errStr.toString()));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TargetCostBillInfo info = (TargetCostBillInfo)model;
        this.check(ctx, info);
        this.checkEntrys(ctx, info);
        this.materialEntryBeforeSave(ctx, info);
        if (info.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0008", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.SUBMITED);
        if (info.getNumber() == null || info.getNumber().toString().equals("")) {
            info.setNumber(this.getNewNumber(ctx, (IObjectValue)info, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        this.submitCheck(info, ctx);
        this.calTotal(ctx, info);
        return super._submit(ctx, model);
    }

    private void submitCheck(TargetCostBillInfo info, Context ctx) throws EASBizException, BOSException {
        TargetCostBillEntryCollection entrysColl = info.getEntrys();
        for (int i = 0; i < entrysColl.size(); ++i) {
            StringBuffer tmpStr = new StringBuffer();
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            boolean isPackageRow = materialEntry.getBoolean("isPackageRow");
            if (info.getProjectType() != null) {
                info.setProjectType(ProjectTypesFactory.getLocalInstance(ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(info.getProjectType().getId())));
            }
            if (!isTotalRow && !isPackageRow) {
                TargetCostBillEntryInfo entry = (TargetCostBillEntryInfo)entrysColl.getObject(i);
                if (PcmTreeBillHelper.isBigDecimalUnderZero(entry.getDecomposeQty())) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0068", (Locale)ctx.getLocale()));
                }
                if (PcmTreeBillHelper.isBigDecimalEmpty(entry.getDecomposePrice())) {
                    entry.setDecomposePrice(BigDecimal.ZERO);
                }
                if (entry.getDecomposeQty() == null) {
                    entry.setDecomposeQty(BigDecimal.ZERO);
                }
                if (entry.getTrolleyQty() == null) {
                    entry.setTrolleyQty(BigDecimal.ZERO);
                }
                if (entry.getTrolleyPrice() == null) {
                    entry.setTrolleyPrice(BigDecimal.ZERO);
                }
                if (entry.getTrolleyCost() == null) {
                    entry.setTrolleyCost(BigDecimal.ZERO);
                }
                if (tmpStr.length() == 0) {
                    entry.setDecomposeCost(entry.getDecomposeQty().multiply(entry.getDecomposePrice()).setScale(2, RoundingMode.HALF_UP));
                    entry.setDiffQty(entry.getDecomposeQty().subtract(entry.getTrolleyQty()));
                    entry.setDiffPrice(entry.getDecomposePrice().subtract(entry.getTrolleyPrice()));
                    BigDecimal diffCost = entry.getDecomposeCost().subtract(entry.getTrolleyCost());
                    entry.setDiffCost(diffCost);
                    if (entry.getTrolleyCost().compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal decomposeOverRate = diffCost.divide(entry.getTrolleyCost(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                        entry.setDecomposeOverRate(decomposeOverRate);
                    } else {
                        entry.setDecomposeOverRate(BigDecimal.ZERO);
                    }
                }
                if (entry.getDiffCost() == null) {
                    entry.setDiffCost(BigDecimal.ZERO);
                }
                if (entry.isIsOut() && entry.getDiffCost().compareTo(BigDecimal.ZERO) > 0) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0069", (Locale)ctx.getLocale()));
                }
                if (entry.isIsLimitPrice() && entry.getDiffPrice().compareTo(BigDecimal.ZERO) > 0) {
                    tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0070", (Locale)ctx.getLocale()));
                }
            }
            if (tmpStr.length() <= 0) continue;
            String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0021", (Locale)ctx.getLocale()) + strInfo + "," + tmpStr.toString()));
        }
    }

    protected void checkEntrys(Context ctx, TargetCostBillInfo eti) throws EASBizException {
        String error = PcmTreeBillHelper.commCheckForEntrys(ctx, eti);
        if (error != null) {
            throw new EASBizException(new NumericExceptionSubItem("", error));
        }
    }

    protected void materialEntryBeforeSave(Context ctx, TargetCostBillInfo model) throws BOSException, EASBizException {
        PcmTreeBillHelper.sortMaterialEntryColl((IObjectCollection)model.getEntrys());
        BigDecimal allCost = BigDecimal.ZERO;
        for (int i = 0; i < model.getEntrys().size(); ++i) {
            TargetCostBillEntryInfo materialEntry = model.getEntrys().get(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (isTotalRow) continue;
            BigDecimal cost = materialEntry.getTrolleyCost() == null ? BigDecimal.ZERO : materialEntry.getTrolleyCost();
            allCost = allCost.add(cost);
        }
        model.setTrolleyMaterialExpense(allCost);
        model.setProjectMatetialExpense(allCost.multiply(model.getProjectQty()).setScale(2, RoundingMode.HALF_UP));
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TargetCostBillInfo info = (TargetCostBillInfo)model;
        this.check(ctx, info);
        this.checkEntrys(ctx, info);
        this.materialEntryBeforeSave(ctx, info);
        if (info.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && info.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0009", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (info.getNumber() == null || info.getNumber().toString().equals("")) {
            info.setNumber(this.getNewNumber(ctx, (IObjectValue)info, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        this.submitCheck(info, ctx);
        this.calTotal(ctx, info);
        return super._save(ctx, model);
    }

    public void calTotal(Context ctx, CoreBillBaseInfo billInfo) throws BOSException {
        int i;
        if (billInfo instanceof EstimateTemplateInfo) {
            return;
        }
        BigDecimal trolleyMaterialExpense = BigDecimal.ZERO;
        BigDecimal trolleyRiskAmount = BigDecimal.ZERO;
        IObjectCollection entrysColl = (IObjectCollection)billInfo.get("entrys");
        ProjectTypesInfo pti = (ProjectTypesInfo)billInfo.get("projectType");
        ClassificationCodeCollection cciColl = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeCollection("select id where projectTypes.id='" + pti.getId().toString() + "' and level=1");
        HashSet<String> topCciSet = new HashSet<String>();
        for (i = 0; i < cciColl.size(); ++i) {
            topCciSet.add(cciColl.get(i).getId().toString());
        }
        for (i = 0; i < entrysColl.size(); ++i) {
            String cciId;
            IObjectValue materialEntry = entrysColl.getObject(i);
            boolean isTotalRow = materialEntry.getBoolean("isTotalRow");
            if (!isTotalRow || !topCciSet.contains(cciId = ((ClassificationCodeInfo)materialEntry.get("classCode")).getId().toString())) continue;
            trolleyMaterialExpense = trolleyMaterialExpense.add(materialEntry.getBigDecimal("trolleyCost"));
        }
        billInfo.put("trolleyMaterialExpense", (Object)trolleyMaterialExpense);
        BigDecimal totalTorlleyCost = trolleyMaterialExpense;
        billInfo.put("trolleyCost", (Object)totalTorlleyCost);
        billInfo.put("trolleyRiskAmount", (Object)trolleyRiskAmount);
        if (billInfo instanceof TargetCostBillInfo) {
            BigDecimal projectQty = new BigDecimal(billInfo.get("projectQty").toString());
            billInfo.put("projectMatetialExpense", (Object)trolleyMaterialExpense.multiply(projectQty).setScale(2, RoundingMode.HALF_UP));
        }
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        String number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
        aSCMBillBaseInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        int i;
        TargetCostBillInfo ebi = (TargetCostBillInfo)objectValue;
        if (ebi.getSourceBillId() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0071", (Locale)ctx.getLocale())));
        }
        if (this.srcBillInfo == null) {
            this.srcBillInfo = ProjectTargetCostBillFactory.getLocalInstance(ctx).getProjectTargetCostBillInfo("where id='" + ebi.getSourceBillId() + "'");
        }
        for (i = 0; i < ebi.getEntrys().size(); ++i) {
            TargetCostBillEntryInfo entry = ebi.getEntrys().get(i);
            if (entry.getSourceBillEntryID() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0072", (Locale)ctx.getLocale())));
            }
            if (entry.isIsOut()) continue;
            entry.setTrolleyPrice(BigDecimal.ZERO);
            entry.setTrolleyCost(BigDecimal.ZERO);
        }
        PcmTreeBillHelper.insertTotalRowByClassCode((IObjectValue)ebi, ctx);
        if (this.srcBillInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.EMMPCPcmResource", (String)"0EMMPCPcm-0073", (Locale)ctx.getLocale())));
        }
        for (i = 0; i < ebi.getEntrys().size(); ++i) {
            TargetCostBillEntryInfo ei = ebi.getEntrys().get(i);
            if (ei.isIsTotalRow() && !ei.isIsOut() && ei.getTrolleyCost().compareTo(BigDecimal.ZERO) > 0) {
                for (int j = 0; j < this.srcBillInfo.getEntrys().size(); ++j) {
                    ProjectTargetCostBillEntryInfo ptcEntry = this.srcBillInfo.getEntrys().get(j);
                    if (!ei.getClassCode().getId().equals((Object)ptcEntry.getClassCode().getId()) || !ptcEntry.isIsOutput() || !ptcEntry.isIsTotalRow()) continue;
                    ei.setIsOut(true);
                }
            }
            ei.setIsMainRow(true);
        }
    }

    protected void _handleAfterTransform(Context context, String s, IObjectCollection coll) throws BOSException, EASBizException {
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                this._handleAfterTransform(context, s, coll.getObject(i));
            }
        }
    }
}

