/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.CostChangeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractCostChangeControllerBean;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CostChangeControllerBean
extends AbstractCostChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.CostChangeControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostChangeInfo eti = (CostChangeInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0048", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CostChangeInfo eti = (CostChangeInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getBillStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0022", (Locale)ctx.getLocale())));
        }
        eti.setBillStatus(BillBaseStatusEnum.SUBMITED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        }
        return super._submit(ctx, model);
    }

    private void checkHead(Context ctx, CostChangeInfo info) throws EASBizException {
        if (info.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0049", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            info.setAdminOrgUnit(ContextUtil.getCurrentAdminUnit((Context)ctx));
        }
        if (info.getBizDate() == null || info.get("bizDate").equals("")) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0050", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, CostChangeInfo info) {
    }

    protected void check(Context ctx, CostChangeInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0051", (Locale)ctx.getLocale())));
        }
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        String number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
        aSCMBillBaseInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (aSCMBillBaseInfo.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)aSCMBillBaseInfo.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostChangeInfo info = (CostChangeInfo)model;
        if (info == null) {
            info = (CostChangeInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0052", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CostChangeInfo info = (CostChangeInfo)model;
        if (info == null) {
            info = (CostChangeInfo)this._getValue(ctx, pk);
        }
        if (info.getBillStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0053", (Locale)ctx.getLocale())));
        }
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditTime(null);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }
}

