/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialAttributeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.FixProjectCostStorageAssEntryCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.FixProjectCostStorageAssEntryInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.FixProjectCostStorageEntryCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.FixProjectCostStorageEntryInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.FixProjectCostStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractFixProjectCostStorageControllerBean;
import com.kingdee.eas.mm.basedata.OperationFactory;
import com.kingdee.eas.mm.basedata.OperationInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FixProjectCostStorageControllerBean
extends AbstractFixProjectCostStorageControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.FixProjectCostStorageControllerBean");

    private String getString(Context ctx, String name) {
        return EASResource.getString((String)this.RESURL, (String)name, (Locale)ctx.getLocale());
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.check(ctx, model);
        return super._addnew(ctx, model);
    }

    private void check(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FixProjectCostStorageInfo fi = (FixProjectCostStorageInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)fi.getProject().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialNumber.id", (Object)fi.getMaterialNumber().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)fi.getTrackNumber().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)fi.getId(), CompareType.NOTEQUALS));
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0061")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getTreeEntrys(Context ctx, Map programMap) throws BOSException {
        FixProjectCostStorageInfo info = new FixProjectCostStorageInfo();
        FixProjectCostStorageEntryCollection coll = info.getEntrys();
        FixProjectCostStorageAssEntryCollection assEntryCollection = info.getAssEntrys();
        String pid = "";
        HashMap<String, FixProjectCostStorageInfo> map = new HashMap<String, FixProjectCostStorageInfo>();
        String tempTable = "";
        try {
            tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(this.createTempTable());
            IRowSet rsRoot = this.getBomByProjectID(ctx, programMap);
            while (rsRoot.next()) {
                pid = rsRoot.getString("BOMID");
                programMap.put("pid", pid);
                programMap.put("FMaterialID", rsRoot.getString("FMATERIALID"));
                programMap.put("storageorgunitid", rsRoot.getString("BOMSTORAGEUNITID"));
                programMap.put("storageorgunitid1", rsRoot.getString("BOM1STORAGEUNITID"));
            }
            rsRoot = this.getBomByMaterialID(ctx, programMap, tempTable);
            this.child(ctx, rsRoot, coll, programMap, "", 0, BigDecimal.ONE, tempTable);
            this.gf(ctx, assEntryCollection, tempTable);
            map.put("fixProjectCostStorageInfo", info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
        return map;
    }

    private BigDecimal child(Context ctx, IRowSet rs, FixProjectCostStorageEntryCollection coll, Map programMap, String jbm, int count, BigDecimal qty, String tempTable) {
        BigDecimal costH = BigDecimal.ZERO;
        try {
            while (rs.next()) {
                BigDecimal cost;
                BigDecimal actualFixQty;
                BigDecimal price;
                FixProjectCostStorageEntryInfo entryInfo = new FixProjectCostStorageEntryInfo();
                entryInfo.setJbType(jbm + ++count);
                String fatherid = rs.getString("fatherMaterialid");
                String fatherName = rs.getString("fatherName");
                String materialid = rs.getString("materialid");
                String materialName = rs.getString("materialName");
                int materialattr = rs.getInt("materialattr");
                String unit = rs.getString("unit");
                String bomFlow = rs.getString("bomFlow");
                String aeId = rs.getString("aeId");
                BigDecimal FConsumeFixQty = rs.getBigDecimal("FConsumeFixQty");
                if (materialattr == 10040 || materialattr == 10090 || materialattr == 10080) {
                    price = rs.getBigDecimal("cflatestpurprice");
                    if (price == null) {
                        price = rs.getBigDecimal("UpdatePrice");
                    }
                } else if (materialattr == 10070 || materialattr == 10050) {
                    price = rs.getBigDecimal("noTaxPrice");
                    if (price == null) {
                        price = rs.getBigDecimal("UpdatePrice");
                    }
                } else {
                    price = rs.getBigDecimal("cflatestpurprice");
                    if (price == null) {
                        price = rs.getBigDecimal("UpdatePrice");
                    }
                }
                BigDecimal bigDecimal = FConsumeFixQty == null ? null : (actualFixQty = qty == null ? BigDecimal.ZERO : qty.multiply(FConsumeFixQty));
                BigDecimal bigDecimal2 = actualFixQty == null ? null : (cost = price == null ? BigDecimal.ZERO : price.multiply(actualFixQty));
                if (cost != null && price != null) {
                    price = price.setScale(4, 2);
                    cost = cost.setScale(4, 2);
                }
                costH = costH.add(cost);
                if (fatherid != null && !fatherid.equals("")) {
                    MaterialInfo mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fatherid)));
                    entryInfo.setParentMaterialNumber(mi);
                    entryInfo.setParentMaterialName(fatherName);
                }
                if (materialid != null && !materialid.equals("")) {
                    MaterialInfo mie = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)materialid)));
                    entryInfo.setEntryMaterial(mie);
                    entryInfo.setEntryMaterialName(materialName);
                }
                entryInfo.setMaterialAttr(MaterialAttributeEnum.getEnum((int)materialattr));
                entryInfo.setUnit(unit);
                entryInfo.setTrackBomFlow(bomFlow);
                entryInfo.setConsumeFixQty(FConsumeFixQty);
                entryInfo.setActualFixQty(actualFixQty);
                entryInfo.setPrice(price);
                entryInfo.setCost(cost);
                entryInfo.setIsChange(false);
                entryInfo.setIsCheckFix(false);
                programMap.put("FMaterialID", materialid);
                programMap.put("storageorgunitid", rs.getString("BOMSTORAGEUNITID"));
                programMap.put("storageorgunitid1", rs.getString("BOM1STORAGEUNITID"));
                IRowSet rowSet = this.checkChild(ctx, programMap);
                BigDecimal temp = BigDecimal.ZERO;
                coll.add(entryInfo);
                if (rowSet != null && rowSet.size() > 0) {
                    IRowSet rsRe = this.getBomByMaterialID(ctx, programMap, tempTable);
                    temp = this.child(ctx, rsRe, coll, programMap, jbm + count + ".", 0, actualFixQty, tempTable);
                }
                entryInfo.setCost(temp.add(cost));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return costH;
    }

    private void gf(Context ctx, FixProjectCostStorageAssEntryCollection assEntryCollection, String tempTable) {
        StringBuffer StrSQL = new StringBuffer();
        ArrayList param = new ArrayList();
        StrSQL.setLength(0);
        StrSQL.append(" /*dialect*/SELECT M.fid as materialid ,M.fnumber as materialNumber,M.fname_l2 as materialName,op.fid as opid,op.fnumber as gxNumber,op.fname_l2 as gxName,be.cfbomflow as cfbomflow,rwp.cffixedworkingtime as cffixedworkingtime");
        StrSQL.append(" from t_mm_bomEntry be   ");
        StrSQL.append(" left outer join t_mm_pbomentry pbe on  be.fid=pbe.fbomitemid");
        StrSQL.append(" left outer join t_mm_pbom pb on pb.fid=pbe.fparentid");
        StrSQL.append(" left outer join T_MM_MaterialRWP rwp on rwp.fid=pbe.froutingitemid");
        StrSQL.append(" left outer join t_mm_operation op on rwp.FOperationID=op.fid");
        StrSQL.append(" left outer join t_bd_material M on M.fid=be.fmaterialid,");
        StrSQL.append(tempTable);
        StrSQL.append(" t where be.fid =t.beid");
        StrSQL.append(" group by M.fid,op.fid,M.fnumber,M.fname_l2,op.fnumber,op.fname_l2,be.cfbomflow,rwp.cffixedworkingtime ");
        try {
            IRowSet rsn = DbUtil.executeQuery((Context)ctx, (String)StrSQL.toString());
            while (rsn.next()) {
                FixProjectCostStorageAssEntryInfo info = new FixProjectCostStorageAssEntryInfo();
                if (rsn.getString("materialid") != null && !rsn.getString("materialid").equals("")) {
                    MaterialInfo mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rsn.getString("materialid"))));
                    info.setLaborMaterialNumber(mi);
                    info.setLaborMaterialName(mi.getName());
                }
                if (rsn.getString("opid") != null) {
                    OperationInfo opi = OperationFactory.getLocalInstance((Context)ctx).getOperationInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rsn.getString("opid"))));
                    info.setOprationNumber(opi);
                    info.setOprationName(opi.getName());
                }
                info.setTrackFlow(rsn.getString("cfbomflow"));
                info.setIsChange(false);
                info.setIsCheckFix(false);
                assEntryCollection.add(info);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private IRowSet getBomByProjectID(Context ctx, Map parmMap) throws EASBizException, BOSException {
        String projectID = (String)parmMap.get("projectId");
        String materialID = (String)parmMap.get("materialNumberId");
        String storageorgunitid = (String)parmMap.get("storageorgunitid");
        StringBuffer StrSQL = new StringBuffer();
        ArrayList<String> param = new ArrayList<String>();
        StrSQL.append(" /*dialect*/SELECT  A.FID AS BOMID,A.FMATERIALID AS FMATERIALID,E.FID AS FProjectID,");
        StrSQL.append(" E.FNAME_L2 AS ProjectName,S.FID As BOMSTORAGEUNITID,S.FNAME_L2 AS BOMSTORAGEUNITNAME,");
        StrSQL.append("S1.FID As BOM1STORAGEUNITID,S1.FNAME_L2 AS BOM1STORAGEUNITNAME,");
        StrSQL.append(" B.FNAME_L2 AS MNAME,B.FNUMBER AS MNUMBER, ");
        StrSQL.append(" B.fid AS bfid, ");
        StrSQL.append(" G.FNAME_L2 AS EMNAME,G.fDeletedStatus AS dStatus, ");
        StrSQL.append(" (Case TO_CHAR((Select fmaterialattr From T_BD_MaterialPlan where fmaterialid = A.FMATERIALID And FOrgUnit =A.FStorageOrgUnitID And Rownum = 1 ))  ");
        StrSQL.append(" when '10010' then 'Planning' when '10020' then 'Virtual'  when '10030' then 'HomeMade'  when '10040' then 'OutSourcing' ");
        StrSQL.append(" when '10050' then 'Entrust_OutSide' when '10060' then 'Other' when '10070' then 'Field_Oc' when '10080' then 'Otc_Oc' ");
        StrSQL.append(" when '10090' then 'Oc' else ''  end ) As FMSOURCE ");
        StrSQL.append(" FROM T_MM_Bom A ");
        StrSQL.append(" LEFT OUTER JOIN T_MM_Project E ON A.FProjectID = E.FID ");
        StrSQL.append(" LEFT OUTER JOIN T_ORG_Storage S ON A.FStorageOrgUnitID =S.FID");
        StrSQL.append(" LEFT OUTER JOIN T_ORG_Storage S1 ON A.CFStorageOrgID =S1.FID");
        StrSQL.append(" inner join T_BD_Material B on A.FMaterialID = B.FID");
        StrSQL.append(" inner join T_BD_MaterialGroup G on B.fMaterialGroupId = G.FID");
        StrSQL.append(" WHERE ");
        StrSQL.append(" A.FBOMTYPE IN (40,50) AND A.FPROJECTID = ?");
        param.add(projectID);
        if (storageorgunitid != null && !storageorgunitid.equals("")) {
            StrSQL.append(" AND CASE A.CFStorageOrgID WHEN NULL THEN A.FSTORAGEORGUNITID ELSE A.CFStorageOrgID END  =?");
            param.add(storageorgunitid);
        }
        if (materialID != null && !materialID.equals("")) {
            StrSQL.append("AND A.FMATERIALID =?");
            param.add(materialID);
        }
        StrSQL.append(" AND A.FBaseStatus IN (1,2,4) Order by E.FNAME_L2,B.FNUMBER ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)StrSQL.toString(), (Object[])param.toArray());
        return rs;
    }

    private IRowSet getBomByMaterialID(Context ctx, Map parmMap, String tempTable) throws EASBizException, BOSException {
        String FProjectID = (String)parmMap.get("projectId");
        String FMaterialID = (String)parmMap.get("FMaterialID");
        String storageorgunitid = (String)parmMap.get("storageorgunitid");
        String storageorgunitid1 = (String)parmMap.get("storageorgunitid1");
        String trackNumber = (String)parmMap.get("trackNumber");
        StringBuffer StrSQL = new StringBuffer();
        StringBuffer StrInsert = new StringBuffer();
        ArrayList<String> param = new ArrayList<String>();
        StrSQL.append(" /*dialect*/SELECT distinct AE.fid as aeId,A.fid as bomid ,B.FID AS fatherMaterialid ,B.fnumber AS fatherNumber,B.fname_l2 AS fatherName,");
        StrSQL.append(" MB.fid AS materialid,MB.Fnumber AS materialNumber,MB.fname_l2 AS materialName,");
        StrSQL.append(" (Case WHEN AE.FMATERIALPROP IS NULL Then (Select fmaterialattr From T_BD_MaterialPlan where fmaterialid = AE.FMATERIALID And FOrgUnit =AE.FSupplyStorageOrgUnitID And Rownum = 1) ELSE (AE.FMATERIALPROP) END )  As materialattr ,");
        StrSQL.append("  MB.fmodel AS model,mu.fname_l2 AS unit,AE.Fconsumefixbaseqty AS FConsumeFixQty,");
        StrSQL.append("  pps.cflatestpurprice as cflatestpurprice,");
        StrSQL.append("  first_value(pm.CFUpdatePrice) over(partition by pm.cfmaterialid  order by pm.fcreatetime desc) AS updatePrice,");
        StrSQL.append("  pg.CFNoTaxPrice as noTaxPrice,");
        StrSQL.append("  AE.Cfbomflow AS bomFlow,S.FID As BOMSTORAGEUNITID, E.FID AS FProjectID,S1.FID As BOM1STORAGEUNITID");
        StrInsert.append(" FROM T_MM_Bom A ");
        StrInsert.append(" right outer join T_MM_BomEntry AE on AE.fparentid=A.fid");
        StrInsert.append(" LEFT OUTER JOIN T_MM_Project E ON A.FProjectID = E.FID ");
        StrInsert.append(" LEFT OUTER JOIN T_BD_Material MB ON AE.Fmaterialid = MB.FID ");
        StrInsert.append(" LEFT OUTER JOIN T_BD_MaterialPlan MPE ON AE.FMaterialInventoID = MPE.FID ");
        StrInsert.append(" LEFT OUTER JOIN T_BD_Measureunit mu ON MB.fbaseunit = Mu.FID ");
        StrInsert.append("  LEFT OUTER JOIN  Ct_Pcm_Purmaterialpricestorage pps on pps.cfmaterialnumberid=AE.Fmaterialid ");
        StrInsert.append("  LEFT OUTER JOIN  CT_PCM_MaterialPriceUpdate pm on pm.CFMaterialID=AE.Fmaterialid ");
        StrInsert.append("  LEFT OUTER JOIN  CT_PCM_GongsiIPBE pg on pg.CFParentMaterialID=AE.Fmaterialid ");
        StrInsert.append(" LEFT OUTER JOIN T_ORG_Storage S ON A.FStorageOrgUnitID =S.FID");
        StrInsert.append(" LEFT OUTER JOIN T_ORG_Storage S1 ON A.CFStorageOrgID =S1.FID");
        StrInsert.append(" left Join T_MM_TrackNumber stn on stn.FID=ae.CFBeginCarnoID");
        StrInsert.append(" left Join T_MM_TrackNumber etn on etn.FID=ae.CFEndCarnoID,");
        StrInsert.append(" T_BD_Material B");
        StrInsert.append(" WHERE A.FMaterialID = B.FID   ");
        StrInsert.append(" AND A.FMATERIALID =?  ");
        param.add(FMaterialID);
        if (storageorgunitid1 == null || storageorgunitid1.equals("")) {
            StrInsert.append(" AND A.FStorageOrgUnitID = ?  ");
            param.add(storageorgunitid);
        } else {
            StrInsert.append(" AND A.CFStorageOrgID =? ");
            param.add(storageorgunitid1);
        }
        if (trackNumber != null && !trackNumber.equals("")) {
            StrInsert.append(" and stn.FNumber <= ? and etn.FNumber >=?");
            param.add(trackNumber);
            param.add(trackNumber);
        }
        StrInsert.append(" AND A.FProjectID =  ? ");
        param.add(FProjectID);
        StrInsert.append(" AND A.FBaseStatus IN (1,2,4) AND A.FBOMTYPE IN (40,50) Order by  MB.Fnumber");
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into " + tempTable);
        buffer.append(" select AE.fid");
        buffer.append(StrInsert);
        DbUtil.execute((Context)ctx, (String)buffer.toString(), (Object[])param.toArray());
        StrSQL.append(StrInsert);
        return DbUtil.executeQuery((Context)ctx, (String)StrSQL.toString(), (Object[])param.toArray());
    }

    private IRowSet checkChild(Context ctx, Map parmMap) throws EASBizException, BOSException {
        String projectID = (String)parmMap.get("projectId");
        String FMaterialID = (String)parmMap.get("FMaterialID");
        String storageorgunitid = (String)parmMap.get("storageorgunitid");
        String storageorgunitid1 = (String)parmMap.get("storageorgunitid1");
        StringBuffer StrSQL = new StringBuffer();
        ArrayList<String> param = new ArrayList<String>();
        StrSQL.append(" SELECT A.FID AS BOMID,A.FMATERIALID AS FMATERIALID,E.FID AS FProjectID,");
        StrSQL.append(" E.FNAME_L2 AS ProjectName,S.FID As BOMSTORAGEUNITID,S.FNAME_L2 AS BOMSTORAGEUNITNAME,");
        StrSQL.append(" S1.FID As BOM1STORAGEUNITID,S1.FNAME_L2 AS BOM1STORAGEUNITNAME,");
        StrSQL.append(" B.FNAME_L2 AS MNAME,B.FNUMBER AS MNUMBER");
        StrSQL.append(" FROM T_MM_Bom A  ");
        StrSQL.append(" LEFT OUTER JOIN T_MM_Project E ON A.FProjectID = E.FID    ");
        StrSQL.append(" LEFT OUTER JOIN T_ORG_Storage S ON A.FStorageOrgUnitID =S.FID ");
        StrSQL.append(" LEFT OUTER JOIN T_ORG_Storage S1 ON A.CFStorageOrgID =S1.FID,      ");
        StrSQL.append(" T_BD_Material B ");
        StrSQL.append(" WHERE A.FMaterialID = B.FID ");
        StrSQL.append("  AND A.FMATERIALID =?");
        param.add(FMaterialID);
        if (storageorgunitid1 == null || storageorgunitid1.equals("")) {
            StrSQL.append(" AND  A.FStorageOrgUnitID =?");
            param.add(storageorgunitid);
        } else {
            StrSQL.append(" AND  A.CFStorageOrgID =?");
            param.add(storageorgunitid1);
        }
        StrSQL.append(" AND A.FProjectID = ?");
        param.add(projectID);
        StrSQL.append(" AND A.FBaseStatus IN (1,2,4) AND A.FBOMTYPE IN (40,50) Order by B.FNUMBER ");
        return DbUtil.executeQuery((Context)ctx, (String)StrSQL.toString(), (Object[])param.toArray());
    }

    private String createTempTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T_PCM_TempFix(");
        sql.append("beid varchar(44)");
        sql.append(")");
        return sql.toString();
    }
}

