/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.TimeUnitEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.ISOAccreditWH;
import com.kingdee.eas.basedata.scm.im.inv.IStoreState;
import com.kingdee.eas.basedata.scm.im.inv.IStoreType;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreFlagEnum;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WHStateEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventoryInitBill;
import com.kingdee.eas.scm.im.inv.InventoryInitBillCollection;
import com.kingdee.eas.scm.im.inv.InventoryInitBillFactory;
import com.kingdee.eas.scm.im.inv.InventoryInitBillInfo;
import com.kingdee.eas.scm.im.inv.InventoryInitEntryInfo;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;

public class InvInitBillDataImport
extends AbstractDataTransmission {
    private static final String[] DECIMAL_ENTRY_PROPERTY = new String[]{"qty", "costPrice", "amount", "diffAmount", "yearReceiptQty", "yearReceiptAmount", "yearReceiptCostDiff", "yearIssueQty", "yearIssueAmount", "yearIssueCostDiff", "assistQty", "yearReceiptAssistQty", "yearIssueAssistQty"};
    private static final String[] QTY_PROPERTY = new String[]{"qty", "yearReceiptQty", "yearIssueQty"};
    private static final String[] ASSISTQTY_PROPERTY = new String[]{"assistQty", "yearReceiptAssistQty", "yearIssueAssistQty"};
    private static final String[] PRICE_PROPERTY = new String[]{"costPrice"};
    private static final String[] AMOUNT_PROPERTY = new String[]{"amount", "diffAmount", "yearReceiptAmount", "yearIssueAmount", "yearReceiptCostDiff", "yearIssueCostDiff"};
    private boolean isArUpdateInventory = false;
    private static final String[] DATE_BILL_PROPERTY = new String[]{"bizDate", "mfg", "exp"};
    private static final String[] DATE_ENTRY_PROPERTY = new String[]{"mfg", "exp"};
    private static final int WAREHOUSE = 0;
    private static final int CUSTOMER = 1;
    private static final int SUPPLIER = 2;
    private static final int ASSISTPROPERTY = 3;
    private static final int ASSISTUNIT = 4;
    private static String resource = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private static String RESOURCE = "com.kingdee.eas.scm.im.inv.InvInitBillResource";
    CompanyOrgUnitInfo cou = null;
    StorageOrgUnitInfo sou = null;
    InventoryInitBillInfo invInit = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    private static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    private static String getMyResource(Context ctx, String strKey) {
        if (StringUtil.isEmptyString((String)strKey)) {
            return null;
        }
        return SCMUtils.getResource((String)RESOURCE, (String)strKey, (Context)ctx);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InventoryInitBillFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private InventoryInitBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        boolean userCodingRuleManager;
        boolean noNumber;
        block28: {
            this.invInit = new InventoryInitBillInfo();
            noNumber = false;
            userCodingRuleManager = false;
            Object number = null;
            if (lineData.get("number") != null) {
                number = ((DataToken)lineData.get((Object)"number")).data;
            }
            if (number != null && number.toString().trim().length() > 0) {
                this.invInit.setNumber(number.toString().trim());
                String existId = this.getIdFromNumber(number.toString().trim(), ctx);
                if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                    throw new TaskExternalException(number.toString().trim() + InvInitBillDataImport.getResource(ctx, "EXISTS"));
                }
                if (this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                    InventoryInitBillInfo existInfo = null;
                    try {
                        existInfo = ((IInventoryInitBill)this.getController(ctx)).getInventoryInitBillInfo((IObjectPK)new ObjectUuidPK(existId));
                    }
                    catch (Exception e) {
                        throw new TaskExternalException("", (Throwable)e);
                    }
                    if (BillBaseStatusEnum.AUDITED.equals((Object)existInfo.getBaseStatus())) {
                        throw new TaskExternalException(number.toString().trim() + InvInitBillDataImport.getMyResource(ctx, "import_bill_audited"));
                    }
                }
                if (StringUtil.isEmptyString((String)existId)) {
                    userCodingRuleManager = true;
                    noNumber = true;
                }
            } else {
                noNumber = true;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < DATE_BILL_PROPERTY.length; ++i) {
                Object date = null;
                if (lineData.get(DATE_BILL_PROPERTY[i]) != null) {
                    date = ((DataToken)lineData.get((Object)InvInitBillDataImport.DATE_BILL_PROPERTY[i])).data;
                }
                if (date == null || date.toString().length() <= 0) continue;
                try {
                    date = df.parse(date.toString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new TaskExternalException(this.getDateString(i, ctx) + InvInitBillDataImport.getResource(ctx, "InvalidDateFormat") + date.toString());
                }
                if (date == null || !(date instanceof Date)) continue;
                this.invInit.setDate(DATE_BILL_PROPERTY[i], (Date)date);
            }
            try {
                Object souData = null;
                if (lineData.get("storageOrgUnit") != null) {
                    souData = ((DataToken)lineData.get((Object)"storageOrgUnit")).data;
                }
                if (souData == null || souData.toString().trim().length() <= 0) break block28;
                IStorageOrgUnit isou = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = isou.getStorageOrgUnitCollection(this.getFilter(souData.toString().trim()));
                if (collection != null && collection.size() > 0) {
                    this.sou = collection.get(0);
                    if (!this.sou.isIsBizUnit()) {
                        throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "StorageOrgUnitIsNotBizUnit"));
                    }
                    this.invInit.setStorageOrgUnit(this.sou);
                    break block28;
                }
                throw new TaskExternalException(souData.toString().trim() + " " + InvInitBillDataImport.getResource(ctx, "StorageOrgUnitNotExists"));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        try {
            boolean isUsedParam;
            if (noNumber && (isUsedParam = DataImportUtils.getImportParam((Context)ctx))) {
                String souID = this.sou.getId().toString().trim();
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (iCodingRuleManager.isExist((IObjectValue)this.invInit, souID)) {
                    this.invInit.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.invInit, souID, ""));
                } else if (!userCodingRuleManager) {
                    IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                    EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(this.sou.getBOSType());
                    Object[] materialNames = new String[]{entityObjectInfo.getAlias()};
                    throw new SCMBillException(SCMBillException.NOCORDRULE, materialNames);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        try {
            this.invInit.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(this.sou.getId().toString(), 4, 1);
            if (orgCol.get(0) != null) {
                this.cou = (CompanyOrgUnitInfo)orgCol.get(0);
                this.invInit.setCompanyOrgUnit(this.cou);
            }
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            this.invInit.setCreator(userInfo);
            Date d = new Date();
            this.invInit.setCreateTime(new Timestamp(d.getTime()));
            this.invInit.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            ITransactionType itt = TransactionTypeFactory.getLocalInstance((Context)ctx);
            BillTypeInfo bii = new BillTypeInfo();
            bii.setId(BOSUuid.read((String)"528d806a-0106-1000-e000-0194c0a812e6463ED552"));
            bii.setNumber("100");
            this.invInit.setBillType(bii);
            String isUpdateByARBILL = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(this.cou.getId()), "CONSIGNSALES");
            if (isUpdateByARBILL != null) {
                this.isArUpdateInventory = isUpdateByARBILL.trim().equals("true");
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return this.invInit;
    }

    private MaterialInventoryInfo getInventoryInfo(String matid, String ouid) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)ouid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)matid, CompareType.EQUALS));
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.hasLocation"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("defaultWarehouse.whman.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.longNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("material.shortName"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("effectedStatus"));
        viewInfo.getSelector().add(new SelectorItemInfo("freezeOrgUnit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("status"));
        viewInfo.getSelector().add(new SelectorItemInfo("creator.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("lastUpdateUser.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("createTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("lastUpdateTime"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.number"));
        viewInfo.getSelector().add(new SelectorItemInfo("unit.name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isControl"));
        viewInfo.getSelector().add(new SelectorItemInfo("qtySafety"));
        viewInfo.getSelector().add(new SelectorItemInfo("qtyMin"));
        viewInfo.getSelector().add(new SelectorItemInfo("qtyMax"));
        viewInfo.getSelector().add(new SelectorItemInfo("daysBottom"));
        viewInfo.getSelector().add(new SelectorItemInfo("daysTop"));
        viewInfo.getSelector().add(new SelectorItemInfo("daysTurnover"));
        viewInfo.getSelector().add(new SelectorItemInfo("isNegative"));
        viewInfo.getSelector().add(new SelectorItemInfo("isBatchNo"));
        viewInfo.getSelector().add(new SelectorItemInfo("isSequenceNo"));
        viewInfo.getSelector().add(new SelectorItemInfo("isLotNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("isBarcode"));
        viewInfo.getSelector().add(new SelectorItemInfo("qtyMinPackage"));
        viewInfo.getSelector().add(new SelectorItemInfo("abcType"));
        viewInfo.getSelector().add(new SelectorItemInfo("isCompages"));
        viewInfo.getSelector().add(new SelectorItemInfo("issuePriorityMode"));
        viewInfo.getSelector().add(new SelectorItemInfo("isPeriodValid"));
        viewInfo.getSelector().add(new SelectorItemInfo("periodValid"));
        viewInfo.getSelector().add(new SelectorItemInfo("periodValidUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("inWarehsAhead"));
        viewInfo.getSelector().add(new SelectorItemInfo("outWarehsAhead"));
        viewInfo.getSelector().add(new SelectorItemInfo("prepWarnAhead"));
        viewInfo.getSelector().add(new SelectorItemInfo("aheadUnit"));
        MaterialInventoryCollection con = MaterialInventoryFactory.getRemoteInstance().getMaterialInventoryCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            for (int i = 0; i < con.size(); ++i) {
                MaterialInventoryInfo info = con.get(i);
                if (!info.getOrgUnit().getId().toString().equals(ouid)) continue;
                return info;
            }
            return con.get(0);
        }
        MaterialInventoryInfo info = null;
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InventoryInitEntryInfo transmitEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        StringBuffer errorString;
        InventoryInitEntryInfo entryInfo;
        block87: {
            ProjectCollection coll;
            ObjectUuidPK cuPK;
            CtrlUnitInfo cu;
            FilterInfo filter2;
            FilterInfo filter;
            HashSet<Integer> status;
            EntityViewInfo viewInfo;
            String number;
            Object data;
            block86: {
                Comparable<BigDecimal> value;
                Object o;
                int i;
                if (hsData == null) {
                    return null;
                }
                entryInfo = new InventoryInitEntryInfo();
                MaterialInfo materialInfo = new MaterialInfo();
                MeasureUnitInfo mui = new MeasureUnitInfo();
                MaterialCompanyInfoInfo materialCompanyInfo = null;
                MaterialInventoryInfo materialInventory = null;
                StoreTypeInfo storeTypeInfo = new StoreTypeInfo();
                this.cou = this.invInit.getCompanyOrgUnit();
                this.sou = this.invInit.getStorageOrgUnit();
                errorString = new StringBuffer();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                for (i = 0; i < DATE_ENTRY_PROPERTY.length; ++i) {
                    o = null;
                    if (hsData.get(DATE_ENTRY_PROPERTY[i]) != null) {
                        o = ((DataToken)hsData.get((Object)InvInitBillDataImport.DATE_ENTRY_PROPERTY[i])).data;
                    }
                    if (o == null || o.toString().length() <= 0) continue;
                    try {
                        o = df.parse(o.toString());
                    }
                    catch (ParseException pex) {
                        pex.printStackTrace();
                        throw new TaskExternalException(this.getDateString(i + 1, ctx) + InvInitBillDataImport.getResource(ctx, "InvalidDateFormat") + o.toString());
                    }
                    if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
                    entryInfo.setDate(DATE_ENTRY_PROPERTY[i], (Date)value);
                }
                for (i = 0; i < DECIMAL_ENTRY_PROPERTY.length; ++i) {
                    try {
                        o = null;
                        if (hsData.get(DECIMAL_ENTRY_PROPERTY[i]) != null) {
                            o = ((DataToken)hsData.get((Object)InvInitBillDataImport.DECIMAL_ENTRY_PROPERTY[i])).data;
                        }
                        if (o != null && o.toString().trim().length() > 0) {
                            value = new BigDecimal(o.toString());
                            if (value == null) continue;
                            if ("costPrice".equals(DECIMAL_ENTRY_PROPERTY[i]) && ((BigDecimal)value).compareTo(ZERO) < 0) {
                                throw new TaskExternalException(DECIMAL_ENTRY_PROPERTY[i] + InvInitBillDataImport.getMyResource(ctx, "import_price_must_positive"));
                            }
                            entryInfo.setBigDecimal(DECIMAL_ENTRY_PROPERTY[i], value);
                            continue;
                        }
                        entryInfo.setBigDecimal(DECIMAL_ENTRY_PROPERTY[i], ZERO);
                        continue;
                    }
                    catch (NumberFormatException nex) {
                        nex.printStackTrace();
                        throw new TaskExternalException(DECIMAL_ENTRY_PROPERTY[i] + InvInitBillDataImport.getResource(ctx, "FormatMustBeNumber"));
                    }
                }
                try {
                    MultiMeasureUnitInfo assistMmu;
                    MultiMeasureUnitInfo mmu;
                    IMeasureUnit imu;
                    WarehouseCollection collection;
                    StoreTypeInfo info;
                    StoreTypeCollection collection2;
                    String number2 = null;
                    Object data2 = null;
                    if (hsData.get("material") != null) {
                        data2 = ((DataToken)hsData.get((Object)"material")).data;
                        if (data2 == null || data2.toString().length() <= 0) throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "MaterialNotExists"));
                        number2 = data2.toString();
                        if (number2 != null && number2.trim().length() > 0) {
                            IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                            collection2 = imaterial.getMaterialCollection(this.getFilter(number2));
                            if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "MaterialNotExists"));
                            info = collection2.get(0);
                            if (info == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "MaterialNotExists"));
                            entryInfo.setMaterial((MaterialInfo)info);
                            materialInfo = info;
                            materialInventory = this.getInventoryInfo(materialInfo.getId().toString(), this.sou.getId().toString());
                            if (materialInventory == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + " " + this.sou.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "NO_INVENTORY_PROPERTY"));
                            }
                            materialCompanyInfo = imaterial.getCompanyInfo(materialInfo.getId().toString(), this.cou.getId().toString());
                            if (materialCompanyInfo == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + " " + this.cou.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "NO_COMPANY_PROPERTY"));
                            }
                            if (materialCompanyInfo.getAccountType() == null) {
                                throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotAccountType"));
                            }
                            entryInfo.setAccountType(materialCompanyInfo.getAccountType());
                        }
                    }
                    if (hsData.get("storeType") != null) {
                        data2 = ((DataToken)hsData.get((Object)"storeType")).data;
                        if (data2 == null) throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "StoreTypeNotExists"));
                        number2 = data2.toString();
                        if (number2 != null) {
                            IStoreType ist = StoreTypeFactory.getLocalInstance((Context)ctx);
                            collection2 = ist.getStoreTypeCollection(this.getFilter(number2));
                            if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "StoreTypeNotExists"));
                            info = collection2.get(0);
                            if (info == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "StoreTypeNotExists"));
                            entryInfo.setStoreType(info);
                            storeTypeInfo = info;
                        }
                    }
                    if (hsData.get("lot") != null) {
                        data2 = ((DataToken)hsData.get((Object)"lot")).data;
                        this.checkLotInfo(ctx, materialInfo, data2, this.sou, entryInfo);
                        if (data2 == null || data2.toString() == null || data2.toString().trim().length() == 0) {
                            entryInfo.setLot(null);
                        } else {
                            entryInfo.setLot(data2.toString().trim());
                        }
                        if (materialInventory.isIsPeriodValid()) {
                            Date mfg = entryInfo.getMfg();
                            Date exp = entryInfo.getExp();
                            if (mfg != null) {
                                TimeUnitEnum periodValidUnit = materialInventory.getPeriodValidUnit();
                                int unit = 3;
                                if (periodValidUnit != null) {
                                    unit = periodValidUnit.getValue();
                                }
                                int periodValid = materialInventory.getPeriodValid();
                                Date exp2 = InvInitBillDataImport.getEXP(mfg, unit, periodValid);
                                entryInfo.setExp(exp2);
                            }
                        }
                    }
                    if (hsData.get("assistProperty") != null) {
                        data2 = ((DataToken)hsData.get((Object)"assistProperty")).data;
                    }
                    this.checkMaterialInfo(ctx, materialInfo, data2, 3);
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        IAsstAttrValue iasstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
                        collection2 = iasstAttrValue.getAsstAttrValueCollection("where number='" + number2 + "'");
                        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(number2 + InvInitBillDataImport.getResource(ctx, "AsstAttrValueExists"));
                        info = collection2.get(0);
                        if (info != null) {
                            entryInfo.setAssistProperty((AsstAttrValueInfo)info);
                        }
                    }
                    if (hsData.get("customer") != null) {
                        data2 = ((DataToken)hsData.get((Object)"customer")).data;
                    }
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        ICustomer ic = CustomerFactory.getLocalInstance((Context)ctx);
                        collection2 = ic.getCustomerCollection(this.getFilter(number2));
                        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "CustomerNotExists"));
                        info = collection2.get(0);
                        if (info == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "CustomerNotExists"));
                        entryInfo.setCustomer((CustomerInfo)info);
                    }
                    this.checkStoreTypeEtc(ctx, storeTypeInfo, data2, 1);
                    if (hsData.get("supplier") != null) {
                        data2 = ((DataToken)hsData.get((Object)"supplier")).data;
                    }
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        ISupplier is = SupplierFactory.getLocalInstance((Context)ctx);
                        collection2 = is.getSupplierCollection(this.getFilter(number2));
                        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "SupplierNotExists"));
                        info = collection2.get(0);
                        if (info == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "SupplierNotExists"));
                        entryInfo.setSupplier((SupplierInfo)info);
                    }
                    this.checkStoreTypeEtc(ctx, storeTypeInfo, data2, 2);
                    if (hsData.get("storeStatus") != null) {
                        data2 = ((DataToken)hsData.get((Object)"storeStatus")).data;
                    }
                    if (data2 == null) throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "StoreStatusNotExists"));
                    number2 = data2.toString();
                    if (number2 != null) {
                        IStoreState iss = StoreStateFactory.getLocalInstance((Context)ctx);
                        collection2 = iss.getStoreStateCollection(this.getFilter(number2));
                        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "StoreStatusNotExists"));
                        info = collection2.get(0);
                        if (info == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "StoreStatusNotExists"));
                        entryInfo.setStoreStatus((StoreStateInfo)info);
                    }
                    WarehouseInfo warehouseInfo = new WarehouseInfo();
                    if (hsData.get("warehouse") != null) {
                        data2 = ((DataToken)hsData.get((Object)"warehouse")).data;
                    }
                    if (data2 != null && data2.toString() != null && data2.toString().length() > 0) {
                        number2 = data2.toString();
                        if (number2 != null) {
                            IWarehouse iw = WarehouseFactory.getLocalInstance((Context)ctx);
                            collection = iw.getWarehouseCollection(this.getFilter(number2));
                            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "WarehouseNotExists"));
                            WarehouseInfo info2 = collection.get(0);
                            if (info2 == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "WarehouseNotExists"));
                            if (!info2.getWhState().equals((Object)WHStateEnum.ACTIVE)) {
                                throw new TaskExternalException(info2.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "WarehouseNotActive"));
                            }
                            this.checkWarehouse(ctx, info2, this.sou);
                            entryInfo.setWarehouse(info2);
                            warehouseInfo = info2;
                        }
                    } else if (this.isWarehouseLotNecessary(storeTypeInfo)) {
                        throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "WarehouseNotExists"));
                    }
                    this.checkStoreTypeEtc(ctx, storeTypeInfo, data2, 0);
                    if (hsData.get("location") != null) {
                        data2 = ((DataToken)hsData.get((Object)"location")).data;
                    }
                    if (warehouseInfo.isHasLocation() && (data2 == null || data2.toString().length() <= 0)) {
                        throw new TaskExternalException(warehouseInfo.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "LocationMustNotBeNull"));
                    }
                    if (!warehouseInfo.isHasLocation() && data2 != null && data2.toString().length() > 0) {
                        String warehsNumber = warehouseInfo.getNumber();
                        if (warehsNumber != null && warehsNumber.trim().length() != 0) throw new TaskExternalException(warehsNumber + " " + InvInitBillDataImport.getResource(ctx, "LocationMustBeNull"));
                        warehsNumber = "";
                        throw new TaskExternalException(warehsNumber + " " + InvInitBillDataImport.getResource(ctx, "LocationMustBeNull"));
                    }
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        ILocation il = LocationFactory.getLocalInstance((Context)ctx);
                        EntityViewInfo viewInfo2 = new EntityViewInfo();
                        FilterInfo filter3 = new FilterInfo();
                        filter3.getFilterItems().add(new FilterItemInfo("number", (Object)number2, CompareType.EQUALS));
                        filter3.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
                        viewInfo2.setFilter(filter3);
                        LocationCollection collection3 = il.getLocationCollection(viewInfo2);
                        if (collection3 == null || collection3.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "LocationNotExists"));
                        LocationInfo info3 = collection3.get(0);
                        if (info3 == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "LocationNotExists"));
                        if (!info3.getState().equals((Object)WHStateEnum.ACTIVE)) {
                            throw new TaskExternalException(info3.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "LocationNotActive"));
                        }
                        if (!warehouseInfo.getId().toString().equals(info3.getWarehouse().getId().toString())) {
                            throw new TaskExternalException(info3.getNumber() + " " + InvInitBillDataImport.getMyResource(ctx, "import_location_not_match_warehouse") + " " + warehouseInfo.getNumber());
                        }
                        entryInfo.setLocation(info3);
                    }
                    if (hsData.get("unit") != null) {
                        data2 = ((DataToken)hsData.get((Object)"unit")).data;
                    }
                    if (data2 == null) throw new TaskExternalException(InvInitBillDataImport.getResource(ctx, "UnitNotExists"));
                    number2 = data2.toString();
                    if (number2 != null) {
                        imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                        collection = imu.getMeasureUnitCollection(this.getFilter(number2));
                        if (collection == null || collection.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "UnitNotExists"));
                        MeasureUnitInfo info4 = collection.get(0);
                        this.checkUnit(ctx, materialInfo, info4);
                        if (info4 == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "UnitNotExists"));
                        entryInfo.setUnit(info4);
                        mui = info4;
                    }
                    if (entryInfo.getUnit() != null && (mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), entryInfo.getUnit().getId().toString())) != null) {
                        int qtyPrecision = mmu.getQtyPrecision();
                        for (int i2 = 0; i2 < QTY_PROPERTY.length; ++i2) {
                            if (entryInfo.getBigDecimal(QTY_PROPERTY[i2]) == null) continue;
                            entryInfo.setBigDecimal(QTY_PROPERTY[i2], entryInfo.getBigDecimal(QTY_PROPERTY[i2]).setScale(qtyPrecision, 4));
                        }
                    }
                    if (hsData.get("assistUnit") != null) {
                        data2 = ((DataToken)hsData.get((Object)"assistUnit")).data;
                    }
                    this.checkMaterialInfo(ctx, materialInfo, data2, 4);
                    if (data2 != null && (number2 = data2.toString()) != null && number2.trim().length() > 0) {
                        imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                        MeasureUnitCollection collection4 = imu.getMeasureUnitCollection(this.getFilter(number2));
                        if (collection4 == null || collection4.size() <= 0) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "AssistUnitNotExists"));
                        MeasureUnitInfo info5 = collection4.get(0);
                        if (info5 == null) throw new TaskExternalException(data2.toString() + " " + InvInitBillDataImport.getResource(ctx, "AssistUnitNotExists"));
                        this.checkAssistUnit(ctx, materialInfo, info5);
                        entryInfo.setAssistUnit(info5);
                    }
                    if (entryInfo.getAssistUnit() != null && (assistMmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), entryInfo.getAssistUnit().getId().toString())) != null) {
                        int assistQtyPrecision = assistMmu.getQtyPrecision();
                        for (int i3 = 0; i3 < ASSISTQTY_PROPERTY.length; ++i3) {
                            if (entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i3]) == null) continue;
                            entryInfo.setBigDecimal(ASSISTQTY_PROPERTY[i3], entryInfo.getBigDecimal(ASSISTQTY_PROPERTY[i3]).setScale(assistQtyPrecision, 4));
                        }
                        if (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(ZERO) == 0) {
                            BigDecimal qty = entryInfo.getQty();
                            BigDecimal assisqtyQty = InvAppUtils.getMultiUnitQty((Context)ctx, (MeasureUnitInfo)mui, (MeasureUnitInfo)entryInfo.getAssistUnit(), (MaterialInfo)materialInfo, (BigDecimal)qty);
                            entryInfo.setAssistQty(assisqtyQty);
                        }
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    IMeasureUnit imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                    MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                    entryInfo.setBaseUnit(baseUnit);
                    BigDecimal price = entryInfo.getCostPrice();
                    BigDecimal amount = entryInfo.getAmount();
                    BigDecimal yearRecAmount = entryInfo.getYearReceiptAmount();
                    BigDecimal yearIssAmount = entryInfo.getYearIssueAmount();
                    BigDecimal qty = entryInfo.getQty();
                    BigDecimal baseQty = InvAppUtils.getBaseUnitQty((Context)ctx, (MeasureUnitInfo)mui, (MeasureUnitInfo)baseUnit, (MaterialInfo)materialInfo, (BigDecimal)qty);
                    entryInfo.setBaseQty(baseQty);
                    ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
                    CurrencyInfo ci = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
                    if (amount != null) {
                        amount = amount.setScale(ci.getPrecision(), 4);
                    }
                    if (yearRecAmount != null) {
                        yearRecAmount = yearRecAmount.setScale(ci.getPrecision(), 4);
                    }
                    if (yearIssAmount != null) {
                        yearIssAmount = yearIssAmount.setScale(ci.getPrecision(), 4);
                    }
                    if (materialCompanyInfo != null) {
                        BigDecimal aPrice;
                        AccountType accountType = materialCompanyInfo.getAccountType();
                        if (accountType.equals((Object)AccountType.STANDARDCOST)) {
                            BigDecimal standardCost = materialCompanyInfo.getStandardCost();
                            BigDecimal unitPrice = InvAppUtils.getUnitPrice((Context)ctx, (MaterialInfo)materialInfo, (BigDecimal)standardCost, (MeasureUnitInfo)baseUnit, (MeasureUnitInfo)mui);
                            if (unitPrice.compareTo(price) != 0) {
                                errorString.append(materialInfo.getNumber()).append(" ").append(InvInitBillDataImport.getResource(ctx, "PRICE_NOT_EQUAL_STANDARDCOST")).append(unitPrice).append(" ").append(price);
                                throw new TaskExternalException(errorString.toString());
                            }
                            BigDecimal aAmount = qty.multiply(price);
                            if ((aAmount = aAmount.setScale(ci.getPrecision(), 4)).compareTo(amount) != 0) {
                                errorString = new StringBuffer();
                                errorString.append(materialInfo.getNumber()).append(" ").append(InvInitBillDataImport.getResource(ctx, "AmountIsError")).append(qty).append("\u00d7").append(price).append("=").append(aAmount).append(" != ").append(amount);
                                throw new TaskExternalException(errorString.toString());
                            }
                        } else if (qty != null && qty.compareTo(ZERO) != 0 && (aPrice = amount.divide(qty, materialInfo.getPricePrecision(), 4)).compareTo(price) != 0) {
                            errorString = new StringBuffer();
                            errorString.append(materialInfo.getNumber()).append(" ").append(InvInitBillDataImport.getResource(ctx, "PriceIsError")).append(amount).append("/").append(qty).append("=").append(aPrice).append(" != ").append(price);
                        }
                    }
                    entryInfo.setPrice(price);
                    BigDecimal recQty = entryInfo.getYearReceiptQty();
                    BigDecimal baseRecQty = InvAppUtils.getBaseUnitQty((Context)ctx, (MeasureUnitInfo)mui, (MeasureUnitInfo)baseUnit, (MaterialInfo)materialInfo, (BigDecimal)recQty);
                    entryInfo.setYearReceiptQty(baseRecQty);
                    BigDecimal isuQty = entryInfo.getYearIssueQty();
                    BigDecimal baseIsuQty = InvAppUtils.getBaseUnitQty((Context)ctx, (MeasureUnitInfo)mui, (MeasureUnitInfo)baseUnit, (MaterialInfo)materialInfo, (BigDecimal)isuQty);
                    entryInfo.setYearIssueQty(baseIsuQty);
                    if (materialCompanyInfo != null && materialCompanyInfo.getAccountType().equals((Object)AccountType.STANDARDCOST)) {
                        if (recQty != null && yearRecAmount != null && recQty.multiply(price).setScale(ci.getPrecision(), 4).compareTo(yearRecAmount) != 0) {
                            throw new TaskExternalException(materialInfo.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "YearRecAmountIsError"));
                        }
                        if (isuQty != null && yearIssAmount != null && isuQty.multiply(price).setScale(ci.getPrecision(), 4).compareTo(yearIssAmount) != 0) {
                            throw new TaskExternalException(materialInfo.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "YearIssueAmountIsError"));
                        }
                    }
                    if (materialCompanyInfo != null && !AccountType.STANDARDCOST.equals((Object)materialCompanyInfo.getAccountType())) {
                        entryInfo.setDiffAmount(ZERO);
                        entryInfo.setYearReceiptCostDiff(ZERO);
                        entryInfo.setYearIssueCostDiff(ZERO);
                    }
                    if (!storeTypeInfo.isIsForwardAmt()) {
                        entryInfo.setAmount(ZERO);
                        entryInfo.setDiffAmount(ZERO);
                        entryInfo.setYearIssueAmount(ZERO);
                        entryInfo.setYearIssueCostDiff(ZERO);
                        entryInfo.setYearReceiptAmount(ZERO);
                        entryInfo.setYearReceiptCostDiff(ZERO);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                try {
                    data = null;
                    if (hsData.get("FProjectNumber") != null) {
                        data = ((DataToken)hsData.get((Object)"FProjectNumber")).data;
                    }
                    if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block86;
                    IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    status = new HashSet<Integer>();
                    status.add(new Integer(4));
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.INCLUDE));
                    filter2 = new FilterInfo();
                    cu = this.sou.getCU();
                    cuPK = null;
                    cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                    try {
                        filter2 = iProject.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                    }
                    catch (EASBizException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    catch (BOSException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                    if (filter2 != null) {
                        filter.mergeFilter(filter2, "and");
                    }
                    viewInfo.setFilter(filter);
                    coll = iProject.getProjectCollection(viewInfo);
                    if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + InvInitBillDataImport.getResource(ctx, "PROJECT_NUMBER_ERROR", "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource"));
                    ProjectInfo projectInfo = coll.get(0);
                    entryInfo.setProject(projectInfo);
                }
                catch (Exception ex) {
                    throw new TaskExternalException(ex.getMessage(), ex.getCause());
                }
            }
            try {
                data = null;
                if (hsData.get("FTrackNumber") != null) {
                    data = ((DataToken)hsData.get((Object)"FTrackNumber")).data;
                }
                if (data == null || (number = data.toString()) == null || number.trim().length() <= 0) break block87;
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                status = new HashSet();
                status.add(new Integer(10));
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                filter2 = new FilterInfo();
                cu = this.sou.getCU();
                cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new ProjectInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll == null || coll.size() <= 0) throw new TaskExternalException(data.toString() + " " + InvInitBillDataImport.getResource(ctx, "TRACK_NUMBER_ERROR", "com.kingdee.eas.scm.im.inv.app.OtherBillDataImportResource"));
                TrackNumberInfo trackNumberInfo = coll.get(0);
                entryInfo.setTrackNumber(trackNumberInfo);
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage(), ex.getCause());
            }
        }
        if (errorString.length() <= 0) return entryInfo;
        throw new TaskExternalException(errorString.toString());
    }

    public static Date getEXP(Date curDate, int unit, int unitValue) {
        if (curDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(curDate);
            int field = 5;
            switch (unit) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                default: {
                    field = 5;
                }
            }
            calendar.add(field, unitValue);
            return calendar.getTime();
        }
        return null;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.invInit = null;
        int keyCursor = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (keyCursor == 0) {
                this.invInit = this.transmitHead(lineData, ctx);
                if (this.invInit == null) {
                    return null;
                }
            }
            InventoryInitEntryInfo entry = this.transmitEntry(lineData, ctx);
            int seq = this.invInit.getEntry().size() + 1;
            entry.setSeq(seq);
            entry.setParent(this.invInit);
            entry.setStorageOrgUnit(this.sou);
            entry.setCompanyOrgUnit(this.cou);
            this.invInit.getEntry().add(entry);
            ++keyCursor;
        }
        return this.invInit;
    }

    private void checkWarehouse(Context ctx, WarehouseInfo warehouseInfo, StorageOrgUnitInfo sou) throws TaskExternalException, BOSException, EASBizException {
        ISOAccreditWH iso = SOAccreditWHFactory.getLocalInstance((Context)ctx);
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("WAREHOUSE", (Object)warehouseInfo.getId().toString(), CompareType.EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("STORAGEORG", (Object)sou.getId().toString(), CompareType.EQUALS));
        if (!iso.exists(fi)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "RelationNotExists"));
        }
        if (iso.isStarted(sou, warehouseInfo)) {
            throw new TaskExternalException(warehouseInfo.getNumber() + "," + sou.getNumber() + " " + InvInitBillDataImport.getResource(ctx, "AlreadyClosed"));
        }
    }

    private void checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, InventoryInitEntryInfo entryInfo) throws TaskExternalException, BOSException, EASBizException {
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        MaterialInventoryInfo materialInventoryInfo = this.getInventoryInfo(materialInfo.getId().toString(), sou.getId().toString());
        boolean isPeriodValid = materialInventoryInfo.isIsPeriodValid();
        boolean isLotNumber = materialInventoryInfo.isIsLotNumber();
        Date exp = entryInfo.getExp();
        Date mfg = entryInfo.getMfg();
        if (!isLotNumber && data != null && data.toString().length() > 0) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotLotManager"));
        }
        if (isLotNumber && (data == null || data.toString().length() <= 0) && this.isWarehouseLotNecessary(entryInfo.getStoreType())) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "LotManager"));
        }
        if (isLotNumber && data != null && data.toString().length() > 0 && !this.isWarehouseLotNecessary(entryInfo.getStoreType())) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "ArUpdateInventoryLotNotNull"));
        }
        if (!isPeriodValid && mfg != null && mfg.toString().length() > 0) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotPVManagerMFGNull"));
        }
        if (isPeriodValid && (mfg == null || mfg.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotPVManagerMFGNotNull"));
        }
        if (!isPeriodValid && exp != null && exp.toString().length() > 0) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotPVManagerEXPNull"));
        }
        if (isPeriodValid && (exp == null || exp.toString().length() <= 0)) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotPVManagerEXPNotNull"));
        }
        if (isPeriodValid && entryInfo.getExp().before(entryInfo.getMfg())) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "EXPMustBeforeEXP"));
        }
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "UnitNotExists"));
        }
    }

    private void checkMaterialInfo(Context ctx, MaterialInfo materialInfo, Object data, int type) throws TaskExternalException, BOSException {
        if (type == 3) {
            AsstAttrTypeInfo asstAttrTypeInfo = materialInfo.getAssistAttr();
            if (asstAttrTypeInfo == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotSetAssistProperty"));
            }
            if (asstAttrTypeInfo != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "SetAssistProperty"));
            }
        } else if (type == 4) {
            MeasureUnitInfo assistUnit = materialInfo.getAssistUnit();
            if (assistUnit == null && data != null && data.toString().length() > 0) {
                throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "NotSetAssistUnit"));
            }
            if (assistUnit != null && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "SetAssistUnit"));
            }
        }
    }

    private void checkStoreTypeEtc(Context ctx, StoreTypeInfo storeTypeInfo, Object data, int type) throws TaskExternalException {
        StoreFlagEnum storeFlag = storeTypeInfo.getStoreFlag();
        if (type == 0) {
            if (this.isWarehouseLotNecessary(storeTypeInfo)) {
                if (data == null || data.toString().length() == 0) {
                    throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "WarehouseCanNotNull"));
                }
            } else if (data != null && data.toString().length() > 0) {
                throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "ArUpdateInventoryWarehouseNotNull"));
            }
        } else if (type == 1) {
            if (StoreFlagEnum.TOCUSTOMER.equals((Object)storeFlag) || StoreFlagEnum.CUSTOMER.equals((Object)storeFlag)) {
                if (data == null || data.toString().length() == 0) {
                    throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "StoreTypeAboutCustomerNeedCustomer"));
                }
            } else if (data != null && data.toString().length() > 0) {
                throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "StoreTypeNotAboutCustomerNeedNotCustomer"));
            }
        } else if (type == 2) {
            if (StoreFlagEnum.TOSUPPLIER.equals((Object)storeFlag) || StoreFlagEnum.SUPPLIER.equals((Object)storeFlag)) {
                if (data == null || data.toString().length() == 0) {
                    throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "StoreTypeAboutSupplierNeedSupplier"));
                }
            } else if (data != null && data.toString().length() > 0) {
                throw new TaskExternalException(storeTypeInfo.getNumber() + InvInitBillDataImport.getResource(ctx, "StoreTypeNotAboutSupplierNeedNotSupplier"));
            }
        }
    }

    private void checkAssistUnit(Context ctx, MaterialInfo mi, MeasureUnitInfo mui) throws TaskExternalException {
        MeasureUnitInfo amui = mi.getAssistUnit();
        if (!amui.getId().equals((Object)mui.getId())) {
            throw new TaskExternalException(mi.getName() + InvInitBillDataImport.getResource(ctx, "AssistQtyIsError"));
        }
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof CoreBillBaseInfo)) {
            return;
        }
        try {
            InventoryInitBillInfo bill = (InventoryInitBillInfo)coreBaseInfo;
            String id = this.getIdFromNumber(bill.getNumber(), ctx);
            IObjectPK userPK = ctx.getCaller();
            ObjectUuidPK orgPK = new ObjectUuidPK(bill.getStorageOrgUnit().getId());
            if (StringUtil.isEmptyString((String)id)) {
                SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPK, (IObjectPK)orgPK, (String)"inventoryinit_new");
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPK, (IObjectPK)orgPK, (String)"inventoryinit_update");
                coreBaseInfo.setId(BOSUuid.read((String)id));
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(id), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        InventoryInitBillCollection collection;
        try {
            collection = InventoryInitBillFactory.getLocalInstance((Context)ctx).getInventoryInitBillCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && (currentNumber.data == null || currentNumber.data.toString().length() == 0 || firstNumber.data.equals(currentNumber.data));
    }

    public String getMainField() {
        return "number";
    }

    private String getDateString(int i, Context ctx) {
        String returnString = null;
        if (0 == i) {
            returnString = InvInitBillDataImport.getResource(ctx, "InventoryBizDate");
        }
        if (1 == i) {
            returnString = InvInitBillDataImport.getResource(ctx, "InventoryMFG");
        }
        if (2 == i) {
            returnString = InvInitBillDataImport.getResource(ctx, "InventoryEXP");
        }
        return returnString;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            result.put("number", DataImportUtils.transformValue((Object)rs.getString("number")));
            result.put("storageOrgUnit", DataImportUtils.transformValue((Object)rs.getString("storageOrgUnit.number")));
            result.put("storageOrgUnitName", DataImportUtils.transformValue((Object)rs.getString("storageOrgUnit.name")));
            result.put("bizDate", DataImportUtils.transformValue((Object)rs.getString("bizDate")));
            result.put("material", DataImportUtils.transformValue((Object)rs.getString("material.number")));
            result.put("materialName", DataImportUtils.transformValue((Object)rs.getString("material.name")));
            result.put("assistProperty", DataImportUtils.transformValue((Object)rs.getString("assistProperty.number")));
            result.put("assistPropertyName", DataImportUtils.transformValue((Object)rs.getString("assistProperty.name")));
            result.put("unit", DataImportUtils.transformValue((Object)rs.getString("unit.number")));
            result.put("unitName", DataImportUtils.transformValue((Object)rs.getString("unit.name")));
            result.put("lot", DataImportUtils.transformValue((Object)rs.getString("entry.lot")));
            result.put("mfg", DataImportUtils.transformValue((Object)rs.getString("entry.mfg")));
            result.put("exp", DataImportUtils.transformValue((Object)rs.getString("entry.exp")));
            result.put("qty", DataImportUtils.transformValue((Object)rs.getString("entry.qty")));
            result.put("assistUnit", DataImportUtils.transformValue((Object)rs.getString("assistantUnit.number")));
            result.put("assistUnitName", DataImportUtils.transformValue((Object)rs.getString("assistantUnit.name")));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("assistantUnit.number")).toString()) || DataImportUtils.transformValue((Object)rs.getString("assistantUnit.number")).toString().length() < 1) {
                result.put("assistQty", DataImportUtils.transformValue(null));
            } else {
                result.put("assistQty", DataImportUtils.transformValue((Object)rs.getString("entry.assistQty")));
            }
            result.put("costPrice", DataImportUtils.transformValue((Object)rs.getString("entry.costPrice")));
            result.put("amount", DataImportUtils.transformValue((Object)rs.getString("entry.amount")));
            result.put("warehouse", DataImportUtils.transformValue((Object)rs.getString("warehouse.number")));
            result.put("warehouseName", DataImportUtils.transformValue((Object)rs.getString("warehouse.name")));
            result.put("location", DataImportUtils.transformValue((Object)rs.getString("location.number")));
            result.put("locationName", DataImportUtils.transformValue((Object)rs.getString("location.name")));
            result.put("storeType", DataImportUtils.transformValue((Object)rs.getString("storeType.number")));
            result.put("storeTypeName", DataImportUtils.transformValue((Object)rs.getString("storeType.name")));
            result.put("storeStatus", DataImportUtils.transformValue((Object)rs.getString("storeStatus.number")));
            result.put("storeStatusName", DataImportUtils.transformValue((Object)rs.getString("storeStatus.name")));
            result.put("customer", DataImportUtils.transformValue((Object)rs.getString("customer.number")));
            result.put("customerName", DataImportUtils.transformValue((Object)rs.getString("customer.name")));
            result.put("supplier", DataImportUtils.transformValue((Object)rs.getString("supplier.number")));
            result.put("supplierName", DataImportUtils.transformValue((Object)rs.getString("supplier.name")));
            result.put("diffAmount", DataImportUtils.transformValue((Object)rs.getString("entry.diffAmount")));
            result.put("yearReceiptQty", DataImportUtils.transformValue((Object)SCMServerUtils.toPlainString((BigDecimal)rs.getBigDecimal("entry.yearReceiptQty"))));
            result.put("yearReceiptAmount", DataImportUtils.transformValue((Object)rs.getString("entry.yearReceiptAmount")));
            result.put("yearIssueQty", DataImportUtils.transformValue((Object)SCMServerUtils.toPlainString((BigDecimal)rs.getBigDecimal("entry.yearIssueQty"))));
            result.put("yearIssueAmount", DataImportUtils.transformValue((Object)rs.getString("entry.yearIssueAmount")));
            result.put("yearReceiptAssistQty", DataImportUtils.transformValue((Object)SCMServerUtils.toPlainString((BigDecimal)rs.getBigDecimal("entry.yearReceiptAssistQty"))));
            result.put("yearIssueAssistQty", DataImportUtils.transformValue((Object)SCMServerUtils.toPlainString((BigDecimal)rs.getBigDecimal("entry.yearIssueAssistQty"))));
            result.put("yearReceiptCostDiff", DataImportUtils.transformValue((Object)rs.getString("entry.yearReceiptCostDiff")));
            result.put("yearIssueCostDiff", DataImportUtils.transformValue((Object)rs.getString("entry.yearIssueCostDiff")));
            result.put("FProjectNumber", DataImportUtils.transformValue((Object)rs.getString("project.number")));
            result.put("FTrackNumber", DataImportUtils.transformValue((Object)rs.getString("trackNumber.number")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo;
        FilterInfo filterInfo = new FilterInfo();
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Storage, (String)"inventoryinit_export");
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        if ((oldFilterInfo = (FilterInfo)this.getContextParameter("filter")) == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.im.inv.InventoryInitExportQuery";
    }

    private boolean isWarehouseLotNecessary(StoreTypeInfo storeTypeInfo) {
        if (storeTypeInfo != null && "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(storeTypeInfo.getId().toString())) {
            return !this.isArUpdateInventory;
        }
        return true;
    }
}

