/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.LargePartsQDPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.LargePartsQDPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractLargePartsQDPriceStorageControllerBean;
import com.kingdee.eas.industry.emm.pcm.basedata.projecttypecategory.ProjectTypesCategoryFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.projecttypecategory.ProjectTypesCategoryInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LargePartsQDPriceStorageControllerBean
extends AbstractLargePartsQDPriceStorageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.LargePartsQDPriceStorageControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LargePartsQDPriceStorageInfo li = LargePartsQDPriceStorageFactory.getLocalInstance(ctx).getLargePartsQDPriceStorageInfo(pk);
        if (li.getStatus().getValue() == 2) {
            throw new EASBizException(new NumericExceptionSubItem("007", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0065", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ClassificationCodeInfo cci;
        LargePartsQDPriceStorageInfo li = (LargePartsQDPriceStorageInfo)model;
        this.check(ctx, li);
        if (li.getMaterialNumber() != null && li.getMaterialNumber().getId() != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)li.getMaterialNumber().getId(), CompareType.EQUALS));
            ev.setFilter(filter);
            MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(ev);
            if (mc != null && mc.size() > 0) {
                MaterialInfo mi = mc.get(0);
                li.setMaterialNumber(mi);
                li.setMaterialName(mi.getName());
                li.setTypesize(mi.getModel());
                li.setUnit(mi.getBaseUnit());
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0066", (Locale)ctx.getLocale())));
            }
        }
        if (li.getClassificationCode() != null && li.getClassificationCode().getId() != null && (cci = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeInfo((IObjectPK)new ObjectUuidPK(li.getClassificationCode().getId()))) != null) {
            ProjectTypesInfo projectTypesInfo;
            li.setClassficationCodeName(cci.getName());
            if (cci.getProjectTypes() != null && (projectTypesInfo = ProjectTypesFactory.getLocalInstance(ctx).getProjectTypesInfo((IObjectPK)new ObjectUuidPK(cci.getProjectTypes().getId()))) != null && projectTypesInfo.getCategory() != null) {
                ProjectTypesCategoryInfo projectTypesCategoryInfo = ProjectTypesCategoryFactory.getLocalInstance(ctx).getProjectTypesCategoryInfo((IObjectPK)new ObjectUuidPK(projectTypesInfo.getCategory().getId()));
                li.setCategory(projectTypesCategoryInfo);
            }
        }
        li.setPrice(li.getPrice() == null ? BigDecimal.ZERO : li.getPrice().setScale(2, 4));
        BigDecimal allAmount = BigDecimal.ZERO;
        BigDecimal qty = li.getQty() == null ? BigDecimal.ZERO : li.getQty();
        li.setAmount(allAmount.add(qty.multiply(li.getPrice())).setScale(2, 4));
        li.setStatus(EnabledStateEnum.SAVE);
        li.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? null : ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return super._submit(ctx, (IObjectValue)li);
    }

    private void check(Context ctx, LargePartsQDPriceStorageInfo li) throws EASBizException {
        if (li.getClassificationCode() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0010", (Locale)ctx.getLocale())));
        }
        if (li.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0067", (Locale)ctx.getLocale())));
        }
        if (li.getQty() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0068", (Locale)ctx.getLocale())));
        }
        if (li.getPrice() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0069", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LargePartsQDPriceStorageInfo li = (LargePartsQDPriceStorageInfo)model;
        this.check(ctx, li);
        return super._addnew(ctx, (IObjectValue)li);
    }
}

