/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.MarketFitPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractMarketFitPriceStorageControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MarketFitPriceStorageControllerBean
extends AbstractMarketFitPriceStorageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.MarketFitPriceStorageControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MarketFitPriceStorageInfo mi = MarketFitPriceStorageFactory.getLocalInstance(ctx).getMarketFitPriceStorageInfo(pk);
        if (mi.getStatus().getValue() == 2) {
            throw new EASBizException(new NumericExceptionSubItem("007", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0054", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkMaterialNumber(ctx, model);
        MarketFitPriceStorageInfo li = (MarketFitPriceStorageInfo)model;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)li.getMaterialNumber().getId(), CompareType.EQUALS));
        ev.setFilter(filter);
        MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(ev);
        if (mc == null || mc.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0066", (Locale)ctx.getLocale())));
        }
        MaterialInfo mi = mc.get(0);
        li.setMaterialNumber(mi);
        li.setMaterialName(mi.getName());
        li.setTypesize(mi.getModel());
        li.setMeasureUnit(mi.getBaseUnit());
        li.setEstimatePrice(li.getEstimatePrice() == null ? BigDecimal.ZERO : li.getEstimatePrice().setScale(2, 4));
        li.setTargetPrice(li.getTargetPrice() == null ? BigDecimal.ZERO : li.getTargetPrice().setScale(2, 4));
        li.setStatus(EnabledStateEnum.SAVE);
        li.setUpdateDate(new Date());
        if (li.getCtrlUnit() == null) {
            li.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? null : ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        return super._submit(ctx, (IObjectValue)li);
    }

    private void checkMaterialNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        MarketFitPriceStorageInfo mi = (MarketFitPriceStorageInfo)model;
        if (mi == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0070", (Locale)ctx.getLocale())));
        }
        if (mi.getMaterialNumber() != null) {
            MarketFitPriceStorageCollection mc;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.id", (Object)mi.getMaterialNumber().getId().toString(), CompareType.EQUALS));
            if (mi.getId() != null) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)mi.getId().toString(), CompareType.NOTEQUALS));
            }
            if ((mc = MarketFitPriceStorageFactory.getLocalInstance(ctx).getMarketFitPriceStorageCollection(view)) != null && mc.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0071", (Locale)ctx.getLocale())));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", (String)"0EMMPCBASE-0072", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }
}

