/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.ClassificationCodeInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.PartsPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PartsPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.PartsPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractPartsPriceStorageControllerBean;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PartsPriceStorageControllerBean
extends AbstractPartsPriceStorageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.PartsPriceStorageControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PartsPriceStorageInfo pi = PartsPriceStorageFactory.getLocalInstance(ctx).getPartsPriceStorageInfo(pk);
        if (pi.getStatus().getValue() == 2) {
            throw new EASBizException(new NumericExceptionSubItem("003", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0060")));
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.check(ctx, model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.check(ctx, model);
        PartsPriceStorageInfo li = (PartsPriceStorageInfo)model;
        this.check(ctx, (IObjectValue)li);
        if (li.getMaterialNumber() != null && li.getMaterialNumber().getId() != null) {
            MaterialInfo mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(li.getMaterialNumber().getId()));
            if (mi != null) {
                li.setMaterialNumber(mi);
                li.setMaterialName(mi.getName());
                li.setTypeSize(mi.getModel());
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0066")));
            }
        }
        if (li.getClassificationCode().getId() != null) {
            ClassificationCodeInfo cci = ClassificationCodeFactory.getLocalInstance(ctx).getClassificationCodeInfo((IObjectPK)new ObjectUuidPK(li.getClassificationCode().getId()));
            if (cci != null && cci.size() > 0) {
                li.setClassificationCodeName(cci.getName());
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0076")));
            }
        }
        if (li.getProjectNumber().getId() != null) {
            ProjectInfo pi = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(li.getProjectNumber().getId()));
            if (pi != null) {
                li.setProjectName(pi.getName());
            } else {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0077")));
            }
        }
        li.setComputedPrice(li.getComputedPrice() == null ? BigDecimal.ZERO : li.getComputedPrice().setScale(2, 4));
        li.setApproximatePrice(li.getApproximatePrice() == null ? BigDecimal.ZERO : li.getApproximatePrice().setScale(2, 4));
        li.setBudgetPrice(li.getBudgetPrice() == null ? BigDecimal.ZERO : li.getBudgetPrice().setScale(2, 4));
        li.setTargetPrice1(li.getTargetPrice1() == null ? BigDecimal.ZERO : li.getTargetPrice1().setScale(2, 4));
        li.setTargetPrice2(li.getTargetPrice2() == null ? BigDecimal.ZERO : li.getTargetPrice2().setScale(2, 4));
        li.setActualPurPrice(li.getActualPurPrice() == null ? BigDecimal.ZERO : li.getActualPurPrice().setScale(2, 4));
        li.setLabourCost(li.getLabourCost() == null ? BigDecimal.ZERO : li.getLabourCost().setScale(2, 4));
        li.setOtherCost(li.getOtherCost() == null ? BigDecimal.ZERO : li.getOtherCost().setScale(2, 4));
        li.setTotalCost(li.getTotalCost() == null ? BigDecimal.ZERO : li.getTotalCost().setScale(2, 4));
        li.setBidingPrice(li.getBidingPrice() == null ? BigDecimal.ZERO : li.getBidingPrice().setScale(2, 4));
        li.setStatus(EnabledStateEnum.SAVE);
        if (li.getUpdateDate() == null) {
            li.setUpdateDate(new Date());
        }
        if (li.getCtrlUnit() == null) {
            li.setCtrlUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? null : ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        return super._submit(ctx, (IObjectValue)li);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.check(ctx, model);
        return super._addnew(ctx, model);
    }

    public void check(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PartsPriceStorageInfo pi = (PartsPriceStorageInfo)model;
        if (pi.getClassificationCode() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0010")));
        }
        if (pi.getProjectNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0078")));
        }
        if (pi.getMeasureUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0079")));
        }
        if (pi.getMaterialNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0080")));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("projectNumber", (Object)pi.getProjectNumber().getId()));
        filter.getFilterItems().add(new FilterItemInfo("materialNumber", (Object)pi.getMaterialNumber().getId()));
        if (pi.getPurSupplier() != null) {
            filter.getFilterItems().add(new FilterItemInfo("purSupplier", (Object)pi.getPurSupplier().getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("purSupplier", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pi.getId(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        PartsPriceStorageCollection c = this.getPartsPriceStorageCollection(ctx, view);
        if (c != null && c.size() > 0) {
            ProjectInfo project = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(pi.getProjectNumber().getId()));
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(pi.getMaterialNumber().getId()));
            String s = "";
            if (pi.getPurSupplier() != null) {
                SupplierInfo info = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(pi.getPurSupplier().getId()));
                s = this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0081") + info.getNumber();
            }
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0082") + project.getNumber() + s + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0083") + material.getNumber() + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0084") + this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0085")));
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.check(ctx, model);
        return super._save(ctx, model);
    }

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

