/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.pcm.basedata.EnabledStateEnum;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageCollection;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageFactory;
import com.kingdee.eas.industry.emm.pcm.basedata.PurMaterialPriceStorageInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractPurMaterialPriceStorageControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurMaterialPriceStorageControllerBean
extends AbstractPurMaterialPriceStorageControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static final long serialVersionUID = -7642061516262050454L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.PurMaterialPriceStorageControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurMaterialPriceStorageInfo pi = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageInfo(pk);
        if (pi.getStatus().getValue() == 2) {
            throw new EASBizException(new NumericExceptionSubItem("003", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0092")));
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkMaterialNumber(ctx, model);
        PurMaterialPriceStorageInfo li = (PurMaterialPriceStorageInfo)model;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)li.getMaterialNumber().getId(), CompareType.EQUALS));
        ev.setFilter(filter);
        MaterialCollection mc = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(ev);
        if (mc == null || mc.size() <= 0) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0066")));
        }
        MaterialInfo mi = mc.get(0);
        li.setMaterialNumber(mi);
        li.setMaterialName(mi.getName());
        li.setModelAndSize(mi.getModel());
        li.setUnitOfMeasurement(mi.getBaseUnit());
        li.setPlanPrice(li.getPlanPrice() == null ? BigDecimal.ZERO : li.getPlanPrice().setScale(2, 4));
        li.setMinPurPrice(li.getMinPurPrice() == null ? BigDecimal.ZERO : li.getMinPurPrice().setScale(2, 4));
        li.setAvePurPrice(li.getAvePurPrice() == null ? BigDecimal.ZERO : li.getAvePurPrice().setScale(2, 4));
        li.setMaxPurPrice(li.getMaxPurPrice() == null ? BigDecimal.ZERO : li.getMaxPurPrice().setScale(2, 4));
        li.setSparepartsPrice(li.getSparepartsPrice() == null ? BigDecimal.ZERO : li.getSparepartsPrice().setScale(2, 4));
        li.setStatus(EnabledStateEnum.SAVE);
        li.setUpdateTime(new Date());
        if (li.getCtrlOrgUnit() == null) {
            li.setCtrlOrgUnit(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? null : ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        return super._submit(ctx, (IObjectValue)li);
    }

    private void checkMaterialNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PurMaterialPriceStorageInfo pi = (PurMaterialPriceStorageInfo)model;
        if (pi == null) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0070")));
        }
        if (pi.getMaterialNumber() != null) {
            PurMaterialPriceStorageCollection pc;
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("materialNumber.id", (Object)pi.getMaterialNumber().getId().toString(), CompareType.EQUALS));
            if (pi.getId() != null) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)pi.getId().toString(), CompareType.NOTEQUALS));
            }
            if ((pc = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageCollection(view)) != null && pc.size() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0071")));
            }
        } else {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0072")));
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    public Map getPriceAndSup(Context ctx, Map map) throws BOSException {
        String materialid = (String)map.get("materialid");
        StringBuffer sb = new StringBuffer();
        HashMap<String, Object> nm = new HashMap<String, Object>();
        if (materialid != null) {
            sb.append("/*dialect*/select min(obe.fprice) minprice,max(obe.fprice) maxprice,avg(obe.fprice) avgprice from T_AP_OtherBillentry obe inner join T_AP_OtherBill ob on ob.fid=obe.fparentid  where obe.fmaterialid='" + materialid + "' and ob.FBillStatus=" + 4);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rs != null) {
                try {
                    while (rs.next()) {
                        BigDecimal minPrice = null;
                        BigDecimal maxPrice = null;
                        BigDecimal avgPrice = null;
                        minPrice = rs.getBigDecimal("minprice");
                        maxPrice = rs.getBigDecimal("maxprice");
                        avgPrice = rs.getBigDecimal("avgprice");
                        nm.put("minPrice", minPrice.setScale(2, 4));
                        nm.put("maxPrice", maxPrice.setScale(2, 4));
                        nm.put("avgPrice", avgPrice.setScale(2, 4));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            try {
                rs.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            sb.setLength(0);
            sb.append("/*dialect*/select ob.fasstactid supplierid,obe.fprice fprice   from T_AP_OtherBillEntry obe inner join  T_AP_OtherBill ob on obe.fparentid=ob.fid where ob.fasstacttypeid='YW3xsAEJEADgAAVEwKgTB0c4VZA=' and ob.FBillStatus=4");
            sb.append(" and  obe.fmaterialid='" + materialid + "'");
            sb.append(" and ob.fbizdate=(select max(obt.fbizdate) from T_AP_OtherBill obt where fbizdate in(select om.fbizdate   from T_AP_OtherBillEntry obk inner join  T_AP_OtherBill om on obk.fparentid=om.fid where om.fasstacttypeid='YW3xsAEJEADgAAVEwKgTB0c4VZA=' and ob.FBillStatus=4");
            sb.append(" and  obk.fmaterialid='" + materialid + "') ) and rownum=1 ");
            IRowSet rsn = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            if (rsn != null) {
                BigDecimal latestPrice = null;
                String supplierid = null;
                try {
                    while (rsn.next()) {
                        latestPrice = null;
                        supplierid = null;
                        supplierid = rsn.getString("supplierid");
                        latestPrice = rsn.getBigDecimal("fprice");
                        nm.put("supplierid", supplierid);
                        nm.put("latestPrice", latestPrice);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        if (nm.size() < 5) {
            if (!nm.containsKey("minPrice")) {
                nm.put("minPrice", null);
            } else if (!nm.containsKey("maxPrice")) {
                nm.put("maxPrice", null);
            } else if (!nm.containsKey("avgPrice")) {
                nm.put("avgPrice", null);
            } else if (!nm.containsKey("latestPrice") && !nm.containsKey("supplierid")) {
                nm.put("latestPrice", null);
                nm.put("supplierid", null);
            }
        }
        return nm;
    }

    @Override
    public Map _updatePurPrice(Context ctx, Map map) throws BOSException {
        Map nm = new HashMap();
        Set set = map.entrySet();
        Iterator it = set.iterator();
        StringBuffer sql = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Map mgp = (Map)entry.getValue();
            Set st = mgp.entrySet();
            Iterator itn = st.iterator();
            while (itn.hasNext()) {
                String bid = null;
                String mid = null;
                Map.Entry en = itn.next();
                bid = en.getKey().toString().split("%")[1];
                mid = en.getValue().toString();
                sql.setLength(0);
                sql.append(" /*dialect*/update CT_PCM_PurMaterialPriceStorage pmps set( pmps.cfminpurprice,pmps.cfmaxpurprice,pmps.cfavepurprice,pmps.CFLatestPurPrice,pmps.CFNewestPurSupplie,Cfupdatetime)=");
                sql.append(" (select FZ.minfprice,FZ.maxfprice,FZ.avgfprice,NM.flastPrice,NM.supplierid,sysdate from");
                sql.append("(select obe.fmaterialid as  fmaterialid,min(obe.fprice) as minfprice,max(obe.fprice) as maxfprice,avg(obe.fprice) as avgfprice");
                sql.append(" from T_AP_OtherBillEntry obe");
                sql.append(" inner join T_AP_OtherBill ob on ob.fid=obe.fparentid and ob.fasstacttypeid='YW3xsAEJEADgAAVEwKgTB0c4VZA=' and ob.FBillStatus=3");
                sql.append(" where obe.fmaterialid='" + mid + "'");
                sql.append(" group by obe.fmaterialid");
                sql.append(" ) FZ,");
                sql.append("(");
                sql.append("select obe.fmaterialid as fmaterialid,obe.fprice as flastPrice,ob.fasstactid as supplierid  from T_AP_OtherBillEntry obe inner join  T_AP_OtherBill ob on obe.fparentid=ob.fid where ob.fasstacttypeid='YW3xsAEJEADgAAVEwKgTB0c4VZA=' and ob.FBillStatus=3");
                sql.append(" and  obe.fmaterialid='" + mid + "'");
                sql.append(" and ob.fbizdate=(select max(obt.fbizdate) from T_AP_OtherBill obt where fbizdate in(select om.fbizdate   from T_AP_OtherBillEntry obk inner join  T_AP_OtherBill om on obk.fparentid=om.fid where om.fasstacttypeid='YW3xsAEJEADgAAVEwKgTB0c4VZA=' and oM.FBillStatus=3");
                sql.append(" and  obk.fmaterialid='" + mid + "') ) and rownum=1 ");
                sql.append(") NM");
                sql.append(" where FZ.fmaterialid=NM.fmaterialid)");
                sql.append(" where pmps.fid='" + bid + "'");
                try {
                    DbUtil.execute((Context)ctx, (String)sql.toString());
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    try {
                        PurMaterialPriceStorageInfo pi = PurMaterialPriceStorageFactory.getLocalInstance(ctx).getPurMaterialPriceStorageInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bid)));
                        String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DJGXSJC", (Locale)ctx.getLocale(), (Object[])new Object[]{pi.getNumber()});
                        throw new EASBizException(new NumericExceptionSubItem("003", strInfo));
                    }
                    catch (EASBizException e1) {
                        logger.equals((Object)e1);
                    }
                }
            }
            nm = mgp;
        }
        return nm;
    }

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

