/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.industry.emm.pcm.basedata.SparePartPriceInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.app.AbstractSparePartPriceControllerBean;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.NumericExceptionSubItem;
import java.util.Locale;
import org.apache.log4j.Logger;

public class SparePartPriceControllerBean
extends AbstractSparePartPriceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basedata.app.SparePartPriceControllerBean");
    private String controlType;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SparePartPriceInfo info = (SparePartPriceInfo)model;
        StringBuffer errorInfo = new StringBuffer();
        errorInfo.append("");
        if (info.getMaterial() == null) {
            errorInfo.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0117"));
        }
        if (info.getProject() == null) {
            errorInfo.append(this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0118"));
        }
        ProjectInfo projectInfo = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(info.getProject().getId()));
        info.setProject(projectInfo);
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(info.getMaterial().getId()));
        info.setMaterial(materialInfo);
        info.setMaterialName(materialInfo.getName());
        info.setMaterialModel(materialInfo.getModel());
        info.setMaterialUnit(materialInfo.getBaseUnit() == null ? "" : materialInfo.getBaseUnit().getName());
        if (errorInfo.length() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("", errorInfo.toString()));
        }
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filterCU;
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        String proNumber = ((ProjectInfo)dataBaseInfo.get("project")).getNumber();
        String materialNumber = ((MaterialInfo)dataBaseInfo.get("material")).getNumber();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("material.number", (Object)materialNumber, CompareType.EQUALS);
        FilterItemInfo filterItemPro = new FilterItemInfo("project.number", (Object)proNumber, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.getFilterItems().add(filterItemPro);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getControlType(ctx, dataBaseInfo).equals("") && FilterUtility.hasFilterItem((FilterInfo)(filterCU = this.getFilterForDefaultCU(ctx, model)))) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", this.getResourceString(ctx, "com.kingdee.eas.industry.emm.pcm.basedata.EMMPCBaseResource", "0EMMPCBASE-0119") + proNumber + ":" + materialNumber));
        }
    }

    private String getControlType(Context ctx, DataBaseInfo info) throws BOSException {
        if (this.controlType != null) {
            return this.controlType;
        }
        this.controlType = "";
        EntityObjectInfo eoi = this.getBOSEntity(ctx, (CoreBaseInfo)info);
        boolean hasShareType = false;
        hasShareType = eoi.containsExtendedPropertyKey("controlType");
        if (hasShareType) {
            this.controlType = eoi.getExtendedProperty("controlType");
        } else if (eoi.getBaseEntity().getName().equals("DataBaseD")) {
            this.controlType = "D";
        }
        return this.controlType;
    }

    private String getResourceString(Context ctx, String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }
}

