/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.industry.emm.common.BillBaseStatusEnum;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.ManchinePartsCostTestBillEntryCollection;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.ManchinePartsCostTestBillEntryInfo;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.ManchinePartsCostTestBillFactory;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.ManchinePartsCostTestBillInfo;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.MaterialClassificationFactory;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.MaterialClassificationInfo;
import com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.app.AbstractManchinePartsCostTestBillControllerBean;
import com.kingdee.eas.industry.emm.pcm.basework.straight.MaterialDensityCollection;
import com.kingdee.eas.industry.emm.pcm.basework.straight.MaterialDensityFactory;
import com.kingdee.eas.industry.emm.pcm.basework.straight.MaterialDensityInfo;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ManchinePartsCostTestBillControllerBean
extends AbstractManchinePartsCostTestBillControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.PCLCMResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.basework.smallproductscost.app.ManchinePartsCostTestBillControllerBean");
    private final double RATE_VALUE = 1.17;

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManchinePartsCostTestBillInfo mcbi = (ManchinePartsCostTestBillInfo)model;
        if (mcbi.getBillStatus().getValue() != 0 && mcbi.getBillStatus().getValue() != 1 && mcbi.getBillStatus().getValue() != 2) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0182", (Locale)ctx.getLocale())));
        }
        this.checkValue(ctx, mcbi);
        mcbi.setBillStatus(BillBaseStatusEnum.SUBMITED);
        return super._submit(ctx, model);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ManchinePartsCostTestBillInfo aci = (ManchinePartsCostTestBillInfo)model;
        if (aci.getBillStatus().getValue() != 2) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0183", (Locale)ctx.getLocale())));
        }
        aci.setBillStatus(BillBaseStatusEnum.AUDITED);
        UserInfo ui = ContextUtil.getCurrentUserInfo((Context)ctx);
        aci.setAuditTime(new Date());
        aci.setAuditor(ui);
        super._update(ctx, pk, (IObjectValue)aci);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        ManchinePartsCostTestBillInfo aci = (ManchinePartsCostTestBillInfo)model;
        if (aci.getBillStatus().getValue() != 4) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0184", (Locale)ctx.getLocale())));
        }
        aci.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        aci.setAuditor(null);
        aci.setAuditTime(null);
        super._update(ctx, pk, (IObjectValue)aci);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ManchinePartsCostTestBillInfo aci = ManchinePartsCostTestBillFactory.getLocalInstance(ctx).getManchinePartsCostTestBillInfo(pk);
        if (aci.getBillStatus().getValue() == 4) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0185", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ManchinePartsCostTestBillInfo mcbi = (ManchinePartsCostTestBillInfo)model;
        if (mcbi.getBillStatus().getValue() == 4) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0186", (Locale)ctx.getLocale())));
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ManchinePartsCostTestBillInfo mcbi = (ManchinePartsCostTestBillInfo)model;
        if (mcbi.getBillStatus().getValue() != 1 && mcbi.getBillStatus().getValue() != 0) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0187", (Locale)ctx.getLocale())));
        }
        this.checkValue(ctx, mcbi);
        mcbi.setBizDate(new Date());
        AdminOrgUnitInfo adi = ContextUtil.getCurrentAdminUnit((Context)ctx);
        mcbi.setAdminOrgUnit(adi);
        mcbi.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        StringBuffer sql = new StringBuffer();
        ArrayList sqlList = new ArrayList();
        for (int i = 0; i < mcbi.getEntrys().size(); ++i) {
            String[] materialAttr;
            MaterialClassificationInfo mci;
            MaterialClassificationInfo mcti;
            ManchinePartsCostTestBillEntryInfo mcbei = mcbi.getEntrys().get(i);
            String mn = mcbei.getMaterialNumber() == null ? null : (mcbei.getMaterialNumber().getId() == null ? null : mcbei.getMaterialNumber().getId().toString());
            sql.setLength(0);
            sql.append(" /*dialect*/select Max(mpe.CFBidPrice) as CFBidPrice,mp.CFProjectID as CFProjectID");
            sql.append(" from CT_PCM_ManchinePCTBE mpe");
            sql.append(" inner join CT_PCM_ManchinePCTB mp on mp.fid=mpe.fparentid");
            if (mn != null) {
                sql.append(" where mpe.CFMaterialNumberID='" + mn + "'");
            } else {
                sql.append(" where mpe.CFMaterialNumberID is null");
            }
            sql.append(" and mp.FBizDate=(select max(mpn.fbizDate) from CT_PCM_ManchinePCTB mpn inner join CT_PCM_ManchinePCTBE mpen  on mpn.fid=mpen.fparentid ");
            if (mn != null) {
                sql.append(" where mpen.CFMaterialNumberID='" + mn + "')");
            } else {
                sql.append(" where mpen.CFMaterialNumberID is null)");
            }
            sql.append(" group by mp.CFProjectID");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                BigDecimal CFBidPrice = null;
                String projectid = null;
                while (rs.next()) {
                    CFBidPrice = rs.getBigDecimal("CFBidPrice");
                    projectid = rs.getString("CFProjectID");
                    ProjectInfo pi = ProjectFactory.getLocalInstance((Context)ctx).getProjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)projectid)));
                    mcbei.setLatestReferencePrice(CFBidPrice);
                    mcbei.setReferenceProject(pi);
                }
            }
            catch (Exception e) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0188", (Locale)ctx.getLocale())));
            }
            if (mcbei.getMaterialNumber() != null) {
                BOSUuid pkid = mcbei.getMaterialNumber().getId();
                MaterialInfo mi = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(pkid));
                mcbei.setMaterialName(mi.getName());
                mcbei.setModel(mcbei.getModel());
                BOSUuid pk = mi.getBaseUnit().getId();
                MeasureUnitInfo mui = null;
                mui = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                mcbei.setBaseUnit(mui.getName());
            }
            if ((mcti = mcbei.getMaterialAttrMT()) != null && (mci = MaterialClassificationFactory.getLocalInstance(ctx).getMaterialClassificationInfo((IObjectPK)new ObjectUuidPK(mcti.getId()))) != null) {
                BigDecimal materialUseRate = mci.getMaterialUseRate();
                mcbei.setMaterialUseRate(materialUseRate);
                BigDecimal weight = mcbei.getWeight();
                if (materialUseRate != null && weight != null) {
                    MathContext mc = new MathContext(2, RoundingMode.HALF_DOWN);
                    BigDecimal materialQuota = weight.divide(materialUseRate, mc);
                    mcbei.setMaterialQuota(materialQuota);
                    BigDecimal matrialPrice = mcbei.getMaterialPrice();
                    if (matrialPrice != null) {
                        BigDecimal materialCost = matrialPrice.multiply(materialQuota);
                        mcbei.setMaterialCost(materialCost);
                        BigDecimal indirectFeeRate1 = mcbei.getIndirectFeeRate1();
                        BigDecimal indirectFeeRate2 = mcbei.getIndirectFeeRate2();
                        if (materialCost != null && indirectFeeRate1 != null) {
                            BigDecimal targetPriceRate1 = materialCost.multiply(indirectFeeRate1.add(BigDecimal.ONE)).setScale(4, 2);
                            mcbei.setTargetPriceRate1(targetPriceRate1);
                        }
                        if (materialCost != null && indirectFeeRate2 != null) {
                            BigDecimal targetPriceRate2 = materialCost.multiply(indirectFeeRate2.add(BigDecimal.ONE)).setScale(4, 2);
                            mcbei.setTargetPriceRate2(targetPriceRate2);
                        }
                    }
                }
            }
            String[] stringArray = mcbei.getMaterialAttrMP() == null ? null : (materialAttr = mcbei.getMaterialAttrMP().getName() == null ? null : mcbei.getMaterialAttrMP().getName().split("-"));
            if (materialAttr != null && materialAttr.length >= 1) {
                MaterialDensityInfo mdi;
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)materialAttr[0], CompareType.EQUALS));
                ev.setFilter(filter);
                MaterialDensityCollection mdc = MaterialDensityFactory.getLocalInstance(ctx).getMaterialDensityCollection(ev);
                if (mdc != null && mdc.size() > 0 && (mdi = mdc.get(0)).getDensity() != null) {
                    mcbei.setMaterialDensity(mdi.getDensity());
                }
            }
            BigDecimal trackNumber = new BigDecimal(mcbei.getTrackNumber());
            BigDecimal bidPrice = mcbei.getBidPrice();
            if (trackNumber == null || bidPrice == null) continue;
            BigDecimal totalCost = trackNumber.multiply(bidPrice);
            mcbei.setTotalCost(totalCost);
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _calEveryClass(Context ctx) throws BOSException, EASBizException {
    }

    private void checkValue(Context ctx, ManchinePartsCostTestBillInfo mcbi) throws EASBizException {
        FilterInfo filter = new FilterInfo();
        if (mcbi.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)mcbi.getId(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)mcbi.getNumber(), CompareType.EQUALS));
        try {
            if (this._exists(ctx, filter)) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0189", (Locale)ctx.getLocale())));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (mcbi.getNumber() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0190", (Locale)ctx.getLocale())));
        }
        if (mcbi.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0191", (Locale)ctx.getLocale())));
        }
        if (mcbi.getEntrys() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0192", (Locale)ctx.getLocale())));
        }
        this.checkEntrys(mcbi.getEntrys(), ctx);
    }

    private void checkEntrys(ManchinePartsCostTestBillEntryCollection entrys, Context ctx) throws EASBizException {
        for (int i = 0; i < entrys.size(); ++i) {
            ManchinePartsCostTestBillEntryInfo abei = entrys.get(i);
            if (abei.getXuhao() == null) {
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0193", (Locale)ctx.getLocale()) + strInfo + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0194", (Locale)ctx.getLocale())));
            }
            if (abei.getMaterialName() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0195", (Locale)ctx.getLocale())));
            }
            if (abei.getBaseUnit() == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0196", (Locale)ctx.getLocale())));
            }
            for (int j = i + 1; j < entrys.size(); ++j) {
                if (entrys.get(j).getXuhao() == null || !entrys.get(j).getXuhao().equals(abei.getXuhao())) continue;
                String strInfo = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1});
                String strInfoj = ResourceBase.getString((String)this.RESURL, (String)"DLINE", (Locale)ctx.getLocale(), (Object[])new Object[]{j + 1});
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0193", (Locale)ctx.getLocale()) + strInfo + "\uff0c" + strInfoj + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.basework.EMMPCWorkResource", (String)"0EMMPCWORK-0197", (Locale)ctx.getLocale())));
            }
        }
    }
}

