/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.industry.emm.pcm.costcalculate.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.industry.emm.pcm.basedata.ProjectTypesInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.PurCostColletCollection;
import com.kingdee.eas.industry.emm.pcm.costcalculate.PurCostColletEntryCollection;
import com.kingdee.eas.industry.emm.pcm.costcalculate.PurCostColletEntryInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.PurCostColletFactory;
import com.kingdee.eas.industry.emm.pcm.costcalculate.PurCostColletInfo;
import com.kingdee.eas.industry.emm.pcm.costcalculate.app.AbstractPurCostColletControllerBean;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.NumericExceptionSubItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurCostColletControllerBean
extends AbstractPurCostColletControllerBean {
    private String RESURL = "com.kingdee.eas.industry.emm.lcm.LcmResourceTwo";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.app.PurCostColletControllerBean");

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PurCostColletInfo info = (PurCostColletInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0008", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0009", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditDate(new Date());
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PurCostColletInfo info = (PurCostColletInfo)model;
        if (info == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0008", (Locale)ctx.getLocale())));
        }
        if (info.getStatus() != BillBaseStatusEnum.AUDITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0010", (Locale)ctx.getLocale())));
        }
        info.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        info.setAuditor(null);
        info.setAuditDate(null);
        this._checkIsHaveDestBills(ctx, (CoreBaseInfo)info);
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    protected void _checkIsHaveDestBills(Context ctx, CoreBaseInfo billInfo) throws EASBizException, BOSException {
        String billIdString;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(billIdString = billInfo.getId().toString())) {
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT, new Object[]{billInfo.getString("number")});
        }
    }

    protected void check(Context ctx, PurCostColletInfo eti) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)eti.getNumber(), CompareType.EQUALS));
        if (eti.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)eti.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filter)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0011", (Locale)ctx.getLocale())));
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurCostColletInfo eti = (PurCostColletInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0012", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.SUBMITED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString()));
        }
        return super._submit(ctx, model);
    }

    private void checkHead(Context ctx, PurCostColletInfo info) throws EASBizException, BOSException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        if (info.getBizDate() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0019", (Locale)ctx.getLocale())));
        }
        if (info.getProject() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0020", (Locale)ctx.getLocale())));
        }
        if (info.getCompanyOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0021", (Locale)ctx.getLocale())));
        }
        if (info.getPeriod() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0022", (Locale)ctx.getLocale())));
        }
        if (info.getAdminOrgUnit() == null) {
            throw new EASBizException(new NumericExceptionSubItem("", info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0023", (Locale)ctx.getLocale())));
        }
        PeriodInfo periodInfo = ictrol.getCacheCurrentPeriod(99, info.getCompanyOrgUnit().getId().toString());
        if (periodInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0024", (Locale)ctx.getLocale())));
        }
        if (!periodInfo.getId().toString().equals(info.getPeriod().getId().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0025", (Locale)ctx.getLocale())));
        }
    }

    private void checkEntry(Context ctx, PurCostColletInfo info) throws EASBizException {
        PurCostColletEntryCollection entryCollection = info.getEntrys();
        for (int i = 0; i < entryCollection.size(); ++i) {
            PurCostColletEntryInfo entryInfo = entryCollection.get(i);
            StringBuffer tmpStr = new StringBuffer();
            if (entryInfo.getDutyCenter() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0026", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getClassifi() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0027", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getMaterial() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0028", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getQty() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0029", (Locale)ctx.getLocale()));
            }
            if (entryInfo.getPrice() == null) {
                tmpStr.append(EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0030", (Locale)ctx.getLocale()));
            }
            if (tmpStr.length() > 0) {
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"FLDJH", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}) + "," + tmpStr.toString()));
            }
            entryInfo.setActualCost(entryInfo.getQty().multiply(entryInfo.getPrice()));
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurCostColletInfo info = this.getPurCostColletInfo(ctx, pk);
        if (info.getStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0015", (Locale)ctx.getLocale()) + info.getNumber() + EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0016", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurCostColletInfo eti = (PurCostColletInfo)model;
        this.checkHead(ctx, eti);
        this.check(ctx, eti);
        this.checkEntry(ctx, eti);
        if (eti.getStatus() != BillBaseStatusEnum.TEMPORARILYSAVED && eti.getStatus() != BillBaseStatusEnum.ADD) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0017", (Locale)ctx.getLocale())));
        }
        eti.setStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (eti.getNumber() == null || eti.getNumber().toString().equals("")) {
            eti.setNumber(this.getNewNumber(ctx, (IObjectValue)eti, ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString()));
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected Map _importIn(Context ctx, Map map) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        ProjectInfo proInfo = (ProjectInfo)map.get("project");
        String createTab = "create table his_pcm_purin\n(\n  fid varchar(44),\n  fcompanyorg VARCHAR(44),\n  fperiod VARCHAR(44),\n  fdutycenter VARCHAR(44),\n  fproject VARCHAR(44),\n  fprojectstype VARCHAR(44),\n  ftracknumberid VARCHAR(44),\n  fclasscodeid VARCHAR(44),\n  fclasscodename VARCHAR(100),\n  fmaterialid VARCHAR(44),\n  fmaterialName VARCHAR(100),\n  fmodel VARCHAR(100),\n  fpurorderid VARCHAR(44),\n  fpurorderentryid VARCHAR(44),\n  fqty NUMERIC(21,8),\n  fprice NUMERIC(21,8),\n  factualCost NUMERIC(21,8),\n  fpriceType int\n  )";
        String reqTempTable = "";
        String createPricingTable = "create table his_pcm_purin\n(\n  fid varchar(44),\n  fpurprice NUMERIC(21,8)  )";
        String purPricingTable = "";
        String createOtherBillTable = "create table his_pcm_purin\n(\n  fsourcebillentryid varchar(44),\n  fprice NUMERIC(21,8)  )";
        String purOtherBillTable = "";
        try {
            reqTempTable = TempTablePool.getInstance((Context)ctx).createTempTable(createTab);
            purPricingTable = TempTablePool.getInstance((Context)ctx).createTempTable(createPricingTable);
            purOtherBillTable = TempTablePool.getInstance((Context)ctx).createTempTable(createOtherBillTable);
        }
        catch (Exception e) {
            throw new BOSException(e.getCause());
        }
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = ictrol.getCacheCurrentPeriod(99, companyOrgUnitInfo.getId().toString());
        if (periodInfo == null) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0000", (Locale)ctx.getLocale())));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        String startDate = df.format(periodInfo.getBeginDate());
        String endDate = df1.format(periodInfo.getEndDate());
        String insertPurInSql = "/*dialect*/ insert into " + reqTempTable + "(fid,fcompanyorg,fperiod,fdutycenter,fproject,fprojectstype,ftracknumberid,fclasscodeid,\n      fclasscodename,fmaterialid,fmaterialName,fmodel,fqty,fpurorderid,fpurorderentryid)\nselect bentry.fid,bentry.fcompanyorgunitid fcompanyorg,'" + periodInfo.getId() + "' fperiod,\n       bentry.fpurchaseorgunitid fdutycenter,pro.fid fproject,pro.cfprojecttypesid fprojectstype,bentry.ftracknumberid ftracknumberid,\n       cla.cfclasscodeid fclasscodeid,ccode.fname_l2 fclasscodename,bentry.fmaterialid fmaterialid,mat.fname_l2 fmaterialName,mat.fmodel fmodel,bentry.fqty fqty,\n       bentry.fpurorderid,bentry.fpurorderentryid\nfrom T_IM_PurInWarehsBill b\ninner join T_IM_PurInWarehsEntry bentry on b.fid = bentry.fparentid\ninner join t_mm_project pro on pro.fid = bentry.fprojectid\ninner join t_bd_material mat on mat.fid = bentry.fmaterialid\nleft join CT_PCM_ClassCMR cla\non cla.cfprojecttypeid = pro.cfprojecttypesid and bentry.fmaterialid = cla.cfmaterialid\nand cla.cfprojecttypeid is not null and cla.cfmaterialid is not null and cla.cfclasscodeid is not null\nleft join ct_pcm_classificationcode ccode on ccode.fid = cla.cfclasscodeid\nwhere pro.fid = '" + proInfo.getId() + "' and\n      bentry.fcompanyorgunitid = '" + companyOrgUnitInfo.getId() + "' and\n      b.fbasestatus > 3 and\n      bentry.fpurchaseorgunitid is not null and\n      b.fbizdate > to_date('" + startDate + "','yyyy-MM-dd HH24:mi:ss') and\n      b.fbizdate < to_date('" + endDate + "','yyyy-MM-dd HH24:mi:ss')";
        DBUtil.execute((Context)ctx, (String)insertPurInSql);
        String insertOrderSql = "/*dialect*/ insert into " + purPricingTable + "(fid,fpurprice)\nselect pentry.fid,pricing.fpurprice from t_sm_purorder p\ninner join t_sm_purorderentry pentry on p.fid = pentry.fparentid\ninner join\n(\nselect ppentry.fid fentryid,ppentry.fpurprice from t_sm_pricingpolicybill pp\ninner join t_sm_pricingpolicybillentry ppentry on pp.fid = ppentry.fparentid\nwhere pp.fbasestatus > 3\n) pricing\non pentry.FPricingPolicyEntryIds = pricing.fentryid\nwhere p.fbasestatus > 3 and p.fcompanyorgunitid = '" + companyOrgUnitInfo.getId() + "'";
        DBUtil.execute((Context)ctx, (String)insertOrderSql);
        String insertOtherSql = "/*dialect*/ insert into " + purOtherBillTable + "(fsourcebillentryid,fprice)\nselect ooe.fsourcebillentryid fsourcebillentryid,min(ooe.fprice) fprice from t_ap_otherbill oo\ninner join t_ap_otherbillentry ooe on oo.fid = ooe.fparentid\nwhere oo.fbillstatus = 3 and ooe.fprice is not null \ngroup by ooe.fsourcebillentryid";
        DBUtil.execute((Context)ctx, (String)insertOtherSql);
        PurCostColletCollection billColInfo = new PurCostColletCollection();
        try {
            billColInfo = PurCostColletFactory.getLocalInstance(ctx).getPurCostColletCollection("select id where companyOrgUnit.number='" + companyOrgUnitInfo.getNumber() + "' and period.number = '" + periodInfo.getNumber() + "' and project.number = '" + proInfo.getNumber() + "'");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (billColInfo.size() > 1) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0031", (Locale)ctx.getLocale())));
        }
        String parentID = "";
        PurCostColletInfo billInfo = new PurCostColletInfo();
        String YR = EASResource.getString((String)this.RESURL, (String)"YR", (Locale)ctx.getLocale());
        if (billColInfo.size() == 1) {
            billInfo = billColInfo.get(0);
            parentID = billInfo.getId().toString();
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append("delete from CT_PCM_PurCostColletEntry entrys\n");
            deleteSql.append("where entrys.FParentID='" + parentID + "' and entrys.CFInType='YR' \n");
            DBUtil.execute((Context)ctx, (String)deleteSql.toString());
        } else if (billColInfo.size() == 0) {
            billInfo.setAdminOrgUnit(ContextUtil.getCurrentAdminUnit((Context)ctx));
            billInfo.setCompanyOrgUnit(companyOrgUnitInfo);
            billInfo.setPeriod(periodInfo);
            billInfo.setBizDate(new Date());
            billInfo.setProject(proInfo);
            billInfo.setProjectTypes((ProjectTypesInfo)proInfo.get("projectTypes"));
            billInfo.setStatus(BillBaseStatusEnum.AUDITED);
            if (ContextUtil.getCurrentAdminUnit((Context)ctx) == null) {
                throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.industry.emm.pcm.costcalculate.EMMPCPcmCostcalculate", (String)"0EMMCOST-0032", (Locale)ctx.getLocale())));
            }
            billInfo.setNumber(this.getNewNumber(ctx, (IObjectValue)billInfo, ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString()));
            parentID = super._submit(ctx, (IObjectValue)billInfo).toString();
        }
        StringBuffer proSql = new StringBuffer();
        proSql.append("/*dialect*/ insert into CT_PCM_PurCostColletEntry \n");
        proSql.append("(fid,CFDutyCenterID,CFTrackNumberID,CFClassifiID,CFClassifiName,\n");
        proSql.append("CFMaterialID,CFMaterialName,CFMaterialModel,CFQty,CFPrice,CFActualCost,CFPriceType,CFInType,FParentID)\n");
        proSql.append("select newbosid('0A9F57A7'),purin.fdutycenter,purin.ftracknumberid,purin.fclasscodeid,purin.fclasscodename,\n");
        proSql.append("       purin.fmaterialid,purin.fmaterialName,purin.fmodel,purin.fqty,tpor.fpurprice,purin.fqty*tpor.fpurprice CFActualCost,\n");
        proSql.append("       1 FPriceType,'YR','" + parentID + "'\n");
        proSql.append("from " + reqTempTable + " purin\n");
        proSql.append("inner join " + purPricingTable + " tpor on purin.fpurorderentryid = tpor.fid\n");
        proSql.append("where tpor.fpurprice is not null and exists\n");
        proSql.append("(\n");
        proSql.append("select 1 from " + purPricingTable + " tpor\n");
        proSql.append("where tpor.fid = purin.fpurorderentryid\n");
        proSql.append(")");
        DBUtil.execute((Context)ctx, (String)proSql.toString());
        StringBuffer proSqlOne = new StringBuffer();
        proSqlOne.append("/*dialect*/ insert into CT_PCM_PurCostColletEntry \n");
        proSqlOne.append("(fid,CFDutyCenterID,CFTrackNumberID,CFClassifiID,CFClassifiName,\n");
        proSqlOne.append("CFMaterialID,CFMaterialName,CFMaterialModel,CFQty,CFPrice,CFActualCost,CFPriceType,CFInType,FParentID)\n");
        proSqlOne.append("select newbosid('0A9F57A7'),purin.fdutycenter,purin.ftracknumberid,purin.fclasscodeid,purin.fclasscodename,\n");
        proSqlOne.append("       purin.fmaterialid,purin.fmaterialName,purin.fmodel,purin.fqty,oentry.fprice,purin.fqty*oentry.fprice CFActualCost,\n");
        proSqlOne.append("       2 FPriceType,'YR','" + parentID + "'\n");
        proSqlOne.append("from " + reqTempTable + " purin\n");
        proSqlOne.append("inner join " + purOtherBillTable + " oentry on oentry.fsourcebillentryid = purin.fid\n");
        proSqlOne.append("where not exists\n");
        proSqlOne.append("(\n");
        proSqlOne.append("select 1 from " + purPricingTable + " tpor\n");
        proSqlOne.append("where tpor.fid = purin.fpurorderentryid\n");
        proSqlOne.append(")\n");
        proSqlOne.append("and exists\n");
        proSqlOne.append("(\n");
        proSqlOne.append(" select 1 from " + purOtherBillTable + " oentry\n");
        proSqlOne.append(" where oentry.fsourcebillentryid = purin.fid\n");
        proSqlOne.append(")");
        DBUtil.execute((Context)ctx, (String)proSqlOne.toString());
        StringBuffer proSqlTwo = new StringBuffer();
        proSqlTwo.append("/*dialect*/ insert into CT_PCM_PurCostColletEntry \n");
        proSqlTwo.append("(fid,CFDutyCenterID,CFTrackNumberID,CFClassifiID,CFClassifiName,\n");
        proSqlTwo.append("CFMaterialID,CFMaterialName,CFMaterialModel,CFQty,CFPrice,CFActualCost,CFPriceType,CFInType,FParentID)\n");
        proSqlTwo.append("select newbosid('0A9F57A7'),purin.fdutycenter,purin.ftracknumberid,purin.fclasscodeid,purin.fclasscodename,\n");
        proSqlTwo.append("       purin.fmaterialid,purin.fmaterialName,purin.fmodel,purin.fqty,mpur.fprice,purin.fqty*mpur.fprice CFActualCost,\n");
        proSqlTwo.append("       3 FPriceType,'YR','" + parentID + "'\n");
        proSqlTwo.append("from " + reqTempTable + " purin\n");
        proSqlTwo.append("inner join t_bd_material mat on purin.fmaterialid = mat.fid\n");
        proSqlTwo.append("inner join t_bd_materialpurchasing mpur on mat.fid = mpur.fmaterialid\n");
        proSqlTwo.append("where mpur.fprice is not null and not exists\n");
        proSqlTwo.append("(\n");
        proSqlTwo.append("select 1 from " + purPricingTable + " tpor\n");
        proSqlTwo.append("where tpor.fid = purin.fpurorderentryid\n");
        proSqlTwo.append(")\n");
        proSqlTwo.append("and not exists\n");
        proSqlTwo.append("(\n");
        proSqlTwo.append(" select 1 from " + purOtherBillTable + " oentry\n");
        proSqlTwo.append(" where oentry.fsourcebillentryid = purin.fid\n");
        proSqlTwo.append(")\n");
        proSqlTwo.append("and\n");
        proSqlTwo.append("mpur.forgunit in (select fid from t_org_purchase where fnumber ='1.70.00')");
        DBUtil.execute((Context)ctx, (String)proSqlTwo.toString());
        TempTablePool.getInstance((Context)ctx).releaseTable(reqTempTable);
        TempTablePool.getInstance((Context)ctx).releaseTable(purPricingTable);
        return super._importIn(ctx, map);
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        String number = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
        aSCMBillBaseInfo.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(aSCMBillBaseInfo.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
            String newNumber = "";
            newNumber = iCodingRuleManager.getNumber((IObjectValue)aSCMBillBaseInfo, strCompanyID, "");
            if (newNumber.equals(aSCMBillBaseInfo.getNumber())) {
                throw new SCMBillException(SCMBillException.NUMBERRULEERROR);
            }
            number = newNumber;
            aSCMBillBaseInfo.setNumber(newNumber);
            if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)aSCMBillBaseInfo)) {
                return this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID);
            }
        }
        return number;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo aSCMBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        filterItem = aSCMBillBaseInfo.getNumber() == null ? new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber(), CompareType.EQUALS) : new FilterItemInfo("number", (Object)aSCMBillBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (aSCMBillBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)aSCMBillBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }
}

